/* lua/except.i: Custom Lua exception handling.
 * Warning: This file is generated by /data/home/olly/tmp/xapian-svn-snapshot/tags/1.2.14/xapian/xapian-bindings/lua/generate-lua-exceptions
 * - do not modify directly!
 *
 * Copyright 2007 Lemur Consulting Ltd
 * Copyright 2007,2011 Olly Betts
 * Copyright 2011 Xiaona Han
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

%include "xapian/error.h"

%{
namespace Xapian {
void handle_exception(lua_State* L) {
    try {
	throw;
    } catch (const Xapian::RangeError &e) {
	SWIG_NewPointerObj(L, (void *)new RangeError(e), SWIGTYPE_p_Xapian__RangeError, 1);
    } catch (const Xapian::SerialisationError &e) {
	SWIG_NewPointerObj(L, (void *)new SerialisationError(e), SWIGTYPE_p_Xapian__SerialisationError, 1);
    } catch (const Xapian::QueryParserError &e) {
	SWIG_NewPointerObj(L, (void *)new QueryParserError(e), SWIGTYPE_p_Xapian__QueryParserError, 1);
    } catch (const Xapian::NetworkTimeoutError &e) {
	SWIG_NewPointerObj(L, (void *)new NetworkTimeoutError(e), SWIGTYPE_p_Xapian__NetworkTimeoutError, 1);
    } catch (const Xapian::NetworkError &e) {
	SWIG_NewPointerObj(L, (void *)new NetworkError(e), SWIGTYPE_p_Xapian__NetworkError, 1);
    } catch (const Xapian::InternalError &e) {
	SWIG_NewPointerObj(L, (void *)new InternalError(e), SWIGTYPE_p_Xapian__InternalError, 1);
    } catch (const Xapian::FeatureUnavailableError &e) {
	SWIG_NewPointerObj(L, (void *)new FeatureUnavailableError(e), SWIGTYPE_p_Xapian__FeatureUnavailableError, 1);
    } catch (const Xapian::DocNotFoundError &e) {
	SWIG_NewPointerObj(L, (void *)new DocNotFoundError(e), SWIGTYPE_p_Xapian__DocNotFoundError, 1);
    } catch (const Xapian::DatabaseVersionError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseVersionError(e), SWIGTYPE_p_Xapian__DatabaseVersionError, 1);
    } catch (const Xapian::DatabaseOpeningError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseOpeningError(e), SWIGTYPE_p_Xapian__DatabaseOpeningError, 1);
    } catch (const Xapian::DatabaseModifiedError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseModifiedError(e), SWIGTYPE_p_Xapian__DatabaseModifiedError, 1);
    } catch (const Xapian::DatabaseLockError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseLockError(e), SWIGTYPE_p_Xapian__DatabaseLockError, 1);
    } catch (const Xapian::DatabaseCreateError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseCreateError(e), SWIGTYPE_p_Xapian__DatabaseCreateError, 1);
    } catch (const Xapian::DatabaseCorruptError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseCorruptError(e), SWIGTYPE_p_Xapian__DatabaseCorruptError, 1);
    } catch (const Xapian::DatabaseError &e) {
	SWIG_NewPointerObj(L, (void *)new DatabaseError(e), SWIGTYPE_p_Xapian__DatabaseError, 1);
    } catch (const Xapian::UnimplementedError &e) {
	SWIG_NewPointerObj(L, (void *)new UnimplementedError(e), SWIGTYPE_p_Xapian__UnimplementedError, 1);
    } catch (const Xapian::InvalidOperationError &e) {
	SWIG_NewPointerObj(L, (void *)new InvalidOperationError(e), SWIGTYPE_p_Xapian__InvalidOperationError, 1);
    } catch (const Xapian::InvalidArgumentError &e) {
	SWIG_NewPointerObj(L, (void *)new InvalidArgumentError(e), SWIGTYPE_p_Xapian__InvalidArgumentError, 1);
    } catch (const Xapian::AssertionError &e) {
	SWIG_NewPointerObj(L, (void *)new AssertionError(e), SWIGTYPE_p_Xapian__AssertionError, 1);
    } catch (const Xapian::RuntimeError &e) {
	SWIG_NewPointerObj(L, (void *)new RuntimeError(e), SWIGTYPE_p_Xapian__RuntimeError, 1);
    } catch (const Xapian::LogicError &e) {
	SWIG_NewPointerObj(L, (void *)new LogicError(e), SWIGTYPE_p_Xapian__LogicError, 1);
    } catch (const std::exception& e) {
	lua_pushfstring(L, "std::exception: %s", e.what());
    } catch (...) {
	lua_pushstring(L, "Unknown exception");
    }
}
}
%}

%exception {
    try {
	$action
    } catch (...) {
	Xapian::handle_exception(L);
	SWIG_fail;
    }
}
