

/*
 *      Copyright (C) 2005-2012 Team XBMC
 *      http://www.xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmc" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/Player.h"
#include "interfaces/legacy/RenderCapture.h"
#include "interfaces/legacy/Keyboard.h"
#include "interfaces/legacy/ModuleXbmc.h"
#include "interfaces/legacy/Monitor.h"

using namespace XBMCAddon;
using namespace xbmc;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif


namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Player
  PyTypeObject PyXBMCAddon_xbmc_Player_Type;
  TypeInfo TyXBMCAddon_xbmc_Player_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::RenderCapture
  PyTypeObject PyXBMCAddon_xbmc_RenderCapture_Type;
  TypeInfo TyXBMCAddon_xbmc_RenderCapture_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagMusic
  PyTypeObject PyXBMCAddon_xbmc_InfoTagMusic_Type;
  TypeInfo TyXBMCAddon_xbmc_InfoTagMusic_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::InfoTagVideo
  PyTypeObject PyXBMCAddon_xbmc_InfoTagVideo_Type;
  TypeInfo TyXBMCAddon_xbmc_InfoTagVideo_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Keyboard
  PyTypeObject PyXBMCAddon_xbmc_Keyboard_Type;
  TypeInfo TyXBMCAddon_xbmc_Keyboard_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::PlayList
  PyTypeObject PyXBMCAddon_xbmc_PlayList_Type;
  TypeInfo TyXBMCAddon_xbmc_PlayList_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmc::Monitor
  PyTypeObject PyXBMCAddon_xbmc_Monitor_Type;
  TypeInfo TyXBMCAddon_xbmc_Monitor_Type;
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmc::PlayListItem from another module 
  extern PyTypeObject PyXBMCAddon_xbmc_PlayListItem_Type;
  extern TypeInfo TyXBMCAddon_xbmc_PlayListItem_Type;
  //=========================================================================

  //=========================================================================
  // These variables define the type XBMCAddon::xbmcgui::ListItem from another module 
  extern PyTypeObject PyXBMCAddon_xbmcgui_ListItem_Type;
  extern TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type;
  //=========================================================================



  //=========================================================================
  // This class is the Director for XBMCAddon::xbmc::Player. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmc_Player_Director : public Director, public XBMCAddon::xbmc::Player
  {
    public:

      inline XBMCAddon_xbmc_Player_Director(int  playerCore ) : XBMCAddon::xbmc::Player( playerCore ) { } 

      virtual void  onPlayBackStarted(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackStarted",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackEnded(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackEnded",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackStopped(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackStopped",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackPaused(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackPaused",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackResumed(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackResumed",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onQueueNextItem(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onQueueNextItem",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSpeedChanged(  int  speed  )
      { 
        PyObject* pyspeed = NULL;
        pyspeed = Py_BuildValue((char*)"i", speed);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSpeedChanged",(char*)"(O)", pyspeed );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSeek(  int  time,  int  seekOffset  )
      { 
        PyObject* pytime = NULL;
        pytime = Py_BuildValue((char*)"i", time);
        PyObject* pyseekOffset = NULL;
        pyseekOffset = Py_BuildValue((char*)"i", seekOffset);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSeek",(char*)"(OO)", pytime , pyseekOffset );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onPlayBackSeekChapter(  int  chapter  )
      { 
        PyObject* pychapter = NULL;
        pychapter = Py_BuildValue((char*)"i", chapter);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onPlayBackSeekChapter",(char*)"(O)", pychapter );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmc::Monitor. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmc_Monitor_Director : public Director, public XBMCAddon::xbmc::Monitor
  {
    public:

      inline XBMCAddon_xbmc_Monitor_Director() : XBMCAddon::xbmc::Monitor() { } 

      virtual void  onSettingsChanged(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onSettingsChanged",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScreensaverActivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScreensaverActivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onScreensaverDeactivated(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onScreensaverDeactivated",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDatabaseUpdated(  String const  database  )
      { 
        PyObject* pydatabase = NULL;
        
pydatabase = PyString_FromString(database.c_str());

        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDatabaseUpdated",(char*)"(O)", pydatabase );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onAbortRequested(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAbortRequested",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  PyDoc_STRVAR(log__doc__,
               "log(msg[, level])--Write a string to XBMC's log file and the debug window. msg : string - text to output. level : [opt] integer - log level to ouput at. (default=LOGNOTICE)\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"Text is written to the log for the following conditions. XBMC loglevel == -1 (NONE, nothing at all is logged) XBMC loglevel == 0 (NORMAL, shows LOGNOTICE, LOGERROR, LOGSEVERE and LOGFATAL)\\ XBMC loglevel == 1 (DEBUG, shows all) See pydocs for valid values for level.\n"
"\n"
"example:\n"
"    - xbmc.output(msg='This is a test string.', level=xbmc.LOGDEBUG));\n");

  static PyObject* xbmc_log (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "msg",
          "level",
          NULL};
         
    char * msg ;         
    int  level  = lLOGNOTICE;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|i",
       (char**)keywords,
         &msg,
         &level
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::log(  msg,  level  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::log\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::log\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(shutdown__doc__,
               "Shutdown()--Shutdown the xbox.\n"
"\n"
"example:\n"
"    - xbmc.shutdown()\n");

  static PyObject* xbmc_shutdown (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::shutdown(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::shutdown\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::shutdown\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(restart__doc__,
               "restart()--Restart the xbox. example:\n"
"    - xbmc.restart()\n");

  static PyObject* xbmc_restart (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::restart(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::restart\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::restart\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(executescript__doc__,
               "executescript(script)--Execute a python script.\n"
"\n"
"script : string - script filename to execute.\n"
"\n"
"example:\n"
"    - xbmc.executescript('special://home/scripts/update.py')\n");

  static PyObject* xbmc_executescript (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "script",
          NULL};
         
    char * script ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &script
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::executescript(  script  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executescript\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executescript\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(executebuiltin__doc__,
               "executebuiltin(function)--Execute a built in XBMC function.\n"
"\n"
"function : string - builtin function to execute.\n"
"\n"
"List of functions -http://wiki.xbmc.org/?title=List_of_Built_In_Functions \n"
"\n"
"example:\n"
"    - xbmc.executebuiltin('XBMC.RunXBE(c:\\\\avalaunch.xbe)')\n");

  static PyObject* xbmc_executebuiltin (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "function",
          "wait",
          NULL};
         
    char * function ;         
    bool  wait  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &function,
         &wait
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::executebuiltin(  function,  wait  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executebuiltin\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executebuiltin\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(executehttpapi__doc__,
               "executehttpapi(httpcommand)--Not implemented anymore.\n");

  static PyObject* xbmc_executehttpapi (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "httpcommand",
          NULL};
         
    char * httpcommand ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &httpcommand
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::executehttpapi(  httpcommand  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executehttpapi\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executehttpapi\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(executeJSONRPC__doc__,
               "executeJSONRPC(jsonrpccommand)--Execute an JSONRPC command.\n"
"\n"
"jsonrpccommand : string - jsonrpc command to execute.\n"
"\n"
"List of commands -\n"
"\n"
"example:\n"
"    - response = xbmc.executeJSONRPC('{ \"jsonrpc\": \"2.0\", \"method\": \"JSONRPC.Introspect\", \"id\": 1 }')\n");

  static PyObject* xbmc_executeJSONRPC (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "jsonrpccommand",
          NULL};
         
    char * jsonrpccommand ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &jsonrpccommand
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::executeJSONRPC(  jsonrpccommand  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::executeJSONRPC\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::executeJSONRPC\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(sleep__doc__,
               "sleep(time)--Sleeps for 'time' msec.\n"
"\n"
"time : integer - number of msec to sleep.\n"
"\n"
"*Note, This is useful if you have for example aPlayer class that is waiting for onPlayBackEnded() calls.\n"
"\n"
"Throws: PyExc_TypeError, if time is not an integer.\n"
"\n"
"example:\n"
"    - xbmc.sleep(2000) # sleeps for 2 seconds\n");

  static PyObject* xbmc_sleep (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "timemillis",
          NULL};
         
    long  timemillis ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &timemillis
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::sleep(  timemillis  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::sleep\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::sleep\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getLocalizedString__doc__,
               "getLocalizedString(id)--Returns a localized 'unicode string'.\n"
"\n"
"id : integer - id# for string you want to localize.\n"
"\n"
"*Note, See strings.xml in \\language\\{yourlanguage}\\ for which id you need for a string.\n"
"\n"
"example:\n"
"    - locstr = xbmc.getLocalizedString(6)\n");

  static PyObject* xbmc_getLocalizedString (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    int  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getLocalizedString(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getLocalizedString\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getLocalizedString\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");


    return result; 
  } 

  PyDoc_STRVAR(getSkinDir__doc__,
               "getSkinDir()--Returns the active skin directory as a string.\n"
"\n"
"*Note, This is not the full path like 'special://home/addons/MediaCenter', but only 'MediaCenter'.\n"
"\n"
"example:\n"
"    - skindir = xbmc.getSkinDir()\n");

  static PyObject* xbmc_getSkinDir (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getSkinDir(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getSkinDir\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getSkinDir\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getLanguage__doc__,
               "getLanguage()--Returns the active language as a string.\n"
"\n"
"example:\n"
"    - language = xbmc.getLanguage()\n");

  static PyObject* xbmc_getLanguage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getLanguage(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getLanguage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getLanguage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getIPAddress__doc__,
               "getIPAddress()--Returns the current ip address as a string.\n"
"\n"
"example:\n"
"    - ip = xbmc.getIPAddress()\n");

  static PyObject* xbmc_getIPAddress (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getIPAddress(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getIPAddress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getIPAddress\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getDVDState__doc__,
               "getDVDState()--Returns the dvd state as an integer.\n"
"\n"
"return values are: 1 : xbmc.DRIVE_NOT_READY 16 : xbmc.TRAY_OPEN 64 : xbmc.TRAY_CLOSED_NO_MEDIA 96 : xbmc.TRAY_CLOSED_MEDIA_PRESENT\n"
"\n"
"example:\n"
"    - dvdstate = xbmc.getDVDState()\n");

  static PyObject* xbmc_getDVDState (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmc::getDVDState(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getDVDState\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getDVDState\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getFreeMem__doc__,
               "getFreeMem()--Returns the amount of free memory in MB as an integer.\n"
"\n"
"example:\n"
"    - freemem = xbmc.getFreeMem()\n");

  static PyObject* xbmc_getFreeMem (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmc::getFreeMem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getFreeMem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getFreeMem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getInfoLabel__doc__,
               "getInfoLabel(infotag)--Returns an InfoLabel as a string.\n"
"\n"
"infotag : string - infoTag for value you want returned.\n"
"\n"
"List of InfoTags -http://wiki.xbmc.org/?title=InfoLabels \n"
"\n"
"example:\n"
"    - label = xbmc.getInfoLabel('Weather.Conditions')\n");

  static PyObject* xbmc_getInfoLabel (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "cLine",
          NULL};
         
    char * cLine ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &cLine
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getInfoLabel(  cLine  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getInfoImage__doc__,
               "getInfoImage(infotag)--Returns a filename including path to the InfoImage's thumbnail as a string.\n"
"\n"
"infotag : string - infotag for value you want returned.\n"
"\n"
"List of InfoTags -http://wiki.xbmc.org/?title=InfoLabels \n"
"\n"
"example:\n"
"    - filename = xbmc.getInfoImage('Weather.Conditions')\n");

  static PyObject* xbmc_getInfoImage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "infotag",
          NULL};
         
    char * infotag ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &infotag
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getInfoImage(  infotag  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getInfoImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(playSFX__doc__,
               "playSFX(filename)--Plays a wav file by filename\n"
"\n"
"filename : string - filename of the wav file to play.\n"
"\n"
"example:\n"
"    - xbmc.playSFX('special://xbmc/scripts/dingdong.wav')\n");

  static PyObject* xbmc_playSFX (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::playSFX(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::playSFX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::playSFX\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(enableNavSounds__doc__,
               "enableNavSounds(yesNo)--Enables/Disables nav sounds\n"
"\n"
"yesNo : integer - enable (True) or disable (False) nav sounds\n"
"\n"
"example:\n"
"    - xbmc.enableNavSounds(True)\n");

  static PyObject* xbmc_enableNavSounds (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "yesNo",
          NULL};
         
    bool  yesNo ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &yesNo
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::enableNavSounds(  yesNo  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::enableNavSounds\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::enableNavSounds\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getCondVisibility__doc__,
               "getCondVisibility(condition)--Returns True (1) or False (0) as a bool.\n"
"\n"
"condition : string - condition to check.\n"
"\n"
"List of Conditions -http://wiki.xbmc.org/?title=List_of_Boolean_Conditions \n"
"\n"
"*Note, You can combine two (or more) of the above settings by using \"+\" as an AND operator, \"|\" as an OR operator, \"!\" as a NOT operator, and \"[\" and \"]\" to bracket expressions.\n"
"\n"
"example:\n"
"    - visible = xbmc.getCondVisibility('[Control.IsVisible(41) + !Control.IsVisible(12)]')\n");

  static PyObject* xbmc_getCondVisibility (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "condition",
          NULL};
         
    char * condition ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &condition
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::getCondVisibility(  condition  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCondVisibility\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCondVisibility\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getGlobalIdleTime__doc__,
               "getGlobalIdleTime()--Returns the elapsed idle time in seconds as an integer.\n"
"\n"
"example:\n"
"    - t = xbmc.getGlobalIdleTime()\n");

  static PyObject* xbmc_getGlobalIdleTime (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (int )XBMCAddon::xbmc::getGlobalIdleTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getGlobalIdleTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getGlobalIdleTime\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getCacheThumbName__doc__,
               "getCacheThumbName(path)--Returns a thumb cache filename.\n"
"\n"
"path : string or unicode - path to file\n"
"\n"
"example:\n"
"    - thumb = xbmc.getCacheThumbName('f:\\\\videos\\\\movie.avi')\n");

  static PyObject* xbmc_getCacheThumbName (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    String  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::getCacheThumbName"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getCacheThumbName(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCacheThumbName\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCacheThumbName\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(makeLegalFilename__doc__,
               "makeLegalFilename(filename[, fatX])--Returns a legal filename or path as a string.\n"
"\n"
"filename : string or unicode - filename/path to make legal fatX : [opt] bool - True=Xbox file system(Default)\n"
"\n"
"*Note, If fatX is true you should pass a full path. If fatX is false only pass the basename of the path.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - filename = xbmc.makeLegalFilename('F:\\Trailers\\Ice Age: The Meltdown.avi')\n");

  static PyObject* xbmc_makeLegalFilename (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "filename",
          "fatX",
          NULL};
         
    String  filename ;
    PyObject* pyfilename = NULL;         
    bool  fatX  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyfilename,
         &fatX
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {
      if (pyfilename) PyXBMCGetUnicodeString(filename,pyfilename,false,"filename","XBMCAddon::xbmc::makeLegalFilename"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::makeLegalFilename(  filename,  fatX  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::makeLegalFilename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::makeLegalFilename\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(translatePath__doc__,
               "translatePath(path)--Returns the translated path.\n"
"\n"
"path : string or unicode - Path to format\n"
"\n"
"*Note, Only useful if you are coding for both Linux and Windows/Xbox. e.g. Converts 'special://masterprofile/script_data' -> '/home/user/XBMC/UserData/script_data' on Linux. Would return 'special://masterprofile/script_data' on the Xbox.\n"
"\n"
"example:\n"
"    - fpath = xbmc.translatePath('special://masterprofile/script_data')\n");

  static PyObject* xbmc_translatePath (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    String  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::translatePath"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::translatePath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::translatePath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::translatePath\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getCleanMovieTitle__doc__,
               "getCleanMovieTitle(path[, usefoldername])--Returns a clean movie title and year string if available.\n"
"\n"
"path : string or unicode - String to clean bool : [opt] bool - use folder names (defaults to false)\n"
"\n"
"example:\n"
"    - title, year = xbmc.getCleanMovieTitle('/path/to/moviefolder/test.avi', True)\n");

  static PyObject* xbmc_getCleanMovieTitle (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "path",
          "usefoldername",
          NULL};
         
    String  path ;
    PyObject* pypath = NULL;         
    bool  usefoldername  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pypath,
         &usefoldername
       ))
    {
      return NULL;
    }

    Tuple< String ,String  >  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::getCleanMovieTitle"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (Tuple< String ,String  > )XBMCAddon::xbmc::getCleanMovieTitle(  path,  usefoldername  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getCleanMovieTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getCleanMovieTitle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    int vecSize = apiResult.GetNumValuesSet();
    result = PyTuple_New(vecSize);
    {
      PyObject* pyentry1; 

      if (vecSize > 0)
      {
        String & entry1 = apiResult.first();
        {
          
pyentry1 = PyString_FromString(entry1.c_str());

        }
        PyTuple_SetItem(result, 0, pyentry1);
      }


      if (vecSize > 1)
      {
        String & entry1 = apiResult.second();
        {
          
pyentry1 = PyString_FromString(entry1.c_str());

        }
        PyTuple_SetItem(result, 1, pyentry1);
      }

    }


    return result; 
  } 

  PyDoc_STRVAR(validatePath__doc__,
               "validatePath(path)--Returns the validated path.\n"
"\n"
"path : string or unicode - Path to format\n"
"\n"
"*Note, Only useful if you are coding for both Linux and Windows/Xbox for fixing slash problems. e.g. Corrects 'Z://something' -> 'Z:\\something'\n"
"\n"
"example:\n"
"    - fpath = xbmc.validatePath(somepath)\n");

  static PyObject* xbmc_validatePath (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    String  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmc::validatePath"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::validatePath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::validatePath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::validatePath\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getRegion__doc__,
               "getRegion(id)--Returns your regions setting as a string for the specified id.\n"
"\n"
"id : string - id of setting to return\n"
"\n"
"*Note, choices are (dateshort, datelong, time, meridiem, tempunit, speedunit)You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - date_long_format = xbmc.getRegion('datelong')\n");

  static PyObject* xbmc_getRegion (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    char * id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getRegion(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getRegion\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getRegion\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(getSupportedMedia__doc__,
               "getSupportedMedia(media)--Returns the supported file types for the specific media as a string.\n"
"\n"
"media : string - media type\n"
"\n"
"*Note, media type can be (video, music, picture).The return value is a pipe separated string of filetypes (eg. '.mov|.avi').\n"
"\n"
"   You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - mTypes = xbmc.getSupportedMedia('video')\n");

  static PyObject* xbmc_getSupportedMedia (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "mediaType",
          NULL};
         
    char * mediaType ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &mediaType
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (String )XBMCAddon::xbmc::getSupportedMedia(  mediaType  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::getSupportedMedia\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::getSupportedMedia\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(skinHasImage__doc__,
               "skinHasImage(image)--Returns True if the image file exists in the skin.\n"
"\n"
"image : string - image filename\n"
"\n"
"*Note, If the media resides in a subfolder include it. (eg. home-myfiles\\\\home-myfiles2.png)You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - exists = xbmc.skinHasImage('ButtonFocusedTexture.png')\n");

  static PyObject* xbmc_skinHasImage (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "image",
          NULL};
         
    char * image ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &image
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::skinHasImage(  image  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::skinHasImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::skinHasImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(startServer__doc__,
               "startServer(typ, bStart, bWait)--start or stop a server.\n"
"\n"
"typ : integer - use SERVER_* constants\n"
"\n"
"bStart : bool - start (True) or stop (False) a server\n"
"\n"
"bWait : [opt] bool - wait on stop before returning (not supported by all servers)\n"
"\n"
"returnValue : bool - True or False example:\n"
"    - xbmc.startServer(xbmc.SERVER_AIRPLAYSERVER, False)\n");

  static PyObject* xbmc_startServer (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "iTyp",
          "bStart",
          "bWait",
          NULL};
         
    int  iTyp ;         
    bool  bStart ;         
    bool  bWait  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ib|b",
       (char**)keywords,
         &iTyp,
         &bStart,
         &bWait
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmc::startServer(  iTyp,  bStart,  bWait  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::startServer\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::startServer\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(audioSuspend__doc__,
               "audioSuspend()--Suspend Audio engine.\n"
"\n"
"example: xbmc.audioSuspend()\n");

  static PyObject* xbmc_audioSuspend (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::audioSuspend(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::audioSuspend\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::audioSuspend\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(audioResume__doc__,
               "audioResume()--Resume Audio engine.\n"
"\n"
"example: xbmc.audioResume()\n");

  static PyObject* xbmc_audioResume (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmc::audioResume(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::audioResume\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::audioResume\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
         
    int  playerCore  = EPC_NONE;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|i",
       
         &playerCore
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::Player * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Player *)(&PyXBMCAddon_xbmc_Player_Type != pytype) ? new XBMCAddon_xbmc_Player_Director( playerCore ) : new XBMCAddon::xbmc::Player(  playerCore  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Player\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Player\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_Player_Type,false);
    if (&PyXBMCAddon_xbmc_Player_Type != pytype) 
      ((XBMCAddon_xbmc_Player_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playStream__doc__,
               "playStream([item, listitem, windowed])--Play this item.\n"
"\n"
"item : [opt] string - filename or url. listitem : [opt] listitem - used with setInfo() to set different infolabels. windowed : [opt] bool - true=play video windowed, false=play users preference.(default)\n"
"\n"
"*Note, If item is not given then thePlayer will try to play the current item in the current playlist.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - listitem =xbmcgui.ListItem ('Ironman')\n"
"    - listitem.setInfo('video', {'Title': 'Ironman', 'Genre': 'Science Fiction'})\n"
"    - xbmc.Player ( xbmc.PLAYER_CORE_MPLAYER ).play(url, listitem, windowed)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "item",
          "listitem",
          "windowed",
          NULL};
         
    String  item  = emptyString;
    PyObject* pyitem = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem  = NULL;
    PyObject* pylistitem = NULL;         
    bool  windowed  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OOb",
       (char**)keywords,
         &pyitem,
         &pylistitem,
         &windowed
       ))
    {
      return NULL;
    }


    try
    {
      if (pyitem) PyXBMCGetUnicodeString(item,pyitem,false,"item","playStream"); 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","playStream"); 

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"playStream","XBMCAddon::xbmc::Player"))-> playStream(  item,  listitem,  windowed  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playStream\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playPlaylist__doc__,
               "playPlaylist([playlist, windowed])--Play this item.\n"
"\n"
"playlist : [opt] playlist. windowed : [opt] bool - true=play video windowed, false=play users preference.(default)\n"
"\n"
"*Note, If playlist is not given then thePlayer will try to play the current item in the current playlist.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playPlaylist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "playlist",
          "windowed",
          NULL};
         
    PlayList * playlist  = NULL;
    PyObject* pyplaylist = NULL;         
    bool  windowed  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|Ob",
       (char**)keywords,
         &pyplaylist,
         &windowed
       ))
    {
      return NULL;
    }


    try
    {
      playlist = (PlayList *)retrieveApiInstance(pyplaylist,"p.PlayList","XBMCAddon::xbmc::","playPlaylist"); 

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"playPlaylist","XBMCAddon::xbmc::Player"))-> playPlaylist(  playlist,  windowed  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playPlaylist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playPlaylist\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playCurrent__doc__,
               "play()--try to play the current item in the current playlist.\n"
"\n"
"windowed : [opt] bool - true=play video windowed, false=play users preference.(default)\n"
"\n"
"example:\n"
"    - xbmc.Player ( xbmc.PLAYER_CORE_MPLAYER ).play()\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playCurrent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "windowed",
          NULL};
         
    bool  windowed  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|b",
       (char**)keywords,
         &windowed
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"playCurrent","XBMCAddon::xbmc::Player"))-> playCurrent(  windowed  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playCurrent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playCurrent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_stop__doc__,
               "stop() --Stop playing.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_stop (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"stop","XBMCAddon::xbmc::Player"))-> stop(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"stop\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"stop\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_pause__doc__,
               "pause() --Pause playing.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_pause (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"pause","XBMCAddon::xbmc::Player"))-> pause(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"pause\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"pause\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playnext__doc__,
               "playnext() --Play next item in playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playnext (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"playnext","XBMCAddon::xbmc::Player"))-> playnext(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playnext\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playnext\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playprevious__doc__,
               "playprevious() --Play previous item in playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playprevious (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"playprevious","XBMCAddon::xbmc::Player"))-> playprevious(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playprevious\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playprevious\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_playselected__doc__,
               "playselected() --Play a certain item from the current playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_playselected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    int  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"playselected","XBMCAddon::xbmc::Player"))-> playselected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"playselected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"playselected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackStarted__doc__,
               "onPlayBackStarted() --onPlayBackStarted method.\n"
"\n"
"Will be called when xbmc starts playing a file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackStarted (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackStarted","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackStarted(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackStarted\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackStarted\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackEnded__doc__,
               "onPlayBackEnded() --onPlayBackEnded method.\n"
"\n"
"Will be called when xbmc stops playing a file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackEnded (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackEnded","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackEnded(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackEnded\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackEnded\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackStopped__doc__,
               "onPlayBackStopped() --onPlayBackStopped method.\n"
"\n"
"Will be called when user stops xbmc playing a file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackStopped (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackStopped","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackStopped(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackStopped\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackStopped\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackPaused__doc__,
               "onPlayBackPaused() --onPlayBackPaused method.\n"
"\n"
"Will be called when user pauses a playing file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackPaused (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackPaused","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackPaused(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackPaused\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackPaused\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackResumed__doc__,
               "onPlayBackResumed() --onPlayBackResumed method.\n"
"\n"
"Will be called when user resumes a paused file\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackResumed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackResumed","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackResumed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackResumed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackResumed\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onQueueNextItem__doc__,
               "onQueueNextItem() --onQueueNextItem method.\n"
"\n"
"Will be called when user queues the next item\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onQueueNextItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onQueueNextItem","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onQueueNextItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onQueueNextItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onQueueNextItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackSpeedChanged__doc__,
               "onPlayBackSpeedChanged(speed)--onPlayBackSpeedChanged method.\n"
"\n"
"speed : integer - current speed of player.\n"
"\n"
"*Note, negative speed means player is rewinding, 1 is normal playback speed.\n"
"\n"
"Will be called when players speed changes. (eg. user FF/RW)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSpeedChanged (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "speed",
          NULL};
         
    int  speed ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &speed
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackSpeedChanged","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSpeedChanged(  speed  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSpeedChanged\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSpeedChanged\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackSeek__doc__,
               "onPlayBackSeek(time, seekOffset)--onPlayBackSeek method.\n"
"\n"
"time : integer - time to seek to. seekOffset : integer - ?.\n"
"\n"
"Will be called when user seeks to a time\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSeek (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "time",
          "seekOffset",
          NULL};
         
    int  time ;         
    int  seekOffset ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii",
       (char**)keywords,
         &time,
         &seekOffset
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackSeek","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSeek(  time,  seekOffset  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSeek\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSeek\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_onPlayBackSeekChapter__doc__,
               "onPlayBackSeekChapter(chapter)--onPlayBackSeekChapter method.\n"
"\n"
"chapter : integer - chapter to seek to.\n"
"\n"
"Will be called when user performs a chapter seek\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_onPlayBackSeekChapter (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "chapter",
          NULL};
         
    int  chapter ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &chapter
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"onPlayBackSeekChapter","XBMCAddon::xbmc::Player"))-> XBMCAddon::xbmc::Player::onPlayBackSeekChapter(  chapter  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onPlayBackSeekChapter\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onPlayBackSeekChapter\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_isPlaying__doc__,
               "isPlaying() --returns True is xbmc is playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlaying (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"isPlaying","XBMCAddon::xbmc::Player"))-> isPlaying(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlaying\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlaying\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_isPlayingAudio__doc__,
               "isPlayingAudio() --returns True is xbmc is playing an audio file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingAudio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"isPlayingAudio","XBMCAddon::xbmc::Player"))-> isPlayingAudio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingAudio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingAudio\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_isPlayingVideo__doc__,
               "isPlayingVideo() --returns True if xbmc is playing a video.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_isPlayingVideo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"isPlayingVideo","XBMCAddon::xbmc::Player"))-> isPlayingVideo(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isPlayingVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isPlayingVideo\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getPlayingFile__doc__,
               "getPlayingFile() --returns the current playing file as a string.\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getPlayingFile (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getPlayingFile","XBMCAddon::xbmc::Player"))-> getPlayingFile(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayingFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayingFile\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getTime__doc__,
               "getTime() --Returns the current time of the current playing media as fractional seconds.\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getTime","XBMCAddon::xbmc::Player"))-> getTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTime\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_seekTime__doc__,
               "seekTime() --Seeks the specified amount of time as fractional seconds. The time specified is relative to the beginning of the currently playing media file.\n"
"\n"
"Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_seekTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "seekTime",
          NULL};
         
    double  seekTime ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"d",
       (char**)keywords,
         &seekTime
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"seekTime","XBMCAddon::xbmc::Player"))-> seekTime(  seekTime  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"seekTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"seekTime\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_setSubtitles__doc__,
               "setSubtitles() --set subtitle file and enable subtitles\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "subtitleFile",
          NULL};
         
    char * subtitleFile ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &subtitleFile
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"setSubtitles","XBMCAddon::xbmc::Player"))-> setSubtitles(  subtitleFile  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitles\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_showSubtitles__doc__,
               "showSubtitles(visible)--enable/disable subtitles\n"
"\n"
"visible : boolean - True for visible subtitles. example:\n"
"    - xbmc.Player().showSubtitles(True)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_showSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "bVisible",
          NULL};
         
    bool  bVisible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &bVisible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"showSubtitles","XBMCAddon::xbmc::Player"))-> showSubtitles(  bVisible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"showSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"showSubtitles\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getSubtitles__doc__,
               "getSubtitles() --get subtitle stream name\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getSubtitles","XBMCAddon::xbmc::Player"))-> getSubtitles(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSubtitles\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_disableSubtitles__doc__,
               "DisableSubtitles()--disable subtitles\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_disableSubtitles (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"disableSubtitles","XBMCAddon::xbmc::Player"))-> disableSubtitles(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"disableSubtitles\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"disableSubtitles\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getAvailableSubtitleStreams__doc__,
               "getAvailableSubtitleStreams() --get Subtitle stream names\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getAvailableSubtitleStreams (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    std::vector< String  > * apiResult;
    try
    {

      apiResult = (std::vector< String  > *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getAvailableSubtitleStreams","XBMCAddon::xbmc::Player"))-> getAvailableSubtitleStreams(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAvailableSubtitleStreams\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAvailableSubtitleStreams\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    result = PyList_New(0);

    if (apiResult != NULL)
    { 

      for (std::vector<String >::iterator iter = apiResult->begin(); iter != apiResult->end(); ++iter)
      {
        String & entry1 = *iter;
        PyObject* pyentry1;
        
pyentry1 = PyString_FromString(entry1.c_str());

        PyList_Append(result, pyentry1);
      }

    }



    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_setSubtitleStream__doc__,
               "setSubtitleStream(stream)--set Subtitle Stream\n"
"\n"
"stream : int\n"
"\n"
"example:\n"
"    - setSubtitleStream(1)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setSubtitleStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "iStream",
          NULL};
         
    int  iStream ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iStream
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"setSubtitleStream","XBMCAddon::xbmc::Player"))-> setSubtitleStream(  iStream  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSubtitleStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSubtitleStream\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getVideoInfoTag__doc__,
               "getVideoInfoTag() --returns the VideoInfoTag of the current playing Movie.\n"
"\n"
"Throws: Exception, if player is not playing a file or current file is not a movie file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getVideoInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    InfoTagVideo * apiResult;
    try
    {

      apiResult = (InfoTagVideo *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getVideoInfoTag","XBMCAddon::xbmc::Player"))-> getVideoInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVideoInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVideoInfoTag\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmc_InfoTagVideo_Type,&TyXBMCAddon_xbmc_InfoTagVideo_Type,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getMusicInfoTag__doc__,
               "getMusicInfoTag() --returns the MusicInfoTag of the current playing 'Song'.\n"
"\n"
"Throws: Exception, if player is not playing a file or current file is not a music file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getMusicInfoTag (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    InfoTagMusic * apiResult;
    try
    {

      apiResult = (InfoTagMusic *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getMusicInfoTag","XBMCAddon::xbmc::Player"))-> getMusicInfoTag(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getMusicInfoTag\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getMusicInfoTag\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmc_InfoTagMusic_Type,&TyXBMCAddon_xbmc_InfoTagMusic_Type,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_getTotalTime__doc__,
               "*getTotalTime()--Returns the total time of the current playing media in seconds. This is only accurate to the full second.\n"
"\n"
"*Throws: Exception, if player is not playing a file.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getTotalTime (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getTotalTime","XBMCAddon::xbmc::Player"))-> getTotalTime(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTotalTime\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTotalTime\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Player_getAvailableAudioStreams (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    std::vector< String  > * apiResult;
    try
    {

      apiResult = (std::vector< String  > *)((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"getAvailableAudioStreams","XBMCAddon::xbmc::Player"))-> getAvailableAudioStreams(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAvailableAudioStreams\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAvailableAudioStreams\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    result = PyList_New(0);

    if (apiResult != NULL)
    { 

      for (std::vector<String >::iterator iter = apiResult->begin(); iter != apiResult->end(); ++iter)
      {
        String & entry1 = *iter;
        PyObject* pyentry1;
        
pyentry1 = PyString_FromString(entry1.c_str());

        PyList_Append(result, pyentry1);
      }

    }



    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Player_setAudioStream__doc__,
               "setAudioStream(stream)--set Audio Stream\n"
"\n"
"stream : int\n"
"\n"
"example:\n"
"    - setAudioStream(1)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Player_setAudioStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "iStream",
          NULL};
         
    int  iStream ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iStream
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"setAudioStream","XBMCAddon::xbmc::Player"))-> setAudioStream(  iStream  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setAudioStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setAudioStream\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmc::RenderCapture * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::RenderCapture *)new XBMCAddon::xbmc::RenderCapture(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::RenderCapture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::RenderCapture\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_RenderCapture_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getWidth__doc__,
               "getWidth() --returns width of captured image.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"getWidth","XBMCAddon::xbmc::RenderCapture"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getHeight__doc__,
               "getHeight() --returns height of captured image.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"getHeight","XBMCAddon::xbmc::RenderCapture"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getCaptureState__doc__,
               "getCaptureState() --returns processing state of capture request.\n"
"\n"
"The returned value could be compared against the following constants: xbmc.CAPTURE_STATE_WORKING : Capture request in progress. xbmc.CAPTURE_STATE_DONE : Capture request done. The image could be retrieved with getImage() xbmc.CAPTURE_STATE_FAILED : Capture request failed.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getCaptureState (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"getCaptureState","XBMCAddon::xbmc::RenderCapture"))-> getCaptureState(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCaptureState\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCaptureState\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getAspectRatio__doc__,
               "getAspectRatio() --returns aspect ratio of currently displayed video.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getAspectRatio (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"getAspectRatio","XBMCAddon::xbmc::RenderCapture"))-> getAspectRatio(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAspectRatio\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAspectRatio\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_getImageFormat__doc__,
               "getImageFormat() --returns format of captured image: 'BGRA' or 'RGBA'.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getImageFormat (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    char * apiResult;
    try
    {

      apiResult = (char *)((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"getImageFormat","XBMCAddon::xbmc::RenderCapture"))-> getImageFormat(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getImageFormat\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getImageFormat\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyString_FromString(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_capture__doc__,
               "getImage()--returns captured image as a bytearray.\n"
"\n"
"The size of the image isgetWidth() *getHeight() * 4 capture(width, height [, flags])--issue capture request.\n"
"\n"
"width : Width capture image should be rendered to height : Height capture image should should be rendered to flags : Optional. Flags that control the capture processing.\n"
"\n"
"The value for 'flags' could be or'ed from the following constants: xbmc.CAPTURE_FLAG_CONTINUOUS : after a capture is done, issue a new capture request immediately xbmc.CAPTURE_FLAG_IMMEDIATELY : read out immediately whencapture() is called, this can cause a busy wait\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_capture (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "width",
          "height",
          "flags",
          NULL};
         
    int  width ;         
    int  height ;         
    int  flags  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii|i",
       (char**)keywords,
         &width,
         &height,
         &flags
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"capture","XBMCAddon::xbmc::RenderCapture"))-> capture(  width,  height,  flags  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"capture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"capture\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent__doc__,
               "waitForCaptureStateChangeEvent([msecs])--wait for capture state change event.\n"
"\n"
"msecs : Milliseconds to wait. Waits forever if not specified.\n"
"\n"
"The method will return 1 if the Event was triggered. Otherwise it will return 0.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "msecs",
          NULL};
         
    unsigned int  msecs  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|I",
       (char**)keywords,
         &msecs
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"waitForCaptureStateChangeEvent","XBMCAddon::xbmc::RenderCapture"))-> waitForCaptureStateChangeEvent(  msecs  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"waitForCaptureStateChangeEvent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"waitForCaptureStateChangeEvent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmc::InfoTagMusic * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagMusic *)new XBMCAddon::xbmc::InfoTagMusic(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagMusic\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagMusic\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_InfoTagMusic_Type,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getURL (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getURL","XBMCAddon::xbmc::InfoTagMusic"))-> getURL(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getURL\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getURL\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getTitle","XBMCAddon::xbmc::InfoTagMusic"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getArtist","XBMCAddon::xbmc::InfoTagMusic"))-> getArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getArtist\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbum (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getAlbum","XBMCAddon::xbmc::InfoTagMusic"))-> getAlbum(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbum\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbum\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getAlbumArtist","XBMCAddon::xbmc::InfoTagMusic"))-> getAlbumArtist(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAlbumArtist\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAlbumArtist\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getGenre (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getGenre","XBMCAddon::xbmc::InfoTagMusic"))-> getGenre(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getGenre\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getGenre\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getDuration (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getDuration","XBMCAddon::xbmc::InfoTagMusic"))-> getDuration(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDuration\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDuration\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getTrack (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getTrack","XBMCAddon::xbmc::InfoTagMusic"))-> getTrack(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTrack\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTrack\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getDisc (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getDisc","XBMCAddon::xbmc::InfoTagMusic"))-> getDisc(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDisc\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDisc\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getReleaseDate (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getReleaseDate","XBMCAddon::xbmc::InfoTagMusic"))-> getReleaseDate(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getReleaseDate\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getReleaseDate\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getListeners (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getListeners","XBMCAddon::xbmc::InfoTagMusic"))-> getListeners(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListeners\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListeners\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getPlayCount (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getPlayCount","XBMCAddon::xbmc::InfoTagMusic"))-> getPlayCount(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayCount\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayCount\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getLastPlayed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getLastPlayed","XBMCAddon::xbmc::InfoTagMusic"))-> getLastPlayed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLastPlayed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLastPlayed\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getComment (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getComment","XBMCAddon::xbmc::InfoTagMusic"))-> getComment(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getComment\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getComment\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagMusic_getLyrics (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"getLyrics","XBMCAddon::xbmc::InfoTagMusic"))-> getLyrics(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLyrics\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLyrics\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmc::InfoTagVideo * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::InfoTagVideo *)new XBMCAddon::xbmc::InfoTagVideo(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::InfoTagVideo\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_InfoTagVideo_Type,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getDirector (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getDirector","XBMCAddon::xbmc::InfoTagVideo"))-> getDirector(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getDirector\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getDirector\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getWritingCredits (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getWritingCredits","XBMCAddon::xbmc::InfoTagVideo"))-> getWritingCredits(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWritingCredits\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWritingCredits\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getGenre (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getGenre","XBMCAddon::xbmc::InfoTagVideo"))-> getGenre(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getGenre\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getGenre\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getTagLine (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getTagLine","XBMCAddon::xbmc::InfoTagVideo"))-> getTagLine(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTagLine\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTagLine\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlotOutline (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlotOutline","XBMCAddon::xbmc::InfoTagVideo"))-> getPlotOutline(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlotOutline\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlotOutline\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlot (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlot","XBMCAddon::xbmc::InfoTagVideo"))-> getPlot(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlot\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlot\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPictureURL (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getPictureURL","XBMCAddon::xbmc::InfoTagVideo"))-> getPictureURL(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPictureURL\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPictureURL\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getTitle","XBMCAddon::xbmc::InfoTagVideo"))-> getTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getTitle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getVotes (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getVotes","XBMCAddon::xbmc::InfoTagVideo"))-> getVotes(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getVotes\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getVotes\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getCast (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getCast","XBMCAddon::xbmc::InfoTagVideo"))-> getCast(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCast\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCast\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getFile (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getFile","XBMCAddon::xbmc::InfoTagVideo"))-> getFile(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFile\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFile\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getPath","XBMCAddon::xbmc::InfoTagVideo"))-> getPath(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPath\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getIMDBNumber","XBMCAddon::xbmc::InfoTagVideo"))-> getIMDBNumber(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getIMDBNumber\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getIMDBNumber\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getYear (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getYear","XBMCAddon::xbmc::InfoTagVideo"))-> getYear(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getYear\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getYear\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getRating (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    double  apiResult;
    try
    {

      apiResult = (double )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getRating","XBMCAddon::xbmc::InfoTagVideo"))-> getRating(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getRating\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getRating\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyFloat_FromDouble(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getPlayCount__doc__,
               "getPlayCount() --returns a integer.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlayCount (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getPlayCount","XBMCAddon::xbmc::InfoTagVideo"))-> getPlayCount(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayCount\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayCount\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_InfoTagVideo_getLastPlayed__doc__,
               "getLastPlayed() --returns a string.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getLastPlayed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getLastPlayed","XBMCAddon::xbmc::InfoTagVideo"))-> getLastPlayed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLastPlayed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLastPlayed\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getOriginalTitle","XBMCAddon::xbmc::InfoTagVideo"))-> getOriginalTitle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getOriginalTitle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getOriginalTitle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getPremiered (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getPremiered","XBMCAddon::xbmc::InfoTagVideo"))-> getPremiered(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPremiered\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPremiered\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_InfoTagVideo_getFirstAired (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"getFirstAired","XBMCAddon::xbmc::InfoTagVideo"))-> getFirstAired(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFirstAired\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFirstAired\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
         
    String  line  = emptyString;
    PyObject* pyline = NULL;         
    String  heading  = emptyString;
    PyObject* pyheading = NULL;         
    bool  hidden  = false;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|OOb",
       
         &pyline,
         &pyheading,
         &hidden
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::Keyboard * apiResult;
    try
    {
      if (pyline) PyXBMCGetUnicodeString(line,pyline,false,"line","XBMCAddon::xbmc::Keyboard"); 
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","XBMCAddon::xbmc::Keyboard"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Keyboard *)new XBMCAddon::xbmc::Keyboard(  line,  heading,  hidden  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Keyboard\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Keyboard\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_Keyboard_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_doModal__doc__,
               "doModal([autoclose])--Show keyboard and wait for user action.\n"
"\n"
"autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)\n"
"\n"
"example:\n"
"    - kb.doModal(30000)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_doModal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "autoclose",
          NULL};
         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|i",
       (char**)keywords,
         &autoclose
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"doModal","XBMCAddon::xbmc::Keyboard"))-> doModal(  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"doModal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"doModal\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_setDefault__doc__,
               "setDefault(default)--Set the default text entry.\n"
"\n"
"default : string - default text entry.\n"
"\n"
"example:\n"
"    - kb.setDefault('password')\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setDefault (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "line",
          NULL};
         
    String  line  = emptyString;
    PyObject* pyline = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|O",
       (char**)keywords,
         &pyline
       ))
    {
      return NULL;
    }


    try
    {
      if (pyline) PyXBMCGetUnicodeString(line,pyline,false,"line","setDefault"); 

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"setDefault","XBMCAddon::xbmc::Keyboard"))-> setDefault(  line  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDefault\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDefault\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_setHiddenInput__doc__,
               "setHiddenInput(hidden)--Allows hidden text entry.\n"
"\n"
"hidden : boolean - True for hidden text entry. example:\n"
"    - kb.setHiddenInput(True)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setHiddenInput (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "hidden",
          NULL};
         
    bool  hidden  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|b",
       (char**)keywords,
         &hidden
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"setHiddenInput","XBMCAddon::xbmc::Keyboard"))-> setHiddenInput(  hidden  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHiddenInput\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHiddenInput\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_setHeading__doc__,
               "setHeading(heading)--Set the keyboard heading.\n"
"\n"
"heading : string - keyboard heading.\n"
"\n"
"example:\n"
"    - kb.setHeading('Enter password')\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_setHeading (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "heading",
          NULL};
         
    String  heading ;
    PyObject* pyheading = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyheading
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","setHeading"); 

      ((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"setHeading","XBMCAddon::xbmc::Keyboard"))-> setHeading(  heading  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHeading\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHeading\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_getText__doc__,
               "getText() --Returns the user input as a string.\n"
"\n"
"*Note, This will always return the text entry even if you cancel the keyboard. Use theisConfirmed() method to check if user cancelled the keyboard.\n"
"\n"
"example:\n"
"    - text = kb.getText()\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"getText","XBMCAddon::xbmc::Keyboard"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard_isConfirmed__doc__,
               "isConfirmed() --Returns False if the user cancelled the input.\n"
"\n"
"example:\n"
"    - if (kb.isConfirmed()):\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Keyboard_isConfirmed (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"isConfirmed","XBMCAddon::xbmc::Keyboard"))-> isConfirmed(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isConfirmed\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isConfirmed\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
         
    int  playList ;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"i",
       
         &playList
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmc::PlayList * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::PlayList *)new XBMCAddon::xbmc::PlayList(  playList  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::PlayList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::PlayList\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_PlayList_Type,false);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_getPlayListId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"getPlayListId","XBMCAddon::xbmc::PlayList"))-> getPlayListId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPlayListId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPlayListId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_add__doc__,
               "add(url[, listitem, index])--Adds a new file to the playlist.\n"
"\n"
"url : string or unicode - filename or url to add. listitem : [opt] listitem - used with setInfo() to set different infolabels. index : [opt] integer - position to add playlist item. (default=end)\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - playlist =xbmc.PlayList (xbmc.PLAYLIST_VIDEO)\n"
"    - video = 'F:\\\\movies\\\\Ironman.mov'\n"
"    - listitem =xbmcgui.ListItem ('Ironman', thumbnailImage='F:\\\\movies\\\\Ironman.tbn')\n"
"    - listitem.setInfo('video', {'Title': 'Ironman', 'Genre': 'Science Fiction'})\n"
"    - playlist.add(url=video, listitem=listitem, index=7)\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_add (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "url",
          "listitem",
          "index",
          NULL};
         
    String  url ;
    PyObject* pyurl = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem  = NULL;
    PyObject* pylistitem = NULL;         
    int  index  = -1;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|Oi",
       (char**)keywords,
         &pyurl,
         &pylistitem,
         &index
       ))
    {
      return NULL;
    }


    try
    {
      if (pyurl) PyXBMCGetUnicodeString(url,pyurl,false,"url","add"); 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","add"); 

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"add","XBMCAddon::xbmc::PlayList"))-> add(  url,  listitem,  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"add\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"add\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_load__doc__,
               "load(filename)--Load a playlist.\n"
"\n"
"clear current playlist and copy items from the file to this Playlist filename can be like .pls or .m3u ... returns False if unable to load playlist\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_load (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"load","XBMCAddon::xbmc::PlayList"))-> load(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"load\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"load\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_remove__doc__,
               "remove(filename)--remove an item with this filename from the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_remove (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "filename",
          NULL};
         
    char * filename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &filename
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"remove","XBMCAddon::xbmc::PlayList"))-> remove(  filename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"remove\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"remove\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_clear__doc__,
               "clear() --clear all items in the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_clear (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"clear","XBMCAddon::xbmc::PlayList"))-> clear(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clear\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clear\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_size__doc__,
               "size() --returns the total number of PlayListItems in this playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"size","XBMCAddon::xbmc::PlayList"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_shuffle__doc__,
               "shuffle() --shuffle the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_shuffle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"shuffle","XBMCAddon::xbmc::PlayList"))-> shuffle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"shuffle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"shuffle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_unshuffle__doc__,
               "unshuffle() --unshuffle the playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_unshuffle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"unshuffle","XBMCAddon::xbmc::PlayList"))-> unshuffle(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"unshuffle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"unshuffle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_PlayList_getposition__doc__,
               "getposition() --returns the position of the current song in this playlist.\n");

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_getposition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"getposition","XBMCAddon::xbmc::PlayList"))-> getposition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getposition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getposition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_PlayList_operatorIndex_ (PyHolder* self , PyObject* pyi )
  {
    TRACE;
         
    long  i ;    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {
      i = PyInt_AsLong(pyi); 

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"operator []","XBMCAddon::xbmc::PlayList"))-> operator [](  i  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"operator []\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"operator []\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type,true);

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmc::Monitor * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmc::Monitor *)(&PyXBMCAddon_xbmc_Monitor_Type != pytype) ? new XBMCAddon_xbmc_Monitor_Director() : new XBMCAddon::xbmc::Monitor(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmc::Monitor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmc::Monitor\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmc_Monitor_Type,false);
    if (&PyXBMCAddon_xbmc_Monitor_Type != pytype) 
      ((XBMCAddon_xbmc_Monitor_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onSettingsChanged__doc__,
               "onSettingsChanged() --onSettingsChanged method.\n"
"\n"
"Will be called when addon settings are changed\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onSettingsChanged (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"onSettingsChanged","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onSettingsChanged(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onSettingsChanged\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onSettingsChanged\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onScreensaverActivated__doc__,
               "onScreensaverActivated() --onScreensaverActivated method.\n"
"\n"
"Will be called when screensaver kicks in\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScreensaverActivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"onScreensaverActivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScreensaverActivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScreensaverActivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScreensaverActivated\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onScreensaverDeactivated__doc__,
               "onScreensaverDeactivated() --onScreensaverDeactivated method.\n"
"\n"
"Will be called when screensaver goes off\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onScreensaverDeactivated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"onScreensaverDeactivated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onScreensaverDeactivated(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onScreensaverDeactivated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onScreensaverDeactivated\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onDatabaseUpdated__doc__,
               "onDatabaseUpdated(database)--onDatabaseUpdated method.\n"
"\n"
"database - video/music as stri\n"
"\n"
"Will be called when database gets updated and return video or music to indicate which DB has been changed\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onDatabaseUpdated (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "database",
          NULL};
         
    String  database ;
    PyObject* pydatabase = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydatabase
       ))
    {
      return NULL;
    }


    try
    {
      if (pydatabase) PyXBMCGetUnicodeString(database,pydatabase,false,"database","onDatabaseUpdated"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"onDatabaseUpdated","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onDatabaseUpdated(  database  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDatabaseUpdated\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDatabaseUpdated\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmc_Monitor_onAbortRequested__doc__,
               "onAbortRequested() --onAbortRequested method.\n"
"\n"
"Will be called when XBMC requests Abort\n");

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_onAbortRequested (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"onAbortRequested","XBMCAddon::xbmc::Monitor"))-> XBMCAddon::xbmc::Monitor::onAbortRequested(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onAbortRequested\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onAbortRequested\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmc_XBMCAddon_xbmc_Monitor_GetId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"GetId","XBMCAddon::xbmc::Monitor"))-> GetId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"GetId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"GetId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static void xbmc_XBMCAddon_xbmc_Player_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::Player* theObj = (XBMCAddon::xbmc::Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"~XBMCAddon::xbmc::Player","XBMCAddon::xbmc::Player");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Player\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Player\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_RenderCapture_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::RenderCapture* theObj = (XBMCAddon::xbmc::RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"~XBMCAddon::xbmc::RenderCapture","XBMCAddon::xbmc::RenderCapture");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::RenderCapture\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::RenderCapture\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagMusic_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagMusic* theObj = (XBMCAddon::xbmc::InfoTagMusic*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagMusic_Type,"~XBMCAddon::xbmc::InfoTagMusic","XBMCAddon::xbmc::InfoTagMusic");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagMusic\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagMusic\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_InfoTagVideo_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::InfoTagVideo* theObj = (XBMCAddon::xbmc::InfoTagVideo*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_InfoTagVideo_Type,"~XBMCAddon::xbmc::InfoTagVideo","XBMCAddon::xbmc::InfoTagVideo");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagVideo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::InfoTagVideo\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_Keyboard_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::Keyboard* theObj = (XBMCAddon::xbmc::Keyboard*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Keyboard_Type,"~XBMCAddon::xbmc::Keyboard","XBMCAddon::xbmc::Keyboard");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Keyboard\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Keyboard\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_PlayList_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::PlayList* theObj = (XBMCAddon::xbmc::PlayList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_PlayList_Type,"~XBMCAddon::xbmc::PlayList","XBMCAddon::xbmc::PlayList");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::PlayList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::PlayList\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmc_XBMCAddon_xbmc_Monitor_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmc::Monitor* theObj = (XBMCAddon::xbmc::Monitor*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Monitor_Type,"~XBMCAddon::xbmc::Monitor","XBMCAddon::xbmc::Monitor");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmc::Monitor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmc::Monitor\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static PyObject* xbmc_XBMCAddon_xbmc_Player_play(PyObject* self, PyObject *args, PyObject *kwds)
  {
    TRACE;
    PyObject *pObject = NULL;
    PyObject *pObjectListItem = NULL;
    char bWindowed = false;
    static const char *keywords[] = { "item", "listitem", "windowed", NULL };

    if (!PyArg_ParseTupleAndKeywords(
      args,
      kwds,
      (char*)"|OOb",
      (char**)keywords,
      &pObject,
      &pObjectListItem,
      &bWindowed))
    {
      return NULL;
    }

    try
    {
      Player* player = ((Player*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_Player_Type,"play","XBMCAddon::xbmc::Player"));

      // set fullscreen or windowed
      bool windowed = (0 != bWindowed);

      if (pObject == NULL)
        player->playCurrent(windowed);
      else if ((PyString_Check(pObject) || PyUnicode_Check(pObject)))
      {
        CStdString item;
        PyXBMCGetUnicodeString(item,pObject,"item","Player::play");
        XBMCAddon::xbmcgui::ListItem* pListItem = 
          (pObjectListItem ? 
           (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pObjectListItem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmc::","play") :
           NULL);
        player->playStream(item,pListItem,windowed);
      }
      else // pObject must be a playlist
        player->playPlaylist((PlayList *)retrieveApiInstance(pObject,"p.XBMCAddon::xbmc::PlayList","XBMCAddon::xbmc::","play"), windowed);
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"Leaving Python method 'XBMCAddon_xbmc_Player_play'. Exception from call to 'play' '%s' ... returning NULL", e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"Unknown exception thrown from the call 'play'");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call 'play'"); 
      return NULL; 
    }

    Py_INCREF(Py_None);
    return Py_None;
  }

  static PyObject* xbmc_XBMCAddon_xbmc_RenderCapture_getImage(PyObject* self, PyObject *args, PyObject *kwds)
  {
  RenderCapture* rc = ((RenderCapture*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmc_RenderCapture_Type,"getImage","XBMCAddon::xbmc::RenderCapture"));
  if (rc->GetUserState() != CAPTURESTATE_DONE)
  {
    PyErr_SetString(PyExc_SystemError, "illegal user state");
    return NULL;
  }
  
  Py_ssize_t size = rc->getWidth() * rc->getHeight() * 4;
  return PyByteArray_FromStringAndSize((const char *)rc->GetPixels(), size);
}

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Player
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Player_methods[] = { 
    {(char*)"playStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playStream, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playStream__doc__ }, 
    {(char*)"playPlaylist", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playPlaylist, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playPlaylist__doc__ }, 
    {(char*)"playCurrent", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playCurrent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playCurrent__doc__ }, 
    {(char*)"stop", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_stop, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_stop__doc__ }, 
    {(char*)"pause", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_pause, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_pause__doc__ }, 
    {(char*)"playnext", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playnext, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playnext__doc__ }, 
    {(char*)"playprevious", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playprevious, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playprevious__doc__ }, 
    {(char*)"playselected", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_playselected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_playselected__doc__ }, 
    {(char*)"onPlayBackStarted", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackStarted, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackStarted__doc__ }, 
    {(char*)"onPlayBackEnded", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackEnded, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackEnded__doc__ }, 
    {(char*)"onPlayBackStopped", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackStopped, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackStopped__doc__ }, 
    {(char*)"onPlayBackPaused", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackPaused, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackPaused__doc__ }, 
    {(char*)"onPlayBackResumed", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackResumed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackResumed__doc__ }, 
    {(char*)"onQueueNextItem", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onQueueNextItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onQueueNextItem__doc__ }, 
    {(char*)"onPlayBackSpeedChanged", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSpeedChanged, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackSpeedChanged__doc__ }, 
    {(char*)"onPlayBackSeek", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSeek, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackSeek__doc__ }, 
    {(char*)"onPlayBackSeekChapter", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_onPlayBackSeekChapter, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_onPlayBackSeekChapter__doc__ }, 
    {(char*)"isPlaying", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlaying, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_isPlaying__doc__ }, 
    {(char*)"isPlayingAudio", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingAudio, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_isPlayingAudio__doc__ }, 
    {(char*)"isPlayingVideo", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_isPlayingVideo, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_isPlayingVideo__doc__ }, 
    {(char*)"getPlayingFile", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getPlayingFile, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getPlayingFile__doc__ }, 
    {(char*)"getTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getTime, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getTime__doc__ }, 
    {(char*)"seekTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_seekTime, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_seekTime__doc__ }, 
    {(char*)"setSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_setSubtitles__doc__ }, 
    {(char*)"showSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_showSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_showSubtitles__doc__ }, 
    {(char*)"getSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getSubtitles__doc__ }, 
    {(char*)"disableSubtitles", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_disableSubtitles, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_disableSubtitles__doc__ }, 
    {(char*)"getAvailableSubtitleStreams", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getAvailableSubtitleStreams, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getAvailableSubtitleStreams__doc__ }, 
    {(char*)"setSubtitleStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setSubtitleStream, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_setSubtitleStream__doc__ }, 
    {(char*)"getVideoInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getVideoInfoTag, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getVideoInfoTag__doc__ }, 
    {(char*)"getMusicInfoTag", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getMusicInfoTag, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getMusicInfoTag__doc__ }, 
    {(char*)"getTotalTime", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getTotalTime, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_getTotalTime__doc__ }, 
    {(char*)"getAvailableAudioStreams", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_getAvailableAudioStreams, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setAudioStream", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_setAudioStream, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Player_setAudioStream__doc__ }, 
    {(char*)"play", (PyCFunction)xbmc_XBMCAddon_xbmc_Player_play, METH_VARARGS|METH_KEYWORDS, NULL},

    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Player_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_Player__doc__,
                 "Player class.\n"
"\n"
"Player([core])--Creates a newPlayer with as default the xbmc music playlist.\n"
"\n"
"core : (optional) Use a specified playcore instead of letting xbmc decide the playercore to use.\n"
"    - xbmc.PLAYER_CORE_AUTO\n"
"    - xbmc.PLAYER_CORE_DVDPLAYER\n"
"    - xbmc.PLAYER_CORE_MPLAYER\n"
"    - xbmc.PLAYER_CORE_PAPLAYER\n"
"\n"
"\n"
"This class is a merge of what was previously in xbmcmodule/player.h and xbmcmodule/PythonPlayer.h without the python references. The queuing and handling of asynchronous callbacks is done internal to this class.\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_Player_Type,&TyXBMCAddon_xbmc_Player_Type);

    PyXBMCAddon_xbmc_Player_Type.tp_name = (char*)"xbmc.Player";
    PyXBMCAddon_xbmc_Player_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_Player_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Player_Dealloc; 

    PyXBMCAddon_xbmc_Player_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_Player_Type.tp_doc = XBMCAddon_xbmc_Player__doc__;
    PyXBMCAddon_xbmc_Player_Type.tp_methods = XBMCAddon_xbmc_Player_methods;
    PyXBMCAddon_xbmc_Player_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_Player_Type.tp_new = xbmc_XBMCAddon_xbmc_Player_New;

    TyXBMCAddon_xbmc_Player_Type.swigType="p.XBMCAddon::xbmc::Player";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::RenderCapture
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_RenderCapture_methods[] = { 
    {(char*)"getWidth", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getWidth__doc__ }, 
    {(char*)"getHeight", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getHeight__doc__ }, 
    {(char*)"getCaptureState", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getCaptureState, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getCaptureState__doc__ }, 
    {(char*)"getAspectRatio", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getAspectRatio, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getAspectRatio__doc__ }, 
    {(char*)"getImageFormat", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getImageFormat, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_getImageFormat__doc__ }, 
    {(char*)"capture", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_capture, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_capture__doc__ }, 
    {(char*)"waitForCaptureStateChangeEvent", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_RenderCapture_waitForCaptureStateChangeEvent__doc__ }, 
    {(char*)"getImage", (PyCFunction)xbmc_XBMCAddon_xbmc_RenderCapture_getImage, METH_VARARGS|METH_KEYWORDS, NULL},

    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_RenderCapture_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_RenderCapture_Type,&TyXBMCAddon_xbmc_RenderCapture_Type);

    PyXBMCAddon_xbmc_RenderCapture_Type.tp_name = (char*)"xbmc.RenderCapture";
    PyXBMCAddon_xbmc_RenderCapture_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_RenderCapture_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_RenderCapture_Dealloc; 

    PyXBMCAddon_xbmc_RenderCapture_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_RenderCapture_Type.tp_doc = NULL;
    PyXBMCAddon_xbmc_RenderCapture_Type.tp_methods = XBMCAddon_xbmc_RenderCapture_methods;
    PyXBMCAddon_xbmc_RenderCapture_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_RenderCapture_Type.tp_new = xbmc_XBMCAddon_xbmc_RenderCapture_New;

    TyXBMCAddon_xbmc_RenderCapture_Type.swigType="p.XBMCAddon::xbmc::RenderCapture";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagMusic
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagMusic_methods[] = { 
    {(char*)"getURL", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getURL, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getArtist, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAlbum", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbum, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAlbumArtist", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getAlbumArtist, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getGenre", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getGenre, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getDuration", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getDuration, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTrack", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getTrack, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getDisc", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getDisc, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getReleaseDate", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getReleaseDate, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListeners", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getListeners, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlayCount", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getPlayCount, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLastPlayed", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getLastPlayed, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getComment", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getComment, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLyrics", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagMusic_getLyrics, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagMusic_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_InfoTagMusic_Type,&TyXBMCAddon_xbmc_InfoTagMusic_Type);

    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_name = (char*)"xbmc.InfoTagMusic";
    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagMusic_Dealloc; 

    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_doc = NULL;
    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_methods = XBMCAddon_xbmc_InfoTagMusic_methods;
    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_InfoTagMusic_Type.tp_new = xbmc_XBMCAddon_xbmc_InfoTagMusic_New;

    TyXBMCAddon_xbmc_InfoTagMusic_Type.swigType="p.XBMCAddon::xbmc::InfoTagMusic";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::InfoTagVideo
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_InfoTagVideo_methods[] = { 
    {(char*)"getDirector", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getDirector, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getWritingCredits", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getWritingCredits, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getGenre", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getGenre, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTagLine", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getTagLine, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlotOutline", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlotOutline, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlot", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlot, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPictureURL", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPictureURL, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getVotes", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getVotes, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCast", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getCast, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFile", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getFile, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPath", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPath, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getIMDBNumber", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getIMDBNumber, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getYear", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getYear, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getRating", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getRating, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPlayCount", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPlayCount, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getPlayCount__doc__ }, 
    {(char*)"getLastPlayed", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getLastPlayed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_InfoTagVideo_getLastPlayed__doc__ }, 
    {(char*)"getOriginalTitle", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getOriginalTitle, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPremiered", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getPremiered, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getFirstAired", (PyCFunction)xbmc_XBMCAddon_xbmc_InfoTagVideo_getFirstAired, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_InfoTagVideo_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_InfoTagVideo_Type,&TyXBMCAddon_xbmc_InfoTagVideo_Type);

    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_name = (char*)"xbmc.InfoTagVideo";
    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_InfoTagVideo_Dealloc; 

    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_doc = NULL;
    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_methods = XBMCAddon_xbmc_InfoTagVideo_methods;
    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_InfoTagVideo_Type.tp_new = xbmc_XBMCAddon_xbmc_InfoTagVideo_New;

    TyXBMCAddon_xbmc_InfoTagVideo_Type.swigType="p.XBMCAddon::xbmc::InfoTagVideo";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Keyboard
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Keyboard_methods[] = { 
    {(char*)"doModal", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_doModal, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_doModal__doc__ }, 
    {(char*)"setDefault", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setDefault, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_setDefault__doc__ }, 
    {(char*)"setHiddenInput", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setHiddenInput, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_setHiddenInput__doc__ }, 
    {(char*)"setHeading", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_setHeading, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_setHeading__doc__ }, 
    {(char*)"getText", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_getText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_getText__doc__ }, 
    {(char*)"isConfirmed", (PyCFunction)xbmc_XBMCAddon_xbmc_Keyboard_isConfirmed, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Keyboard_isConfirmed__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Keyboard_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_Keyboard__doc__,
                 "Keyboard class.\n"
"\n"
"Keyboard([default, heading, hidden])--Creates a newKeyboard object with default text heading and hidden input flag if supplied.\n"
"\n"
"default : [opt] string - default text entry. heading : [opt] string - keyboard heading. hidden : [opt] boolean - True for hidden text entry.\n"
"\n"
"example:\n"
"    - kb =xbmc.Keyboard ('default', 'heading', True)\n"
"    - kb.setDefault('password') # optional\n"
"    - kb.setHeading('Enter password') # optional\n"
"    - kb.setHiddenInput(True) # optional\n"
"    - kb.doModal()\n"
"    - if (kb.isConfirmed()):\n"
"    - text = kb.getText()\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_Keyboard_Type,&TyXBMCAddon_xbmc_Keyboard_Type);

    PyXBMCAddon_xbmc_Keyboard_Type.tp_name = (char*)"xbmc.Keyboard";
    PyXBMCAddon_xbmc_Keyboard_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_Keyboard_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Keyboard_Dealloc; 

    PyXBMCAddon_xbmc_Keyboard_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_Keyboard_Type.tp_doc = XBMCAddon_xbmc_Keyboard__doc__;
    PyXBMCAddon_xbmc_Keyboard_Type.tp_methods = XBMCAddon_xbmc_Keyboard_methods;
    PyXBMCAddon_xbmc_Keyboard_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_Keyboard_Type.tp_new = xbmc_XBMCAddon_xbmc_Keyboard_New;

    TyXBMCAddon_xbmc_Keyboard_Type.swigType="p.XBMCAddon::xbmc::Keyboard";  
  }
  //=========================================================================

  static Py_ssize_t xbmc_XBMCAddon_xbmc_PlayList_size_(PyObject* self)
  {
    return (Py_ssize_t)((XBMCAddon::xbmc::PlayList*)retrieveApiInstance(self,&PyXBMCAddon_xbmc_PlayList_Type,"operator []","XBMCAddon::xbmc::PlayList"))-> size();
  }

  //=========================================================================
  // tp_as_mapping struct for XBMCAddon::xbmc::PlayList
  //=========================================================================
  PyMappingMethods xbmc_XBMCAddon_xbmc_PlayList_as_mapping = {
    xbmc_XBMCAddon_xbmc_PlayList_size_,    /* inquiry mp_length;                  __len__ */
    (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_operatorIndex_,   /* binaryfunc mp_subscript             __getitem__ */
    0,                  /* objargproc mp_ass_subscript;     __setitem__ */
  };

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::PlayList
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_PlayList_methods[] = { 
    {(char*)"getPlayListId", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_getPlayListId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"add", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_add, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_add__doc__ }, 
    {(char*)"load", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_load, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_load__doc__ }, 
    {(char*)"remove", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_remove, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_remove__doc__ }, 
    {(char*)"clear", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_clear, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_clear__doc__ }, 
    {(char*)"size", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_size, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_size__doc__ }, 
    {(char*)"shuffle", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_shuffle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_shuffle__doc__ }, 
    {(char*)"unshuffle", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_unshuffle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_unshuffle__doc__ }, 
    {(char*)"getposition", (PyCFunction)xbmc_XBMCAddon_xbmc_PlayList_getposition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_PlayList_getposition__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_PlayList_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_PlayList_Type,&TyXBMCAddon_xbmc_PlayList_Type);

    PyXBMCAddon_xbmc_PlayList_Type.tp_name = (char*)"xbmc.PlayList";
    PyXBMCAddon_xbmc_PlayList_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_PlayList_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_PlayList_Dealloc; 

    PyXBMCAddon_xbmc_PlayList_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_PlayList_Type.tp_doc = NULL;
    PyXBMCAddon_xbmc_PlayList_Type.tp_methods = XBMCAddon_xbmc_PlayList_methods;
    PyXBMCAddon_xbmc_PlayList_Type.tp_as_mapping = &xbmc_XBMCAddon_xbmc_PlayList_as_mapping;
    PyXBMCAddon_xbmc_PlayList_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_PlayList_Type.tp_new = xbmc_XBMCAddon_xbmc_PlayList_New;

    TyXBMCAddon_xbmc_PlayList_Type.swigType="p.XBMCAddon::xbmc::PlayList";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmc::Monitor
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmc_Monitor_methods[] = { 
    {(char*)"onSettingsChanged", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onSettingsChanged, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onSettingsChanged__doc__ }, 
    {(char*)"onScreensaverActivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScreensaverActivated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onScreensaverActivated__doc__ }, 
    {(char*)"onScreensaverDeactivated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onScreensaverDeactivated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onScreensaverDeactivated__doc__ }, 
    {(char*)"onDatabaseUpdated", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onDatabaseUpdated, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onDatabaseUpdated__doc__ }, 
    {(char*)"onAbortRequested", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_onAbortRequested, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmc_Monitor_onAbortRequested__doc__ }, 
    {(char*)"GetId", (PyCFunction)xbmc_XBMCAddon_xbmc_Monitor_GetId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmc_Monitor_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmc_Monitor__doc__,
                 "Monitor class.\n"
"\n"
"Monitor()--Creates a newMonitor to notify addon about changes.\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmc_Monitor_Type,&TyXBMCAddon_xbmc_Monitor_Type);

    PyXBMCAddon_xbmc_Monitor_Type.tp_name = (char*)"xbmc.Monitor";
    PyXBMCAddon_xbmc_Monitor_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmc_Monitor_Type.tp_dealloc = (destructor)xbmc_XBMCAddon_xbmc_Monitor_Dealloc; 

    PyXBMCAddon_xbmc_Monitor_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmc_Monitor_Type.tp_doc = XBMCAddon_xbmc_Monitor__doc__;
    PyXBMCAddon_xbmc_Monitor_Type.tp_methods = XBMCAddon_xbmc_Monitor_methods;
    PyXBMCAddon_xbmc_Monitor_Type.tp_base = NULL;
    PyXBMCAddon_xbmc_Monitor_Type.tp_new = xbmc_XBMCAddon_xbmc_Monitor_New;

    TyXBMCAddon_xbmc_Monitor_Type.swigType="p.XBMCAddon::xbmc::Monitor";  
  }
  //=========================================================================


  static PyMethodDef xbmc_methods[] = { 
    {(char*)"log", (PyCFunction)xbmc_log, METH_VARARGS|METH_KEYWORDS, log__doc__ }, 
    {(char*)"shutdown", (PyCFunction)xbmc_shutdown, METH_VARARGS|METH_KEYWORDS, shutdown__doc__ }, 
    {(char*)"restart", (PyCFunction)xbmc_restart, METH_VARARGS|METH_KEYWORDS, restart__doc__ }, 
    {(char*)"executescript", (PyCFunction)xbmc_executescript, METH_VARARGS|METH_KEYWORDS, executescript__doc__ }, 
    {(char*)"executebuiltin", (PyCFunction)xbmc_executebuiltin, METH_VARARGS|METH_KEYWORDS, executebuiltin__doc__ }, 
    {(char*)"executehttpapi", (PyCFunction)xbmc_executehttpapi, METH_VARARGS|METH_KEYWORDS, executehttpapi__doc__ }, 
    {(char*)"executeJSONRPC", (PyCFunction)xbmc_executeJSONRPC, METH_VARARGS|METH_KEYWORDS, executeJSONRPC__doc__ }, 
    {(char*)"sleep", (PyCFunction)xbmc_sleep, METH_VARARGS|METH_KEYWORDS, sleep__doc__ }, 
    {(char*)"getLocalizedString", (PyCFunction)xbmc_getLocalizedString, METH_VARARGS|METH_KEYWORDS, getLocalizedString__doc__ }, 
    {(char*)"getSkinDir", (PyCFunction)xbmc_getSkinDir, METH_VARARGS|METH_KEYWORDS, getSkinDir__doc__ }, 
    {(char*)"getLanguage", (PyCFunction)xbmc_getLanguage, METH_VARARGS|METH_KEYWORDS, getLanguage__doc__ }, 
    {(char*)"getIPAddress", (PyCFunction)xbmc_getIPAddress, METH_VARARGS|METH_KEYWORDS, getIPAddress__doc__ }, 
    {(char*)"getDVDState", (PyCFunction)xbmc_getDVDState, METH_VARARGS|METH_KEYWORDS, getDVDState__doc__ }, 
    {(char*)"getFreeMem", (PyCFunction)xbmc_getFreeMem, METH_VARARGS|METH_KEYWORDS, getFreeMem__doc__ }, 
    {(char*)"getInfoLabel", (PyCFunction)xbmc_getInfoLabel, METH_VARARGS|METH_KEYWORDS, getInfoLabel__doc__ }, 
    {(char*)"getInfoImage", (PyCFunction)xbmc_getInfoImage, METH_VARARGS|METH_KEYWORDS, getInfoImage__doc__ }, 
    {(char*)"playSFX", (PyCFunction)xbmc_playSFX, METH_VARARGS|METH_KEYWORDS, playSFX__doc__ }, 
    {(char*)"enableNavSounds", (PyCFunction)xbmc_enableNavSounds, METH_VARARGS|METH_KEYWORDS, enableNavSounds__doc__ }, 
    {(char*)"getCondVisibility", (PyCFunction)xbmc_getCondVisibility, METH_VARARGS|METH_KEYWORDS, getCondVisibility__doc__ }, 
    {(char*)"getGlobalIdleTime", (PyCFunction)xbmc_getGlobalIdleTime, METH_VARARGS|METH_KEYWORDS, getGlobalIdleTime__doc__ }, 
    {(char*)"getCacheThumbName", (PyCFunction)xbmc_getCacheThumbName, METH_VARARGS|METH_KEYWORDS, getCacheThumbName__doc__ }, 
    {(char*)"makeLegalFilename", (PyCFunction)xbmc_makeLegalFilename, METH_VARARGS|METH_KEYWORDS, makeLegalFilename__doc__ }, 
    {(char*)"translatePath", (PyCFunction)xbmc_translatePath, METH_VARARGS|METH_KEYWORDS, translatePath__doc__ }, 
    {(char*)"getCleanMovieTitle", (PyCFunction)xbmc_getCleanMovieTitle, METH_VARARGS|METH_KEYWORDS, getCleanMovieTitle__doc__ }, 
    {(char*)"validatePath", (PyCFunction)xbmc_validatePath, METH_VARARGS|METH_KEYWORDS, validatePath__doc__ }, 
    {(char*)"getRegion", (PyCFunction)xbmc_getRegion, METH_VARARGS|METH_KEYWORDS, getRegion__doc__ }, 
    {(char*)"getSupportedMedia", (PyCFunction)xbmc_getSupportedMedia, METH_VARARGS|METH_KEYWORDS, getSupportedMedia__doc__ }, 
    {(char*)"skinHasImage", (PyCFunction)xbmc_skinHasImage, METH_VARARGS|METH_KEYWORDS, skinHasImage__doc__ }, 
    {(char*)"startServer", (PyCFunction)xbmc_startServer, METH_VARARGS|METH_KEYWORDS, startServer__doc__ }, 
    {(char*)"audioSuspend", (PyCFunction)xbmc_audioSuspend, METH_VARARGS|METH_KEYWORDS, audioSuspend__doc__ }, 
    {(char*)"audioResume", (PyCFunction)xbmc_audioResume, METH_VARARGS|METH_KEYWORDS, audioResume__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmc_Player_Type();
      initPyXBMCAddon_xbmc_RenderCapture_Type();
      initPyXBMCAddon_xbmc_InfoTagMusic_Type();
      initPyXBMCAddon_xbmc_InfoTagVideo_Type();
      initPyXBMCAddon_xbmc_Keyboard_Type();
      initPyXBMCAddon_xbmc_PlayList_Type();
      initPyXBMCAddon_xbmc_Monitor_Type();
      if (PyType_Ready(&PyXBMCAddon_xbmc_Player_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmc_RenderCapture_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmc_InfoTagMusic_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmc_InfoTagVideo_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmc_Keyboard_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmc_PlayList_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmc_Monitor_Type) < 0)
        return;
    }
  }

  void initModule_xbmc()
  {
    initTypes();

    // init general xbmc modules
    PyObject* module;


    Py_INCREF(&PyXBMCAddon_xbmc_Player_Type);
    Py_INCREF(&PyXBMCAddon_xbmc_RenderCapture_Type);
    Py_INCREF(&PyXBMCAddon_xbmc_InfoTagMusic_Type);
    Py_INCREF(&PyXBMCAddon_xbmc_InfoTagVideo_Type);
    Py_INCREF(&PyXBMCAddon_xbmc_Keyboard_Type);
    Py_INCREF(&PyXBMCAddon_xbmc_PlayList_Type);
    Py_INCREF(&PyXBMCAddon_xbmc_Monitor_Type);

    module = Py_InitModule((char*)"xbmc", xbmc_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"Player", (PyObject*)&PyXBMCAddon_xbmc_Player_Type);
    PyModule_AddObject(module, (char*)"RenderCapture", (PyObject*)&PyXBMCAddon_xbmc_RenderCapture_Type);
    PyModule_AddObject(module, (char*)"InfoTagMusic", (PyObject*)&PyXBMCAddon_xbmc_InfoTagMusic_Type);
    PyModule_AddObject(module, (char*)"InfoTagVideo", (PyObject*)&PyXBMCAddon_xbmc_InfoTagVideo_Type);
    PyModule_AddObject(module, (char*)"Keyboard", (PyObject*)&PyXBMCAddon_xbmc_Keyboard_Type);
    PyModule_AddObject(module, (char*)"PlayList", (PyObject*)&PyXBMCAddon_xbmc_PlayList_Type);
    PyModule_AddObject(module, (char*)"Monitor", (PyObject*)&PyXBMCAddon_xbmc_Monitor_Type);

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team XBMC <www.xbmc.org>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Mon Dec 24 22:37:33 EST 2012");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team XBMC");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"SERVER_WEBSERVER",(int)getSERVER_WEBSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_AIRPLAYSERVER",(int)getSERVER_AIRPLAYSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_UPNPSERVER",(int)getSERVER_UPNPSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_UPNPRENDERER",(int)getSERVER_UPNPRENDERER()); 
   PyModule_AddIntConstant(module,"SERVER_EVENTSERVER",(int)getSERVER_EVENTSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_JSONRPCSERVER",(int)getSERVER_JSONRPCSERVER()); 
   PyModule_AddIntConstant(module,"SERVER_ZEROCONF",(int)getSERVER_ZEROCONF()); 
   PyModule_AddIntConstant(module,"PLAYLIST_MUSIC",(int)getPLAYLIST_MUSIC()); 
   PyModule_AddIntConstant(module,"PLAYLIST_VIDEO",(int)getPLAYLIST_VIDEO()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_AUTO",(int)getPLAYER_CORE_AUTO()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_DVDPLAYER",(int)getPLAYER_CORE_DVDPLAYER()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_MPLAYER",(int)getPLAYER_CORE_MPLAYER()); 
   PyModule_AddIntConstant(module,"PLAYER_CORE_PAPLAYER",(int)getPLAYER_CORE_PAPLAYER()); 
   PyModule_AddIntConstant(module,"TRAY_OPEN",(int)getTRAY_OPEN()); 
   PyModule_AddIntConstant(module,"DRIVE_NOT_READY",(int)getDRIVE_NOT_READY()); 
   PyModule_AddIntConstant(module,"TRAY_CLOSED_NO_MEDIA",(int)getTRAY_CLOSED_NO_MEDIA()); 
   PyModule_AddIntConstant(module,"TRAY_CLOSED_MEDIA_PRESENT",(int)getTRAY_CLOSED_MEDIA_PRESENT()); 
   PyModule_AddIntConstant(module,"LOGDEBUG",(int)getLOGDEBUG()); 
   PyModule_AddIntConstant(module,"LOGINFO",(int)getLOGINFO()); 
   PyModule_AddIntConstant(module,"LOGNOTICE",(int)getLOGNOTICE()); 
   PyModule_AddIntConstant(module,"LOGWARNING",(int)getLOGWARNING()); 
   PyModule_AddIntConstant(module,"LOGERROR",(int)getLOGERROR()); 
   PyModule_AddIntConstant(module,"LOGSEVERE",(int)getLOGSEVERE()); 
   PyModule_AddIntConstant(module,"LOGFATAL",(int)getLOGFATAL()); 
   PyModule_AddIntConstant(module,"LOGNONE",(int)getLOGNONE()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_WORKING",(int)getCAPTURE_STATE_WORKING()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_DONE",(int)getCAPTURE_STATE_DONE()); 
   PyModule_AddIntConstant(module,"CAPTURE_STATE_FAILED",(int)getCAPTURE_STATE_FAILED()); 
   PyModule_AddIntConstant(module,"CAPTURE_FLAG_CONTINUOUS",(int)getCAPTURE_FLAG_CONTINUOUS()); 
   PyModule_AddIntConstant(module,"CAPTURE_FLAG_IMMEDIATELY",(int)getCAPTURE_FLAG_IMMEDIATELY()); 
  }

} // end PythonBindings namespace for python type definitions

