

/*
 *      Copyright (C) 2005-2012 Team XBMC
 *      http://www.xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmcgui" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/Dialog.h"
#include "interfaces/legacy/ModuleXbmcgui.h"
#include "interfaces/legacy/Control.h"
#include "interfaces/legacy/Window.h"
#include "interfaces/legacy/WindowDialog.h"
#include "interfaces/legacy/Dialog.h"
#include "interfaces/legacy/WindowXML.h"

using namespace XBMCAddon;
using namespace xbmcgui;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif



namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ListItem
  PyTypeObject PyXBMCAddon_xbmcgui_ListItem_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Control
  PyTypeObject PyXBMCAddon_xbmcgui_Control_Type;
  TypeInfo TyXBMCAddon_xbmcgui_Control_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlSpin
  PyTypeObject PyXBMCAddon_xbmcgui_ControlSpin_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlSpin_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlSpin> XBMCAddon_xbmcgui_ControlSpin_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlLabel
  PyTypeObject PyXBMCAddon_xbmcgui_ControlLabel_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlLabel_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlLabel> XBMCAddon_xbmcgui_ControlLabel_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlEdit
  PyTypeObject PyXBMCAddon_xbmcgui_ControlEdit_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlEdit_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlEdit> XBMCAddon_xbmcgui_ControlEdit_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlList
  PyTypeObject PyXBMCAddon_xbmcgui_ControlList_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlList_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlList> XBMCAddon_xbmcgui_ControlList_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlFadeLabel
  PyTypeObject PyXBMCAddon_xbmcgui_ControlFadeLabel_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlFadeLabel_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlFadeLabel> XBMCAddon_xbmcgui_ControlFadeLabel_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlTextBox
  PyTypeObject PyXBMCAddon_xbmcgui_ControlTextBox_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlTextBox_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlTextBox> XBMCAddon_xbmcgui_ControlTextBox_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlImage
  PyTypeObject PyXBMCAddon_xbmcgui_ControlImage_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlImage_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlImage> XBMCAddon_xbmcgui_ControlImage_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlProgress
  PyTypeObject PyXBMCAddon_xbmcgui_ControlProgress_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlProgress_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlProgress> XBMCAddon_xbmcgui_ControlProgress_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlButton
  PyTypeObject PyXBMCAddon_xbmcgui_ControlButton_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlButton_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlButton> XBMCAddon_xbmcgui_ControlButton_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlCheckMark
  PyTypeObject PyXBMCAddon_xbmcgui_ControlCheckMark_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlCheckMark_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlCheckMark> XBMCAddon_xbmcgui_ControlCheckMark_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlGroup
  PyTypeObject PyXBMCAddon_xbmcgui_ControlGroup_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlGroup_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlGroup> XBMCAddon_xbmcgui_ControlGroup_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlRadioButton
  PyTypeObject PyXBMCAddon_xbmcgui_ControlRadioButton_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlRadioButton_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlRadioButton> XBMCAddon_xbmcgui_ControlRadioButton_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlSlider
  PyTypeObject PyXBMCAddon_xbmcgui_ControlSlider_Type;
  TypeInfo TyXBMCAddon_xbmcgui_ControlSlider_Type;
  TypeConverter<XBMCAddon::xbmcgui::Control,XBMCAddon::xbmcgui::ControlSlider> XBMCAddon_xbmcgui_ControlSlider_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Dialog
  PyTypeObject PyXBMCAddon_xbmcgui_Dialog_Type;
  TypeInfo TyXBMCAddon_xbmcgui_Dialog_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::DialogProgress
  PyTypeObject PyXBMCAddon_xbmcgui_DialogProgress_Type;
  TypeInfo TyXBMCAddon_xbmcgui_DialogProgress_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Action
  PyTypeObject PyXBMCAddon_xbmcgui_Action_Type;
  TypeInfo TyXBMCAddon_xbmcgui_Action_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Window
  PyTypeObject PyXBMCAddon_xbmcgui_Window_Type;
  TypeInfo TyXBMCAddon_xbmcgui_Window_Type;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowDialog
  PyTypeObject PyXBMCAddon_xbmcgui_WindowDialog_Type;
  TypeInfo TyXBMCAddon_xbmcgui_WindowDialog_Type;
  TypeConverter<XBMCAddon::xbmcgui::Window,XBMCAddon::xbmcgui::WindowDialog> XBMCAddon_xbmcgui_WindowDialog_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowXML
  PyTypeObject PyXBMCAddon_xbmcgui_WindowXML_Type;
  TypeInfo TyXBMCAddon_xbmcgui_WindowXML_Type;
  TypeConverter<XBMCAddon::xbmcgui::Window,XBMCAddon::xbmcgui::WindowXML> XBMCAddon_xbmcgui_WindowXML_ParentConverter;
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowXMLDialog
  PyTypeObject PyXBMCAddon_xbmcgui_WindowXMLDialog_Type;
  TypeInfo TyXBMCAddon_xbmcgui_WindowXMLDialog_Type;
  TypeConverter<XBMCAddon::xbmcgui::WindowXML,XBMCAddon::xbmcgui::WindowXMLDialog> XBMCAddon_xbmcgui_WindowXMLDialog_ParentConverter;
  //=========================================================================



  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::Window. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_Window_Director : public Director, public XBMCAddon::xbmcgui::Window
  {
    public:

      inline XBMCAddon_xbmcgui_Window_Director(int  existingWindowId ) : XBMCAddon::xbmcgui::Window( existingWindowId ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,&PyXBMCAddon_xbmcgui_Action_Type,&TyXBMCAddon_xbmcgui_Action_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowDialog. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowDialog_Director : public Director, public XBMCAddon::xbmcgui::WindowDialog
  {
    public:

      inline XBMCAddon_xbmcgui_WindowDialog_Director() : XBMCAddon::xbmcgui::WindowDialog() { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,&PyXBMCAddon_xbmcgui_Action_Type,&TyXBMCAddon_xbmcgui_Action_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowXML. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowXML_Director : public Director, public XBMCAddon::xbmcgui::WindowXML
  {
    public:

      inline XBMCAddon_xbmcgui_WindowXML_Director(String const & xmlFilename, String const & scriptPath, String const & defaultSkin, String const & defaultRes ) : XBMCAddon::xbmcgui::WindowXML( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,&PyXBMCAddon_xbmcgui_Action_Type,&TyXBMCAddon_xbmcgui_Action_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowXMLDialog. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowXMLDialog_Director : public Director, public XBMCAddon::xbmcgui::WindowXMLDialog
  {
    public:

      inline XBMCAddon_xbmcgui_WindowXMLDialog_Director(String const & xmlFilename, String const & scriptPath, String const & defaultSkin, String const & defaultRes ) : XBMCAddon::xbmcgui::WindowXMLDialog( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,&PyXBMCAddon_xbmcgui_Action_Type,&TyXBMCAddon_xbmcgui_Action_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  PyDoc_STRVAR(lock__doc__,
               "lock()--Lock the gui until xbmcgui.unlock() is called.\n"
"\n"
"*Note, This will improve performance when doing a lot of gui manipulation at once. The main program (xbmc itself) will freeze until xbmcgui.unlock() is called.\n"
"\n"
"example:\n"
"    - xbmcgui.lock()\n");

  static PyObject* xbmcgui_lock (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcgui::lock(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::lock\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::lock\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(unlock__doc__,
               "unlock()--Unlock the gui from a lock() call.\n"
"\n"
"example:\n"
"    - xbmcgui.unlock()\n");

  static PyObject* xbmcgui_unlock (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcgui::unlock(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::unlock\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::unlock\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getCurrentWindowId__doc__,
               "getCurrentWindowId()--Returns the id for the current 'active' window as an integer.\n"
"\n"
"example:\n"
"    - wid = xbmcgui.getCurrentWindowId()\n");

  static PyObject* xbmcgui_getCurrentWindowId (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmcgui::getCurrentWindowId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getCurrentWindowDialogId__doc__,
               "getCurrentWindowDialogId()--Returns the id for the current 'active' dialog as an integer.\n"
"\n"
"example:\n"
"    - wid = xbmcgui.getCurrentWindowDialogId()\n");

  static PyObject* xbmcgui_getCurrentWindowDialogId (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmcgui::getCurrentWindowDialogId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowDialogId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowDialogId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "label2",
          "iconImage",
          "thumbnailImage",
          "path",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;         
    String  iconImage  = emptyString;
    PyObject* pyiconImage = NULL;         
    String  thumbnailImage  = emptyString;
    PyObject* pythumbnailImage = NULL;         
    String  path  = emptyString;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OOOOO",
       (char**)keywords,
         &pylabel,
         &pylabel2,
         &pyiconImage,
         &pythumbnailImage,
         &pypath
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","XBMCAddon::xbmcgui::ListItem"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","XBMCAddon::xbmcgui::ListItem"); 
      if (pyiconImage) PyXBMCGetUnicodeString(iconImage,pyiconImage,false,"iconImage","XBMCAddon::xbmcgui::ListItem"); 
      if (pythumbnailImage) PyXBMCGetUnicodeString(thumbnailImage,pythumbnailImage,false,"thumbnailImage","XBMCAddon::xbmcgui::ListItem"); 
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","XBMCAddon::xbmcgui::ListItem"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ListItem *)new XBMCAddon::xbmcgui::ListItem(  label,  label2,  iconImage,  thumbnailImage,  path  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ListItem_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getLabel__doc__,
               "getLabel() --Returns the listitem label.\n"
"\n"
"example:\n"
"    - label = self.list.getSelectedItem().getLabel() \n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"getLabel","XBMCAddon::xbmcgui::ListItem"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getLabel2__doc__,
               "getLabel2() --Returns the listitem label.\n"
"\n"
"example:\n"
"    - label = self.list.getSelectedItem().getLabel2() \n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"getLabel2","XBMCAddon::xbmcgui::ListItem"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setLabel__doc__,
               "setLabel(label)--Sets the listitem's label.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setLabel('Casino Royale')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    String  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setLabel","XBMCAddon::xbmcgui::ListItem"))-> setLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setLabel2__doc__,
               "setLabel2(label)--Sets the listitem's label2.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setLabel2('Casino Royale')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    String  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel2"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setLabel2","XBMCAddon::xbmcgui::ListItem"))-> setLabel2(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setIconImage__doc__,
               "setIconImage(icon)--Sets the listitem's icon image.\n"
"\n"
"icon : string - image filename.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setIconImage('emailread.png')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setIconImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "iconImage",
          NULL};
         
    String  iconImage ;
    PyObject* pyiconImage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyiconImage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyiconImage) PyXBMCGetUnicodeString(iconImage,pyiconImage,false,"iconImage","setIconImage"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setIconImage","XBMCAddon::xbmcgui::ListItem"))-> setIconImage(  iconImage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setIconImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setIconImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setThumbnailImage__doc__,
               "setThumbnailImage(thumbFilename)--Sets the listitem's thumbnail image.\n"
"\n"
"thumb : string - image filename.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setThumbnailImage('emailread.png')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setThumbnailImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "thumbFilename",
          NULL};
         
    String  thumbFilename ;
    PyObject* pythumbFilename = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pythumbFilename
       ))
    {
      return NULL;
    }


    try
    {
      if (pythumbFilename) PyXBMCGetUnicodeString(thumbFilename,pythumbFilename,false,"thumbFilename","setThumbnailImage"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setThumbnailImage","XBMCAddon::xbmcgui::ListItem"))-> setThumbnailImage(  thumbFilename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setThumbnailImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setThumbnailImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_select__doc__,
               "select(selected)--Sets the listitem's selected status.\n"
"\n"
"selected : bool - True=selected/False=not selected\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().select(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_select (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"select","XBMCAddon::xbmcgui::ListItem"))-> select(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"select\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"select\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_isSelected__doc__,
               "isSelected() --Returns the listitem's selected status.\n"
"\n"
"example:\n"
"    - is = self.list.getSelectedItem().isSelected() \n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"isSelected","XBMCAddon::xbmcgui::ListItem"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setInfo__doc__,
               "setInfo(type, infoLabels)--Sets the listitem's infoLabels.\n"
"\n"
"type : string - type of media(video/music/pictures). infoLabels : dictionary - pairs of { label: value }.\n"
"\n"
"*Note, To set pictures exif info, prepend 'exif:' to the label. Exif values must be passed as strings, separate value pairs with a comma. (eg. {'exif:resolution': '720,480'} See CPictureInfoTag::TranslateString in PictureInfoTag.cpp for valid strings.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"General Values that apply to all types: count : integer (12) - can be used to store an id for later, or for sorting purposes size : long (1024) - size in bytes date : string (d.m.Y / 01.01.2009) - file date\n"
"\n"
"Video Values: genre : string (Comedy) year : integer (2009) episode : integer (4) season : integer (1) top250 : integer (192) tracknumber : integer (3) rating : float (6.4) - range is 0..10 watched : depreciated - use playcount instead playcount : integer (2) - number of times this item has been played overlay : integer (2) - range is 0..8. See GUIListItem.h for values cast : list (Michal C. Hall) castandrole : list (Michael C. Hall|Dexter) director : string (Dagur Kari) mpaa : string (PG-13) plot : string (Long Description) plotoutline : string (Short Description) title : string (Big Fan) originaltitle : string (Big Fan) sorttitle : string (Big Fan) duration : string (3:18) studio : string (Warner Bros.) tagline : string (An awesome movie) - short description of movie writer : string (Robert D. Siegel) tvshowtitle : string (Heroes) premiered : string (2005-03-04) status : string (Continuing) - status of a TVshow code : string (tt0110293) - IMDb code aired : string (2008-12-07) credits : string (Andy Kaufman) - writing credits lastplayed : string (Y-m-d h:m:s = 2009-04-05 23:16:04) album : string (The Joshua Tree) artist : list (['U2']) votes : string (12345 votes) trailer : string (/home/user/trailer.avi) dateadded : string (Y-m-d h:m:s = 2009-04-05 23:16:04)\n"
"\n"
"Music Values: tracknumber : integer (8) duration : integer (245) - duration in seconds year : integer (1998) genre : string (Rock) album : string (Pulse) artist : string (Muse) title : string (American Pie) rating : string (3) - single character between 0 and 5 lyrics : string (On a dark desert highway...) playcount : integer (2) - number of times this item has been played lastplayed : string (Y-m-d h:m:s = 2009-04-05 23:16:04)\n"
"\n"
"Picture Values: title : string (In the last summer-1) picturepath : string (/home/username/pictures/img001.jpg) exif* : string (See CPictureInfoTag::TranslateString in PictureInfoTag.cpp for valid strings)\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setInfo('video', { 'Genre': 'Comedy' })\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setInfo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "type",
          "infoLabels",
          NULL};
         
    char * type ;         
    Dictionary  infoLabels ;
    PyObject* pyinfoLabels = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &type,
         &pyinfoLabels
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pyinfoLabels, &pos, &pykey, &pyvalue))
      {
        CStdString key;
        CStdString value;
        PyXBMCGetUnicodeString(key,pykey,false,"infoLabels","setInfo");
        PyXBMCGetUnicodeString(value,pyvalue,true,"infoLabels","setInfo");
        infoLabels[key] = value;
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setInfo","XBMCAddon::xbmcgui::ListItem"))-> setInfo(  type,  infoLabels  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setInfo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setInfo\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_addStreamInfo__doc__,
               "addStreamInfo(type, values)--Add a stream with details.\n"
"\n"
"type : string - type of stream(video/audio/subtitle). values : dictionary - pairs of { label: value }.\n"
"\n"
"Video Values: codec : string (h264) aspect : float (1.78) width : integer (1280) height : integer (720) duration : integer (seconds)\n"
"\n"
"Audio Values: codec : string (dts) language : string (en) channels : integer (2)\n"
"\n"
"Subtitle Values: language : string (en)\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().addStreamInfo('video', { 'Codec': 'h264', 'Width' : 1280 })\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_addStreamInfo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "cType",
          "dictionary",
          NULL};
         
    char * cType ;         
    Dictionary  dictionary ;
    PyObject* pydictionary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &cType,
         &pydictionary
       ))
    {
      return NULL;
    }


    try
    {
      
    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pydictionary, &pos, &pykey, &pyvalue))
      {
        CStdString key;
        CStdString value;
        PyXBMCGetUnicodeString(key,pykey,false,"dictionary","addStreamInfo");
        PyXBMCGetUnicodeString(value,pyvalue,true,"dictionary","addStreamInfo");
        dictionary[key] = value;
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"addStreamInfo","XBMCAddon::xbmcgui::ListItem"))-> addStreamInfo(  cType,  dictionary  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addStreamInfo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addStreamInfo\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_addContextMenuItems__doc__,
               "addContextMenuItems([(label, action,)*], replaceItems)--Adds item(s) to the context menu for media lists.\n"
"\n"
"items : list - [(label, action,)*] A list of tuples consisting of label and action pairs.\n"
"    - label : string or unicode - item's label.\n"
"    - action : string or unicode - any built-in function to perform. replaceItems : [opt] bool - True=only your items will show/False=your items will be added to context menu(Default).\n"
"\n"
"\n"
"List of functions -http://wiki.xbmc.org/?title=List_of_Built_In_Functions \n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - listitem.addContextMenuItems([('Theater Showtimes', 'XBMC.RunScript(special://home/scripts/showtimes/default.py,Iron Man)',)])\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_addContextMenuItems (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "items",
          "replaceItems",
          NULL};
         
    std::vector< Tuple< String ,String  >  >  items ;
    PyObject* pyitems = NULL;         
    bool  replaceItems  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyitems,
         &replaceItems
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"items\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Tuple< String ,String  >  entry1;
        

    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"entry1\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        String  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","addContextMenuItems");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        String  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","addContextMenuItems");
        entry1.second() = entry1_2;
      }

    }

        items.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"addContextMenuItems","XBMCAddon::xbmcgui::ListItem"))-> addContextMenuItems(  items,  replaceItems  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addContextMenuItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addContextMenuItems\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setProperty__doc__,
               "setProperty(key, value)--Sets a listitem property, similar to an infolabel.\n"
"\n"
"key : string - property name. value : string or unicode - value of property.\n"
"\n"
"*Note, Key is NOT case sensitive. You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"Some of these are treated internally by XBMC, such as the 'StartOffset' property, which is the offset in seconds at which to start playback of an item. Others may be used in the skin to add extra information, such as 'WatchedCount' for tvshow items\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setProperty('AspectRatio', '1.85 : 1')\n"
"    - self.list.getSelectedItem().setProperty('StartOffset', '256.4')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "key",
          "value",
          NULL};
         
    char * key ;         
    String  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","setProperty"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setProperty","XBMCAddon::xbmcgui::ListItem"))-> setProperty(  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getProperty__doc__,
               "getProperty(key)--Returns a listitem property as a string, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"\n"
"*Note, Key is NOT case sensitive. You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - AspectRatio = self.list.getSelectedItem().getProperty('AspectRatio')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"getProperty","XBMCAddon::xbmcgui::ListItem"))-> getProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setPath__doc__,
               "addContextMenuItems([(label, action,)*], replaceItems)--Adds item(s) to the context menu for media lists.\n"
"\n"
"items : list - [(label, action,)*] A list of tuples consisting of label and action pairs.\n"
"    - label : string or unicode - item's label.\n"
"    - action : string or unicode - any built-in function to perform. replaceItems : [opt] bool - True=only your items will show/False=your items will be added to context menu(Default).\n"
"\n"
"\n"
"List of functions -http://wiki.xbmc.org/?title=List_of_Built_In_Functions \n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - listitem.addContextMenuItems([('Theater Showtimes', 'XBMC.RunScript(special://home/scripts/showtimes/default.py,Iron Man)',)]) setPath(path)--Sets the listitem's path.\n"
"\n"
"\n"
"path : string or unicode - path, activated when item is clicked.\n"
"\n"
"*Note, You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setPath(path='ActivateWindow(Weather)')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    String  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }


    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","setPath"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setPath","XBMCAddon::xbmcgui::ListItem"))-> setPath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPath\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setMimeType__doc__,
               "setMimeType(mimetype)--Sets the listitem's mimetype if known.\n"
"\n"
"mimetype : string or unicode - mimetype.\n"
"\n"
"*If known prehand, this can avoid xbmc doing HEAD requests to http servers to figure out file type.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setMimeType (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "mimetype",
          NULL};
         
    String  mimetype ;
    PyObject* pymimetype = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pymimetype
       ))
    {
      return NULL;
    }


    try
    {
      if (pymimetype) PyXBMCGetUnicodeString(mimetype,pymimetype,false,"mimetype","setMimeType"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"setMimeType","XBMCAddon::xbmcgui::ListItem"))-> setMimeType(  mimetype  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setMimeType\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setMimeType\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getdescription__doc__,
               "getdescription() --Returns the description of this PlayListItem.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getdescription (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"getdescription","XBMCAddon::xbmcgui::ListItem"))-> getdescription(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getdescription\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getdescription\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getduration__doc__,
               "getduration() --Returns the duration of this PlayListItem\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getduration (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"getduration","XBMCAddon::xbmcgui::ListItem"))-> getduration(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getduration\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getduration\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getfilename__doc__,
               "getfilename() --Returns the filename of this PlayListItem.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getfilename (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"getfilename","XBMCAddon::xbmcgui::ListItem"))-> getfilename(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getfilename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getfilename\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "classname",
          NULL};
         
    char * classname ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &classname
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Control *)new XBMCAddon::xbmcgui::Control(  classname  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Control\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Control\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_Control_Type,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_canAcceptMessages (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "actionId",
          NULL};
         
    int  actionId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &actionId
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"canAcceptMessages","XBMCAddon::xbmcgui::Control"))-> canAcceptMessages(  actionId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"canAcceptMessages\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"canAcceptMessages\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setLabel","XBMCAddon::xbmcgui::Control"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"reset","XBMCAddon::xbmcgui::Control"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setSelected","XBMCAddon::xbmcgui::Control"))-> setSelected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setPercent","XBMCAddon::xbmcgui::Control"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setDisabledColor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "color",
          NULL};
         
    char * color ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &color
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setDisabledColor","XBMCAddon::xbmcgui::Control"))-> setDisabledColor(  color  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDisabledColor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDisabledColor\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getPercent","XBMCAddon::xbmcgui::Control"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getLabel","XBMCAddon::xbmcgui::Control"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getText","XBMCAddon::xbmcgui::Control"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"size","XBMCAddon::xbmcgui::Control"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setTextures (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "upFocus",
          "downFocus",
          NULL};
         
    char * up ;         
    char * down ;         
    char * upFocus ;         
    char * downFocus ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ssss",
       (char**)keywords,
         &up,
         &down,
         &upFocus,
         &downFocus
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setTextures","XBMCAddon::xbmcgui::Control"))-> setTextures(  up,  down,  upFocus,  downFocus  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setTextures\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setTextures\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    String  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setText","XBMCAddon::xbmcgui::Control"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setStaticContent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::ListItem * > * items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"items\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      items = new std::vector<XBMCAddon::xbmcgui::ListItem *>();
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        XBMCAddon::xbmcgui::ListItem * entry1;
        entry1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","setStaticContent");
        items->push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setStaticContent","XBMCAddon::xbmcgui::Control"))-> setStaticContent(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setStaticContent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setStaticContent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "space",
          NULL};
         
    int  space ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &space
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setSpace","XBMCAddon::xbmcgui::Control"))-> setSpace(  space  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSpace\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setRadioDimension (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setRadioDimension","XBMCAddon::xbmcgui::Control"))-> setRadioDimension(  x,  y,  width,  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setRadioDimension\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setRadioDimension\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setPageControlVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setPageControlVisible","XBMCAddon::xbmcgui::Control"))-> setPageControlVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPageControlVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPageControlVisible\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setItemHeight","XBMCAddon::xbmcgui::Control"))-> setItemHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setItemHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setImageDimensions (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "imageWidth",
          "imageHeight",
          NULL};
         
    long  imageWidth ;         
    long  imageHeight ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &imageWidth,
         &imageHeight
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setImageDimensions","XBMCAddon::xbmcgui::Control"))-> setImageDimensions(  imageWidth,  imageHeight  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImageDimensions\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImageDimensions\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "imageFilename",
          NULL};
         
    char * imageFilename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &imageFilename
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setImage","XBMCAddon::xbmcgui::Control"))-> setImage(  imageFilename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setColorDiffuse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "hexString",
          NULL};
         
    char * hexString ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &hexString
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setColorDiffuse","XBMCAddon::xbmcgui::Control"))-> setColorDiffuse(  hexString  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setColorDiffuse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setColorDiffuse\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_selectItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "item",
          NULL};
         
    long  item ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &item
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"selectItem","XBMCAddon::xbmcgui::Control"))-> selectItem(  item  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"selectItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"selectItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_scroll (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    long  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"scroll","XBMCAddon::xbmcgui::Control"))-> scroll(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"scroll\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"scroll\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"isSelected","XBMCAddon::xbmcgui::Control"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getSpinControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getSpinControl","XBMCAddon::xbmcgui::Control"))-> getSpinControl(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpinControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpinControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getSpace","XBMCAddon::xbmcgui::Control"))-> getSpace(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpace\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getSelectedPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getSelectedPosition","XBMCAddon::xbmcgui::Control"))-> getSelectedPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getSelectedItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getSelectedItem","XBMCAddon::xbmcgui::Control"))-> getSelectedItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getSelected","XBMCAddon::xbmcgui::Control"))-> getSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "index",
          NULL};
         
    int  index ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &index
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getListItem","XBMCAddon::xbmcgui::Control"))-> getListItem(  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getLabel2","XBMCAddon::xbmcgui::Control"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getItemHeight","XBMCAddon::xbmcgui::Control"))-> getItemHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getItemHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_addLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    String  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","addLabel"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"addLabel","XBMCAddon::xbmcgui::Control"))-> addLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_addItemStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "fileOrUrl",
          "sendMessage",
          NULL};
         
    String  fileOrUrl ;
    PyObject* pyfileOrUrl = NULL;         
    bool  sendMessage  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyfileOrUrl,
         &sendMessage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyfileOrUrl) PyXBMCGetUnicodeString(fileOrUrl,pyfileOrUrl,false,"fileOrUrl","addItemStream"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"addItemStream","XBMCAddon::xbmcgui::Control"))-> addItemStream(  fileOrUrl,  sendMessage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItemStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItemStream\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_addListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "listitem",
          "sendMessage",
          NULL};
         
    XBMCAddon::xbmcgui::ListItem * listitem ;
    PyObject* pylistitem = NULL;         
    bool  sendMessage  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pylistitem,
         &sendMessage
       ))
    {
      return NULL;
    }


    try
    {
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addListItem"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"addListItem","XBMCAddon::xbmcgui::Control"))-> addListItem(  listitem,  sendMessage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getId__doc__,
               "getId() --Returns the control's current id as an integer.\n"
"\n"
"example:\n"
"    - id = self.button.getId()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getId","XBMCAddon::xbmcgui::Control"))-> getId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 




  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getPosition__doc__,
               "getPosition() --Returns the control's current position as a x,y integer tuple.\n"
"\n"
"example:\n"
"    - pos = self.button.getPosition()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    std::vector< int  >  apiResult;
    try
    {

      apiResult = (std::vector< int  > )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getPosition","XBMCAddon::xbmcgui::Control"))-> getPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    result = PyList_New(0);

      for (std::vector<int >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        int & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = Py_BuildValue((char*)"i", entry1);
        PyList_Append(result, pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getX (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getX","XBMCAddon::xbmcgui::Control"))-> getX(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getX\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getY (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getY","XBMCAddon::xbmcgui::Control"))-> getY(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getY\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getY\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getHeight__doc__,
               "getHeight() --Returns the control's current height as an integer.\n"
"\n"
"example:\n"
"    - height = self.button.getHeight()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getHeight","XBMCAddon::xbmcgui::Control"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getWidth__doc__,
               "getWidth() --Returns the control's current width as an integer.\n"
"\n"
"example:\n"
"    - width = self.button.getWidth()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"getWidth","XBMCAddon::xbmcgui::Control"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setEnabled__doc__,
               "setEnabled(enabled)--Set's the control's enabled/disabled state.\n"
"\n"
"enabled : bool - True=enabled / False=disabled.\n"
"\n"
"example:\n"
"    - self.button.setEnabled(False)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setEnabled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "enabled",
          NULL};
         
    bool  enabled ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &enabled
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setEnabled","XBMCAddon::xbmcgui::Control"))-> setEnabled(  enabled  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setEnabled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setEnabled\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setVisible__doc__,
               "setVisible(visible)--Set's the control's visible/hidden state.\n"
"\n"
"visible : bool - True=visible / False=hidden.\n"
"\n"
"example:\n"
"    - self.button.setVisible(False)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setVisible","XBMCAddon::xbmcgui::Control"))-> setVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setVisible\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setVisibleCondition__doc__,
               "setVisibleCondition(visible[,allowHiddenFocus])--Set's the control's visible condition. Allows XBMC to control the visible status of the control.\n"
"\n"
"visible : string - Visible condition. allowHiddenFocus : bool - True=gains focus even if hidden.\n"
"\n"
"List of Conditions -http://wiki.xbmc.org/index.php?title=List_of_Boolean_Conditions \n"
"\n"
"example:\n"
"    - self.button.setVisibleCondition('[Control.IsVisible(41) + !Control.IsVisible(12)]', True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setVisibleCondition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "visible",
          "allowHiddenFocus",
          NULL};
         
    char * visible ;         
    bool  allowHiddenFocus  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &visible,
         &allowHiddenFocus
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setVisibleCondition","XBMCAddon::xbmcgui::Control"))-> setVisibleCondition(  visible,  allowHiddenFocus  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setVisibleCondition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setVisibleCondition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setEnableCondition__doc__,
               "setEnableCondition(enable)--Set's the control's enabled condition. Allows XBMC to control the enabled status of the control.\n"
"\n"
"enable : string - Enable condition.\n"
"\n"
"List of Conditions -http://wiki.xbmc.org/index.php?title=List_of_Boolean_Conditions \n"
"\n"
"example:\n"
"    - self.button.setEnableCondition('System.InternetState')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setEnableCondition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "enable",
          NULL};
         
    char * enable ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &enable
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setEnableCondition","XBMCAddon::xbmcgui::Control"))-> setEnableCondition(  enable  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setEnableCondition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setEnableCondition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setAnimations__doc__,
               "setAnimations([(event, attr,)*])--Set's the control's animations.\n"
"\n"
"[(event,attr,)*] : list - A list of tuples consisting of event and attributes pairs.\n"
"    - event : string - The event to animate.\n"
"    - attr : string - The whole attribute string separated by spaces.\n"
"\n"
"\n"
"Animating your skin -http://wiki.xbmc.org/?title=Animating_Your_Skin \n"
"\n"
"example:\n"
"    - self.button.setAnimations([('focus', 'effect=zoom end=90,247,220,56 time=0',)])\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setAnimations (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "eventAttr",
          NULL};
         
    std::vector< Tuple< String ,String  >  >  eventAttr ;
    PyObject* pyeventAttr = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyeventAttr
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyeventAttr,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyeventAttr,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"eventAttr\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyeventAttr) : PyList_Size(pyeventAttr));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyeventAttr, i) : PyList_GetItem(pyeventAttr, i));
        Tuple< String ,String  >  entry1;
        

    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"entry1\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        String  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","setAnimations");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        String  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","setAnimations");
        entry1.second() = entry1_2;
      }

    }

        eventAttr.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setAnimations","XBMCAddon::xbmcgui::Control"))-> setAnimations(  eventAttr  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setAnimations\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setAnimations\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setPosition__doc__,
               "setPosition(x, y)--Set's the controls position.\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control.\n"
"\n"
"*Note, You may use negative integers. (e.g sliding a control into view)\n"
"\n"
"example:\n"
"    - self.button.setPosition(100, 250)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          NULL};
         
    long  x ;         
    long  y ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &x,
         &y
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setPosition","XBMCAddon::xbmcgui::Control"))-> setPosition(  x,  y  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setWidth__doc__,
               "setWidth(width)--Set's the controls width.\n"
"\n"
"width : integer - width of control.\n"
"\n"
"example:\n"
"    - self.image.setWidth(100)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "width",
          NULL};
         
    long  width ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &width
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setWidth","XBMCAddon::xbmcgui::Control"))-> setWidth(  width  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setHeight__doc__,
               "setHeight(height)--Set's the controls height.\n"
"\n"
"height : integer - height of control.\n"
"\n"
"example:\n"
"    - self.image.setHeight(100)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setHeight","XBMCAddon::xbmcgui::Control"))-> setHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setNavigation__doc__,
               "setNavigation(up, down, left, right)--Set's the controls navigation.\n"
"\n"
"up : control object - control to navigate to on up. down : control object - control to navigate to on down. left : control object - control to navigate to on left. right : control object - control to navigate to on right.\n"
"\n"
"*Note, Same ascontrolUp() ,controlDown() ,controlLeft() ,controlRight() . Set to self to disable navigation for that direction.\n"
"\n"
"Throws: TypeError, if one of the supplied arguments is not a control type. ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"example:\n"
"    - self.button.setNavigation(self.button1, self.button2, self.button3, self.button4)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setNavigation (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "left",
          "right",
          NULL};
         
    XBMCAddon::xbmcgui::Control * up ;
    PyObject* pyup = NULL;         
    XBMCAddon::xbmcgui::Control * down ;
    PyObject* pydown = NULL;         
    XBMCAddon::xbmcgui::Control * left ;
    PyObject* pyleft = NULL;         
    XBMCAddon::xbmcgui::Control * right ;
    PyObject* pyright = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OOOO",
       (char**)keywords,
         &pyup,
         &pydown,
         &pyleft,
         &pyright
       ))
    {
      return NULL;
    }


    try
    {
      up = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyup,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      down = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pydown,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      left = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyleft,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      right = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyright,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"setNavigation","XBMCAddon::xbmcgui::Control"))-> setNavigation(  up,  down,  left,  right  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setNavigation\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setNavigation\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlUp__doc__,
               "controlUp(control)--Set's the controls up navigation.\n"
"\n"
"control : control object - control to navigate to on up.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws: TypeError, if one of the supplied arguments is not a control type. ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"example:\n"
"    - self.button.controlUp(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlUp (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "up",
          NULL};
         
    XBMCAddon::xbmcgui::Control * up ;
    PyObject* pyup = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyup
       ))
    {
      return NULL;
    }


    try
    {
      up = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyup,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlUp"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"controlUp","XBMCAddon::xbmcgui::Control"))-> controlUp(  up  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlUp\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlUp\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlDown__doc__,
               "controlDown(control)--Set's the controls down navigation.\n"
"\n"
"control : control object - control to navigate to on down.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws: TypeError, if one of the supplied arguments is not a control type. ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"example:\n"
"    - self.button.controlDown(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlDown (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlDown"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"controlDown","XBMCAddon::xbmcgui::Control"))-> controlDown(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlDown\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlDown\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlLeft__doc__,
               "controlLeft(control)--Set's the controls left navigation.\n"
"\n"
"control : control object - control to navigate to on left.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws: TypeError, if one of the supplied arguments is not a control type. ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"example:\n"
"    - self.button.controlLeft(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlLeft (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlLeft"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"controlLeft","XBMCAddon::xbmcgui::Control"))-> controlLeft(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlLeft\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlLeft\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlRight__doc__,
               "controlRight(control)--Set's the controls right navigation.\n"
"\n"
"control : control object - control to navigate to on right.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws: TypeError, if one of the supplied arguments is not a control type. ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"example:\n"
"    - self.button.controlRight(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlRight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlRight"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"controlRight","XBMCAddon::xbmcgui::Control"))-> controlRight(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlRight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlRight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSpin_setTextures__doc__,
               "setTextures(up, down, upFocus, downFocus)--Set's textures for this control.\n"
"\n"
"texture are image files that are used for example in the skin\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSpin_setTextures (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "upFocus",
          "downFocus",
          NULL};
         
    char * up ;         
    char * down ;         
    char * upFocus ;         
    char * downFocus ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ssss",
       (char**)keywords,
         &up,
         &down,
         &upFocus,
         &downFocus
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlSpin*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlSpin_Type,"setTextures","XBMCAddon::xbmcgui::ControlSpin"))-> setTextures(  up,  down,  upFocus,  downFocus  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setTextures\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setTextures\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 


  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "font",
          "textColor",
          "disabledColor",
          "alignment",
          "hasPath",
          "angle",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    String  label ;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  alignment  = XBFONT_LEFT;         
    bool  hasPath  = false;         
    long  angle  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|ssslbl",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &alignment,
         &hasPath,
         &angle
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlLabel * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","XBMCAddon::xbmcgui::ControlLabel"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlLabel *)new XBMCAddon::xbmcgui::ControlLabel(  x,  y,  width,  height,  label,  font,  textColor,  disabledColor,  alignment,  hasPath,  angle  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlLabel_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlLabel_getLabel__doc__,
               "getLabel() --Returns the text value for this label.\n"
"\n"
"example:\n"
"    - label = self.label.getLabel()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlLabel_Type,"getLabel","XBMCAddon::xbmcgui::ControlLabel"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlLabel_setLabel__doc__,
               "setLabel(label)--Set's text for this label.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.label.setLabel('Status')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlLabel_Type,"setLabel","XBMCAddon::xbmcgui::ControlLabel"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "font",
          "textColor",
          "disabledColor",
          "_alignment",
          "focusTexture",
          "noFocusTexture",
          "isPassword",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    String  label ;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  _alignment  = XBFONT_LEFT;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    bool  isPassword  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|ssslssb",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &_alignment,
         &focusTexture,
         &noFocusTexture,
         &isPassword
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlEdit * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","XBMCAddon::xbmcgui::ControlEdit"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlEdit *)new XBMCAddon::xbmcgui::ControlEdit(  x,  y,  width,  height,  label,  font,  textColor,  disabledColor,  _alignment,  focusTexture,  noFocusTexture,  isPassword  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlEdit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlEdit\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlEdit_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_setLabel__doc__,
               "setLabel(label)--Set's text heading for this edit control.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.edit.setLabel('Status')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlEdit_Type,"setLabel","XBMCAddon::xbmcgui::ControlEdit"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_getLabel__doc__,
               "getLabel() --Returns the text heading for this edit control.\n"
"\n"
"example:\n"
"    - label = self.edit.getLabel()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlEdit_Type,"getLabel","XBMCAddon::xbmcgui::ControlEdit"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_setText__doc__,
               "setText(value)--Set's text value for this edit control.\n"
"\n"
"value : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.edit.setText('online')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    String  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlEdit_Type,"setText","XBMCAddon::xbmcgui::ControlEdit"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_getText__doc__,
               "getText() --Returns the text value for this edit control.\n"
"\n"
"example:\n"
"    - value = self.edit.getText()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlEdit_Type,"getText","XBMCAddon::xbmcgui::ControlEdit"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          "buttonTexture",
          "buttonFocusTexture",
          "selectedColor",
          "_imageWidth",
          "_imageHeight",
          "_itemTextXOffset",
          "_itemTextYOffset",
          "_itemHeight",
          "_space",
          "_alignmentY",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * buttonTexture  = NULL;         
    char * buttonFocusTexture  = NULL;         
    char * selectedColor  = NULL;         
    long  _imageWidth  = 10;         
    long  _imageHeight  = 10;         
    long  _itemTextXOffset  = 10;         
    long  _itemTextYOffset  = 2;         
    long  _itemHeight  = 27;         
    long  _space  = 2;         
    long  _alignmentY  = XBFONT_CENTER_Y;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ssssslllllll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor,
         &buttonTexture,
         &buttonFocusTexture,
         &selectedColor,
         &_imageWidth,
         &_imageHeight,
         &_itemTextXOffset,
         &_itemTextYOffset,
         &_itemHeight,
         &_space,
         &_alignmentY
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlList * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlList *)new XBMCAddon::xbmcgui::ControlList(  x,  y,  width,  height,  font,  textColor,  buttonTexture,  buttonFocusTexture,  selectedColor,  _imageWidth,  _imageHeight,  _itemTextXOffset,  _itemTextYOffset,  _itemHeight,  _space,  _alignmentY  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlList\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlList_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_addItemStream__doc__,
               "addItem(item)--Add a new item to this list control.\n"
"\n"
"item : string, unicode orListItem - item to add.\n"
"\n"
"example:\n"
"    - cList.addItem('Reboot XBMC')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_addItemStream (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "fileOrUrl",
          "sendMessage",
          NULL};
         
    String  fileOrUrl ;
    PyObject* pyfileOrUrl = NULL;         
    bool  sendMessage  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyfileOrUrl,
         &sendMessage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyfileOrUrl) PyXBMCGetUnicodeString(fileOrUrl,pyfileOrUrl,false,"fileOrUrl","addItemStream"); 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"addItemStream","XBMCAddon::xbmcgui::ControlList"))-> addItemStream(  fileOrUrl,  sendMessage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItemStream\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItemStream\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_addListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "listitem",
          "sendMessage",
          NULL};
         
    XBMCAddon::xbmcgui::ListItem * listitem ;
    PyObject* pylistitem = NULL;         
    bool  sendMessage  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pylistitem,
         &sendMessage
       ))
    {
      return NULL;
    }


    try
    {
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addListItem"); 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"addListItem","XBMCAddon::xbmcgui::ControlList"))-> addListItem(  listitem,  sendMessage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_selectItem__doc__,
               "selectItem(item)--Select an item by index number.\n"
"\n"
"item : integer - index number of the item to select.\n"
"\n"
"example:\n"
"    - cList.selectItem(12)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_selectItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "item",
          NULL};
         
    long  item ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &item
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"selectItem","XBMCAddon::xbmcgui::ControlList"))-> selectItem(  item  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"selectItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"selectItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_reset__doc__,
               "reset() --Clear all ListItems in this control list.\n"
"\n"
"example:\n"
"    - cList.reset()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"reset","XBMCAddon::xbmcgui::ControlList"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSpinControl__doc__,
               "getSpinControl() --returns the associatedControlSpin object.\n"
"\n"
"*Note, Not working completely yet - After adding this control list to a window it is not possible to change the settings of this spin control.\n"
"\n"
"example:\n"
"    - ctl = cList.getSpinControl()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpinControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"getSpinControl","XBMCAddon::xbmcgui::ControlList"))-> getSpinControl(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpinControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpinControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSelectedPosition__doc__,
               "getSelectedPosition() --Returns the position of the selected item as an integer.\n"
"\n"
"*Note, Returns -1 for empty lists.\n"
"\n"
"example:\n"
"    - pos = cList.getSelectedPosition()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"getSelectedPosition","XBMCAddon::xbmcgui::ControlList"))-> getSelectedPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSelectedItem__doc__,
               "getSelectedItem() --Returns the selected item as aListItem object.\n"
"\n"
"*Note, Same asgetSelectedPosition() , but instead of an integer aListItem object is returned. Returns None for empty lists. See windowexample.py on how to use this.\n"
"\n"
"example:\n"
"    - item = cList.getSelectedItem()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"getSelectedItem","XBMCAddon::xbmcgui::ControlList"))-> getSelectedItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setImageDimensions__doc__,
               "setImageDimensions(imageWidth, imageHeight)--Sets the width/height of items icon or thumbnail.\n"
"\n"
"imageWidth : [opt] integer - width of items icon or thumbnail. imageHeight : [opt] integer - height of items icon or thumbnail.\n"
"\n"
"example:\n"
"    - cList.setImageDimensions(18, 18)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setImageDimensions (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "imageWidth",
          "imageHeight",
          NULL};
         
    long  imageWidth ;         
    long  imageHeight ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &imageWidth,
         &imageHeight
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"setImageDimensions","XBMCAddon::xbmcgui::ControlList"))-> setImageDimensions(  imageWidth,  imageHeight  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImageDimensions\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImageDimensions\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setItemHeight__doc__,
               "setItemHeight(itemHeight)--Sets the height of items.\n"
"\n"
"itemHeight : integer - height of items.\n"
"\n"
"example:\n"
"    - cList.setItemHeight(25)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"setItemHeight","XBMCAddon::xbmcgui::ControlList"))-> setItemHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setItemHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setSpace__doc__,
               "setSpace(space)--Set's the space between items.\n"
"\n"
"space : [opt] integer - space between items.\n"
"\n"
"example:\n"
"    - cList.setSpace(5)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "space",
          NULL};
         
    int  space ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &space
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"setSpace","XBMCAddon::xbmcgui::ControlList"))-> setSpace(  space  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSpace\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setPageControlVisible__doc__,
               "setPageControlVisible(visible)--Sets the spin control's visible/hidden state.\n"
"\n"
"visible : boolean - True=visible / False=hidden.\n"
"\n"
"example:\n"
"    - cList.setPageControlVisible(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setPageControlVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"setPageControlVisible","XBMCAddon::xbmcgui::ControlList"))-> setPageControlVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPageControlVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPageControlVisible\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_size__doc__,
               "size() --Returns the total number of items in this list control as an integer.\n"
"\n"
"example:\n"
"    - cnt = cList.size()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"size","XBMCAddon::xbmcgui::ControlList"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getItemHeight__doc__,
               "getItemHeight() --Returns the control's current item height as an integer.\n"
"\n"
"example:\n"
"    - item_height = self.cList.getItemHeight()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"getItemHeight","XBMCAddon::xbmcgui::ControlList"))-> getItemHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getItemHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSpace__doc__,
               "getSpace() --Returns the control's space between items as an integer.\n"
"\n"
"example:\n"
"    - gap = self.cList.getSpace()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"getSpace","XBMCAddon::xbmcgui::ControlList"))-> getSpace(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpace\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getListItem__doc__,
               "getListItem(index)--Returns a givenListItem in thisList .\n"
"\n"
"index : integer - index number of item to return.\n"
"\n"
"*Note, throws a ValueError if index is out of range.\n"
"\n"
"example:\n"
"    - listitem = cList.getListItem(6)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "index",
          NULL};
         
    int  index ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &index
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"getListItem","XBMCAddon::xbmcgui::ControlList"))-> getListItem(  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setStaticContent__doc__,
               "setStaticContent(items)--Fills a static list with a list of listitems.\n"
"\n"
"items :List - list of listitems to add.\n"
"\n"
"*Note, You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - cList.setStaticContent(items=listitems)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setStaticContent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::ListItem * > * items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"items\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      items = new std::vector<XBMCAddon::xbmcgui::ListItem *>();
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        XBMCAddon::xbmcgui::ListItem * entry1;
        entry1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","setStaticContent");
        items->push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"setStaticContent","XBMCAddon::xbmcgui::ControlList"))-> setStaticContent(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setStaticContent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setStaticContent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          "_alignment",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    long  _alignment  = XBFONT_LEFT;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ssl",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor,
         &_alignment
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlFadeLabel * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlFadeLabel *)new XBMCAddon::xbmcgui::ControlFadeLabel(  x,  y,  width,  height,  font,  textColor,  _alignment  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlFadeLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlFadeLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlFadeLabel_addLabel__doc__,
               "addLabel(label)--Add a label to this control for scrolling.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.fadelabel.addLabel('This is a line of text that can scroll.')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_addLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    String  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","addLabel"); 

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"addLabel","XBMCAddon::xbmcgui::ControlFadeLabel"))-> addLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlFadeLabel_reset__doc__,
               "reset() --Clear this fade label.\n"
"\n"
"example:\n"
"    - self.fadelabel.reset()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"reset","XBMCAddon::xbmcgui::ControlFadeLabel"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlTextBox * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlTextBox *)new XBMCAddon::xbmcgui::ControlTextBox(  x,  y,  width,  height,  font,  textColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlTextBox\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlTextBox\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_setText__doc__,
               "setText(text)--Set's the text for this textbox.\n"
"\n"
"text : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.textbox.setText('This is a line of text that can wrap.')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    String  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlTextBox_Type,"setText","XBMCAddon::xbmcgui::ControlTextBox"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_reset__doc__,
               "reset() --Clear's this textbox.\n"
"\n"
"example:\n"
"    - self.textbox.reset()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlTextBox_Type,"reset","XBMCAddon::xbmcgui::ControlTextBox"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_scroll__doc__,
               "scroll(position)--Scrolls to the given position.\n"
"\n"
"id : integer - position to scroll to.\n"
"\n"
"example:\n"
"    - self.textbox.scroll(10)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_scroll (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    long  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlTextBox_Type,"scroll","XBMCAddon::xbmcgui::ControlTextBox"))-> scroll(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"scroll\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"scroll\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "filename",
          "aspectRatio",
          "colorDiffuse",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * filename ;         
    long  aspectRatio  = 0;         
    char * colorDiffuse  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"lllls|ls",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &filename,
         &aspectRatio,
         &colorDiffuse
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlImage * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlImage *)new XBMCAddon::xbmcgui::ControlImage(  x,  y,  width,  height,  filename,  aspectRatio,  colorDiffuse  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlImage_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlImage_setImage__doc__,
               "setImage(filename)--Changes the image.\n"
"\n"
"filename : string - image filename.\n"
"\n"
"example:\n"
"    - self.image.setImage('special://home/scripts/test.png')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_setImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "imageFilename",
          NULL};
         
    char * imageFilename ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &imageFilename
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlImage_Type,"setImage","XBMCAddon::xbmcgui::ControlImage"))-> setImage(  imageFilename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlImage_setColorDiffuse__doc__,
               "setColorDiffuse(colorDiffuse)--Changes the images color.\n"
"\n"
"colorDiffuse : hexString - (example, '0xC0FF0000' (red tint))\n"
"\n"
"example:\n"
"    - self.image.setColorDiffuse('0xC0FF0000')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_setColorDiffuse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "hexString",
          NULL};
         
    char * hexString ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &hexString
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlImage_Type,"setColorDiffuse","XBMCAddon::xbmcgui::ControlImage"))-> setColorDiffuse(  hexString  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setColorDiffuse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setColorDiffuse\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "texturebg",
          "textureleft",
          "texturemid",
          "textureright",
          "textureoverlay",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * texturebg  = NULL;         
    char * textureleft  = NULL;         
    char * texturemid  = NULL;         
    char * textureright  = NULL;         
    char * textureoverlay  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|sssss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &texturebg,
         &textureleft,
         &texturemid,
         &textureright,
         &textureoverlay
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlProgress * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlProgress *)new XBMCAddon::xbmcgui::ControlProgress(  x,  y,  width,  height,  texturebg,  textureleft,  texturemid,  textureright,  textureoverlay  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlProgress\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlProgress_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlProgress_setPercent__doc__,
               "setPercent(percent)--Sets the percentage of the progressbar to show.\n"
"\n"
"percent : float - percentage of the bar to show.\n"
"\n"
"*Note, valid range for percent is 0-100\n"
"\n"
"example:\n"
"    - self.progress.setPercent(60)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlProgress_Type,"setPercent","XBMCAddon::xbmcgui::ControlProgress"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlProgress_getPercent__doc__,
               "getPercent() --Returns a float of the percent of the progress.\n"
"\n"
"example:\n"
"    - print self.progress.getValue()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlProgress_Type,"getPercent","XBMCAddon::xbmcgui::ControlProgress"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusTexture",
          "noFocusTexture",
          "textOffsetX",
          "textOffsetY",
          "alignment",
          "font",
          "textColor",
          "disabledColor",
          "angle",
          "shadowColor",
          "focusedColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    String  label ;
    PyObject* pylabel = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  textOffsetX  = 10;         
    long  textOffsetY  = 2;         
    long  alignment  = (XBFONT_LEFT|XBFONT_CENTER_Y);         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  angle  = 0;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sslllssslss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusTexture,
         &noFocusTexture,
         &textOffsetX,
         &textOffsetY,
         &alignment,
         &font,
         &textColor,
         &disabledColor,
         &angle,
         &shadowColor,
         &focusedColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlButton * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","XBMCAddon::xbmcgui::ControlButton"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlButton *)new XBMCAddon::xbmcgui::ControlButton(  x,  y,  width,  height,  label,  focusTexture,  noFocusTexture,  textOffsetX,  textOffsetY,  alignment,  font,  textColor,  disabledColor,  angle,  shadowColor,  focusedColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlButton\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlButton_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_setLabel__doc__,
               "setLabel([label, font, textColor, disabledColor, shadowColor, focusedColor])--Set's this buttons text attributes.\n"
"\n"
"label : [opt] string or unicode - text string. font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled button's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled button's label. (e.g. '0xFFFF3300') shadowColor : [opt] hexstring - color of button's label's shadow. (e.g. '0xFF000000') focusedColor : [opt] hexstring - color of focused button's label. (e.g. '0xFFFFFF00') label2 : [opt] string or unicode - text string.\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.button.setLabel('Status', 'font14', '0xFFFFFFFF', '0xFFFF3300', '0xFF000000')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlButton_Type,"setLabel","XBMCAddon::xbmcgui::ControlButton"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_setDisabledColor__doc__,
               "setDisabledColor(disabledColor)--Set's this buttons disabled color.\n"
"\n"
"disabledColor : hexstring - color of disabled button's label. (e.g. '0xFFFF3300')\n"
"\n"
"example:\n"
"    - self.button.setDisabledColor('0xFFFF3300')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_setDisabledColor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "color",
          NULL};
         
    char * color ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &color
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlButton_Type,"setDisabledColor","XBMCAddon::xbmcgui::ControlButton"))-> setDisabledColor(  color  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDisabledColor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDisabledColor\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_getLabel__doc__,
               "getLabel() --Returns the buttons label as a unicode string.\n"
"\n"
"example:\n"
"    - label = self.button.getLabel()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlButton_Type,"getLabel","XBMCAddon::xbmcgui::ControlButton"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_getLabel2__doc__,
               "getLabel2() --Returns the buttons label2 as a unicode string.\n"
"\n"
"example:\n"
"    - label = self.button.getLabel2()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlButton_Type,"getLabel2","XBMCAddon::xbmcgui::ControlButton"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusTexture",
          "noFocusTexture",
          "checkWidth",
          "checkHeight",
          "_alignment",
          "font",
          "textColor",
          "disabledColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    String  label ;
    PyObject* pylabel = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  checkWidth  = 30;         
    long  checkHeight  = 30;         
    long  _alignment  = XBFONT_RIGHT;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sslllsss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusTexture,
         &noFocusTexture,
         &checkWidth,
         &checkHeight,
         &_alignment,
         &font,
         &textColor,
         &disabledColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlCheckMark * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","XBMCAddon::xbmcgui::ControlCheckMark"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlCheckMark *)new XBMCAddon::xbmcgui::ControlCheckMark(  x,  y,  width,  height,  label,  focusTexture,  noFocusTexture,  checkWidth,  checkHeight,  _alignment,  font,  textColor,  disabledColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlCheckMark\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlCheckMark\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_getSelected__doc__,
               "getSelected() --Returns the selected status for this checkmark as a bool.\n"
"\n"
"example:\n"
"    - selected = self.checkmark.getSelected()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_getSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlCheckMark_Type,"getSelected","XBMCAddon::xbmcgui::ControlCheckMark"))-> getSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_setSelected__doc__,
               "setSelected(isOn)--Sets this checkmark status to on or off.\n"
"\n"
"isOn : bool - True=selected (on) / False=not selected (off)\n"
"\n"
"example:\n"
"    - self.checkmark.setSelected(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlCheckMark_Type,"setSelected","XBMCAddon::xbmcgui::ControlCheckMark"))-> setSelected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_setLabel__doc__,
               "setLabel(label[, font, textColor, disabledColor])--Set's this controls text attributes.\n"
"\n"
"label : string or unicode - text string. font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled checkmark's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"example:\n"
"    - self.checkmark.setLabel('Status', 'font14', '0xFFFFFFFF', '0xFFFF3300')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlCheckMark_Type,"setLabel","XBMCAddon::xbmcgui::ControlCheckMark"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor__doc__,
               "setDisabledColor(disabledColor)--Set's this controls disabled color.\n"
"\n"
"disabledColor : hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"example:\n"
"    - self.checkmark.setDisabledColor('0xFFFF3300')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "color",
          NULL};
         
    char * color ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &color
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlCheckMark_Type,"setDisabledColor","XBMCAddon::xbmcgui::ControlCheckMark"))-> setDisabledColor(  color  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDisabledColor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDisabledColor\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlGroup_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlGroup * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlGroup *)new XBMCAddon::xbmcgui::ControlGroup(  x,  y,  width,  height  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlGroup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlGroup\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlGroup_Type,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusTexture",
          "noFocusTexture",
          "textOffsetX",
          "textOffsetY",
          "_alignment",
          "font",
          "textColor",
          "disabledColor",
          "angle",
          "shadowColor",
          "focusedColor",
          "TextureRadioFocus",
          "TextureRadioNoFocus",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    String  label ;
    PyObject* pylabel = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  textOffsetX  = 10;         
    long  textOffsetY  = 2;         
    long  _alignment  = (XBFONT_LEFT|XBFONT_CENTER_Y);         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  angle  = 0;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    char * TextureRadioFocus  = NULL;         
    char * TextureRadioNoFocus  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sslllssslssss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusTexture,
         &noFocusTexture,
         &textOffsetX,
         &textOffsetY,
         &_alignment,
         &font,
         &textColor,
         &disabledColor,
         &angle,
         &shadowColor,
         &focusedColor,
         &TextureRadioFocus,
         &TextureRadioNoFocus
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlRadioButton * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","XBMCAddon::xbmcgui::ControlRadioButton"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlRadioButton *)new XBMCAddon::xbmcgui::ControlRadioButton(  x,  y,  width,  height,  label,  focusTexture,  noFocusTexture,  textOffsetX,  textOffsetY,  _alignment,  font,  textColor,  disabledColor,  angle,  shadowColor,  focusedColor,  TextureRadioFocus,  TextureRadioNoFocus  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlRadioButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlRadioButton\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_setSelected__doc__,
               "setSelected(selected)--Sets the radio buttons's selected status.\n"
"\n"
"selected : bool - True=selected (on) / False=not selected (off)\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.radiobutton.setSelected(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setSelected","XBMCAddon::xbmcgui::ControlRadioButton"))-> setSelected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_isSelected__doc__,
               "isSelected() --Returns the radio buttons's selected status.\n"
"\n"
"example:\n"
"    - is = self.radiobutton.isSelected()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlRadioButton_Type,"isSelected","XBMCAddon::xbmcgui::ControlRadioButton"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_setLabel__doc__,
               "setLabel(label[, font, textColor, disabledColor, shadowColor, focusedColor])--Set's the radio buttons text attributes.\n"
"\n"
"label : string or unicode - text string. font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled radio button's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled radio button's label. (e.g. '0xFFFF3300') shadowColor : [opt] hexstring - color of radio button's label's shadow. (e.g. '0xFF000000') focusedColor : [opt] hexstring - color of focused radio button's label. (e.g. '0xFFFFFF00')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.radiobutton.setLabel('Status', 'font14', '0xFFFFFFFF', '0xFFFF3300', '0xFF000000')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    String  label  = emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    String  label2  = emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setLabel","XBMCAddon::xbmcgui::ControlRadioButton"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension__doc__,
               "setRadioDimension(x, y, width, height)--Sets the radio buttons's radio texture's position and size.\n"
"\n"
"x : integer - x coordinate of radio texture. y : integer - y coordinate of radio texture. width : integer - width of radio texture. height : integer - height of radio texture.\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.radiobutton.setRadioDimension(x=100, y=5, width=20, height=20)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setRadioDimension","XBMCAddon::xbmcgui::ControlRadioButton"))-> setRadioDimension(  x,  y,  width,  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setRadioDimension\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setRadioDimension\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "textureback",
          "texture",
          "texturefocus",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * textureback  = NULL;         
    char * texture  = NULL;         
    char * texturefocus  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|sss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &textureback,
         &texture,
         &texturefocus
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlSlider * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlSlider *)new XBMCAddon::xbmcgui::ControlSlider(  x,  y,  width,  height,  textureback,  texture,  texturefocus  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlSlider\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlSlider\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_ControlSlider_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSlider_getPercent__doc__,
               "getPercent() --Returns a float of the percent of the slider.\n"
"\n"
"example:\n"
"    - print self.slider.getPercent()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlSlider_Type,"getPercent","XBMCAddon::xbmcgui::ControlSlider"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSlider_setPercent__doc__,
               "setPercent(50)--Sets the percent of the slider.\n"
"\n"
"example: self.slider.setPercent(50)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlSlider_Type,"setPercent","XBMCAddon::xbmcgui::ControlSlider"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::Dialog * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Dialog *)new XBMCAddon::xbmcgui::Dialog(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Dialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Dialog\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_Dialog_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_yesno__doc__,
               "yesno(heading, line1[, line2, line3])--Show a dialog 'YES/NO'.\n"
"\n"
"heading : string or unicode - dialog heading. line1 : string or unicode - line #1 text. line2 : [opt] string or unicode - line #2 text. line3 : [opt] string or unicode - line #3 text. nolabel : [opt] label to put on the no button. yeslabel : [opt] label to put on the yes button.\n"
"\n"
"*Note, Returns True if 'Yes' was pressed, else False.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - ret = dialog.yesno('XBMC', 'Do you want to exit this script?')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_yesno (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          "nolabel",
          "yeslabel",
          NULL};
         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  line1 ;
    PyObject* pyline1 = NULL;         
    String  line2  = emptyString;
    PyObject* pyline2 = NULL;         
    String  line3  = emptyString;
    PyObject* pyline3 = NULL;         
    String  nolabel  = emptyString;
    PyObject* pynolabel = NULL;         
    String  yeslabel  = emptyString;
    PyObject* pyyeslabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|OOOO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3,
         &pynolabel,
         &pyyeslabel
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","yesno"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","yesno"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","yesno"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","yesno"); 
      if (pynolabel) PyXBMCGetUnicodeString(nolabel,pynolabel,false,"nolabel","yesno"); 
      if (pyyeslabel) PyXBMCGetUnicodeString(yeslabel,pyyeslabel,false,"yeslabel","yesno"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"yesno","XBMCAddon::xbmcgui::Dialog"))-> yesno(  heading,  line1,  line2,  line3,  nolabel,  yeslabel  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"yesno\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"yesno\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_select__doc__,
               "select(heading, list)--Show a select dialog.\n"
"\n"
"heading : string or unicode - dialog heading. list : string list - list of items. autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)\n"
"\n"
"*Note, Returns the position of the highlighted item as an integer.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - ret = dialog.select('Choose a playlist', ['Playlist #1', 'Playlist #2, 'Playlist #3'])\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_select (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "heading",
          "list",
          "autoclose",
          NULL};
         
    String  heading ;
    PyObject* pyheading = NULL;         
    std::vector< String  >  list ;
    PyObject* pylist = NULL;         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|i",
       (char**)keywords,
         &pyheading,
         &pylist,
         &autoclose
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","select"); 
      

    {
      bool isTuple = PyObject_TypeCheck(pylist,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pylist,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"list\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pylist) : PyList_Size(pylist));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pylist, i) : PyList_GetItem(pylist, i));
        String  entry1;
        if (pyentry1) PyXBMCGetUnicodeString(entry1,pyentry1,false,"entry1","select");
        list.push_back(entry1);
      }
    }
 

      apiResult = (int )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"select","XBMCAddon::xbmcgui::Dialog"))-> select(  heading,  list,  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"select\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"select\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_ok__doc__,
               "ok(heading, line1[, line2, line3])--Show a dialog 'OK'.\n"
"\n"
"heading : string or unicode - dialog heading. line1 : string or unicode - line #1 text. line2 : [opt] string or unicode - line #2 text. line3 : [opt] string or unicode - line #3 text.\n"
"\n"
"*Note, Returns True if 'Ok' was pressed, else False.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - ok = dialog.ok('XBMC', 'There was an error.')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_ok (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          NULL};
         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  line1 ;
    PyObject* pyline1 = NULL;         
    String  line2  = emptyString;
    PyObject* pyline2 = NULL;         
    String  line3  = emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|OO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","ok"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","ok"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","ok"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","ok"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"ok","XBMCAddon::xbmcgui::Dialog"))-> ok(  heading,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"ok\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"ok\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_browse__doc__,
               "browse(type, heading, shares[, mask, useThumbs, treatAsFolder, default, enableMultiple])--Show a 'Browse' dialog.\n"
"\n"
"type : integer - the type of browse dialog. heading : string or unicode - dialog heading. shares : string or unicode - from sources.xml. (i.e. 'myprograms') mask : [opt] string or unicode - '|' separated file mask. (i.e. '.jpg|.png') useThumbs : [opt] boolean - if True autoswitch to Thumb view if files exist. treatAsFolder : [opt] boolean - if True playlists and archives act as folders. default : [opt] string - default path or file.\n"
"\n"
"enableMultiple : [opt] boolean - if True multiple file selection is enabled. Types: 0 : ShowAndGetDirectory 1 : ShowAndGetFile 2 : ShowAndGetImage 3 : ShowAndGetWriteableDirectory\n"
"\n"
"*Note, If enableMultiple is False (default): returns filename and/or path as a string to the location of the highlighted item, if user pressed 'Ok' or a masked item was selected. Returns the default value if dialog was canceled. If enableMultiple is True: returns tuple of marked filenames as a strin if user pressed 'Ok' or a masked item was selected. Returns empty tuple if dialog was canceled.\n"
"\n"
"If type is 0 or 3 the enableMultiple parameter is ignore\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - fn = dialog.browse(3, 'XBMC', 'files', '', False, False, False, 'special://masterprofile/script_data/XBMC Lyrics')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "s_shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          "enableMultiple",
          NULL};
         
    int  type ;         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  s_shares ;
    PyObject* pys_shares = NULL;         
    String  mask  = emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    String  defaultt  = emptyString;
    PyObject* pydefaultt = NULL;         
    bool  enableMultiple  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbOb",
       (char**)keywords,
         &type,
         &pyheading,
         &pys_shares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt,
         &enableMultiple
       ))
    {
      return NULL;
    }

    Alternative< String ,std::vector< String  >  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browse"); 
      if (pys_shares) PyXBMCGetUnicodeString(s_shares,pys_shares,false,"s_shares","browse"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browse"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browse"); 

      apiResult = (Alternative< String ,std::vector< String  >  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"browse","XBMCAddon::xbmcgui::Dialog"))-> browse(  type,  heading,  s_shares,  mask,  useThumbs,  treatAsFolder,  defaultt,  enableMultiple  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browse\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    

    WhichAlternative pos = apiResult.which();

    if (pos != XBMCAddon::none)
    { 
      if (pos == XBMCAddon::first)
      {
        String & entry1 = apiResult.former();
        {
          
result = PyString_FromString(entry1.c_str());

        }
      }

      if (pos == XBMCAddon::second)
      {
        std::vector< String  > & entry1 = apiResult.later();
        {
          


    result = PyList_New(0);

      for (std::vector<String >::iterator iter = entry1.begin(); iter != entry1.end(); ++iter)
      {
        String & entry2 = *iter;
        PyObject* pyentry2;
        
pyentry2 = PyString_FromString(entry2.c_str());

        PyList_Append(result, pyentry2);
      }


        }
      }

    }
    else
    { 
      result = Py_None;
    }


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_browseSingle__doc__,
               "browse(type, heading, shares[, mask, useThumbs, treatAsFolder, default])--Show a 'Browse' dialog.\n"
"\n"
"type : integer - the type of browse dialog. heading : string or unicode - dialog heading. shares : string or unicode - from sources.xml. (i.e. 'myprograms') mask : [opt] string or unicode - '|' separated file mask. (i.e. '.jpg|.png') useThumbs : [opt] boolean - if True autoswitch to Thumb view if files exist (default=false). treatAsFolder : [opt] boolean - if True playlists and archives act as folders (default=false). default : [opt] string - default path or file.\n"
"\n"
"Types: 0 : ShowAndGetDirectory 1 : ShowAndGetFile 2 : ShowAndGetImage 3 : ShowAndGetWriteableDirectory\n"
"\n"
"*Note, Returns filename and/or path as a string to the location of the highlighted item, if user pressed 'Ok' or a masked item was selected. Returns the default value if dialog was canceled.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - fn = dialog.browse(3, 'XBMC', 'files', '', False, False, 'special://masterprofile/script_data/XBMC Lyrics')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browseSingle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          NULL};
         
    int  type ;         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  shares ;
    PyObject* pyshares = NULL;         
    String  mask  = emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    String  defaultt  = emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbO",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browseSingle"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browseSingle"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browseSingle"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browseSingle"); 

      apiResult = (String )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"browseSingle","XBMCAddon::xbmcgui::Dialog"))-> browseSingle(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browseSingle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browseSingle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_browseMultiple__doc__,
               "browse(type, heading, shares[, mask, useThumbs, treatAsFolder, default])--Show a 'Browse' dialog.\n"
"\n"
"type : integer - the type of browse dialog. heading : string or unicode - dialog heading. shares : string or unicode - from sources.xml. (i.e. 'myprograms') mask : [opt] string or unicode - '|' separated file mask. (i.e. '.jpg|.png') useThumbs : [opt] boolean - if True autoswitch to Thumb view if files exist (default=false). treatAsFolder : [opt] boolean - if True playlists and archives act as folders (default=false). default : [opt] string - default path or file.\n"
"\n"
"Types: 1 : ShowAndGetFile 2 : ShowAndGetImage\n"
"\n"
"*Note, returns tuple of marked filenames as a string,\" if user pressed 'Ok' or a masked item was selected. Returns empty tuple if dialog was canceled.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - fn = dialog.browseMultiple(2, 'XBMC', 'files', '', False, False, 'special://masterprofile/script_data/XBMC Lyrics')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browseMultiple (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          NULL};
         
    int  type ;         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  shares ;
    PyObject* pyshares = NULL;         
    String  mask  = emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    String  defaultt  = emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbO",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::vector< String  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browseMultiple"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browseMultiple"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browseMultiple"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browseMultiple"); 

      apiResult = (std::vector< String  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"browseMultiple","XBMCAddon::xbmcgui::Dialog"))-> browseMultiple(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browseMultiple\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browseMultiple\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    result = PyList_New(0);

      for (std::vector<String >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        String & entry1 = *iter;
        PyObject* pyentry1;
        
pyentry1 = PyString_FromString(entry1.c_str());

        PyList_Append(result, pyentry1);
      }



    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_numeric__doc__,
               "numeric(type, heading[, default])--Show a 'Numeric' dialog.\n"
"\n"
"type : integer - the type of numeric dialog. heading : string or unicode - dialog heading. default : [opt] string - default value.\n"
"\n"
"Types: 0 : ShowAndGetNumber (default format: #) 1 : ShowAndGetDate (default format: DD/MM/YYYY) 2 : ShowAndGetTime (default format: HH:MM) 3 : ShowAndGetIPAddress (default format: #.#.#.#)\n"
"\n"
"*Note, Returns the entered data as a string. Returns the default value if dialog was canceled.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - d = dialog.numeric(1, 'Enter date of birth')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_numeric (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "defaultt",
          NULL};
         
    int  type ;         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  defaultt  = emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iO|O",
       (char**)keywords,
         &type,
         &pyheading,
         &pydefaultt
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","numeric"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","numeric"); 

      apiResult = (String )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"numeric","XBMCAddon::xbmcgui::Dialog"))-> numeric(  type,  heading,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"numeric\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"numeric\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::DialogProgress * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::DialogProgress *)new XBMCAddon::xbmcgui::DialogProgress(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgress\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_DialogProgress_Type,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_create__doc__,
               "create(heading[, line1, line2, line3])--Create and show a progress dialog.\n"
"\n"
"heading : string or unicode - dialog heading. line1 : [opt] string or unicode - line #1 text. line2 : [opt] string or unicode - line #2 text. line3 : [opt] string or unicode - line #3 text.\n"
"\n"
"*Note, Useupdate() to update lines and progressbar.\n"
"\n"
"example:\n"
"    - pDialog = xbmcgui.DialogProgress()\n"
"    - pDialog.create('XBMC', 'Initializing script...')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_create (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          NULL};
         
    String  heading ;
    PyObject* pyheading = NULL;         
    String  line1  = emptyString;
    PyObject* pyline1 = NULL;         
    String  line2  = emptyString;
    PyObject* pyline2 = NULL;         
    String  line3  = emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|OOO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","create"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","create"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","create"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","create"); 

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_DialogProgress_Type,"create","XBMCAddon::xbmcgui::DialogProgress"))-> create(  heading,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"create\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"create\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_update__doc__,
               "update(percent[, line1, line2, line3])--Update's the progress dialog.\n"
"\n"
"percent : integer - percent complete. (0:100) line1 : [opt] string or unicode - line #1 text. line2 : [opt] string or unicode - line #2 text. line3 : [opt] string or unicode - line #3 text.\n"
"\n"
"*Note, If percent == 0, the progressbar will be hidden.\n"
"\n"
"example:\n"
"    - pDialog.update(25, 'Importing modules...')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_update (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "percent",
          "line1",
          "line2",
          "line3",
          NULL};
         
    int  percent ;         
    String  line1  = emptyString;
    PyObject* pyline1 = NULL;         
    String  line2  = emptyString;
    PyObject* pyline2 = NULL;         
    String  line3  = emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i|OOO",
       (char**)keywords,
         &percent,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }


    try
    {
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","update"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","update"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","update"); 

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_DialogProgress_Type,"update","XBMCAddon::xbmcgui::DialogProgress"))-> update(  percent,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"update\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"update\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_close__doc__,
               "close() --Close the progress dialog.\n"
"\n"
"example:\n"
"    - pDialog.close()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_DialogProgress_Type,"close","XBMCAddon::xbmcgui::DialogProgress"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_iscanceled__doc__,
               "iscanceled() --Returns True if the user pressed cancel.\n"
"\n"
"example:\n"
"    - if (pDialog.iscanceled()): return\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_iscanceled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_DialogProgress_Type,"iscanceled","XBMCAddon::xbmcgui::DialogProgress"))-> iscanceled(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"iscanceled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"iscanceled\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::Action * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Action *)new XBMCAddon::xbmcgui::Action(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Action\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Action\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_Action_Type,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Action_Type,"getId","XBMCAddon::xbmcgui::Action"))-> getId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getButtonCode (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Action_Type,"getButtonCode","XBMCAddon::xbmcgui::Action"))-> getButtonCode(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getButtonCode\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getButtonCode\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getAmount1 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Action_Type,"getAmount1","XBMCAddon::xbmcgui::Action"))-> getAmount1(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAmount1\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAmount1\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getAmount2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Action_Type,"getAmount2","XBMCAddon::xbmcgui::Action"))-> getAmount2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAmount2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAmount2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
         
    int  existingWindowId  = -1;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|i",
       
         &existingWindowId
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Window * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Window *)(&PyXBMCAddon_xbmcgui_Window_Type != pytype) ? new XBMCAddon_xbmcgui_Window_Director( existingWindowId ) : new XBMCAddon::xbmcgui::Window(  existingWindowId  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Window\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Window\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_Window_Type,false);
    if (&PyXBMCAddon_xbmcgui_Window_Type != pytype) 
      ((XBMCAddon_xbmcgui_Window_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onAction__doc__,
               "onAction(self, Action action)--onAction method.\n"
"\n"
"This method will recieve all actions that the main program will send to this window. By default, only the PREVIOUS_MENU and NAV_BACK actions are handled. Overwrite this method to let your script handle all actions. Don't forget to capture ACTION_PREVIOUS_MENU or ACTION_NAV_BACK, else the user can't close this window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onAction (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "action",
          NULL};
         
    XBMCAddon::xbmcgui::Action * action ;
    PyObject* pyaction = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyaction
       ))
    {
      return NULL;
    }


    try
    {
      action = (XBMCAddon::xbmcgui::Action *)retrieveApiInstance(pyaction,"p.XBMCAddon::xbmcgui::Action","XBMCAddon::xbmcgui::","onAction"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"onAction","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onAction(  action  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onAction\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onAction\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","onControl"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"onControl","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onControl(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onClick (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"onClick","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onClick(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onClick\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onClick\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"onFocus","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onFocus(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onFocus\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onInit (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"onInit","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onInit(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onInit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onInit\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_show__doc__,
               "show(self)--Show this window.\n"
"\n"
"Shows this window by activating it, callingclose() after it wil activate the current window again. Note, if your script ends this window will be closed to. To show it forever, make a loop at the end of your script ar usedoModal() instead\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_show (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"show","XBMCAddon::xbmcgui::Window"))-> show(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"show\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"show\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setFocus__doc__,
               "setFocus(self, Control)--Give the supplied control focus. Throws: TypeError, if supplied argument is not aControl type SystemError, on Internal error RuntimeError, if control is not added to a window\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setFocus"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"setFocus","XBMCAddon::xbmcgui::Window"))-> setFocus(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setFocus\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setFocusId__doc__,
               "setFocusId(self, int)--Gives the control with the supplied focus. Throws: SystemError, on Internal error RuntimeError, if control is not added to a window\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setFocusId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "iControlId",
          NULL};
         
    int  iControlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iControlId
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"setFocusId","XBMCAddon::xbmcgui::Window"))-> setFocusId(  iControlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setFocusId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setFocusId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getFocus__doc__,
               "getFocus(self, Control)--returns the control which is focused. Throws: SystemError, on Internal error RuntimeError, if no control has focus\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getFocus","XBMCAddon::xbmcgui::Window"))-> getFocus(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFocus\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getFocusId__doc__,
               "getFocusId(self, int)--returns the id of the control which is focused. Throws: SystemError, on Internal error RuntimeError, if no control has focus\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getFocusId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getFocusId","XBMCAddon::xbmcgui::Window"))-> getFocusId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFocusId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFocusId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_removeControl__doc__,
               "removeControl(self, Control)--Removes the control from this window.\n"
"\n"
"Throws: TypeError, if supplied argument is not aControl type RuntimeError, if control is not added to this window\n"
"\n"
"This will not delete the control. It is only removed from the window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_removeControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","removeControl"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"removeControl","XBMCAddon::xbmcgui::Window"))-> removeControl(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_removeControls__doc__,
               "removeControls(self, List)--Removes a list of controls from this window.\n"
"\n"
"Throws: TypeError, if supplied argument is not aControl type RuntimeError, if control is not added to this window\n"
"\n"
"This will not delete the controls. They are only removed from the window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_removeControls (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pControls",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::Control * >  pControls ;
    PyObject* pypControls = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControls
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pypControls,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypControls,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"pControls\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypControls) : PyList_Size(pypControls));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypControls, i) : PyList_GetItem(pypControls, i));
        XBMCAddon::xbmcgui::Control * entry1;
        entry1 = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","removeControls");
        pControls.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"removeControls","XBMCAddon::xbmcgui::Window"))-> removeControls(  pControls  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeControls\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeControls\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getHeight__doc__,
               "getHeight(self)--Returns the height of this screen.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getHeight","XBMCAddon::xbmcgui::Window"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getWidth__doc__,
               "getWidth(self)--Returns the width of this screen.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getWidth","XBMCAddon::xbmcgui::Window"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getResolution__doc__,
               "getResolution(self)--Returns the resolution of the scree The returned value is one of the following: 0 - 1080i (1920x1080) 1 - 720p (1280x720) 2 - 480p 4:3 (720x480) 3 - 480p 16:9 (720x480) 4 - NTSC 4:3 (720x480) 5 - NTSC 16:9 (720x480) 6 - PAL 4:3 (720x576) 7 - PAL 16:9 (720x576) 8 - PAL60 4:3 (720x480) 9 - PAL60 16:9 (720x480)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getResolution (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getResolution","XBMCAddon::xbmcgui::Window"))-> getResolution(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getResolution\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getResolution\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setCoordinateResolution__doc__,
               "setCoordinateResolution(self, int resolution)--Sets the resolution that the coordinates of all controls are defined in. Allows XBMC to scale control positions and width/heights to whatever resolution XBMC is currently using. resolution is one of the following: 0 - 1080i (1920x1080) 1 - 720p (1280x720) 2 - 480p 4:3 (720x480) 3 - 480p 16:9 (720x480) 4 - NTSC 4:3 (720x480) 5 - NTSC 16:9 (720x480) 6 - PAL 4:3 (720x576) 7 - PAL 16:9 (720x576) 8 - PAL60 4:3 (720x480) 9 - PAL60 16:9 (720x480)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setCoordinateResolution (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "res",
          NULL};
         
    long  res ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &res
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"setCoordinateResolution","XBMCAddon::xbmcgui::Window"))-> setCoordinateResolution(  res  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCoordinateResolution\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCoordinateResolution\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setProperty__doc__,
               "setProperty(key, value)--Sets a window property, similar to an infolabel.\n"
"\n"
"key : string - property name. value : string or unicode - value of property.\n"
"\n"
"*Note, key is NOT case sensitive. Setting value to an empty string is equivalent to clearProperty(key) You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - win.setProperty('Category', 'Newest')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "key",
          "value",
          NULL};
         
    char * key ;         
    String  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","setProperty"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"setProperty","XBMCAddon::xbmcgui::Window"))-> setProperty(  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getProperty__doc__,
               "getProperty(key)--Returns a window property as a string, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"\n"
"*Note, key is NOT case sensitive. You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - category = win.getProperty('Category')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    String  apiResult;
    try
    {

      apiResult = (String )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getProperty","XBMCAddon::xbmcgui::Window"))-> getProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromString(apiResult.c_str());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_clearProperty__doc__,
               "clearProperty(key)--Clears the specific window property.\n"
"\n"
"key : string - property name.\n"
"\n"
"*Note, key is NOT case sensitive. Equivalent to setProperty(key,'') You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - win.clearProperty('Category')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_clearProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"clearProperty","XBMCAddon::xbmcgui::Window"))-> clearProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_clearProperties__doc__,
               "clearProperties() --Clears all window properties.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - win.clearProperties()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_clearProperties (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"clearProperties","XBMCAddon::xbmcgui::Window"))-> clearProperties(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearProperties\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearProperties\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_close__doc__,
               "close(self)--Closes this window.\n"
"\n"
"Closes this window by activating the old window. The window is not deleted with this method.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"close","XBMCAddon::xbmcgui::Window"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_doModal__doc__,
               "doModal(self)--Display this window untilclose() is called.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_doModal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"doModal","XBMCAddon::xbmcgui::Window"))-> doModal(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"doModal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"doModal\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_addControl__doc__,
               "addControl(self, Control)--Add aControl to this window.\n"
"\n"
"Throws: TypeError, if supplied argument is not aControl type ReferenceError, if control is already used in another window RuntimeError, should not happen :-)\n"
"\n"
"The next controls can be added to a window atm\n"
"\n"
"-ControlLabel -ControlFadeLabel -ControlTextBox -ControlButton -ControlCheckMark -ControlList -ControlGroup -ControlImage -ControlRadioButton -ControlProgress\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_addControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","addControl"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"addControl","XBMCAddon::xbmcgui::Window"))-> addControl(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_addControls__doc__,
               "addControls(self, List)--Add a list of Controls to this window.\n"
"\n"
"*Throws: TypeError, if supplied argument is not ofList type, or a control is not ofControl type ReferenceError, if control is already used in another window RuntimeError, should not happen :-)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_addControls (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "pControls",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::Control * >  pControls ;
    PyObject* pypControls = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControls
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pypControls,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypControls,&PyList_Type))
      {
        PyErr_SetString(PyExc_TypeError, "the parameter \"pControls\" must be either a Tuple or a List.");
        return NULL; // short circuit the rest of this python method
      }

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypControls) : PyList_Size(pypControls));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypControls, i) : PyList_GetItem(pypControls, i));
        XBMCAddon::xbmcgui::Control * entry1;
        entry1 = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","addControls");
        pControls.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"addControls","XBMCAddon::xbmcgui::Window"))-> addControls(  pControls  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addControls\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addControls\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getControl__doc__,
               "getControl(self, int controlId)--Get's the control from this window.\n"
"\n"
"Throws: Exception, ifControl doesn't exist\n"
"\n"
"controlId doesn't have to be a python control, it can be a control id from a xbmc window too (you can find id's in the xml files\n"
"\n"
"Note, not python controls are not completely usable yet You can only use theControl functions\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "iControlId",
          NULL};
         
    int  iControlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iControlId
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"getControl","XBMCAddon::xbmcgui::Window"))-> getControl(  iControlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowDialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    XBMCAddon::xbmcgui::WindowDialog * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowDialog *)(&PyXBMCAddon_xbmcgui_WindowDialog_Type != pytype) ? new XBMCAddon_xbmcgui_WindowDialog_Director() : new XBMCAddon::xbmcgui::WindowDialog(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowDialog\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_WindowDialog_Type,false);
    if (&PyXBMCAddon_xbmcgui_WindowDialog_Type != pytype) 
      ((XBMCAddon_xbmcgui_WindowDialog_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowDialog_show (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowDialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowDialog_Type,"show","XBMCAddon::xbmcgui::WindowDialog"))-> show(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"show\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"show\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowDialog_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowDialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowDialog_Type,"close","XBMCAddon::xbmcgui::WindowDialog"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
         
    String  xmlFilename ;
    PyObject* pyxmlFilename = NULL;         
    String  scriptPath ;
    PyObject* pyscriptPath = NULL;         
    String  defaultSkin  = "Default";
    PyObject* pydefaultSkin = NULL;         
    String  defaultRes  = "720p";
    PyObject* pydefaultRes = NULL;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"OO|OO",
       
         &pyxmlFilename,
         &pyscriptPath,
         &pydefaultSkin,
         &pydefaultRes
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::WindowXML * apiResult;
    try
    {
      if (pyxmlFilename) PyXBMCGetUnicodeString(xmlFilename,pyxmlFilename,false,"xmlFilename","XBMCAddon::xbmcgui::WindowXML"); 
      if (pyscriptPath) PyXBMCGetUnicodeString(scriptPath,pyscriptPath,false,"scriptPath","XBMCAddon::xbmcgui::WindowXML"); 
      if (pydefaultSkin) PyXBMCGetUnicodeString(defaultSkin,pydefaultSkin,false,"defaultSkin","XBMCAddon::xbmcgui::WindowXML"); 
      if (pydefaultRes) PyXBMCGetUnicodeString(defaultRes,pydefaultRes,false,"defaultRes","XBMCAddon::xbmcgui::WindowXML"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowXML *)(&PyXBMCAddon_xbmcgui_WindowXML_Type != pytype) ? new XBMCAddon_xbmcgui_WindowXML_Director( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) : new XBMCAddon::xbmcgui::WindowXML(  xmlFilename,  scriptPath,  defaultSkin,  defaultRes  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXML\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXML\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_WindowXML_Type,false);
    if (&PyXBMCAddon_xbmcgui_WindowXML_Type != pytype) 
      ((XBMCAddon_xbmcgui_WindowXML_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItemString (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "item",
          "position",
          NULL};
         
    String  item ;
    PyObject* pyitem = NULL;         
    int  position  = INT_MAX;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|i",
       (char**)keywords,
         &pyitem,
         &position
       ))
    {
      return NULL;
    }


    try
    {
      if (pyitem) PyXBMCGetUnicodeString(item,pyitem,false,"item","addItem"); 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"addItem","XBMCAddon::xbmcgui::WindowXML"))-> addItem(  item,  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_addListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "item",
          "position",
          NULL};
         
    XBMCAddon::xbmcgui::ListItem * item ;
    PyObject* pyitem = NULL;         
    int  position  = INT_MAX;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|i",
       (char**)keywords,
         &pyitem,
         &position
       ))
    {
      return NULL;
    }


    try
    {
      item = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addListItem"); 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"addListItem","XBMCAddon::xbmcgui::WindowXML"))-> addListItem(  item,  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_removeItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"removeItem","XBMCAddon::xbmcgui::WindowXML"))-> removeItem(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"getCurrentListPosition","XBMCAddon::xbmcgui::WindowXML"))-> getCurrentListPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCurrentListPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCurrentListPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"setCurrentListPosition","XBMCAddon::xbmcgui::WindowXML"))-> setCurrentListPosition(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCurrentListPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCurrentListPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"getListItem","XBMCAddon::xbmcgui::WindowXML"))-> getListItem(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListSize (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"getListSize","XBMCAddon::xbmcgui::WindowXML"))-> getListSize(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListSize\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListSize\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_clearList (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"clearList","XBMCAddon::xbmcgui::WindowXML"))-> clearList(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearList\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    static const char *keywords[] = {
          "strProperty",
          "strValue",
          NULL};
         
    String  strProperty ;
    PyObject* pystrProperty = NULL;         
    String  strValue ;
    PyObject* pystrValue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO",
       (char**)keywords,
         &pystrProperty,
         &pystrValue
       ))
    {
      return NULL;
    }


    try
    {
      if (pystrProperty) PyXBMCGetUnicodeString(strProperty,pystrProperty,false,"strProperty","setProperty"); 
      if (pystrValue) PyXBMCGetUnicodeString(strValue,pystrValue,false,"strValue","setProperty"); 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"setProperty","XBMCAddon::xbmcgui::WindowXML"))-> setProperty(  strProperty,  strValue  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    TRACE;
         
    String  xmlFilename ;
    PyObject* pyxmlFilename = NULL;         
    String  scriptPath ;
    PyObject* pyscriptPath = NULL;         
    String  defaultSkin  = "Default";
    PyObject* pydefaultSkin = NULL;         
    String  defaultRes  = "720p";
    PyObject* pydefaultRes = NULL;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"OO|OO",
       
         &pyxmlFilename,
         &pyscriptPath,
         &pydefaultSkin,
         &pydefaultRes
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::WindowXMLDialog * apiResult;
    try
    {
      if (pyxmlFilename) PyXBMCGetUnicodeString(xmlFilename,pyxmlFilename,false,"xmlFilename","XBMCAddon::xbmcgui::WindowXMLDialog"); 
      if (pyscriptPath) PyXBMCGetUnicodeString(scriptPath,pyscriptPath,false,"scriptPath","XBMCAddon::xbmcgui::WindowXMLDialog"); 
      if (pydefaultSkin) PyXBMCGetUnicodeString(defaultSkin,pydefaultSkin,false,"defaultSkin","XBMCAddon::xbmcgui::WindowXMLDialog"); 
      if (pydefaultRes) PyXBMCGetUnicodeString(defaultRes,pydefaultRes,false,"defaultRes","XBMCAddon::xbmcgui::WindowXMLDialog"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::LanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowXMLDialog *)(&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type != pytype) ? new XBMCAddon_xbmcgui_WindowXMLDialog_Director( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) : new XBMCAddon::xbmcgui::WindowXMLDialog(  xmlFilename,  scriptPath,  defaultSkin,  defaultRes  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXMLDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXMLDialog\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,&TyXBMCAddon_xbmcgui_WindowXMLDialog_Type,false);
    if (&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type != pytype) 
      ((XBMCAddon_xbmcgui_WindowXMLDialog_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_show (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowXMLDialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type,"show","XBMCAddon::xbmcgui::WindowXMLDialog"))-> show(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"show\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"show\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowXMLDialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type,"close","XBMCAddon::xbmcgui::WindowXMLDialog"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static void xbmcgui_XBMCAddon_xbmcgui_ListItem_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ListItem* theObj = (XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ListItem_Type,"~XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::ListItem");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ListItem\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Control_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::Control* theObj = (XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Control_Type,"~XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::Control");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Control\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Control\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlSpin_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlSpin* theObj = (XBMCAddon::xbmcgui::ControlSpin*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlSpin_Type,"~XBMCAddon::xbmcgui::ControlSpin","XBMCAddon::xbmcgui::ControlSpin");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSpin\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSpin\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlLabel_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlLabel* theObj = (XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlLabel_Type,"~XBMCAddon::xbmcgui::ControlLabel","XBMCAddon::xbmcgui::ControlLabel");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlLabel\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlEdit_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlEdit* theObj = (XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlEdit_Type,"~XBMCAddon::xbmcgui::ControlEdit","XBMCAddon::xbmcgui::ControlEdit");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlEdit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlEdit\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlList_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlList* theObj = (XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlList_Type,"~XBMCAddon::xbmcgui::ControlList","XBMCAddon::xbmcgui::ControlList");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlList\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlFadeLabel* theObj = (XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"~XBMCAddon::xbmcgui::ControlFadeLabel","XBMCAddon::xbmcgui::ControlFadeLabel");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlFadeLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlFadeLabel\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlTextBox* theObj = (XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlTextBox_Type,"~XBMCAddon::xbmcgui::ControlTextBox","XBMCAddon::xbmcgui::ControlTextBox");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlTextBox\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlTextBox\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlImage_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlImage* theObj = (XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlImage_Type,"~XBMCAddon::xbmcgui::ControlImage","XBMCAddon::xbmcgui::ControlImage");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlImage\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlProgress_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlProgress* theObj = (XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlProgress_Type,"~XBMCAddon::xbmcgui::ControlProgress","XBMCAddon::xbmcgui::ControlProgress");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlProgress\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlButton_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlButton* theObj = (XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlButton_Type,"~XBMCAddon::xbmcgui::ControlButton","XBMCAddon::xbmcgui::ControlButton");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlButton\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlCheckMark* theObj = (XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlCheckMark_Type,"~XBMCAddon::xbmcgui::ControlCheckMark","XBMCAddon::xbmcgui::ControlCheckMark");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlCheckMark\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlCheckMark\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlGroup_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlGroup* theObj = (XBMCAddon::xbmcgui::ControlGroup*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlGroup_Type,"~XBMCAddon::xbmcgui::ControlGroup","XBMCAddon::xbmcgui::ControlGroup");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlGroup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlGroup\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlRadioButton* theObj = (XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlRadioButton_Type,"~XBMCAddon::xbmcgui::ControlRadioButton","XBMCAddon::xbmcgui::ControlRadioButton");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlRadioButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlRadioButton\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlSlider_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlSlider* theObj = (XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_ControlSlider_Type,"~XBMCAddon::xbmcgui::ControlSlider","XBMCAddon::xbmcgui::ControlSlider");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSlider\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSlider\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Dialog_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::Dialog* theObj = (XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Dialog_Type,"~XBMCAddon::xbmcgui::Dialog","XBMCAddon::xbmcgui::Dialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Dialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Dialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_DialogProgress_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::DialogProgress* theObj = (XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_DialogProgress_Type,"~XBMCAddon::xbmcgui::DialogProgress","XBMCAddon::xbmcgui::DialogProgress");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgress\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Action_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::Action* theObj = (XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Action_Type,"~XBMCAddon::xbmcgui::Action","XBMCAddon::xbmcgui::Action");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Action\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Action\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Window_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::Window* theObj = (XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_Window_Type,"~XBMCAddon::xbmcgui::Window","XBMCAddon::xbmcgui::Window");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Window\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Window\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowDialog_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowDialog* theObj = (XBMCAddon::xbmcgui::WindowDialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowDialog_Type,"~XBMCAddon::xbmcgui::WindowDialog","XBMCAddon::xbmcgui::WindowDialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowDialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowXML_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowXML* theObj = (XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXML_Type,"~XBMCAddon::xbmcgui::WindowXML","XBMCAddon::xbmcgui::WindowXML");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXML\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXML\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_Dealloc (PyHolder* self  )
  {
    TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowXMLDialog* theObj = (XBMCAddon::xbmcgui::WindowXMLDialog*)retrieveApiInstance((PyObject*)self,&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type,"~XBMCAddon::xbmcgui::WindowXMLDialog","XBMCAddon::xbmcgui::WindowXMLDialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXMLDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXMLDialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_addItems(PyObject* self, PyObject *args, PyObject *kwds)
  {
  TRACE;

  static const char *keywords[] = {
    "items",
    NULL};

  String  items;
  PyObject* pyitems = NULL;
  if (!PyArg_ParseTupleAndKeywords(
                                   args,
                                   kwds,
                                   (char*)"O",
                                   (char**)keywords,
                                   &pyitems
                                   ))
    return NULL;

  const char* callName = "addItems";
  try
  {
    XBMCAddon::xbmcgui::Control* tmp = ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,
                                        &PyXBMCAddon_xbmcgui_Control_Type,"addItem","XBMCAddon::xbmcgui::Control"));

    XBMCAddon::xbmcgui::ControlList* apiobj = dynamic_cast<XBMCAddon::xbmcgui::ControlList*>(tmp);

    if (apiobj == NULL)
      throw WrongTypeException("Incorrect type passed to '%s', was expecting a '%s'.",callName,"XBMCAddon::xbmcgui::Control");

    CGUIListItemPtr items(new CFileItemList());
    int listSize = PyList_Size(pyitems);
    for (int index = 0; index < listSize; index++)
    {
      PyObject *pyitem = PyList_GetItem(pyitems, index);

      if (PyUnicode_Check(pyitem) || PyString_Check(pyitem))
      {
        callName = "addItemStream";
        String  item;
        PyXBMCGetUnicodeString(item,pyitem,false,"item","addItem"); 
        apiobj->addItemStream(item,false);
      }
      else
      {
        callName = "addListItem";
        // assume it's a ListItem. retrieveApiInstance will throw an exception if it's not
        XBMCAddon::xbmcgui::ListItem* listItem = ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)pyitem,
                                                &PyXBMCAddon_xbmcgui_ListItem_Type,"addItem","XBMCAddon::xbmcgui::ListItem"));
        apiobj->addListItem(listItem,false);
      }
    }

    apiobj->sendLabelBind(listSize);
  }
  catch (const XbmcCommons::Exception& e)
  { 
    CLog::Log(LOGERROR,"EXCEPTION: from call to '%s' '%s' ... returning NULL", callName,e.GetMessage());
    PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    return NULL; 
  }
  catch (...)
  {
    CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call '%s'",callName);
    PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call 'addItem'"); 
    return NULL; 
  }

  PyObject* result;

  // transform the result
  Py_INCREF(Py_None);
  result = Py_None;

  return result; 
}

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_addItem(PyObject* self, PyObject *args, PyObject *kwds)
  {
  TRACE;

  static const char *keywords[] = {
    "item",
    NULL};

  String  item;
  PyObject* pyitem = NULL;
  if (!PyArg_ParseTupleAndKeywords(
                                   args,
                                   kwds,
                                   (char*)"O",
                                   (char**)keywords,
                                   &pyitem
                                   ))
    return NULL;

  const char* callName = "addItem";
  try
  {
    XBMCAddon::xbmcgui::Control* tmp = ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,
                                        &PyXBMCAddon_xbmcgui_Control_Type,"addItem","XBMCAddon::xbmcgui::Control"));

    XBMCAddon::xbmcgui::ControlList* apiobj = dynamic_cast<XBMCAddon::xbmcgui::ControlList*>(tmp);

    if (apiobj == NULL)
      throw WrongTypeException("Incorrect type passed to '%s', was expecting a '%s'.",callName,"XBMCAddon::xbmcgui::Control");


    if (PyUnicode_Check(pyitem) || PyString_Check(pyitem))
    {
      callName = "addItemStream";
      PyXBMCGetUnicodeString(item,pyitem,false,"item","addItem"); 
      apiobj->addItemStream(item);
    }
    else
    {
      callName = "addListItem";
      // assume it's a ListItem. retrieveApiInstance will throw an exception if it's not
      XBMCAddon::xbmcgui::ListItem* listItem = ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)pyitem,
                                              &PyXBMCAddon_xbmcgui_ListItem_Type,"addItem","XBMCAddon::xbmcgui::ListItem"));
      apiobj->addListItem(listItem);
    }
  }
  catch (const XbmcCommons::Exception& e)
  { 
    CLog::Log(LOGERROR,"EXCEPTION: from call to '%s' '%s' ... returning NULL", callName,e.GetMessage());
    PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    return NULL; 
  }
  catch (...)
  {
    CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call '%s'",callName);
    PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call 'addItem'"); 
    return NULL; 
  }

  PyObject* result;

  // transform the result
  Py_INCREF(Py_None);
  result = Py_None;

  return result; 
}

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItem(PyObject* self, PyObject *args, PyObject *kwds)
  {
  TRACE;

  static const char *keywords[] = {
    "item",
    NULL};

  String  item;
  PyObject* pyitem = NULL;
  if (!PyArg_ParseTupleAndKeywords(
                                   args,
                                   kwds,
                                   (char*)"O",
                                   (char**)keywords,
                                   &pyitem
                                   ))
    return NULL;

  const char* callName = "addItem";
  try
  {
    XBMCAddon::xbmcgui::WindowXML* apiobj = ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,
                                        &PyXBMCAddon_xbmcgui_WindowXML_Type,"addItem","XBMCAddon::xbmcgui::WindowXML"));

    if (PyUnicode_Check(pyitem) || PyString_Check(pyitem))
    {
      callName = "addItemString";
      PyXBMCGetUnicodeString(item,pyitem,false,"item","addItem"); 
      apiobj->addItem(item);
    }
    else
    {
      callName = "addListItem";
      // assume it's a ListItem. retrieveApiInstance will throw an exception if it's not
      XBMCAddon::xbmcgui::ListItem* listItem = ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)pyitem,
                                              &PyXBMCAddon_xbmcgui_ListItem_Type,"addItem","XBMCAddon::xbmcgui::ListItem"));
      apiobj->addListItem(listItem);
    }
  }
  catch (const XbmcCommons::Exception& e)
  { 
    CLog::Log(LOGERROR,"EXCEPTION: from call to '%s' '%s' ... returning NULL", callName,e.GetMessage());
    PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    return NULL; 
  }
  catch (...)
  {
    CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call '%s'",callName);
    PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call 'addItem'"); 
    return NULL; 
  }

  PyObject* result;

  // transform the result
  Py_INCREF(Py_None);
  result = Py_None;

  return result; 
}

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ListItem
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ListItem_methods[] = { 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getLabel__doc__ }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getLabel2__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setLabel__doc__ }, 
    {(char*)"setLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setLabel2__doc__ }, 
    {(char*)"setIconImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setIconImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setIconImage__doc__ }, 
    {(char*)"setThumbnailImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setThumbnailImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setThumbnailImage__doc__ }, 
    {(char*)"select", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_select, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_select__doc__ }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_isSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_isSelected__doc__ }, 
    {(char*)"setInfo", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setInfo, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setInfo__doc__ }, 
    {(char*)"addStreamInfo", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_addStreamInfo, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_addStreamInfo__doc__ }, 
    {(char*)"addContextMenuItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_addContextMenuItems, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_addContextMenuItems__doc__ }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setProperty__doc__ }, 
    {(char*)"getProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getProperty__doc__ }, 
    {(char*)"setPath", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setPath, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setPath__doc__ }, 
    {(char*)"setMimeType", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setMimeType, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setMimeType__doc__ }, 
    {(char*)"getdescription", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getdescription, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getdescription__doc__ }, 
    {(char*)"getduration", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getduration, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getduration__doc__ }, 
    {(char*)"getfilename", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getfilename, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getfilename__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ListItem_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ListItem_Type,&TyXBMCAddon_xbmcgui_ListItem_Type);

    PyXBMCAddon_xbmcgui_ListItem_Type.tp_name = (char*)"xbmcgui.ListItem";
    PyXBMCAddon_xbmcgui_ListItem_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ListItem_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ListItem_Dealloc; 

    PyXBMCAddon_xbmcgui_ListItem_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ListItem_Type.tp_doc = NULL;
    PyXBMCAddon_xbmcgui_ListItem_Type.tp_methods = XBMCAddon_xbmcgui_ListItem_methods;
    PyXBMCAddon_xbmcgui_ListItem_Type.tp_base = NULL;
    PyXBMCAddon_xbmcgui_ListItem_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ListItem_New;

    TyXBMCAddon_xbmcgui_ListItem_Type.swigType="p.XBMCAddon::xbmcgui::ListItem";  
  }
  //=========================================================================

  static int xbmcgui_XBMCAddon_xbmcgui_Control_cmp(PyObject* obj1, PyObject* obj2)
  {
    return PythonCompare<XBMCAddon::xbmcgui::Control>::compare(obj1,obj2,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","compare on XBMCAddon::xbmcgui::Control");
  }

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Control
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Control_methods[] = { 
    {(char*)"canAcceptMessages", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_canAcceptMessages, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_reset, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setSelected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setPercent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setDisabledColor", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setDisabledColor, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getPercent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"size", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_size, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setTextures", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setTextures, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setText, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setStaticContent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setStaticContent, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setSpace, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setRadioDimension", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setRadioDimension, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setPageControlVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setPageControlVisible, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setItemHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setImageDimensions", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setImageDimensions, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setImage, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setColorDiffuse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setColorDiffuse, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"selectItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_selectItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"scroll", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_scroll, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_isSelected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSpinControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getSpinControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getSpace, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSelectedPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getSelectedPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSelectedItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getSelectedItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getSelected, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getLabel2, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getItemHeight, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_addLabel, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addItemStream", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_addItemStream, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_addListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getId__doc__ }, 
    {(char*)"getPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getPosition__doc__ }, 
    {(char*)"getX", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getX, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getY", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getY, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getHeight__doc__ }, 
    {(char*)"getWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getWidth__doc__ }, 
    {(char*)"setEnabled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setEnabled, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setEnabled__doc__ }, 
    {(char*)"setVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setVisible, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setVisible__doc__ }, 
    {(char*)"setVisibleCondition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setVisibleCondition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setVisibleCondition__doc__ }, 
    {(char*)"setEnableCondition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setEnableCondition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setEnableCondition__doc__ }, 
    {(char*)"setAnimations", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setAnimations, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setAnimations__doc__ }, 
    {(char*)"setPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setPosition__doc__ }, 
    {(char*)"setWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setWidth__doc__ }, 
    {(char*)"setHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setHeight__doc__ }, 
    {(char*)"setNavigation", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setNavigation, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setNavigation__doc__ }, 
    {(char*)"controlUp", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlUp, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlUp__doc__ }, 
    {(char*)"controlDown", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlDown, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlDown__doc__ }, 
    {(char*)"controlLeft", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlLeft, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlLeft__doc__ }, 
    {(char*)"controlRight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlRight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlRight__doc__ }, 
    {(char*)"addItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_addItems, METH_VARARGS|METH_KEYWORDS, NULL},

    {(char*)"addItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_addItem, METH_VARARGS|METH_KEYWORDS, NULL},

    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Control_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Control__doc__,
                 "Parent for control classes. The problem here is that Python uses references to this class in a dynamic typing way. For example, you will find this type of python code frequently:\n"
"\n"
"window.getControl( 100 ).setLabel( \"Stupid Dynamic Type\")\n"
"\n"
"Notice that the 'getControl' call returns a 'Control ' object. In a dynamically typed language, the subsequent call to setLabel works if the specific type of control has the method. The script writer is often in a position to know more than the code about the specificControl type (in the example, that control id 100 is a 'ControlLabel ') where the C++ code is not.\n"
"\n"
"SWIG doesn't support this type of dynamic typing. The 'Control ' wrapper that's returned will wrap aControlLabel but will not have the 'setLabel' method on it. The only way to handle this is to add all possible subclass methods to the parent class. This is ugly but the alternative is nearly as ugly. It's particularly ugly here because the majority of the methods are unique to the particular subclass.\n"
"\n"
"If anyone thinks they have a solution then let me know. The alternative would be to have a set of 'getContol' methods, each one coresponding to a type so that the downcast can be done in the native code. IOW rather than a simple 'getControl' there would be a 'getControlLabel', 'getControlRadioButton', 'getControlButton', etc.\n"
"\n"
"TODO:This later solution should be implemented for future scripting languages while the former will remain as deprecated functionality for Python.\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_Control_Type,&TyXBMCAddon_xbmcgui_Control_Type);

    PyXBMCAddon_xbmcgui_Control_Type.tp_name = (char*)"xbmcgui.Control";
    PyXBMCAddon_xbmcgui_Control_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_Control_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Control_Dealloc; 
    PyXBMCAddon_xbmcgui_Control_Type.tp_compare=xbmcgui_XBMCAddon_xbmcgui_Control_cmp;

    PyXBMCAddon_xbmcgui_Control_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_Control_Type.tp_doc = XBMCAddon_xbmcgui_Control__doc__;
    PyXBMCAddon_xbmcgui_Control_Type.tp_methods = XBMCAddon_xbmcgui_Control_methods;
    PyXBMCAddon_xbmcgui_Control_Type.tp_base = NULL;
    PyXBMCAddon_xbmcgui_Control_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_Control_New;

    TyXBMCAddon_xbmcgui_Control_Type.swigType="p.XBMCAddon::xbmcgui::Control";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlSpin
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlSpin_methods[] = { 
    {(char*)"setTextures", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSpin_setTextures, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlSpin_setTextures__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlSpin_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSpin__doc__,
                 "ControlSpin class.\n"
"\n"
"\n"
"    - Not working yet -.\n"
"\n"
"\n"
"you can't create this object, it is returned by objects likeControlTextBox andControlList .\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlSpin_Type,&TyXBMCAddon_xbmcgui_ControlSpin_Type);

    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_name = (char*)"xbmcgui.ControlSpin";
    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlSpin_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_doc = XBMCAddon_xbmcgui_ControlSpin__doc__;
    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_methods = XBMCAddon_xbmcgui_ControlSpin_methods;
    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlSpin_Type.tp_new = NULL;

    TyXBMCAddon_xbmcgui_ControlSpin_Type.swigType="p.XBMCAddon::xbmcgui::ControlSpin";
    TyXBMCAddon_xbmcgui_ControlSpin_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlSpin_Type.converter=&XBMCAddon_xbmcgui_ControlSpin_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlLabel
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlLabel_methods[] = { 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlLabel_getLabel__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlLabel_setLabel__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlLabel_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlLabel__doc__,
                 "ControlLabel class.\n"
"\n"
"ControlLabel (x, y, width, height, label[, font, textColor, disabledColor, alignment, hasPath, angle])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. label : string or unicode - text string. font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled label's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled label's label. (e.g. '0xFFFF3300') alignment : [opt] integer - alignment of label - *Note, see xbfont.h hasPath : [opt] bool - True=stores a path / False=no path. angle : [opt] integer - angle of control. (+ rotates CCW, - rotates C\n"
"\n"
"example:\n"
"    - self.label =xbmcgui.ControlLabel (100, 250, 125, 75, 'Status', angle=45)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlLabel_Type,&TyXBMCAddon_xbmcgui_ControlLabel_Type);

    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_name = (char*)"xbmcgui.ControlLabel";
    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_doc = XBMCAddon_xbmcgui_ControlLabel__doc__;
    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_methods = XBMCAddon_xbmcgui_ControlLabel_methods;
    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlLabel_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlLabel_New;

    TyXBMCAddon_xbmcgui_ControlLabel_Type.swigType="p.XBMCAddon::xbmcgui::ControlLabel";
    TyXBMCAddon_xbmcgui_ControlLabel_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlLabel_Type.converter=&XBMCAddon_xbmcgui_ControlLabel_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlEdit
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlEdit_methods[] = { 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_setLabel__doc__ }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_getLabel__doc__ }, 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_setText__doc__ }, 
    {(char*)"getText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_getText__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlEdit_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit__doc__,
                 "ControlEdit class.\n"
"\n"
"ControlEdit (x, y, width, height, label[, font, textColor, disabledColor, alignment, focusTexture, noFocusTexture])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. label : string or unicode - text string. font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled label's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled label's label. (e.g. '0xFFFF3300') alignment : [opt] integer - alignment of label - *Note, see xbfont.h focusTexture : [opt] string - filename for focus texture. noFocusTexture : [opt] string - filename for no focus texture. isPassword : [opt] bool - if true, mask text value.\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.edit =xbmcgui.ControlEdit (100, 250, 125, 75, 'Status')\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlEdit_Type,&TyXBMCAddon_xbmcgui_ControlEdit_Type);

    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_name = (char*)"xbmcgui.ControlEdit";
    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_doc = XBMCAddon_xbmcgui_ControlEdit__doc__;
    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_methods = XBMCAddon_xbmcgui_ControlEdit_methods;
    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlEdit_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlEdit_New;

    TyXBMCAddon_xbmcgui_ControlEdit_Type.swigType="p.XBMCAddon::xbmcgui::ControlEdit";
    TyXBMCAddon_xbmcgui_ControlEdit_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlEdit_Type.converter=&XBMCAddon_xbmcgui_ControlEdit_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlList
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlList_methods[] = { 
    {(char*)"addItemStream", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_addItemStream, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_addItemStream__doc__ }, 
    {(char*)"addListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_addListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"selectItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_selectItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_selectItem__doc__ }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_reset, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_reset__doc__ }, 
    {(char*)"getSpinControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpinControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSpinControl__doc__ }, 
    {(char*)"getSelectedPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSelectedPosition__doc__ }, 
    {(char*)"getSelectedItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSelectedItem__doc__ }, 
    {(char*)"setImageDimensions", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setImageDimensions, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setImageDimensions__doc__ }, 
    {(char*)"setItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setItemHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setItemHeight__doc__ }, 
    {(char*)"setSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setSpace, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setSpace__doc__ }, 
    {(char*)"setPageControlVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setPageControlVisible, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setPageControlVisible__doc__ }, 
    {(char*)"size", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_size, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_size__doc__ }, 
    {(char*)"getItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getItemHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getItemHeight__doc__ }, 
    {(char*)"getSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpace, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSpace__doc__ }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getListItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getListItem__doc__ }, 
    {(char*)"setStaticContent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setStaticContent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setStaticContent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlList_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList__doc__,
                 "ControlList class.\n"
"\n"
"ControlList (x, y, width, height[, font, textColor, buttonTexture, buttonFocusTexture, selectedColor, imageWidth, imageHeight, itemTextXOffset, itemTextYOffset, itemHeight, space, alignmentY])\n"
"\"//, shadowColor])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. font : [opt] string - font used for items label. (e.g. 'font13') textColor : [opt] hexstring - color of items label. (e.g. '0xFFFFFFFF') buttonTexture : [opt] string - filename for focus texture. buttonFocusTexture : [opt] string - filename for no focus texture. selectedColor : [opt] integer - x offset of label. imageWidth : [opt] integer - width of items icon or thumbnail. imageHeight : [opt] integer - height of items icon or thumbnail. itemTextXOffset : [opt] integer - x offset of items label. itemTextYOffset : [opt] integer - y offset of items label. itemHeight : [opt] integer - height of items. space : [opt] integer - space between items. alignmentY : [opt] integer - Y-axis alignment of items label - *Note, see xbfont.h //\"shadowColor : [opt] hexstring - color of items label's shadow. (e.g. '0xFF000000')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.cList =xbmcgui.ControlList (100, 250, 200, 250, 'font14', space=5)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlList_Type,&TyXBMCAddon_xbmcgui_ControlList_Type);

    PyXBMCAddon_xbmcgui_ControlList_Type.tp_name = (char*)"xbmcgui.ControlList";
    PyXBMCAddon_xbmcgui_ControlList_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlList_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlList_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlList_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlList_Type.tp_doc = XBMCAddon_xbmcgui_ControlList__doc__;
    PyXBMCAddon_xbmcgui_ControlList_Type.tp_methods = XBMCAddon_xbmcgui_ControlList_methods;
    PyXBMCAddon_xbmcgui_ControlList_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlList_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlList_New;

    TyXBMCAddon_xbmcgui_ControlList_Type.swigType="p.XBMCAddon::xbmcgui::ControlList";
    TyXBMCAddon_xbmcgui_ControlList_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlList_Type.converter=&XBMCAddon_xbmcgui_ControlList_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlFadeLabel
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlFadeLabel_methods[] = { 
    {(char*)"addLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_addLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlFadeLabel_addLabel__doc__ }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_reset, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlFadeLabel_reset__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlFadeLabel_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlFadeLabel__doc__,
                 "ControlFadeLabel class.Control that scroll's labl\n"
"\n"
"ControlFadeLabel(x, y, width, height[, font, textColor, alignment])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of fadelabel's labels. (e.g. '0xFFFFFFFF') alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.fadelabel =xbmcgui.ControlFadeLabel (100, 250, 200, 50, textColor='0xFFFFFFFF')\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type);

    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_name = (char*)"xbmcgui.ControlFadeLabel";
    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_doc = XBMCAddon_xbmcgui_ControlFadeLabel__doc__;
    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_methods = XBMCAddon_xbmcgui_ControlFadeLabel_methods;
    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlFadeLabel_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_New;

    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.swigType="p.XBMCAddon::xbmcgui::ControlFadeLabel";
    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.converter=&XBMCAddon_xbmcgui_ControlFadeLabel_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlTextBox
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlTextBox_methods[] = { 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_setText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_setText__doc__ }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_reset, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_reset__doc__ }, 
    {(char*)"scroll", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_scroll, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_scroll__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlTextBox_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox__doc__,
                 "ControlTextBox class.\n"
"\n"
"ControlTextBox(x, y, width, height[, font, textColor])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. font : [opt] string - font used for text. (e.g. 'font13') textColor : [opt] hexstring - color of textbox's text. (e.g. '0xFFFFFFFF')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.textbox =xbmcgui.ControlTextBox (100, 250, 300, 300, textColor='0xFFFFFFFF')\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlTextBox_Type,&TyXBMCAddon_xbmcgui_ControlTextBox_Type);

    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_name = (char*)"xbmcgui.ControlTextBox";
    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_doc = XBMCAddon_xbmcgui_ControlTextBox__doc__;
    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_methods = XBMCAddon_xbmcgui_ControlTextBox_methods;
    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlTextBox_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_New;

    TyXBMCAddon_xbmcgui_ControlTextBox_Type.swigType="p.XBMCAddon::xbmcgui::ControlTextBox";
    TyXBMCAddon_xbmcgui_ControlTextBox_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlTextBox_Type.converter=&XBMCAddon_xbmcgui_ControlTextBox_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlImage
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlImage_methods[] = { 
    {(char*)"setImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlImage_setImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlImage_setImage__doc__ }, 
    {(char*)"setColorDiffuse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlImage_setColorDiffuse, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlImage_setColorDiffuse__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlImage_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlImage__doc__,
                 "ControlImage class.\n"
"\n"
"ControlImage(x, y, width, height, filename[, aspectRatio, colorDiffuse])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. filename : string - image filename. aspectRatio : [opt] integer - (values 0 = stretch (default), 1 = scale up (crops), 2 = scale down (black bar colorDiffuse : hexString - (example, '0xC0FF0000' (red tint))\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.image =xbmcgui.ControlImage (100, 250, 125, 75, aspectRatio=2)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlImage_Type,&TyXBMCAddon_xbmcgui_ControlImage_Type);

    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_name = (char*)"xbmcgui.ControlImage";
    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlImage_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_doc = XBMCAddon_xbmcgui_ControlImage__doc__;
    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_methods = XBMCAddon_xbmcgui_ControlImage_methods;
    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlImage_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlImage_New;

    TyXBMCAddon_xbmcgui_ControlImage_Type.swigType="p.XBMCAddon::xbmcgui::ControlImage";
    TyXBMCAddon_xbmcgui_ControlImage_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlImage_Type.converter=&XBMCAddon_xbmcgui_ControlImage_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlProgress
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlProgress_methods[] = { 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_setPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlProgress_setPercent__doc__ }, 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_getPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlProgress_getPercent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlProgress_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlProgress_Type,&TyXBMCAddon_xbmcgui_ControlProgress_Type);

    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_name = (char*)"xbmcgui.ControlProgress";
    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_doc = NULL;
    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_methods = XBMCAddon_xbmcgui_ControlProgress_methods;
    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlProgress_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlProgress_New;

    TyXBMCAddon_xbmcgui_ControlProgress_Type.swigType="p.XBMCAddon::xbmcgui::ControlProgress";
    TyXBMCAddon_xbmcgui_ControlProgress_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlProgress_Type.converter=&XBMCAddon_xbmcgui_ControlProgress_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlButton
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlButton_methods[] = { 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_setLabel__doc__ }, 
    {(char*)"setDisabledColor", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_setDisabledColor, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_setDisabledColor__doc__ }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_getLabel__doc__ }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_getLabel2__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlButton_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton__doc__,
                 "ControlButton class.\n"
"\n"
"ControlButton (x, y, width, height, label[, focusTexture, noFocusTexture, textOffsetX, textOffsetY, alignment, font, textColor, disabledColor, angle, shadowColor, focusedColor])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. label : string or unicode - text string. focusTexture : [opt] string - filename for focus texture. noFocusTexture : [opt] string - filename for no focus texture. textOffsetX : [opt] integer - x offset of label. textOffsetY : [opt] integer - y offset of label. alignment : [opt] integer - alignment of label - *Note, see xbfont.h font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled button's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled button's label. (e.g. '0xFFFF3300') angle : [opt] integer - angle of control. (+ rotates CCW, - rotates CW) shadowColor : [opt] hexstring - color of button's label's shadow. (e.g. '0xFF000000') focusedColor : [opt] hexstring - color of focused button's label. (e.g. '0xFF00FFFF')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.button =xbmcgui.ControlButton (100, 250, 200, 50, 'Status', font='font14')\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlButton_Type,&TyXBMCAddon_xbmcgui_ControlButton_Type);

    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_name = (char*)"xbmcgui.ControlButton";
    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlButton_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_doc = XBMCAddon_xbmcgui_ControlButton__doc__;
    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_methods = XBMCAddon_xbmcgui_ControlButton_methods;
    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlButton_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlButton_New;

    TyXBMCAddon_xbmcgui_ControlButton_Type.swigType="p.XBMCAddon::xbmcgui::ControlButton";
    TyXBMCAddon_xbmcgui_ControlButton_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlButton_Type.converter=&XBMCAddon_xbmcgui_ControlButton_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlCheckMark
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlCheckMark_methods[] = { 
    {(char*)"getSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_getSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_getSelected__doc__ }, 
    {(char*)"setSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_setSelected__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_setLabel__doc__ }, 
    {(char*)"setDisabledColor", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlCheckMark_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark__doc__,
                 "ControlCheckMark class.\n"
"\n"
"ControlCheckMark (x, y, width, height, label[, focusTexture, noFocusTexture, checkWidth, checkHeight, alignment, font, textColor, disabledColor])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. label : string or unicode - text string. focusTexture : [opt] string - filename for focus texture. noFocusTexture : [opt] string - filename for no focus texture. checkWidth : [opt] integer - width of checkmark. checkHeight : [opt] integer - height of checkmark. alignment : [opt] integer - alignment of label - *Note, see xbfont.h font : [opt] string - font used for label text. (e.g. 'font13') textColor : [opt] hexstring - color of enabled checkmark's label. (e.g. '0xFFFFFFFF') disabledColor : [opt] hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.checkmark =xbmcgui.ControlCheckMark (100, 250, 200, 50, 'Status', font='font14')\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlCheckMark_Type,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type);

    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_name = (char*)"xbmcgui.ControlCheckMark";
    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_doc = XBMCAddon_xbmcgui_ControlCheckMark__doc__;
    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_methods = XBMCAddon_xbmcgui_ControlCheckMark_methods;
    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlCheckMark_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_New;

    TyXBMCAddon_xbmcgui_ControlCheckMark_Type.swigType="p.XBMCAddon::xbmcgui::ControlCheckMark";
    TyXBMCAddon_xbmcgui_ControlCheckMark_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlCheckMark_Type.converter=&XBMCAddon_xbmcgui_ControlCheckMark_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlGroup
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlGroup_methods[] = { 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlGroup_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlGroup__doc__,
                 "ControlGroup class.\n"
"\n"
"ControlGroup (x, y, width, height\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. example:\n"
"    - self.group = xbmcgui.ControlGroup(100, 250, 125, 75)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlGroup_Type,&TyXBMCAddon_xbmcgui_ControlGroup_Type);

    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_name = (char*)"xbmcgui.ControlGroup";
    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlGroup_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_doc = XBMCAddon_xbmcgui_ControlGroup__doc__;
    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_methods = XBMCAddon_xbmcgui_ControlGroup_methods;
    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlGroup_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlGroup_New;

    TyXBMCAddon_xbmcgui_ControlGroup_Type.swigType="p.XBMCAddon::xbmcgui::ControlGroup";
    TyXBMCAddon_xbmcgui_ControlGroup_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlGroup_Type.converter=&XBMCAddon_xbmcgui_ControlGroup_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlRadioButton
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlRadioButton_methods[] = { 
    {(char*)"setSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_setSelected__doc__ }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_isSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_isSelected__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_setLabel__doc__ }, 
    {(char*)"setRadioDimension", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlRadioButton_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlRadioButton_Type,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type);

    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_name = (char*)"xbmcgui.ControlRadioButton";
    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_doc = NULL;
    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_methods = XBMCAddon_xbmcgui_ControlRadioButton_methods;
    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlRadioButton_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_New;

    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.swigType="p.XBMCAddon::xbmcgui::ControlRadioButton";
    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.converter=&XBMCAddon_xbmcgui_ControlRadioButton_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlSlider
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlSlider_methods[] = { 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_getPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlSlider_getPercent__doc__ }, 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_setPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlSlider_setPercent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlSlider_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSlider__doc__,
                 "ControlSlider class.\n"
"\n"
"ControlSlider(x, y, width, height[, textureback, texture, texturefocus])\n"
"\n"
"x : integer - x coordinate of control. y : integer - y coordinate of control. width : integer - width of control. height : integer - height of control. textureback : [opt] string - image filename. texture : [opt] string - image filename. texturefocus : [opt] string - image filename.\n"
"\" *Note, You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword. After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.slider = xbmcgui.ControlSlider(100, 250, 350, 40)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_ControlSlider_Type,&TyXBMCAddon_xbmcgui_ControlSlider_Type);

    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_name = (char*)"xbmcgui.ControlSlider";
    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_Dealloc; 

    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_doc = XBMCAddon_xbmcgui_ControlSlider__doc__;
    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_methods = XBMCAddon_xbmcgui_ControlSlider_methods;
    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_base = &PyXBMCAddon_xbmcgui_Control_Type;
    PyXBMCAddon_xbmcgui_ControlSlider_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlSlider_New;

    TyXBMCAddon_xbmcgui_ControlSlider_Type.swigType="p.XBMCAddon::xbmcgui::ControlSlider";
    TyXBMCAddon_xbmcgui_ControlSlider_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;
    TyXBMCAddon_xbmcgui_ControlSlider_Type.converter=&XBMCAddon_xbmcgui_ControlSlider_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Dialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Dialog_methods[] = { 
    {(char*)"yesno", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_yesno, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_yesno__doc__ }, 
    {(char*)"select", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_select, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_select__doc__ }, 
    {(char*)"ok", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_ok, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_ok__doc__ }, 
    {(char*)"browse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browse, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_browse__doc__ }, 
    {(char*)"browseSingle", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browseSingle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_browseSingle__doc__ }, 
    {(char*)"browseMultiple", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browseMultiple, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_browseMultiple__doc__ }, 
    {(char*)"numeric", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_numeric, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_numeric__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Dialog_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog__doc__,
                 "Dialog class (Duh!)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_Dialog_Type,&TyXBMCAddon_xbmcgui_Dialog_Type);

    PyXBMCAddon_xbmcgui_Dialog_Type.tp_name = (char*)"xbmcgui.Dialog";
    PyXBMCAddon_xbmcgui_Dialog_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_Dialog_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Dialog_Dealloc; 

    PyXBMCAddon_xbmcgui_Dialog_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_Dialog_Type.tp_doc = XBMCAddon_xbmcgui_Dialog__doc__;
    PyXBMCAddon_xbmcgui_Dialog_Type.tp_methods = XBMCAddon_xbmcgui_Dialog_methods;
    PyXBMCAddon_xbmcgui_Dialog_Type.tp_base = NULL;
    PyXBMCAddon_xbmcgui_Dialog_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_Dialog_New;

    TyXBMCAddon_xbmcgui_Dialog_Type.swigType="p.XBMCAddon::xbmcgui::Dialog";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::DialogProgress
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_DialogProgress_methods[] = { 
    {(char*)"create", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_create, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_create__doc__ }, 
    {(char*)"update", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_update, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_update__doc__ }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_close, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_close__doc__ }, 
    {(char*)"iscanceled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_iscanceled, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_iscanceled__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_DialogProgress_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress__doc__,
                 "DialogProgress class (Duh!)\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_DialogProgress_Type,&TyXBMCAddon_xbmcgui_DialogProgress_Type);

    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_name = (char*)"xbmcgui.DialogProgress";
    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_Dealloc; 

    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_doc = XBMCAddon_xbmcgui_DialogProgress__doc__;
    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_methods = XBMCAddon_xbmcgui_DialogProgress_methods;
    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_base = NULL;
    PyXBMCAddon_xbmcgui_DialogProgress_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_DialogProgress_New;

    TyXBMCAddon_xbmcgui_DialogProgress_Type.swigType="p.XBMCAddon::xbmcgui::DialogProgress";  
  }
  //=========================================================================

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_rcmp(PyObject* obj1, PyObject *obj2, int method)
  { TRACE;
    if (method == Py_EQ)
    {
      XBMCAddon::xbmcgui::Action* a1 = (Action*)retrieveApiInstance(obj1,&PyXBMCAddon_xbmcgui_Action_Type,"rcmp","XBMCAddon::xbmcgui::Action");
      if (PyObject_TypeCheck(obj2, &PyXBMCAddon_xbmcgui_Action_Type))
      {
        // both are Action objects
        XBMCAddon::xbmcgui::Action* a2 = (Action*)retrieveApiInstance(obj2,&PyXBMCAddon_xbmcgui_Action_Type,"rcmp","XBMCAddon::xbmcgui::Action");

        if (a1->id == a2->id &&
            a1->buttonCode == a2->buttonCode &&
            a1->fAmount1 == a2->fAmount1 &&
            a1->fAmount2 == a2->fAmount2 &&
            a1->fRepeat == a2->fRepeat &&
            a1->strAction == a2->strAction)
        {
          Py_RETURN_TRUE;
        }
        else
        {
          Py_RETURN_FALSE;
        }
      }
      else
      {
        // for backwards compatability in python scripts
        PyObject* o1 = PyLong_FromLong(a1->id);
        return PyObject_RichCompare(o1, obj2, method);
      }
    }
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
  }

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Action
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Action_methods[] = { 
    {(char*)"getId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getId, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getButtonCode", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getButtonCode, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAmount1", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getAmount1, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getAmount2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getAmount2, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Action_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_Action_Type,&TyXBMCAddon_xbmcgui_Action_Type);

    PyXBMCAddon_xbmcgui_Action_Type.tp_name = (char*)"xbmcgui.Action";
    PyXBMCAddon_xbmcgui_Action_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_Action_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Action_Dealloc; 
    PyXBMCAddon_xbmcgui_Action_Type.tp_richcompare=(richcmpfunc)xbmcgui_XBMCAddon_xbmcgui_Action_rcmp;

    PyXBMCAddon_xbmcgui_Action_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_Action_Type.tp_doc = NULL;
    PyXBMCAddon_xbmcgui_Action_Type.tp_methods = XBMCAddon_xbmcgui_Action_methods;
    PyXBMCAddon_xbmcgui_Action_Type.tp_base = NULL;
    PyXBMCAddon_xbmcgui_Action_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_Action_New;

    TyXBMCAddon_xbmcgui_Action_Type.swigType="p.XBMCAddon::xbmcgui::Action";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Window
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Window_methods[] = { 
    {(char*)"onAction", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onAction, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onAction__doc__ }, 
    {(char*)"onControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onControl, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onClick", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onClick, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onFocus, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"onInit", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onInit, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"show", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_show, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_show__doc__ }, 
    {(char*)"setFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setFocus, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setFocus__doc__ }, 
    {(char*)"setFocusId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setFocusId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setFocusId__doc__ }, 
    {(char*)"getFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getFocus, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getFocus__doc__ }, 
    {(char*)"getFocusId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getFocusId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getFocusId__doc__ }, 
    {(char*)"removeControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_removeControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_removeControl__doc__ }, 
    {(char*)"removeControls", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_removeControls, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_removeControls__doc__ }, 
    {(char*)"getHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getHeight__doc__ }, 
    {(char*)"getWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getWidth__doc__ }, 
    {(char*)"getResolution", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getResolution, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getResolution__doc__ }, 
    {(char*)"setCoordinateResolution", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setCoordinateResolution, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setCoordinateResolution__doc__ }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setProperty__doc__ }, 
    {(char*)"getProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getProperty__doc__ }, 
    {(char*)"clearProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_clearProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_clearProperty__doc__ }, 
    {(char*)"clearProperties", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_clearProperties, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_clearProperties__doc__ }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_close, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_close__doc__ }, 
    {(char*)"doModal", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_doModal, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_doModal__doc__ }, 
    {(char*)"addControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_addControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_addControl__doc__ }, 
    {(char*)"addControls", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_addControls, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_addControls__doc__ }, 
    {(char*)"getControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getControl__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Window_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Window__doc__,
                 "This is the main class for thexbmcgui.Window functionality. It is tied into the main XBMC windowing system via theInterceptor \n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_Window_Type,&TyXBMCAddon_xbmcgui_Window_Type);

    PyXBMCAddon_xbmcgui_Window_Type.tp_name = (char*)"xbmcgui.Window";
    PyXBMCAddon_xbmcgui_Window_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_Window_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Window_Dealloc; 

    PyXBMCAddon_xbmcgui_Window_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_Window_Type.tp_doc = XBMCAddon_xbmcgui_Window__doc__;
    PyXBMCAddon_xbmcgui_Window_Type.tp_methods = XBMCAddon_xbmcgui_Window_methods;
    PyXBMCAddon_xbmcgui_Window_Type.tp_base = NULL;
    PyXBMCAddon_xbmcgui_Window_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_Window_New;

    TyXBMCAddon_xbmcgui_Window_Type.swigType="p.XBMCAddon::xbmcgui::Window";  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowDialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowDialog_methods[] = { 
    {(char*)"show", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowDialog_show, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowDialog_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowDialog_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_WindowDialog_Type,&TyXBMCAddon_xbmcgui_WindowDialog_Type);

    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_name = (char*)"xbmcgui.WindowDialog";
    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowDialog_Dealloc; 

    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_doc = NULL;
    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_methods = XBMCAddon_xbmcgui_WindowDialog_methods;
    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_base = &PyXBMCAddon_xbmcgui_Window_Type;
    PyXBMCAddon_xbmcgui_WindowDialog_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowDialog_New;

    TyXBMCAddon_xbmcgui_WindowDialog_Type.swigType="p.XBMCAddon::xbmcgui::WindowDialog";
    TyXBMCAddon_xbmcgui_WindowDialog_Type.parentType=&TyXBMCAddon_xbmcgui_Window_Type;
    TyXBMCAddon_xbmcgui_WindowDialog_Type.converter=&XBMCAddon_xbmcgui_WindowDialog_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowXML
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowXML_methods[] = { 
    {(char*)"addItemString", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItemString, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_addListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"removeItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_removeItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getCurrentListPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setCurrentListPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListItem, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getListSize", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListSize, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"clearList", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_clearList, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_setProperty, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"addItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItem, METH_VARARGS|METH_KEYWORDS, NULL},

    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowXML_Type()
  {

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_WindowXML_Type,&TyXBMCAddon_xbmcgui_WindowXML_Type);

    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_name = (char*)"xbmcgui.WindowXML";
    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowXML_Dealloc; 

    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_doc = NULL;
    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_methods = XBMCAddon_xbmcgui_WindowXML_methods;
    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_base = &PyXBMCAddon_xbmcgui_Window_Type;
    PyXBMCAddon_xbmcgui_WindowXML_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowXML_New;

    TyXBMCAddon_xbmcgui_WindowXML_Type.swigType="p.XBMCAddon::xbmcgui::WindowXML";
    TyXBMCAddon_xbmcgui_WindowXML_Type.parentType=&TyXBMCAddon_xbmcgui_Window_Type;
    TyXBMCAddon_xbmcgui_WindowXML_Type.converter=&XBMCAddon_xbmcgui_WindowXML_ParentConverter;
  
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowXMLDialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowXMLDialog_methods[] = { 
    {(char*)"show", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_show, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_close, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {NULL, NULL, 0, NULL}
  };

  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowXMLDialog_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXMLDialog__doc__,
                 "Ideally what we want here is a Dialog/MediaWindow . The problem is that these are two orthogonal discriminations of CGUIWindow and there wasn't a previous accounting for this possibility through the use of making CGUIWindow a virtual base class of the pertinent subclasses. So now we're left with no good solution.\n"
"\n"
"<strike>So here we're going to have the 'main' hierarchy (the one visible to SWIG) go the way intended - throughWindowXML , but we're going to borrow dialog functionality from CGUIDialog by using it as a Mixin.</strike>\n"
"\n"
"jmarshall says that this class has no reason to inherit fromCGUIMediaWindow . At some point this entire hierarchy needs to be reworked. The XML handling routines should be put in a mixin.\n"
                );

    PyXBMCInitializeTypeObject(&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type,&TyXBMCAddon_xbmcgui_WindowXMLDialog_Type);

    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_name = (char*)"xbmcgui.WindowXMLDialog";
    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_basicsize = sizeof(PyHolder);
    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_Dealloc; 

    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_doc = XBMCAddon_xbmcgui_WindowXMLDialog__doc__;
    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_methods = XBMCAddon_xbmcgui_WindowXMLDialog_methods;
    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_base = &PyXBMCAddon_xbmcgui_WindowXML_Type;
    PyXBMCAddon_xbmcgui_WindowXMLDialog_Type.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_New;

    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.swigType="p.XBMCAddon::xbmcgui::WindowXMLDialog";
    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.parentType=&TyXBMCAddon_xbmcgui_WindowXML_Type;
    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.converter=&XBMCAddon_xbmcgui_WindowXMLDialog_ParentConverter;
  
  }
  //=========================================================================


  static PyMethodDef xbmcgui_methods[] = { 
    {(char*)"lock", (PyCFunction)xbmcgui_lock, METH_VARARGS|METH_KEYWORDS, lock__doc__ }, 
    {(char*)"unlock", (PyCFunction)xbmcgui_unlock, METH_VARARGS|METH_KEYWORDS, unlock__doc__ }, 
    {(char*)"getCurrentWindowId", (PyCFunction)xbmcgui_getCurrentWindowId, METH_VARARGS|METH_KEYWORDS, getCurrentWindowId__doc__ }, 
    {(char*)"getCurrentWindowDialogId", (PyCFunction)xbmcgui_getCurrentWindowDialogId, METH_VARARGS|METH_KEYWORDS, getCurrentWindowDialogId__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmcgui_ListItem_Type();
      initPyXBMCAddon_xbmcgui_Control_Type();
      initPyXBMCAddon_xbmcgui_ControlSpin_Type();
      initPyXBMCAddon_xbmcgui_ControlLabel_Type();
      initPyXBMCAddon_xbmcgui_ControlEdit_Type();
      initPyXBMCAddon_xbmcgui_ControlList_Type();
      initPyXBMCAddon_xbmcgui_ControlFadeLabel_Type();
      initPyXBMCAddon_xbmcgui_ControlTextBox_Type();
      initPyXBMCAddon_xbmcgui_ControlImage_Type();
      initPyXBMCAddon_xbmcgui_ControlProgress_Type();
      initPyXBMCAddon_xbmcgui_ControlButton_Type();
      initPyXBMCAddon_xbmcgui_ControlCheckMark_Type();
      initPyXBMCAddon_xbmcgui_ControlGroup_Type();
      initPyXBMCAddon_xbmcgui_ControlRadioButton_Type();
      initPyXBMCAddon_xbmcgui_ControlSlider_Type();
      initPyXBMCAddon_xbmcgui_Dialog_Type();
      initPyXBMCAddon_xbmcgui_DialogProgress_Type();
      initPyXBMCAddon_xbmcgui_Action_Type();
      initPyXBMCAddon_xbmcgui_Window_Type();
      initPyXBMCAddon_xbmcgui_WindowDialog_Type();
      initPyXBMCAddon_xbmcgui_WindowXML_Type();
      initPyXBMCAddon_xbmcgui_WindowXMLDialog_Type();
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ListItem_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_Control_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlSpin_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlLabel_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlEdit_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlList_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlTextBox_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlImage_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlProgress_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlButton_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlCheckMark_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlGroup_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlRadioButton_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_ControlSlider_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_Dialog_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_DialogProgress_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_Action_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_Window_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_WindowDialog_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_WindowXML_Type) < 0)
        return;
      if (PyType_Ready(&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type) < 0)
        return;
    }
  }

  void initModule_xbmcgui()
  {
    initTypes();

    // init general xbmcgui modules
    PyObject* module;


    Py_INCREF(&PyXBMCAddon_xbmcgui_ListItem_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_Control_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlSpin_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlLabel_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlEdit_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlList_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlTextBox_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlImage_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlProgress_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlButton_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlCheckMark_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlGroup_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlRadioButton_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_ControlSlider_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_Dialog_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_DialogProgress_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_Action_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_Window_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_WindowDialog_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_WindowXML_Type);
    Py_INCREF(&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type);

    module = Py_InitModule((char*)"xbmcgui", xbmcgui_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"ListItem", (PyObject*)&PyXBMCAddon_xbmcgui_ListItem_Type);
    PyModule_AddObject(module, (char*)"Control", (PyObject*)&PyXBMCAddon_xbmcgui_Control_Type);
    PyModule_AddObject(module, (char*)"ControlSpin", (PyObject*)&PyXBMCAddon_xbmcgui_ControlSpin_Type);
    PyModule_AddObject(module, (char*)"ControlLabel", (PyObject*)&PyXBMCAddon_xbmcgui_ControlLabel_Type);
    PyModule_AddObject(module, (char*)"ControlEdit", (PyObject*)&PyXBMCAddon_xbmcgui_ControlEdit_Type);
    PyModule_AddObject(module, (char*)"ControlList", (PyObject*)&PyXBMCAddon_xbmcgui_ControlList_Type);
    PyModule_AddObject(module, (char*)"ControlFadeLabel", (PyObject*)&PyXBMCAddon_xbmcgui_ControlFadeLabel_Type);
    PyModule_AddObject(module, (char*)"ControlTextBox", (PyObject*)&PyXBMCAddon_xbmcgui_ControlTextBox_Type);
    PyModule_AddObject(module, (char*)"ControlImage", (PyObject*)&PyXBMCAddon_xbmcgui_ControlImage_Type);
    PyModule_AddObject(module, (char*)"ControlProgress", (PyObject*)&PyXBMCAddon_xbmcgui_ControlProgress_Type);
    PyModule_AddObject(module, (char*)"ControlButton", (PyObject*)&PyXBMCAddon_xbmcgui_ControlButton_Type);
    PyModule_AddObject(module, (char*)"ControlCheckMark", (PyObject*)&PyXBMCAddon_xbmcgui_ControlCheckMark_Type);
    PyModule_AddObject(module, (char*)"ControlGroup", (PyObject*)&PyXBMCAddon_xbmcgui_ControlGroup_Type);
    PyModule_AddObject(module, (char*)"ControlRadioButton", (PyObject*)&PyXBMCAddon_xbmcgui_ControlRadioButton_Type);
    PyModule_AddObject(module, (char*)"ControlSlider", (PyObject*)&PyXBMCAddon_xbmcgui_ControlSlider_Type);
    PyModule_AddObject(module, (char*)"Dialog", (PyObject*)&PyXBMCAddon_xbmcgui_Dialog_Type);
    PyModule_AddObject(module, (char*)"DialogProgress", (PyObject*)&PyXBMCAddon_xbmcgui_DialogProgress_Type);
    PyModule_AddObject(module, (char*)"Action", (PyObject*)&PyXBMCAddon_xbmcgui_Action_Type);
    PyModule_AddObject(module, (char*)"Window", (PyObject*)&PyXBMCAddon_xbmcgui_Window_Type);
    PyModule_AddObject(module, (char*)"WindowDialog", (PyObject*)&PyXBMCAddon_xbmcgui_WindowDialog_Type);
    PyModule_AddObject(module, (char*)"WindowXML", (PyObject*)&PyXBMCAddon_xbmcgui_WindowXML_Type);
    PyModule_AddObject(module, (char*)"WindowXMLDialog", (PyObject*)&PyXBMCAddon_xbmcgui_WindowXMLDialog_Type);

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team XBMC <www.xbmc.org>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Fri Jan 18 00:23:30 EST 2013");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team XBMC");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"ICON_OVERLAY_NONE",(int)CGUIListItem::ICON_OVERLAY_NONE); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_RAR",(int)CGUIListItem::ICON_OVERLAY_RAR); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_ZIP",(int)CGUIListItem::ICON_OVERLAY_ZIP); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_LOCKED",(int)CGUIListItem::ICON_OVERLAY_LOCKED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_HAS_TRAINER",(int)CGUIListItem::ICON_OVERLAY_HAS_TRAINER); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_TRAINED",(int)CGUIListItem::ICON_OVERLAY_TRAINED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_UNWATCHED",(int)CGUIListItem::ICON_OVERLAY_UNWATCHED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_WATCHED",(int)CGUIListItem::ICON_OVERLAY_WATCHED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_HD",(int)CGUIListItem::ICON_OVERLAY_HD); 
   PyModule_AddIntConstant(module,"CONTROL_TEXT_OFFSET_X",(int)10); 
   PyModule_AddIntConstant(module,"CONTROL_TEXT_OFFSET_Y",(int)2); 
  }

} // end PythonBindings namespace for python type definitions

