/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import groovy.lang.ReadOnlyPropertyException;
import groovy.transform.Immutable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.transform.AbstractASTTransformUtil;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.EqualsAndHashCodeASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.ToStringASTTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ImmutableASTTransformation
extends AbstractASTTransformation {
    private static List<String> immutableList = Arrays.asList("java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Double", "java.lang.Float", "java.lang.Integer", "java.lang.Long", "java.lang.Short", "java.lang.String", "java.math.BigInteger", "java.math.BigDecimal", "java.awt.Color", "java.net.URI", "java.util.UUID");
    private static final Class MY_CLASS = Immutable.class;
    static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    private static final ClassNode DATE_TYPE = ClassHelper.make(Date.class);
    private static final ClassNode CLONEABLE_TYPE = ClassHelper.make(Cloneable.class);
    private static final ClassNode COLLECTION_TYPE = ClassHelper.makeWithoutCaching(Collection.class, false);
    private static final ClassNode READONLYEXCEPTION_TYPE = ClassHelper.make(ReadOnlyPropertyException.class);
    private static final ClassNode DGM_TYPE = ClassHelper.make(DefaultGroovyMethods.class);
    private static final ClassNode SELF_TYPE = ClassHelper.make(ImmutableASTTransformation.class);
    private static final ClassNode HASHMAP_TYPE = ClassHelper.makeWithoutCaching(HashMap.class, false);
    private static final ClassNode MAP_TYPE = ClassHelper.makeWithoutCaching(Map.class, false);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode parent = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!node.getClassNode().getName().endsWith(".Immutable")) {
            return;
        }
        ArrayList<PropertyNode> newProperties = new ArrayList<PropertyNode>();
        if (parent instanceof ClassNode) {
            ClassNode cNode = (ClassNode)parent;
            String cName = cNode.getName();
            this.checkNotInterface(cNode, MY_TYPE_NAME);
            this.makeClassFinal(cNode);
            List<PropertyNode> pList = AbstractASTTransformUtil.getInstanceProperties(cNode);
            for (PropertyNode pNode : pList) {
                this.adjustPropertyForImmutability(pNode, newProperties);
            }
            for (PropertyNode pNode : newProperties) {
                cNode.getProperties().remove(pNode);
                this.addProperty(cNode, pNode);
            }
            List<FieldNode> fList = cNode.getFields();
            for (FieldNode fNode : fList) {
                this.ensureNotPublic(cName, fNode);
            }
            this.createConstructors(cNode);
            EqualsAndHashCodeASTTransformation.createHashCode(cNode, true, false, false, null, null);
            EqualsAndHashCodeASTTransformation.createEquals(cNode, false, false, false, null, null);
            ToStringASTTransformation.createToString(cNode, false, false, null, null);
        }
    }

    private void makeClassFinal(ClassNode cNode) {
        if ((cNode.getModifiers() & 0x10) == 0) {
            cNode.setModifiers(cNode.getModifiers() | 0x10);
        }
    }

    private void createConstructors(ClassNode cNode) {
        boolean specialHashMapCase;
        FieldNode constructorField = cNode.addField("$print$names", 4098, ClassHelper.boolean_TYPE, null);
        VariableExpression constructorStyle = new VariableExpression(constructorField);
        if (!this.validateConstructors(cNode)) {
            return;
        }
        List<PropertyNode> list = AbstractASTTransformUtil.getInstanceProperties(cNode);
        boolean bl = specialHashMapCase = list.size() == 1 && list.get(0).getField().getType().equals(HASHMAP_TYPE);
        if (specialHashMapCase) {
            this.createConstructorMapSpecial(cNode, constructorStyle, list);
        } else {
            this.createConstructorMap(cNode, constructorStyle, list);
            this.createConstructorOrdered(cNode, constructorStyle, list);
        }
    }

    private void createConstructorOrdered(ClassNode cNode, Expression constructorStyle, List<PropertyNode> list) {
        MapExpression argMap = new MapExpression();
        Parameter[] orderedParams = new Parameter[list.size()];
        int index = 0;
        for (PropertyNode pNode : list) {
            Parameter param = new Parameter(pNode.getField().getType(), pNode.getField().getName());
            orderedParams[index++] = param;
            argMap.addMapEntryExpression(new ConstantExpression(pNode.getName()), new VariableExpression(pNode.getName()));
        }
        BlockStatement orderedBody = new BlockStatement();
        orderedBody.addStatement(new ExpressionStatement(new ConstructorCallExpression(ClassNode.THIS, new ArgumentListExpression(new CastExpression(HASHMAP_TYPE, argMap)))));
        orderedBody.addStatement(AbstractASTTransformUtil.assignStatement(constructorStyle, ConstantExpression.FALSE));
        cNode.addConstructor(new ConstructorNode(1, orderedParams, ClassNode.EMPTY_ARRAY, orderedBody));
    }

    private Statement createGetterBodyDefault(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        return new ExpressionStatement(fieldExpr);
    }

    private Expression cloneCollectionExpr(Expression fieldExpr) {
        return new StaticMethodCallExpression(DGM_TYPE, "asImmutable", fieldExpr);
    }

    private Expression cloneArrayOrCloneableExpr(Expression fieldExpr) {
        return new MethodCallExpression(fieldExpr, "clone", MethodCallExpression.NO_ARGUMENTS);
    }

    private void createConstructorMapSpecial(ClassNode cNode, Expression constructorStyle, List<PropertyNode> list) {
        BlockStatement body = new BlockStatement();
        body.addStatement(this.createConstructorStatementMapSpecial(list.get(0).getField()));
        this.createConstructorMapCommon(cNode, constructorStyle, body);
    }

    private void createConstructorMap(ClassNode cNode, Expression constructorStyle, List<PropertyNode> list) {
        BlockStatement body = new BlockStatement();
        for (PropertyNode pNode : list) {
            body.addStatement(this.createConstructorStatement(cNode, pNode));
        }
        ArgumentListExpression checkArgs = new ArgumentListExpression(new VariableExpression("this"), new VariableExpression("args"));
        body.addStatement(new ExpressionStatement(new StaticMethodCallExpression(SELF_TYPE, "checkPropNames", checkArgs)));
        this.createConstructorMapCommon(cNode, constructorStyle, body);
    }

    private void createConstructorMapCommon(ClassNode cNode, Expression constructorStyle, BlockStatement body) {
        List<FieldNode> fList = cNode.getFields();
        for (FieldNode fNode : fList) {
            if (fNode.isPublic() || cNode.getProperty(fNode.getName()) != null || fNode.isFinal() && fNode.isStatic() || fNode.getName().contains("$")) continue;
            if (fNode.isFinal() && fNode.getInitialExpression() != null) {
                body.addStatement(this.checkFinalArgNotOverridden(cNode, fNode));
            }
            body.addStatement(AbstractASTTransformUtil.createConstructorStatementDefault(fNode));
        }
        body.addStatement(AbstractASTTransformUtil.assignStatement(constructorStyle, ConstantExpression.TRUE));
        Parameter[] params = new Parameter[]{new Parameter(HASHMAP_TYPE, "args")};
        cNode.addConstructor(new ConstructorNode(1, params, ClassNode.EMPTY_ARRAY, new IfStatement(AbstractASTTransformUtil.equalsNullExpr(new VariableExpression("args")), new EmptyStatement(), body)));
    }

    private Statement checkFinalArgNotOverridden(ClassNode cNode, FieldNode fNode) {
        String name = fNode.getName();
        Expression value = AbstractASTTransformUtil.findArg(name);
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(value), new EmptyStatement(), new ThrowStatement(new ConstructorCallExpression(READONLYEXCEPTION_TYPE, new ArgumentListExpression(new ConstantExpression(name), new ConstantExpression(cNode.getName())))));
    }

    private Statement createConstructorStatementMapSpecial(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression namedArgs = AbstractASTTransformUtil.findArg(fNode.getName());
        VariableExpression baseArgs = new VariableExpression("args");
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(baseArgs), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(initExpr), new EmptyStatement(), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(initExpr))), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(namedArgs), new IfStatement(AbstractASTTransformUtil.isTrueExpr(new MethodCallExpression((Expression)baseArgs, "containsKey", (Expression)new ConstantExpression(fNode.getName()))), AbstractASTTransformUtil.assignStatement(fieldExpr, namedArgs), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(baseArgs))), new IfStatement(AbstractASTTransformUtil.isOneExpr(new MethodCallExpression((Expression)baseArgs, "size", MethodCallExpression.NO_ARGUMENTS)), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(namedArgs)), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(baseArgs)))));
    }

    private void ensureNotPublic(String cNode, FieldNode fNode) {
        String fName = fNode.getName();
        if (!(!fNode.isPublic() || fName.contains("$") || fNode.isStatic() && fNode.isFinal())) {
            this.addError("Public field '" + fName + "' not allowed for " + MY_TYPE_NAME + " class '" + cNode + "'.", fNode);
        }
    }

    private void addProperty(ClassNode cNode, PropertyNode pNode) {
        FieldNode fn = pNode.getField();
        cNode.getFields().remove(fn);
        cNode.addProperty(pNode.getName(), pNode.getModifiers() | 0x10, pNode.getType(), pNode.getInitialExpression(), pNode.getGetterBlock(), pNode.getSetterBlock());
        FieldNode newfn = cNode.getField(fn.getName());
        cNode.getFields().remove(newfn);
        cNode.addField(fn);
    }

    private boolean validateConstructors(ClassNode cNode) {
        List<ConstructorNode> constructors;
        if (cNode instanceof InnerClassNode && Modifier.isStatic(cNode.getModifiers()) && (constructors = cNode.getDeclaredConstructors()).size() == 1 && constructors.get(0).getCode() == null) {
            constructors.remove(0);
        }
        if (cNode.getDeclaredConstructors().size() != 0) {
            this.addError("Explicit constructors not allowed for " + MY_TYPE_NAME + " class: " + cNode.getNameWithoutPackage(), cNode.getDeclaredConstructors().get(0));
        }
        return true;
    }

    private Statement createConstructorStatement(ClassNode cNode, PropertyNode pNode) {
        FieldNode fNode = pNode.getField();
        ClassNode fieldType = fNode.getType();
        Statement statement = null;
        if (fieldType.isArray() || fieldType.implementsInterface(CLONEABLE_TYPE)) {
            statement = this.createConstructorStatementArrayOrCloneable(fNode);
        } else if (fieldType.isDerivedFrom(DATE_TYPE)) {
            statement = this.createConstructorStatementDate(fNode);
        } else if (AbstractASTTransformUtil.isOrImplements(fieldType, COLLECTION_TYPE) || fieldType.isDerivedFrom(COLLECTION_TYPE) || AbstractASTTransformUtil.isOrImplements(fieldType, MAP_TYPE) || fieldType.isDerivedFrom(MAP_TYPE)) {
            statement = this.createConstructorStatementCollection(fNode);
        } else if (this.isKnownImmutable(fieldType)) {
            statement = AbstractASTTransformUtil.createConstructorStatementDefault(fNode);
        } else if (fieldType.isResolved()) {
            this.addError(ImmutableASTTransformation.createErrorMessage(cNode.getName(), fNode.getName(), fieldType.getName(), "compiling"), fNode);
        } else {
            statement = this.createConstructorStatementGuarded(cNode, fNode);
        }
        return statement;
    }

    private Statement createConstructorStatementGuarded(ClassNode cNode, FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression unknown = AbstractASTTransformUtil.findArg(fNode.getName());
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(unknown), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(initExpr), new EmptyStatement(), AbstractASTTransformUtil.assignStatement(fieldExpr, this.checkUnresolved(cNode, fNode, initExpr))), AbstractASTTransformUtil.assignStatement(fieldExpr, this.checkUnresolved(cNode, fNode, unknown)));
    }

    private Expression checkUnresolved(ClassNode cNode, FieldNode fNode, Expression value) {
        TupleExpression args = new TupleExpression(new ConstantExpression(cNode.getName()), new ConstantExpression(fNode.getName()), value);
        return new StaticMethodCallExpression(SELF_TYPE, "checkImmutable", args);
    }

    private Statement createConstructorStatementCollection(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression collection = AbstractASTTransformUtil.findArg(fNode.getName());
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(collection), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(initExpr), new EmptyStatement(), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(initExpr))), new IfStatement(AbstractASTTransformUtil.isInstanceOf(collection, CLONEABLE_TYPE), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(this.cloneArrayOrCloneableExpr(collection))), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneCollectionExpr(collection))));
    }

    private boolean isKnownImmutable(ClassNode fieldType) {
        if (!fieldType.isResolved()) {
            return false;
        }
        return fieldType.isEnum() || ClassHelper.isPrimitiveType(fieldType) || fieldType.getAnnotations(MY_TYPE).size() != 0 || ImmutableASTTransformation.inImmutableList(fieldType.getName());
    }

    private static boolean inImmutableList(String typeName) {
        return immutableList.contains(typeName);
    }

    private Statement createConstructorStatementArrayOrCloneable(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression array = AbstractASTTransformUtil.findArg(fNode.getName());
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(array), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(initExpr), AbstractASTTransformUtil.assignStatement(fieldExpr, ConstantExpression.NULL), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneArrayOrCloneableExpr(initExpr))), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneArrayOrCloneableExpr(array)));
    }

    private Statement createConstructorStatementDate(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression initExpr = fNode.getInitialValueExpression();
        if (initExpr == null) {
            initExpr = ConstantExpression.NULL;
        }
        Expression date = AbstractASTTransformUtil.findArg(fNode.getName());
        return new IfStatement(AbstractASTTransformUtil.equalsNullExpr(date), new IfStatement(AbstractASTTransformUtil.equalsNullExpr(initExpr), AbstractASTTransformUtil.assignStatement(fieldExpr, ConstantExpression.NULL), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneDateExpr(initExpr))), AbstractASTTransformUtil.assignStatement(fieldExpr, this.cloneDateExpr(date)));
    }

    private Expression cloneDateExpr(Expression origDate) {
        return new ConstructorCallExpression(DATE_TYPE, new MethodCallExpression(origDate, "getTime", MethodCallExpression.NO_ARGUMENTS));
    }

    private void adjustPropertyForImmutability(PropertyNode pNode, List<PropertyNode> newNodes) {
        FieldNode fNode = pNode.getField();
        fNode.setModifiers(pNode.getModifiers() & 0xFFFFFFFE | 0x10 | 2);
        this.adjustPropertyNode(pNode, this.createGetterBody(fNode));
        newNodes.add(pNode);
    }

    private void adjustPropertyNode(PropertyNode pNode, Statement getterBody) {
        pNode.setSetterBlock(null);
        pNode.setGetterBlock(getterBody);
    }

    private Statement createGetterBody(FieldNode fNode) {
        BlockStatement body = new BlockStatement();
        ClassNode fieldType = fNode.getType();
        Statement statement = fieldType.isArray() || fieldType.implementsInterface(CLONEABLE_TYPE) ? this.createGetterBodyArrayOrCloneable(fNode) : (fieldType.isDerivedFrom(DATE_TYPE) ? this.createGetterBodyDate(fNode) : this.createGetterBodyDefault(fNode));
        body.addStatement(statement);
        return body;
    }

    private static String createErrorMessage(String className, String fieldName, String typeName, String mode) {
        return MY_TYPE_NAME + " processor doesn't know how to handle field '" + fieldName + "' of type '" + ImmutableASTTransformation.prettyTypeName(typeName) + "' while " + mode + " class " + className + ".\n" + MY_TYPE_NAME + " classes only support properties with effectively immutable types including:\n" + "- Strings, primitive types, wrapper types, BigInteger and BigDecimal, enums\n" + "- other " + MY_TYPE_NAME + " classes and known immutables (java.awt.Color, java.net.URI)\n" + "- Cloneable classes, collections, maps and arrays, and other classes with special handling (java.util.Date)\n" + "Other restrictions apply, please see the groovydoc for " + MY_TYPE_NAME + " for further details";
    }

    private static String prettyTypeName(String name) {
        return name.equals("java.lang.Object") ? name + " or def" : name;
    }

    private Statement createGetterBodyArrayOrCloneable(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression expression = this.cloneArrayOrCloneableExpr(fieldExpr);
        return AbstractASTTransformUtil.safeExpression(fieldExpr, expression);
    }

    private Statement createGetterBodyDate(FieldNode fNode) {
        VariableExpression fieldExpr = new VariableExpression(fNode);
        Expression expression = this.cloneDateExpr(fieldExpr);
        return AbstractASTTransformUtil.safeExpression(fieldExpr, expression);
    }

    public static Object checkImmutable(String className, String fieldName, Object field) {
        if (field == null || field instanceof Enum || ImmutableASTTransformation.inImmutableList(field.getClass().getName())) {
            return field;
        }
        if (field instanceof Collection) {
            return DefaultGroovyMethods.asImmutable((Collection)field);
        }
        if (field.getClass().getAnnotation(MY_CLASS) != null) {
            return field;
        }
        String typeName = field.getClass().getName();
        throw new RuntimeException(ImmutableASTTransformation.createErrorMessage(className, fieldName, typeName, "constructing"));
    }

    public static void checkPropNames(Object instance, Map<String, Object> args) {
        MetaClass metaClass = InvokerHelper.getMetaClass(instance);
        for (String k : args.keySet()) {
            if (metaClass.hasProperty(instance, k) != null) continue;
            throw new MissingPropertyException(k, instance.getClass());
        }
    }
}

