

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmcgui" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/Dialog.h"
#include "interfaces/legacy/ModuleXbmcgui.h"
#include "interfaces/legacy/Control.h"
#include "interfaces/legacy/Window.h"
#include "interfaces/legacy/WindowDialog.h"
#include "interfaces/legacy/Dialog.h"
#include "interfaces/legacy/WindowXML.h"
#include "guilib/Key.h"

using namespace XBMCAddon;
using namespace xbmcgui;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif



namespace PythonBindings
{

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ListItem
  TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type(typeid(XBMCAddon::xbmcgui::ListItem));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Control
  TypeInfo TyXBMCAddon_xbmcgui_Control_Type(typeid(XBMCAddon::xbmcgui::Control));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlSpin
  TypeInfo TyXBMCAddon_xbmcgui_ControlSpin_Type(typeid(XBMCAddon::xbmcgui::ControlSpin));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlLabel
  TypeInfo TyXBMCAddon_xbmcgui_ControlLabel_Type(typeid(XBMCAddon::xbmcgui::ControlLabel));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlEdit
  TypeInfo TyXBMCAddon_xbmcgui_ControlEdit_Type(typeid(XBMCAddon::xbmcgui::ControlEdit));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlList
  TypeInfo TyXBMCAddon_xbmcgui_ControlList_Type(typeid(XBMCAddon::xbmcgui::ControlList));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlFadeLabel
  TypeInfo TyXBMCAddon_xbmcgui_ControlFadeLabel_Type(typeid(XBMCAddon::xbmcgui::ControlFadeLabel));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlTextBox
  TypeInfo TyXBMCAddon_xbmcgui_ControlTextBox_Type(typeid(XBMCAddon::xbmcgui::ControlTextBox));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlImage
  TypeInfo TyXBMCAddon_xbmcgui_ControlImage_Type(typeid(XBMCAddon::xbmcgui::ControlImage));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlProgress
  TypeInfo TyXBMCAddon_xbmcgui_ControlProgress_Type(typeid(XBMCAddon::xbmcgui::ControlProgress));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlButton
  TypeInfo TyXBMCAddon_xbmcgui_ControlButton_Type(typeid(XBMCAddon::xbmcgui::ControlButton));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlCheckMark
  TypeInfo TyXBMCAddon_xbmcgui_ControlCheckMark_Type(typeid(XBMCAddon::xbmcgui::ControlCheckMark));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlGroup
  TypeInfo TyXBMCAddon_xbmcgui_ControlGroup_Type(typeid(XBMCAddon::xbmcgui::ControlGroup));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlRadioButton
  TypeInfo TyXBMCAddon_xbmcgui_ControlRadioButton_Type(typeid(XBMCAddon::xbmcgui::ControlRadioButton));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::ControlSlider
  TypeInfo TyXBMCAddon_xbmcgui_ControlSlider_Type(typeid(XBMCAddon::xbmcgui::ControlSlider));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Dialog
  TypeInfo TyXBMCAddon_xbmcgui_Dialog_Type(typeid(XBMCAddon::xbmcgui::Dialog));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::DialogProgress
  TypeInfo TyXBMCAddon_xbmcgui_DialogProgress_Type(typeid(XBMCAddon::xbmcgui::DialogProgress));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::DialogProgressBG
  TypeInfo TyXBMCAddon_xbmcgui_DialogProgressBG_Type(typeid(XBMCAddon::xbmcgui::DialogProgressBG));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Action
  TypeInfo TyXBMCAddon_xbmcgui_Action_Type(typeid(XBMCAddon::xbmcgui::Action));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::Window
  TypeInfo TyXBMCAddon_xbmcgui_Window_Type(typeid(XBMCAddon::xbmcgui::Window));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowDialog
  TypeInfo TyXBMCAddon_xbmcgui_WindowDialog_Type(typeid(XBMCAddon::xbmcgui::WindowDialog));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowXML
  TypeInfo TyXBMCAddon_xbmcgui_WindowXML_Type(typeid(XBMCAddon::xbmcgui::WindowXML));
  //=========================================================================

  //=========================================================================
  // These variables will hold the Python Type information for XBMCAddon::xbmcgui::WindowXMLDialog
  TypeInfo TyXBMCAddon_xbmcgui_WindowXMLDialog_Type(typeid(XBMCAddon::xbmcgui::WindowXMLDialog));
  //=========================================================================



  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::Window. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_Window_Director : public Director, public XBMCAddon::xbmcgui::Window
  {
    public:

      inline XBMCAddon_xbmcgui_Window_Director(int  existingWindowId ) : XBMCAddon::xbmcgui::Window( existingWindowId ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowDialog. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowDialog_Director : public Director, public XBMCAddon::xbmcgui::WindowDialog
  {
    public:

      inline XBMCAddon_xbmcgui_WindowDialog_Director() : XBMCAddon::xbmcgui::WindowDialog() { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowXML. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowXML_Director : public Director, public XBMCAddon::xbmcgui::WindowXML
  {
    public:

      inline XBMCAddon_xbmcgui_WindowXML_Director(XBMCAddon::String const & xmlFilename, XBMCAddon::String const & scriptPath, XBMCAddon::String const & defaultSkin, XBMCAddon::String const & defaultRes ) : XBMCAddon::xbmcgui::WindowXML( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  //=========================================================================
  // This class is the Director for XBMCAddon::xbmcgui::WindowXMLDialog. 
  // It provides the "reverse bridge" from C++ to Python to support 
  // cross-language polymorphism.
  //=========================================================================
  class XBMCAddon_xbmcgui_WindowXMLDialog_Director : public Director, public XBMCAddon::xbmcgui::WindowXMLDialog
  {
    public:

      inline XBMCAddon_xbmcgui_WindowXMLDialog_Director(XBMCAddon::String const & xmlFilename, XBMCAddon::String const & scriptPath, XBMCAddon::String const & defaultSkin, XBMCAddon::String const & defaultRes ) : XBMCAddon::xbmcgui::WindowXMLDialog( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) { } 

      virtual void  onAction(  XBMCAddon::xbmcgui::Action * action  )
      { 
        PyObject* pyaction = NULL;
        pyaction = makePythonInstance(action,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onAction",(char*)"(O)", pyaction );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onControl(  XBMCAddon::xbmcgui::Control * control  )
      { 
        PyObject* pycontrol = NULL;
        pycontrol = makePythonInstance(control,true);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onControl",(char*)"(O)", pycontrol );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onDoubleClick(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onDoubleClick",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onFocus(  int  controlId  )
      { 
        PyObject* pycontrolId = NULL;
        pycontrolId = Py_BuildValue((char*)"i", controlId);
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onFocus",(char*)"(O)", pycontrolId );
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

      virtual void  onInit(  )
      { 
        XBMCAddon::Python::PyContext pyContext;
        PyObject_CallMethod(self,(char*)"onInit",(char*)"()");
        if (PyErr_Occurred())
          throw PythonBindings::PythonToCppException();
      }

  };

  PyDoc_STRVAR(lock__doc__,
               "lock()--Lock the gui until xbmcgui.unlock() is called.\n"
"\n"
"*Note, This will improve performance when doing a lot of gui manipulation at once.\n"
"The main program (xbmc itself) will freeze until xbmcgui.unlock() is called.\n"
"example:\n"
"    - xbmcgui.lock()\n");

  static PyObject* xbmcgui_lock (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcgui::lock(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::lock\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::lock\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(unlock__doc__,
               "unlock()--Unlock the gui from a lock() call.\n"
"\n"
"example:\n"
"    - xbmcgui.unlock()\n");

  static PyObject* xbmcgui_unlock (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcgui::unlock(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::unlock\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::unlock\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getCurrentWindowId__doc__,
               "getCurrentWindowId()--Returns the id for the current 'active' window as an integer.\n"
"\n"
"example:\n"
"    - wid = xbmcgui.getCurrentWindowId()\n");

  static PyObject* xbmcgui_getCurrentWindowId (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmcgui::getCurrentWindowId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(getCurrentWindowDialogId__doc__,
               "getCurrentWindowDialogId()--Returns the id for the current 'active' dialog as an integer.\n"
"\n"
"example:\n"
"    - wid = xbmcgui.getCurrentWindowDialogId()\n");

  static PyObject* xbmcgui_getCurrentWindowDialogId (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (long )XBMCAddon::xbmcgui::getCurrentWindowDialogId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowDialogId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::getCurrentWindowDialogId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "label2",
          "iconImage",
          "thumbnailImage",
          "path",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;         
    std::string  iconImage  = XBMCAddon::emptyString;
    PyObject* pyiconImage = NULL;         
    std::string  thumbnailImage  = XBMCAddon::emptyString;
    PyObject* pythumbnailImage = NULL;         
    std::string  path  = XBMCAddon::emptyString;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OOOOO",
       (char**)keywords,
         &pylabel,
         &pylabel2,
         &pyiconImage,
         &pythumbnailImage,
         &pypath
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ListItem"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","ListItem"); 
      if (pyiconImage) PyXBMCGetUnicodeString(iconImage,pyiconImage,false,"iconImage","ListItem"); 
      if (pythumbnailImage) PyXBMCGetUnicodeString(thumbnailImage,pythumbnailImage,false,"thumbnailImage","ListItem"); 
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","ListItem"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ListItem *)new XBMCAddon::xbmcgui::ListItem(  label,  label2,  iconImage,  thumbnailImage,  path  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getLabel__doc__,
               "getLabel() --Returns the listitem label.\n"
"\n"
"example:\n"
"    - label = self.list.getSelectedItem().getLabel() \n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getLabel","XBMCAddon::xbmcgui::ListItem"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getLabel2__doc__,
               "getLabel2() --Returns the listitem label.\n"
"\n"
"example:\n"
"    - label = self.list.getSelectedItem().getLabel2() \n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getLabel2","XBMCAddon::xbmcgui::ListItem"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setLabel__doc__,
               "setLabel(label)--Sets the listitem's label.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setLabel('Casino Royale')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    std::string  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setLabel","XBMCAddon::xbmcgui::ListItem"))-> setLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setLabel2__doc__,
               "setLabel2(label)--Sets the listitem's label2.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setLabel2('Casino Royale')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    std::string  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel2"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setLabel2","XBMCAddon::xbmcgui::ListItem"))-> setLabel2(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setIconImage__doc__,
               "setIconImage(icon)--Sets the listitem's icon image.\n"
"\n"
"icon : string - image filename.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setIconImage('emailread.png')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setIconImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iconImage",
          NULL};
         
    std::string  iconImage ;
    PyObject* pyiconImage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyiconImage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyiconImage) PyXBMCGetUnicodeString(iconImage,pyiconImage,false,"iconImage","setIconImage"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setIconImage","XBMCAddon::xbmcgui::ListItem"))-> setIconImage(  iconImage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setIconImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setIconImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setThumbnailImage__doc__,
               "setThumbnailImage(thumbFilename)--Sets the listitem's thumbnail image.\n"
"\n"
"thumb : string - image filename.\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().setThumbnailImage('emailread.png')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setThumbnailImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "thumbFilename",
          NULL};
         
    std::string  thumbFilename ;
    PyObject* pythumbFilename = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pythumbFilename
       ))
    {
      return NULL;
    }


    try
    {
      if (pythumbFilename) PyXBMCGetUnicodeString(thumbFilename,pythumbFilename,false,"thumbFilename","setThumbnailImage"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setThumbnailImage","XBMCAddon::xbmcgui::ListItem"))-> setThumbnailImage(  thumbFilename  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setThumbnailImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setThumbnailImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setArt__doc__,
               "setArt(values)--Sets the listitem's art\n"
"values : dictionary - pairs of { label: value }.\n"
"\n"
"    - Some default art values (any string possible):\n"
"        - thumb : string - image filename\n"
"        - poster : string - image filename\n"
"        - banner : string - image filename\n"
"        - fanart : string - image filename\n"
"        - clearart : string - image filename\n"
"        - clearlogo : string - image filename\n"
"        - landscape : string - image filename\n"
"\n"
"\n"
"\n"
"example:\n"
"        - self.list.getSelectedItem().setArt({ 'poster': 'poster.png', 'banner' : 'banner.png' })\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setArt (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "dictionary",
          NULL};
         
    XBMCAddon::Dictionary< XBMCAddon::StringOrInt  >  dictionary ;
    PyObject* pydictionary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pydictionary
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pydictionary, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"dictionary","setArt");
        std::string  value;
        if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,PyInt_Check(pyvalue) || PyLong_Check(pyvalue) || PyFloat_Check(pyvalue),"value","setArt");
        dictionary[key] = value;
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setArt","XBMCAddon::xbmcgui::ListItem"))-> setArt(  dictionary  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setArt\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setArt\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_select__doc__,
               "select(selected)--Sets the listitem's selected status.\n"
"\n"
"selected : bool - True=selected/False=not selected\n"
"\n"
"example:\n"
"    - self.list.getSelectedItem().select(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_select (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"select","XBMCAddon::xbmcgui::ListItem"))-> select(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"select\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"select\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_isSelected__doc__,
               "isSelected() --Returns the listitem's selected status.\n"
"\n"
"example:\n"
"    - is = self.list.getSelectedItem().isSelected() \n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"isSelected","XBMCAddon::xbmcgui::ListItem"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setInfo__doc__,
               "setInfo(type, infoLabels)--Sets the listitem's infoLabels.\n"
"\n"
"type : string - type of media(video/music/pictures).\n"
"infoLabels : dictionary - pairs of { label: value }.\n"
"\n"
"*Note, To set pictures exif info, prepend 'exif:' to the label. Exif values must be passed\n"
"as strings, separate value pairs with a comma. (eg. {'exif:resolution': '720,480'}\n"
"See CPictureInfoTag::TranslateString in PictureInfoTag.cpp for valid strings.\n"
"\n"
"You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"\n"
"    - General Values that apply to all types:\n"
"        - count : integer (12) - can be used to store an id for later, or for sorting purposes\n"
"        - size : long (1024) - size in bytes\n"
"        - date : string (d.m.Y / 01.01.2009) - file date\n"
"\n"
"    - Video Values:\n"
"        - genre : string (Comedy)\n"
"        - year : integer (2009)\n"
"        - episode : integer (4)\n"
"        - season : integer (1)\n"
"        - top250 : integer (192)\n"
"        - tracknumber : integer (3)\n"
"        - rating : float (6.4) - range is 0..10\n"
"        - watched : depreciated - use playcount instead\n"
"        - playcount : integer (2) - number of times this item has been played\n"
"        - overlay : integer (2) - range is 0..8. See GUIListItem.h for values\n"
"        - cast : list (Michal C. Hall)\n"
"        - castandrole : list (Michael C. Hall|Dexter)\n"
"        - director : string (Dagur Kari)\n"
"        - mpaa : string (PG-13)\n"
"        - plot : string (Long Description)\n"
"        - plotoutline : string (Short Description)\n"
"        - title : string (Big Fan)\n"
"        - originaltitle : string (Big Fan)\n"
"        - sorttitle : string (Big Fan)\n"
"        - duration : string (3:18)\n"
"        - studio : string (Warner Bros.)\n"
"        - tagline : string (An awesome movie) - short description of movie\n"
"        - writer : string (Robert D. Siegel)\n"
"        - tvshowtitle : string (Heroes)\n"
"        - premiered : string (2005-03-04)\n"
"        - status : string (Continuing) - status of a TVshow\n"
"        - code : string (tt0110293) - IMDb code\n"
"        - aired : string (2008-12-07)\n"
"        - credits : string (Andy Kaufman) - writing credits\n"
"        - lastplayed : string (Y-m-d h:m:s = 2009-04-05 23:16:04)\n"
"        - album : string (The Joshua Tree)\n"
"        - artist : list (['U2'])\n"
"        - votes : string (12345 votes)\n"
"        - trailer : string (/home/user/trailer.avi)\n"
"        - dateadded : string (Y-m-d h:m:s = 2009-04-05 23:16:04)\n"
"\n"
"    - Music Values:\n"
"        - tracknumber : integer (8)\n"
"        - duration : integer (245) - duration in seconds\n"
"        - year : integer (1998)\n"
"        - genre : string (Rock)\n"
"        - album : string (Pulse)\n"
"        - artist : string (Muse)\n"
"        - title : string (American Pie)\n"
"        - rating : string (3) - single character between 0 and 5\n"
"        - lyrics : string (On a dark desert highway...)\n"
"        - playcount : integer (2) - number of times this item has been played\n"
"        - lastplayed : string (Y-m-d h:m:s = 2009-04-05 23:16:04)\n"
"\n"
"    - Picture Values:\n"
"        - title : string (In the last summer-1)\n"
"        - picturepath : string (/home/username/pictures/img001.jpg)\n"
"        - exif* : string (See CPictureInfoTag::TranslateString in PictureInfoTag.cpp for valid strings)\n"
"\n"
"\n"
"\n"
"example:\n"
"\n"
"        - self.list.getSelectedItem().setInfo('video', { 'Genre': 'Comedy' })n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setInfo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "infoLabels",
          NULL};
         
    char * type ;         
    XBMCAddon::Dictionary< XBMCAddon::xbmcgui::InfoLabelValue  >  infoLabels ;
    PyObject* pyinfoLabels = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &type,
         &pyinfoLabels
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pyinfoLabels, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"infoLabels","setInfo");
        Alternative< XBMCAddon::StringOrInt ,std::vector< XBMCAddon::xbmcgui::InfoLabelStringOrTuple  >  >  value;
        

    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyvalue;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,PyInt_Check(pyentry_1) || PyLong_Check(pyentry_1) || PyFloat_Check(pyentry_1),"entry0_1","setInfo");
        value.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          std::vector< XBMCAddon::xbmcgui::InfoLabelStringOrTuple  >  entry1_1;
          

    {
      bool isTuple = PyObject_TypeCheck(pyentry_1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry_1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1_1\" must be either a Tuple or a List.");

      
      PyObject *pyentry2 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyentry_1) : PyList_Size(pyentry_1));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry2 = (isTuple ? PyTuple_GetItem(pyentry_1, i) : PyList_GetItem(pyentry_1, i));
        Alternative< XBMCAddon::StringOrInt ,Tuple< XBMCAddon::String ,XBMCAddon::StringOrInt  >  >  entry2;
        

    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_3 = pyentry2;
      try
      {
        std::string  entry0_3;
        if (pyentry_3) PyXBMCGetUnicodeString(entry0_3,pyentry_3,PyInt_Check(pyentry_3) || PyLong_Check(pyentry_3) || PyFloat_Check(pyentry_3),"entry0_3","setInfo");
        entry2.former() = entry0_3;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          Tuple< XBMCAddon::String ,XBMCAddon::StringOrInt  >  entry1_3;
          

    {
      bool isTuple = PyObject_TypeCheck(pyentry_3,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry_3,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1_3\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry_3) : PyList_Size(pyentry_3));

      if (vecSize > 0)
      {
        PyObject *pyentry0_4 = NULL;
        pyentry0_4 = (isTuple ? PyTuple_GetItem(pyentry_3, 0) : PyList_GetItem(pyentry_3, 0));
        std::string  entry0_4;
        if (pyentry0_4) PyXBMCGetUnicodeString(entry0_4,pyentry0_4,false,"entry0_4","setInfo");
        entry1_3.first() = entry0_4;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_4 = NULL;
        pyentry1_4 = (isTuple ? PyTuple_GetItem(pyentry_3, 1) : PyList_GetItem(pyentry_3, 1));
        std::string  entry1_4;
        if (pyentry1_4) PyXBMCGetUnicodeString(entry1_4,pyentry1_4,PyInt_Check(pyentry1_4) || PyLong_Check(pyentry1_4) || PyFloat_Check(pyentry1_4),"entry1_4","setInfo");
        entry1_3.second() = entry1_4;
      }

    }

          entry2.later() = entry1_3;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "Tuple<(XBMCAddon::String,XBMCAddon::StringOrInt)>" );
        }
      }
    }

      

        entry1_1.push_back(entry2);
      }
    }

          value.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "std::vector<(XBMCAddon::xbmcgui::InfoLabelStringOrTuple)>" );
        }
      }
    }

      

        infoLabels[key] = value;
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setInfo","XBMCAddon::xbmcgui::ListItem"))-> setInfo(  type,  infoLabels  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setInfo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setInfo\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_addStreamInfo__doc__,
               "addStreamInfo(type, values)--Add a stream with details.\n"
"\n"
"type : string - type of stream(video/audio/subtitle).\n"
"values : dictionary - pairs of { label: value }.\n"
"\n"
"    - Video Values:\n"
"        - codec : string (h264)\n"
"        - aspect : float (1.78)\n"
"        - width : integer (1280)\n"
"        - height : integer (720)\n"
"        - duration : integer (seconds)\n"
"\n"
"    - Audio Values:\n"
"        - codec : string (dts)\n"
"        - language : string (en)\n"
"        - channels : integer (2)\n"
"\n"
"    - Subtitle Values:\n"
"        - language : string (en)\n"
"\n"
"\n"
"\n"
"example:\n"
"        - self.list.getSelectedItem().addStreamInfo('video', { 'Codec': 'h264', 'Width' : 1280 })\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_addStreamInfo (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "cType",
          "dictionary",
          NULL};
         
    char * cType ;         
    XBMCAddon::Dictionary< XBMCAddon::StringOrInt  >  dictionary ;
    PyObject* pydictionary = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &cType,
         &pydictionary
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      PyObject *pykey, *pyvalue;
      Py_ssize_t pos = 0;
      while(PyDict_Next(pydictionary, &pos, &pykey, &pyvalue))
      {
        std::string key;
        PyXBMCGetUnicodeString(key,pykey,false,"dictionary","addStreamInfo");
        std::string  value;
        if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,PyInt_Check(pyvalue) || PyLong_Check(pyvalue) || PyFloat_Check(pyvalue),"value","addStreamInfo");
        dictionary[key] = value;
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"addStreamInfo","XBMCAddon::xbmcgui::ListItem"))-> addStreamInfo(  cType,  dictionary  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addStreamInfo\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addStreamInfo\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_addContextMenuItems__doc__,
               "addContextMenuItems([(label, action,)*], replaceItems)--Adds item(s) to the context menu for media lists.\n"
"\n"
"items : list - [(label, action,)*] A list of tuples consisting of label and action pairs.\n"
"    - label : string or unicode - item's label.\n"
"    - action : string or unicode - any built-in function to perform. replaceItems : [opt] bool - True=only your items will show/False=your items will be added to context menu(Default).\n"
"List of functions -http://wiki.xbmc.org/?title=List_of_Built_In_Functions \n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - listitem.addContextMenuItems([('Theater Showtimes', 'XBMC.RunScript(special://home/scripts/showtimes/default.py,Iron Man)',)])n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_addContextMenuItems (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          "replaceItems",
          NULL};
         
    std::vector< Tuple< XBMCAddon::String ,XBMCAddon::String  >  >  items ;
    PyObject* pyitems = NULL;         
    bool  replaceItems  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyitems,
         &replaceItems
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Tuple< XBMCAddon::String ,XBMCAddon::String  >  entry1;
        

    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        std::string  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","addContextMenuItems");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        std::string  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","addContextMenuItems");
        entry1.second() = entry1_2;
      }

    }

        items.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"addContextMenuItems","XBMCAddon::xbmcgui::ListItem"))-> addContextMenuItems(  items,  replaceItems  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addContextMenuItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addContextMenuItems\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setProperty__doc__,
               "setProperty(key, value)--Sets a listitem property, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"value : string or unicode - value of property.\n"
"\n"
"*Note, Key is NOT case sensitive.\n"
"You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"Some of these are treated internally by XBMC, such as the 'StartOffset' property, which is\n"
"the offset in seconds at which to start playback of an item. Others may be used in the skin\n"
"to add extra information, such as 'WatchedCount' for tvshow items\n"
"example:\n"
"    - self.list.getSelectedItem().setProperty('AspectRatio', '1.85 : 1')\n"
"    - self.list.getSelectedItem().setProperty('StartOffset', '256.4')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          "value",
          NULL};
         
    char * key ;         
    std::string  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","setProperty"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setProperty","XBMCAddon::xbmcgui::ListItem"))-> setProperty(  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getProperty__doc__,
               "getProperty(key)--Returns a listitem property as a string, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"\n"
"*Note, Key is NOT case sensitive.\n"
"You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"example:\n"
"    - AspectRatio = self.list.getSelectedItem().getProperty('AspectRatio')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getProperty","XBMCAddon::xbmcgui::ListItem"))-> getProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setPath__doc__,
               "addContextMenuItems([(label, action,)*], replaceItems)--Adds item(s) to the context menu for media lists.\n"
"\n"
"items : list - [(label, action,)*] A list of tuples consisting of label and action pairs.\n"
"    - label : string or unicode - item's label.\n"
"    - action : string or unicode - any built-in function to perform. replaceItems : [opt] bool - True=only your items will show/False=your items will be added to context menu(Default).\n"
"List of functions -http://wiki.xbmc.org/?title=List_of_Built_In_Functions \n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - listitem.addContextMenuItems([('Theater Showtimes', 'XBMC.RunScript(special://home/scripts/showtimes/default.py,Iron Man)',)]) setPath(path)--Sets the listitem's path.\n"
"\n"
"path : string or unicode - path, activated when item is clicked.\n"
"\n"
"*Note, You can use the above as keywords for arguments.\n"
"example:\n"
"    - self.list.getSelectedItem().setPath(path='ActivateWindow(Weather)')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setPath (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "path",
          NULL};
         
    std::string  path ;
    PyObject* pypath = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypath
       ))
    {
      return NULL;
    }


    try
    {
      if (pypath) PyXBMCGetUnicodeString(path,pypath,false,"path","setPath"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setPath","XBMCAddon::xbmcgui::ListItem"))-> setPath(  path  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPath\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPath\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_setMimeType__doc__,
               "setMimeType(mimetype)--Sets the listitem's mimetype if known.\n"
"\n"
"mimetype : string or unicode - mimetype.\n"
"\n"
"*If known prehand, this can avoid xbmc doing HEAD requests to http servers to figure out file type.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_setMimeType (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "mimetype",
          NULL};
         
    std::string  mimetype ;
    PyObject* pymimetype = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pymimetype
       ))
    {
      return NULL;
    }


    try
    {
      if (pymimetype) PyXBMCGetUnicodeString(mimetype,pymimetype,false,"mimetype","setMimeType"); 

      ((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"setMimeType","XBMCAddon::xbmcgui::ListItem"))-> setMimeType(  mimetype  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setMimeType\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setMimeType\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getdescription__doc__,
               "getdescription() --Returns the description of this PlayListItem.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getdescription (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getdescription","XBMCAddon::xbmcgui::ListItem"))-> getdescription(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getdescription\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getdescription\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getduration__doc__,
               "getduration() --Returns the duration of this PlayListItem\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getduration (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getduration","XBMCAddon::xbmcgui::ListItem"))-> getduration(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getduration\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getduration\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ListItem_getfilename__doc__,
               "getfilename() --Returns the filename of this PlayListItem.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ListItem_getfilename (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"getfilename","XBMCAddon::xbmcgui::ListItem"))-> getfilename(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getfilename\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getfilename\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 


  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_canAcceptMessages (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "actionId",
          NULL};
         
    int  actionId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &actionId
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"canAcceptMessages","XBMCAddon::xbmcgui::Control"))-> canAcceptMessages(  actionId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"canAcceptMessages\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"canAcceptMessages\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getId__doc__,
               "getId() --Returns the control's current id as an integer.\n"
"\n"
"example:\n"
"    - id = self.button.getId()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getId","XBMCAddon::xbmcgui::Control"))-> getId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 




  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getPosition__doc__,
               "getPosition() --Returns the control's current position as a x,y integer tuple.\n"
"\n"
"example:\n"
"    - pos = self.button.getPosition()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::vector< int  >  apiResult;
    try
    {

      apiResult = (std::vector< int  > )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getPosition","XBMCAddon::xbmcgui::Control"))-> getPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    result = PyList_New(0);

      for (std::vector<int >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        int & entry1 = *iter;
        PyObject* pyentry1;
        pyentry1 = Py_BuildValue((char*)"i", entry1);
        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getX (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getX","XBMCAddon::xbmcgui::Control"))-> getX(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getX\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getX\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getY (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getY","XBMCAddon::xbmcgui::Control"))-> getY(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getY\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getY\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getHeight__doc__,
               "getHeight() --Returns the control's current height as an integer.\n"
"\n"
"example:\n"
"    - height = self.button.getHeight()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getHeight","XBMCAddon::xbmcgui::Control"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_getWidth__doc__,
               "getWidth() --Returns the control's current width as an integer.\n"
"\n"
"example:\n"
"    - width = self.button.getWidth()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"getWidth","XBMCAddon::xbmcgui::Control"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setEnabled__doc__,
               "setEnabled(enabled)--Set's the control's enabled/disabled state.\n"
"\n"
"enabled : bool - True=enabled / False=disabled.\n"
"\n"
"example:\n"
"    - self.button.setEnabled(False)n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setEnabled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "enabled",
          NULL};
         
    bool  enabled ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &enabled
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setEnabled","XBMCAddon::xbmcgui::Control"))-> setEnabled(  enabled  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setEnabled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setEnabled\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setVisible__doc__,
               "setVisible(visible)--Set's the control's visible/hidden state.\n"
"\n"
"visible : bool - True=visible / False=hidden.\n"
"\n"
"example:\n"
"    - self.button.setVisible(False)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setVisible","XBMCAddon::xbmcgui::Control"))-> setVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setVisible\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setVisibleCondition__doc__,
               "setVisibleCondition(visible[,allowHiddenFocus])--Set's the control's visible condition. Allows XBMC to control the visible status of the control.\n"
"\n"
"visible : string - Visible condition.\n"
"allowHiddenFocus : bool - True=gains focus even if hidden.\n"
"\n"
"List of Conditions -http://wiki.xbmc.org/index.php?title=List_of_Boolean_Conditions \n"
"\n"
"example:\n"
"    - self.button.setVisibleCondition('[Control.IsVisible(41) + !Control.IsVisible(12)]', True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setVisibleCondition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "visible",
          "allowHiddenFocus",
          NULL};
         
    char * visible ;         
    bool  allowHiddenFocus  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &visible,
         &allowHiddenFocus
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setVisibleCondition","XBMCAddon::xbmcgui::Control"))-> setVisibleCondition(  visible,  allowHiddenFocus  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setVisibleCondition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setVisibleCondition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setEnableCondition__doc__,
               "setEnableCondition(enable)--Set's the control's enabled condition. Allows XBMC to control the enabled status of the control.\n"
"\n"
"enable : string - Enable condition.\n"
"\n"
"List of Conditions -http://wiki.xbmc.org/index.php?title=List_of_Boolean_Conditions \n"
"\n"
"example:\n"
"    - self.button.setEnableCondition('System.InternetState')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setEnableCondition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "enable",
          NULL};
         
    char * enable ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &enable
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setEnableCondition","XBMCAddon::xbmcgui::Control"))-> setEnableCondition(  enable  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setEnableCondition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setEnableCondition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setAnimations__doc__,
               "setAnimations([(event, attr,)*])--Set's the control's animations.\n"
"\n"
"[(event,attr,)*] : list - A list of tuples consisting of event and attributes pairs.\n"
"    - event : string - The event to animate.\n"
"    - attr : string - The whole attribute string separated by spaces.\n"
"\n"
"\n"
"Animating your skin -http://wiki.xbmc.org/?title=Animating_Your_Skin \n"
"\n"
"example:\n"
"    - self.button.setAnimations([('focus', 'effect=zoom end=90,247,220,56 time=0',)])\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setAnimations (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "eventAttr",
          NULL};
         
    std::vector< Tuple< XBMCAddon::String ,XBMCAddon::String  >  >  eventAttr ;
    PyObject* pyeventAttr = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyeventAttr
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyeventAttr,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyeventAttr,&PyList_Type))
        throw WrongTypeException("The parameter \"eventAttr\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyeventAttr) : PyList_Size(pyeventAttr));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyeventAttr, i) : PyList_GetItem(pyeventAttr, i));
        Tuple< XBMCAddon::String ,XBMCAddon::String  >  entry1;
        

    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        std::string  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","setAnimations");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        std::string  entry1_2;
        if (pyentry1_2) PyXBMCGetUnicodeString(entry1_2,pyentry1_2,false,"entry1_2","setAnimations");
        entry1.second() = entry1_2;
      }

    }

        eventAttr.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setAnimations","XBMCAddon::xbmcgui::Control"))-> setAnimations(  eventAttr  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setAnimations\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setAnimations\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setPosition__doc__,
               "setPosition(x, y)--Set's the controls position.\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"\n"
"*Note, You may use negative integers. (e.g sliding a control into view)\n"
"\n"
"example:\n"
"    - self.button.setPosition(100, 250)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          NULL};
         
    long  x ;         
    long  y ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &x,
         &y
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setPosition","XBMCAddon::xbmcgui::Control"))-> setPosition(  x,  y  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setWidth__doc__,
               "setWidth(width)--Set's the controls width.\n"
"\n"
"width : integer - width of control.\n"
"\n"
"example:\n"
"    - self.image.setWidth(100)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "width",
          NULL};
         
    long  width ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &width
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setWidth","XBMCAddon::xbmcgui::Control"))-> setWidth(  width  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setHeight__doc__,
               "setHeight(height)--Set's the controls height.\n"
"\n"
"height : integer - height of control.\n"
"\n"
"example:\n"
"    - self.image.setHeight(100)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setHeight","XBMCAddon::xbmcgui::Control"))-> setHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_setNavigation__doc__,
               "setNavigation(up, down, left, right)--Set's the controls navigation.\n"
"\n"
"up : control object - control to navigate to on up.\n"
"down : control object - control to navigate to on down.\n"
"left : control object - control to navigate to on left.\n"
"right : control object - control to navigate to on right.\n"
"\n"
"*Note, Same ascontrolUp() ,controlDown() ,controlLeft() ,controlRight() . Set to self to disable navigation for that direction.\n"
"\n"
"Throws:\n"
"    - TypeError, if one of the supplied arguments is not a control type.\n"
"    - ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"\n"
"example:\n"
"    - self.button.setNavigation(self.button1, self.button2, self.button3, self.button4)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_setNavigation (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "left",
          "right",
          NULL};
         
    XBMCAddon::xbmcgui::Control * up ;
    PyObject* pyup = NULL;         
    XBMCAddon::xbmcgui::Control * down ;
    PyObject* pydown = NULL;         
    XBMCAddon::xbmcgui::Control * left ;
    PyObject* pyleft = NULL;         
    XBMCAddon::xbmcgui::Control * right ;
    PyObject* pyright = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OOOO",
       (char**)keywords,
         &pyup,
         &pydown,
         &pyleft,
         &pyright
       ))
    {
      return NULL;
    }


    try
    {
      up = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyup,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      down = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pydown,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      left = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyleft,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 
      right = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyright,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setNavigation"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"setNavigation","XBMCAddon::xbmcgui::Control"))-> setNavigation(  up,  down,  left,  right  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setNavigation\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setNavigation\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlUp__doc__,
               "controlUp(control)--Set's the controls up navigation.\n"
"\n"
"control : control object - control to navigate to on up.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws:\n"
"    - TypeError, if one of the supplied arguments is not a control type.\n"
"    - ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"\n"
"example:\n"
"    - self.button.controlUp(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlUp (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "up",
          NULL};
         
    XBMCAddon::xbmcgui::Control * up ;
    PyObject* pyup = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyup
       ))
    {
      return NULL;
    }


    try
    {
      up = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyup,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlUp"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlUp","XBMCAddon::xbmcgui::Control"))-> controlUp(  up  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlUp\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlUp\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlDown__doc__,
               "controlDown(control)--Set's the controls down navigation.\n"
"\n"
"control : control object - control to navigate to on down.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws:\n"
"    - TypeError, if one of the supplied arguments is not a control type.\n"
"    - ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"\n"
"example:\n"
"    - self.button.controlDown(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlDown (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlDown"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlDown","XBMCAddon::xbmcgui::Control"))-> controlDown(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlDown\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlDown\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlLeft__doc__,
               "controlLeft(control)--Set's the controls left navigation.\n"
"\n"
"control : control object - control to navigate to on left.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws:\n"
"    - TypeError, if one of the supplied arguments is not a control type.\n"
"    - ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"\n"
"example:\n"
"    - self.button.controlLeft(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlLeft (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlLeft"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlLeft","XBMCAddon::xbmcgui::Control"))-> controlLeft(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlLeft\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlLeft\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Control_controlRight__doc__,
               "controlRight(control)--Set's the controls right navigation.\n"
"\n"
"control : control object - control to navigate to on right.\n"
"\n"
"*Note, You can also usesetNavigation() . Set to self to disable navigation.\n"
"\n"
"Throws:\n"
"    - TypeError, if one of the supplied arguments is not a control type.\n"
"    - ReferenceError, if one of the controls is not added to a window.\n"
"\n"
"\n"
"example:\n"
"    - self.button.controlRight(self.button1)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Control_controlRight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","controlRight"); 

      ((XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"controlRight","XBMCAddon::xbmcgui::Control"))-> controlRight(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"controlRight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"controlRight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSpin_setTextures__doc__,
               "setTextures(up, down, upFocus, downFocus)--Set's textures for this control.\n"
"\n"
"texture are image files that are used for example in the skin\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSpin_setTextures (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "up",
          "down",
          "upFocus",
          "downFocus",
          NULL};
         
    char * up ;         
    char * down ;         
    char * upFocus ;         
    char * downFocus ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ssss",
       (char**)keywords,
         &up,
         &down,
         &upFocus,
         &downFocus
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlSpin*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSpin_Type,"setTextures","XBMCAddon::xbmcgui::ControlSpin"))-> setTextures(  up,  down,  upFocus,  downFocus  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setTextures\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setTextures\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 


  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "font",
          "textColor",
          "disabledColor",
          "alignment",
          "hasPath",
          "angle",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  alignment  = XBFONT_LEFT;         
    bool  hasPath  = false;         
    long  angle  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|ssslbl",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &alignment,
         &hasPath,
         &angle
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlLabel * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlLabel"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlLabel *)new XBMCAddon::xbmcgui::ControlLabel(  x,  y,  width,  height,  label,  font,  textColor,  disabledColor,  alignment,  hasPath,  angle  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlLabel_getLabel__doc__,
               "getLabel() --Returns the text value for this label.\n"
"\n"
"example:\n"
"    - label = self.label.getLabel()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlLabel_Type,"getLabel","XBMCAddon::xbmcgui::ControlLabel"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlLabel_setLabel__doc__,
               "setLabel(label)--Set's text for this label.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.label.setLabel('Status')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlLabel_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlLabel_Type,"setLabel","XBMCAddon::xbmcgui::ControlLabel"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "font",
          "textColor",
          "disabledColor",
          "_alignment",
          "focusTexture",
          "noFocusTexture",
          "isPassword",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  _alignment  = XBFONT_LEFT;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    bool  isPassword  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|ssslssb",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &_alignment,
         &focusTexture,
         &noFocusTexture,
         &isPassword
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlEdit * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlEdit"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlEdit *)new XBMCAddon::xbmcgui::ControlEdit(  x,  y,  width,  height,  label,  font,  textColor,  disabledColor,  _alignment,  focusTexture,  noFocusTexture,  isPassword  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlEdit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlEdit\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_setLabel__doc__,
               "setLabel(label)--Set's text heading for this edit control.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.edit.setLabel('Status')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"setLabel","XBMCAddon::xbmcgui::ControlEdit"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_getLabel__doc__,
               "getLabel() --Returns the text heading for this edit control.\n"
"\n"
"example:\n"
"    - label = self.edit.getLabel()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"getLabel","XBMCAddon::xbmcgui::ControlEdit"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_setText__doc__,
               "setText(value)--Set's text value for this edit control.\n"
"\n"
"value : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.edit.setText('online')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    std::string  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"setText","XBMCAddon::xbmcgui::ControlEdit"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit_getText__doc__,
               "getText() --Returns the text value for this edit control.\n"
"\n"
"example:\n"
"    - value = self.edit.getText()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"getText","XBMCAddon::xbmcgui::ControlEdit"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          "buttonTexture",
          "buttonFocusTexture",
          "selectedColor",
          "_imageWidth",
          "_imageHeight",
          "_itemTextXOffset",
          "_itemTextYOffset",
          "_itemHeight",
          "_space",
          "_alignmentY",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * buttonTexture  = NULL;         
    char * buttonFocusTexture  = NULL;         
    char * selectedColor  = NULL;         
    long  _imageWidth  = 10;         
    long  _imageHeight  = 10;         
    long  _itemTextXOffset  = 10;         
    long  _itemTextYOffset  = 2;         
    long  _itemHeight  = 27;         
    long  _space  = 2;         
    long  _alignmentY  = XBFONT_CENTER_Y;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ssssslllllll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor,
         &buttonTexture,
         &buttonFocusTexture,
         &selectedColor,
         &_imageWidth,
         &_imageHeight,
         &_itemTextXOffset,
         &_itemTextYOffset,
         &_itemHeight,
         &_space,
         &_alignmentY
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlList * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlList *)new XBMCAddon::xbmcgui::ControlList(  x,  y,  width,  height,  font,  textColor,  buttonTexture,  buttonFocusTexture,  selectedColor,  _imageWidth,  _imageHeight,  _itemTextXOffset,  _itemTextYOffset,  _itemHeight,  _space,  _alignmentY  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlList\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_addItem__doc__,
               "addItem(item)--Add a new item to this list control.\n"
"\n"
"item : string, unicode orListItem - item to add.\n"
"\n"
"example:\n"
"    - cList.addItem('Reboot XBMC')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_addItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          "sendMessage",
          NULL};
         
    Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  item ;
    PyObject* pyitem = NULL;         
    bool  sendMessage  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|b",
       (char**)keywords,
         &pyitem,
         &sendMessage
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyitem;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,false,"entry0_1","addItem");
        item.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_1;
          entry1_1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItem");
          item.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }

      
 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"addItem","XBMCAddon::xbmcgui::ControlList"))-> addItem(  item,  sendMessage  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_addItems__doc__,
               "addItems(items)--Adds a list of listitems or strings to this list control.\n"
"\n"
"items :List - list of strings, unicode objects or ListItems to add.\n"
"\n"
"*Note, You can use the above as keywords for arguments.\n"
"\n"
"Large lists benefit considerably, than using the standardaddItem() \n"
"\n"
"example:\n"
"    - cList.addItems(items=listitems)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_addItems (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  >  items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  entry1;
        

    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_2 = pyentry1;
      try
      {
        std::string  entry0_2;
        if (pyentry_2) PyXBMCGetUnicodeString(entry0_2,pyentry_2,false,"entry0_2","addItems");
        entry1.former() = entry0_2;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_2;
          entry1_2 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_2,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItems");
          entry1.later() = entry1_2;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }

      

        items.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"addItems","XBMCAddon::xbmcgui::ControlList"))-> addItems(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItems\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_selectItem__doc__,
               "selectItem(item)--Select an item by index number.\n"
"\n"
"item : integer - index number of the item to select.\n"
"\n"
"example:\n"
"    - cList.selectItem(12)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_selectItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          NULL};
         
    long  item ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &item
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"selectItem","XBMCAddon::xbmcgui::ControlList"))-> selectItem(  item  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"selectItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"selectItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_removeItem__doc__,
               "removeItem(index)--Remove an item by index number.\n"
"\n"
"index : integer - index number of the item to remove.\n"
"\n"
"example:\n"
"    - cList.removeItem(12)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_removeItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "index",
          NULL};
         
    int  index ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &index
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"removeItem","XBMCAddon::xbmcgui::ControlList"))-> removeItem(  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_reset__doc__,
               "reset() --Clear all ListItems in this control list.\n"
"\n"
"example:\n"
"    - cList.reset()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"reset","XBMCAddon::xbmcgui::ControlList"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSpinControl__doc__,
               "getSpinControl() --returns the associatedControlSpin object.\n"
"\n"
"*Note, Not working completely yet -\n"
"After adding this control list to a window it is not possible to change\n"
"the settings of this spin control.\n"
"\n"
"example:\n"
"    - ctl = cList.getSpinControl()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpinControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSpinControl","XBMCAddon::xbmcgui::ControlList"))-> getSpinControl(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpinControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpinControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSelectedPosition__doc__,
               "getSelectedPosition() --Returns the position of the selected item as an integer.\n"
"\n"
"*Note, Returns -1 for empty lists.\n"
"\n"
"example:\n"
"    - pos = cList.getSelectedPosition()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSelectedPosition","XBMCAddon::xbmcgui::ControlList"))-> getSelectedPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSelectedItem__doc__,
               "getSelectedItem() --Returns the selected item as aListItem object.\n"
"\n"
"*Note, Same asgetSelectedPosition() , but instead of an integer aListItem object\n"
"is returned. Returns None for empty lists.\n"
"See windowexample.py on how to use this.\n"
"\n"
"example:\n"
"    - item = cList.getSelectedItem()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSelectedItem","XBMCAddon::xbmcgui::ControlList"))-> getSelectedItem(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelectedItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelectedItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setImageDimensions__doc__,
               "setImageDimensions(imageWidth, imageHeight)--Sets the width/height of items icon or thumbnail.\n"
"\n"
"imageWidth : [opt] integer - width of items icon or thumbnail.\n"
"imageHeight : [opt] integer - height of items icon or thumbnail.\n"
"\n"
"example:\n"
"    - cList.setImageDimensions(18, 18)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setImageDimensions (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "imageWidth",
          "imageHeight",
          NULL};
         
    long  imageWidth ;         
    long  imageHeight ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ll",
       (char**)keywords,
         &imageWidth,
         &imageHeight
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setImageDimensions","XBMCAddon::xbmcgui::ControlList"))-> setImageDimensions(  imageWidth,  imageHeight  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImageDimensions\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImageDimensions\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setItemHeight__doc__,
               "setItemHeight(itemHeight)--Sets the height of items.\n"
"\n"
"itemHeight : integer - height of items.\n"
"\n"
"example:\n"
"    - cList.setItemHeight(25)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "height",
          NULL};
         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setItemHeight","XBMCAddon::xbmcgui::ControlList"))-> setItemHeight(  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setItemHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setSpace__doc__,
               "setSpace(space)--Set's the space between items.\n"
"\n"
"space : [opt] integer - space between items.\n"
"\n"
"example:\n"
"    - cList.setSpace(5)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "space",
          NULL};
         
    int  space ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &space
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setSpace","XBMCAddon::xbmcgui::ControlList"))-> setSpace(  space  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSpace\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setPageControlVisible__doc__,
               "setPageControlVisible(visible)--Sets the spin control's visible/hidden state.\n"
"\n"
"visible : boolean - True=visible / False=hidden.\n"
"\n"
"example:\n"
"    - cList.setPageControlVisible(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setPageControlVisible (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "visible",
          NULL};
         
    bool  visible ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &visible
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setPageControlVisible","XBMCAddon::xbmcgui::ControlList"))-> setPageControlVisible(  visible  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPageControlVisible\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPageControlVisible\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_size__doc__,
               "size() --Returns the total number of items in this list control as an integer.\n"
"\n"
"example:\n"
"    - cnt = cList.size()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_size (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"size","XBMCAddon::xbmcgui::ControlList"))-> size(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"size\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"size\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getItemHeight__doc__,
               "getItemHeight() --Returns the control's current item height as an integer.\n"
"\n"
"example:\n"
"    - item_height = self.cList.getItemHeight()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getItemHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getItemHeight","XBMCAddon::xbmcgui::ControlList"))-> getItemHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getItemHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getItemHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getSpace__doc__,
               "getSpace() --Returns the control's space between items as an integer.\n"
"\n"
"example:\n"
"    - gap = self.cList.getSpace()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpace (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getSpace","XBMCAddon::xbmcgui::ControlList"))-> getSpace(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSpace\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSpace\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_getListItem__doc__,
               "getListItem(index)--Returns a givenListItem in thisList .\n"
"\n"
"index : integer - index number of item to return.\n"
"\n"
"*Note, throws a ValueError if index is out of range.\n"
"\n"
"example:\n"
"    - listitem = cList.getListItem(6)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "index",
          NULL};
         
    int  index ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &index
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"getListItem","XBMCAddon::xbmcgui::ControlList"))-> getListItem(  index  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList_setStaticContent__doc__,
               "setStaticContent(items)--Fills a static list with a list of listitems.\n"
"\n"
"items :List - list of listitems to add.\n"
"\n"
"*Note, You can use the above as keywords for arguments.\n"
"\n"
"example:\n"
"    - cList.setStaticContent(items=listitems)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlList_setStaticContent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "items",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::ListItem * > * items ;
    PyObject* pyitems = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyitems
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      items = new std::vector<XBMCAddon::xbmcgui::ListItem *>();
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        XBMCAddon::xbmcgui::ListItem * entry1;
        entry1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","setStaticContent");
        items->push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"setStaticContent","XBMCAddon::xbmcgui::ControlList"))-> setStaticContent(  items  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setStaticContent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setStaticContent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          "_alignment",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    long  _alignment  = XBFONT_LEFT;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ssl",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor,
         &_alignment
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlFadeLabel * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlFadeLabel *)new XBMCAddon::xbmcgui::ControlFadeLabel(  x,  y,  width,  height,  font,  textColor,  _alignment  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlFadeLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlFadeLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlFadeLabel_addLabel__doc__,
               "addLabel(label)--Add a label to this control for scrolling.\n"
"\n"
"label : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.fadelabel.addLabel('This is a line of text that can scroll.')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_addLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          NULL};
         
    std::string  label ;
    PyObject* pylabel = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pylabel
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","addLabel"); 

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"addLabel","XBMCAddon::xbmcgui::ControlFadeLabel"))-> addLabel(  label  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlFadeLabel_reset__doc__,
               "reset() --Clear this fade label.\n"
"\n"
"example:\n"
"    - self.fadelabel.reset()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"reset","XBMCAddon::xbmcgui::ControlFadeLabel"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "font",
          "textColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * font  = NULL;         
    char * textColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|ss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &font,
         &textColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlTextBox * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlTextBox *)new XBMCAddon::xbmcgui::ControlTextBox(  x,  y,  width,  height,  font,  textColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlTextBox\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlTextBox\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_setText__doc__,
               "setText(text)--Set's the text for this textbox.\n"
"\n"
"text : string or unicode - text string.\n"
"\n"
"example:\n"
"    - self.textbox.setText('This is a line of text that can wrap.')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_setText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "text",
          NULL};
         
    std::string  text ;
    PyObject* pytext = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pytext
       ))
    {
      return NULL;
    }


    try
    {
      if (pytext) PyXBMCGetUnicodeString(text,pytext,false,"text","setText"); 

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"setText","XBMCAddon::xbmcgui::ControlTextBox"))-> setText(  text  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_getText__doc__,
               "getText() --Returns the text value for this textbox.\n"
"\n"
"example:\n"
"    - text = self.text.getText()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_getText (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"getText","XBMCAddon::xbmcgui::ControlTextBox"))-> getText(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getText\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getText\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_reset__doc__,
               "reset() --Clear's this textbox.\n"
"\n"
"example:\n"
"    - self.textbox.reset()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_reset (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"reset","XBMCAddon::xbmcgui::ControlTextBox"))-> reset(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"reset\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"reset\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox_scroll__doc__,
               "scroll(position)--Scrolls to the given position.\n"
"\n"
"id : integer - position to scroll to.\n"
"\n"
"example:\n"
"    - self.textbox.scroll(10)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_scroll (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "id",
          NULL};
         
    long  id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &id
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"scroll","XBMCAddon::xbmcgui::ControlTextBox"))-> scroll(  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"scroll\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"scroll\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "filename",
          "aspectRatio",
          "colorDiffuse",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * filename ;         
    long  aspectRatio  = 0;         
    char * colorDiffuse  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"lllls|ls",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &filename,
         &aspectRatio,
         &colorDiffuse
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlImage * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlImage *)new XBMCAddon::xbmcgui::ControlImage(  x,  y,  width,  height,  filename,  aspectRatio,  colorDiffuse  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlImage_setImage__doc__,
               "setImage(filename, useCache)--Changes the image.\n"
"\n"
"filename : string - image filename. useCache : [opt] bool - true/use cache, false/don't use cache\n"
"\n"
"example:\n"
"    - self.image.setImage('special://home/scripts/test.png')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_setImage (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "imageFilename",
          "useCache",
          NULL};
         
    char * imageFilename ;         
    bool  useCache  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s|b",
       (char**)keywords,
         &imageFilename,
         &useCache
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlImage_Type,"setImage","XBMCAddon::xbmcgui::ControlImage"))-> setImage(  imageFilename,  useCache  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setImage\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlImage_setColorDiffuse__doc__,
               "setColorDiffuse(colorDiffuse)--Changes the images color.\n"
"\n"
"colorDiffuse : hexString - (example, '0xC0FF0000' (red tint))\n"
"\n"
"example:\n"
"    - self.image.setColorDiffuse('0xC0FF0000')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlImage_setColorDiffuse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "hexString",
          NULL};
         
    char * hexString ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &hexString
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlImage_Type,"setColorDiffuse","XBMCAddon::xbmcgui::ControlImage"))-> setColorDiffuse(  hexString  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setColorDiffuse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setColorDiffuse\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "texturebg",
          "textureleft",
          "texturemid",
          "textureright",
          "textureoverlay",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * texturebg  = NULL;         
    char * textureleft  = NULL;         
    char * texturemid  = NULL;         
    char * textureright  = NULL;         
    char * textureoverlay  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|sssss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &texturebg,
         &textureleft,
         &texturemid,
         &textureright,
         &textureoverlay
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlProgress * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlProgress *)new XBMCAddon::xbmcgui::ControlProgress(  x,  y,  width,  height,  texturebg,  textureleft,  texturemid,  textureright,  textureoverlay  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlProgress\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlProgress_setPercent__doc__,
               "setPercent(percent)--Sets the percentage of the progressbar to show.\n"
"\n"
"percent : float - percentage of the bar to show.\n"
"\n"
"*Note, valid range for percent is 0-100\n"
"\n"
"example:\n"
"    - self.progress.setPercent(60)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlProgress_Type,"setPercent","XBMCAddon::xbmcgui::ControlProgress"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlProgress_getPercent__doc__,
               "getPercent() --Returns a float of the percent of the progress.\n"
"\n"
"example:\n"
"    - print self.progress.getValue()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlProgress_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlProgress_Type,"getPercent","XBMCAddon::xbmcgui::ControlProgress"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusTexture",
          "noFocusTexture",
          "textOffsetX",
          "textOffsetY",
          "alignment",
          "font",
          "textColor",
          "disabledColor",
          "angle",
          "shadowColor",
          "focusedColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  textOffsetX  = 10;         
    long  textOffsetY  = 2;         
    long  alignment  = (XBFONT_LEFT|XBFONT_CENTER_Y);         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  angle  = 0;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sslllssslss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusTexture,
         &noFocusTexture,
         &textOffsetX,
         &textOffsetY,
         &alignment,
         &font,
         &textColor,
         &disabledColor,
         &angle,
         &shadowColor,
         &focusedColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlButton * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlButton"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlButton *)new XBMCAddon::xbmcgui::ControlButton(  x,  y,  width,  height,  label,  focusTexture,  noFocusTexture,  textOffsetX,  textOffsetY,  alignment,  font,  textColor,  disabledColor,  angle,  shadowColor,  focusedColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlButton\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_setLabel__doc__,
               "setLabel([label, font, textColor, disabledColor, shadowColor, focusedColor])--Set's this buttons text attributes.\n"
"\n"
"label : [opt] string or unicode - text string.\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled button's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled button's label. (e.g. '0xFFFF3300')\n"
"shadowColor : [opt] hexstring - color of button's label's shadow. (e.g. '0xFF000000')\n"
"focusedColor : [opt] hexstring - color of focused button's label. (e.g. '0xFFFFFF00')\n"
"label2 : [opt] string or unicode - text string.\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.button.setLabel('Status', 'font14', '0xFFFFFFFF', '0xFFFF3300', '0xFF000000')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"setLabel","XBMCAddon::xbmcgui::ControlButton"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_setDisabledColor__doc__,
               "setDisabledColor(disabledColor)--Set's this buttons disabled color.\n"
"\n"
"disabledColor : hexstring - color of disabled button's label. (e.g. '0xFFFF3300')\n"
"\n"
"example:\n"
"    - self.button.setDisabledColor('0xFFFF3300')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_setDisabledColor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "color",
          NULL};
         
    char * color ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &color
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"setDisabledColor","XBMCAddon::xbmcgui::ControlButton"))-> setDisabledColor(  color  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDisabledColor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDisabledColor\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_getLabel__doc__,
               "getLabel() --Returns the buttons label as a unicode string.\n"
"\n"
"example:\n"
"    - label = self.button.getLabel()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"getLabel","XBMCAddon::xbmcgui::ControlButton"))-> getLabel(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton_getLabel2__doc__,
               "getLabel2() --Returns the buttons label2 as a unicode string.\n"
"\n"
"example:\n"
"    - label = self.button.getLabel2()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"getLabel2","XBMCAddon::xbmcgui::ControlButton"))-> getLabel2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getLabel2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getLabel2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyUnicode_DecodeUTF8(apiResult.c_str(),apiResult.size(),"replace");


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusTexture",
          "noFocusTexture",
          "checkWidth",
          "checkHeight",
          "_alignment",
          "font",
          "textColor",
          "disabledColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  checkWidth  = 30;         
    long  checkHeight  = 30;         
    long  _alignment  = XBFONT_RIGHT;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sslllsss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusTexture,
         &noFocusTexture,
         &checkWidth,
         &checkHeight,
         &_alignment,
         &font,
         &textColor,
         &disabledColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlCheckMark * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlCheckMark"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlCheckMark *)new XBMCAddon::xbmcgui::ControlCheckMark(  x,  y,  width,  height,  label,  focusTexture,  noFocusTexture,  checkWidth,  checkHeight,  _alignment,  font,  textColor,  disabledColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlCheckMark\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlCheckMark\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_getSelected__doc__,
               "getSelected() --Returns the selected status for this checkmark as a bool.\n"
"\n"
"example:\n"
"    - selected = self.checkmark.getSelected()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_getSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type,"getSelected","XBMCAddon::xbmcgui::ControlCheckMark"))-> getSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_setSelected__doc__,
               "setSelected(isOn)--Sets this checkmark status to on or off.\n"
"\n"
"isOn : bool - True=selected (on) / False=not selected (off)\n"
"\n"
"example:\n"
"    - self.checkmark.setSelected(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type,"setSelected","XBMCAddon::xbmcgui::ControlCheckMark"))-> setSelected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_setLabel__doc__,
               "setLabel(label[, font, textColor, disabledColor])--Set's this controls text attributes.\n"
"\n"
"label : string or unicode - text string.\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled checkmark's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"example:\n"
"    - self.checkmark.setLabel('Status', 'font14', '0xFFFFFFFF', '0xFFFF3300')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type,"setLabel","XBMCAddon::xbmcgui::ControlCheckMark"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor__doc__,
               "setDisabledColor(disabledColor)--Set's this controls disabled color.\n"
"\n"
"disabledColor : hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"example:\n"
"    - self.checkmark.setDisabledColor('0xFFFF3300')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "color",
          NULL};
         
    char * color ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &color
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type,"setDisabledColor","XBMCAddon::xbmcgui::ControlCheckMark"))-> setDisabledColor(  color  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setDisabledColor\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setDisabledColor\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlGroup_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlGroup * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlGroup *)new XBMCAddon::xbmcgui::ControlGroup(  x,  y,  width,  height  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlGroup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlGroup\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "label",
          "focusOnTexture",
          "noFocusOnTexture",
          "focusOffTexture",
          "noFocusOffTexture",
          "focusTexture",
          "noFocusTexture",
          "textOffsetX",
          "textOffsetY",
          "_alignment",
          "font",
          "textColor",
          "disabledColor",
          "angle",
          "shadowColor",
          "focusedColor",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    std::string  label ;
    PyObject* pylabel = NULL;         
    char * focusOnTexture  = NULL;         
    char * noFocusOnTexture  = NULL;         
    char * focusOffTexture  = NULL;         
    char * noFocusOffTexture  = NULL;         
    char * focusTexture  = NULL;         
    char * noFocusTexture  = NULL;         
    long  textOffsetX  = 10;         
    long  textOffsetY  = 2;         
    long  _alignment  = (XBFONT_LEFT|XBFONT_CENTER_Y);         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    long  angle  = 0;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llllO|sssssslllssslss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &pylabel,
         &focusOnTexture,
         &noFocusOnTexture,
         &focusOffTexture,
         &noFocusOffTexture,
         &focusTexture,
         &noFocusTexture,
         &textOffsetX,
         &textOffsetY,
         &_alignment,
         &font,
         &textColor,
         &disabledColor,
         &angle,
         &shadowColor,
         &focusedColor
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlRadioButton * apiResult;
    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","ControlRadioButton"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlRadioButton *)new XBMCAddon::xbmcgui::ControlRadioButton(  x,  y,  width,  height,  label,  focusOnTexture,  noFocusOnTexture,  focusOffTexture,  noFocusOffTexture,  focusTexture,  noFocusTexture,  textOffsetX,  textOffsetY,  _alignment,  font,  textColor,  disabledColor,  angle,  shadowColor,  focusedColor  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlRadioButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlRadioButton\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_setSelected__doc__,
               "setSelected(selected)--Sets the radio buttons's selected status.\n"
"\n"
"selected : bool - True=selected (on) / False=not selected (off)\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.radiobutton.setSelected(True)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "selected",
          NULL};
         
    bool  selected ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"b",
       (char**)keywords,
         &selected
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setSelected","XBMCAddon::xbmcgui::ControlRadioButton"))-> setSelected(  selected  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_isSelected__doc__,
               "isSelected() --Returns the radio buttons's selected status.\n"
"\n"
"example:\n"
"    - is = self.radiobutton.isSelected()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_isSelected (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"isSelected","XBMCAddon::xbmcgui::ControlRadioButton"))-> isSelected(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isSelected\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isSelected\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_setLabel__doc__,
               "setLabel(label[, font, textColor, disabledColor, shadowColor, focusedColor])--Set's the radio buttons text attributes.\n"
"\n"
"label : string or unicode - text string.\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled radio button's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled radio button's label. (e.g. '0xFFFF3300')\n"
"shadowColor : [opt] hexstring - color of radio button's label's shadow. (e.g. '0xFF000000')\n"
"focusedColor : [opt] hexstring - color of focused radio button's label. (e.g. '0xFFFFFF00')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.radiobutton.setLabel('Status', 'font14', '0xFFFFFFFF', '0xFFFF3300', '0xFF000000')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setLabel (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "label",
          "font",
          "textColor",
          "disabledColor",
          "shadowColor",
          "focusedColor",
          "label2",
          NULL};
         
    std::string  label  = XBMCAddon::emptyString;
    PyObject* pylabel = NULL;         
    char * font  = NULL;         
    char * textColor  = NULL;         
    char * disabledColor  = NULL;         
    char * shadowColor  = NULL;         
    char * focusedColor  = NULL;         
    std::string  label2  = XBMCAddon::emptyString;
    PyObject* pylabel2 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|OsssssO",
       (char**)keywords,
         &pylabel,
         &font,
         &textColor,
         &disabledColor,
         &shadowColor,
         &focusedColor,
         &pylabel2
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel) PyXBMCGetUnicodeString(label,pylabel,false,"label","setLabel"); 
      if (pylabel2) PyXBMCGetUnicodeString(label2,pylabel2,false,"label2","setLabel"); 

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setLabel","XBMCAddon::xbmcgui::ControlRadioButton"))-> setLabel(  label,  font,  textColor,  disabledColor,  shadowColor,  focusedColor,  label2  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setLabel\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension__doc__,
               "setRadioDimension(x, y, width, height)--Sets the radio buttons's radio texture's position and size.\n"
"\n"
"x : integer - x coordinate of radio texture.\n"
"y : integer - y coordinate of radio texture.\n"
"width : integer - width of radio texture.\n"
"height : integer - height of radio texture.\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - self.radiobutton.setRadioDimension(x=100, y=5, width=20, height=20)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"setRadioDimension","XBMCAddon::xbmcgui::ControlRadioButton"))-> setRadioDimension(  x,  y,  width,  height  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setRadioDimension\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setRadioDimension\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "x",
          "y",
          "width",
          "height",
          "textureback",
          "texture",
          "texturefocus",
          NULL};
         
    long  x ;         
    long  y ;         
    long  width ;         
    long  height ;         
    char * textureback  = NULL;         
    char * texture  = NULL;         
    char * texturefocus  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"llll|sss",
       (char**)keywords,
         &x,
         &y,
         &width,
         &height,
         &textureback,
         &texture,
         &texturefocus
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ControlSlider * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::ControlSlider *)new XBMCAddon::xbmcgui::ControlSlider(  x,  y,  width,  height,  textureback,  texture,  texturefocus  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlSlider\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::ControlSlider\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSlider_getPercent__doc__,
               "getPercent() --Returns a float of the percent of the slider.\n"
"\n"
"example:\n"
"    - print self.slider.getPercent()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_getPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSlider_Type,"getPercent","XBMCAddon::xbmcgui::ControlSlider"))-> getPercent(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSlider_setPercent__doc__,
               "setPercent(50)--Sets the percent of the slider.\n"
"\n"
"example:\n"
"    - self.slider.setPercent(50)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_ControlSlider_setPercent (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pct",
          NULL};
         
    float  pct ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"f",
       (char**)keywords,
         &pct
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSlider_Type,"setPercent","XBMCAddon::xbmcgui::ControlSlider"))-> setPercent(  pct  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setPercent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setPercent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Dialog * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Dialog *)new XBMCAddon::xbmcgui::Dialog(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Dialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Dialog\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_yesno__doc__,
               "yesno(heading, line1[, line2, line3])--Show a dialog 'YES/NO'.\n"
"\n"
"heading : string or unicode - dialog heading.\n"
"line1 : string or unicode - line #1 text.\n"
"line2 : [opt] string or unicode - line #2 text.\n"
"line3 : [opt] string or unicode - line #3 text.\n"
"nolabel : [opt] label to put on the no button.\n"
"yeslabel : [opt] label to put on the yes button.\n"
"autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)\n"
"\n"
"*Note, Returns True if 'Yes' was pressed, else False.\n"
"*Note, Optionally line1 can be sent as multi-line text. In this case line2 and line3 must be omitted.\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"\n"
"    - ret = dialog.yesno('XBMC', 'Do you want to exit this script?')n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_yesno (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          "nolabel",
          "yeslabel",
          "autoclose",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  line1 ;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;         
    std::string  nolabel  = XBMCAddon::emptyString;
    PyObject* pynolabel = NULL;         
    std::string  yeslabel  = XBMCAddon::emptyString;
    PyObject* pyyeslabel = NULL;         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|OOOOi",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3,
         &pynolabel,
         &pyyeslabel,
         &autoclose
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","yesno"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","yesno"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","yesno"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","yesno"); 
      if (pynolabel) PyXBMCGetUnicodeString(nolabel,pynolabel,false,"nolabel","yesno"); 
      if (pyyeslabel) PyXBMCGetUnicodeString(yeslabel,pyyeslabel,false,"yeslabel","yesno"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"yesno","XBMCAddon::xbmcgui::Dialog"))-> yesno(  heading,  line1,  line2,  line3,  nolabel,  yeslabel,  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"yesno\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"yesno\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_select__doc__,
               "select(heading, list)--Show a select dialog.\n"
"\n"
"heading : string or unicode - dialog heading.\n"
"list : string list - list of items.\n"
"autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)\n"
"\n"
"*Note, Returns the position of the highlighted item as an integer.\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"\n"
"    - ret = dialog.select('Choose a playlist', ['Playlist #1', 'Playlist #2, 'Playlist #3'])n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_select (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "list",
          "autoclose",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::vector< XBMCAddon::String  >  list ;
    PyObject* pylist = NULL;         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|i",
       (char**)keywords,
         &pyheading,
         &pylist,
         &autoclose
       ))
    {
      return NULL;
    }

    int  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","select"); 
      

    {
      bool isTuple = PyObject_TypeCheck(pylist,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pylist,&PyList_Type))
        throw WrongTypeException("The parameter \"list\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pylist) : PyList_Size(pylist));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pylist, i) : PyList_GetItem(pylist, i));
        std::string  entry1;
        if (pyentry1) PyXBMCGetUnicodeString(entry1,pyentry1,false,"entry1","select");
        list.push_back(entry1);
      }
    }
 

      apiResult = (int )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"select","XBMCAddon::xbmcgui::Dialog"))-> select(  heading,  list,  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"select\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"select\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_ok__doc__,
               "ok(heading, line1[, line2, line3])--Show a dialog 'OK'.\n"
"\n"
"heading : string or unicode - dialog heading.\n"
"line1 : string or unicode - line #1 text.\n"
"line2 : [opt] string or unicode - line #2 text.\n"
"line3 : [opt] string or unicode - line #3 text.\n"
"\n"
"*Note, Returns True if 'Ok' was pressed, else False.\n"
"*Note: Optionally line1 can be sent as multi-line text. In this case line2 and line3 must be omitted.\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"\n"
"    - ok = dialog.ok('XBMC', 'There was an error.')n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_ok (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  line1 ;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|OO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","ok"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","ok"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","ok"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","ok"); 

      apiResult = (bool )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"ok","XBMCAddon::xbmcgui::Dialog"))-> ok(  heading,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"ok\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"ok\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_browse__doc__,
               "browse(type, heading, shares[, mask, useThumbs, treatAsFolder, default, enableMultiple])--Show a 'Browse' dialog.\n"
"\n"
"type : integer - the type of browse dialog.\n"
"heading : string or unicode - dialog heading.\n"
"shares : string or unicode - from sources.xml. (i.e. 'myprograms')\n"
"mask : [opt] string or unicode - '|' separated file mask. (i.e. '.jpg|.png')\n"
"useThumbs : [opt] boolean - if True autoswitch to Thumb view if files exist.\n"
"treatAsFolder : [opt] boolean - if True playlists and archives act as folders.\n"
"default : [opt] string - default path or file.\n"
"enableMultiple : [opt] boolean - if True multiple file selection is enabled.\n"
"\n"
"Types:\n"
"    - 0 : ShowAndGetDirectory\n"
"    - 1 : ShowAndGetFile\n"
"    - 2 : ShowAndGetImage\n"
"    - 3 : ShowAndGetWriteableDirectory\n"
"\n"
"\n"
"*Note, If enableMultiple is False (default): returns filename and/or path as a string\n"
"to the location of the highlighted item, if user pressed 'Ok' or a masked item\n"
"was selected. Returns the default value if dialog was canceled.\n"
"If enableMultiple is True: returns tuple of marked filenames as a strin\n"
"if user pressed 'Ok' or a masked item was selected. Returns empty tuple if dialog was canceled.\n"
"\n"
"If type is 0 or 3 the enableMultiple parameter is ignore\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"\n"
"    - fn = dialog.browse(3, 'XBMC', 'files', '', False, False, False, 'special://masterprofile/script_data/XBMC Lyrics')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browse (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "s_shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          "enableMultiple",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  s_shares ;
    PyObject* pys_shares = NULL;         
    std::string  mask  = XBMCAddon::emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;         
    bool  enableMultiple  = false;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbOb",
       (char**)keywords,
         &type,
         &pyheading,
         &pys_shares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt,
         &enableMultiple
       ))
    {
      return NULL;
    }

    Alternative< XBMCAddon::String ,std::vector< XBMCAddon::String  >  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browse"); 
      if (pys_shares) PyXBMCGetUnicodeString(s_shares,pys_shares,false,"s_shares","browse"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browse"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browse"); 

      apiResult = (Alternative< XBMCAddon::String ,std::vector< XBMCAddon::String  >  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"browse","XBMCAddon::xbmcgui::Dialog"))-> browse(  type,  heading,  s_shares,  mask,  useThumbs,  treatAsFolder,  defaultt,  enableMultiple  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browse\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browse\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    

    WhichAlternative pos = apiResult.which();

    if (pos != XBMCAddon::none)
    { 
      if (pos == XBMCAddon::first)
      {
        std::string & entry1 = apiResult.former();
        {
          
result = PyString_FromStringAndSize(entry1.c_str(), entry1.length());

        }
      }

      if (pos == XBMCAddon::second)
      {
        std::vector< XBMCAddon::String  > & entry1 = apiResult.later();
        {
          


    result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = entry1.begin(); iter != entry1.end(); ++iter)
      {
        std::string & entry2 = *iter;
        PyObject* pyentry2;
        
pyentry2 = PyString_FromStringAndSize(entry2.c_str(), entry2.length());

        PyList_Append(result, pyentry2);
        Py_DECREF(pyentry2);
      }


        }
      }

    }
    else
    { 
      result = Py_None;
    }


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_browseSingle__doc__,
               "browse(type, heading, shares[, mask, useThumbs, treatAsFolder, default])--Show a 'Browse' dialog.\n"
"\n"
"type : integer - the type of browse dialog.\n"
"heading : string or unicode - dialog heading.\n"
"shares : string or unicode - from sources.xml. (i.e. 'myprograms')\n"
"mask : [opt] string or unicode - '|' separated file mask. (i.e. '.jpg|.png')\n"
"useThumbs : [opt] boolean - if True autoswitch to Thumb view if files exist (default=false).\n"
"treatAsFolder : [opt] boolean - if True playlists and archives act as folders (default=false).\n"
"default : [opt] string - default path or file.\n"
"\n"
"Types:\n"
"\n"
"    - 0 : ShowAndGetDirectory\n"
"    - 1 : ShowAndGetFile\n"
"    - 2 : ShowAndGetImage\n"
"    - 3 : ShowAndGetWriteableDirectory\n"
"*Note, Returns filename and/or path as a string to the location of the highlighted item,\n"
"if user pressed 'Ok' or a masked item was selected.\n"
"Returns the default value if dialog was canceled.\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - fn = dialog.browse(3, 'XBMC', 'files', '', False, False, 'special://masterprofile/script_data/XBMC Lyrics')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browseSingle (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  shares ;
    PyObject* pyshares = NULL;         
    std::string  mask  = XBMCAddon::emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbO",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browseSingle"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browseSingle"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browseSingle"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browseSingle"); 

      apiResult = (std::string )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"browseSingle","XBMCAddon::xbmcgui::Dialog"))-> browseSingle(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browseSingle\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browseSingle\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_browseMultiple__doc__,
               "browse(type, heading, shares[, mask, useThumbs, treatAsFolder, default])--Show a 'Browse' dialog.\n"
"\n"
"type : integer - the type of browse dialog.\n"
"heading : string or unicode - dialog heading.\n"
"shares : string or unicode - from sources.xml. (i.e. 'myprograms')\n"
"mask : [opt] string or unicode - '|' separated file mask. (i.e. '.jpg|.png')\n"
"useThumbs : [opt] boolean - if True autoswitch to Thumb view if files exist (default=false).\n"
"treatAsFolder : [opt] boolean - if True playlists and archives act as folders (default=false).\n"
"default : [opt] string - default path or file.\n"
"\n"
"Types:\n"
"    - 1 : ShowAndGetFile\n"
"    - 2 : ShowAndGetImage\n"
"\n"
"\n"
"*Note,\n"
"returns tuple of marked filenames as a string,\"\n"
"if user pressed 'Ok' or a masked item was selected. Returns empty tuple if dialog was canceled.\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - fn = dialog.browseMultiple(2, 'XBMC', 'files', '', False, False, 'special://masterprofile/script_data/XBMC Lyrics')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_browseMultiple (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "shares",
          "mask",
          "useThumbs",
          "treatAsFolder",
          "defaultt",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  shares ;
    PyObject* pyshares = NULL;         
    std::string  mask  = XBMCAddon::emptyString;
    PyObject* pymask = NULL;         
    bool  useThumbs  = false;         
    bool  treatAsFolder  = false;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|ObbO",
       (char**)keywords,
         &type,
         &pyheading,
         &pyshares,
         &pymask,
         &useThumbs,
         &treatAsFolder,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::vector< XBMCAddon::String  >  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","browseMultiple"); 
      if (pyshares) PyXBMCGetUnicodeString(shares,pyshares,false,"shares","browseMultiple"); 
      if (pymask) PyXBMCGetUnicodeString(mask,pymask,false,"mask","browseMultiple"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","browseMultiple"); 

      apiResult = (std::vector< XBMCAddon::String  > )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"browseMultiple","XBMCAddon::xbmcgui::Dialog"))-> browseMultiple(  type,  heading,  shares,  mask,  useThumbs,  treatAsFolder,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"browseMultiple\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"browseMultiple\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    


    result = PyList_New(0);

      for (std::vector<XBMCAddon::String >::iterator iter = apiResult.begin(); iter != apiResult.end(); ++iter)
      {
        std::string & entry1 = *iter;
        PyObject* pyentry1;
        
pyentry1 = PyString_FromStringAndSize(entry1.c_str(), entry1.length());

        PyList_Append(result, pyentry1);
        Py_DECREF(pyentry1);
      }



    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_numeric__doc__,
               "numeric(type, heading[, default])--Show a 'Numeric' dialog.\n"
"\n"
"type : integer - the type of numeric dialog.\n"
"heading : string or unicode - dialog heading.\n"
"default : [opt] string - default value.\n"
"\n"
"Types:\n"
"    - 0 : ShowAndGetNumber (default format: #)\n"
"    - 1 : ShowAndGetDate (default format: DD/MM/YYYY)\n"
"    - 2 : ShowAndGetTime (default format: HH:MM)\n"
"    - 3 : ShowAndGetIPAddress (default format: #.#.#.#)\n"
"\n"
"\n"
"*Note, Returns the entered data as a string.\n"
"Returns the default value if dialog was canceled.\n"
"\n"
"example:\n"
"\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - d = dialog.numeric(1, 'Enter date of birth')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_numeric (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "type",
          "heading",
          "defaultt",
          NULL};
         
    int  type ;         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iO|O",
       (char**)keywords,
         &type,
         &pyheading,
         &pydefaultt
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","numeric"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","numeric"); 

      apiResult = (std::string )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"numeric","XBMCAddon::xbmcgui::Dialog"))-> numeric(  type,  heading,  defaultt  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"numeric\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"numeric\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_notification__doc__,
               "notification(heading, message[, icon, time, sound])--Show a Notification alert.\n"
"\n"
"heading : string - dialog heading.\n"
"message : string - dialog message.\n"
"icon : [opt] string - icon to use. (default xbmcgui.NOTIFICATION_INFO)\n"
"time : [opt] integer - time in milliseconds (default 5000)\n"
"sound : [opt] bool - play notification sound (default True)\n"
"\n"
"Builtin Icons:\n"
"\n"
"    - xbmcgui.NOTIFICATION_INFO\n"
"    - xbmcgui.NOTIFICATION_WARNING\n"
"    - xbmcgui.NOTIFICATION_ERROR\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - dialog.notification('Movie Trailers', 'Finding Nemo download finished.', xbmcgui.NOTIFICATION_INFO, 5000)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_notification (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "message",
          "icon",
          "time",
          "sound",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  message ;
    PyObject* pymessage = NULL;         
    std::string  icon  = XBMCAddon::emptyString;
    PyObject* pyicon = NULL;         
    int  time  = 0;         
    bool  sound  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO|Oib",
       (char**)keywords,
         &pyheading,
         &pymessage,
         &pyicon,
         &time,
         &sound
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","notification"); 
      if (pymessage) PyXBMCGetUnicodeString(message,pymessage,false,"message","notification"); 
      if (pyicon) PyXBMCGetUnicodeString(icon,pyicon,false,"icon","notification"); 

      ((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"notification","XBMCAddon::xbmcgui::Dialog"))-> notification(  heading,  message,  icon,  time,  sound  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"notification\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"notification\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog_input__doc__,
               "input(heading[, default, type, option, autoclose])--Show an Input dialog.\n"
"\n"
"heading : string - dialog heading.\n"
"default : [opt] string - default value. (default=empty string)\n"
"type : [opt] integer - the type of keyboard dialog. (default=xbmcgui.INPUT_ALPHANUM)\n"
"option : [opt] integer - option for the dialog. (see Options below)\n"
"autoclose : [opt] integer - milliseconds to autoclose dialog. (default=do not autoclose)\n"
"\n"
"Types:\n"
"    - xbmcgui.INPUT_ALPHANUM (standard keyboard)\n"
"    - xbmcgui.INPUT_NUMERIC (format: #)\n"
"    - xbmcgui.INPUT_DATE (format: DD/MM/YYYY)\n"
"    - xbmcgui.INPUT_TIME (format: HH:MM)\n"
"    - xbmcgui.INPUT_IPADDRESS (format: #.#.#.#)\n"
"    - xbmcgui.INPUT_PASSWORD (return md5 hash of input, input is masked)\n"
"\n"
"\n"
"Options PasswordDialog :\n"
"\n"
"    - xbmcgui.PASSWORD_VERIFY (verifies an existing (default) md5 hashed password)\n"
"Options AlphanumDialog :\n"
"\n"
"    - xbmcgui.ALPHANUM_HIDE_INPUT (masks input)\n"
"*Note, Returns the entered data as a string.\n"
"Returns an empty string if dialog was canceled.\n"
"\n"
"example:\n"
"    - dialog = xbmcgui.Dialog()\n"
"    - d = dialog.input('Enter secret code', type=xbmcgui.INPUT_ALPHANUM, option=xbmcgui.ALPHANUM_HIDE_INPUT)n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Dialog_input (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "defaultt",
          "type",
          "option",
          "autoclose",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  defaultt  = XBMCAddon::emptyString;
    PyObject* pydefaultt = NULL;         
    int  type  = 0;         
    int  option  = 0;         
    int  autoclose  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|Oiii",
       (char**)keywords,
         &pyheading,
         &pydefaultt,
         &type,
         &option,
         &autoclose
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","input"); 
      if (pydefaultt) PyXBMCGetUnicodeString(defaultt,pydefaultt,false,"defaultt","input"); 

      apiResult = (std::string )((XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"input","XBMCAddon::xbmcgui::Dialog"))-> input(  heading,  defaultt,  type,  option,  autoclose  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"input\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"input\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::DialogProgress * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::DialogProgress *)new XBMCAddon::xbmcgui::DialogProgress(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgress\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_create__doc__,
               "create(heading[, line1, line2, line3])--Create and show a progress dialog.\n"
"\n"
"heading : string or unicode - dialog heading.\n"
"line1 : [opt] string or unicode - line #1 text.\n"
"line2 : [opt] string or unicode - line #2 text.\n"
"line3 : [opt] string or unicode - line #3 text.\n"
"\n"
"*Note, Optionally line1 can be sent as multi-line text. In this case line2 and line3 must be omitted.\n"
"*Note, Useupdate() to update lines and progressbar.\n"
"\n"
"example:\n"
"    - pDialog = xbmcgui.DialogProgress()\n"
"    - pDialog.create('XBMC', 'Initializing script...')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_create (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "line1",
          "line2",
          "line3",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  line1  = XBMCAddon::emptyString;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|OOO",
       (char**)keywords,
         &pyheading,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","create"); 
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","create"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","create"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","create"); 

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"create","XBMCAddon::xbmcgui::DialogProgress"))-> create(  heading,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"create\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"create\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_update__doc__,
               "update(percent[, line1, line2, line3])--Updates the progress dialog.\n"
"\n"
"percent : integer - percent complete. (0:100)\n"
"line1 : [opt] string or unicode - line #1 text.\n"
"line2 : [opt] string or unicode - line #2 text.\n"
"line3 : [opt] string or unicode - line #3 text.\n"
"\n"
"*Note, Optionally line1 can be sent as multi-line text. In this case line2 and line3 must be omitted.\n"
"*Note, If percent == 0, the progressbar will be hidden.\n"
"\n"
"example:\n"
"    - pDialog.update(25, 'Importing modules...')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_update (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "percent",
          "line1",
          "line2",
          "line3",
          NULL};
         
    int  percent ;         
    std::string  line1  = XBMCAddon::emptyString;
    PyObject* pyline1 = NULL;         
    std::string  line2  = XBMCAddon::emptyString;
    PyObject* pyline2 = NULL;         
    std::string  line3  = XBMCAddon::emptyString;
    PyObject* pyline3 = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i|OOO",
       (char**)keywords,
         &percent,
         &pyline1,
         &pyline2,
         &pyline3
       ))
    {
      return NULL;
    }


    try
    {
      if (pyline1) PyXBMCGetUnicodeString(line1,pyline1,false,"line1","update"); 
      if (pyline2) PyXBMCGetUnicodeString(line2,pyline2,false,"line2","update"); 
      if (pyline3) PyXBMCGetUnicodeString(line3,pyline3,false,"line3","update"); 

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"update","XBMCAddon::xbmcgui::DialogProgress"))-> update(  percent,  line1,  line2,  line3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"update\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"update\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_close__doc__,
               "close() --Close the progress dialog.\n"
"\n"
"example:\n"
"    - pDialog.close()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"close","XBMCAddon::xbmcgui::DialogProgress"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress_iscanceled__doc__,
               "iscanceled() --Returns True if the user pressed cancel.\n"
"\n"
"example:\n"
"    - if (pDialog.iscanceled()): return\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgress_iscanceled (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"iscanceled","XBMCAddon::xbmcgui::DialogProgress"))-> iscanceled(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"iscanceled\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"iscanceled\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::DialogProgressBG * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::DialogProgressBG *)new XBMCAddon::xbmcgui::DialogProgressBG(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgressBG\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::DialogProgressBG\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgressBG_create__doc__,
               "create(heading[, message])--Create and show a background progress dialog.\n"
"heading : string or unicode - dialog heading.\n"
"message : [opt] string or unicode - message text.\n"
"*Note, 'heading' is used for the dialog's id. Use a unique heading.\n"
"Useupdate() to update heading, message and progressbar.\n"
"example:\n"
"    - pDialog = xbmcgui.DialogProgressBG()\n"
"    - pDialog.create('Movie Trailers', 'Downloading Monsters Inc. ...')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_create (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "heading",
          "message",
          NULL};
         
    std::string  heading ;
    PyObject* pyheading = NULL;         
    std::string  message  = XBMCAddon::emptyString;
    PyObject* pymessage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|O",
       (char**)keywords,
         &pyheading,
         &pymessage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","create"); 
      if (pymessage) PyXBMCGetUnicodeString(message,pymessage,false,"message","create"); 

      ((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"create","XBMCAddon::xbmcgui::DialogProgressBG"))-> create(  heading,  message  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"create\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"create\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgressBG_update__doc__,
               "update([percent, heading, message])--Updates the background progress dialog.\n"
"\n"
"percent : [opt] integer - percent complete. (0:100)\n"
"heading : [opt] string or unicode - dialog heading.\n"
"message : [opt] string or unicode - message text.\n"
"*Note, To clear heading or message, you must pass a blank character.\n"
"example:\n"
"    - pDialog.update(25, message='Downloading Finding Nemo ...')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_update (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "percent",
          "heading",
          "message",
          NULL};
         
    int  percent  = 0;         
    std::string  heading  = XBMCAddon::emptyString;
    PyObject* pyheading = NULL;         
    std::string  message  = XBMCAddon::emptyString;
    PyObject* pymessage = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"|iOO",
       (char**)keywords,
         &percent,
         &pyheading,
         &pymessage
       ))
    {
      return NULL;
    }


    try
    {
      if (pyheading) PyXBMCGetUnicodeString(heading,pyheading,false,"heading","update"); 
      if (pymessage) PyXBMCGetUnicodeString(message,pymessage,false,"message","update"); 

      ((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"update","XBMCAddon::xbmcgui::DialogProgressBG"))-> update(  percent,  heading,  message  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"update\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"update\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgressBG_close__doc__,
               "close() --Close the background progress dialog\n"
"\n"
"example:\n"
"    - pDialog.close()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"close","XBMCAddon::xbmcgui::DialogProgressBG"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgressBG_isFinished__doc__,
               "isFinished() --Returns True if the background dialog is active.\n"
"\n"
"example:\n"
"    - if (pDialog.isFinished()): return\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_isFinished (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    bool  apiResult;
    try
    {

      apiResult = (bool )((XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"isFinished","XBMCAddon::xbmcgui::DialogProgressBG"))-> isFinished(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"isFinished\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"isFinished\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Action * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Action *)new XBMCAddon::xbmcgui::Action(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Action\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Action\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Action_getId__doc__,
               "getId() --Returns the action's current id as a long or 0 if no action is mapped in the xml's.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getId","XBMCAddon::xbmcgui::Action"))-> getId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Action_getButtonCode__doc__,
               "getButtonCode() --Returns the button code for this action.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getButtonCode (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getButtonCode","XBMCAddon::xbmcgui::Action"))-> getButtonCode(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getButtonCode\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getButtonCode\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Action_getAmount1__doc__,
               "getAmount1() --Returns the first amount of force applied to the thumbstick n.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getAmount1 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getAmount1","XBMCAddon::xbmcgui::Action"))-> getAmount1(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAmount1\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAmount1\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Action_getAmount2__doc__,
               "getAmount2() --Returns the second amount of force applied to the thumbstick n.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_getAmount2 (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    float  apiResult;
    try
    {

      apiResult = (float )((XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"getAmount2","XBMCAddon::xbmcgui::Action"))-> getAmount2(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getAmount2\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getAmount2\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"f", apiResult);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    int  existingWindowId  = -1;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"|i",
       
         &existingWindowId
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Window * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::Window *)(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_Window_Director( existingWindowId ) : new XBMCAddon::xbmcgui::Window(  existingWindowId  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Window\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::Window\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_Window_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_Window_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onAction__doc__,
               "onAction(self, Action action)--onAction method.\n"
"\n"
"This method will recieve all actions that the main program will send to this window.\n"
"\n"
"Notes:\n"
"    - By default, only the PREVIOUS_MENU and NAV_BACK actions are handled.\n"
"    - Overwrite this method to let your script handle all actions.\n"
"    - Don't forget to capture ACTION_PREVIOUS_MENU or ACTION_NAV_BACK, else the user can't close this window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onAction (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "action",
          NULL};
         
    XBMCAddon::xbmcgui::Action * action ;
    PyObject* pyaction = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pyaction
       ))
    {
      return NULL;
    }


    try
    {
      action = (XBMCAddon::xbmcgui::Action *)retrieveApiInstance(pyaction,"p.XBMCAddon::xbmcgui::Action","XBMCAddon::xbmcgui::","onAction"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onAction","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onAction(  action  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onAction\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onAction\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onControl__doc__,
               "onControl(self, Control control)--onClick method.\n"
"\n"
"This method will recieve all click events on owned and selected controls when\n"
"the control itself doesn't handle the message.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "control",
          NULL};
         
    XBMCAddon::xbmcgui::Control * control ;
    PyObject* pycontrol = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pycontrol
       ))
    {
      return NULL;
    }


    try
    {
      control = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pycontrol,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","onControl"); 

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onControl","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onControl(  control  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onClick__doc__,
               "onClick(self, int controlId)--onClick method.\n"
"\n"
"This method will recieve all click events that the main program will send\n"
"to this window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onClick (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onClick","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onClick(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onClick\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onClick\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onDoubleClick__doc__,
               "onDoubleClick(self, int controlId)--onClick method.\n"
"\n"
"This method will recieve all double click events that the main program will send\n"
"to this window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onDoubleClick (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onDoubleClick","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onDoubleClick(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onDoubleClick\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onDoubleClick\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onFocus__doc__,
               "onFocus(self, int controlId)--onFocus method.\n"
"\n"
"This method will recieve all focus events that the main program will send\n"
"to this window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "controlId",
          NULL};
         
    int  controlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &controlId
       ))
    {
      return NULL;
    }


    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onFocus","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onFocus(  controlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onFocus\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_onInit__doc__,
               "onInit(self)--onInit method.\n"
"\n"
"This method will be called to initialize the window\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_onInit (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      // This is a director call comming from python so it explcitly calls the base class method.
      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"onInit","XBMCAddon::xbmcgui::Window"))-> XBMCAddon::xbmcgui::Window::onInit(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"onInit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"onInit\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_show__doc__,
               "show(self)--Show this window.\n"
"\n"
"Shows this window by activating it, callingclose() after it wil activate the current window again.\n"
"\n"
"Note, if your script ends this window will be closed to. To show it forever, make a loop at the end of your script ar usedoModal() instead\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_show (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"show","XBMCAddon::xbmcgui::Window"))-> show(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"show\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"show\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setFocus__doc__,
               "setFocus(self, Control)--Give the supplied control focus.\n"
"\n"
"Throws:\n"
"    - TypeError, if supplied argument is not aControl type\n"
"    - SystemError, on Internal error\n"
"    - RuntimeError, if control is not added to a window\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","setFocus"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setFocus","XBMCAddon::xbmcgui::Window"))-> setFocus(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setFocus\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setFocusId__doc__,
               "setFocusId(self, int)--Gives the control with the supplied focus.\n"
"\n"
"Throws:\n"
"    - SystemError, on Internal error\n"
"    - RuntimeError, if control is not added to a window\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setFocusId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iControlId",
          NULL};
         
    int  iControlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iControlId
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setFocusId","XBMCAddon::xbmcgui::Window"))-> setFocusId(  iControlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setFocusId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setFocusId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getFocus__doc__,
               "getFocus(self, Control)--returns the control which is focused.\n"
"\n"
"Throws:\n"
"    - SystemError, on Internal error\n"
"    - RuntimeError, if no control has focus\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getFocus (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getFocus","XBMCAddon::xbmcgui::Window"))-> getFocus(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFocus\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFocus\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getFocusId__doc__,
               "getFocusId(self, int)--returns the id of the control which is focused. Throws:\n"
"    - SystemError, on Internal error\n"
"    - RuntimeError, if no control has focus\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getFocusId (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getFocusId","XBMCAddon::xbmcgui::Window"))-> getFocusId(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getFocusId\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getFocusId\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_removeControl__doc__,
               "removeControl(self, Control)--Removes the control from this window.\n"
"\n"
"Throws:\n"
"    - TypeError, if supplied argument is not aControl type\n"
"    - RuntimeError, if control is not added to this window\n"
"\n"
"\n"
"This will not delete the control. It is only removed from the window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_removeControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","removeControl"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"removeControl","XBMCAddon::xbmcgui::Window"))-> removeControl(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_removeControls__doc__,
               "removeControls(self, List)--Removes a list of controls from this window.\n"
"\n"
"Throws:\n"
"    - TypeError, if supplied argument is not aControl type\n"
"    - RuntimeError, if control is not added to this window\n"
"\n"
"\n"
"This will not delete the controls. They are only removed from the window.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_removeControls (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControls",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::Control * >  pControls ;
    PyObject* pypControls = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControls
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pypControls,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypControls,&PyList_Type))
        throw WrongTypeException("The parameter \"pControls\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypControls) : PyList_Size(pypControls));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypControls, i) : PyList_GetItem(pypControls, i));
        XBMCAddon::xbmcgui::Control * entry1;
        entry1 = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","removeControls");
        pControls.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"removeControls","XBMCAddon::xbmcgui::Window"))-> removeControls(  pControls  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeControls\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeControls\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getHeight__doc__,
               "getHeight(self)--Returns the height of this screen.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getHeight (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getHeight","XBMCAddon::xbmcgui::Window"))-> getHeight(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getHeight\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getHeight\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getWidth__doc__,
               "getWidth(self)--Returns the width of this screen.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getWidth (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getWidth","XBMCAddon::xbmcgui::Window"))-> getWidth(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getWidth\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getWidth\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getResolution__doc__,
               "getResolution(self)--Returns the resolution of the scree The returned value is one of the following:\n"
"    - 0 - 1080i (1920x1080)\n"
"    - 1 - 720p (1280x720)\n"
"    - 2 - 480p 4:3 (720x480)\n"
"    - 3 - 480p 16:9 (720x480)\n"
"    - 4 - NTSC 4:3 (720x480)\n"
"    - 5 - NTSC 16:9 (720x480)\n"
"    - 6 - PAL 4:3 (720x576)\n"
"    - 7 - PAL 16:9 (720x576)\n"
"    - 8 - PAL60 4:3 (720x480)\n"
"    - 9 - PAL60 16:9 (720x480)n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getResolution (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    long  apiResult;
    try
    {

      apiResult = (long )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getResolution","XBMCAddon::xbmcgui::Window"))-> getResolution(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getResolution\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getResolution\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = PyInt_FromLong(apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setCoordinateResolution__doc__,
               "setCoordinateResolution(self, int resolution)--Sets the resolution that the coordinates of all controls are defined in. Allows XBMC to scale control positions and width/heights to whatever resolution XBMC is currently using.\n"
"\n"
"resolution is one of the following:\n"
"    - 0 - 1080i (1920x1080)\n"
"    - 1 - 720p (1280x720)\n"
"    - 2 - 480p 4:3 (720x480)\n"
"    - 3 - 480p 16:9 (720x480)\n"
"    - 4 - NTSC 4:3 (720x480)\n"
"    - 5 - NTSC 16:9 (720x480)\n"
"    - 6 - PAL 4:3 (720x576)\n"
"    - 7 - PAL 16:9 (720x576)\n"
"    - 8 - PAL60 4:3 (720x480)\n"
"    - 9 - PAL60 16:9 (720x480)n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setCoordinateResolution (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "res",
          NULL};
         
    long  res ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"l",
       (char**)keywords,
         &res
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setCoordinateResolution","XBMCAddon::xbmcgui::Window"))-> setCoordinateResolution(  res  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCoordinateResolution\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCoordinateResolution\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_setProperty__doc__,
               "setProperty(key, value)--Sets a window property, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"value : string or unicode - value of property.\n"
"\n"
"*Note, key is NOT case sensitive. Setting value to an empty string is equivalent to clearProperty(key) You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - win.setProperty('Category', 'Newest')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          "value",
          NULL};
         
    char * key ;         
    std::string  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"sO",
       (char**)keywords,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","setProperty"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"setProperty","XBMCAddon::xbmcgui::Window"))-> setProperty(  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getProperty__doc__,
               "getProperty(key)--Returns a window property as a string, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"\n"
"*Note, key is NOT case sensitive. You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - category = win.getProperty('Category')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      apiResult = (std::string )((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getProperty","XBMCAddon::xbmcgui::Window"))-> getProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_clearProperty__doc__,
               "clearProperty(key)--Clears the specific window property.\n"
"\n"
"key : string - property name.\n"
"\n"
"*Note, key is NOT case sensitive. Equivalent to setProperty(key,'') You can use the above as keywords for arguments and skip certain optional arguments. Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - win.clearProperty('Category')n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_clearProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "key",
          NULL};
         
    char * key ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"s",
       (char**)keywords,
         &key
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"clearProperty","XBMCAddon::xbmcgui::Window"))-> clearProperty(  key  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_clearProperties__doc__,
               "clearProperties() --Clears all window properties.\n"
"\n"
"example:\n"
"    - win =xbmcgui.Window (xbmcgui.getCurrentWindowId())\n"
"    - win.clearProperties()n\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_clearProperties (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"clearProperties","XBMCAddon::xbmcgui::Window"))-> clearProperties(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearProperties\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearProperties\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_close__doc__,
               "close(self)--Closes this window.\n"
"\n"
"Closes this window by activating the old window. The window is not deleted with this method.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_close (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"close","XBMCAddon::xbmcgui::Window"))-> close(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"close\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"close\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_doModal__doc__,
               "doModal(self)--Display this window untilclose() is called.\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_doModal (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"doModal","XBMCAddon::xbmcgui::Window"))-> doModal(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"doModal\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"doModal\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_addControl__doc__,
               "addControl(self, Control)--Add aControl to this window.\n"
"\n"
"Throws:\n"
"    - TypeError, if supplied argument is not aControl type\n"
"    - ReferenceError, if control is already used in another window\n"
"    - RuntimeError, should not happen :-)\n"
"\n"
"\n"
"The next controls can be added to a window atm\n"
"\n"
"-ControlLabel -ControlFadeLabel -ControlTextBox -ControlButton -ControlCheckMark -ControlList -ControlGroup -ControlImage -ControlRadioButton -ControlProgressn\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_addControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControl",
          NULL};
         
    XBMCAddon::xbmcgui::Control * pControl ;
    PyObject* pypControl = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControl
       ))
    {
      return NULL;
    }


    try
    {
      pControl = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pypControl,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","addControl"); 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"addControl","XBMCAddon::xbmcgui::Window"))-> addControl(  pControl  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_addControls__doc__,
               "addControls(self, List)--Add a list of Controls to this window.\n"
"\n"
"Throws:\n"
"    - TypeError, if supplied argument is not ofList type, or a control is not ofControl type\n"
"    - ReferenceError, if control is already used in another window\n"
"    - RuntimeError, should not happen :-)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_addControls (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "pControls",
          NULL};
         
    std::vector< XBMCAddon::xbmcgui::Control * >  pControls ;
    PyObject* pypControls = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O",
       (char**)keywords,
         &pypControls
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pypControls,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pypControls,&PyList_Type))
        throw WrongTypeException("The parameter \"pControls\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pypControls) : PyList_Size(pypControls));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pypControls, i) : PyList_GetItem(pypControls, i));
        XBMCAddon::xbmcgui::Control * entry1;
        entry1 = (XBMCAddon::xbmcgui::Control *)retrieveApiInstance(pyentry1,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","addControls");
        pControls.push_back(entry1);
      }
    }
 

      ((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"addControls","XBMCAddon::xbmcgui::Window"))-> addControls(  pControls  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addControls\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addControls\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_Window_getControl__doc__,
               "getControl(self, int controlId)--Get's the control from this window.\n"
"\n"
"Throws: Exception, ifControl doesn't exist\n"
"\n"
"controlId doesn't have to be a python control, it can be a control id from a xbmc window too (you can find id's in the xml files\n"
"\n"
"Note, not python controls are not completely usable yet You can only use theControl functions\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Window_getControl (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "iControlId",
          NULL};
         
    int  iControlId ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &iControlId
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::Control * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::Control *)((XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"getControl","XBMCAddon::xbmcgui::Window"))-> getControl(  iControlId  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getControl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getControl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowDialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    XBMCAddon::xbmcgui::WindowDialog * apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowDialog *)(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_WindowDialog_Director() : new XBMCAddon::xbmcgui::WindowDialog(  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowDialog\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_WindowDialog_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    std::string  xmlFilename ;
    PyObject* pyxmlFilename = NULL;         
    std::string  scriptPath ;
    PyObject* pyscriptPath = NULL;         
    std::string  defaultSkin  = "Default";
    PyObject* pydefaultSkin = NULL;         
    std::string  defaultRes  = "720p";
    PyObject* pydefaultRes = NULL;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"OO|OO",
       
         &pyxmlFilename,
         &pyscriptPath,
         &pydefaultSkin,
         &pydefaultRes
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::WindowXML * apiResult;
    try
    {
      if (pyxmlFilename) PyXBMCGetUnicodeString(xmlFilename,pyxmlFilename,false,"xmlFilename","WindowXML"); 
      if (pyscriptPath) PyXBMCGetUnicodeString(scriptPath,pyscriptPath,false,"scriptPath","WindowXML"); 
      if (pydefaultSkin) PyXBMCGetUnicodeString(defaultSkin,pydefaultSkin,false,"defaultSkin","WindowXML"); 
      if (pydefaultRes) PyXBMCGetUnicodeString(defaultRes,pydefaultRes,false,"defaultRes","WindowXML"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowXML *)(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_WindowXML_Director( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) : new XBMCAddon::xbmcgui::WindowXML(  xmlFilename,  scriptPath,  defaultSkin,  defaultRes  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXML\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXML\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_WindowXML_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_addItem__doc__,
               "addItem(item[, position])--Add a new item to thisWindow List .\n"
"\n"
"\n"
"    - item : string, unicode orListItem - item to add.\n"
"    - position : [opt] integer - position of item to add. (NO Int = Adds to bottom,0 adds to top, 1 adds to one below from top,-1 adds to one above from bottom etc etc )\n"
"        - If integer positions are greater than list size, negative positions will add to top of list, positive positions will add to bottom of list\n"
"\n"
"\n"
"\n"
"example:\n"
"        - self.addItem('Reboot XBMC', 0)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "item",
          "position",
          NULL};
         
    Alternative< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const * >  item ;
    PyObject* pyitem = NULL;         
    int  position  = INT_MAX;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"O|i",
       (char**)keywords,
         &pyitem,
         &position
       ))
    {
      return NULL;
    }


    try
    {
      

    {
      // we need to check the parameter type and see if it matches
      PyObject *pyentry_1 = pyitem;
      try
      {
        std::string  entry0_1;
        if (pyentry_1) PyXBMCGetUnicodeString(entry0_1,pyentry_1,false,"entry0_1","addItem");
        item.former() = entry0_1;
      }
      catch (XBMCAddon::WrongTypeException wte)
      {
        try
        {
          XBMCAddon::xbmcgui::ListItem * entry1_1;
          entry1_1 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry_1,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::","addItem");
          item.later() = entry1_1;
        }
        catch (XBMCAddon::WrongTypeException wte2)
        {
          throw XBMCAddon::WrongTypeException("Failed to convert to input type to either a " 
                                              "std::string or a "
                                              "p.XBMCAddon::xbmcgui::ListItem" );
        }
      }
    }

      
 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"addItem","XBMCAddon::xbmcgui::WindowXML"))-> addItem(  item,  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"addItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"addItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_removeItem__doc__,
               "removeItem(position)--Removes a specified item based on position, from theWindow List .\n"
"\n"
"position : integer - position of item to remove.\n"
"\n"
"example:\n"
"\n"
"    - self.removeItem(5)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_removeItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"removeItem","XBMCAddon::xbmcgui::WindowXML"))-> removeItem(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"removeItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"removeItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition__doc__,
               "getCurrentListPosition() --Gets the current position in theWindow List .\n"
"\n"
"example:\n"
"\n"
"    - pos = self.getCurrentListPosition()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getCurrentListPosition","XBMCAddon::xbmcgui::WindowXML"))-> getCurrentListPosition(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getCurrentListPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getCurrentListPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition__doc__,
               "setCurrentListPosition(position)--Set the current position in theWindow List .\n"
"\n"
"position : integer - position of item to set.\n"
"\n"
"example:\n"
"\n"
"    - self.setCurrentListPosition(5)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }


    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"setCurrentListPosition","XBMCAddon::xbmcgui::WindowXML"))-> setCurrentListPosition(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setCurrentListPosition\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setCurrentListPosition\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_getListItem__doc__,
               "getListItem(position)--Returns a givenListItem in thisWindow List .\n"
"\n"
"position : integer - position of item to return.\n"
"\n"
"example:\n"
"\n"
"    - listitem = self.getListItem(6)\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListItem (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "position",
          NULL};
         
    int  position ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i",
       (char**)keywords,
         &position
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::ListItem * apiResult;
    try
    {

      apiResult = (XBMCAddon::xbmcgui::ListItem *)((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getListItem","XBMCAddon::xbmcgui::WindowXML"))-> getListItem(  position  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,true);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_getListSize__doc__,
               "getListSize() --Returns the number of items in thisWindow List .\n"
"\n"
"example:\n"
"\n"
"    - listSize = self.getListSize()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListSize (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
    int  apiResult;
    try
    {

      apiResult = (int )((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"getListSize","XBMCAddon::xbmcgui::WindowXML"))-> getListSize(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"getListSize\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"getListSize\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"i", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_clearList__doc__,
               "clearList() --Clear theWindow List .\n"
"\n"
"example:\n"
"\n"
"    - self.clearList()\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_clearList (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    try
    {

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"clearList","XBMCAddon::xbmcgui::WindowXML"))-> clearList(  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"clearList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"clearList\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML_setProperty__doc__,
               "setProperty(key, value)--Sets a container property, similar to an infolabel.\n"
"\n"
"key : string - property name.\n"
"value : string or unicode - value of property.\n"
"\n"
"*Note, Key is NOT case sensitive. You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"\n"
"example:\n"
"\n"
"    - self.setProperty('Category', 'Newest')\n");

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXML_setProperty (PyHolder* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "strProperty",
          "strValue",
          NULL};
         
    std::string  strProperty ;
    PyObject* pystrProperty = NULL;         
    std::string  strValue ;
    PyObject* pystrValue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"OO",
       (char**)keywords,
         &pystrProperty,
         &pystrValue
       ))
    {
      return NULL;
    }


    try
    {
      if (pystrProperty) PyXBMCGetUnicodeString(strProperty,pystrProperty,false,"strProperty","setProperty"); 
      if (pystrValue) PyXBMCGetUnicodeString(strValue,pystrValue,false,"strValue","setProperty"); 

      ((XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"setProperty","XBMCAddon::xbmcgui::WindowXML"))-> setProperty(  strProperty,  strValue  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_New (PyTypeObject* pytype  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;
         
    std::string  xmlFilename ;
    PyObject* pyxmlFilename = NULL;         
    std::string  scriptPath ;
    PyObject* pyscriptPath = NULL;         
    std::string  defaultSkin  = "Default";
    PyObject* pydefaultSkin = NULL;         
    std::string  defaultRes  = "720p";
    PyObject* pydefaultRes = NULL;
    if (!PyArg_ParseTuple(
       args,
       
       (char*)"OO|OO",
       
         &pyxmlFilename,
         &pyscriptPath,
         &pydefaultSkin,
         &pydefaultRes
       ))
    {
      return NULL;
    }

    XBMCAddon::xbmcgui::WindowXMLDialog * apiResult;
    try
    {
      if (pyxmlFilename) PyXBMCGetUnicodeString(xmlFilename,pyxmlFilename,false,"xmlFilename","WindowXMLDialog"); 
      if (pyscriptPath) PyXBMCGetUnicodeString(scriptPath,pyscriptPath,false,"scriptPath","WindowXMLDialog"); 
      if (pydefaultSkin) PyXBMCGetUnicodeString(defaultSkin,pydefaultSkin,false,"defaultSkin","WindowXMLDialog"); 
      if (pydefaultRes) PyXBMCGetUnicodeString(defaultRes,pydefaultRes,false,"defaultRes","WindowXMLDialog"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (XBMCAddon::xbmcgui::WindowXMLDialog *)(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType) != pytype) ? new XBMCAddon_xbmcgui_WindowXMLDialog_Director( xmlFilename,  scriptPath,  defaultSkin,  defaultRes ) : new XBMCAddon::xbmcgui::WindowXMLDialog(  xmlFilename,  scriptPath,  defaultSkin,  defaultRes  );
      prepareForReturn(apiResult);
    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXMLDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"new XBMCAddon::xbmcgui::WindowXMLDialog\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = makePythonInstance(apiResult,pytype,false);
    if (&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType) != pytype) 
      ((XBMCAddon_xbmcgui_WindowXMLDialog_Director*)apiResult)->setPyObjectForDirector(result);

    return result; 
  } 

  static void xbmcgui_XBMCAddon_xbmcgui_ListItem_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ListItem* theObj = (XBMCAddon::xbmcgui::ListItem*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ListItem_Type,"~XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcgui::ListItem");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ListItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ListItem\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Control_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Control* theObj = (XBMCAddon::xbmcgui::Control*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Control_Type,"~XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::Control");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Control\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Control\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlSpin_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlSpin* theObj = (XBMCAddon::xbmcgui::ControlSpin*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSpin_Type,"~XBMCAddon::xbmcgui::ControlSpin","XBMCAddon::xbmcgui::ControlSpin");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSpin\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSpin\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlLabel_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlLabel* theObj = (XBMCAddon::xbmcgui::ControlLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlLabel_Type,"~XBMCAddon::xbmcgui::ControlLabel","XBMCAddon::xbmcgui::ControlLabel");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlLabel\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlEdit_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlEdit* theObj = (XBMCAddon::xbmcgui::ControlEdit*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlEdit_Type,"~XBMCAddon::xbmcgui::ControlEdit","XBMCAddon::xbmcgui::ControlEdit");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlEdit\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlEdit\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlList_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlList* theObj = (XBMCAddon::xbmcgui::ControlList*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlList_Type,"~XBMCAddon::xbmcgui::ControlList","XBMCAddon::xbmcgui::ControlList");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlList\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlList\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlFadeLabel* theObj = (XBMCAddon::xbmcgui::ControlFadeLabel*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type,"~XBMCAddon::xbmcgui::ControlFadeLabel","XBMCAddon::xbmcgui::ControlFadeLabel");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlFadeLabel\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlFadeLabel\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlTextBox* theObj = (XBMCAddon::xbmcgui::ControlTextBox*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlTextBox_Type,"~XBMCAddon::xbmcgui::ControlTextBox","XBMCAddon::xbmcgui::ControlTextBox");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlTextBox\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlTextBox\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlImage_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlImage* theObj = (XBMCAddon::xbmcgui::ControlImage*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlImage_Type,"~XBMCAddon::xbmcgui::ControlImage","XBMCAddon::xbmcgui::ControlImage");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlImage\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlImage\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlProgress_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlProgress* theObj = (XBMCAddon::xbmcgui::ControlProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlProgress_Type,"~XBMCAddon::xbmcgui::ControlProgress","XBMCAddon::xbmcgui::ControlProgress");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlProgress\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlButton_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlButton* theObj = (XBMCAddon::xbmcgui::ControlButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlButton_Type,"~XBMCAddon::xbmcgui::ControlButton","XBMCAddon::xbmcgui::ControlButton");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlButton\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlCheckMark* theObj = (XBMCAddon::xbmcgui::ControlCheckMark*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlCheckMark_Type,"~XBMCAddon::xbmcgui::ControlCheckMark","XBMCAddon::xbmcgui::ControlCheckMark");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlCheckMark\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlCheckMark\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlGroup_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlGroup* theObj = (XBMCAddon::xbmcgui::ControlGroup*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlGroup_Type,"~XBMCAddon::xbmcgui::ControlGroup","XBMCAddon::xbmcgui::ControlGroup");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlGroup\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlGroup\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlRadioButton* theObj = (XBMCAddon::xbmcgui::ControlRadioButton*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlRadioButton_Type,"~XBMCAddon::xbmcgui::ControlRadioButton","XBMCAddon::xbmcgui::ControlRadioButton");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlRadioButton\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlRadioButton\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_ControlSlider_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::ControlSlider* theObj = (XBMCAddon::xbmcgui::ControlSlider*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_ControlSlider_Type,"~XBMCAddon::xbmcgui::ControlSlider","XBMCAddon::xbmcgui::ControlSlider");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSlider\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::ControlSlider\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Dialog_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Dialog* theObj = (XBMCAddon::xbmcgui::Dialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Dialog_Type,"~XBMCAddon::xbmcgui::Dialog","XBMCAddon::xbmcgui::Dialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Dialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Dialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_DialogProgress_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::DialogProgress* theObj = (XBMCAddon::xbmcgui::DialogProgress*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgress_Type,"~XBMCAddon::xbmcgui::DialogProgress","XBMCAddon::xbmcgui::DialogProgress");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgress\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgress\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::DialogProgressBG* theObj = (XBMCAddon::xbmcgui::DialogProgressBG*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_DialogProgressBG_Type,"~XBMCAddon::xbmcgui::DialogProgressBG","XBMCAddon::xbmcgui::DialogProgressBG");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgressBG\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::DialogProgressBG\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Action_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Action* theObj = (XBMCAddon::xbmcgui::Action*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Action_Type,"~XBMCAddon::xbmcgui::Action","XBMCAddon::xbmcgui::Action");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Action\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Action\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_Window_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::Window* theObj = (XBMCAddon::xbmcgui::Window*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_Window_Type,"~XBMCAddon::xbmcgui::Window","XBMCAddon::xbmcgui::Window");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Window\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::Window\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowDialog_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowDialog* theObj = (XBMCAddon::xbmcgui::WindowDialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowDialog_Type,"~XBMCAddon::xbmcgui::WindowDialog","XBMCAddon::xbmcgui::WindowDialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowDialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowXML_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowXML* theObj = (XBMCAddon::xbmcgui::WindowXML*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXML_Type,"~XBMCAddon::xbmcgui::WindowXML","XBMCAddon::xbmcgui::WindowXML");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXML\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXML\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  static void xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_Dealloc (PyHolder* self  )
  {
    XBMC_TRACE;

    try
    {


      XBMCAddon::xbmcgui::WindowXMLDialog* theObj = (XBMCAddon::xbmcgui::WindowXMLDialog*)retrieveApiInstance((PyObject*)self,&TyXBMCAddon_xbmcgui_WindowXMLDialog_Type,"~XBMCAddon::xbmcgui::WindowXMLDialog","XBMCAddon::xbmcgui::WindowXMLDialog");
      cleanForDealloc(theObj);

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXMLDialog\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcgui::WindowXMLDialog\""); 
    }

    self->ob_type->tp_free((PyObject*)self); 
    
  } 
  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ListItem
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ListItem_methods[] = { 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getLabel__doc__ }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getLabel2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getLabel2__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setLabel__doc__ }, 
    {(char*)"setLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setLabel2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setLabel2__doc__ }, 
    {(char*)"setIconImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setIconImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setIconImage__doc__ }, 
    {(char*)"setThumbnailImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setThumbnailImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setThumbnailImage__doc__ }, 
    {(char*)"setArt", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setArt, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setArt__doc__ }, 
    {(char*)"select", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_select, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_select__doc__ }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_isSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_isSelected__doc__ }, 
    {(char*)"setInfo", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setInfo, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setInfo__doc__ }, 
    {(char*)"addStreamInfo", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_addStreamInfo, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_addStreamInfo__doc__ }, 
    {(char*)"addContextMenuItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_addContextMenuItems, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_addContextMenuItems__doc__ }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setProperty__doc__ }, 
    {(char*)"getProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getProperty__doc__ }, 
    {(char*)"setPath", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setPath, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setPath__doc__ }, 
    {(char*)"setMimeType", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_setMimeType, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_setMimeType__doc__ }, 
    {(char*)"getdescription", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getdescription, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getdescription__doc__ }, 
    {(char*)"getduration", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getduration, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getduration__doc__ }, 
    {(char*)"getfilename", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ListItem_getfilename, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ListItem_getfilename__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ListItem_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ListItem_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ListItem";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ListItem_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ListItem_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ListItem_New;

    TyXBMCAddon_xbmcgui_ListItem_Type.swigType="p.XBMCAddon::xbmcgui::ListItem";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ListItem_Type);

  }
  //=========================================================================

  static int xbmcgui_XBMCAddon_xbmcgui_Control_cmp(PyObject* obj1, PyObject* obj2)
  {
    return PythonCompare<XBMCAddon::xbmcgui::Control>::compare(obj1,obj2,"p.XBMCAddon::xbmcgui::Control","XBMCAddon::xbmcgui::","compare on XBMCAddon::xbmcgui::Control");
  }

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Control
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Control_methods[] = { 
    {(char*)"canAcceptMessages", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_canAcceptMessages, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getId__doc__ }, 
    {(char*)"getPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getPosition__doc__ }, 
    {(char*)"getX", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getX, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getY", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getY, METH_VARARGS|METH_KEYWORDS, NULL }, 
    {(char*)"getHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getHeight__doc__ }, 
    {(char*)"getWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_getWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_getWidth__doc__ }, 
    {(char*)"setEnabled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setEnabled, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setEnabled__doc__ }, 
    {(char*)"setVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setVisible, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setVisible__doc__ }, 
    {(char*)"setVisibleCondition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setVisibleCondition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setVisibleCondition__doc__ }, 
    {(char*)"setEnableCondition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setEnableCondition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setEnableCondition__doc__ }, 
    {(char*)"setAnimations", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setAnimations, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setAnimations__doc__ }, 
    {(char*)"setPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setPosition__doc__ }, 
    {(char*)"setWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setWidth__doc__ }, 
    {(char*)"setHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setHeight__doc__ }, 
    {(char*)"setNavigation", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_setNavigation, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_setNavigation__doc__ }, 
    {(char*)"controlUp", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlUp, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlUp__doc__ }, 
    {(char*)"controlDown", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlDown, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlDown__doc__ }, 
    {(char*)"controlLeft", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlLeft, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlLeft__doc__ }, 
    {(char*)"controlRight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Control_controlRight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Control_controlRight__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Control_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Control__doc__,
                 "Control class.\n"
"\n"
"Base class for all controls.\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Control_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Control";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Control_Dealloc; 
    pythonType.tp_compare=xbmcgui_XBMCAddon_xbmcgui_Control_cmp;

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_Control__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Control_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = NULL;

    TyXBMCAddon_xbmcgui_Control_Type.swigType="p.XBMCAddon::xbmcgui::Control";
  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlSpin
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlSpin_methods[] = { 
    {(char*)"setTextures", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSpin_setTextures, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlSpin_setTextures__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlSpin_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSpin__doc__,
                 "ControlSpin class.\n"
"\n"
"\n"
"    - Not working yet -.\n"
"\n"
"\n"
"you can't create this object, it is returned by objects likeControlTextBox andControlList .\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlSpin";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlSpin_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlSpin__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlSpin_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = NULL;

    TyXBMCAddon_xbmcgui_ControlSpin_Type.swigType="p.XBMCAddon::xbmcgui::ControlSpin";
    TyXBMCAddon_xbmcgui_ControlSpin_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlLabel
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlLabel_methods[] = { 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlLabel_getLabel__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlLabel_setLabel__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlLabel_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlLabel__doc__,
                 "ControlLabel class.\n"
"\n"
"ControlLabel (x, y, width, height, label[, font, textColor, disabledColor, alignment, hasPath, angle])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"label : string or unicode - text string.\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled label's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled label's label. (e.g. '0xFFFF3300')\n"
"alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"hasPath : [opt] bool - True=stores a path / False=no path.\n"
"angle : [opt] integer - angle of control. (+ rotates CCW, - rotates C\n"
"example:\n"
"    - self.label =xbmcgui.ControlLabel (100, 250, 125, 75, 'Status', angle=45)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlLabel";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlLabel_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlLabel__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlLabel_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlLabel_New;

    TyXBMCAddon_xbmcgui_ControlLabel_Type.swigType="p.XBMCAddon::xbmcgui::ControlLabel";
    TyXBMCAddon_xbmcgui_ControlLabel_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlLabel_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlEdit
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlEdit_methods[] = { 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_setLabel__doc__ }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_getLabel__doc__ }, 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_setText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_setText__doc__ }, 
    {(char*)"getText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_getText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlEdit_getText__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlEdit_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlEdit__doc__,
                 "ControlEdit class.\n"
"\n"
"ControlEdit (x, y, width, height, label[, font, textColor, disabledColor, alignment, focusTexture, noFocusTexture])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"label : string or unicode - text string.\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled label's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled label's label. (e.g. '0xFFFF3300')\n"
"alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"focusTexture : [opt] string - filename for focus texture.\n"
"noFocusTexture : [opt] string - filename for no focus texture.\n"
"isPassword : [opt] bool - if true, mask text value.\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"example:\n"
"    - self.edit =xbmcgui.ControlEdit (100, 250, 125, 75, 'Status')\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlEdit";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlEdit_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlEdit__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlEdit_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlEdit_New;

    TyXBMCAddon_xbmcgui_ControlEdit_Type.swigType="p.XBMCAddon::xbmcgui::ControlEdit";
    TyXBMCAddon_xbmcgui_ControlEdit_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlEdit_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlList
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlList_methods[] = { 
    {(char*)"addItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_addItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_addItem__doc__ }, 
    {(char*)"addItems", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_addItems, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_addItems__doc__ }, 
    {(char*)"selectItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_selectItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_selectItem__doc__ }, 
    {(char*)"removeItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_removeItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_removeItem__doc__ }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_reset, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_reset__doc__ }, 
    {(char*)"getSpinControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpinControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSpinControl__doc__ }, 
    {(char*)"getSelectedPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSelectedPosition__doc__ }, 
    {(char*)"getSelectedItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSelectedItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSelectedItem__doc__ }, 
    {(char*)"setImageDimensions", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setImageDimensions, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setImageDimensions__doc__ }, 
    {(char*)"setItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setItemHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setItemHeight__doc__ }, 
    {(char*)"setSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setSpace, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setSpace__doc__ }, 
    {(char*)"setPageControlVisible", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setPageControlVisible, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setPageControlVisible__doc__ }, 
    {(char*)"size", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_size, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_size__doc__ }, 
    {(char*)"getItemHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getItemHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getItemHeight__doc__ }, 
    {(char*)"getSpace", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getSpace, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getSpace__doc__ }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_getListItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_getListItem__doc__ }, 
    {(char*)"setStaticContent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlList_setStaticContent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlList_setStaticContent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlList_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlList__doc__,
                 "ControlList class.\n"
"\n"
"ControlList (x, y, width, height[, font, textColor, buttonTexture, buttonFocusTexture, selectedColor, imageWidth, imageHeight, itemTextXOffset, itemTextYOffset, itemHeight, space, alignmentY])n\"//, shadowColor])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"font : [opt] string - font used for items label. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of items label. (e.g. '0xFFFFFFFF')\n"
"buttonTexture : [opt] string - filename for focus texture.\n"
"buttonFocusTexture : [opt] string - filename for no focus texture.\n"
"selectedColor : [opt] integer - x offset of label.\n"
"imageWidth : [opt] integer - width of items icon or thumbnail.\n"
"imageHeight : [opt] integer - height of items icon or thumbnail.\n"
"itemTextXOffset : [opt] integer - x offset of items label.\n"
"itemTextYOffset : [opt] integer - y offset of items label.\n"
"itemHeight : [opt] integer - height of items.\n"
"space : [opt] integer - space between items.\n"
"alignmentY : [opt] integer - Y-axis alignment of items label - *Note, see xbfont.h\n"
"//\"shadowColor : [opt] hexstring - color of items label's shadow. (e.g. '0xFF000000')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"example:\n"
"    - self.cList =xbmcgui.ControlList (100, 250, 200, 250, 'font14', space=5)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlList_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlList";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlList_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlList__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlList_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlList_New;

    TyXBMCAddon_xbmcgui_ControlList_Type.swigType="p.XBMCAddon::xbmcgui::ControlList";
    TyXBMCAddon_xbmcgui_ControlList_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlList_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlFadeLabel
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlFadeLabel_methods[] = { 
    {(char*)"addLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_addLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlFadeLabel_addLabel__doc__ }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_reset, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlFadeLabel_reset__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlFadeLabel_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlFadeLabel__doc__,
                 "ControlFadeLabel class.\n"
"Control that scroll's labl\n"
"\n"
"ControlFadeLabel(x, y, width, height[, font, textColor, alignment])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of fadelabel's labels. (e.g. '0xFFFFFFFF')\n"
"alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.fadelabel =xbmcgui.ControlFadeLabel (100, 250, 200, 50, textColor='0xFFFFFFFF')\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlFadeLabel";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlFadeLabel__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlFadeLabel_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlFadeLabel_New;

    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.swigType="p.XBMCAddon::xbmcgui::ControlFadeLabel";
    TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlFadeLabel_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlTextBox
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlTextBox_methods[] = { 
    {(char*)"setText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_setText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_setText__doc__ }, 
    {(char*)"getText", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_getText, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_getText__doc__ }, 
    {(char*)"reset", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_reset, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_reset__doc__ }, 
    {(char*)"scroll", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_scroll, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlTextBox_scroll__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlTextBox_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlTextBox__doc__,
                 "ControlTextBox class.\n"
"\n"
"ControlTextBox(x, y, width, height[, font, textColor])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"font : [opt] string - font used for text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of textbox's text. (e.g. '0xFFFFFFFF')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.textbox =xbmcgui.ControlTextBox (100, 250, 300, 300, textColor='0xFFFFFFFF')\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlTextBox";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlTextBox__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlTextBox_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlTextBox_New;

    TyXBMCAddon_xbmcgui_ControlTextBox_Type.swigType="p.XBMCAddon::xbmcgui::ControlTextBox";
    TyXBMCAddon_xbmcgui_ControlTextBox_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlTextBox_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlImage
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlImage_methods[] = { 
    {(char*)"setImage", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlImage_setImage, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlImage_setImage__doc__ }, 
    {(char*)"setColorDiffuse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlImage_setColorDiffuse, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlImage_setColorDiffuse__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlImage_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlImage__doc__,
                 "ControlImage class.\n"
"\n"
"ControlImage(x, y, width, height, filename[, aspectRatio, colorDiffuse])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"filename : string - image filename.\n"
"aspectRatio : [opt] integer - (values 0 = stretch (default), 1 = scale up (crops), 2 = scale down (black bar\n"
"colorDiffuse : hexString - (example, '0xC0FF0000' (red tint))\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.image =xbmcgui.ControlImage (100, 250, 125, 75, aspectRatio=2)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlImage";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlImage_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlImage__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlImage_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlImage_New;

    TyXBMCAddon_xbmcgui_ControlImage_Type.swigType="p.XBMCAddon::xbmcgui::ControlImage";
    TyXBMCAddon_xbmcgui_ControlImage_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlImage_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlProgress
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlProgress_methods[] = { 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_setPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlProgress_setPercent__doc__ }, 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_getPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlProgress_getPercent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlProgress_Type()
  {


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlProgress";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlProgress_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = NULL;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlProgress_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlProgress_New;

    TyXBMCAddon_xbmcgui_ControlProgress_Type.swigType="p.XBMCAddon::xbmcgui::ControlProgress";
    TyXBMCAddon_xbmcgui_ControlProgress_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlProgress_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlButton
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlButton_methods[] = { 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_setLabel__doc__ }, 
    {(char*)"setDisabledColor", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_setDisabledColor, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_setDisabledColor__doc__ }, 
    {(char*)"getLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_getLabel__doc__ }, 
    {(char*)"getLabel2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlButton_getLabel2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlButton_getLabel2__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlButton_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlButton__doc__,
                 "ControlButton class.\n"
"\n"
"ControlButton (x, y, width, height, label[, focusTexture, noFocusTexture, textOffsetX, textOffsetY, alignment, font, textColor, disabledColor, angle, shadowColor, focusedColor])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"label : string or unicode - text string.\n"
"focusTexture : [opt] string - filename for focus texture.\n"
"noFocusTexture : [opt] string - filename for no focus texture.\n"
"textOffsetX : [opt] integer - x offset of label.\n"
"textOffsetY : [opt] integer - y offset of label.\n"
"alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled button's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled button's label. (e.g. '0xFFFF3300')\n"
"angle : [opt] integer - angle of control. (+ rotates CCW, - rotates CW)\n"
"shadowColor : [opt] hexstring - color of button's label's shadow. (e.g. '0xFF000000')\n"
"focusedColor : [opt] hexstring - color of focused button's label. (e.g. '0xFF00FFFF')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.button =xbmcgui.ControlButton (100, 250, 200, 50, 'Status', font='font14')\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlButton";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlButton_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlButton__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlButton_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlButton_New;

    TyXBMCAddon_xbmcgui_ControlButton_Type.swigType="p.XBMCAddon::xbmcgui::ControlButton";
    TyXBMCAddon_xbmcgui_ControlButton_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlButton_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlCheckMark
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlCheckMark_methods[] = { 
    {(char*)"getSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_getSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_getSelected__doc__ }, 
    {(char*)"setSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_setSelected__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_setLabel__doc__ }, 
    {(char*)"setDisabledColor", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlCheckMark_setDisabledColor__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlCheckMark_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlCheckMark__doc__,
                 "ControlCheckMark class.\n"
"\n"
"ControlCheckMark (x, y, width, height, label[, focusTexture, noFocusTexture, checkWidth, checkHeight, alignment, font, textColor, disabledColor])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"label : string or unicode - text string.\n"
"focusTexture : [opt] string - filename for focus texture.\n"
"noFocusTexture : [opt] string - filename for no focus texture.\n"
"checkWidth : [opt] integer - width of checkmark.\n"
"checkHeight : [opt] integer - height of checkmark.\n"
"alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled checkmark's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.checkmark =xbmcgui.ControlCheckMark (100, 250, 200, 50, 'Status', font='font14')\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlCheckMark_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlCheckMark";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlCheckMark__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlCheckMark_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlCheckMark_New;

    TyXBMCAddon_xbmcgui_ControlCheckMark_Type.swigType="p.XBMCAddon::xbmcgui::ControlCheckMark";
    TyXBMCAddon_xbmcgui_ControlCheckMark_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlCheckMark_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlGroup
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlGroup_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlGroup_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlGroup__doc__,
                 "ControlGroup class.\n"
"\n"
"ControlGroup (x, y, width, height\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control. example:\n"
"    - self.group = xbmcgui.ControlGroup(100, 250, 125, 75)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlGroup";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlGroup_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlGroup__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlGroup_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlGroup_New;

    TyXBMCAddon_xbmcgui_ControlGroup_Type.swigType="p.XBMCAddon::xbmcgui::ControlGroup";
    TyXBMCAddon_xbmcgui_ControlGroup_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlGroup_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlRadioButton
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlRadioButton_methods[] = { 
    {(char*)"setSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_setSelected__doc__ }, 
    {(char*)"isSelected", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_isSelected, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_isSelected__doc__ }, 
    {(char*)"setLabel", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setLabel, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_setLabel__doc__ }, 
    {(char*)"setRadioDimension", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlRadioButton_setRadioDimension__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlRadioButton_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlRadioButton__doc__,
                 "ControlRadioButton class.\n"
"\n"
"ControlRadioButton (x, y, width, height, label[, focusOnTexture, noFocusOnTexture,\n"
"focusOffTexture, noFocusOffTexture, focusTexture, noFocusTexture,\n"
"textOffsetX, textOffsetY, alignment, font, textColor, disabledColor])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"label : string or unicode - text string.\n"
"focusOnTexture : [opt] string - filename for radio ON focused texture.\n"
"noFocusOnTexture : [opt] string - filename for radio ON not focused texture.\n"
"focusOfTexture : [opt] string - filename for radio OFF focused texture.\n"
"noFocusOffTexture : [opt] string - filename for radio OFF not focused texture.\n"
"focusTexture : [opt] string - filename for radio ON texture (deprecated, use focusOnTexture and noFocusOnTexture).\n"
"noFocusTexture : [opt] string - filename for radio OFF texture (deprecated, use focusOffTexture and noFocusOffTexture).\n"
"textOffsetX : [opt] integer - horizontal text offset\n"
"textOffsetY : [opt] integer - vertical text offset\n"
"alignment : [opt] integer - alignment of label - *Note, see xbfont.h\n"
"font : [opt] string - font used for label text. (e.g. 'font13')\n"
"textColor : [opt] hexstring - color of enabled checkmark's label. (e.g. '0xFFFFFFFF')\n"
"disabledColor : [opt] hexstring - color of disabled checkmark's label. (e.g. '0xFFFF3300')\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.radiobutton =xbmcgui.ControlRadioButton (100, 250, 200, 50, 'Enable', font='font14')\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlRadioButton";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlRadioButton__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlRadioButton_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlRadioButton_New;

    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.swigType="p.XBMCAddon::xbmcgui::ControlRadioButton";
    TyXBMCAddon_xbmcgui_ControlRadioButton_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlRadioButton_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::ControlSlider
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_ControlSlider_methods[] = { 
    {(char*)"getPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_getPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlSlider_getPercent__doc__ }, 
    {(char*)"setPercent", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_setPercent, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_ControlSlider_setPercent__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_ControlSlider_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_ControlSlider__doc__,
                 "ControlSlider class.\n"
"\n"
"ControlSlider(x, y, width, height[, textureback, texture, texturefocus])\n"
"\n"
"x : integer - x coordinate of control.\n"
"y : integer - y coordinate of control.\n"
"width : integer - width of control.\n"
"height : integer - height of control.\n"
"textureback : [opt] string - image filename.\n"
"texture : [opt] string - image filename.\n"
"texturefocus : [opt] string - image filename.n\"\n"
"\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"After you create the control, you need to add it to the window with addControl().\n"
"\n"
"example:\n"
"    - self.slider = xbmcgui.ControlSlider(100, 250, 350, 40)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.ControlSlider";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_ControlSlider_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_ControlSlider__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_ControlSlider_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Control_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_ControlSlider_New;

    TyXBMCAddon_xbmcgui_ControlSlider_Type.swigType="p.XBMCAddon::xbmcgui::ControlSlider";
    TyXBMCAddon_xbmcgui_ControlSlider_Type.parentType=&TyXBMCAddon_xbmcgui_Control_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_ControlSlider_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Dialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Dialog_methods[] = { 
    {(char*)"yesno", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_yesno, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_yesno__doc__ }, 
    {(char*)"select", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_select, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_select__doc__ }, 
    {(char*)"ok", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_ok, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_ok__doc__ }, 
    {(char*)"browse", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browse, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_browse__doc__ }, 
    {(char*)"browseSingle", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browseSingle, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_browseSingle__doc__ }, 
    {(char*)"browseMultiple", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_browseMultiple, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_browseMultiple__doc__ }, 
    {(char*)"numeric", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_numeric, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_numeric__doc__ }, 
    {(char*)"notification", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_notification, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_notification__doc__ }, 
    {(char*)"input", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Dialog_input, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Dialog_input__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Dialog_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Dialog__doc__,
                 "Dialog class (Duh!)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Dialog_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Dialog";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Dialog_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_Dialog__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Dialog_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_Dialog_New;

    TyXBMCAddon_xbmcgui_Dialog_Type.swigType="p.XBMCAddon::xbmcgui::Dialog";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_Dialog_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::DialogProgress
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_DialogProgress_methods[] = { 
    {(char*)"create", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_create, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_create__doc__ }, 
    {(char*)"update", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_update, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_update__doc__ }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_close, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_close__doc__ }, 
    {(char*)"iscanceled", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_iscanceled, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgress_iscanceled__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_DialogProgress_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgress__doc__,
                 "DialogProgress class (Duh!)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.DialogProgress";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_DialogProgress_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_DialogProgress__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_DialogProgress_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_DialogProgress_New;

    TyXBMCAddon_xbmcgui_DialogProgress_Type.swigType="p.XBMCAddon::xbmcgui::DialogProgress";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_DialogProgress_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::DialogProgressBG
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_DialogProgressBG_methods[] = { 
    {(char*)"create", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_create, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgressBG_create__doc__ }, 
    {(char*)"update", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_update, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgressBG_update__doc__ }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_close, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgressBG_close__doc__ }, 
    {(char*)"isFinished", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_isFinished, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_DialogProgressBG_isFinished__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_DialogProgressBG_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_DialogProgressBG__doc__,
                 "DialogProgressBG class\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.DialogProgressBG";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_DialogProgressBG__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_DialogProgressBG_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_DialogProgressBG_New;

    TyXBMCAddon_xbmcgui_DialogProgressBG_Type.swigType="p.XBMCAddon::xbmcgui::DialogProgressBG";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_DialogProgressBG_Type);

  }
  //=========================================================================

  static PyObject* xbmcgui_XBMCAddon_xbmcgui_Action_rcmp(PyObject* obj1, PyObject *obj2, int method)
  { XBMC_TRACE;
    if (method == Py_EQ)
    {
      XBMCAddon::xbmcgui::Action* a1 = (Action*)retrieveApiInstance(obj1,&TyXBMCAddon_xbmcgui_Action_Type,"rcmp","XBMCAddon::xbmcgui::Action");
      if (PyObject_TypeCheck(obj2, &(TyXBMCAddon_xbmcgui_Action_Type.pythonType)))
      {
        // both are Action objects
        XBMCAddon::xbmcgui::Action* a2 = (Action*)retrieveApiInstance(obj2,&TyXBMCAddon_xbmcgui_Action_Type,"rcmp","XBMCAddon::xbmcgui::Action");

        if (a1->id == a2->id &&
            a1->buttonCode == a2->buttonCode &&
            a1->fAmount1 == a2->fAmount1 &&
            a1->fAmount2 == a2->fAmount2 &&
            a1->fRepeat == a2->fRepeat &&
            a1->strAction == a2->strAction)
        {
          Py_RETURN_TRUE;
        }
        else
        {
          Py_RETURN_FALSE;
        }
      }
      else
      {
        // for backwards compatability in python scripts
        PyObject* o1 = PyLong_FromLong(a1->id);
        return PyObject_RichCompare(o1, obj2, method);
      }
    }
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
  }

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Action
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Action_methods[] = { 
    {(char*)"getId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Action_getId__doc__ }, 
    {(char*)"getButtonCode", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getButtonCode, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Action_getButtonCode__doc__ }, 
    {(char*)"getAmount1", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getAmount1, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Action_getAmount1__doc__ }, 
    {(char*)"getAmount2", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Action_getAmount2, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Action_getAmount2__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Action_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Action__doc__,
                 "Action class.\n"
"\n"
"For backwards compatibility reasons the == operator is extended so that it\n"
"can compare an action with other actions and action.GetID() with numbers\n"
"    - example: (action == ACTION_MOVE_LEFT)\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Action_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Action";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Action_Dealloc; 
    pythonType.tp_richcompare=(richcmpfunc)xbmcgui_XBMCAddon_xbmcgui_Action_rcmp;

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_Action__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Action_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_Action_New;

    TyXBMCAddon_xbmcgui_Action_Type.swigType="p.XBMCAddon::xbmcgui::Action";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_Action_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::Window
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_Window_methods[] = { 
    {(char*)"onAction", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onAction, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onAction__doc__ }, 
    {(char*)"onControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onControl__doc__ }, 
    {(char*)"onClick", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onClick, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onClick__doc__ }, 
    {(char*)"onDoubleClick", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onDoubleClick, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onDoubleClick__doc__ }, 
    {(char*)"onFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onFocus, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onFocus__doc__ }, 
    {(char*)"onInit", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_onInit, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_onInit__doc__ }, 
    {(char*)"show", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_show, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_show__doc__ }, 
    {(char*)"setFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setFocus, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setFocus__doc__ }, 
    {(char*)"setFocusId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setFocusId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setFocusId__doc__ }, 
    {(char*)"getFocus", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getFocus, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getFocus__doc__ }, 
    {(char*)"getFocusId", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getFocusId, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getFocusId__doc__ }, 
    {(char*)"removeControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_removeControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_removeControl__doc__ }, 
    {(char*)"removeControls", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_removeControls, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_removeControls__doc__ }, 
    {(char*)"getHeight", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getHeight, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getHeight__doc__ }, 
    {(char*)"getWidth", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getWidth, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getWidth__doc__ }, 
    {(char*)"getResolution", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getResolution, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getResolution__doc__ }, 
    {(char*)"setCoordinateResolution", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setCoordinateResolution, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setCoordinateResolution__doc__ }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_setProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_setProperty__doc__ }, 
    {(char*)"getProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getProperty__doc__ }, 
    {(char*)"clearProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_clearProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_clearProperty__doc__ }, 
    {(char*)"clearProperties", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_clearProperties, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_clearProperties__doc__ }, 
    {(char*)"close", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_close, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_close__doc__ }, 
    {(char*)"doModal", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_doModal, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_doModal__doc__ }, 
    {(char*)"addControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_addControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_addControl__doc__ }, 
    {(char*)"addControls", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_addControls, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_addControls__doc__ }, 
    {(char*)"getControl", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_Window_getControl, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_Window_getControl__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_Window_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_Window__doc__,
                 "Window class.\n"
"\n"
"Window(self[, int windowId):\n"
"    - Create a newWindow to draw on.\n"
"    - Specify an id to use an existing window.\n"
"\n"
"\n"
"Throws:\n"
"    - ValueError, if supplied window Id does not exist.\n"
"    - Exception, if more then 200 windows are created.\n"
"\n"
"\n"
"Deleting this window will activate the old window that was active\n"
"and resets (not delete) all controls that are associated with this window.\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_Window_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.Window";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_Window_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_Window__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_Window_methods; 
    pythonType.tp_base = NULL;
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_Window_New;

    TyXBMCAddon_xbmcgui_Window_Type.swigType="p.XBMCAddon::xbmcgui::Window";
    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_Window_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowDialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowDialog_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowDialog_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowDialog__doc__,
                 "WindowDialog class\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.WindowDialog";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowDialog_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_WindowDialog__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_WindowDialog_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Window_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowDialog_New;

    TyXBMCAddon_xbmcgui_WindowDialog_Type.swigType="p.XBMCAddon::xbmcgui::WindowDialog";
    TyXBMCAddon_xbmcgui_WindowDialog_Type.parentType=&TyXBMCAddon_xbmcgui_Window_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_WindowDialog_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowXML
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowXML_methods[] = { 
    {(char*)"addItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_addItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_addItem__doc__ }, 
    {(char*)"removeItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_removeItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_removeItem__doc__ }, 
    {(char*)"getCurrentListPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_getCurrentListPosition__doc__ }, 
    {(char*)"setCurrentListPosition", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_setCurrentListPosition__doc__ }, 
    {(char*)"getListItem", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListItem, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_getListItem__doc__ }, 
    {(char*)"getListSize", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_getListSize, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_getListSize__doc__ }, 
    {(char*)"clearList", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_clearList, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_clearList__doc__ }, 
    {(char*)"setProperty", (PyCFunction)xbmcgui_XBMCAddon_xbmcgui_WindowXML_setProperty, METH_VARARGS|METH_KEYWORDS, XBMCAddon_xbmcgui_WindowXML_setProperty__doc__ }, 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowXML_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXML__doc__,
                 "WindowXML class.\n"
"\n"
"WindowXML(self, xmlFilename, scriptPath[, defaultSkin, defaultRes])--Create a newWindowXML script.\n"
"\n"
"xmlFilename : string - the name of the xml file to look for.\n"
"scriptPath : string - path to script. used to fallback to if the xml doesn't exist in the current skin. (eg os.getcwd())\n"
"defaultSkin : [opt] string - name of the folder in the skins path to look in for the xml. (default='Default')\n"
"defaultRes : [opt] string - default skins resolution. (default='720p')\n"
"\n"
"*Note, skin folder structure is eg(resources/skins/Default/720p)\n"
"\n"
"example:\n"
"\n"
"    - ui = GUI('script-Lyrics-main.xml', os.getcwd(), 'LCARS', 'PAL')\n"
"ui.doModal()\n"
"del ui\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.WindowXML";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowXML_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_WindowXML__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_WindowXML_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_Window_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowXML_New;

    TyXBMCAddon_xbmcgui_WindowXML_Type.swigType="p.XBMCAddon::xbmcgui::WindowXML";
    TyXBMCAddon_xbmcgui_WindowXML_Type.parentType=&TyXBMCAddon_xbmcgui_Window_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_WindowXML_Type);

  }
  //=========================================================================

  //=========================================================================
  // This section contains the initialization for the
  // Python extention for the Api class XBMCAddon::xbmcgui::WindowXMLDialog
  //=========================================================================
  // All of the methods on this class
  static PyMethodDef XBMCAddon_xbmcgui_WindowXMLDialog_methods[] = { 
    {NULL, NULL, 0, NULL}
  };



  // This method initializes the above mentioned Python Type structure
  static void initPyXBMCAddon_xbmcgui_WindowXMLDialog_Type()
  {

    PyDoc_STRVAR(XBMCAddon_xbmcgui_WindowXMLDialog__doc__,
                 "WindowXMLDialog class.\n"
"\n"
"WindowXMLDialog(self, xmlFilename, scriptPath[, defaultSkin, defaultRes])--Create a newWindowXMLDialog script.\n"
"\n"
"xmlFilename : string - the name of the xml file to look for.\n"
"scriptPath : string - path to script. used to fallback to if the xml doesn't exist in the current skin. (eg os.getcwd())\n"
"defaultSkin : [opt] string - name of the folder in the skins path to look in for the xml. (default='Default')\n"
"defaultRes : [opt] string - default skins resolution. (default='720p')\n"
"\n"
"*Note, skin folder structure is eg(resources/skins/Default/720p)\n"
"\n"
"example:\n"
"    - ui = GUI('script-Lyrics-main.xml', os.getcwd(), 'LCARS', 'PAL')\n"
"    - ui.doModal()\n"
"    - del ui\n"
                );


    PyTypeObject& pythonType = TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType;
    pythonType.tp_name = (char*)"xbmcgui.WindowXMLDialog";
    pythonType.tp_basicsize = sizeof(PyHolder);
    pythonType.tp_dealloc = (destructor)xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_Dealloc; 

    pythonType.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE;
    pythonType.tp_doc = XBMCAddon_xbmcgui_WindowXMLDialog__doc__;
    pythonType.tp_methods = XBMCAddon_xbmcgui_WindowXMLDialog_methods; 
    pythonType.tp_base = &(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType);
    pythonType.tp_new = xbmcgui_XBMCAddon_xbmcgui_WindowXMLDialog_New;

    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.swigType="p.XBMCAddon::xbmcgui::WindowXMLDialog";
    TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.parentType=&TyXBMCAddon_xbmcgui_WindowXML_Type;

    registerAddonClassTypeInformation(&TyXBMCAddon_xbmcgui_WindowXMLDialog_Type);

  }
  //=========================================================================


  static PyMethodDef xbmcgui_methods[] = { 
    {(char*)"lock", (PyCFunction)xbmcgui_lock, METH_VARARGS|METH_KEYWORDS, lock__doc__ }, 
    {(char*)"unlock", (PyCFunction)xbmcgui_unlock, METH_VARARGS|METH_KEYWORDS, unlock__doc__ }, 
    {(char*)"getCurrentWindowId", (PyCFunction)xbmcgui_getCurrentWindowId, METH_VARARGS|METH_KEYWORDS, getCurrentWindowId__doc__ }, 
    {(char*)"getCurrentWindowDialogId", (PyCFunction)xbmcgui_getCurrentWindowDialogId, METH_VARARGS|METH_KEYWORDS, getCurrentWindowDialogId__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

      initPyXBMCAddon_xbmcgui_ListItem_Type();
      initPyXBMCAddon_xbmcgui_Control_Type();
      initPyXBMCAddon_xbmcgui_ControlSpin_Type();
      initPyXBMCAddon_xbmcgui_ControlLabel_Type();
      initPyXBMCAddon_xbmcgui_ControlEdit_Type();
      initPyXBMCAddon_xbmcgui_ControlList_Type();
      initPyXBMCAddon_xbmcgui_ControlFadeLabel_Type();
      initPyXBMCAddon_xbmcgui_ControlTextBox_Type();
      initPyXBMCAddon_xbmcgui_ControlImage_Type();
      initPyXBMCAddon_xbmcgui_ControlProgress_Type();
      initPyXBMCAddon_xbmcgui_ControlButton_Type();
      initPyXBMCAddon_xbmcgui_ControlCheckMark_Type();
      initPyXBMCAddon_xbmcgui_ControlGroup_Type();
      initPyXBMCAddon_xbmcgui_ControlRadioButton_Type();
      initPyXBMCAddon_xbmcgui_ControlSlider_Type();
      initPyXBMCAddon_xbmcgui_Dialog_Type();
      initPyXBMCAddon_xbmcgui_DialogProgress_Type();
      initPyXBMCAddon_xbmcgui_DialogProgressBG_Type();
      initPyXBMCAddon_xbmcgui_Action_Type();
      initPyXBMCAddon_xbmcgui_Window_Type();
      initPyXBMCAddon_xbmcgui_WindowDialog_Type();
      initPyXBMCAddon_xbmcgui_WindowXML_Type();
      initPyXBMCAddon_xbmcgui_WindowXMLDialog_Type();
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ListItem_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Control_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlList_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlCheckMark_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Dialog_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Action_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType)) < 0)
        return;
      if (PyType_Ready(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType)) < 0)
        return;
    }
  }

  void initModule_xbmcgui()
  {
    initTypes();

    // init general xbmcgui modules
    PyObject* module;


    Py_INCREF(&(TyXBMCAddon_xbmcgui_ListItem_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Control_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlList_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlCheckMark_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Dialog_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Action_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType));
    Py_INCREF(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType));

    module = Py_InitModule((char*)"xbmcgui", xbmcgui_methods);
    if (module == NULL) return;


    PyModule_AddObject(module, (char*)"ListItem", (PyObject*)(&(TyXBMCAddon_xbmcgui_ListItem_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Control", (PyObject*)(&(TyXBMCAddon_xbmcgui_Control_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlSpin", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlSpin_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlLabel", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlLabel_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlEdit", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlEdit_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlList", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlList_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlFadeLabel", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlFadeLabel_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlTextBox", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlTextBox_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlImage", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlImage_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlProgress", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlProgress_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlButton", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlButton_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlCheckMark", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlCheckMark_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlGroup", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlGroup_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlRadioButton", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlRadioButton_Type.pythonType)));
    PyModule_AddObject(module, (char*)"ControlSlider", (PyObject*)(&(TyXBMCAddon_xbmcgui_ControlSlider_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Dialog", (PyObject*)(&(TyXBMCAddon_xbmcgui_Dialog_Type.pythonType)));
    PyModule_AddObject(module, (char*)"DialogProgress", (PyObject*)(&(TyXBMCAddon_xbmcgui_DialogProgress_Type.pythonType)));
    PyModule_AddObject(module, (char*)"DialogProgressBG", (PyObject*)(&(TyXBMCAddon_xbmcgui_DialogProgressBG_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Action", (PyObject*)(&(TyXBMCAddon_xbmcgui_Action_Type.pythonType)));
    PyModule_AddObject(module, (char*)"Window", (PyObject*)(&(TyXBMCAddon_xbmcgui_Window_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WindowDialog", (PyObject*)(&(TyXBMCAddon_xbmcgui_WindowDialog_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WindowXML", (PyObject*)(&(TyXBMCAddon_xbmcgui_WindowXML_Type.pythonType)));
    PyModule_AddObject(module, (char*)"WindowXMLDialog", (PyObject*)(&(TyXBMCAddon_xbmcgui_WindowXMLDialog_Type.pythonType)));

   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team XBMC <http://xbmc.org>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Thu Aug 21 10:48:24 EDT 2014");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.14.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team XBMC");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"ICON_OVERLAY_NONE",CGUIListItem::ICON_OVERLAY_NONE); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_RAR",CGUIListItem::ICON_OVERLAY_RAR); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_ZIP",CGUIListItem::ICON_OVERLAY_ZIP); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_LOCKED",CGUIListItem::ICON_OVERLAY_LOCKED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_HAS_TRAINER",CGUIListItem::ICON_OVERLAY_HAS_TRAINER); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_TRAINED",CGUIListItem::ICON_OVERLAY_TRAINED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_UNWATCHED",CGUIListItem::ICON_OVERLAY_UNWATCHED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_WATCHED",CGUIListItem::ICON_OVERLAY_WATCHED); 
   PyModule_AddIntConstant(module,"ICON_OVERLAY_HD",CGUIListItem::ICON_OVERLAY_HD); 
   PyModule_AddStringConstant(module,"NOTIFICATION_INFO",getNOTIFICATION_INFO()); 
   PyModule_AddStringConstant(module,"NOTIFICATION_WARNING",getNOTIFICATION_WARNING()); 
   PyModule_AddStringConstant(module,"NOTIFICATION_ERROR",getNOTIFICATION_ERROR()); 
   PyModule_AddIntConstant(module,"INPUT_ALPHANUM",INPUT_ALPHANUM); 
   PyModule_AddIntConstant(module,"INPUT_NUMERIC",INPUT_NUMERIC); 
   PyModule_AddIntConstant(module,"INPUT_DATE",INPUT_DATE); 
   PyModule_AddIntConstant(module,"INPUT_TIME",INPUT_TIME); 
   PyModule_AddIntConstant(module,"INPUT_IPADDRESS",INPUT_IPADDRESS); 
   PyModule_AddIntConstant(module,"INPUT_PASSWORD",INPUT_PASSWORD); 
   PyModule_AddIntConstant(module,"PASSWORD_VERIFY",PASSWORD_VERIFY); 
   PyModule_AddIntConstant(module,"ALPHANUM_HIDE_INPUT",ALPHANUM_HIDE_INPUT); 
   PyModule_AddIntConstant(module,"CONTROL_TEXT_OFFSET_X",10); 
   PyModule_AddIntConstant(module,"CONTROL_TEXT_OFFSET_Y",2); 
   PyModule_AddIntConstant(module,"INPUT_ALPHANUM",0); 
   PyModule_AddIntConstant(module,"INPUT_NUMERIC",1); 
   PyModule_AddIntConstant(module,"INPUT_DATE",2); 
   PyModule_AddIntConstant(module,"INPUT_TIME",3); 
   PyModule_AddIntConstant(module,"INPUT_IPADDRESS",4); 
   PyModule_AddIntConstant(module,"INPUT_PASSWORD",5); 
   PyModule_AddIntConstant(module,"PASSWORD_VERIFY",1); 
   PyModule_AddIntConstant(module,"ALPHANUM_HIDE_INPUT",2); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_A",256); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_B",257); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_X",258); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_Y",259); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_BLACK",260); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_WHITE",261); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_TRIGGER",262); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_TRIGGER",263); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK",264); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK",265); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_UP",266); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_DOWN",267); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_LEFT",268); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_STICK_RIGHT",269); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_UP",270); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_DOWN",271); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_LEFT",272); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_DPAD_RIGHT",273); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_START",274); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_BACK",275); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_BUTTON",276); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_THUMB_BUTTON",277); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_ANALOG_TRIGGER",278); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_RIGHT_ANALOG_TRIGGER",279); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_UP",280); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_DOWN",281); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_LEFT",282); 
   PyModule_AddIntConstant(module,"KEY_BUTTON_LEFT_THUMB_STICK_RIGHT",283); 
   PyModule_AddIntConstant(module,"KEY_VMOUSE",0xEFFF); 
   PyModule_AddIntConstant(module,"KEY_VKEY",0xF000); 
   PyModule_AddIntConstant(module,"KEY_ASCII",0xF100); 
   PyModule_AddIntConstant(module,"KEY_UNICODE",0xF200); 
   PyModule_AddIntConstant(module,"KEY_MOUSE",0xE000); 
   PyModule_AddIntConstant(module,"KEY_APPCOMMAND",0xD000); 
   PyModule_AddIntConstant(module,"KEY_TOUCH",0xF000); 
   PyModule_AddIntConstant(module,"KEY_INVALID",0xFFFF); 
   PyModule_AddIntConstant(module,"ACTION_NONE",0); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_LEFT",1); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_RIGHT",2); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_UP",3); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_DOWN",4); 
   PyModule_AddIntConstant(module,"ACTION_PAGE_UP",5); 
   PyModule_AddIntConstant(module,"ACTION_PAGE_DOWN",6); 
   PyModule_AddIntConstant(module,"ACTION_SELECT_ITEM",7); 
   PyModule_AddIntConstant(module,"ACTION_HIGHLIGHT_ITEM",8); 
   PyModule_AddIntConstant(module,"ACTION_PARENT_DIR",9); 
   PyModule_AddIntConstant(module,"ACTION_PREVIOUS_MENU",10); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_INFO",11); 
   PyModule_AddIntConstant(module,"ACTION_PAUSE",12); 
   PyModule_AddIntConstant(module,"ACTION_STOP",13); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_ITEM",14); 
   PyModule_AddIntConstant(module,"ACTION_PREV_ITEM",15); 
   PyModule_AddIntConstant(module,"ACTION_FORWARD",16); 
   PyModule_AddIntConstant(module,"ACTION_REWIND",17); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_GUI",18); 
   PyModule_AddIntConstant(module,"ACTION_ASPECT_RATIO",19); 
   PyModule_AddIntConstant(module,"ACTION_STEP_FORWARD",20); 
   PyModule_AddIntConstant(module,"ACTION_STEP_BACK",21); 
   PyModule_AddIntConstant(module,"ACTION_BIG_STEP_FORWARD",22); 
   PyModule_AddIntConstant(module,"ACTION_BIG_STEP_BACK",23); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_OSD",24); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_SUBTITLES",25); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_SUBTITLE",26); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_CODEC",27); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_PICTURE",28); 
   PyModule_AddIntConstant(module,"ACTION_PREV_PICTURE",29); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_OUT",30); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_IN",31); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_SOURCE_DEST",32); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_PLAYLIST",33); 
   PyModule_AddIntConstant(module,"ACTION_QUEUE_ITEM",34); 
   PyModule_AddIntConstant(module,"ACTION_REMOVE_ITEM",35); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_FULLSCREEN",36); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_NORMAL",37); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_1",38); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_2",39); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_3",40); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_4",41); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_5",42); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_6",43); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_7",44); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_8",45); 
   PyModule_AddIntConstant(module,"ACTION_ZOOM_LEVEL_9",46); 
   PyModule_AddIntConstant(module,"ACTION_CALIBRATE_SWAP_ARROWS",47); 
   PyModule_AddIntConstant(module,"ACTION_CALIBRATE_RESET",48); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_MOVE",49); 
   PyModule_AddIntConstant(module,"ACTION_ROTATE_PICTURE_CW",50); 
   PyModule_AddIntConstant(module,"ACTION_ROTATE_PICTURE_CCW",51); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_DELAY_MIN",52); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_DELAY_PLUS",53); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_DELAY_MIN",54); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_DELAY_PLUS",55); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_NEXT_LANGUAGE",56); 
   PyModule_AddIntConstant(module,"ACTION_CHANGE_RESOLUTION",57); 
   PyModule_AddIntConstant(module,"REMOTE_0",58); 
   PyModule_AddIntConstant(module,"REMOTE_1",59); 
   PyModule_AddIntConstant(module,"REMOTE_2",60); 
   PyModule_AddIntConstant(module,"REMOTE_3",61); 
   PyModule_AddIntConstant(module,"REMOTE_4",62); 
   PyModule_AddIntConstant(module,"REMOTE_5",63); 
   PyModule_AddIntConstant(module,"REMOTE_6",64); 
   PyModule_AddIntConstant(module,"REMOTE_7",65); 
   PyModule_AddIntConstant(module,"REMOTE_8",66); 
   PyModule_AddIntConstant(module,"REMOTE_9",67); 
   PyModule_AddIntConstant(module,"ACTION_PLAY",68); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_LEFT",69); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_RIGHT",70); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_UP",71); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_DOWN",72); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_SELECT",73); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_VALUE_PLUS",74); 
   PyModule_AddIntConstant(module,"ACTION_OSD_SHOW_VALUE_MIN",75); 
   PyModule_AddIntConstant(module,"ACTION_SMALL_STEP_BACK",76); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_FORWARD",77); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_REWIND",78); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_PLAY",79); 
   PyModule_AddIntConstant(module,"ACTION_DELETE_ITEM",80); 
   PyModule_AddIntConstant(module,"ACTION_COPY_ITEM",81); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_ITEM",82); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_MPLAYER_OSD",83); 
   PyModule_AddIntConstant(module,"ACTION_OSD_HIDESUBMENU",84); 
   PyModule_AddIntConstant(module,"ACTION_TAKE_SCREENSHOT",85); 
   PyModule_AddIntConstant(module,"ACTION_RENAME_ITEM",87); 
   PyModule_AddIntConstant(module,"ACTION_VOLUME_UP",88); 
   PyModule_AddIntConstant(module,"ACTION_VOLUME_DOWN",89); 
   PyModule_AddIntConstant(module,"ACTION_MUTE",91); 
   PyModule_AddIntConstant(module,"ACTION_NAV_BACK",92); 
   PyModule_AddIntConstant(module,"ACTION_VOLAMP_UP",93); 
   PyModule_AddIntConstant(module,"ACTION_VOLAMP_DOWN",94); 
   PyModule_AddIntConstant(module,"ACTION_CREATE_EPISODE_BOOKMARK",95); 
   PyModule_AddIntConstant(module,"ACTION_CREATE_BOOKMARK",96); 
   PyModule_AddIntConstant(module,"ACTION_CHAPTER_OR_BIG_STEP_FORWARD",97); 
   PyModule_AddIntConstant(module,"ACTION_CHAPTER_OR_BIG_STEP_BACK",98); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_START",100); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_LEFT_CLICK",100); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_RIGHT_CLICK",101); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_MIDDLE_CLICK",102); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_DOUBLE_CLICK",103); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_WHEEL_UP",104); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_WHEEL_DOWN",105); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_DRAG",106); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_MOVE",107); 
   PyModule_AddIntConstant(module,"ACTION_MOUSE_END",109); 
   PyModule_AddIntConstant(module,"ACTION_BACKSPACE",110); 
   PyModule_AddIntConstant(module,"ACTION_SCROLL_UP",111); 
   PyModule_AddIntConstant(module,"ACTION_SCROLL_DOWN",112); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_FORWARD",113); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_REWIND",114); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_ITEM_UP",115); 
   PyModule_AddIntConstant(module,"ACTION_MOVE_ITEM_DOWN",116); 
   PyModule_AddIntConstant(module,"ACTION_CONTEXT_MENU",117); 
   PyModule_AddIntConstant(module,"ACTION_SHIFT",118); 
   PyModule_AddIntConstant(module,"ACTION_SYMBOLS",119); 
   PyModule_AddIntConstant(module,"ACTION_CURSOR_LEFT",120); 
   PyModule_AddIntConstant(module,"ACTION_CURSOR_RIGHT",121); 
   PyModule_AddIntConstant(module,"ACTION_BUILT_IN_FUNCTION",122); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_OSD_TIME",123); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_SEEK_FORWARD",124); 
   PyModule_AddIntConstant(module,"ACTION_ANALOG_SEEK_BACK",125); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_SHOW",126); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_LIST",127); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_NEXT",128); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_PREV",129); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_LOCK",130); 
   PyModule_AddIntConstant(module,"ACTION_VIS_PRESET_RANDOM",131); 
   PyModule_AddIntConstant(module,"ACTION_VIS_RATE_PRESET_PLUS",132); 
   PyModule_AddIntConstant(module,"ACTION_VIS_RATE_PRESET_MINUS",133); 
   PyModule_AddIntConstant(module,"ACTION_SHOW_VIDEOMENU",134); 
   PyModule_AddIntConstant(module,"ACTION_ENTER",135); 
   PyModule_AddIntConstant(module,"ACTION_INCREASE_RATING",136); 
   PyModule_AddIntConstant(module,"ACTION_DECREASE_RATING",137); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_SCENE",138); 
   PyModule_AddIntConstant(module,"ACTION_PREV_SCENE",139); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_LETTER",140); 
   PyModule_AddIntConstant(module,"ACTION_PREV_LETTER",141); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS2",142); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS3",143); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS4",144); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS5",145); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS6",146); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS7",147); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS8",148); 
   PyModule_AddIntConstant(module,"ACTION_JUMP_SMS9",149); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_CLEAR",150); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS2",151); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS3",152); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS4",153); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS5",154); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS6",155); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS7",156); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS8",157); 
   PyModule_AddIntConstant(module,"ACTION_FILTER_SMS9",158); 
   PyModule_AddIntConstant(module,"ACTION_FIRST_PAGE",159); 
   PyModule_AddIntConstant(module,"ACTION_LAST_PAGE",160); 
   PyModule_AddIntConstant(module,"ACTION_AUDIO_DELAY",161); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_DELAY",162); 
   PyModule_AddIntConstant(module,"ACTION_RECORD",170); 
   PyModule_AddIntConstant(module,"ACTION_PASTE",180); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_CONTROL",181); 
   PyModule_AddIntConstant(module,"ACTION_PREV_CONTROL",182); 
   PyModule_AddIntConstant(module,"ACTION_CHANNEL_SWITCH",183); 
   PyModule_AddIntConstant(module,"ACTION_CHANNEL_UP",184); 
   PyModule_AddIntConstant(module,"ACTION_CHANNEL_DOWN",185); 
   PyModule_AddIntConstant(module,"ACTION_NEXT_CHANNELGROUP",186); 
   PyModule_AddIntConstant(module,"ACTION_PREVIOUS_CHANNELGROUP",187); 
   PyModule_AddIntConstant(module,"ACTION_PVR_PLAY",188); 
   PyModule_AddIntConstant(module,"ACTION_PVR_PLAY_TV",189); 
   PyModule_AddIntConstant(module,"ACTION_PVR_PLAY_RADIO",190); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_FULLSCREEN",199); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_WATCHED",200); 
   PyModule_AddIntConstant(module,"ACTION_SCAN_ITEM",201); 
   PyModule_AddIntConstant(module,"ACTION_TOGGLE_DIGITAL_ANALOG",202); 
   PyModule_AddIntConstant(module,"ACTION_RELOAD_KEYMAPS",203); 
   PyModule_AddIntConstant(module,"ACTION_GUIPROFILE_BEGIN",204); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_RED",215); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_GREEN",216); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_YELLOW",217); 
   PyModule_AddIntConstant(module,"ACTION_TELETEXT_BLUE",218); 
   PyModule_AddIntConstant(module,"ACTION_INCREASE_PAR",219); 
   PyModule_AddIntConstant(module,"ACTION_DECREASE_PAR",220); 
   PyModule_AddIntConstant(module,"ACTION_VSHIFT_UP",227); 
   PyModule_AddIntConstant(module,"ACTION_VSHIFT_DOWN",228); 
   PyModule_AddIntConstant(module,"ACTION_PLAYER_PLAYPAUSE",229); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_VSHIFT_UP",230); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_VSHIFT_DOWN",231); 
   PyModule_AddIntConstant(module,"ACTION_SUBTITLE_ALIGN",232); 
   PyModule_AddIntConstant(module,"ACTION_FILTER",233); 
   PyModule_AddIntConstant(module,"ACTION_SWITCH_PLAYER",234); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_NEXT",235); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_PREVIOUS",236); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_TOGGLE",237); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_SELECT",238); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_TOMONO",239); 
   PyModule_AddIntConstant(module,"ACTION_STEREOMODE_SET",240); 
   PyModule_AddIntConstant(module,"ACTION_SETTINGS_RESET",241); 
   PyModule_AddIntConstant(module,"ACTION_SETTINGS_LEVEL_CHANGE",242); 
   PyModule_AddIntConstant(module,"ACTION_TRIGGER_OSD",243); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_TAP",401); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_TAP_TEN",410); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_LONGPRESS",411); 
   PyModule_AddIntConstant(module,"ACTION_TOUCH_LONGPRESS_TEN",420); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_NOTIFY",500); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_BEGIN",501); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_ZOOM",502); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_ROTATE",503); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_PAN",504); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_LEFT",511); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_LEFT_TEN",520); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_RIGHT",521); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_RIGHT_TEN",530); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_UP",531); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_UP_TEN",540); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_DOWN",541); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_SWIPE_DOWN_TEN",550); 
   PyModule_AddIntConstant(module,"ACTION_GESTURE_END",599); 
   PyModule_AddIntConstant(module,"ACTION_NOOP",999); 
   PyModule_AddIntConstant(module,"ICON_TYPE_NONE",101); 
   PyModule_AddIntConstant(module,"ICON_TYPE_PROGRAMS",102); 
   PyModule_AddIntConstant(module,"ICON_TYPE_MUSIC",103); 
   PyModule_AddIntConstant(module,"ICON_TYPE_PICTURES",104); 
   PyModule_AddIntConstant(module,"ICON_TYPE_VIDEOS",105); 
   PyModule_AddIntConstant(module,"ICON_TYPE_FILES",106); 
   PyModule_AddIntConstant(module,"ICON_TYPE_WEATHER",107); 
   PyModule_AddIntConstant(module,"ICON_TYPE_SETTINGS",109); 
  }

} // end PythonBindings namespace for python type definitions
