

/*
 *      Copyright (C) 2005-2013 Team XBMC
 *      http://xbmc.org
 *
 *  This Program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This Program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with XBMC; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *  http://www.gnu.org/copyleft/gpl.html
 *
 */

// ************************************************************************
// This file was generated by xbmc compile process. DO NOT EDIT!!
//  It was created by running the code generator on the spec file for
//  the module "xbmcplugin" on the template file PythonSwig.template.cpp
// ************************************************************************



#include <Python.h>
#include <string>
#include "interfaces/python/LanguageHook.h"
#include "interfaces/python/swig.h"
#include "interfaces/python/PyContext.h"


#include "interfaces/legacy/ModuleXbmcplugin.h"

using namespace XBMCAddon;
using namespace xbmcplugin;

#if defined(__GNUG__) && (__GNUC__>4) || (__GNUC__==4 && __GNUC_MINOR__>=2)
#pragma GCC diagnostic ignored "-Wstrict-aliasing"
#endif



namespace PythonBindings
{

  //=========================================================================
  // These variables define the type XBMCAddon::xbmcgui::ListItem from another module 
  extern TypeInfo TyXBMCAddon_xbmcgui_ListItem_Type;
  //=========================================================================



  PyDoc_STRVAR(addDirectoryItem__doc__,
               "addDirectoryItem(handle, url, listitem [,isFolder, totalItems])--Callback function to pass directory contents back to XBMC.\n"
"    - Returns a bool for successful completion.\n"
"\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"url : string - url of the entry. would be plugin:// for another virtual directory\n"
"listitem : ListItem - item to add.\n"
"isFolder : [opt] bool - True=folder / False=not a folder(default).\n"
"totalItems : [opt] integer - total number of items that will be passed.(used for progressbar)\n"
"*Note, You can use the above as keywords for arguments and skip certain optional arguments.\n"
"Once you use a keyword, all following arguments require the keyword.\n"
"example:\n"
"    - if not xbmcplugin.addDirectoryItem(int(sys.argv[1]), 'F:\\Trailers\\300.mov', listitem, totalItems=50): break\n");

  static PyObject* xbmcplugin_addDirectoryItem (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "url",
          "listitem",
          "isFolder",
          "totalItems",
          NULL};
         
    int  handle ;         
    std::string  url ;
    PyObject* pyurl = NULL;         
    XBMCAddon::xbmcgui::ListItem * listitem ;
    PyObject* pylistitem = NULL;         
    bool  isFolder  = false;         
    int  totalItems  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO|bi",
       (char**)keywords,
         &handle,
         &pyurl,
         &pylistitem,
         &isFolder,
         &totalItems
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      if (pyurl) PyXBMCGetUnicodeString(url,pyurl,false,"url","XBMCAddon::xbmcplugin::addDirectoryItem"); 
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcplugin::","XBMCAddon::xbmcplugin::addDirectoryItem"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcplugin::addDirectoryItem(  handle,  url,  listitem,  isFolder,  totalItems  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::addDirectoryItem\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::addDirectoryItem\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(addDirectoryItems__doc__,
               "addDirectoryItems(handle, items [,totalItems])--Callback function to pass directory contents back to XBMC as a list.\n"
"    - Returns a bool for successful completion.\n"
"\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"items :List - list of (url, listitem[, isFolder]) as a tuple to add.\n"
"totalItems : [opt] integer - total number of items that will be passed.(used for progressbar)\n"
"Large lists benefit over using the standard addDirectoryItem()\n"
"   You may call this more than once to add items in chunks\n"
"\n"
"example:\n"
"    - if not xbmcplugin.addDirectoryItems(int(sys.argv[1]), [(url, listitem, False,)]: raise\n");

  static PyObject* xbmcplugin_addDirectoryItems (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "items",
          "totalItems",
          NULL};
         
    int  handle ;         
    std::vector< Tuple< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const *,bool  >  >  items ;
    PyObject* pyitems = NULL;         
    int  totalItems  = 0;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iO|i",
       (char**)keywords,
         &handle,
         &pyitems,
         &totalItems
       ))
    {
      return NULL;
    }

    bool  apiResult;
    try
    {
      

    {
      bool isTuple = PyObject_TypeCheck(pyitems,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyitems,&PyList_Type))
        throw WrongTypeException("The parameter \"items\" must be either a Tuple or a List.");

      
      PyObject *pyentry1 = NULL;
      int vecSize = (isTuple ? PyTuple_Size(pyitems) : PyList_Size(pyitems));
      for(int i = 0; i < vecSize; i++)
      {
        pyentry1 = (isTuple ? PyTuple_GetItem(pyitems, i) : PyList_GetItem(pyitems, i));
        Tuple< XBMCAddon::String ,XBMCAddon::xbmcgui::ListItem const *,bool  >  entry1;
        

    {
      bool isTuple = PyObject_TypeCheck(pyentry1,&PyTuple_Type);
      if (!isTuple && !PyObject_TypeCheck(pyentry1,&PyList_Type))
        throw WrongTypeException("The parameter \"entry1\" must be either a Tuple or a List.");
      int vecSize = (isTuple ? PyTuple_Size(pyentry1) : PyList_Size(pyentry1));

      if (vecSize > 0)
      {
        PyObject *pyentry0_2 = NULL;
        pyentry0_2 = (isTuple ? PyTuple_GetItem(pyentry1, 0) : PyList_GetItem(pyentry1, 0));
        std::string  entry0_2;
        if (pyentry0_2) PyXBMCGetUnicodeString(entry0_2,pyentry0_2,false,"entry0_2","XBMCAddon::xbmcplugin::addDirectoryItems");
        entry1.first() = entry0_2;
      }

      if (vecSize > 1)
      {
        PyObject *pyentry1_2 = NULL;
        pyentry1_2 = (isTuple ? PyTuple_GetItem(pyentry1, 1) : PyList_GetItem(pyentry1, 1));
        XBMCAddon::xbmcgui::ListItem * entry1_2;
        entry1_2 = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pyentry1_2,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcplugin::","XBMCAddon::xbmcplugin::addDirectoryItems");
        entry1.second() = entry1_2;
      }

      if (vecSize > 2)
      {
        PyObject *pyentry2_2 = NULL;
        pyentry2_2 = (isTuple ? PyTuple_GetItem(pyentry1, 2) : PyList_GetItem(pyentry1, 2));
        bool  entry2_2;
        entry2_2 = (PyInt_AsLong(pyentry2_2) == 0L ? false : true);
        entry1.third() = entry2_2;
      }

    }

        items.push_back(entry1);
      }
    }
 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (bool )XBMCAddon::xbmcplugin::addDirectoryItems(  handle,  items,  totalItems  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::addDirectoryItems\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::addDirectoryItems\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    result = Py_BuildValue((char*)"b", apiResult);

    return result; 
  } 

  PyDoc_STRVAR(endOfDirectory__doc__,
               "endOfDirectory(handle[, succeeded, updateListing, cacheToDisc])--Callback function to tell XBMC that the end of the directory listing in a virtualPythonFolder module is reached.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"succeeded : [opt] bool - True=script completed successfully(Default)/False=Script did not.\n"
"updateListing : [opt] bool - True=this folder should update the current listing/False=Folder is a subfolder(Default).\n"
"cacheToDisc : [opt] bool - True=Folder will cache if extended time(default)/False=this folder will never cache to disc.\n"
"\n"
"example:\n"
"    - xbmcplugin.endOfDirectory(int(sys.argv[1]), cacheToDisc=False)\n");

  static PyObject* xbmcplugin_endOfDirectory (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "succeeded",
          "updateListing",
          "cacheToDisc",
          NULL};
         
    int  handle ;         
    bool  succeeded  = true;         
    bool  updateListing  = false;         
    bool  cacheToDisc  = true;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i|bbb",
       (char**)keywords,
         &handle,
         &succeeded,
         &updateListing,
         &cacheToDisc
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::endOfDirectory(  handle,  succeeded,  updateListing,  cacheToDisc  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::endOfDirectory\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::endOfDirectory\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(setResolvedUrl__doc__,
               "setResolvedUrl(handle, succeeded, listitem)--Callback function to tell XBMC that the file plugin has been resolved to a url\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"succeeded : bool - True=script completed successfully/False=Script did not.\n"
"listitem : ListItem - item the file plugin resolved to for playback.\n"
"\n"
"example:\n"
"    - xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, listitem)\n");

  static PyObject* xbmcplugin_setResolvedUrl (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "succeeded",
          "listitem",
          NULL};
         
    int  handle ;         
    bool  succeeded ;         
    XBMCAddon::xbmcgui::ListItem * listitem ;
    PyObject* pylistitem = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ibO",
       (char**)keywords,
         &handle,
         &succeeded,
         &pylistitem
       ))
    {
      return NULL;
    }


    try
    {
      listitem = (XBMCAddon::xbmcgui::ListItem *)retrieveApiInstance(pylistitem,"p.XBMCAddon::xbmcgui::ListItem","XBMCAddon::xbmcplugin::","XBMCAddon::xbmcplugin::setResolvedUrl"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::setResolvedUrl(  handle,  succeeded,  listitem  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setResolvedUrl\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setResolvedUrl\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(addSortMethod__doc__,
               "addSortMethod(handle, sortMethod, label2Mask)--Adds a sorting method for the media list.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"sortMethod : integer - number for sortmethod see SortFileItem.h.\n"
"label2Mask : [opt] string - the label mask to use for the second label. Defaults to 'D'\n"
"    - applies to:\n"
"        - SORT_METHOD_NONE, SORT_METHOD_UNSORTED, SORT_METHOD_VIDEO_TITLE,\n"
"        - SORT_METHOD_TRACKNUM, SORT_METHOD_FILE, SORT_METHOD_TITLE,\n"
"        - SORT_METHOD_TITLE_IGNORE_THE, SORT_METHOD_LABEL,\n"
"        - SORT_METHOD_LABEL_IGNORE_THE, SORT_METHOD_VIDEO_SORT_TITLE,\n"
"        - SORT_METHOD_VIDEO_SORT_TITLE_IGNORE_THE, SORT_METHOD_FULLPATH,\n"
"        - SORT_METHOD_LABEL_IGNORE_FOLDERS, SORT_METHOD_CHANNEL\n"
"\n"
"\n"
"\n"
"example:\n"
"        - xbmcplugin.addSortMethod(int(sys.argv[1]), 1)\n");

  static PyObject* xbmcplugin_addSortMethod (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "sortMethod",
          "label2Mask",
          NULL};
         
    int  handle ;         
    int  sortMethod ;         
    std::string  label2Mask  = XBMCAddon::emptyString;
    PyObject* pylabel2Mask = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"ii|O",
       (char**)keywords,
         &handle,
         &sortMethod,
         &pylabel2Mask
       ))
    {
      return NULL;
    }


    try
    {
      if (pylabel2Mask) PyXBMCGetUnicodeString(label2Mask,pylabel2Mask,false,"label2Mask","XBMCAddon::xbmcplugin::addSortMethod"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::addSortMethod(  handle,  sortMethod,  label2Mask  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::addSortMethod\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::addSortMethod\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(getSetting__doc__,
               "getSetting(handle, id)--Returns the value of a setting as a string.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"id : string - id of the setting that the module needs to access.\n"
"\n"
"*Note, You can use the above as a keyword.\n"
"\n"
"example:\n"
"    - apikey = xbmcplugin.getSetting(int(sys.argv[1]), 'apikey')\n");

  static PyObject* xbmcplugin_getSetting (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "id",
          NULL};
         
    int  handle ;         
    char * id ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"is",
       (char**)keywords,
         &handle,
         &id
       ))
    {
      return NULL;
    }

    std::string  apiResult;
    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      apiResult = (std::string )XBMCAddon::xbmcplugin::getSetting(  handle,  id  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::getSetting\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::getSetting\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    
result = PyString_FromStringAndSize(apiResult.c_str(), apiResult.length());


    return result; 
  } 

  PyDoc_STRVAR(setSetting__doc__,
               "setSetting(handle, id, value)--Sets a plugin setting for the current running plugin.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"id : string - id of the setting that the module needs to access.\n"
"value : string or unicode - value of the setting.\n"
"\n"
"example:\n"
"    - xbmcplugin.setSetting(int(sys.argv[1]), id='username', value='teamxbmc')\n");

  static PyObject* xbmcplugin_setSetting (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "id",
          "value",
          NULL};
         
    int  handle ;         
    std::string  id ;
    PyObject* pyid = NULL;         
    std::string  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iOO",
       (char**)keywords,
         &handle,
         &pyid,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyid) PyXBMCGetUnicodeString(id,pyid,false,"id","XBMCAddon::xbmcplugin::setSetting"); 
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","XBMCAddon::xbmcplugin::setSetting"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::setSetting(  handle,  id,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setSetting\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setSetting\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(setContent__doc__,
               "setContent(handle, content)--Sets the plugins content.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"content : string - content type (eg. movies)\n"
"\n"
"*Note: content: files, songs, artists, albums, movies, tvshows, episodes, musicvideos\n"
"\n"
"example:\n"
"    - xbmcplugin.setContent(int(sys.argv[1]), 'movies')\n");

  static PyObject* xbmcplugin_setContent (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "content",
          NULL};
         
    int  handle ;         
    char * content ;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"is",
       (char**)keywords,
         &handle,
         &content
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::setContent(  handle,  content  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setContent\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setContent\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(setPluginCategory__doc__,
               "setPluginCategory(handle, category)--Sets the plugins name for skins to display.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"category : string or unicode - plugins sub category.\n"
"\n"
"example:\n"
"    - xbmcplugin.setPluginCategory(int(sys.argv[1]), 'Comedy')\n");

  static PyObject* xbmcplugin_setPluginCategory (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "category",
          NULL};
         
    int  handle ;         
    std::string  category ;
    PyObject* pycategory = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"iO",
       (char**)keywords,
         &handle,
         &pycategory
       ))
    {
      return NULL;
    }


    try
    {
      if (pycategory) PyXBMCGetUnicodeString(category,pycategory,false,"category","XBMCAddon::xbmcplugin::setPluginCategory"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::setPluginCategory(  handle,  category  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setPluginCategory\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setPluginCategory\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(setPluginFanart__doc__,
               "setPluginFanart(handle, image, color1, color2, color3)--Sets the plugins fanart and color for skins to display.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"image : [opt] string - path to fanart image.\n"
"color1 : [opt] hexstring - color1. (e.g. '0xFFFFFFFF')\n"
"color2 : [opt] hexstring - color2. (e.g. '0xFFFF3300')\n"
"color3 : [opt] hexstring - color3. (e.g. '0xFF000000')\n"
"\n"
"example:\n"
"    - xbmcplugin.setPluginFanart(int(sys.argv[1]), 'special://home/addons/plugins/video/Apple movie trailers II/fanart.png', color2='0xFFFF3300')\n");

  static PyObject* xbmcplugin_setPluginFanart (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "image",
          "color1",
          "color2",
          "color3",
          NULL};
         
    int  handle ;         
    char * image  = NULL;         
    char * color1  = NULL;         
    char * color2  = NULL;         
    char * color3  = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"i|ssss",
       (char**)keywords,
         &handle,
         &image,
         &color1,
         &color2,
         &color3
       ))
    {
      return NULL;
    }


    try
    {

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::setPluginFanart(  handle,  image,  color1,  color2,  color3  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setPluginFanart\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setPluginFanart\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 

  PyDoc_STRVAR(setProperty__doc__,
               "setProperty(handle, key, value)--Sets a container property for this plugin.\n"
"\n"
"handle : integer - handle the plugin was started with.\n"
"key : string - property name.\n"
"value : string or unicode - value of property.\n"
"\n"
"*Note, Key is NOT case sensitive.\n"
"\n"
"example:\n"
"    - xbmcplugin.setProperty(int(sys.argv[1]), 'Emulator', 'M.A.M.E.')\n");

  static PyObject* xbmcplugin_setProperty (PyObject* self  , PyObject *args, PyObject *kwds  )
  {
    XBMC_TRACE;

    static const char *keywords[] = {
          "handle",
          "key",
          "value",
          NULL};
         
    int  handle ;         
    char * key ;         
    std::string  value ;
    PyObject* pyvalue = NULL;
    if (!PyArg_ParseTupleAndKeywords(
       args,
       kwds,
       (char*)"isO",
       (char**)keywords,
         &handle,
         &key,
         &pyvalue
       ))
    {
      return NULL;
    }


    try
    {
      if (pyvalue) PyXBMCGetUnicodeString(value,pyvalue,false,"value","XBMCAddon::xbmcplugin::setProperty"); 

      XBMCAddon::SetLanguageHookGuard slhg(XBMCAddon::Python::PythonLanguageHook::GetIfExists(PyThreadState_Get()->interp).get());
      XBMCAddon::xbmcplugin::setProperty(  handle,  key,  value  );

    }
    catch (const XBMCAddon::WrongTypeException& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_TypeError, e.GetMessage()); 
      return NULL; 
    }
    catch (const XbmcCommons::Exception& e)
    { 
      CLog::Log(LOGERROR,"EXCEPTION: %s",e.GetMessage());
      PyErr_SetString(PyExc_RuntimeError, e.GetMessage()); 
      return NULL; 
    }
    catch (...)
    {
      CLog::Log(LOGERROR,"EXCEPTION: Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setProperty\"");
      PyErr_SetString(PyExc_RuntimeError, "Unknown exception thrown from the call \"XBMCAddon::xbmcplugin::setProperty\""); 
      return NULL; 
    }

    PyObject* result;

    // transform the result
    Py_INCREF(Py_None);
    result = Py_None;

    return result; 
  } 


  static PyMethodDef xbmcplugin_methods[] = { 
    {(char*)"addDirectoryItem", (PyCFunction)xbmcplugin_addDirectoryItem, METH_VARARGS|METH_KEYWORDS, addDirectoryItem__doc__ }, 
    {(char*)"addDirectoryItems", (PyCFunction)xbmcplugin_addDirectoryItems, METH_VARARGS|METH_KEYWORDS, addDirectoryItems__doc__ }, 
    {(char*)"endOfDirectory", (PyCFunction)xbmcplugin_endOfDirectory, METH_VARARGS|METH_KEYWORDS, endOfDirectory__doc__ }, 
    {(char*)"setResolvedUrl", (PyCFunction)xbmcplugin_setResolvedUrl, METH_VARARGS|METH_KEYWORDS, setResolvedUrl__doc__ }, 
    {(char*)"addSortMethod", (PyCFunction)xbmcplugin_addSortMethod, METH_VARARGS|METH_KEYWORDS, addSortMethod__doc__ }, 
    {(char*)"getSetting", (PyCFunction)xbmcplugin_getSetting, METH_VARARGS|METH_KEYWORDS, getSetting__doc__ }, 
    {(char*)"setSetting", (PyCFunction)xbmcplugin_setSetting, METH_VARARGS|METH_KEYWORDS, setSetting__doc__ }, 
    {(char*)"setContent", (PyCFunction)xbmcplugin_setContent, METH_VARARGS|METH_KEYWORDS, setContent__doc__ }, 
    {(char*)"setPluginCategory", (PyCFunction)xbmcplugin_setPluginCategory, METH_VARARGS|METH_KEYWORDS, setPluginCategory__doc__ }, 
    {(char*)"setPluginFanart", (PyCFunction)xbmcplugin_setPluginFanart, METH_VARARGS|METH_KEYWORDS, setPluginFanart__doc__ }, 
    {(char*)"setProperty", (PyCFunction)xbmcplugin_setProperty, METH_VARARGS|METH_KEYWORDS, setProperty__doc__ }, 
    {NULL, NULL, 0, NULL}
  };

  // This is the call that will call all of the other initializes 
  //  for all of the classes in this module
  static void initTypes()
  {
    static bool typesAlreadyInitialized = false;
    if (!typesAlreadyInitialized)
    {
      typesAlreadyInitialized = true;

    }
  }

  void initModule_xbmcplugin()
  {
    initTypes();

    // init general xbmcplugin modules
    PyObject* module;



    module = Py_InitModule((char*)"xbmcplugin", xbmcplugin_methods);
    if (module == NULL) return;



   // constants
   PyModule_AddStringConstant(module, (char*)"__author__", (char*)"Team XBMC <http://xbmc.org>");
   PyModule_AddStringConstant(module, (char*)"__date__", (char*)"Thu Aug 21 10:48:17 EDT 2014");
   PyModule_AddStringConstant(module, (char*)"__version__", (char*)"2.14.0");
   PyModule_AddStringConstant(module, (char*)"__credits__", (char*)"Team XBMC");
   PyModule_AddStringConstant(module, (char*)"__platform__", (char*)"ALL");

   // need to handle constants

   PyModule_AddIntConstant(module,"SORT_METHOD_NONE",SORT_METHOD_NONE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_LABEL",SORT_METHOD_LABEL); 
   PyModule_AddIntConstant(module,"SORT_METHOD_LABEL_IGNORE_THE",SORT_METHOD_LABEL_IGNORE_THE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_DATE",SORT_METHOD_DATE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_SIZE",SORT_METHOD_SIZE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_FILE",SORT_METHOD_FILE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_DRIVE_TYPE",SORT_METHOD_DRIVE_TYPE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_TRACKNUM",SORT_METHOD_TRACKNUM); 
   PyModule_AddIntConstant(module,"SORT_METHOD_DURATION",SORT_METHOD_DURATION); 
   PyModule_AddIntConstant(module,"SORT_METHOD_TITLE",SORT_METHOD_TITLE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_TITLE_IGNORE_THE",SORT_METHOD_TITLE_IGNORE_THE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_ARTIST",SORT_METHOD_ARTIST); 
   PyModule_AddIntConstant(module,"SORT_METHOD_ARTIST_IGNORE_THE",SORT_METHOD_ARTIST_IGNORE_THE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_ALBUM",SORT_METHOD_ALBUM); 
   PyModule_AddIntConstant(module,"SORT_METHOD_ALBUM_IGNORE_THE",SORT_METHOD_ALBUM_IGNORE_THE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_GENRE",SORT_METHOD_GENRE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_VIDEO_YEAR",SORT_METHOD_YEAR); 
   PyModule_AddIntConstant(module,"SORT_METHOD_VIDEO_RATING",SORT_METHOD_VIDEO_RATING); 
   PyModule_AddIntConstant(module,"SORT_METHOD_PROGRAM_COUNT",SORT_METHOD_PROGRAM_COUNT); 
   PyModule_AddIntConstant(module,"SORT_METHOD_PLAYLIST_ORDER",SORT_METHOD_PLAYLIST_ORDER); 
   PyModule_AddIntConstant(module,"SORT_METHOD_EPISODE",SORT_METHOD_EPISODE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_VIDEO_TITLE",SORT_METHOD_VIDEO_TITLE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_VIDEO_SORT_TITLE",SORT_METHOD_VIDEO_SORT_TITLE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_VIDEO_SORT_TITLE_IGNORE_THE",SORT_METHOD_VIDEO_SORT_TITLE_IGNORE_THE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_PRODUCTIONCODE",SORT_METHOD_PRODUCTIONCODE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_SONG_RATING",SORT_METHOD_SONG_RATING); 
   PyModule_AddIntConstant(module,"SORT_METHOD_MPAA_RATING",SORT_METHOD_MPAA_RATING); 
   PyModule_AddIntConstant(module,"SORT_METHOD_VIDEO_RUNTIME",SORT_METHOD_VIDEO_RUNTIME); 
   PyModule_AddIntConstant(module,"SORT_METHOD_STUDIO",SORT_METHOD_STUDIO); 
   PyModule_AddIntConstant(module,"SORT_METHOD_STUDIO_IGNORE_THE",SORT_METHOD_STUDIO_IGNORE_THE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_UNSORTED",SORT_METHOD_UNSORTED); 
   PyModule_AddIntConstant(module,"SORT_METHOD_BITRATE",SORT_METHOD_BITRATE); 
   PyModule_AddIntConstant(module,"SORT_METHOD_LISTENERS",SORT_METHOD_LISTENERS); 
   PyModule_AddIntConstant(module,"SORT_METHOD_COUNTRY",SORT_METHOD_COUNTRY); 
   PyModule_AddIntConstant(module,"SORT_METHOD_DATEADDED",SORT_METHOD_DATEADDED); 
   PyModule_AddIntConstant(module,"SORT_METHOD_FULLPATH",SORT_METHOD_FULLPATH); 
   PyModule_AddIntConstant(module,"SORT_METHOD_LABEL_IGNORE_FOLDERS",SORT_METHOD_LABEL_IGNORE_FOLDERS); 
   PyModule_AddIntConstant(module,"SORT_METHOD_LASTPLAYED",SORT_METHOD_LASTPLAYED); 
   PyModule_AddIntConstant(module,"SORT_METHOD_PLAYCOUNT",SORT_METHOD_PLAYCOUNT); 
   PyModule_AddIntConstant(module,"SORT_METHOD_CHANNEL",SORT_METHOD_CHANNEL); 
   PyModule_AddIntConstant(module,"SORT_METHOD_DATE_TAKEN",SORT_METHOD_DATE_TAKEN); 
  }

} // end PythonBindings namespace for python type definitions
