/*	xcdbglog.c -- debug logging module for XC
	This file uses 4-character tabstops
*/

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/timeb.h>
#include <time.h>
#define NODEBUG 1 /* prevents unwanted recursion in this module */
#include "xc.h"

#if DEBUG
static FILE *dfp;

void
dbglog P_((void))
{
	time_t todnow;

	time(&todnow);
	if (!access("debug.log",0) && (dfp=fopen("debug.log","w")))
		setbuf(dfp, NIL(char)),
		fprintf(dfp,(char*)asctime(localtime(&todnow)));
	return;
}

int
Fputc(c, stream)
register c;
FILE *stream;
{
	if (!capture && dfp && c != '\r')
		fputc(c,dfp);
	return(fputc(c,stream));
}

int
Fputs(s, stream)
register char *s;
FILE *stream;
{
	if (!capture && dfp)
		fputs(s,dfp);
	return(fputs(s,stream));
}

#if _POSIX_SOURCE || __STDC__
#include <stdarg.h>
int
Fprintf(FILE *stream, const char *format, ...)
{
    int retcode;
    va_list arg;

    if (!capture && dfp) {
	va_start(arg, format);
	vfprintf(dfp, format, arg);
	va_end(arg);
    }

    va_start(arg, format);
    retcode = vfprintf(stream, format, arg);
    va_end(arg);

    return (retcode);
}

#else /* not posix */

int
Fprintf(stream, format, a, b, c, d, e, f, g)
FILE *stream;
char *format;
long a, b, c, d, e, f, g;
{
	if (!capture && dfp)
		fprintf(dfp,format,a,b,c,d,e,f,g);
	return(fprintf(stream,format,a,b,c,d,e,f,g));
}

#endif /*_POSIX_SOURCE || __STDC__*/

#endif /* DEBUG */

