/**************************************************************************
 * 
 * vdi_fill.c
 *
 * Hoover a file or device into a vdi.
 * You must first create the vdi with vdi_create.
 *
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include "blockstore.h"
#include "radix.h"
#include "requests-async.h"
#include "vdi.h"

int main(int argc, char *argv[])
{
    vdi_t       *vdi;
    uint64_t          id;
    int          fd;
    struct stat  st;
    uint64_t          tot_size;
    char         spage[BLOCK_SIZE];
    char        *dpage;
    uint64_t          vblock = 0, count=0;
    
    __init_blockstore();
    init_block_async();
    __init_vdi();
    
    if ( argc < 3 ) {
        printf("usage: %s <VDI id> <filename>\n", argv[0]);
        exit(-1);
    }
        
    id = (uint64_t) atoll(argv[1]);
    
    vdi = vdi_get( id );
    
    if ( vdi == NULL ) {
        printf("Failed to retreive VDI %Ld!\n", id);
        exit(-1);
    }
    
    fd = open(argv[2], O_RDONLY | O_LARGEFILE);
    
    if (fd < 0) {
        printf("Couldn't open %s!\n", argv[2]);
        exit(-1);
    }
    
    if ( fstat(fd, &st) != 0 ) {
        printf("Couldn't stat %s!\n", argv[2]);
        exit(-1);
    }
    
    tot_size = (uint64_t) st.st_size;
    printf("Filling VDI %Ld with %Ld bytes.\n", id, tot_size);
    
    printf("%011Ld blocks total\n", tot_size / BLOCK_SIZE);    
    printf("           ");
    while ( ( count = read(fd, spage, BLOCK_SIZE) ) > 0 ) {
        vdi_write_s(vdi, vblock, spage);
        
        vblock++;
        if ((vblock % 512) == 0)
        printf("\b\b\b\b\b\b\b\b\b\b\b%011Ld", vblock);
        fflush(stdout);
    }
    printf("\n");
    
    freeblock(vdi);
    
    return (0);
}
