/*
 *  Copyright (c) 2008 Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __XGM_PLUGIN_MENU_H__
#define __XGM_PLUGIN_MENU_H__

#define XGM_PLUGIN_TYPE_MENU               (xgm_plugin_menu_get_type())

#define XGM_PLUGIN_MENU(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), XGM_PLUGIN_TYPE_MENU, XgmPluginMenu))
#define XGM_PLUGIN_MENU_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), XGM_PLUGIN_TYPE_MENU, XgmPluginMenuClass))

#define XGM_PLUGIN_IS_MENU(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XGM_PLUGIN_TYPE_MENU))
#define XGM_PLUGIN_IS_MENU_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), XGM_PLUGIN_TYPE_MENU))

#define XGM_PLUGIN_MENU_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), XGM_PLUGIN_TYPE_MENU, XgmPluginMenuClass))

typedef struct _XgmPluginMenuClass         XgmPluginMenuClass;
typedef struct _XgmPluginMenu              XgmPluginMenu;
typedef struct _XgmPluginMenuPrivate       XgmPluginMenuPrivate;

struct _XgmPluginMenuClass
{
  GtkMenuClass           parent_class;
};

struct _XgmPluginMenu
{
  GtkMenu                parent;

  /* Private */
  XgmPluginMenuPrivate  *priv;
};

GType                   xgm_plugin_menu_get_type           ();

GtkWidget *             xgm_plugin_menu_new                ();

#endif /* !__XGM_PLUGIN_MENU_H__ */

