/*
 *  Copyright (c) 2008 Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __XGM_DAEMON_H__
#define __XGM_DAEMON_H__

#define XGM_TYPE_DAEMON               (xgm_daemon_get_type())

#define XGM_DAEMON(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), XGM_TYPE_DAEMON, XgmDaemon))
#define XGM_DAEMON_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), XGM_TYPE_DAEMON, XgmDaemonClass))

#define XGM_IS_DAEMON(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XGM_TYPE_DAEMON))
#define XGM_IS_DAEMON_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), XGM_TYPE_DAEMON))

#define XGM_DAEMON_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), XGM_TYPE_DAEMON, XgmDaemonClass))

typedef struct _XgmDaemonClass         XgmDaemonClass;
typedef struct _XgmDaemon              XgmDaemon;
typedef struct _XgmDaemonPrivate       XgmDaemonPrivate;

struct _XgmDaemonClass
{
  GObjectClass           parent_class;
};

struct _XgmDaemon
{
  GObject                parent;

  /* Private */
  XgmDaemonPrivate  *priv;
};

GType                   xgm_daemon_get_type           ();

XgmDaemon *             xgm_daemon_new_unique         (GError **error);

#endif /* !__XGM_DAEMON_H__ */

