/*
 *  Copyright (c) 2008-2009 Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <gtk/gtk.h>
#include <libxfce4util/libxfce4util.h>
#include <glade/glade.h>

#include "mount-dialog.h"
#include "utils.h"



/* Option entries */
static gboolean opt_version = FALSE;
static gchar *location = NULL;
static GOptionEntry option_entries[] =
{
    { "version", 'V', 0, G_OPTION_ARG_NONE, &opt_version, N_("Version information"), NULL },
    { "location", 'l', 0, G_OPTION_ARG_STRING, &location, N_("Remote file system location"), NULL },
    { NULL }
};



gint
main (gint argc,
      gchar *argv[])
{
  XgmMountDialog *dialog;
  GError *error = NULL;

  /* Init locale */
  xfce_textdomain (GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  /* Init GTK+ */
  if (!gtk_init_with_args (&argc, &argv, "[-l location]", option_entries, GETTEXT_PACKAGE, &error))
    {
      if (G_LIKELY (error))
        {
          g_print ("%s: %s.\n", PACKAGE_NAME, error->message);
          g_print ("Type '%s --help' for usage.", PACKAGE_NAME);
          g_print ("\n");
          g_error_free (error);
        }
      else
        g_error ("Unable to open display.");

      return EXIT_FAILURE;
    }

  /* Print version information */
  if (G_UNLIKELY (opt_version))
    {
      g_print ("%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
      return EXIT_SUCCESS;
    }

  /* Check for DBus */
  if (!xgm_check_dbus ())
    return EXIT_FAILURE;

  /* Dialog */
  dialog = xgm_mount_dialog_new ();
  if (location != NULL)
    g_object_set (dialog, "location", location, NULL);
  xgm_mount_dialog_run (dialog);

  /* Quit */
  g_object_unref (dialog);

  return EXIT_SUCCESS;
}

