/*
 *  Copyright (c) 2008 Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <gtk/gtk.h>
#include <libxfce4util/libxfce4util.h>

#include "daemon.h"



/* Option entries */
static gboolean opt_version = FALSE;
static GOptionEntry option_entries[] =
{
    { "version", 'v', 0, G_OPTION_ARG_NONE, &opt_version, N_("Version information"), NULL },
    { NULL }
};



gint
main (gint argc,
      gchar *argv[])
{
  XgmDaemon *daemon;
  GError *error = NULL;

  /* Init locale */
  xfce_textdomain (GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  /* Init GTK+ */
  if (!gtk_init_with_args (&argc, &argv, NULL, option_entries, GETTEXT_PACKAGE, &error))
    {
      if (G_LIKELY (error))
        {
          g_print ("%s: %s.\n", PACKAGE_NAME, error->message);
          g_print ("Type '%s --help' for usage.", PACKAGE_NAME);
          g_print ("\n");
          g_error_free (error);
        }
      else
        g_error ("Unable to open display.");

      return EXIT_FAILURE;
    }

  /* Print version information */
  if (G_UNLIKELY (opt_version))
    {
      g_print ("%s %s\n", "xfce4-gvfs-daemon", PACKAGE_VERSION);
      return EXIT_SUCCESS;
    }

  /* Daemon */
  daemon = xgm_daemon_new_unique (&error);
  if (daemon == NULL)
    {
      g_error ("Unable to start the Xfce4 GVfs daemon: %s", error->message);
      g_error_free (error);
      return 1;
    }

  /* Start */
  gtk_main ();

  /* Quit */
  g_object_unref (daemon);

  return EXIT_SUCCESS;
}

