/*
 *  Copyright (c) 2008-2009 Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef __XGM_MOUNT_DIALOG_H__
#define __XGM_MOUNT_DIALOG_H__

#define XGM_TYPE_MOUNT_DIALOG               (xgm_mount_dialog_get_type())

#define XGM_MOUNT_DIALOG(obj)               (G_TYPE_CHECK_INSTANCE_CAST ((obj), XGM_TYPE_MOUNT_DIALOG, XgmMountDialog))
#define XGM_MOUNT_DIALOG_CLASS(klass)       (G_TYPE_CHECK_CLASS_CAST ((klass), XGM_TYPE_MOUNT_DIALOG, XgmMountDialogClass))

#define XGM_IS_MOUNT_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XGM_TYPE_MOUNT_DIALOG))
#define XGM_IS_MOUNT_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_TYPE ((klass), XGM_TYPE_MOUNT_DIALOG))

#define XGM_MOUNT_DIALOG_GET_CLASS(obj)     (G_TYPE_INSTANCE_GET_CLASS ((obj), XGM_TYPE_MOUNT_DIALOG, XgmMountDialogClass))

typedef struct _XgmMountDialogClass         XgmMountDialogClass;
typedef struct _XgmMountDialog              XgmMountDialog;
typedef struct _XgmMountDialogPrivate       XgmMountDialogPrivate;

struct _XgmMountDialogClass
{
  GObjectClass           parent_class;
};

struct _XgmMountDialog
{
  GObject                parent;

  /* Private */
  XgmMountDialogPrivate  *priv;
};

GType                   xgm_mount_dialog_get_type           ();

XgmMountDialog *        xgm_mount_dialog_new                ();
gint                    xgm_mount_dialog_run                (XgmMountDialog *dialog);

#endif /* !__XGM_MOUNT_DIALOG_H__ */

