/*
 *  Copyright (c) 2008 Mike Massonnet <mmassonnet@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <libxfce4util/libxfce4util.h>
#include <libxfcegui4/libxfcegui4.h>

#include <dbus/dbus-glib.h>

#include "utils.h"

gboolean
xgm_check_dbus ()
{
  GError *error = NULL;
  DBusGConnection *dbus_conn;

  dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, &error);
  if (error != NULL)
    {
      xfce_err (_("Failed to open connection to bus: %s"), error->message);
      g_error_free (error);
      return FALSE;
    }

  return TRUE;
}

void
xgm_mount (const gchar *location)
{
  xgm_mount_with_password (location, NULL);
}

void
xgm_mount_with_password (const gchar *location,
                         const gchar *password)
{
  DBusGConnection *dbus_conn;
  DBusGProxy *proxy;

  dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, NULL);
  proxy = dbus_g_proxy_new_for_name (dbus_conn, "org.xfce.vfs.Daemon", "/org/xfce/vfs/Daemon", "org.xfce.vfs.Daemon");
  dbus_g_proxy_call (proxy, "Mount", NULL,
                     G_TYPE_STRING, location, G_TYPE_STRING, password, G_TYPE_INVALID,
                     G_TYPE_INVALID);

  g_object_unref (proxy);
}

void
xgm_unmount (const gchar *location)
{
  DBusGConnection *dbus_conn;
  DBusGProxy *proxy;

  dbus_conn = dbus_g_bus_get (DBUS_BUS_SESSION, NULL);
  proxy = dbus_g_proxy_new_for_name (dbus_conn, "org.xfce.vfs.Daemon", "/org/xfce/vfs/Daemon", "org.xfce.vfs.Daemon");
  dbus_g_proxy_call (proxy, "Unmount", NULL,
                     G_TYPE_STRING, location, G_TYPE_INVALID,
                     G_TYPE_INVALID);

  g_object_unref (proxy);
}

