/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xfsm-manager-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.xfce.Session.Manager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XfsmDbusManager
 * @title: XfsmDbusManager
 * @short_description: Generated C code for the org.xfce.Session.Manager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.xfce.Session.Manager ---- */

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_get_info_OUT_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_get_info_OUT_ARG_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_get_info_OUT_ARG_vendor =
{
  {
    -1,
    (gchar *) "vendor",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_get_info_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_get_info_OUT_ARG_name.parent_struct,
  &_xfsm_dbus_manager_method_info_get_info_OUT_ARG_version.parent_struct,
  &_xfsm_dbus_manager_method_info_get_info_OUT_ARG_vendor.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_get_info =
{
  {
    -1,
    (gchar *) "GetInfo",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_get_info_OUT_ARG_pointers,
    NULL
  },
  "handle-get-info",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_list_clients_OUT_ARG_clients =
{
  {
    -1,
    (gchar *) "clients",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_list_clients_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_list_clients_OUT_ARG_clients.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_list_clients =
{
  {
    -1,
    (gchar *) "ListClients",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_list_clients_OUT_ARG_pointers,
    NULL
  },
  "handle-list-clients",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_get_state_OUT_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_get_state_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_get_state_OUT_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_get_state =
{
  {
    -1,
    (gchar *) "GetState",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_get_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_checkpoint_IN_ARG_session_name =
{
  {
    -1,
    (gchar *) "session_name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_checkpoint_IN_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_checkpoint_IN_ARG_session_name.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_checkpoint =
{
  {
    -1,
    (gchar *) "Checkpoint",
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_checkpoint_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-checkpoint",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_logout_IN_ARG_show_dialog =
{
  {
    -1,
    (gchar *) "show_dialog",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_logout_IN_ARG_allow_save =
{
  {
    -1,
    (gchar *) "allow_save",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_logout_IN_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_logout_IN_ARG_show_dialog.parent_struct,
  &_xfsm_dbus_manager_method_info_logout_IN_ARG_allow_save.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_logout =
{
  {
    -1,
    (gchar *) "Logout",
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_logout_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-logout",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_shutdown_IN_ARG_allow_save =
{
  {
    -1,
    (gchar *) "allow_save",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_shutdown_IN_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_shutdown_IN_ARG_allow_save.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_shutdown =
{
  {
    -1,
    (gchar *) "Shutdown",
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_shutdown_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-shutdown",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_can_shutdown_OUT_ARG_can_shutdown =
{
  {
    -1,
    (gchar *) "can_shutdown",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_can_shutdown_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_can_shutdown_OUT_ARG_can_shutdown.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_can_shutdown =
{
  {
    -1,
    (gchar *) "CanShutdown",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_can_shutdown_OUT_ARG_pointers,
    NULL
  },
  "handle-can-shutdown",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_restart_IN_ARG_allow_save =
{
  {
    -1,
    (gchar *) "allow_save",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_restart_IN_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_restart_IN_ARG_allow_save.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_restart =
{
  {
    -1,
    (gchar *) "Restart",
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_restart_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-restart",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_can_restart_OUT_ARG_can_restart =
{
  {
    -1,
    (gchar *) "can_restart",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_can_restart_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_can_restart_OUT_ARG_can_restart.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_can_restart =
{
  {
    -1,
    (gchar *) "CanRestart",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_can_restart_OUT_ARG_pointers,
    NULL
  },
  "handle-can-restart",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_suspend =
{
  {
    -1,
    (gchar *) "Suspend",
    NULL,
    NULL,
    NULL
  },
  "handle-suspend",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_can_suspend_OUT_ARG_can_suspend =
{
  {
    -1,
    (gchar *) "can_suspend",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_can_suspend_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_can_suspend_OUT_ARG_can_suspend.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_can_suspend =
{
  {
    -1,
    (gchar *) "CanSuspend",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_can_suspend_OUT_ARG_pointers,
    NULL
  },
  "handle-can-suspend",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_hibernate =
{
  {
    -1,
    (gchar *) "Hibernate",
    NULL,
    NULL,
    NULL
  },
  "handle-hibernate",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_can_hibernate_OUT_ARG_can_hibernate =
{
  {
    -1,
    (gchar *) "can_hibernate",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_can_hibernate_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_can_hibernate_OUT_ARG_can_hibernate.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_can_hibernate =
{
  {
    -1,
    (gchar *) "CanHibernate",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_can_hibernate_OUT_ARG_pointers,
    NULL
  },
  "handle-can-hibernate",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_hybrid_sleep =
{
  {
    -1,
    (gchar *) "HybridSleep",
    NULL,
    NULL,
    NULL
  },
  "handle-hybrid-sleep",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_can_hybrid_sleep_OUT_ARG_can_hybrid_sleep =
{
  {
    -1,
    (gchar *) "can_hybrid_sleep",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_can_hybrid_sleep_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_can_hybrid_sleep_OUT_ARG_can_hybrid_sleep.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_can_hybrid_sleep =
{
  {
    -1,
    (gchar *) "CanHybridSleep",
    NULL,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_can_hybrid_sleep_OUT_ARG_pointers,
    NULL
  },
  "handle-can-hybrid-sleep",
  FALSE
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_switch_user =
{
  {
    -1,
    (gchar *) "SwitchUser",
    NULL,
    NULL,
    NULL
  },
  "handle-switch-user",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_register_client_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_register_client_IN_ARG_client_startup_id =
{
  {
    -1,
    (gchar *) "client_startup_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_register_client_IN_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_register_client_IN_ARG_app_id.parent_struct,
  &_xfsm_dbus_manager_method_info_register_client_IN_ARG_client_startup_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_register_client_OUT_ARG_client_id =
{
  {
    -1,
    (gchar *) "client_id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_register_client_OUT_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_register_client_OUT_ARG_client_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_register_client =
{
  {
    -1,
    (gchar *) "RegisterClient",
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_register_client_IN_ARG_pointers,
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_register_client_OUT_ARG_pointers,
    NULL
  },
  "handle-register-client",
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_method_info_unregister_client_IN_ARG_client_id =
{
  {
    -1,
    (gchar *) "client_id",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_method_info_unregister_client_IN_ARG_pointers[] =
{
  &_xfsm_dbus_manager_method_info_unregister_client_IN_ARG_client_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xfsm_dbus_manager_method_info_unregister_client =
{
  {
    -1,
    (gchar *) "UnregisterClient",
    (GDBusArgInfo **) &_xfsm_dbus_manager_method_info_unregister_client_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-unregister-client",
  FALSE
};

static const GDBusMethodInfo * const _xfsm_dbus_manager_method_info_pointers[] =
{
  &_xfsm_dbus_manager_method_info_get_info.parent_struct,
  &_xfsm_dbus_manager_method_info_list_clients.parent_struct,
  &_xfsm_dbus_manager_method_info_get_state.parent_struct,
  &_xfsm_dbus_manager_method_info_checkpoint.parent_struct,
  &_xfsm_dbus_manager_method_info_logout.parent_struct,
  &_xfsm_dbus_manager_method_info_shutdown.parent_struct,
  &_xfsm_dbus_manager_method_info_can_shutdown.parent_struct,
  &_xfsm_dbus_manager_method_info_restart.parent_struct,
  &_xfsm_dbus_manager_method_info_can_restart.parent_struct,
  &_xfsm_dbus_manager_method_info_suspend.parent_struct,
  &_xfsm_dbus_manager_method_info_can_suspend.parent_struct,
  &_xfsm_dbus_manager_method_info_hibernate.parent_struct,
  &_xfsm_dbus_manager_method_info_can_hibernate.parent_struct,
  &_xfsm_dbus_manager_method_info_hybrid_sleep.parent_struct,
  &_xfsm_dbus_manager_method_info_can_hybrid_sleep.parent_struct,
  &_xfsm_dbus_manager_method_info_switch_user.parent_struct,
  &_xfsm_dbus_manager_method_info_register_client.parent_struct,
  &_xfsm_dbus_manager_method_info_unregister_client.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_signal_info_state_changed_ARG_old_state =
{
  {
    -1,
    (gchar *) "old_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_signal_info_state_changed_ARG_new_state =
{
  {
    -1,
    (gchar *) "new_state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_signal_info_state_changed_ARG_pointers[] =
{
  &_xfsm_dbus_manager_signal_info_state_changed_ARG_old_state.parent_struct,
  &_xfsm_dbus_manager_signal_info_state_changed_ARG_new_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_manager_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_xfsm_dbus_manager_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const _ExtendedGDBusArgInfo _xfsm_dbus_manager_signal_info_client_registered_ARG_client =
{
  {
    -1,
    (gchar *) "client",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xfsm_dbus_manager_signal_info_client_registered_ARG_pointers[] =
{
  &_xfsm_dbus_manager_signal_info_client_registered_ARG_client.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_manager_signal_info_client_registered =
{
  {
    -1,
    (gchar *) "ClientRegistered",
    (GDBusArgInfo **) &_xfsm_dbus_manager_signal_info_client_registered_ARG_pointers,
    NULL
  },
  "client-registered"
};

static const _ExtendedGDBusSignalInfo _xfsm_dbus_manager_signal_info_shutdown_cancelled =
{
  {
    -1,
    (gchar *) "ShutdownCancelled",
    NULL,
    NULL
  },
  "shutdown-cancelled"
};

static const GDBusSignalInfo * const _xfsm_dbus_manager_signal_info_pointers[] =
{
  &_xfsm_dbus_manager_signal_info_state_changed.parent_struct,
  &_xfsm_dbus_manager_signal_info_client_registered.parent_struct,
  &_xfsm_dbus_manager_signal_info_shutdown_cancelled.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xfsm_dbus_manager_annotation_info_0 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.CSymbol",
  (gchar *) "xfsm_manager_dbus",
  NULL
};

static const GDBusAnnotationInfo _xfsm_dbus_manager_annotation_info_1 =
{
  -1,
  (gchar *) "org.freedesktop.DBus.GLib.ClientCSymbol",
  (gchar *) "xfsm_manager_dbus_client",
  NULL
};

static const GDBusAnnotationInfo * const _xfsm_dbus_manager_annotation_info_pointers[] =
{
  &_xfsm_dbus_manager_annotation_info_0,
  &_xfsm_dbus_manager_annotation_info_1,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xfsm_dbus_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.xfce.Session.Manager",
    (GDBusMethodInfo **) &_xfsm_dbus_manager_method_info_pointers,
    (GDBusSignalInfo **) &_xfsm_dbus_manager_signal_info_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xfsm_dbus_manager_annotation_info_pointers
  },
  "manager",
};


/**
 * xfsm_dbus_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xfsm_dbus_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xfsm_dbus_manager_interface_info.parent_struct;
}

/**
 * xfsm_dbus_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XfsmDbusManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xfsm_dbus_manager_override_properties (GObjectClass *klass, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XfsmDbusManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link>.
 */

/**
 * XfsmDbusManagerIface:
 * @parent_iface: The parent interface.
 * @handle_can_hibernate: Handler for the #XfsmDbusManager::handle-can-hibernate signal.
 * @handle_can_hybrid_sleep: Handler for the #XfsmDbusManager::handle-can-hybrid-sleep signal.
 * @handle_can_restart: Handler for the #XfsmDbusManager::handle-can-restart signal.
 * @handle_can_shutdown: Handler for the #XfsmDbusManager::handle-can-shutdown signal.
 * @handle_can_suspend: Handler for the #XfsmDbusManager::handle-can-suspend signal.
 * @handle_checkpoint: Handler for the #XfsmDbusManager::handle-checkpoint signal.
 * @handle_get_info: Handler for the #XfsmDbusManager::handle-get-info signal.
 * @handle_get_state: Handler for the #XfsmDbusManager::handle-get-state signal.
 * @handle_hibernate: Handler for the #XfsmDbusManager::handle-hibernate signal.
 * @handle_hybrid_sleep: Handler for the #XfsmDbusManager::handle-hybrid-sleep signal.
 * @handle_list_clients: Handler for the #XfsmDbusManager::handle-list-clients signal.
 * @handle_logout: Handler for the #XfsmDbusManager::handle-logout signal.
 * @handle_register_client: Handler for the #XfsmDbusManager::handle-register-client signal.
 * @handle_restart: Handler for the #XfsmDbusManager::handle-restart signal.
 * @handle_shutdown: Handler for the #XfsmDbusManager::handle-shutdown signal.
 * @handle_suspend: Handler for the #XfsmDbusManager::handle-suspend signal.
 * @handle_switch_user: Handler for the #XfsmDbusManager::handle-switch-user signal.
 * @handle_unregister_client: Handler for the #XfsmDbusManager::handle-unregister-client signal.
 * @client_registered: Handler for the #XfsmDbusManager::client-registered signal.
 * @shutdown_cancelled: Handler for the #XfsmDbusManager::shutdown-cancelled signal.
 * @state_changed: Handler for the #XfsmDbusManager::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link>.
 */

typedef XfsmDbusManagerIface XfsmDbusManagerInterface;
G_DEFINE_INTERFACE (XfsmDbusManager, xfsm_dbus_manager, G_TYPE_OBJECT)

static void
xfsm_dbus_manager_default_init (XfsmDbusManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XfsmDbusManager::handle-get-info:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.GetInfo">GetInfo()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_get_info() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-info",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_get_info),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-list-clients:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.ListClients">ListClients()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_list_clients() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list-clients",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_list_clients),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-get-state:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.GetState">GetState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_get_state() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_get_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-checkpoint:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.Checkpoint">Checkpoint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_checkpoint() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-checkpoint",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_checkpoint),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * XfsmDbusManager::handle-logout:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_show_dialog: Argument passed by remote caller.
   * @arg_allow_save: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.Logout">Logout()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_logout() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-logout",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_logout),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);

  /**
   * XfsmDbusManager::handle-shutdown:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_allow_save: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.Shutdown">Shutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * XfsmDbusManager::handle-can-shutdown:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.CanShutdown">CanShutdown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_can_shutdown() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-shutdown",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_can_shutdown),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-restart:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_allow_save: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.Restart">Restart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_restart() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-restart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_restart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_BOOLEAN);

  /**
   * XfsmDbusManager::handle-can-restart:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.CanRestart">CanRestart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_can_restart() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-restart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_can_restart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-suspend:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.Suspend">Suspend()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_suspend() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-suspend",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_suspend),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-can-suspend:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.CanSuspend">CanSuspend()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_can_suspend() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-suspend",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_can_suspend),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-hibernate:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.Hibernate">Hibernate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_hibernate() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hibernate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_hibernate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-can-hibernate:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHibernate">CanHibernate()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_can_hibernate() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-hibernate",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_can_hibernate),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-hybrid-sleep:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.HybridSleep">HybridSleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_hybrid_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hybrid-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_hybrid_sleep),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-can-hybrid-sleep:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_can_hybrid_sleep() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-can-hybrid-sleep",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_can_hybrid_sleep),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-switch-user:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.SwitchUser">SwitchUser()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_switch_user() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-switch-user",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_switch_user),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XfsmDbusManager::handle-register-client:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_client_startup_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.RegisterClient">RegisterClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_register_client() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-register-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_register_client),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XfsmDbusManager::handle-unregister-client:
   * @object: A #XfsmDbusManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_client_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-xfce-Session-Manager.UnregisterClient">UnregisterClient()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xfsm_dbus_manager_complete_unregister_client() or e.g. g_dbus_method_invocation_return_error() on it) and no order signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %TRUE if the invocation was handled, %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-unregister-client",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, handle_unregister_client),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XfsmDbusManager::state-changed:
   * @object: A #XfsmDbusManager.
   * @arg_old_state: Argument.
   * @arg_new_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Manager.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_UINT, G_TYPE_UINT);

  /**
   * XfsmDbusManager::client-registered:
   * @object: A #XfsmDbusManager.
   * @arg_client: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Manager.ClientRegistered">"ClientRegistered"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("client-registered",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, client_registered),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    1, G_TYPE_STRING);

  /**
   * XfsmDbusManager::shutdown-cancelled:
   * @object: A #XfsmDbusManager.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-xfce-Session-Manager.ShutdownCancelled">"ShutdownCancelled"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("shutdown-cancelled",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XfsmDbusManagerIface, shutdown_cancelled),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * xfsm_dbus_manager_emit_state_changed:
 * @object: A #XfsmDbusManager.
 * @arg_old_state: Argument to pass with the signal.
 * @arg_new_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Manager.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
xfsm_dbus_manager_emit_state_changed (
    XfsmDbusManager *object,
    guint arg_old_state,
    guint arg_new_state)
{
  g_signal_emit_by_name (object, "state-changed", arg_old_state, arg_new_state);
}

/**
 * xfsm_dbus_manager_emit_client_registered:
 * @object: A #XfsmDbusManager.
 * @arg_client: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Manager.ClientRegistered">"ClientRegistered"</link> D-Bus signal.
 */
void
xfsm_dbus_manager_emit_client_registered (
    XfsmDbusManager *object,
    const gchar *arg_client)
{
  g_signal_emit_by_name (object, "client-registered", arg_client);
}

/**
 * xfsm_dbus_manager_emit_shutdown_cancelled:
 * @object: A #XfsmDbusManager.
 *
 * Emits the <link linkend="gdbus-signal-org-xfce-Session-Manager.ShutdownCancelled">"ShutdownCancelled"</link> D-Bus signal.
 */
void
xfsm_dbus_manager_emit_shutdown_cancelled (
    XfsmDbusManager *object)
{
  g_signal_emit_by_name (object, "shutdown-cancelled");
}

/**
 * xfsm_dbus_manager_call_get_info:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.GetInfo">GetInfo()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_get_info_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_get_info_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_get_info (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetInfo",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_get_info_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vendor: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_get_info().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_get_info().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_get_info_finish (
    XfsmDbusManager *proxy,
    gchar **out_name,
    gchar **out_version,
    gchar **out_vendor,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(sss)",
                 out_name,
                 out_version,
                 out_vendor);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_get_info_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_name: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_version: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_vendor: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.GetInfo">GetInfo()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_get_info() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_get_info_sync (
    XfsmDbusManager *proxy,
    gchar **out_name,
    gchar **out_version,
    gchar **out_vendor,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetInfo",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(sss)",
                 out_name,
                 out_version,
                 out_vendor);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_list_clients:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.ListClients">ListClients()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_list_clients_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_list_clients_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_list_clients (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ListClients",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_list_clients_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_clients: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_list_clients().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_list_clients().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_list_clients_finish (
    XfsmDbusManager *proxy,
    gchar ***out_clients,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_clients);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_list_clients_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_clients: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.ListClients">ListClients()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_list_clients() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_list_clients_sync (
    XfsmDbusManager *proxy,
    gchar ***out_clients,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ListClients",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_clients);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_get_state:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.GetState">GetState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_get_state_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_get_state_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_get_state (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_get_state_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_get_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_get_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_get_state_finish (
    XfsmDbusManager *proxy,
    guint *out_state,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_get_state_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_state: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.GetState">GetState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_get_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_get_state_sync (
    XfsmDbusManager *proxy,
    guint *out_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_state);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_checkpoint:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Checkpoint">Checkpoint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_checkpoint_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_checkpoint_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_checkpoint (
    XfsmDbusManager *proxy,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Checkpoint",
    g_variant_new ("(s)",
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_checkpoint_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_checkpoint().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_checkpoint().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_checkpoint_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_checkpoint_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_session_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Checkpoint">Checkpoint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_checkpoint() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_checkpoint_sync (
    XfsmDbusManager *proxy,
    const gchar *arg_session_name,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Checkpoint",
    g_variant_new ("(s)",
                   arg_session_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_logout:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_show_dialog: Argument to pass with the method invocation.
 * @arg_allow_save: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Logout">Logout()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_logout_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_logout_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_logout (
    XfsmDbusManager *proxy,
    gboolean arg_show_dialog,
    gboolean arg_allow_save,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Logout",
    g_variant_new ("(bb)",
                   arg_show_dialog,
                   arg_allow_save),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_logout_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_logout().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_logout().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_logout_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_logout_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_show_dialog: Argument to pass with the method invocation.
 * @arg_allow_save: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Logout">Logout()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_logout() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_logout_sync (
    XfsmDbusManager *proxy,
    gboolean arg_show_dialog,
    gboolean arg_allow_save,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Logout",
    g_variant_new ("(bb)",
                   arg_show_dialog,
                   arg_allow_save),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_shutdown:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_allow_save: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Shutdown">Shutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_shutdown_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_shutdown (
    XfsmDbusManager *proxy,
    gboolean arg_allow_save,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Shutdown",
    g_variant_new ("(b)",
                   arg_allow_save),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_shutdown_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_shutdown_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_shutdown_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_allow_save: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Shutdown">Shutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_shutdown_sync (
    XfsmDbusManager *proxy,
    gboolean arg_allow_save,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Shutdown",
    g_variant_new ("(b)",
                   arg_allow_save),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_shutdown:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanShutdown">CanShutdown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_can_shutdown_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_can_shutdown_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_can_shutdown (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_can_shutdown_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_shutdown: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_can_shutdown().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_can_shutdown().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_shutdown_finish (
    XfsmDbusManager *proxy,
    gboolean *out_can_shutdown,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_shutdown);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_shutdown_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_shutdown: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanShutdown">CanShutdown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_can_shutdown() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_shutdown_sync (
    XfsmDbusManager *proxy,
    gboolean *out_can_shutdown,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanShutdown",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_shutdown);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_restart:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_allow_save: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Restart">Restart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_restart_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_restart_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_restart (
    XfsmDbusManager *proxy,
    gboolean arg_allow_save,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Restart",
    g_variant_new ("(b)",
                   arg_allow_save),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_restart_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_restart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_restart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_restart_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_restart_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_allow_save: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Restart">Restart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_restart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_restart_sync (
    XfsmDbusManager *proxy,
    gboolean arg_allow_save,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Restart",
    g_variant_new ("(b)",
                   arg_allow_save),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_restart:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanRestart">CanRestart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_can_restart_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_can_restart_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_can_restart (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanRestart",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_can_restart_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_restart: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_can_restart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_can_restart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_restart_finish (
    XfsmDbusManager *proxy,
    gboolean *out_can_restart,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_restart);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_restart_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_restart: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanRestart">CanRestart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_can_restart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_restart_sync (
    XfsmDbusManager *proxy,
    gboolean *out_can_restart,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanRestart",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_restart);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_suspend:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Suspend">Suspend()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_suspend_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_suspend_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_suspend (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Suspend",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_suspend_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_suspend().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_suspend().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_suspend_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_suspend_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Suspend">Suspend()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_suspend() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_suspend_sync (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Suspend",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_suspend:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanSuspend">CanSuspend()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_can_suspend_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_can_suspend_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_can_suspend (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanSuspend",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_can_suspend_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_suspend: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_can_suspend().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_can_suspend().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_suspend_finish (
    XfsmDbusManager *proxy,
    gboolean *out_can_suspend,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_suspend);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_suspend_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_suspend: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanSuspend">CanSuspend()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_can_suspend() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_suspend_sync (
    XfsmDbusManager *proxy,
    gboolean *out_can_suspend,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanSuspend",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_suspend);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_hibernate:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Hibernate">Hibernate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_hibernate_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_hibernate_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_hibernate (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Hibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_hibernate_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_hibernate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_hibernate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_hibernate_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_hibernate_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.Hibernate">Hibernate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_hibernate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_hibernate_sync (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Hibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_hibernate:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHibernate">CanHibernate()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_can_hibernate_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_can_hibernate_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_can_hibernate (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanHibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_can_hibernate_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_hibernate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_can_hibernate().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_can_hibernate().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_hibernate_finish (
    XfsmDbusManager *proxy,
    gboolean *out_can_hibernate,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_hibernate);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_hibernate_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_hibernate: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHibernate">CanHibernate()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_can_hibernate() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_hibernate_sync (
    XfsmDbusManager *proxy,
    gboolean *out_can_hibernate,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanHibernate",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_hibernate);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_hybrid_sleep:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.HybridSleep">HybridSleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_hybrid_sleep_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_hybrid_sleep_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_hybrid_sleep (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HybridSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_hybrid_sleep_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_hybrid_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_hybrid_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_hybrid_sleep_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_hybrid_sleep_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.HybridSleep">HybridSleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_hybrid_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_hybrid_sleep_sync (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HybridSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_hybrid_sleep:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_can_hybrid_sleep_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_can_hybrid_sleep_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_can_hybrid_sleep (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CanHybridSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_can_hybrid_sleep_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_hybrid_sleep: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_can_hybrid_sleep().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_can_hybrid_sleep().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_hybrid_sleep_finish (
    XfsmDbusManager *proxy,
    gboolean *out_can_hybrid_sleep,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_hybrid_sleep);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_can_hybrid_sleep_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_can_hybrid_sleep: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_can_hybrid_sleep() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_can_hybrid_sleep_sync (
    XfsmDbusManager *proxy,
    gboolean *out_can_hybrid_sleep,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CanHybridSleep",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_can_hybrid_sleep);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_switch_user:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.SwitchUser">SwitchUser()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_switch_user_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_switch_user_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_switch_user (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwitchUser",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_switch_user_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_switch_user().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_switch_user().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_switch_user_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_switch_user_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.SwitchUser">SwitchUser()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_switch_user() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_switch_user_sync (
    XfsmDbusManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwitchUser",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_register_client:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_client_startup_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.RegisterClient">RegisterClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_register_client_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_register_client_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_register_client (
    XfsmDbusManager *proxy,
    const gchar *arg_app_id,
    const gchar *arg_client_startup_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RegisterClient",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_client_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_register_client_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @out_client_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_register_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_register_client().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_register_client_finish (
    XfsmDbusManager *proxy,
    gchar **out_client_id,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_register_client_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_client_startup_id: Argument to pass with the method invocation.
 * @out_client_id: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.RegisterClient">RegisterClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_register_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_register_client_sync (
    XfsmDbusManager *proxy,
    const gchar *arg_app_id,
    const gchar *arg_client_startup_id,
    gchar **out_client_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RegisterClient",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_client_startup_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_client_id);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_unregister_client:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_client_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.UnregisterClient">UnregisterClient()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_call_unregister_client_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_call_unregister_client_sync() for the synchronous, blocking version of this method.
 */
void
xfsm_dbus_manager_call_unregister_client (
    XfsmDbusManager *proxy,
    const gchar *arg_client_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UnregisterClient",
    g_variant_new ("(o)",
                   arg_client_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xfsm_dbus_manager_call_unregister_client_finish:
 * @proxy: A #XfsmDbusManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_call_unregister_client().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xfsm_dbus_manager_call_unregister_client().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_unregister_client_finish (
    XfsmDbusManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_call_unregister_client_sync:
 * @proxy: A #XfsmDbusManagerProxy.
 * @arg_client_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-xfce-Session-Manager.UnregisterClient">UnregisterClient()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_call_unregister_client() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xfsm_dbus_manager_call_unregister_client_sync (
    XfsmDbusManager *proxy,
    const gchar *arg_client_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UnregisterClient",
    g_variant_new ("(o)",
                   arg_client_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xfsm_dbus_manager_complete_get_info:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @name: Parameter to return.
 * @version: Parameter to return.
 * @vendor: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.GetInfo">GetInfo()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_get_info (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    const gchar *name,
    const gchar *version,
    const gchar *vendor)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(sss)",
                   name,
                   version,
                   vendor));
}

/**
 * xfsm_dbus_manager_complete_list_clients:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @clients: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.ListClients">ListClients()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_list_clients (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    const gchar *const *clients)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   clients));
}

/**
 * xfsm_dbus_manager_complete_get_state:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @state: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.GetState">GetState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_get_state (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    guint state)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   state));
}

/**
 * xfsm_dbus_manager_complete_checkpoint:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.Checkpoint">Checkpoint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_checkpoint (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_logout:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.Logout">Logout()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_logout (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_shutdown:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.Shutdown">Shutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_shutdown (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_can_shutdown:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @can_shutdown: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.CanShutdown">CanShutdown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_can_shutdown (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    gboolean can_shutdown)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   can_shutdown));
}

/**
 * xfsm_dbus_manager_complete_restart:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.Restart">Restart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_restart (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_can_restart:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @can_restart: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.CanRestart">CanRestart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_can_restart (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    gboolean can_restart)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   can_restart));
}

/**
 * xfsm_dbus_manager_complete_suspend:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.Suspend">Suspend()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_suspend (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_can_suspend:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @can_suspend: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.CanSuspend">CanSuspend()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_can_suspend (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    gboolean can_suspend)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   can_suspend));
}

/**
 * xfsm_dbus_manager_complete_hibernate:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.Hibernate">Hibernate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_hibernate (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_can_hibernate:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @can_hibernate: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHibernate">CanHibernate()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_can_hibernate (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    gboolean can_hibernate)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   can_hibernate));
}

/**
 * xfsm_dbus_manager_complete_hybrid_sleep:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.HybridSleep">HybridSleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_hybrid_sleep (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_can_hybrid_sleep:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @can_hybrid_sleep: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.CanHybridSleep">CanHybridSleep()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_can_hybrid_sleep (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    gboolean can_hybrid_sleep)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   can_hybrid_sleep));
}

/**
 * xfsm_dbus_manager_complete_switch_user:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.SwitchUser">SwitchUser()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_switch_user (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xfsm_dbus_manager_complete_register_client:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @client_id: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.RegisterClient">RegisterClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_register_client (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation,
    const gchar *client_id)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   client_id));
}

/**
 * xfsm_dbus_manager_complete_unregister_client:
 * @object: A #XfsmDbusManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-xfce-Session-Manager.UnregisterClient">UnregisterClient()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xfsm_dbus_manager_complete_unregister_client (
    XfsmDbusManager *object,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XfsmDbusManagerProxy:
 *
 * The #XfsmDbusManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfsmDbusManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfsmDbusManagerProxy.
 */

struct _XfsmDbusManagerProxyPrivate
{
  GData *qdata;
};

static void xfsm_dbus_manager_proxy_iface_init (XfsmDbusManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfsmDbusManagerProxy, xfsm_dbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XfsmDbusManagerProxy)
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_MANAGER, xfsm_dbus_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfsmDbusManagerProxy, xfsm_dbus_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_MANAGER, xfsm_dbus_manager_proxy_iface_init))

#endif
static void
xfsm_dbus_manager_proxy_finalize (GObject *object)
{
  XfsmDbusManagerProxy *proxy = XFSM_DBUS_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xfsm_dbus_manager_proxy_parent_class)->finalize (object);
}

static void
xfsm_dbus_manager_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfsm_dbus_manager_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xfsm_dbus_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xfsm_dbus_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XFSM_DBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFSM_DBUS_TYPE_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xfsm_dbus_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XfsmDbusManagerProxy *proxy = XFSM_DBUS_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xfsm_dbus_manager_proxy_init (XfsmDbusManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xfsm_dbus_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XFSM_DBUS_TYPE_MANAGER_PROXY, XfsmDbusManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xfsm_dbus_manager_interface_info ());
}

static void
xfsm_dbus_manager_proxy_class_init (XfsmDbusManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xfsm_dbus_manager_proxy_finalize;
  gobject_class->get_property = xfsm_dbus_manager_proxy_get_property;
  gobject_class->set_property = xfsm_dbus_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xfsm_dbus_manager_proxy_g_signal;
  proxy_class->g_properties_changed = xfsm_dbus_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfsmDbusManagerProxyPrivate));
#endif
}

static void
xfsm_dbus_manager_proxy_iface_init (XfsmDbusManagerIface *iface)
{
}

/**
 * xfsm_dbus_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_proxy_new_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xfsm_dbus_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFSM_DBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Manager", NULL);
}

/**
 * xfsm_dbus_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfsm_dbus_manager_proxy_new().
 *
 * Returns: (transfer full) (type XfsmDbusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusManager *
xfsm_dbus_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFSM_DBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * xfsm_dbus_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfsmDbusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusManager *
xfsm_dbus_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFSM_DBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Manager", NULL);
  if (ret != NULL)
    return XFSM_DBUS_MANAGER (ret);
  else
    return NULL;
}


/**
 * xfsm_dbus_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xfsm_dbus_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xfsm_dbus_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xfsm_dbus_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xfsm_dbus_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XFSM_DBUS_TYPE_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Manager", NULL);
}

/**
 * xfsm_dbus_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xfsm_dbus_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xfsm_dbus_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XfsmDbusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusManager *
xfsm_dbus_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XFSM_DBUS_MANAGER (ret);
  else
    return NULL;
}

/**
 * xfsm_dbus_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xfsm_dbus_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xfsm_dbus_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XfsmDbusManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
XfsmDbusManager *
xfsm_dbus_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XFSM_DBUS_TYPE_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.xfce.Session.Manager", NULL);
  if (ret != NULL)
    return XFSM_DBUS_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XfsmDbusManagerSkeleton:
 *
 * The #XfsmDbusManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XfsmDbusManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XfsmDbusManagerSkeleton.
 */

struct _XfsmDbusManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xfsm_dbus_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XFSM_DBUS_TYPE_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XFSM_DBUS_TYPE_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xfsm_dbus_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xfsm_dbus_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xfsm_dbus_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xfsm_dbus_manager_skeleton_vtable =
{
  _xfsm_dbus_manager_skeleton_handle_method_call,
  _xfsm_dbus_manager_skeleton_handle_get_property,
  _xfsm_dbus_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xfsm_dbus_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xfsm_dbus_manager_interface_info ();
}

static GDBusInterfaceVTable *
xfsm_dbus_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xfsm_dbus_manager_skeleton_vtable;
}

static GVariant *
xfsm_dbus_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xfsm_dbus_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xfsm_dbus_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xfsm_dbus_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xfsm_dbus_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Manager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xfsm_dbus_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
}

static void
_xfsm_dbus_manager_on_signal_state_changed (
    XfsmDbusManager *object,
    guint arg_old_state,
    guint arg_new_state)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(uu)",
                   arg_old_state,
                   arg_new_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Manager", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_manager_on_signal_client_registered (
    XfsmDbusManager *object,
    const gchar *arg_client)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_client));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Manager", "ClientRegistered",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_xfsm_dbus_manager_on_signal_shutdown_cancelled (
    XfsmDbusManager *object)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.xfce.Session.Manager", "ShutdownCancelled",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xfsm_dbus_manager_skeleton_iface_init (XfsmDbusManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XfsmDbusManagerSkeleton, xfsm_dbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XfsmDbusManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_MANAGER, xfsm_dbus_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XfsmDbusManagerSkeleton, xfsm_dbus_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XFSM_DBUS_TYPE_MANAGER, xfsm_dbus_manager_skeleton_iface_init))

#endif
static void
xfsm_dbus_manager_skeleton_finalize (GObject *object)
{
  XfsmDbusManagerSkeleton *skeleton = XFSM_DBUS_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xfsm_dbus_manager_skeleton_parent_class)->finalize (object);
}

static void
xfsm_dbus_manager_skeleton_init (XfsmDbusManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xfsm_dbus_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XFSM_DBUS_TYPE_MANAGER_SKELETON, XfsmDbusManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xfsm_dbus_manager_skeleton_class_init (XfsmDbusManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xfsm_dbus_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xfsm_dbus_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xfsm_dbus_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xfsm_dbus_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xfsm_dbus_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XfsmDbusManagerSkeletonPrivate));
#endif
}

static void
xfsm_dbus_manager_skeleton_iface_init (XfsmDbusManagerIface *iface)
{
  iface->state_changed = _xfsm_dbus_manager_on_signal_state_changed;
  iface->client_registered = _xfsm_dbus_manager_on_signal_client_registered;
  iface->shutdown_cancelled = _xfsm_dbus_manager_on_signal_shutdown_cancelled;
}

/**
 * xfsm_dbus_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-xfce-Session-Manager.top_of_page">org.xfce.Session.Manager</link>.
 *
 * Returns: (transfer full) (type XfsmDbusManagerSkeleton): The skeleton object.
 */
XfsmDbusManager *
xfsm_dbus_manager_skeleton_new (void)
{
  return XFSM_DBUS_MANAGER (g_object_new (XFSM_DBUS_TYPE_MANAGER_SKELETON, NULL));
}

