%define name	xine-ui
%define version	0.9.13
%define release	1

%define major   0
%define libname libxine%{major}

%define skindir	 %(xine-config --skindir)
%define deskdir	 %(xine-config --desktopdir)

%define	ginstall install -c

Name:        %{name}
Summary:     A Free Audio/Video Player.
Summary(cs): Voln iiteln audio/video pehrva
Summary(de): Ein freies Audio- und Video-Abspielprogramm
Version:     %{version}
Release:     %{release}
Copyright:   GPL
Group:       Applications/Multimedia
Source:      http://xine.sourceforge.net/files/%{name}-%{version}.tar.gz
URL:         http://xine.sourceforge.net/
Packager:    Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
Requires:    %{libname} >= %{version}
BuildPreReq: %{libname}-devel >= %{version}
BuildRoot:   %{_tmppath}/%{name}-buildroot

%description
xine is a fully-featured free audio/video player for unix-like systems which
uses libxine for audio/video decoding and playback. For more informations on
what formats are supported, please refer to the libxine documentation.

%description -l cs
xine je velmi atraktivn voln iiteln audio/video pehrva pro unixovsk
systmy, kter pouv libxine pro dekdovn zvuku a videa a pehrvn.
Vce informac o tom, jak formty jsou podporovny zskte v dokumentaci
od libxine.

%description -l de
xine ist ein funktionsreiches, freies Audio- und Video-Abspielprogramm fr
Unix-basierende Systeme, welches die xine-Bibliothek libxine fr Audio- und
Videodekodierung, sowie -wiedergabe verwendet. Um mehr Informationen ber die
untersttzten Formate zu erhalten, lesen Sie bitte in der Dokumentation der
xine-Bibliothek libxine nach.

%prep
%setup -n %{name}-%{version}

%build
if [ ! -f configure ]; then
   NO_CONFIGURE=1 ./cvscompile.sh
fi

#
# currently we do not use %%configure as it seems to cause trouble with
# certain automake produced configure scripts - depending on automake version.
#
./configure --build=%{_target_platform} --prefix=%{_prefix} \
	    --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} \
	    --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} \
	    --datadir=%{_datadir} --includedir=%{_includedir} \
	    --libdir=%{_libdir} --libexecdir=%{_libexecdir} \
	    --localstatedir=%{_localstatedir} \
	    --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} \
	    --infodir=%{_infodir}
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=%{?buildroot:%{buildroot}} install

%post
if test -d %{skindir}/metal; then rm -rf %{skindir}/metal; fi
if test -d %{skindir}/default; then rm -rf %{skindir}/default && ln -s %{skindir}/xinetic %{skindir}/default; fi

if test ! -d %{_datadir}/icons; then
  %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/icons
fi
%{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.xpm %{_datadir}/icons/xine.xpm
if test ! -d %{_datadir}/pixmaps; then
  %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/pixmaps
fi
%{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.xpm %{_datadir}/pixmaps/xine.xpm
if test -d %{_sysconfdir}/X11/wmconfig; then
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.wmconfig %{_sysconfdir}/X11/wmconfig/xine
fi
if test -d %{_sysconfdir}/X11/applnk; then
  if test ! -d %{_sysconfdir}/X11/applnk/Multimedia; then
    %{ginstall} -m 755 -o 0 -g 0 -d %{_sysconfdir}/X11/applnk/Multimedia
  fi
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_sysconfdir}/X11/applnk/Multimedia/xine.desktop
fi
# End Icons
# Gnome
if test -d /opt/gnome; then
  if test ! -d /opt/gnome/share/pixmaps; then
    %{ginstall} -m 755 -o 0 -g 0 -d /opt/gnome/share/pixmaps
  fi
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.xpm /opt/gnome/share/pixmaps/xine.xpm
  if test -d /opt/gnome/share/gnome/apps/Multimedia; then
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/gnome/share/gnome/apps/Multimedia/xine.desktop
  else
    %{ginstall} -m 755 -o 0 -g 0 -d /opt/gnome/share/gnome/apps/Multimedia
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/gnome/share/gnome/apps/Multimedia/xine.desktop
  fi
else
  if test -d %{_datadir}/gnome/apps; then
    if test -d %{_datadir}/gnome/apps/Multimedia; then
      %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/gnome/apps/Multimedia/xine.desktop
    else
      %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/gnome/apps/Multimedia
      %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/gnome/apps/Multimedia/xine.desktop
    fi
  fi
fi
# End Gnome
# Kde3
if test -d /opt/kde3/; then
  DIR_HI3=/opt/kde3/share/icons/hicolor
  DIR_LO3=/opt/kde3/share/icons/locolor
  HIRES3='48x48 32x32 22x22'
  LORES3='32x32 22x22 16x16'
  for hires in $HIRES3; do
    %{ginstall} -m 755 -o 0 -g 0 -d $DIR_HI3/$hires/apps
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine_$hires.png $DIR_HI3/$hires/apps/xine.png
  done
  for lores in $LORES3; do
    %{ginstall} -m 755 -o 0 -g 0 -d $DIR_LO3/$lores/apps
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine_$lores.png $DIR_LO3/$lores/apps/xine.png
  done
  if test ! -d /opt/kde3/share/applnk/Multimedia; then
    %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde3/share/applnk/Multimedia
  fi
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/kde3/share/applnk/Multimedia/xine.desktop
  cat /opt/kde3/share/applnk/Multimedia/xine.desktop | sed -e "s/xine.xpm/\xine/g" > /opt/kde3/share/applnk/Multimedia/xine.desktop
fi
# End Kde3
# Kde2
if test -d /opt/kde2/; then
  DIR_HI=/opt/kde2/share/icons/hicolor
  DIR_LO=/opt/kde2/share/icons/locolor
  HIRES='48x48 32x32 22x22'
  LORES='32x32 22x22 16x16'
  for hires in $HIRES; do
    %{ginstall} -m 755 -o 0 -g 0 -d $DIR_HI/$hires/apps
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine_$hires.png $DIR_HI/$hires/apps/xine.png
  done
  for lores in $LORES; do
    %{ginstall} -m 755 -o 0 -g 0 -d $DIR_LO/$lores/apps
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine_$lores.png $DIR_LO/$lores/apps/xine.png
  done
  if test ! -d /opt/kde2/share/applnk/Multimedia; then
    %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde2/share/applnk/Multimedia
  fi
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/kde2/share/applnk/Multimedia/xine.desktop
  cat /opt/kde2/share/applnk/Multimedia/xine.desktop | sed -e "s/xine.xpm/\xine/g" > /opt/kde2/share/applnk/Multimedia/xine.desktop
else
  if test -d %{_datadir}/applnk/Multimedia; then
    if test ! -d %{_datadir}/applnk/Multimedia; then
      %{ginstall} -m 755 -o 0 -g 0 -d %{_datadir}/applnk/Multimedia
    fi
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/applnk/Multimedia/xine.desktop
  fi
fi
# End Kde2
# Kde
if test -d /opt/kde; then
  if test ! -d /opt/kde/share/icons; then
    %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde/share/icons
  fi
  if test ! -d /opt/kde/share/applnk/Multimedia; then
    %{ginstall} -m 755 -o 0 -g 0 -d /opt/kde/share/applnk/Multimedia
  fi
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.xpm /opt/kde/share/icons/xine.xpm
  %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop /opt/kde/share/applnk/Multimedia/xine.desktop
else
  if test -d %{_datadir}/applnk/Multimedia; then
    %{ginstall} -m 644 -o 0 -g 0 %{deskdir}/xine.desktop %{_datadir}/applnk/Multimedia/xine.desktop
  fi
fi
# End Kde

%preun
  DIR_HI=/opt/kde2/share/icons/hicolor
  DIR_LO=/opt/kde2/share/icons/locolor
  DIR_HI3=/opt/kde3/share/icons/hicolor
  DIR_LO3=/opt/kde3/share/icons/locolor
  # icon dimensions
  HIRES='48x48 32x32 22x22'
  LORES='32x32 22x22 16x16'
  # files to remove
  REMOVALS='%{_datadir}/icons/xine.xpm %{_datadir}/pixmaps/xine.xpm %{_sysconfdir}/X11/wmconfig/xine %{_sysconfdir}/X11/applnk/Multimedia/xine.desktop /opt/gnome/share/pixmaps/xine.xpm /opt/gnome/share/gnome/apps/Multimedia/xine.desktop %{_datadir}/gnome/apps/Multimedia/xine.desktop /opt/kde2/share/applnk/Multimedia/xine.desktop /opt/kde3/share/applnk/Multimedia/xine.desktop  %{_datadir}/applnk/Multimedia/xine.desktop /opt/kde/share/icons/xine.xpm /opt/kde/share/applnk/Multimedia/xine.desktop %{_datadir}/applnk/Multimedia/xine.desktop'
  # remove files in $REMOVALS
  for remove in $REMOVALS; do
    rm -f $remove
  done
  # KDE2 icons
  for hires in $HIRES; do
    rm -f $DIR_HI/$hires/apps/xine.png
  done
  for lores in $LORES; do
    rm -f $DIR_LO/$lores/apps/xine.png
  done
  # KDE3 icons
  for hires in $HIRES; do
    rm -f $DIR_HI3/$hires/apps/xine.png
  done
  for lores in $LORES; do
    rm -f $DIR_LO3/$lores/apps/xine.png
  done

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc doc/FAQ_* doc/README.* doc/README_* doc/bug_report_form
%{_bindir}/*xine*
%{skindir}/*
%{_datadir}/idl/xine.idl
%{_datadir}/xine/desktop/*
%lang(de) %{_mandir}/de/man1/*
%lang(fr) %{_mandir}/fr/man1/*
%lang(es) %{_mandir}/es/man1/*
%lang(pl) %{_mandir}/pl/man1/*
%{_mandir}/man1/*
%{_datadir}/locale/*

%changelog
* Mon May 27 2002 Matthias Dahl <matthew2k@web.de>
- added passing of build parameter to configure
* Sun May 26 2002 Matthias Dahl <matthew2k@web.de>
- added more kde2 and kde3 fixes by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sun May 20 2002 Matthias Dahl <matthew2k@web.de>
- added kde2 bugfix by Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added german description by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sun May 20 2002 Matthias Dahl <matthew2k@web.de>
- added kde3 support by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sat May 18 2002 Matthias Dahl <matthew2k@web.de>
- added czech translations by valtri@atlas.cz
* Thu May 16 2002 Matthias Dahl <matthew2k@web.de>
- replaced %configure because it was causing trouble on some configurations
* Sat May 11 2002 Matthias Dahl <matthew2k@web.de>
- reworked/revamped spec file, still needs some tuning (BuildPreReq, ...)
* Fri May 03 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add xitk README file.
* Sun Mar 31 2002 Matthias Dahl <matthew2k@web.de>
- added xine-bugreport and xine-check, including their man pages.
- added german man pages and README_fi.
* Fri Dec 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add portuguese brazilian *.mo files: thanks to Miguel Freitas <miguel@cetuc.puc-rio.br> ;-)
* Tue Nov 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add spanish *.mo files: thanks to Juan Manuel Garca Molina <juanmagm@mail.com>
* Sun Nov 18 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add *.mo files
* Wed Oct 3 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- use DESTDIR for package building and add xineshot, based on patch from Andrew Meredith <andrew@anvil.org>
* Thu Sep 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add icons and desktop stuff from patches by Miguel Freitas <miguel@cetuc.puc-rio.br>
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Merge patch from Jos Carlos Monteiro <jcm@netcabo.pt>:
  - Filelist and other minor updates,
  - Fixed some SuSE compatibility issues,
  - Added Portuguese summary.
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add missing files.
* Thu Jul 26 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Made AA as separate package.
* Thu Jul 26 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist.
* Tue Jul 03 2001 Matthias Dahl <matthew2k@web.de>
- fixed the "no-skins-in-final-RPM-package" problem (nice explanation *grin*)
* Sun Jun 10 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist and the requirements field
- removed /sbin/ldconfig as post install script
* Thu Mar 28 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add korean summary, patch from Louis JANG <louis@ns.mizi.com>
* Thu Jan 11 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- patch from Sung-Hyun Nam <namsh@lgic.co.kr> applied.
* Fri Oct 17 2000 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- first spec file.
