.TH xinput 1 __xorgversion__

.SH NAME
xinput - utility to configure and test X input devices

.SH SYNOPSIS
.B xinput [OPTIONS] [DEVICE]

.SH DESCRIPTION
xinput is a utility to list available input devices, query information about
a device and change input device settings.
.SH OPTIONS
.TP 8
.B --version
Test if the X Input extension is available and return the version number
of the program and the version supported by the server. This option does not
require a device name.
.PP
.TP 8
.B --list [--short || --long] [\fIdevice\fP]
If no argument is given list all the input devices. If an argument is given,
show all the features of \fIdevice\fP. Uses XListInputDevices(3).
If --long is provided, the output includes detailed information about the
capabilities of each devices. Otherwise, or if --short is provided, only the
device names and some minimal information is listed.
.PP
.TP 8
.B --get-feedbacks \fIdevice\fP
Display the feedbacks of \fIdevice\fP.
.PP
.TP 8
.B --set-pointer \fIdevice\fP
Switch \fIdevice\fP in core pointer.
This option does nothing on X servers 1.5 and later.
.PP
.TP 8
.B --set-mode \fIdevice\fP \fIABSOLUTE|RELATIVE\fP
Change the mode of \fIdevice\fP.
.PP
.TP 8
.B --set-ptr-feedback \fIdevice\fP \fIthreshold\fP \fInum\fP \fIdenom\fP
Change the acceleration of \fIdevice\fP.
.PP
.TP 8
.B --set-integer-feedback \fIdevice\fP \fIindex\fP \fIvalue\fP
Change the value of an integer feedback of \fIdevice\fP.
.PP
.TP 8
.B --set-button-map \fIdevice\fP \fImap_button_1\fP [\fImap_button_2\fP [\fI...\fP]]
Change the button mapping of \fIdevice\fP. The buttons are specified in
physical order (starting with button 1) and are mapped to the logical button
provided. 0 disables a button. The default button mapping for a device is 1
2 3 4 5 6 etc.
.PP
.TP 8
.B --query-state \fIdevice\fP
Query the device state.
.PP
.TP 8
.B --list-props \fIdevice\fP [\fIdevice\fP [\fI...\fP]]
Lists properties that can be set for the given device(s).
.PP
.TP 8
.B --set-int-prop \fIdevice\fP \fIproperty\fP \fIformat\fP \fIvalue\fP
Sets an integer property for the device.  Appropriate values for \fIformat\fP
are 8, 16, or 32, depending on the property. Deprecated, use
.B --set-prop
instead.
.PP
.TP 8
.B --set-float-prop \fIdevice\fP \fIproperty\fP \fIvalue\fP
Sets a float property for the device. Deprecated, use
.B --set-prop
instead.
.PP
.TP 8
.B --set\-prop [\-\-type=\fIatom|float|int\fP] [\-\-format=\fI8|16|32\fP] \fIdevice\fP \fIproperty\fP \fIvalue\fP [...]
Set the property to the given value(s).  If not specified, the format and type
of the property are left as-is.  The arguments are interpreted according to the
property type.
.PP
.TP 8
.B --watch-props \fIdevice\fP
Prints to standard out when property changes occur.
.PP
.TP 8
.B --delete-prop \fIdevice\fP \fIproperty\fP
Delete the property from the device.
.PP
.TP 8
.B --test [-proximity] \fIdevice\fP
Register all extended events from \fIdevice\fP and enter an endless
loop displaying events received. If the -proximity is given, ProximityIn
and ProximityOut are registered.
.PP
.TP 8
.B --test_xi2
Register for a number of XI2 events and display them. This option does not
take a device argument.
.PP
\fIdevice\fP can be the device name as a string or the XID of the
device.
.PP
\fIproperty\fP can be the property as a string or the Atom value.
.PP

.SH COPYRIGHT
Copyright 1996,1997, Frederic Lepied.
.PP
Copyright 2008, Philip Langdale.

.SH AUTHORS

.nf
Philip Langdale, <philipl@alumni.utexas.net>
Frederic Lepied, France <Frederic.Lepied@sugix.frmug.org>
Peter Hutterer <peter.hutterer@who-t.net>
Julien Cristau <jcristau@debian.org>
Thomas Jaeger <ThJaeger@gmail.com>
and more.
.fi
