/* Dambusters */
/* 'nothing' driver ;-) */

#include "driver.h"
#include "vidhrdw/generic.h"
#include "sound/ay8910.h"


VIDEO_START( dambustr  )
{
	return 0;
}

VIDEO_UPDATE( dambustr )
{

}


WRITE8_HANDLER( dambustr_videoram_w )
{
	videoram[offset]=data;
}

static ADDRESS_MAP_START( mem, ADDRESS_SPACE_PROGRAM, 8 )
	AM_RANGE(0x0000, 0x7fff) AM_ROM
	AM_RANGE(0x8000, 0xffff) AM_RAM
ADDRESS_MAP_END

static ADDRESS_MAP_START( readport, ADDRESS_SPACE_IO, 8 )
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
ADDRESS_MAP_END

static ADDRESS_MAP_START( writeport, ADDRESS_SPACE_IO, 8 )
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
ADDRESS_MAP_END


INPUT_PORTS_START( dambustr )
INPUT_PORTS_END

static const gfx_layout charlayout =
{
	8,8,
	RGN_FRAC(1,2),
	2,
	{ 0, RGN_FRAC(1,2) },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8
};

static const gfx_decode gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &charlayout,     0, 8 },
	{ -1 }	/* end of array */
};


static MACHINE_DRIVER_START( dambustr )

	/* basic machine hardware */
	MDRV_CPU_ADD(Z80,8000000/2)
	MDRV_CPU_PROGRAM_MAP(mem, 0)
	MDRV_CPU_IO_MAP(readport, writeport)
	/*MDRV_CPU_VBLANK_INT(irq0_line_hold,4) */

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(32*8, 32*8)
	MDRV_VISIBLE_AREA(0*8, 32*8-1, 2*8, 30*8-1)
	MDRV_GFXDECODE(gfxdecodeinfo)
	MDRV_PALETTE_LENGTH(512)

	MDRV_VIDEO_START(dambustr)
	MDRV_VIDEO_UPDATE(dambustr)

	/* sound hardware */
	MDRV_SPEAKER_STANDARD_MONO("mono")

	MDRV_SOUND_ADD(AY8910, 8000000/4)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.30)
MACHINE_DRIVER_END

/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( dambustr )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "db5a",   0x4000, 0x1000, CRC(75659ecc) SHA1(b61254fb12f3999607abd88d1cc649dcfbf0384c) )
	ROM_LOAD( "db6a",   0x5000, 0x1000, CRC(448db54b) SHA1(c9afbf02bf4d4ac2972ab7ac6adfa4e951ae79c2) )
	ROM_LOAD( "db7a",   0x6000, 0x1000, CRC(675b1f5e) SHA1(6a386212a640fb467b6956a4dc5a68476af1cf97) )
	ROM_LOAD( "db8a",   0x7000, 0x1000, CRC(fd041ff4) SHA1(8d27da7bf0c655633711b960cbc23950c8a371ae) )

	ROM_REGION( 0x10000,REGION_USER1,0)
 	ROM_LOAD( "db11a",   0x0000, 0x1000, CRC(427bd3fb) SHA1(cdbaef4040fa2e0598a086e320d51ecb26a591dd) )
	ROM_LOAD( "db9a",    0x1000, 0x1000, CRC(57164563) SHA1(8471d0660f39511d0afa3cdd63a1e84b0ea80fd0) )
	ROM_LOAD( "db10a",   0x2000, 0x1000, CRC(075b9c5e) SHA1(ff6ce873897004c0e796813725e260df85a520f9) )
	ROM_LOAD( "db12a",   0x3000, 0x1000, CRC(ed01a68b) SHA1(9dd37c2a25865717a7acdd7e2a3bef26a4cef3d9) )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "db1a",   0x1000, 0x1000, CRC(4cb964cd) SHA1(1c90b14deb201a64b8ed4378b022e9e4574aed94) )
	ROM_LOAD( "db2a",   0x3000, 0x1000, CRC(0a0a6af5) SHA1(ecd2a6696ce9154f030c830ccb45690787881a73) )
	ROM_LOAD( "db3a",   0x0000, 0x1000, CRC(9e9a9710) SHA1(a9f67a05a2882b9f6f3378cc73e90539de4b8ca4) )
	ROM_LOAD( "db4a",   0x2000, 0x1000, CRC(d9d2df33) SHA1(97057fe33c146898755b556558ff707b9f4551ec) )
ROM_END

ROM_START( dambust )
	ROM_REGION( 0x10000, REGION_CPU1, 0 )
	ROM_LOAD( "db05.bin",   0x4000, 0x1000, CRC(75659ecc) SHA1(b61254fb12f3999607abd88d1cc649dcfbf0384c) )
	ROM_LOAD( "db06p.bin",   0x5000, 0x1000,  CRC(35dcee01) )
	ROM_LOAD( "db07.bin",   0x6000, 0x1000,  CRC(675b1f5e) SHA1(6a386212a640fb467b6956a4dc5a68476af1cf97) )
	ROM_LOAD( "db08.bin",   0x7000, 0x1000,  CRC(fd041ff4) SHA1(8d27da7bf0c655633711b960cbc23950c8a371ae) )

	ROM_REGION( 0x10000,REGION_USER1,0)
 	ROM_LOAD( "db11.bin",   0x0000, 0x1000, CRC(9e6b34fe) )
	ROM_LOAD( "db09.bin",    0x1000, 0x1000, CRC(57164563) SHA1(8471d0660f39511d0afa3cdd63a1e84b0ea80fd0) )
	ROM_LOAD( "db10p.bin",   0x2000, 0x1000, CRC(c129c57b) )
	ROM_LOAD( "db12.bin",   0x3000, 0x1000, CRC(ea4c65f5) )

	ROM_REGION( 0x4000, REGION_GFX1, ROMREGION_DISPOSE )
	ROM_LOAD( "db1ap.bin",   0x1000, 0x1000, CRC(4cb964cd) SHA1(1c90b14deb201a64b8ed4378b022e9e4574aed94) )
	ROM_LOAD( "db02.bin",   0x3000, 0x1000, CRC(0a0a6af5) SHA1(ecd2a6696ce9154f030c830ccb45690787881a73) )
	ROM_LOAD( "db03.bin",   0x0000, 0x1000, CRC(9e9a9710) SHA1(a9f67a05a2882b9f6f3378cc73e90539de4b8ca4) )
	ROM_LOAD( "db04.bin",   0x2000, 0x1000, CRC(d9d2df33) SHA1(97057fe33c146898755b556558ff707b9f4551ec) )
ROM_END


static DRIVER_INIT(dambustr)
{
	int i,j;
	int tmpram[16];
	for(i=0;i<4096*4;i++)
	{
		memory_region(REGION_CPU1)[i]=memory_region(REGION_USER1)[BITSWAP16(i,15,14,13,12, 4,10,9,8,7,6,5,3,11,2,1,0)];
	}

	/*swap gfx */
	for(i=0;i<0x4000;i+=16)
	{
		for(j=0;j<16;j++) tmpram[j]=memory_region(REGION_GFX1)[i+j];
		for(j=0;j<8;j++)
		{
			memory_region(REGION_GFX1)[i+j]=tmpram[j*2];
			memory_region(REGION_GFX1)[i+j+8]=tmpram[j*2+1];
		}
	}
}

GAME( 19??, dambustr,  0,       dambustr,  dambustr,  dambustr, ROT90, "GAT", "Dambusters (set 1)",GAME_NOT_WORKING )
GAME( 19??, dambust ,  dambustr,       dambustr,  dambustr,  dambustr, ROT90, "GAT", "Dambusters (set 2)",GAME_NOT_WORKING )
