/*
 * Decompiled with CFR 0.152.
 */
package org.apache.env;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.env.WhichConstant;

public abstract class WhichJar {
    public static final String SERVICE_NAME = "WhichJar";
    private static final String WHICHJAR_PROPS = "org/apache/env/WhichJar.properties";
    protected static Properties jarSizeTable = new Properties();
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$env$WhichJar;

    static {
        WhichJar.loadJarTable(jarSizeTable, WHICHJAR_PROPS);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static void getClasspathInfo(Hashtable hashtable, String string) {
        hashtable.put("java.class.path", System.getProperty("java.class.path"));
        hashtable.put("sun.boot.class.path", System.getProperty("sun.boot.class.path"));
        hashtable.put("java.ext.dirs", System.getProperty("java.ext.dirs"));
    }

    private static String getFilename(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "/";
        return string.substring(string.lastIndexOf("/"));
    }

    public static int getInfo(Hashtable hashtable, File file, String string) {
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
        }
        if (file == null) {
            hashtable.put(SERVICE_NAME + WhichConstant.ITEM_DESC[5], "getInfo() called on null jarFile");
            return 5;
        }
        String string2 = file.getName();
        if (file.exists()) {
            try {
                hashtable.put(String.valueOf(string2) + ".path", file.getAbsolutePath());
                String string3 = WhichJar.getJarInfo(string2, file.length());
                if (string3 == null) {
                    hashtable.put(String.valueOf(string2) + WhichConstant.ITEM_DESC[2], "not from an official release, size:" + file.length());
                    return 2;
                }
                hashtable.put(String.valueOf(string2) + WhichConstant.ITEM_DESC[1], string3);
                return 1;
            }
            catch (Exception exception) {
                hashtable.put(String.valueOf(string2) + WhichConstant.ITEM_DESC[5], String.valueOf(file.getAbsolutePath()) + " threw: " + exception.toString());
                return 5;
            }
        }
        int n = WhichConstant.isStrict(string) ? 5 : 0;
        hashtable.put(String.valueOf(string2) + WhichConstant.ITEM_DESC[n], String.valueOf(file.getAbsolutePath()) + " does not exist");
        return n;
    }

    private static String getJarInfo(String string, long l) {
        if (jarSizeTable == null) {
            return null;
        }
        String string2 = ".";
        return jarSizeTable.getProperty(String.valueOf(String.valueOf(l)) + "." + string);
    }

    public static String getVersion() {
        return "WhichJar.java:($Revision: 1.1 $)";
    }

    private static void loadJarTable(Properties properties, String string) {
        if (properties == null) {
            properties = new Properties();
        }
        try {
            InputStream inputStream = null;
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Method method = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = WhichJar.class$("java.lang.Thread"))).getMethod("getContextClassLoader", classArray);
                if (method != null) {
                    ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), objectArray);
                    inputStream = classLoader.getResourceAsStream(string);
                }
            }
            catch (Exception exception) {}
            if (inputStream == null) {
                inputStream = (class$org$apache$env$WhichJar != null ? class$org$apache$env$WhichJar : (class$org$apache$env$WhichJar = WhichJar.class$("org.apache.env.WhichJar"))).getResourceAsStream("/" + string);
            }
            properties.load(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            System.err.println("WhichJar loadJarTable threw: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public static int searchClasspaths(Hashtable hashtable, String string, String string2) {
        int n = WhichJar.searchPath(hashtable, "java.class.path", string, string2);
        int n2 = WhichJar.searchPath(hashtable, "sun.boot.class.path", string, string2);
        int n3 = WhichJar.searchDirs(hashtable, "java.ext.dirs", string, string2);
        if (WhichConstant.isStrict(string2)) {
            return Math.max(n, Math.max(n2, n3));
        }
        return 2;
    }

    public static int searchDir(Hashtable hashtable, String string, String string2, String string3) {
        File file = new File(string);
        if (!file.exists()) {
            int n = WhichConstant.isStrict(string3) ? 5 : 0;
            hashtable.put("WhichJarsearchDir" + WhichConstant.ITEM_DESC[n], "searchDir does not exist: " + string);
            return n;
        }
        File file2 = new File(file, string2);
        return WhichJar.getInfo(hashtable, file2, string3);
    }

    public static int searchDirs(Hashtable hashtable, String string, String string2, String string3) {
        String string4 = System.getProperty(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().toLowerCase();
            n = Math.max(n, WhichJar.searchDir(hashtable, string5, string2, string3));
        }
        return n;
    }

    public static int searchPath(Hashtable hashtable, String string, String string2, String string3) {
        String string4 = System.getProperty(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string4, File.pathSeparator);
        int n = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().toLowerCase();
            if (string5.indexOf(string2) <= -1) continue;
            File file = new File(string5);
            if (file.exists()) {
                if (bl) {
                    Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                    int n2 = WhichConstant.isStrict(string3) ? 5 : 0;
                    hashtable2.put(String.valueOf(string2) + WhichConstant.ITEM_DESC[n2], "jar on classpath multiple times!");
                    n = Math.max(n, WhichJar.getInfo(hashtable2, file, string3));
                    n = Math.max(n, n2);
                    hashtable.put(String.valueOf(string) + "." + string2 + ".hashinfo", hashtable2);
                    continue;
                }
                n = Math.max(n, WhichJar.getInfo(hashtable, file, string3));
                bl = true;
                continue;
            }
            hashtable.put(String.valueOf(string2) + WhichConstant.ITEM_DESC[4], "classpath entry [" + string5 + "] does not exist on disk!");
            n = Math.max(n, WhichConstant.isStrict(string3) ? 4 : 3);
        }
        return n;
    }
}

