/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.apps;

import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XParseError
implements ErrorHandler {
    private boolean showErrors = true;
    private boolean showWarnings = false;
    private int maxMessages = 10;
    private int fatalCount = 0;
    private int errorCount = 0;
    private int warningCount = 0;
    private String baseURI = "";

    public XParseError(boolean bl, boolean bl2) {
        this.showErrors = bl;
        this.showWarnings = bl2;
        String string = System.getProperty("user.dir");
        String string2 = "";
        string2 = string.endsWith("/") ? "file:" + string + "file" : "file:" + string + "/" + string2;
        try {
            URL uRL = new URL(string2);
            this.baseURI = uRL.toString();
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void error(SAXParseException sAXParseException) {
        if (this.showErrors) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Error", sAXParseException);
            }
            ++this.errorCount;
        }
    }

    public void fatalError(SAXParseException sAXParseException) {
        if (this.showErrors) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Fatal error", sAXParseException);
            }
            ++this.errorCount;
            ++this.fatalCount;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalCount() {
        return this.fatalCount;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    private void message(String string, SAXParseException sAXParseException) {
        String string2 = sAXParseException.getSystemId();
        if (string2.startsWith(this.baseURI)) {
            string2 = string2.substring(this.baseURI.length());
        }
        System.out.print(String.valueOf(string) + ":" + string2 + ":" + sAXParseException.getLineNumber());
        if (sAXParseException.getColumnNumber() > 0) {
            System.out.print(":" + sAXParseException.getColumnNumber());
        }
        System.out.println(":" + sAXParseException.getMessage());
    }

    public void setMaxMessages(int n) {
        this.maxMessages = n;
    }

    public void warning(SAXParseException sAXParseException) {
        if (this.showWarnings) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Warning", sAXParseException);
            }
            ++this.warningCount;
        }
    }
}

