/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.readers;

import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.helpers.Debug;
import org.apache.xml.resolver.helpers.PublicId;
import org.apache.xml.resolver.readers.SAXCatalogParser;
import org.apache.xml.resolver.readers.SAXCatalogReader;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class OASISXMLCatalogReader
extends SAXCatalogReader
implements SAXCatalogParser {
    protected Catalog catalog = null;
    public static final String namespaceName = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String tr9401NamespaceName = "urn:oasis:names:tc:entity:xmlns:tr9401:catalog";
    protected Stack baseURIStack = new Stack();
    protected Stack overrideStack = new Stack();
    protected Stack namespaceStack = new Stack();

    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    public boolean checkAttributes(Attributes attributes, String string) {
        if (attributes.getValue(string) == null) {
            Debug.message(1, "Error: required attribute " + string + " missing.");
            return false;
        }
        return true;
    }

    public boolean checkAttributes(Attributes attributes, String string, String string2) {
        return this.checkAttributes(attributes, string) && this.checkAttributes(attributes, string2);
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        block11: {
            CatalogEntry catalogEntry;
            String string4;
            String string5;
            boolean bl;
            Vector<String> vector;
            int n;
            block10: {
                n = -1;
                vector = new Vector<String>();
                bl = this.inExtensionNamespace();
                if (string != null && !bl && (namespaceName.equals(string) || tr9401NamespaceName.equals(string))) {
                    string5 = (String)this.baseURIStack.pop();
                    string4 = (String)this.baseURIStack.peek();
                    if (!string4.equals(string5)) {
                        n = Catalog.BASE;
                        vector.add(string4);
                        Debug.message(4, "(reset) xml:base", string4);
                        try {
                            catalogEntry = new CatalogEntry(n, vector);
                            this.catalog.addEntry(catalogEntry);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                Debug.message(1, "Invalid catalog entry type", string2);
                            }
                            if (catalogException.getExceptionType() != 2) break block10;
                            Debug.message(1, "Invalid catalog entry (rbase)", string2);
                        }
                    }
                }
            }
            if (string != null && namespaceName.equals(string) && !bl && (string2.equals("catalog") || string2.equals("group"))) {
                string5 = (String)this.overrideStack.pop();
                string4 = (String)this.overrideStack.peek();
                if (!string4.equals(string5)) {
                    n = Catalog.OVERRIDE;
                    vector.add(string4);
                    this.overrideStack.push(string4);
                    Debug.message(4, "(reset) override", string4);
                    try {
                        catalogEntry = new CatalogEntry(n, vector);
                        this.catalog.addEntry(catalogEntry);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            Debug.message(1, "Invalid catalog entry type", string2);
                        }
                        if (catalogException.getExceptionType() != 2) break block11;
                        Debug.message(1, "Invalid catalog entry (roverride)", string2);
                    }
                }
            }
        }
        this.namespaceStack.pop();
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    protected boolean inExtensionNamespace() {
        boolean bl = false;
        Enumeration enumeration = this.namespaceStack.elements();
        while (!bl && enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string == null) {
                bl = true;
                continue;
            }
            boolean bl2 = bl = !string.equals(tr9401NamespaceName) && !string.equals(namespaceName);
        }
        return bl;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.baseURIStack.push(this.catalog.getCurrentBase());
        this.overrideStack.push(this.catalog.getDefaultOverride());
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block74: {
            CatalogEntry catalogEntry;
            Object object;
            boolean bl;
            Vector<String> vector;
            int n;
            block72: {
                n = -1;
                vector = new Vector<String>();
                this.namespaceStack.push(string);
                bl = this.inExtensionNamespace();
                if (string != null && namespaceName.equals(string) && !bl) {
                    if (attributes.getValue("xml:base") != null) {
                        block70: {
                            object = attributes.getValue("xml:base");
                            n = Catalog.BASE;
                            vector.add((String)object);
                            this.baseURIStack.push(object);
                            Debug.message(4, "xml:base", (String)object);
                            try {
                                catalogEntry = new CatalogEntry(n, vector);
                                this.catalog.addEntry(catalogEntry);
                            }
                            catch (CatalogException catalogException) {
                                if (catalogException.getExceptionType() == 3) {
                                    Debug.message(1, "Invalid catalog entry type", string2);
                                }
                                if (catalogException.getExceptionType() != 2) break block70;
                                Debug.message(1, "Invalid catalog entry (base)", string2);
                            }
                        }
                        n = -1;
                        vector = new Vector();
                    } else {
                        this.baseURIStack.push(this.baseURIStack.peek());
                    }
                    if ((string2.equals("catalog") || string2.equals("group")) && attributes.getValue("prefer") != null) {
                        block71: {
                            object = attributes.getValue("prefer");
                            if (((String)object).equals("public")) {
                                object = "yes";
                            } else if (((String)object).equals("system")) {
                                object = "no";
                            } else {
                                Debug.message(1, "Invalid prefer: must be 'system' or 'public'", string2);
                                object = this.catalog.getDefaultOverride();
                            }
                            n = Catalog.OVERRIDE;
                            vector.add((String)object);
                            this.overrideStack.push(object);
                            Debug.message(4, "override", (String)object);
                            try {
                                catalogEntry = new CatalogEntry(n, vector);
                                this.catalog.addEntry(catalogEntry);
                            }
                            catch (CatalogException catalogException) {
                                if (catalogException.getExceptionType() == 3) {
                                    Debug.message(1, "Invalid catalog entry type", string2);
                                }
                                if (catalogException.getExceptionType() != 2) break block71;
                                Debug.message(1, "Invalid catalog entry (override)", string2);
                            }
                        }
                        n = -1;
                        vector = new Vector();
                    } else {
                        this.overrideStack.push(this.overrideStack.peek());
                    }
                    if (string2.equals("delegatePublic")) {
                        if (this.checkAttributes(attributes, "publicIdStartString", "catalog")) {
                            n = Catalog.DELEGATE_PUBLIC;
                            vector.add(attributes.getValue("publicIdStartString"));
                            vector.add(attributes.getValue("catalog"));
                            Debug.message(4, "delegatePublic", PublicId.normalize(attributes.getValue("publicIdStartString")), attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("delegateSystem")) {
                        if (this.checkAttributes(attributes, "systemIdStartString", "catalog")) {
                            n = Catalog.DELEGATE_SYSTEM;
                            vector.add(attributes.getValue("systemIdStartString"));
                            vector.add(attributes.getValue("catalog"));
                            Debug.message(4, "delegateSystem", attributes.getValue("systemIdStartString"), attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("delegateURI")) {
                        if (this.checkAttributes(attributes, "uriStartString", "catalog")) {
                            n = Catalog.DELEGATE_URI;
                            vector.add(attributes.getValue("uriStartString"));
                            vector.add(attributes.getValue("catalog"));
                            Debug.message(4, "delegateURI", attributes.getValue("uriStartString"), attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("rewriteSystem")) {
                        if (this.checkAttributes(attributes, "systemIdStartString", "rewritePrefix")) {
                            n = Catalog.REWRITE_SYSTEM;
                            vector.add(attributes.getValue("systemIdStartString"));
                            vector.add(attributes.getValue("rewritePrefix"));
                            Debug.message(4, "rewriteSystem", attributes.getValue("systemIdStartString"), attributes.getValue("rewritePrefix"));
                        }
                    } else if (string2.equals("rewriteURI")) {
                        if (this.checkAttributes(attributes, "uriStartString", "rewritePrefix")) {
                            n = Catalog.REWRITE_URI;
                            vector.add(attributes.getValue("uriStartString"));
                            vector.add(attributes.getValue("rewritePrefix"));
                            Debug.message(4, "rewriteURI", attributes.getValue("uriStartString"), attributes.getValue("rewritePrefix"));
                        }
                    } else if (string2.equals("nextCatalog")) {
                        if (this.checkAttributes(attributes, "catalog")) {
                            n = Catalog.CATALOG;
                            vector.add(attributes.getValue("catalog"));
                            Debug.message(4, "nextCatalog", attributes.getValue("catalog"));
                        }
                    } else if (string2.equals("public")) {
                        if (this.checkAttributes(attributes, "publicId", "uri")) {
                            n = Catalog.PUBLIC;
                            vector.add(attributes.getValue("publicId"));
                            vector.add(attributes.getValue("uri"));
                            Debug.message(4, "public", PublicId.normalize(attributes.getValue("publicId")), attributes.getValue("uri"));
                        }
                    } else if (string2.equals("system")) {
                        if (this.checkAttributes(attributes, "systemId", "uri")) {
                            n = Catalog.SYSTEM;
                            vector.add(attributes.getValue("systemId"));
                            vector.add(attributes.getValue("uri"));
                            Debug.message(4, "system", attributes.getValue("systemId"), attributes.getValue("uri"));
                        }
                    } else if (string2.equals("uri")) {
                        if (this.checkAttributes(attributes, "name", "uri")) {
                            n = Catalog.URI;
                            vector.add(attributes.getValue("name"));
                            vector.add(attributes.getValue("uri"));
                            Debug.message(4, "uri", attributes.getValue("name"), attributes.getValue("uri"));
                        }
                    } else if (!string2.equals("catalog") && !string2.equals("group")) {
                        Debug.message(1, "Invalid catalog entry type", string2);
                    }
                    if (n >= 0) {
                        try {
                            object = new CatalogEntry(n, vector);
                            this.catalog.addEntry((CatalogEntry)object);
                        }
                        catch (CatalogException catalogException) {
                            if (catalogException.getExceptionType() == 3) {
                                Debug.message(1, "Invalid catalog entry type", string2);
                            }
                            if (catalogException.getExceptionType() != 2) break block72;
                            Debug.message(1, "Invalid catalog entry", string2);
                        }
                    }
                }
            }
            if (string == null || !tr9401NamespaceName.equals(string) || bl) break block74;
            if (attributes.getValue("xml:base") != null) {
                block73: {
                    object = attributes.getValue("xml:base");
                    n = Catalog.BASE;
                    vector.add((String)object);
                    this.baseURIStack.push(object);
                    Debug.message(4, "xml:base", (String)object);
                    try {
                        catalogEntry = new CatalogEntry(n, vector);
                        this.catalog.addEntry(catalogEntry);
                    }
                    catch (CatalogException catalogException) {
                        if (catalogException.getExceptionType() == 3) {
                            Debug.message(1, "Invalid catalog entry type", string2);
                        }
                        if (catalogException.getExceptionType() != 2) break block73;
                        Debug.message(1, "Invalid catalog entry (base)", string2);
                    }
                }
                n = -1;
                vector = new Vector();
            } else {
                this.baseURIStack.push(this.baseURIStack.peek());
            }
            if (string2.equals("doctype")) {
                n = Catalog.DOCTYPE;
                vector.add(attributes.getValue("name"));
                vector.add(attributes.getValue("uri"));
            } else if (string2.equals("document")) {
                n = Catalog.DOCUMENT;
                vector.add(attributes.getValue("uri"));
            } else if (string2.equals("dtddecl")) {
                n = Catalog.DTDDECL;
                vector.add(attributes.getValue("publicId"));
                vector.add(attributes.getValue("uri"));
            } else if (string2.equals("entity")) {
                n = Catalog.ENTITY;
                vector.add(attributes.getValue("name"));
                vector.add(attributes.getValue("uri"));
            } else if (string2.equals("linktype")) {
                n = Catalog.LINKTYPE;
                vector.add(attributes.getValue("name"));
                vector.add(attributes.getValue("uri"));
            } else if (string2.equals("notation")) {
                n = Catalog.NOTATION;
                vector.add(attributes.getValue("name"));
                vector.add(attributes.getValue("uri"));
            } else if (string2.equals("sgmldecl")) {
                n = Catalog.SGMLDECL;
                vector.add(attributes.getValue("uri"));
            } else {
                Debug.message(1, "Invalid catalog entry type", string2);
            }
            if (n >= 0) {
                try {
                    object = new CatalogEntry(n, vector);
                    this.catalog.addEntry((CatalogEntry)object);
                }
                catch (CatalogException catalogException) {
                    if (catalogException.getExceptionType() == 3) {
                        Debug.message(1, "Invalid catalog entry type", string2);
                        break block74;
                    }
                    if (catalogException.getExceptionType() != 2) break block74;
                    Debug.message(1, "Invalid catalog entry", string2);
                }
            }
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
    }
}

