/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlByte;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlShort;
import org.apache.xmlbeans.XmlUnsignedByte;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.regex.ParseException;
import org.apache.xmlbeans.impl.regex.RegularExpression;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.StscResolver;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.schema.StscTranslator;
import org.apache.xmlbeans.impl.schema.XmlValueRef;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.w3.x2001.xmlSchema.Facet;
import org.w3.x2001.xmlSchema.ListDocument;
import org.w3.x2001.xmlSchema.LocalSimpleType;
import org.w3.x2001.xmlSchema.RestrictionDocument;
import org.w3.x2001.xmlSchema.SimpleType;
import org.w3.x2001.xmlSchema.UnionDocument;

public class StscSimpleTypeResolver {
    private static final RegularExpression[] EMPTY_REGEX_ARRAY;
    private static CodeForNameEntry[] facetCodes;
    private static final Map facetCodeMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void resolveSimpleType(SchemaTypeImpl sImpl) {
        SimpleType parseSt = (SimpleType)sImpl.getParseObject();
        if (!$assertionsDisabled && !sImpl.isSimpleType()) {
            throw new AssertionError();
        }
        int count = (parseSt.isSetList() ? 1 : 0) + (parseSt.isSetUnion() ? 1 : 0) + (parseSt.isSetRestriction() ? 1 : 0);
        if (count > 1) {
            StscState.get().error("A simple type must define either a list, a union, or a restriction: more than one found.", 52, parseSt);
        } else if (count < 1) {
            StscState.get().error("A simple type must define either a list, a union, or a restriction: none was found.", 52, parseSt);
            StscSimpleTypeResolver.resolveErrorSimpleType(sImpl);
            return;
        }
        boolean finalRest = false;
        boolean finalList = false;
        boolean finalUnion = false;
        if (parseSt.isSetFinal()) {
            String value = parseSt.getFinal();
            if (value.equals("#all")) {
                finalUnion = true;
                finalList = true;
                finalRest = true;
            } else if (value.equals("restriction")) {
                finalRest = true;
            } else if (value.equals("list")) {
                finalList = true;
            } else if (value.equals("union")) {
                finalUnion = true;
            }
        }
        sImpl.setSimpleFinal(finalRest, finalList, finalUnion);
        ArrayList anonTypes = new ArrayList();
        if (parseSt.getList() != null) {
            StscSimpleTypeResolver.resolveListType(sImpl, parseSt.getList(), anonTypes);
        } else if (parseSt.getUnion() != null) {
            StscSimpleTypeResolver.resolveUnionType(sImpl, parseSt.getUnion(), anonTypes);
        } else if (parseSt.getRestriction() != null) {
            StscSimpleTypeResolver.resolveSimpleRestrictionType(sImpl, parseSt.getRestriction(), anonTypes);
        }
        sImpl.setAnonymousTypeRefs(StscSimpleTypeResolver.makeRefArray(anonTypes));
    }

    private static SchemaType.Ref[] makeRefArray(Collection typeList) {
        SchemaType.Ref[] result = new SchemaType.Ref[typeList.size()];
        int j = 0;
        Iterator i = typeList.iterator();
        while (i.hasNext()) {
            result[j] = ((SchemaType)i.next()).getRef();
            ++j;
        }
        return result;
    }

    static void resolveErrorSimpleType(SchemaTypeImpl sImpl) {
        sImpl.setSimpleTypeVariety(1);
        sImpl.setBaseTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
        sImpl.setBaseDepth(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getBaseDepth() + 1);
        sImpl.setPrimitiveTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
    }

    static void resolveListType(SchemaTypeImpl sImpl, ListDocument.List parseList, List anonTypes) {
        XmlObject errorLoc;
        SchemaTypeImpl itemImpl;
        StscState state = StscState.get();
        sImpl.setSimpleTypeVariety(3);
        sImpl.setBaseTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
        sImpl.setBaseDepth(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getBaseDepth() + 1);
        sImpl.setDerivationType(1);
        if (sImpl.isRedefinition()) {
            StscState.get().error("A type redefinition must restrict the original definition of the type.", 60, parseList);
        }
        QName itemName = parseList.getItemType();
        LocalSimpleType parseInner = parseList.getSimpleType();
        if (itemName != null && parseInner != null) {
            state.error("List type definitions provide either an itemType attribute or contain a nested simpleType: both were found.", 7, parseList);
            parseInner = null;
        }
        if (itemName != null) {
            itemImpl = state.findGlobalType(itemName, sImpl.getChameleonNamespace());
            errorLoc = parseList.xgetItemType();
            if (itemImpl == null) {
                state.notFoundError(itemName, 6, parseList.xgetItemType());
                itemImpl = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
            }
        } else if (parseInner != null) {
            itemImpl = new SchemaTypeImpl(state.sts());
            errorLoc = parseInner;
            itemImpl.setSimpleType(true);
            itemImpl.setParseContext(parseInner, sImpl.getTargetNamespace(), sImpl.getChameleonNamespace() != null, false);
            itemImpl.setOuterSchemaTypeRef(sImpl.getRef());
            anonTypes.add(itemImpl);
        } else {
            state.error("List type definitions provide either an itemType attribute or contain a nested simpleType: neither was found.", 22, parseList);
            StscSimpleTypeResolver.resolveErrorSimpleType(sImpl);
            return;
        }
        if (itemImpl.finalList()) {
            state.error("Cannot derive by list a final type.", 54, parseList);
        }
        StscResolver.resolveType(itemImpl);
        if (!itemImpl.isSimpleType()) {
            state.error("Item type for this list type is not simple", 23, errorLoc);
            sImpl = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        switch (itemImpl.getSimpleVariety()) {
            case 3: {
                state.error("This item type is another list type; lists of lists are not allowed.", 24, errorLoc);
                StscSimpleTypeResolver.resolveErrorSimpleType(sImpl);
                return;
            }
            case 2: {
                if (itemImpl.isUnionOfLists()) {
                    state.error("This item type is a union containing a list; lists of lists are not allowed.", 24, errorLoc);
                    StscSimpleTypeResolver.resolveErrorSimpleType(sImpl);
                    return;
                }
            }
            case 1: {
                sImpl.setListItemTypeRef(itemImpl.getRef());
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                sImpl.setListItemTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
            }
        }
        sImpl.setBasicFacets(StscState.FACETS_LIST, StscState.FIXED_FACETS_LIST);
        sImpl.setWhiteSpaceRule(3);
        StscSimpleTypeResolver.resolveFundamentalFacets(sImpl);
    }

    static void resolveUnionType(SchemaTypeImpl sImpl, UnionDocument.Union parseUnion, List anonTypes) {
        SchemaTypeImpl mImpl;
        SchemaTypeImpl mImpl2;
        sImpl.setSimpleTypeVariety(2);
        sImpl.setBaseTypeRef(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getRef());
        sImpl.setBaseDepth(BuiltinSchemaTypeSystem.ST_ANY_SIMPLE.getBaseDepth() + 1);
        sImpl.setDerivationType(1);
        StscState state = StscState.get();
        if (sImpl.isRedefinition()) {
            StscState.get().error("A type redefinition must restrict the original definition of the type.", 60, parseUnion);
        }
        List memberTypes = parseUnion.getMemberTypes();
        LocalSimpleType[] simpleTypes = parseUnion.getSimpleTypeArray();
        ArrayList<SchemaTypeImpl> memberImplList = new ArrayList<SchemaTypeImpl>();
        if (simpleTypes.length == 0 && (memberTypes == null || memberTypes.size() == 0)) {
            state.error("A union type must specify at least one member type", 14, parseUnion);
        }
        if (memberTypes != null) {
            Iterator mNames = memberTypes.iterator();
            while (mNames.hasNext()) {
                QName mName = (QName)mNames.next();
                SchemaTypeImpl memberImpl = state.findGlobalType(mName, sImpl.getChameleonNamespace());
                if (memberImpl == null) {
                    state.notFoundError(mName, 6, parseUnion.xgetMemberTypes());
                    continue;
                }
                memberImplList.add(memberImpl);
            }
        }
        for (int i = 0; i < simpleTypes.length; ++i) {
            mImpl2 = new SchemaTypeImpl(state.sts());
            mImpl2.setSimpleType(true);
            mImpl2.setParseContext(simpleTypes[i], sImpl.getTargetNamespace(), sImpl.getChameleonNamespace() != null, false);
            memberImplList.add(mImpl2);
            mImpl2.setOuterSchemaTypeRef(sImpl.getRef());
            mImpl2.setAnonymousUnionMemberOrdinal(i + 1);
            anonTypes.add(mImpl2);
        }
        Iterator mImpls = memberImplList.iterator();
        while (mImpls.hasNext()) {
            mImpl2 = (SchemaTypeImpl)mImpls.next();
            if (StscResolver.resolveType(mImpl2)) continue;
            if (mImpl2.getOuterType().equals(sImpl)) {
                state.error("Member has a cyclic dependency on the containing union", 13, mImpl2.getParseObject());
            } else {
                state.error("Member " + QNameHelper.pretty(mImpl2.getName()) + " has a cyclic dependency on the union", 13, parseUnion.xgetMemberTypes());
            }
            mImpls.remove();
        }
        boolean isUnionOfLists = false;
        Iterator mImpls2 = memberImplList.iterator();
        while (mImpls2.hasNext()) {
            mImpl = (SchemaTypeImpl)mImpls2.next();
            if (!mImpl.isSimpleType()) {
                if (mImpl.getOuterType() != null && mImpl.getOuterType().equals(sImpl)) {
                    state.error("Member is not simple", 14, mImpl.getParseObject());
                } else {
                    state.error("Member " + QNameHelper.pretty(mImpl.getName()) + " is not simple", 14, parseUnion.xgetMemberTypes());
                }
                mImpls2.remove();
                continue;
            }
            if (mImpl.getSimpleVariety() != 3 && (mImpl.getSimpleVariety() != 2 || !mImpl.isUnionOfLists())) continue;
            isUnionOfLists = true;
        }
        for (int i = 0; i < memberImplList.size(); ++i) {
            mImpl = (SchemaTypeImpl)memberImplList.get(i);
            if (!mImpl.finalUnion()) continue;
            state.error("Cannot derive by union a final type.", 54, parseUnion);
        }
        sImpl.setUnionOfLists(isUnionOfLists);
        sImpl.setUnionMemberTypeRefs(StscSimpleTypeResolver.makeRefArray(memberImplList));
        sImpl.setBasicFacets(StscState.FACETS_UNION, StscState.FIXED_FACETS_UNION);
        StscSimpleTypeResolver.resolveFundamentalFacets(sImpl);
    }

    static void resolveSimpleRestrictionType(SchemaTypeImpl sImpl, RestrictionDocument.Restriction parseRestr, List anonTypes) {
        SchemaTypeImpl baseImpl;
        QName baseName = parseRestr.getBase();
        LocalSimpleType parseInner = parseRestr.getSimpleType();
        StscState state = StscState.get();
        if (baseName != null && parseInner != null) {
            state.error("Simple type restrictions must name a base type or contain a nested simple type: both were found.", 15, parseRestr);
            parseInner = null;
        }
        if (baseName != null) {
            if (sImpl.isRedefinition()) {
                baseImpl = state.findRedefinedGlobalType(parseRestr.getBase(), sImpl.getChameleonNamespace(), sImpl.getName());
                if (baseImpl != null && !baseImpl.getName().equals(sImpl.getName())) {
                    state.error("A type redefinition must restrict the original type definition", 60, parseRestr);
                }
            } else {
                baseImpl = state.findGlobalType(baseName, sImpl.getChameleonNamespace());
            }
            if (baseImpl == null) {
                state.notFoundError(baseName, 6, parseRestr.xgetBase());
                baseImpl = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
            }
        } else if (parseInner != null) {
            if (sImpl.isRedefinition()) {
                StscState.get().error("A type redefinition must restrict the original definition of the type.", 60, parseInner);
            }
            baseImpl = new SchemaTypeImpl(state.sts());
            baseImpl.setSimpleType(true);
            baseImpl.setParseContext(parseInner, sImpl.getTargetNamespace(), sImpl.getChameleonNamespace() != null, false);
            baseImpl.setOuterSchemaTypeRef(sImpl.getRef());
            anonTypes.add(baseImpl);
        } else {
            state.error("Simple type restrictions must name a base type or contain a nested simple type: neither were found.", 16, parseRestr);
            baseImpl = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (!StscResolver.resolveType(baseImpl)) {
            baseImpl = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (baseImpl.finalRestriction()) {
            state.error("Cannot restrict a final type", 54, parseRestr);
        }
        sImpl.setBaseTypeRef(baseImpl.getRef());
        sImpl.setBaseDepth(baseImpl.getBaseDepth() + 1);
        sImpl.setDerivationType(1);
        if (!baseImpl.isSimpleType()) {
            state.error("Base type for this simple type restriction is not simple", 17, parseRestr.xgetBase());
            StscSimpleTypeResolver.resolveErrorSimpleType(sImpl);
            return;
        }
        sImpl.setSimpleTypeVariety(baseImpl.getSimpleVariety());
        switch (baseImpl.getSimpleVariety()) {
            case 1: {
                sImpl.setPrimitiveTypeRef(baseImpl.getPrimitiveType().getRef());
                break;
            }
            case 2: {
                sImpl.setUnionOfLists(baseImpl.isUnionOfLists());
                sImpl.setUnionMemberTypeRefs(StscSimpleTypeResolver.makeRefArray(Arrays.asList(baseImpl.getUnionMemberTypes())));
                break;
            }
            case 3: {
                sImpl.setListItemTypeRef(baseImpl.getListItemType().getRef());
            }
        }
        StscSimpleTypeResolver.resolveFacets(sImpl, parseRestr, baseImpl);
        StscSimpleTypeResolver.resolveFundamentalFacets(sImpl);
    }

    static int translateWhitespaceCode(XmlAnySimpleType value) {
        String textval = value.getStringValue();
        if (textval.equals("collapse")) {
            return 3;
        }
        if (textval.equals("preserve")) {
            return 1;
        }
        if (textval.equals("replace")) {
            return 2;
        }
        StscState.get().error("Unrecognized whitespace value \"" + textval + "\"", 20, value);
        return 0;
    }

    static boolean isMultipleFacet(int facetcode) {
        return facetcode == 11 || facetcode == 10;
    }

    static boolean facetAppliesToType(int facetCode, SchemaTypeImpl baseImpl) {
        switch (baseImpl.getSimpleVariety()) {
            case 3: {
                switch (facetCode) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (facetCode) {
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
        }
        switch (baseImpl.getPrimitiveType().getBuiltinTypeCode()) {
            case 2: {
                return false;
            }
            case 3: {
                switch (facetCode) {
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                return false;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                switch (facetCode) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 11: {
                switch (facetCode) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                switch (facetCode) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 9: 
                    case 10: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return false;
    }

    private static int other_similar_limit(int facetcode) {
        switch (facetcode) {
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 5;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new IllegalStateException();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static void resolveFacets(SchemaTypeImpl sImpl, XmlObject restriction, SchemaTypeImpl baseImpl) {
        block39: {
            state = StscState.get();
            seenFacet = new boolean[12];
            myFacets = baseImpl.getBasicFacets();
            fixedFacets = baseImpl.getFixedFacets();
            wsr = 0;
            enumeratedValues = null;
            patterns = null;
            if (restriction == null) break block39;
            cur = restriction.newCursor();
            more = cur.toFirstChild();
            while (more) {
                block40: {
                    block42: {
                        block41: {
                            code = StscSimpleTypeResolver.translateFacetCode(cur.getName());
                            if (code == -1) break block40;
                            facet = (Facet)cur.getObject();
                            if (StscSimpleTypeResolver.facetAppliesToType(code, baseImpl)) break block41;
                            state.error("The facet " + facet.newCursor().getName().getLocalPart() + " does not apply to the base type " + baseImpl, 18, facet);
                            break block40;
                        }
                        if (!seenFacet[code] || StscSimpleTypeResolver.isMultipleFacet(code)) break block42;
                        state.error("Facet specified multiple times", 19, facet);
                        break block40;
                    }
                    seenFacet[code] = true;
                    switch (code) {
                        case 0: {
                            if (myFacets[1] != null || myFacets[2] != null) {
                                state.error("Cannot specify length in addition to minLength or maxLength", 19, facet);
                                break;
                            }
                            len = StscTranslator.buildNnInteger(facet.getValue());
                            if (len == null) {
                                state.error("Must be a nonnegative integer", 20, facet);
                                break;
                            }
                            if (fixedFacets[code] && !myFacets[code].valueEquals(len)) {
                                state.error("This facet is fixed and cannot be overridden", 21, facet);
                                break;
                            }
                            myFacets[code] = len;
                            ** GOTO lbl124
                        }
                        case 1: 
                        case 2: {
                            if (myFacets[0] != null) {
                                state.error("Cannot specify minLength or maxLength in addition to length", 19, facet);
                                break;
                            }
                            mlen = StscTranslator.buildNnInteger(facet.getValue());
                            if (mlen == null) {
                                state.error("Must be a nonnegative integer", 20, facet);
                                break;
                            }
                            if (fixedFacets[code] && !myFacets[code].valueEquals(mlen)) {
                                state.error("This facet is fixed and cannot be overridden", 21, facet);
                                break;
                            }
                            if (myFacets[2] != null && mlen.compareValue(myFacets[2]) > 0) {
                                state.error("Larger than prior maxLength", 20, facet);
                                break;
                            }
                            if (myFacets[1] != null && mlen.compareValue(myFacets[1]) < 0) {
                                state.error("Smaller than prior minLength", 20, facet);
                                break;
                            }
                            myFacets[code] = mlen;
                            ** GOTO lbl124
                        }
                        case 7: 
                        case 8: {
                            istotaldig = code == 7;
                            dig = StscTranslator.buildNnInteger(facet.getValue());
                            if (dig == null) {
                                state.error("Must be a nonnegative integer", 20, facet);
                            } else {
                                if (fixedFacets[code] && !myFacets[code].valueEquals(dig)) {
                                    state.error("This facet is fixed and cannot be overridden", 21, facet);
                                    break;
                                }
                                if (myFacets[7] != null && dig.compareValue(myFacets[7]) > 0) {
                                    state.error("Larger than prior totalDigits", 20, facet);
                                }
                                if (!istotaldig && myFacets[8] != null && dig.compareValue(myFacets[8]) > 0) {
                                    state.error("Larger than prior fractionDigits", 20, facet);
                                }
                                myFacets[code] = dig;
                            }
                            ** GOTO lbl124
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (seenFacet[StscSimpleTypeResolver.other_similar_limit(code)]) {
                                state.error("Cannot define both inclusive and exclusive limit in the same restriciton", 19, facet);
                                break;
                            }
                            ismin = code == 3 || code == 4;
                            isexclusive = code == 3 || code == 6;
                            try {
                                limit = baseImpl.newValue(facet.getValue());
                            }
                            catch (XmlValueOutOfRangeException e) {
                                state.error("Must be valid value in base type", 20, facet);
                                break;
                            }
                            if (fixedFacets[code] && !myFacets[code].valueEquals(limit)) {
                                state.error("This facet is fixed and cannot be overridden", 21, facet);
                                break;
                            }
                            if (myFacets[code] != null && ((comparison = limit.compareValue(myFacets[code])) == 2 || comparison == (ismin != false ? -1 : 1))) {
                                state.error(ismin ? (isexclusive ? "Must be greater than or equal to previous minExclusive" : "Must be greater than or equal to previous minInclusive") : (isexclusive != false ? "Must be less than or equal to previous maxExclusive" : "Must be less than or equal to previous maxInclusive"), 20, facet);
                                break;
                            }
                            myFacets[code] = limit;
                            myFacets[StscSimpleTypeResolver.other_similar_limit((int)code)] = null;
                            ** GOTO lbl124
                        }
                        case 9: {
                            wsr = StscSimpleTypeResolver.translateWhitespaceCode(facet.getValue());
                            if (baseImpl.getWhiteSpaceRule() > wsr) {
                                wsr = 0;
                                state.error("Cannot apply this whitespace facet over the previous one", 20, facet);
                                break;
                            }
                            myFacets[code] = StscState.build_wsstring(wsr).get();
                            ** GOTO lbl124
                        }
                        case 11: {
                            try {
                                enumval = baseImpl.newValue(facet.getValue());
                            }
                            catch (XmlValueOutOfRangeException e) {
                                state.error("Enumerated value invalid in base type", 20, facet);
                                break;
                            }
                            if (enumeratedValues == null) {
                                enumeratedValues = new ArrayList<XmlAnySimpleType>();
                            }
                            enumeratedValues.add(enumval);
                            ** GOTO lbl124
                        }
                        case 10: {
                            try {
                                p = new RegularExpression(facet.getValue().getStringValue(), "X");
                            }
                            catch (ParseException e) {
                                state.error("Malformed regular expression", 20, facet);
                                break;
                            }
                            if (patterns == null) {
                                patterns = new ArrayList<RegularExpression>();
                            }
                            patterns.add(p);
                        }
lbl124:
                        // 9 sources

                        default: {
                            if (!facet.getFixed()) break;
                            fixedFacets[code] = true;
                        }
                    }
                }
                more = cur.toNextSibling();
            }
        }
        sImpl.setBasicFacets(StscSimpleTypeResolver.makeValueRefArray(myFacets), fixedFacets);
        if (wsr == 0) {
            wsr = baseImpl.getWhiteSpaceRule();
        }
        sImpl.setWhiteSpaceRule(wsr);
        if (enumeratedValues != null) {
            sImpl.setEnumerationValues(StscSimpleTypeResolver.makeValueRefArray(enumeratedValues.toArray(new XmlAnySimpleType[enumeratedValues.size()])));
            beType /* !! */  = sImpl;
            if (sImpl.getBaseType().getBaseEnumType() != null) {
                beType /* !! */  = sImpl.getBaseType().getBaseEnumType();
            }
            sImpl.setBaseEnumTypeRef(beType /* !! */ .getRef());
        } else {
            sImpl.copyEnumerationValues(baseImpl);
        }
        patternArray = patterns != null ? patterns.toArray(StscSimpleTypeResolver.EMPTY_REGEX_ARRAY) : StscSimpleTypeResolver.EMPTY_REGEX_ARRAY;
        sImpl.setPatternFacet(patternArray.length > 0 || baseImpl.hasPatternFacet() != false);
        sImpl.setPatterns(patternArray);
    }

    private static XmlValueRef[] makeValueRefArray(XmlAnySimpleType[] source) {
        XmlValueRef[] result = new XmlValueRef[source.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = source[i] == null ? null : new XmlValueRef(source[i]);
        }
        return result;
    }

    private static boolean isDiscreteType(SchemaTypeImpl sImpl) {
        if (sImpl.getFacet(8) != null) {
            return true;
        }
        switch (sImpl.getPrimitiveType().getBuiltinTypeCode()) {
            case 3: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNumericPrimitive(SchemaType sImpl) {
        switch (sImpl.getBuiltinTypeCode()) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    private static int decimalSizeOfType(SchemaTypeImpl sImpl) {
        int size = StscSimpleTypeResolver.mathematicalSizeOfType(sImpl);
        if (size == 8 && !XmlByte.type.isAssignableFrom(sImpl)) {
            size = 16;
        }
        if (size == 16 && !XmlShort.type.isAssignableFrom(sImpl) && !XmlUnsignedByte.type.isAssignableFrom(sImpl)) {
            size = 32;
        }
        return size;
    }

    private static int mathematicalSizeOfType(SchemaTypeImpl sImpl) {
        if (sImpl.getPrimitiveType().getBuiltinTypeCode() != 11) {
            return 0;
        }
        if (sImpl.getFacet(8) == null || ((SimpleValue)((Object)sImpl.getFacet(8))).getBigIntegerValue().signum() != 0) {
            return 1000001;
        }
        BigInteger min = null;
        BigInteger max = null;
        if (sImpl.getFacet(3) != null) {
            min = ((SimpleValue)((Object)sImpl.getFacet(3))).getBigIntegerValue();
        }
        if (sImpl.getFacet(4) != null) {
            min = ((SimpleValue)((Object)sImpl.getFacet(4))).getBigIntegerValue();
        }
        if (sImpl.getFacet(5) != null) {
            max = ((SimpleValue)((Object)sImpl.getFacet(5))).getBigIntegerValue();
        }
        if (sImpl.getFacet(6) != null) {
            max = ((SimpleValue)((Object)sImpl.getFacet(6))).getBigIntegerValue();
        }
        if (sImpl.getFacet(7) != null) {
            BigInteger peg = null;
            try {
                BigInteger totalDigits = ((SimpleValue)((Object)sImpl.getFacet(7))).getBigIntegerValue();
                switch (totalDigits.intValue()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        peg = BigInteger.valueOf(99L);
                        break;
                    }
                    case 3: 
                    case 4: {
                        peg = BigInteger.valueOf(9999L);
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        peg = BigInteger.valueOf(999999999L);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        peg = BigInteger.valueOf(999999999999999999L);
                    }
                }
            }
            catch (XmlValueOutOfRangeException e) {
                // empty catch block
            }
            if (peg != null) {
                min = min == null ? peg.negate() : min.max(peg.negate());
                BigInteger bigInteger = max = max == null ? peg : max.min(peg);
            }
        }
        if (min != null && max != null) {
            if (min.signum() < 0) {
                min = min.negate().subtract(BigInteger.ONE);
            }
            if (max.signum() < 0) {
                max = max.negate().subtract(BigInteger.ONE);
            }
            if ((max = max.max(min)).compareTo(BigInteger.valueOf(127L)) <= 0) {
                return 8;
            }
            if (max.compareTo(BigInteger.valueOf(32767L)) <= 0) {
                return 16;
            }
            if (max.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) <= 0) {
                return 32;
            }
            if (max.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                return 64;
            }
        }
        return 1000000;
    }

    static void resolveFundamentalFacets(SchemaTypeImpl sImpl) {
        switch (sImpl.getSimpleVariety()) {
            case 1: {
                SchemaTypeImpl baseImpl = (SchemaTypeImpl)sImpl.getBaseType();
                sImpl.setOrdered(baseImpl.ordered());
                sImpl.setBounded(!(sImpl.getFacet(3) == null && sImpl.getFacet(4) == null || sImpl.getFacet(5) == null && sImpl.getFacet(6) == null));
                sImpl.setFinite(baseImpl.isFinite() || sImpl.isBounded() && StscSimpleTypeResolver.isDiscreteType(sImpl));
                sImpl.setNumeric(baseImpl.isNumeric() || StscSimpleTypeResolver.isNumericPrimitive(sImpl.getPrimitiveType()));
                sImpl.setDecimalSize(StscSimpleTypeResolver.decimalSizeOfType(sImpl));
                break;
            }
            case 2: {
                SchemaType[] mTypes = sImpl.getUnionMemberTypes();
                int ordered = 0;
                boolean isBounded = true;
                boolean isFinite = true;
                boolean isNumeric = true;
                for (int i = 0; i < mTypes.length; ++i) {
                    if (mTypes[i].ordered() != 0) {
                        ordered = 1;
                    }
                    if (!mTypes[i].isBounded()) {
                        isBounded = false;
                    }
                    if (!mTypes[i].isFinite()) {
                        isFinite = false;
                    }
                    if (mTypes[i].isNumeric()) continue;
                    isNumeric = false;
                }
                sImpl.setOrdered(ordered);
                sImpl.setBounded(isBounded);
                sImpl.setFinite(isFinite);
                sImpl.setNumeric(isNumeric);
                sImpl.setDecimalSize(0);
                break;
            }
            case 3: {
                sImpl.setOrdered(0);
                sImpl.setBounded(sImpl.getFacet(0) != null || sImpl.getFacet(2) != null);
                sImpl.setFinite(sImpl.getListItemType().isFinite() && sImpl.isBounded());
                sImpl.setNumeric(false);
                sImpl.setDecimalSize(0);
            }
        }
    }

    private static Map buildFacetCodeMap() {
        HashMap<QName, Integer> result = new HashMap<QName, Integer>();
        for (int i = 0; i < facetCodes.length; ++i) {
            result.put(StscSimpleTypeResolver.facetCodes[i].name, new Integer(StscSimpleTypeResolver.facetCodes[i].code));
        }
        return result;
    }

    private static int translateFacetCode(QName name) {
        Integer result = (Integer)facetCodeMap.get(name);
        if (result == null) {
            return -1;
        }
        return result;
    }

    static {
        $assertionsDisabled = !StscSimpleTypeResolver.class.desiredAssertionStatus();
        EMPTY_REGEX_ARRAY = new RegularExpression[0];
        facetCodes = new CodeForNameEntry[]{new CodeForNameEntry(QNameHelper.forLNS("length", "http://www.w3.org/2001/XMLSchema"), 0), new CodeForNameEntry(QNameHelper.forLNS("minLength", "http://www.w3.org/2001/XMLSchema"), 1), new CodeForNameEntry(QNameHelper.forLNS("maxLength", "http://www.w3.org/2001/XMLSchema"), 2), new CodeForNameEntry(QNameHelper.forLNS("pattern", "http://www.w3.org/2001/XMLSchema"), 10), new CodeForNameEntry(QNameHelper.forLNS("enumeration", "http://www.w3.org/2001/XMLSchema"), 11), new CodeForNameEntry(QNameHelper.forLNS("whiteSpace", "http://www.w3.org/2001/XMLSchema"), 9), new CodeForNameEntry(QNameHelper.forLNS("maxInclusive", "http://www.w3.org/2001/XMLSchema"), 5), new CodeForNameEntry(QNameHelper.forLNS("maxExclusive", "http://www.w3.org/2001/XMLSchema"), 6), new CodeForNameEntry(QNameHelper.forLNS("minInclusive", "http://www.w3.org/2001/XMLSchema"), 4), new CodeForNameEntry(QNameHelper.forLNS("minExclusive", "http://www.w3.org/2001/XMLSchema"), 3), new CodeForNameEntry(QNameHelper.forLNS("totalDigits", "http://www.w3.org/2001/XMLSchema"), 7), new CodeForNameEntry(QNameHelper.forLNS("fractionDigits", "http://www.w3.org/2001/XMLSchema"), 8)};
        facetCodeMap = StscSimpleTypeResolver.buildFacetCodeMap();
    }

    private static class CodeForNameEntry {
        public QName name;
        public int code;

        CodeForNameEntry(QName name, int code) {
            this.name = name;
            this.code = code;
        }
    }
}

