/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.schema;

import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.QNameSet;
import org.apache.xmlbeans.QNameSetBuilder;
import org.apache.xmlbeans.SchemaAttributeModel;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaIdentityConstraint;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.common.XPath;
import org.apache.xmlbeans.impl.regex.RegularExpression;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaAttributeGroupImpl;
import org.apache.xmlbeans.impl.schema.SchemaGlobalAttributeImpl;
import org.apache.xmlbeans.impl.schema.SchemaGlobalElementImpl;
import org.apache.xmlbeans.impl.schema.SchemaIdentityConstraintImpl;
import org.apache.xmlbeans.impl.schema.SchemaLocalAttributeImpl;
import org.apache.xmlbeans.impl.schema.SchemaLocalElementImpl;
import org.apache.xmlbeans.impl.schema.SchemaModelGroupImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeImpl;
import org.apache.xmlbeans.impl.schema.StscImporter;
import org.apache.xmlbeans.impl.schema.StscResolver;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.values.NamespaceContext;
import org.apache.xmlbeans.impl.values.XmlIntegerImpl;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.apache.xmlbeans.soap.SOAPArrayType;
import org.w3.x2001.xmlSchema.Annotated;
import org.w3.x2001.xmlSchema.Attribute;
import org.w3.x2001.xmlSchema.AttributeGroup;
import org.w3.x2001.xmlSchema.Element;
import org.w3.x2001.xmlSchema.FieldDocument;
import org.w3.x2001.xmlSchema.FormChoice;
import org.w3.x2001.xmlSchema.Keybase;
import org.w3.x2001.xmlSchema.KeyrefDocument;
import org.w3.x2001.xmlSchema.LocalElement;
import org.w3.x2001.xmlSchema.LocalSimpleType;
import org.w3.x2001.xmlSchema.NamedAttributeGroup;
import org.w3.x2001.xmlSchema.NamedGroup;
import org.w3.x2001.xmlSchema.RedefineDocument;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.w3.x2001.xmlSchema.TopLevelAttribute;
import org.w3.x2001.xmlSchema.TopLevelComplexType;
import org.w3.x2001.xmlSchema.TopLevelElement;
import org.w3.x2001.xmlSchema.TopLevelSimpleType;

public class StscTranslator {
    private static final QName WSDL_ARRAYTYPE_NAME;
    public static final RegularExpression XPATH_REGEXP;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addAllDefinitions(StscImporter.SchemaToProcess[] schemasAndChameleons) {
        for (int i = 0; i < schemasAndChameleons.length; ++i) {
            StscTranslator.addAllDefinitions(schemasAndChameleons[i].getSchema(), schemasAndChameleons[i].getChameleonNamespace(), schemasAndChameleons[i].getRedefine());
        }
    }

    public static void addAllDefinitions(SchemaDocument.Schema schema, String givenTargetNamespace, RedefineDocument.Redefine redefine) {
        StscState state = StscState.get();
        if (schema.sizeOfNotationArray() > 0) {
            state.warning("Schema <notation> is not yet supported for this release.", 51, schema.getNotationArray(0));
        }
        String targetNamespace = schema.getTargetNamespace();
        boolean chameleon = false;
        if (givenTargetNamespace != null && targetNamespace == null) {
            targetNamespace = givenTargetNamespace;
            chameleon = true;
        }
        if (targetNamespace == null) {
            targetNamespace = "";
        }
        state.addNamespace(targetNamespace);
        RedefinitionHolder redefinitions = new RedefinitionHolder(redefine);
        TopLevelComplexType[] complexTypes = schema.getComplexTypeArray();
        for (int i = 0; i < complexTypes.length; ++i) {
            TopLevelComplexType redef = redefinitions.redefineComplexType(complexTypes[i].getName());
            state.addGlobalType(StscTranslator.translateGlobalComplexType(complexTypes[i], targetNamespace, chameleon, false), redef != null);
            if (redef == null) continue;
            state.addGlobalType(StscTranslator.translateGlobalComplexType(redef, targetNamespace, chameleon, true), false);
        }
        TopLevelSimpleType[] simpleTypes = schema.getSimpleTypeArray();
        for (int i = 0; i < simpleTypes.length; ++i) {
            TopLevelSimpleType redef = redefinitions.redefineSimpleType(simpleTypes[i].getName());
            state.addGlobalType(StscTranslator.translateGlobalSimpleType(simpleTypes[i], targetNamespace, chameleon, false), redef != null);
            if (redef == null) continue;
            state.addGlobalType(StscTranslator.translateGlobalSimpleType(redef, targetNamespace, chameleon, true), false);
        }
        TopLevelElement[] elements = schema.getElementArray();
        for (int i = 0; i < elements.length; ++i) {
            TopLevelElement element = elements[i];
            state.addDocumentType(StscTranslator.translateDocumentType(element, targetNamespace, chameleon), QNameHelper.forLNS(element.getName(), targetNamespace));
        }
        TopLevelAttribute[] attributes = schema.getAttributeArray();
        for (int i = 0; i < attributes.length; ++i) {
            TopLevelAttribute attribute = attributes[i];
            state.addAttributeType(StscTranslator.translateAttributeType(attribute, targetNamespace, chameleon), QNameHelper.forLNS(attribute.getName(), targetNamespace));
        }
        NamedGroup[] modelgroups = schema.getGroupArray();
        for (int i = 0; i < modelgroups.length; ++i) {
            NamedGroup redef = redefinitions.redefineModelGroup(modelgroups[i].getName());
            state.addModelGroup(StscTranslator.translateModelGroup(modelgroups[i], targetNamespace, chameleon, false), redef != null);
            if (redef == null) continue;
            state.addModelGroup(StscTranslator.translateModelGroup(redef, targetNamespace, chameleon, true), false);
        }
        NamedAttributeGroup[] attrgroups = schema.getAttributeGroupArray();
        for (int i = 0; i < attrgroups.length; ++i) {
            NamedAttributeGroup redef = redefinitions.redefineAttributeGroup(attrgroups[i].getName());
            state.addAttributeGroup(StscTranslator.translateAttributeGroup(attrgroups[i], targetNamespace, chameleon, false), redef != null);
            if (redef == null) continue;
            state.addAttributeGroup(StscTranslator.translateAttributeGroup(redef, targetNamespace, chameleon, true), false);
        }
        redefinitions.complainAboutMissingDefinitions();
    }

    private static String findFilename(XmlObject xobj) {
        return StscState.get().sourceNameForUri(xobj.documentProperties().getSourceName());
    }

    private static SchemaTypeImpl translateDocumentType(TopLevelElement xsdType, String targetNamespace, boolean chameleon) {
        SchemaTypeImpl sType = new SchemaTypeImpl(StscState.get().sts());
        sType.setDocumentType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon, false);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateAttributeType(TopLevelAttribute xsdType, String targetNamespace, boolean chameleon) {
        SchemaTypeImpl sType = new SchemaTypeImpl(StscState.get().sts());
        sType.setAttributeType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon, false);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        return sType;
    }

    private static SchemaTypeImpl translateGlobalComplexType(TopLevelComplexType xsdType, String targetNamespace, boolean chameleon, boolean redefinition) {
        QName name;
        StscState state = StscState.get();
        String localname = xsdType.getName();
        if (localname == null) {
            state.error("Global type missing a name", 5, xsdType);
            return null;
        }
        if (!XMLChar.isValidNCName(localname)) {
            state.error("Invalid type name \"" + localname + "\"", 53, xsdType.xgetName());
        }
        if (StscTranslator.isReservedTypeName(name = QNameHelper.forLNS(localname, targetNamespace))) {
            state.warning("Skipping definition of built-in type " + QNameHelper.pretty(name), 44, xsdType);
            return null;
        }
        SchemaTypeImpl sType = new SchemaTypeImpl(state.sts());
        sType.setParseContext(xsdType, targetNamespace, chameleon, redefinition);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        sType.setName(QNameHelper.forLNS(localname, targetNamespace));
        return sType;
    }

    private static SchemaTypeImpl translateGlobalSimpleType(TopLevelSimpleType xsdType, String targetNamespace, boolean chameleon, boolean redefinition) {
        QName name;
        StscState state = StscState.get();
        String localname = xsdType.getName();
        if (localname == null) {
            state.error("Global type missing a name", 5, xsdType);
            return null;
        }
        if (!XMLChar.isValidNCName(localname)) {
            state.error("Invalid type name \"" + localname + "\"", 53, xsdType.xgetName());
        }
        if (StscTranslator.isReservedTypeName(name = QNameHelper.forLNS(localname, targetNamespace))) {
            state.warning("Skipping definition of built-in type " + QNameHelper.pretty(name), 44, xsdType);
            return null;
        }
        SchemaTypeImpl sType = new SchemaTypeImpl(state.sts());
        sType.setSimpleType(true);
        sType.setParseContext(xsdType, targetNamespace, chameleon, redefinition);
        sType.setFilename(StscTranslator.findFilename(xsdType));
        sType.setName(name);
        return sType;
    }

    static FormChoice findElementFormDefault(XmlObject obj) {
        XmlCursor cur = obj.newCursor();
        while (cur.getObject().schemaType() != SchemaDocument.Schema.type) {
            if (cur.toParent()) continue;
            return null;
        }
        return ((SchemaDocument.Schema)cur.getObject()).xgetElementFormDefault();
    }

    public static boolean uriMatch(String s1, String s2) {
        if (s1 == null) {
            return s2 == null || s2.equals("");
        }
        if (s2 == null) {
            return s1.equals("");
        }
        return s1.equals(s2);
    }

    public static void copyGlobalElementToLocalElement(SchemaGlobalElement referenced, SchemaLocalElementImpl target) {
        target.setNameAndTypeRef(referenced.getName(), referenced.getType().getRef());
        target.setNillable(referenced.isNillable());
        target.setDefault(referenced.getDefaultText(), referenced.isFixed(), ((SchemaGlobalElementImpl)referenced).getParseObject());
        target.setIdentityConstraints(((SchemaLocalElementImpl)((Object)referenced)).getIdentityConstraintRefs());
        target.setBlock(referenced.blockExtension(), referenced.blockRestriction(), referenced.blockSubstitution());
        target.setAbstract(referenced.isAbstract());
        target.setTransitionRules(((SchemaParticle)((Object)referenced)).acceptedStartNames(), ((SchemaParticle)((Object)referenced)).isSkippable());
    }

    public static void copyGlobalAttributeToLocalAttribute(SchemaGlobalAttributeImpl referenced, SchemaLocalAttributeImpl target) {
        target.init(referenced.getName(), referenced.getTypeRef(), referenced.getUse(), referenced.getDefaultText(), referenced.getParseObject(), referenced._defaultValue, referenced.isFixed(), referenced.getWSDLArrayType());
    }

    public static SchemaLocalElementImpl translateElement(Element xsdElt, String targetNamespace, boolean chameleon, List anonymousTypes, SchemaType outerType) {
        SchemaGlobalElementImpl head;
        QName qname;
        SchemaLocalElementImpl impl;
        StscState state = StscState.get();
        SchemaTypeImpl sgHead = null;
        if (xsdElt.isSetSubstitutionGroup() && (sgHead = state.findDocumentType(xsdElt.getSubstitutionGroup(), ((SchemaTypeImpl)outerType).getChameleonNamespace())) != null) {
            StscResolver.resolveType(sgHead);
        }
        String name = xsdElt.getName();
        QName ref = xsdElt.getRef();
        if (ref != null && name != null) {
            state.error("Element " + name + " specifies both a ref and a name", 30, xsdElt.xgetRef());
            name = null;
        }
        if (ref == null && name == null) {
            state.error("Element has no name", 8, xsdElt);
            return null;
        }
        if (name != null && !XMLChar.isValidNCName(name)) {
            state.error("Invalid element name \"" + name + "\"", 53, xsdElt.xgetName());
        }
        if (ref != null) {
            if (xsdElt.getType() != null || xsdElt.getSimpleType() != null || xsdElt.getComplexType() != null) {
                state.error("Element reference cannot also specify a type", 53, xsdElt);
            }
            if (xsdElt.getForm() != null) {
                state.error("Element reference cannot also specify form", 53, xsdElt);
            }
            if (xsdElt.sizeOfKeyArray() > 0 || xsdElt.sizeOfKeyrefArray() > 0 || xsdElt.sizeOfUniqueArray() > 0) {
                state.warning("Element reference cannot also contain key, keyref, or unique", 53, xsdElt);
            }
            if (xsdElt.isSetDefault()) {
                state.warning("Element with reference to '" + ref.getLocalPart() + "' cannot also specify default", 53, xsdElt);
            }
            if (xsdElt.isSetFixed()) {
                state.warning("Element with reference to '" + ref.getLocalPart() + "' cannot also specify fixed", 53, xsdElt);
            }
            if (xsdElt.isSetBlock()) {
                state.warning("Element with reference to '" + ref.getLocalPart() + "' cannot also specify block", 53, xsdElt);
            }
            if (xsdElt.isSetNillable()) {
                state.warning("Element with reference to '" + ref.getLocalPart() + "' cannot also specify nillable", 53, xsdElt);
            }
            if (!$assertionsDisabled && !(xsdElt instanceof LocalElement)) {
                throw new AssertionError();
            }
            SchemaGlobalElementImpl referenced = state.findGlobalElement(ref, chameleon ? targetNamespace : null);
            if (referenced == null) {
                state.notFoundError(ref, 29, xsdElt.xgetRef());
                return null;
            }
            SchemaLocalElementImpl target = new SchemaLocalElementImpl();
            target.setParticleType(4);
            StscTranslator.copyGlobalElementToLocalElement(referenced, target);
            return target;
        }
        SchemaType sType = null;
        if (xsdElt instanceof LocalElement) {
            impl = new SchemaLocalElementImpl();
            FormChoice form = xsdElt.xgetForm();
            if (form == null) {
                form = StscTranslator.findElementFormDefault(xsdElt);
            }
            qname = form == null || form.getStringValue().equals("unqualified") ? QNameHelper.forLN(name) : QNameHelper.forLNS(name, targetNamespace);
        } else {
            SchemaGlobalElementImpl head2;
            SchemaGlobalElementImpl gelt = new SchemaGlobalElementImpl(state.sts());
            impl = gelt;
            if (sgHead != null && (head2 = state.findGlobalElement(xsdElt.getSubstitutionGroup(), chameleon ? targetNamespace : null)) != null) {
                gelt.setSubstitutionGroup(head2.getRef());
            }
            qname = QNameHelper.forLNS(name, targetNamespace);
            SchemaTypeImpl docType = (SchemaTypeImpl)outerType;
            QName[] sgMembers = docType.getSubstitutionGroupMembers();
            QNameSetBuilder transitionRules = new QNameSetBuilder();
            transitionRules.add(qname);
            for (int i = 0; i < sgMembers.length; ++i) {
                gelt.addSubstitutionGroupMember(sgMembers[i]);
                transitionRules.add(sgMembers[i]);
            }
            impl.setTransitionRules(QNameSet.forSpecification(transitionRules), false);
            impl.setTransitionNotes(QNameSet.EMPTY, true);
            boolean finalExt = false;
            boolean finalRest = false;
            Object ds = xsdElt.getFinal();
            if (ds != null) {
                if (ds instanceof String && ds.equals("#all")) {
                    finalRest = true;
                    finalExt = true;
                } else if (ds instanceof List) {
                    if (((List)ds).contains("extension")) {
                        finalExt = true;
                    }
                    if (((List)ds).contains("restriction")) {
                        finalRest = true;
                    }
                }
            }
            gelt.setFinal(finalExt, finalRest);
            gelt.setAbstract(xsdElt.getAbstract());
            gelt.setFilename(StscTranslator.findFilename(xsdElt));
            gelt.setParseContext(xsdElt, targetNamespace, chameleon);
        }
        if (xsdElt.getType() != null && (sType = state.findGlobalType(xsdElt.getType(), chameleon ? targetNamespace : null)) == null) {
            state.notFoundError(xsdElt.getType(), 6, xsdElt.xgetType());
        }
        boolean simpleTypedef = false;
        Annotated typedef = xsdElt.getComplexType();
        if (typedef == null) {
            typedef = xsdElt.getSimpleType();
            simpleTypedef = true;
        }
        if (sType != null && typedef != null) {
            state.error("Illegal to define a nested type when a type attribute is specified", 7, typedef);
            typedef = null;
        }
        if (typedef != null) {
            SchemaTypeImpl sTypeImpl = new SchemaTypeImpl(state.sts());
            sType = sTypeImpl;
            sTypeImpl.setContainerField(impl);
            sTypeImpl.setOuterSchemaTypeRef(outerType == null ? null : outerType.getRef());
            anonymousTypes.add(sType);
            sTypeImpl.setSimpleType(simpleTypedef);
            sTypeImpl.setParseContext(typedef, targetNamespace, chameleon, false);
        }
        if (sType == null && sgHead != null && (head = state.findGlobalElement(xsdElt.getSubstitutionGroup(), chameleon ? targetNamespace : null)) != null) {
            sType = head.getType();
        }
        if (sType == null) {
            sType = BuiltinSchemaTypeSystem.ST_ANY_TYPE;
        }
        SOAPArrayType wat = null;
        XmlCursor c = xsdElt.newCursor();
        String arrayType = c.getAttributeText(WSDL_ARRAYTYPE_NAME);
        c.dispose();
        if (arrayType != null) {
            wat = new SOAPArrayType(arrayType, new NamespaceContext(xsdElt));
        }
        impl.setWsdlArrayType(wat);
        boolean isFixed = xsdElt.isSetFixed();
        if (xsdElt.isSetDefault() && isFixed) {
            state.error("Should not set both default and fixed on the same element", 9, xsdElt.xgetFixed());
            isFixed = false;
        }
        impl.setParticleType(4);
        impl.setNameAndTypeRef(qname, sType.getRef());
        impl.setNillable(xsdElt.getNillable());
        impl.setDefault(isFixed ? xsdElt.getFixed() : xsdElt.getDefault(), isFixed, xsdElt);
        Object block = xsdElt.getBlock();
        boolean blockExt = false;
        boolean blockRest = false;
        boolean blockSubst = false;
        if (block != null) {
            if (block instanceof String && block.equals("#all")) {
                blockSubst = true;
                blockRest = true;
                blockExt = true;
            } else if (block instanceof List) {
                if (((List)block).contains("extension")) {
                    blockExt = true;
                }
                if (((List)block).contains("restriction")) {
                    blockRest = true;
                }
                if (((List)block).contains("substitution")) {
                    blockSubst = true;
                }
            }
        }
        impl.setBlock(blockExt, blockRest, blockSubst);
        boolean constraintFailed = false;
        int length = xsdElt.sizeOfKeyArray() + xsdElt.sizeOfKeyrefArray() + xsdElt.sizeOfUniqueArray();
        SchemaIdentityConstraintImpl[] constraints = new SchemaIdentityConstraintImpl[length];
        int cur = 0;
        Keybase[] keys = xsdElt.getKeyArray();
        int i = 0;
        while (i < keys.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(keys[i], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(1);
            } else {
                constraintFailed = true;
            }
            ++i;
            ++cur;
        }
        Keybase[] uc = xsdElt.getUniqueArray();
        int i2 = 0;
        while (i2 < uc.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(uc[i2], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(3);
            } else {
                constraintFailed = true;
            }
            ++i2;
            ++cur;
        }
        KeyrefDocument.Keyref[] krs = xsdElt.getKeyrefArray();
        int i3 = 0;
        while (i3 < krs.length) {
            constraints[cur] = StscTranslator.translateIdentityConstraint(krs[i3], targetNamespace, chameleon);
            if (constraints[cur] != null) {
                constraints[cur].setConstraintCategory(2);
            } else {
                constraintFailed = true;
            }
            ++i3;
            ++cur;
        }
        if (!constraintFailed) {
            SchemaIdentityConstraint.Ref[] refs = new SchemaIdentityConstraint.Ref[length];
            for (int i4 = 0; i4 < refs.length; ++i4) {
                refs[i4] = constraints[i4].getRef();
            }
            impl.setIdentityConstraints(refs);
        }
        return impl;
    }

    private static String removeWhitespace(String xpath) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < xpath.length(); ++i) {
            char ch = xpath.charAt(i);
            if (XMLChar.isSpace(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkXPathSyntax(String xpath) {
        if (xpath == null) {
            return false;
        }
        xpath = StscTranslator.removeWhitespace(xpath);
        RegularExpression regularExpression = XPATH_REGEXP;
        synchronized (regularExpression) {
            return XPATH_REGEXP.matches(xpath);
        }
    }

    private static SchemaIdentityConstraintImpl translateIdentityConstraint(Keybase parseIC, String targetNamespace, boolean chameleon) {
        String selector;
        StscState state = StscState.get();
        String string = selector = parseIC.getSelector() == null ? null : parseIC.getSelector().getXpath();
        if (!StscTranslator.checkXPathSyntax(selector)) {
            StscState.get().error("Invalid xpath in selector.", 58, parseIC.getSelector().xgetXpath());
            return null;
        }
        FieldDocument.Field[] fieldElts = parseIC.getFieldArray();
        for (int j = 0; j < fieldElts.length; ++j) {
            if (StscTranslator.checkXPathSyntax(fieldElts[j].getXpath())) continue;
            StscState.get().error("Invalid xpath in field.", 58, fieldElts[j].xgetXpath());
            return null;
        }
        SchemaIdentityConstraintImpl ic = new SchemaIdentityConstraintImpl(state.sts());
        ic.setName(QNameHelper.forLNS(parseIC.getName(), targetNamespace));
        ic.setSelector(parseIC.getSelector().getXpath());
        ic.setParseContext(parseIC, targetNamespace, chameleon);
        XmlCursor c = parseIC.newCursor();
        HashMap nsMap = new HashMap();
        c.getAllNamespaces(nsMap);
        nsMap.remove("");
        ic.setNSMap(nsMap);
        c.dispose();
        String[] fields = new String[fieldElts.length];
        for (int j = 0; j < fields.length; ++j) {
            fields[j] = fieldElts[j].getXpath();
        }
        ic.setFields(fields);
        try {
            ic.buildPaths();
        }
        catch (XPath.XPathCompileException e) {
            StscState.get().error("Invalid xpath in identity constraint: " + e.getMessage(), 58, parseIC);
            return null;
        }
        state.addIdConstraint(ic);
        return ic;
    }

    public static SchemaModelGroupImpl translateModelGroup(NamedGroup namedGroup, String targetNamespace, boolean chameleon, boolean redefinition) {
        String name = namedGroup.getName();
        if (name == null) {
            StscState.get().error("Model groups must be named", 10, namedGroup);
            return null;
        }
        SchemaModelGroupImpl result = new SchemaModelGroupImpl(StscState.get().sts());
        result.init(QNameHelper.forLNS(name, targetNamespace), targetNamespace, chameleon, redefinition, namedGroup);
        return result;
    }

    public static SchemaAttributeGroupImpl translateAttributeGroup(AttributeGroup attrGroup, String targetNamespace, boolean chameleon, boolean redefinition) {
        String name = attrGroup.getName();
        if (name == null) {
            StscState.get().error("Attribute groups must be named", 12, attrGroup);
            return null;
        }
        SchemaAttributeGroupImpl result = new SchemaAttributeGroupImpl(StscState.get().sts());
        result.init(QNameHelper.forLNS(name, targetNamespace), targetNamespace, chameleon, redefinition, attrGroup);
        return result;
    }

    static FormChoice findAttributeFormDefault(XmlObject obj) {
        XmlCursor cur = obj.newCursor();
        while (cur.getObject().schemaType() != SchemaDocument.Schema.type) {
            if (cur.toParent()) continue;
            return null;
        }
        return ((SchemaDocument.Schema)cur.getObject()).xgetAttributeFormDefault();
    }

    static SchemaLocalAttributeImpl translateAttribute(Attribute xsdAttr, String targetNamespace, boolean chameleon, List anonymousTypes, SchemaType outerType, SchemaAttributeModel baseModel, boolean local) {
        QName qname;
        SchemaLocalAttributeImpl sAttr;
        StscState state = StscState.get();
        String name = xsdAttr.getName();
        QName ref = xsdAttr.getRef();
        if (ref != null && name != null) {
            if (name.equals(ref.getLocalPart()) && StscTranslator.uriMatch(targetNamespace, ref.getNamespaceURI())) {
                state.warning("Attribute " + name + " specifies both a ref and a name", 30, xsdAttr.xgetRef());
            } else {
                state.error("Attribute " + name + " specifies both a ref and a name", 30, xsdAttr.xgetRef());
            }
            name = null;
        }
        if (ref == null && name == null) {
            state.error("Attribute has no name", 8, xsdAttr);
            return null;
        }
        if (name != null && !XMLChar.isValidNCName(name)) {
            state.error("Invalid attribute name \"" + name + "\"", 53, xsdAttr.xgetName());
        }
        boolean isFixed = false;
        String deftext = null;
        SchemaType sType = null;
        int use = 2;
        if (local) {
            sAttr = new SchemaLocalAttributeImpl();
        } else {
            sAttr = new SchemaGlobalAttributeImpl(state.sts());
            ((SchemaGlobalAttributeImpl)sAttr).setParseContext(xsdAttr, targetNamespace, chameleon);
        }
        if (ref != null) {
            SchemaGlobalAttributeImpl referenced;
            if (xsdAttr.getType() != null || xsdAttr.getSimpleType() != null) {
                state.error("Attribute reference cannot also specify type", 53, xsdAttr);
            }
            if (xsdAttr.getForm() != null) {
                state.error("Attribute reference cannot also specify form", 53, xsdAttr);
            }
            if ((referenced = state.findGlobalAttribute(ref, chameleon ? targetNamespace : null)) == null) {
                state.notFoundError(ref, 36, xsdAttr.xgetRef());
                return null;
            }
            qname = ref;
            use = referenced.getUse();
            sType = referenced.getType();
            deftext = referenced.getDefaultText();
            if (deftext != null) {
                isFixed = referenced.isFixed();
            }
        } else {
            if (local) {
                FormChoice form = xsdAttr.xgetForm();
                if (form == null) {
                    form = StscTranslator.findAttributeFormDefault(xsdAttr);
                }
                qname = form == null || form.getStringValue().equals("unqualified") ? QNameHelper.forLN(name) : QNameHelper.forLNS(name, targetNamespace);
            } else {
                qname = QNameHelper.forLNS(name, targetNamespace);
            }
            if (xsdAttr.getType() != null && (sType = state.findGlobalType(xsdAttr.getType(), chameleon ? targetNamespace : null)) == null) {
                state.notFoundError(xsdAttr.getType(), 6, xsdAttr.xgetType());
            }
            if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                state.error("Illegal namespace for attribute declaration.", 53, xsdAttr.xgetName());
            }
            if (qname.getNamespaceURI().length() == 0 && qname.getLocalPart().equals("xmlns")) {
                state.error("Illegal name for attribute declaration.", 53, xsdAttr.xgetName());
            }
            LocalSimpleType typedef = xsdAttr.getSimpleType();
            if (sType != null && typedef != null) {
                state.error("Illegal to define a nested type when a type attribute is specified", 7, typedef);
                typedef = null;
            }
            if (typedef != null) {
                SchemaTypeImpl sTypeImpl = new SchemaTypeImpl(state.sts());
                sType = sTypeImpl;
                sTypeImpl.setContainerField(sAttr);
                sTypeImpl.setOuterSchemaTypeRef(outerType == null ? null : outerType.getRef());
                anonymousTypes.add(sType);
                sTypeImpl.setSimpleType(true);
                sTypeImpl.setParseContext(typedef, targetNamespace, chameleon, false);
            }
            if (sType == null && baseModel != null && baseModel.getAttribute(qname) != null) {
                sType = baseModel.getAttribute(qname).getType();
            }
        }
        if (sType == null) {
            sType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (!sType.isSimpleType()) {
            state.error("Attributes must have a simple type (not complex).", 46, xsdAttr);
            sType = BuiltinSchemaTypeSystem.ST_ANY_SIMPLE;
        }
        if (xsdAttr.isSetUse() && (use = StscTranslator.translateUseCode(xsdAttr.xgetUse())) != 2 && !isFixed) {
            deftext = null;
        }
        if (xsdAttr.isSetDefault() || xsdAttr.isSetFixed()) {
            if (isFixed && !xsdAttr.isSetFixed()) {
                state.error("A use of a fixed attribute definition must also be fixed", 9, xsdAttr.xgetFixed());
            }
            isFixed = xsdAttr.isSetFixed();
            if (xsdAttr.isSetDefault() && isFixed) {
                state.error("Should not set both default and fixed on the same attribute", 9, xsdAttr.xgetFixed());
                isFixed = false;
            }
            String string = deftext = isFixed ? xsdAttr.getFixed() : xsdAttr.getDefault();
        }
        if (!local) {
            ((SchemaGlobalAttributeImpl)sAttr).setFilename(StscTranslator.findFilename(xsdAttr));
        }
        SOAPArrayType wat = null;
        XmlCursor c = xsdAttr.newCursor();
        String arrayType = c.getAttributeText(WSDL_ARRAYTYPE_NAME);
        c.dispose();
        if (arrayType != null) {
            wat = new SOAPArrayType(arrayType, new NamespaceContext(xsdAttr));
        }
        sAttr.init(qname, sType.getRef(), use, deftext, xsdAttr, null, isFixed, wat);
        return sAttr;
    }

    static int translateUseCode(Attribute.Use attruse) {
        if (attruse == null) {
            return 2;
        }
        String val = attruse.getStringValue();
        if (val.equals("optional")) {
            return 2;
        }
        if (val.equals("required")) {
            return 3;
        }
        if (val.equals("prohibited")) {
            return 1;
        }
        return 2;
    }

    static XmlInteger buildNnInteger(XmlAnySimpleType value) {
        BigInteger bigInt;
        if (value == null) {
            return null;
        }
        String text = value.getStringValue();
        try {
            bigInt = new BigInteger(text);
        }
        catch (NumberFormatException e) {
            StscState.get().error("Must be nonnegative integer", 21, value);
            return null;
        }
        if (bigInt.signum() < 0) {
            StscState.get().error("Must be nonnegative integer", 21, value);
            return null;
        }
        try {
            XmlIntegerImpl i = new XmlIntegerImpl();
            i.set(bigInt);
            i.setImmutable();
            return i;
        }
        catch (XmlValueOutOfRangeException e) {
            StscState.get().error("Internal error processing number", 21, value);
            return null;
        }
    }

    private static boolean isReservedTypeName(QName name) {
        return BuiltinSchemaTypeSystem.get().findType(name) != null;
    }

    static {
        $assertionsDisabled = !StscTranslator.class.desiredAssertionStatus();
        WSDL_ARRAYTYPE_NAME = QNameHelper.forLNS("arrayType", "http://schemas.xmlsoap.org/wsdl/");
        XPATH_REGEXP = new RegularExpression("(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*))))(\\|(\\.//)?((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)/)*((((child::)?((\\i\\c*:)?(\\i\\c*|\\*)))|\\.)|((attribute::|@)((\\i\\c*:)?(\\i\\c*|\\*)))))*", "X");
    }

    private static class RedefinitionHolder {
        private Map stRedefinitions = Collections.EMPTY_MAP;
        private Map ctRedefinitions = Collections.EMPTY_MAP;
        private Map agRedefinitions = Collections.EMPTY_MAP;
        private Map mgRedefinitions = Collections.EMPTY_MAP;
        private String schemaLocation = "";

        RedefinitionHolder(RedefineDocument.Redefine redefine) {
            if (redefine != null) {
                StscState state = StscState.get();
                this.stRedefinitions = new HashMap();
                this.ctRedefinitions = new HashMap();
                this.agRedefinitions = new HashMap();
                this.mgRedefinitions = new HashMap();
                if (redefine.getSchemaLocation() != null) {
                    this.schemaLocation = redefine.getSchemaLocation();
                }
                TopLevelComplexType[] complexTypes = redefine.getComplexTypeArray();
                for (int i = 0; i < complexTypes.length; ++i) {
                    if (complexTypes[i].getName() == null) continue;
                    if (this.ctRedefinitions.containsKey(complexTypes[i].getName())) {
                        state.error("Duplicate type redefinition: " + complexTypes[i].getName(), 49, null);
                        continue;
                    }
                    this.ctRedefinitions.put(complexTypes[i].getName(), complexTypes[i]);
                }
                TopLevelSimpleType[] simpleTypes = redefine.getSimpleTypeArray();
                for (int i = 0; i < simpleTypes.length; ++i) {
                    if (simpleTypes[i].getName() == null) continue;
                    if (this.stRedefinitions.containsKey(simpleTypes[i].getName())) {
                        state.error("Duplicate type redefinition: " + simpleTypes[i].getName(), 49, null);
                        continue;
                    }
                    this.stRedefinitions.put(simpleTypes[i].getName(), simpleTypes[i]);
                }
                NamedGroup[] modelgroups = redefine.getGroupArray();
                for (int i = 0; i < modelgroups.length; ++i) {
                    if (modelgroups[i].getName() == null) continue;
                    if (this.mgRedefinitions.containsKey(modelgroups[i].getName())) {
                        state.error("Duplicate type redefinition: " + modelgroups[i].getName(), 49, null);
                        continue;
                    }
                    this.mgRedefinitions.put(modelgroups[i].getName(), modelgroups[i]);
                }
                NamedAttributeGroup[] attrgroups = redefine.getAttributeGroupArray();
                for (int i = 0; i < attrgroups.length; ++i) {
                    if (attrgroups[i].getName() == null) continue;
                    if (this.agRedefinitions.containsKey(attrgroups[i].getName())) {
                        state.error("Duplicate type redefinition: " + attrgroups[i].getName(), 49, null);
                        continue;
                    }
                    this.agRedefinitions.put(attrgroups[i].getName(), attrgroups[i]);
                }
            }
        }

        public TopLevelSimpleType redefineSimpleType(String name) {
            if (name == null || !this.stRedefinitions.containsKey(name)) {
                return null;
            }
            return (TopLevelSimpleType)this.stRedefinitions.remove(name);
        }

        public TopLevelComplexType redefineComplexType(String name) {
            if (name == null || !this.ctRedefinitions.containsKey(name)) {
                return null;
            }
            return (TopLevelComplexType)this.ctRedefinitions.remove(name);
        }

        public NamedGroup redefineModelGroup(String name) {
            if (name == null || !this.mgRedefinitions.containsKey(name)) {
                return null;
            }
            return (NamedGroup)this.mgRedefinitions.remove(name);
        }

        public NamedAttributeGroup redefineAttributeGroup(String name) {
            if (name == null || !this.agRedefinitions.containsKey(name)) {
                return null;
            }
            return (NamedAttributeGroup)this.agRedefinitions.remove(name);
        }

        public void complainAboutMissingDefinitions() {
            QName name;
            if (this.stRedefinitions.isEmpty() && this.ctRedefinitions.isEmpty() && this.agRedefinitions.isEmpty() && this.mgRedefinitions.isEmpty()) {
                return;
            }
            StscState state = StscState.get();
            Iterator i = this.stRedefinitions.keySet().iterator();
            while (i.hasNext()) {
                name = (QName)i.next();
                state.error("Redefined simple type " + QNameHelper.pretty(name) + " not found in " + this.schemaLocation, 60, (XmlObject)this.stRedefinitions.get(name));
            }
            i = this.ctRedefinitions.keySet().iterator();
            while (i.hasNext()) {
                name = (QName)i.next();
                state.error("Redefined complex type " + QNameHelper.pretty(name) + " not found in " + this.schemaLocation, 60, (XmlObject)this.ctRedefinitions.get(name));
            }
            i = this.agRedefinitions.keySet().iterator();
            while (i.hasNext()) {
                name = (QName)i.next();
                state.error("Redefined attribute group " + QNameHelper.pretty(name) + " not found in " + this.schemaLocation, 60, (XmlObject)this.agRedefinitions.get(name));
            }
            i = this.mgRedefinitions.keySet().iterator();
            while (i.hasNext()) {
                name = (QName)i.next();
                state.error("Redefined model group " + QNameHelper.pretty(name) + " not found in " + this.schemaLocation, 60, (XmlObject)this.mgRedefinitions.get(name));
            }
        }
    }
}

