/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDocumentProperties;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.impl.common.GlobalLock;
import org.apache.xmlbeans.impl.common.XMLChar;
import org.apache.xmlbeans.impl.store.CursorData;
import org.apache.xmlbeans.impl.store.Path;
import org.apache.xmlbeans.impl.store.Root;
import org.apache.xmlbeans.impl.store.Saver;
import org.apache.xmlbeans.impl.store.Splay;
import org.apache.xmlbeans.impl.store.Type;
import org.apache.xmlbeans.xml.stream.XMLInputStream;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class Cursor
implements XmlCursor,
Root.ChangeListener {
    private static final XmlOptions _toStringOptions;
    CursorData _data;
    static final /* synthetic */ boolean $assertionsDisabled;

    Cursor(Root r, Splay s) {
        if (!$assertionsDisabled && s == null) {
            throw new AssertionError();
        }
        this._data = CursorData.getOne(r);
        this.set(s);
    }

    Cursor(Root r, Splay s, int p) {
        if (!$assertionsDisabled && s == null) {
            throw new AssertionError();
        }
        this._data = CursorData.getOne(r);
        this.set(s, p);
    }

    public Object monitor() {
        return this.getRoot();
    }

    Root getRoot() {
        return this._data._goober.getRoot();
    }

    Splay getSplay() {
        return this._data._goober.getSplay();
    }

    int getPos() {
        return this._data._goober.getPos();
    }

    void set(Splay s, int p) {
        this._data._goober.set(s, p);
    }

    void set(Splay s) {
        this._data._goober.set(s, 0);
    }

    void set(int p) {
        this._data._goober.set(p);
    }

    void set(Splay.Goober g) {
        this._data._goober.set(g);
    }

    int getPostCch() {
        int p = this.getPos();
        if (p == 0) {
            return 0;
        }
        Splay s = this.getSplay();
        int pa = s.getPosAfter();
        if (!$assertionsDisabled && p < pa && !s.isLeaf()) {
            throw new AssertionError();
        }
        return p >= pa ? s.getCchAfter() - p + pa : s.getPosLeafEnd() - p;
    }

    int getPreCch() {
        Splay sOrig = this.getSplay();
        int pOrig = this.getPos();
        int n = this.toPrevChar(-1);
        this.set(sOrig, pOrig);
        return n;
    }

    private void checkDisposed() {
        Cursor.checkDisposed(this);
    }

    private static void checkDisposed(Cursor c) {
        if (c.isDisposed()) {
            throw new IllegalStateException("Cursor has been disposed");
        }
    }

    boolean isDisposed() {
        return this._data == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.monitor();
        synchronized (object) {
            if (!this.isDisposed()) {
                this._data.release();
                this._data = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlObject getObject() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Root r = this.getRoot();
            if (this.getPos() > 0) {
                return null;
            }
            Splay s = this.getSplay();
            if (!s.isTypeable()) {
                return null;
            }
            Type t = s.getType(r);
            if (!$assertionsDisabled && t == null) {
                throw new AssertionError();
            }
            XmlObject result = t.getXmlObject();
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toCursor(XmlCursor moveTo) {
        if (moveTo == null) {
            throw new IllegalArgumentException("Invalid destination cursor");
        }
        if (this.monitor() == moveTo.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.toCursorImpl(moveTo);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = moveTo.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        boolean bl = this.toCursorImpl(moveTo);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    private boolean toCursorImpl(XmlCursor moveTo) {
        this.checkDisposed();
        Cursor c = null;
        if (moveTo instanceof Cursor) {
            c = (Cursor)moveTo;
            Cursor.checkDisposed(c);
            if (c.getRoot() != this.getRoot()) {
                c = null;
            }
        }
        if (c == null) {
            return false;
        }
        this.set(c._data._goober);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlDocumentProperties documentProperties() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return this.getRoot().documentProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor newCursor() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return new Cursor(this.getRoot(), this.getSplay(), this.getPos());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toBookmark(XmlCursor.XmlBookmark bm) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (bm == null) {
                return false;
            }
            if (!(bm._currentMark instanceof Splay.Annotation)) {
                return false;
            }
            Splay.Annotation a = (Splay.Annotation)bm._currentMark;
            if (a.getRoot() != this.getRoot()) {
                return false;
            }
            if (!$assertionsDisabled && a.getSplay() == null) {
                throw new AssertionError();
            }
            this.set(a);
            return true;
        }
    }

    public XmlCursor.XmlBookmark toNextBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                return null;
            }
            Splay sOrig = this.getSplay();
            int pOrig = this.getPos();
            XmlCursor.TokenType tt = this.currentTokenType();
            if (tt.isText()) {
                this.toNextChar(1);
                tt = this.currentTokenType();
            } else {
                tt = this.toNextToken();
                if (tt.isNone()) {
                    this.set(sOrig, pOrig);
                    return null;
                }
            }
            do {
                int postCch;
                XmlCursor.XmlBookmark bm;
                if ((bm = this.getBookmark(key)) != null) {
                    return bm;
                }
                if (!tt.isText() || (postCch = this.getPostCch()) <= 1) continue;
                Splay s = this.getSplay();
                int p = this.getPos();
                int d = postCch;
                Splay.Goober g = s.firstGoober();
                while (g != null) {
                    XmlCursor.XmlBookmark mark;
                    int dist;
                    if (g.isAnnotation() && (dist = g.getPos() - p) > 1 && dist < d && (mark = g.getBookmark()) != null && mark.getKey().equals(key)) {
                        bm = mark;
                        d = dist;
                    }
                    g = s.nextGoober(g);
                }
                if (bm == null) continue;
                this.set(s, p + d);
                return bm;
            } while (!(tt = this.toNextToken()).isNone());
            this.set(sOrig, pOrig);
            return null;
        }
    }

    public XmlCursor.XmlBookmark toPrevBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                return null;
            }
            Splay sOrig = this.getSplay();
            int pOrig = this.getPos();
            XmlCursor.TokenType tt = this.prevTokenType();
            if (tt.isText()) {
                this.toPrevChar(1);
                tt = this.prevTokenType();
            } else {
                if (this.toPrevToken().isNone()) {
                    this.set(sOrig, pOrig);
                    return null;
                }
                tt = this.prevTokenType();
            }
            while (true) {
                int preCch;
                XmlCursor.XmlBookmark bm;
                if ((bm = this.getBookmark(key)) != null) {
                    return bm;
                }
                if (tt.isText() && (preCch = this.getPreCch()) > 1) {
                    int p;
                    Splay s;
                    if (this.getPos() == 0) {
                        s = this.getSplay().prevNonAttrSplay();
                        p = s.getEndPos();
                    } else {
                        s = this.getSplay();
                        p = this.getPos();
                    }
                    int d = preCch;
                    Splay.Goober g = s.firstGoober();
                    while (g != null) {
                        XmlCursor.XmlBookmark mark;
                        int dist;
                        if (g.isAnnotation() && (dist = p - g.getPos()) > 1 && dist < d && (mark = g.getBookmark()) != null && mark.getKey().equals(key)) {
                            bm = mark;
                            d = dist;
                        }
                        g = s.nextGoober(g);
                    }
                    if (bm != null) {
                        this.set(s, p - d);
                        return bm;
                    }
                }
                if (tt.isText()) {
                    this.toPrevChar(-1);
                    tt = this.prevTokenType();
                    continue;
                }
                if (this.toPrevToken().isNone()) {
                    this.set(sOrig, pOrig);
                    return null;
                }
                tt = this.prevTokenType();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.TokenType currentTokenType() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return this.getSplay().getTokenType(this.getPos());
        }
    }

    public boolean isStartdoc() {
        return this.currentTokenType().isStartdoc();
    }

    public boolean isEnddoc() {
        return this.currentTokenType().isEnddoc();
    }

    public boolean isStart() {
        return this.currentTokenType().isStart();
    }

    public boolean isEnd() {
        return this.currentTokenType().isEnd();
    }

    public boolean isText() {
        return this.currentTokenType().isText();
    }

    public boolean isAttr() {
        return this.currentTokenType().isAttr();
    }

    public boolean isNamespace() {
        return this.currentTokenType().isNamespace();
    }

    public boolean isComment() {
        return this.currentTokenType().isComment();
    }

    public boolean isProcinst() {
        return this.currentTokenType().isProcinst();
    }

    public boolean isContainer() {
        return this.currentTokenType().isContainer();
    }

    public boolean isFinish() {
        return this.currentTokenType().isFinish();
    }

    public boolean isAnyAttr() {
        return this.currentTokenType().isAnyAttr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.TokenType prevTokenType() {
        Object object = this.monitor();
        synchronized (object) {
            XmlCursor.TokenType tt;
            this.checkDisposed();
            Splay sOrig = this.getSplay();
            int pOrig = this.getPos();
            if (this.toPrevChar(1) == 1) {
                tt = XmlCursor.TokenType.TEXT;
            } else {
                tt = this.toPrevToken();
                if (!tt.isNone()) {
                    tt = this.currentTokenType();
                }
            }
            this.set(sOrig, pOrig);
            return tt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.TokenType toNextToken() {
        Object object = this.monitor();
        synchronized (object) {
            Splay t;
            Splay os;
            this.checkDisposed();
            Splay s = os = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isRoot()) {
                    return XmlCursor.TokenType.NONE;
                }
                if (s.isContainer()) {
                    t = s.nextSplay();
                    if (t.isAttr()) {
                        this.set(t, 0);
                        return this.currentTokenType();
                    }
                    s.ensureContentValid();
                }
                if (s.getMaxPos() > 0) {
                    p = 1;
                } else {
                    s = s.nextSplay();
                    p = 0;
                }
            } else {
                if (!$assertionsDisabled && p <= 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s.isRoot()) {
                    throw new AssertionError();
                }
                if (p >= s.getPosAfter() && s.getCchAfter() > 0) {
                    s = s.nextSplay();
                    p = 0;
                } else {
                    if (!$assertionsDisabled && !s.isLeaf()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && p >= s.getPosAfter()) {
                        throw new AssertionError();
                    }
                    if (p != s.getPosLeafEnd()) {
                        p = s.getPosLeafEnd();
                    } else if (s.getCchAfter() > 0) {
                        p = s.getPosAfter();
                    } else {
                        s = s.nextSplay();
                        p = 0;
                    }
                }
            }
            if (p == 0) {
                if (!s.isAttr() && os.isAttr()) {
                    t = os.prevNonAttrSplay();
                    if (!$assertionsDisabled && !t.isContainer()) {
                        throw new AssertionError();
                    }
                    t.ensureContentValid();
                    if (t.getMaxPos() > 0) {
                        s = t;
                        p = 1;
                    }
                } else if (s.isAttr() && !os.isAttr() && os.getMaxPos() > 0) {
                    if (!$assertionsDisabled && !os.isContainer()) {
                        throw new AssertionError();
                    }
                    s = s.nextNonAttrSplay();
                }
            }
            this.set(s, p);
            return this.currentTokenType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.TokenType toPrevToken() {
        Object object = this.monitor();
        synchronized (object) {
            Splay t;
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 1 && s.isInvalid()) {
                if (!$assertionsDisabled && !s.isLeaf()) {
                    throw new AssertionError();
                }
                p += s.ensureContentValid();
            }
            if (p == 1 && s.isContainer() && (t = s.nextSplay()).isAttr()) {
                s = t;
                t = t.nextSplay();
                while (t.isAttr()) {
                    s = t;
                    t = t.nextSplay();
                }
                this.set(s, 0);
                return this.currentTokenType();
            }
            if (p == 0 && !s.isAttr()) {
                if (s.isDoc()) {
                    return XmlCursor.TokenType.NONE;
                }
                t = s.prevSplay();
                if (t.isAttr()) {
                    t = t.prevNonAttrSplay();
                    if (!$assertionsDisabled && !t.isContainer()) {
                        throw new AssertionError();
                    }
                    if (t.isDoc()) {
                        t.ensureContentValid();
                    }
                    if (t.getMaxPos() > 0) {
                        this.set(t, t.getCchAfter() > 0 ? t.getPosAfter() : t.getMaxPos());
                        return this.currentTokenType();
                    }
                }
            }
            if (s.isAttr()) {
                if (!$assertionsDisabled && p != 0) {
                    throw new AssertionError();
                }
                t = s.prevSplay();
                if (!t.isAttr()) {
                    if (!$assertionsDisabled && !t.isContainer()) {
                        throw new AssertionError();
                    }
                    this.set(t, 0);
                    return this.currentTokenType();
                }
            }
            if (p == 0) {
                if (s.isDoc()) {
                    return XmlCursor.TokenType.NONE;
                }
                if ((s = s.prevSplay()).isDoc()) {
                    s.ensureContentValid();
                }
                p = s.getCchAfter() > 0 ? s.getPosAfter() : s.getMaxPos();
            } else {
                if (!$assertionsDisabled && p <= 0) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && s.isRoot()) {
                    throw new AssertionError();
                }
                int posAfter = s.getPosAfter();
                if (p >= posAfter) {
                    if (!$assertionsDisabled && s.getCchAfter() <= 0) {
                        throw new AssertionError();
                    }
                    p = posAfter - 1;
                } else {
                    if (!$assertionsDisabled && !s.isValid()) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !s.isLeaf()) {
                        throw new AssertionError();
                    }
                    p = p > 1 && p == posAfter - 1 ? 1 : 0;
                }
            }
            this.set(s, p);
            return this.currentTokenType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChars(String text) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isDoc() || s.isAttr()) {
                    throw new IllegalStateException("Invalid location for text");
                }
                s = s.prevNonAttrSplay();
                p = s.getEndPos();
            }
            if (text == null) {
                return;
            }
            int cch = text.length();
            if (cch > 0) {
                s.insertChars(p, this.getRoot(), text, 0, cch);
            }
        }
    }

    private static void validateLocalName(QName name) {
        if (name == null) {
            throw new IllegalArgumentException("QName is null");
        }
        Cursor.validateLocalName(name.getLocalPart());
    }

    private static void validateLocalName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Name is empty");
        }
        if (!XMLChar.isValidNCName(name)) {
            throw new IllegalArgumentException("Name is not valid");
        }
    }

    private static void validatePrefix(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Prefix is null");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Prefix is empty");
        }
        if (Splay.beginsWithXml(name)) {
            throw new IllegalArgumentException("Prefix begins with 'xml'");
        }
        if (!XMLChar.isValidNCName(name)) {
            throw new IllegalArgumentException("Prefix is not valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertAttribute(QName name, String value) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.insert(new Splay.Attr(name), value);
        }
    }

    public void insertAttribute(String name) {
        this.insertAttributeWithValue(name, null, null);
    }

    public void insertAttribute(String name, String uri) {
        this.insertAttributeWithValue(name, uri, null);
    }

    public void insertAttributeWithValue(String name, String value) {
        this.insertAttributeWithValue(name, null, value);
    }

    public void insertAttributeWithValue(String name, String uri, String value) {
        Cursor.validateLocalName(name);
        this.insertAttribute(new QName(uri, name), value);
    }

    public void insertAttribute(QName name) {
        Cursor.validateLocalName(name);
        this.insertAttribute(name, null);
    }

    public void insertAttributeWithValue(QName name, String value) {
        Cursor.validateLocalName(name);
        this.insertAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNamespace(String prefix, String namespace) {
        Object object = this.monitor();
        synchronized (object) {
            if (prefix == null) {
                prefix = "";
            } else if (prefix.length() > 0) {
                Cursor.validatePrefix(prefix);
            }
            if (namespace == null) {
                namespace = "";
            }
            if (namespace.length() == 0 && prefix.length() > 0) {
                throw new IllegalArgumentException("Can't map a prefix to no namespace");
            }
            this.insert(new Splay.Xmlns(new QName(namespace, prefix)), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertComment(String value) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.insert(new Splay.Comment(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertProcInst(String target, String value) {
        Cursor.validateLocalName(target);
        if (Splay.beginsWithXml(target) && target.length() == 3) {
            throw new IllegalArgumentException("Target begins with 'xml'");
        }
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.insert(new Splay.Procinst(target), value);
        }
    }

    public void insertElement(String name) {
        this.insertElementWithText(name, null, null);
    }

    public void insertElementWithText(String name, String text) {
        this.insertElementWithText(name, null, text);
    }

    public void insertElement(String name, String uri) {
        this.insertElementWithText(name, uri, null);
    }

    public void insertElement(QName name) {
        this.insertElementWithText(name, null);
    }

    public void beginElement(QName name) {
        this.insertElement(name);
        this.toPrevToken();
    }

    public void beginElement(String name) {
        this.insertElement(name);
        this.toPrevToken();
    }

    public void beginElement(String name, String uri) {
        this.insertElement(name, uri);
        this.toPrevToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertElementWithText(QName name, String text) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Cursor.validateLocalName(name.getLocalPart());
            Splay.Begin b = new Splay.Begin(name, null);
            b.toggleIsLeaf();
            this.insert(b, text);
        }
    }

    public void insertElementWithText(String name, String uri, String text) {
        this.insertElementWithText(new QName(uri, name), text);
    }

    void insert(Splay sInsert, String value) {
        if (!$assertionsDisabled && this.isDisposed()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && sInsert.getRootSlow() != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sInsert.getCch() != 0) {
            throw new AssertionError();
        }
        if (value != null) {
            sInsert.adjustCch(value.length());
        }
        Splay s = this.getSplay();
        int p = this.getPos();
        sInsert.checkInsertionValidity(0, s, p, false);
        if (value != null) {
            s.insert(this.getRoot(), p, sInsert, value, 0, value.length(), true);
        } else {
            s.insert(this.getRoot(), p, sInsert, null, 0, 0, true);
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextValue() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || s.isFinish() || s.isXmlns()) {
                throw new IllegalStateException("Can't get text value, current token can have no text value");
            }
            return this.getSplay().getText(this.getRoot());
        }
    }

    public int getTextValue(char[] buf, int off, int cch) {
        String s = this.getTextValue();
        int n = s.length();
        if (n > cch) {
            n = cch;
        }
        if (n <= 0) {
            return 0;
        }
        s.getChars(0, n, buf, off);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextValue(String text) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p > 0 || s.isXmlns() || s.isFinish()) {
                throw new IllegalStateException("Can't set text value, current token can have no text value");
            }
            s.setText(this.getRoot(), text, 0, text == null ? 0 : text.length());
        }
    }

    public void setTextValue(char[] buf, int off, int len) {
        this.setTextValue(String.copyValueOf(buf, off, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChars() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int cch = -1;
            int postCch = this.getPostCch();
            if (cch < 0 || cch > postCch) {
                cch = postCch;
            }
            return this.getRoot()._text.fetch(this.getSplay().getCpForPos(this.getRoot(), this.getPos()), cch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChars(char[] buf, int off, int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int postCch = this.getPostCch();
            if (cch < 0 || cch > postCch) {
                cch = postCch;
            }
            if (buf == null || off >= buf.length) {
                return 0;
            }
            if (buf.length - off < cch) {
                cch = buf.length - off;
            }
            this.getRoot()._text.fetch(buf, off, this.getSplay().getCpForPos(this.getRoot(), this.getPos()), cch);
            return cch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBookmark(XmlCursor.XmlBookmark annotation) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (annotation == null) {
                return;
            }
            this.clearBookmark(annotation.getKey());
            Splay.Annotation a = new Splay.Annotation(this.getRoot(), annotation);
            if (a._key == null) {
                throw new IllegalArgumentException("Annotation key is null");
            }
            a.set(this._data._goober);
            annotation._currentMark = a;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.XmlBookmark getBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                return null;
            }
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                Splay.Annotation a;
                XmlCursor.XmlBookmark xa;
                if (g.getKind() == 2 && g.getPos() == p && (xa = (a = (Splay.Annotation)g).getXmlBookmark()) != null && a._key.equals(key)) {
                    return xa;
                }
                g = s.nextGoober(g);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBookmark(Object key) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (key == null) {
                return;
            }
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                Splay.Annotation a;
                XmlCursor.XmlBookmark xa;
                if (g.getKind() == 2 && g.getPos() == p && (xa = (a = (Splay.Annotation)g).getXmlBookmark()) != null && a._key.equals(key)) {
                    g.set(null, 0);
                    return;
                }
                g = s.nextGoober(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllBookmarkRefs(Collection listToFill) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (listToFill == null) {
                return;
            }
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay.Goober g = s.firstGoober();
            while (g != null) {
                if (g.getKind() == 2 && g.getPos() == p) {
                    listToFill.add(((Splay.Annotation)g).getXmlBookmark());
                }
                g = s.nextGoober(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (!$assertionsDisabled && this.getSplay().isRoot() && this.getPos() != 0) {
                throw new AssertionError();
            }
            return !this.getSplay().isRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPrevToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return !this.getSplay().isDoc() || this.getPos() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QName getName() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this.getPos() > 0) {
                return null;
            }
            Splay s = this.getSplay();
            switch (s.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    return s.getName();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(QName name) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (name == null) {
                throw new IllegalArgumentException("Name is null");
            }
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isBegin() && !s.isAttr() && !s.isProcinst()) {
                throw new IllegalStateException("Can't set name here: " + this.currentTokenType());
            }
            if (s.isProcinst()) {
                Cursor.validatePrefix(name.getLocalPart());
                if (name.getNamespaceURI().length() > 0) {
                    throw new IllegalArgumentException("Procinst name must have no URI");
                }
            } else if (s.isXmlns()) {
                if (name.getLocalPart().length() > 0) {
                    Cursor.validatePrefix(name.getLocalPart());
                }
            } else {
                Cursor.validateLocalName(name.getLocalPart());
            }
            s.setName(this.getRoot(), name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toNextChar(int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            int maxCch = this.getPostCch();
            if (maxCch == 0 || cch == 0) {
                return 0;
            }
            if (cch < 0 || cch > maxCch) {
                cch = maxCch;
            }
            if (!$assertionsDisabled && p + cch > s.getEndPos()) {
                throw new AssertionError();
            }
            if (p + cch == s.getEndPos()) {
                this.toNextToken();
            } else {
                this.set(p + cch);
            }
            return cch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toPrevChar(int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            Splay sText = s;
            int pText = p;
            int maxCch = 0;
            if (p == 0) {
                if (!s.isDoc() && !s.isAttr()) {
                    sText = s.prevNonAttrSplay();
                    pText = sText.getEndPos();
                    maxCch = sText.getCchAfter();
                }
            } else if (s.isLeaf() && p <= s.getPosLeafEnd()) {
                int dCch = s.ensureContentValid();
                pText = p += dCch;
                maxCch = p - 1;
            } else {
                maxCch = p - s.getPosAfter();
            }
            if (!$assertionsDisabled && pText > sText.getEndPos()) {
                throw new AssertionError();
            }
            if (maxCch == 0 || cch == 0) {
                return 0;
            }
            if (cch < 0 || cch > maxCch) {
                cch = maxCch;
            }
            this.set(sText, pText - cch);
            return cch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toEndDoc() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.set(this.getRoot(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toStartDoc() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this.set(this.getRoot()._doc, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.TokenType toFirstContentToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                return XmlCursor.TokenType.NONE;
            }
            s.ensureContentValid();
            if (s.getCch() > 0 || s.isLeaf()) {
                this.set(1);
            } else {
                this.set(s.nextNonAttrSplay(), 0);
            }
            return this.currentTokenType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.TokenType toEndToken() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                return XmlCursor.TokenType.NONE;
            }
            if (s.isLeaf()) {
                this.set(s.getPosLeafEnd());
            } else {
                this.set(s.getFinishSplay());
            }
            return this.currentTokenType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toParent() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0 && s.isDoc()) {
                return false;
            }
            this.set(s.getContainer(p), 0);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toNextSibling() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isDoc()) {
                    return false;
                }
                if (s.isBegin()) {
                    s = s.getFinishSplay().nextSplay();
                }
            } else {
                if (s.isLeaf() && p <= s.getPosLeafEnd()) {
                    return false;
                }
                s = s.nextSplay();
            }
            while (!s.isBegin()) {
                if (s.isFinish()) {
                    return false;
                }
                s = s.nextSplay();
            }
            this.set(s, 0);
            return true;
        }
    }

    public boolean toNextSibling(String name) {
        return this.toNextSibling(new QName(name));
    }

    public boolean toNextSibling(String namespace, String name) {
        return this.toNextSibling(new QName(namespace, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toNextSibling(QName name) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            while (this.toNextSibling()) {
                if (!this.getName().equals(name)) continue;
                return true;
            }
            this.set(sOriginal, pOriginal);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toPrevSibling() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (p == 0) {
                if (s.isDoc() || s.isAttr()) {
                    return false;
                }
                s = s.prevSplay();
            } else {
                if (!$assertionsDisabled && p <= 0) {
                    throw new AssertionError();
                }
                if (s.isContainer()) {
                    if (s.isLeaf()) {
                        if (p <= s.getPosLeafEnd()) {
                            return false;
                        }
                        this.set(0);
                        return true;
                    }
                    return false;
                }
            }
            while (true) {
                if (s.isEnd()) {
                    s = s.getContainer();
                    break;
                }
                if (s.isLeaf()) break;
                if (s.isContainer()) {
                    return false;
                }
                s = s.prevSplay();
            }
            this.set(s, 0);
            return true;
        }
    }

    private Splay getStart() {
        this.checkDisposed();
        Splay s = this.getSplay();
        if (!s.isContainer() || this.getPos() != 0) {
            this.push();
            s = this.toNextSibling() ? this.getSplay() : null;
            this.pop();
        }
        return s;
    }

    public boolean toFirstChild() {
        return this.toChild((QName)null);
    }

    public boolean toChild(String name) {
        return this.toChild(new QName(name));
    }

    public boolean toChild(String namespace, String name) {
        return this.toChild(new QName(namespace, name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toChild(QName name) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay.Begin s = this.getRoot().findNthBegin(this.getStart(), name, null, 0);
            if (s == null) {
                return false;
            }
            this.set(s, 0);
            return true;
        }
    }

    public boolean toChild(int n) {
        return this.toChild(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toChild(QName name, int n) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay.Begin s = this.getRoot().findNthBegin(this.getStart(), name, null, n);
            if (s == null) {
                return false;
            }
            this.set(s, 0);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toLastChild() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            if (!(sOriginal.isContainer() && pOriginal == 0 || this.toNextSibling())) {
                return false;
            }
            if (!this.toEndToken().isNone() && this.toPrevSibling()) {
                return true;
            }
            this.set(sOriginal, pOriginal);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toFirstAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            if (!sOriginal.isContainer() || pOriginal != 0) {
                return false;
            }
            Splay s = sOriginal.nextSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    this.set(s, 0);
                    return true;
                }
                s = s.nextSplay();
            }
            this.set(sOriginal, pOriginal);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toLastAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay sOriginal = this.getSplay();
            int pOriginal = this.getPos();
            if (!sOriginal.isContainer() || pOriginal != 0) {
                return false;
            }
            Splay lastNormalAttr = null;
            Splay s = sOriginal.nextSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    lastNormalAttr = s;
                }
                s = s.nextSplay();
            }
            if (lastNormalAttr != null) {
                this.set(lastNormalAttr, 0);
                return true;
            }
            this.set(sOriginal, pOriginal);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toNextAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (!s.isAttr()) {
                return false;
            }
            s = s.nextSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    this.set(s, 0);
                    return true;
                }
                s = s.nextSplay();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toPrevAttribute() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (!s.isAttr()) {
                return false;
            }
            s = s.prevSplay();
            while (s.isAttr()) {
                if (s.isNormalAttr()) {
                    this.set(s, 0);
                    return true;
                }
                s = s.prevSplay();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttributeText(QName attrName) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (attrName == null) {
                throw new IllegalArgumentException("Attr name is null");
            }
            if (this.getPos() > 0) {
                return null;
            }
            Splay s = this.getSplay().getAttr(attrName);
            String string = s == null ? null : s.getText(this.getRoot());
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAttributeText(QName attrName, String value) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (attrName == null) {
                throw new IllegalArgumentException("Attr name is null");
            }
            Cursor.validateLocalName(attrName.getLocalPart());
            if (this.getPos() > 0) {
                return false;
            }
            Splay s = this.getSplay();
            if (!s.isContainer()) {
                return false;
            }
            if (value == null) {
                value = "";
            }
            if ((s = this.getSplay().getAttr(attrName)) == null) {
                XmlCursor c = this.newCursor();
                try {
                    do {
                        c.toNextToken();
                    } while (c.isAnyAttr());
                    c.insertAttributeWithValue(attrName, value);
                }
                finally {
                    c.dispose();
                }
            } else {
                s.setText(this.getRoot(), value, 0, value.length());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAttribute(QName attrName) {
        Object object = this.monitor();
        synchronized (object) {
            Splay s;
            this.checkDisposed();
            if (attrName == null) {
                throw new IllegalArgumentException("Attr name is null");
            }
            if (this.getPos() > 0) {
                return false;
            }
            boolean removed = false;
            while ((s = this.getSplay().getAttr(attrName)) != null) {
                s.remove(this.getRoot(), true);
                removed = true;
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeChars(int cch) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            int postCch = this.getPostCch();
            if (postCch == 0 || cch == 0) {
                return 0;
            }
            if (cch < 0 || cch > postCch) {
                cch = postCch;
            }
            return this.getSplay().removeChars(this.getRoot(), this.getPos(), cch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveChars(int cch, XmlCursor dst) {
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (this.monitor() == dst.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.moveCharsImpl(cch, dst);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = dst.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        int n = this.moveCharsImpl(cch, dst);
                        return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    private int moveCharsImpl(int cch, XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Invalid destination cursor");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Root rDst = cDst.getRoot();
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        if (pDst == 0 && (sDst.isDoc() || sDst.isAttr())) {
            throw new IllegalArgumentException("Invalid destination");
        }
        return this.getSplay().moveChars(this.getRoot(), this.getPos(), cch, rDst, sDst, pDst, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyChars(int cch, XmlCursor dst) {
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.copyCharsImpl(cch, dst);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = dst.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        int n = this.copyCharsImpl(cch, dst);
                        return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    private int copyCharsImpl(int cch, XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Invalid destination cursor");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Root rDst = cDst.getRoot();
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        if (pDst == 0) {
            if (sDst.isDoc() || sDst.isAttr()) {
                throw new IllegalArgumentException("Invalid destination");
            }
            sDst = sDst.prevNonAttrSplay();
            pDst = sDst.getEndPos();
        }
        return this.getSplay().copyChars(this.getRoot(), this.getPos(), cch, rDst, sDst, pDst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String namespaceForPrefix(String prefix) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                throw new IllegalStateException("Not on a container");
            }
            return s.namespaceForPrefix(prefix, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prefixForNamespace(String ns) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (ns == null || ns.length() == 0) {
                throw new IllegalArgumentException("Must specify a namespace");
            }
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                throw new IllegalStateException("Not on a container");
            }
            String result = s.prefixForNamespace(this.getRoot(), ns, null, true);
            if (!$assertionsDisabled && result == null) {
                throw new AssertionError();
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAllNamespaces(Map addToThis) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            if (this.getPos() > 0 || !s.isContainer()) {
                throw new IllegalStateException("Not on a container");
            }
            XmlCursor c = this.newCursor();
            do {
                if (!$assertionsDisabled && !c.isContainer()) {
                    throw new AssertionError();
                }
                QName cName = c.getName();
                while (!c.toNextToken().isNone() && c.isAnyAttr()) {
                    if (!c.isNamespace()) continue;
                    String prefix = c.getName().getLocalPart();
                    String uri = c.getName().getNamespaceURI();
                    if (prefix.length() == 0 && uri.length() > 0 && cName != null && cName.getNamespaceURI().length() > 0 || addToThis.containsKey(prefix)) continue;
                    addToThis.put(prefix, uri);
                }
                c.toParent();
            } while (c.toParent());
            c.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int comparePosition(XmlCursor xthat) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (xthat == null || !(xthat instanceof Cursor)) {
                throw new IllegalArgumentException("Invalid that cursor");
            }
            Cursor that = (Cursor)xthat;
            Root r = this.getRoot();
            if (r != that.getRoot()) {
                throw new IllegalArgumentException("Cursors not in same document");
            }
            Cursor.checkDisposed(that);
            return this.getSplay().compare(r, this.getPos(), that.getSplay(), that.getPos());
        }
    }

    public boolean isLeftOf(XmlCursor that) {
        return this.comparePosition(that) < 0;
    }

    public boolean isAtSamePositionAs(XmlCursor that) {
        return this.comparePosition(that) == 0;
    }

    public boolean isRightOf(XmlCursor that) {
        return this.comparePosition(that) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newInputStream(XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return new Saver.InputStreamSaver(this.getRoot(), this.getSplay(), this.getPos(), options);
        }
    }

    public InputStream newInputStream() {
        return this.newInputStream(null);
    }

    public Reader newReader() {
        return this.newReader(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader newReader(XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return new Saver.TextReader(this.getRoot(), this.getSplay(), this.getPos(), options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLInputStream newXMLInputStream(XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return new Saver.XmlInputStreamImpl(this.getRoot(), this.getSplay(), this.getPos(), options);
        }
    }

    public XMLInputStream newXMLInputStream() {
        return this.newXMLInputStream(null);
    }

    static final XmlOptions buildPrettyOptions() {
        XmlOptions options = new XmlOptions();
        options.put("SAVE_PRETTY_PRINT");
        options.put("SAVE_AGGRESSIVE_NAMESPACES");
        options.put("SAVE_USE_DEFAULT_NAMESPACE");
        return options;
    }

    public String toString() {
        return this.xmlText(_toStringOptions);
    }

    public String xmlText() {
        return this.xmlText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String xmlText(XmlOptions options) {
        Saver.TextSaver saver;
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            saver = new Saver.TextSaver(this.getRoot(), this.getSplay(), this.getPos(), options, null);
        }
        return saver.saveToString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor.ChangeStamp getDocChangeStamp() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return new ChangeStampImpl(this.getRoot());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeXml() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            Splay s = this.getSplay();
            int p = this.getPos();
            if (!$assertionsDisabled && p >= s.getEndPos()) {
                throw new AssertionError();
            }
            if (p > 0) {
                if (s.isLeaf() && p == s.getPosLeafEnd()) {
                    return false;
                }
                int cchRemove = this.removeChars(this.getPostCch());
                if (!$assertionsDisabled && cchRemove <= 0) {
                    throw new AssertionError();
                }
                return true;
            }
            if (s.isDoc()) {
                throw new IllegalStateException("Can't remove a whole document.");
            }
            if (s.isFinish()) {
                return false;
            }
            s.remove(this.getRoot(), true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveXml(XmlCursor dst) {
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.moveXmlImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = dst.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        boolean bl = this.moveXmlImpl(dst);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    private boolean moveXmlImpl(XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Can't move to a foreign document");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Root rDst = cDst.getRoot();
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        Root rSrc = this.getRoot();
        Splay sSrc = this.getSplay();
        int pSrc = this.getPos();
        if (sSrc.checkInsertionValidity(pSrc, sDst, pDst, true)) {
            return sSrc.moveChars(rSrc, pSrc, this.getPostCch(), rDst, sDst, pDst, false) > 0;
        }
        if (!$assertionsDisabled && pSrc != 0) {
            throw new AssertionError();
        }
        if (rSrc == rDst && sDst.between(rDst, pDst, sSrc)) {
            return false;
        }
        if (!$assertionsDisabled && pSrc != 0) {
            throw new AssertionError();
        }
        sSrc.move(rSrc, cDst.getRoot(), cDst.getSplay(), cDst.getPos(), true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyXml(XmlCursor dst) {
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.copyXmlImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = dst.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        boolean bl = this.copyXmlImpl(dst);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    private boolean copyXmlImpl(XmlCursor dst) {
        this.checkDisposed();
        if (dst == null || !(dst instanceof Cursor)) {
            throw new IllegalArgumentException("Can't copy to a foreign document");
        }
        Cursor cDst = (Cursor)dst;
        Cursor.checkDisposed(cDst);
        Splay sDst = cDst.getSplay();
        int pDst = cDst.getPos();
        Splay s = this.getSplay();
        int p = this.getPos();
        if (s.checkInsertionValidity(p, sDst, pDst, true)) {
            return this.copyCharsImpl(this.getPostCch(), dst) > 0;
        }
        if (!$assertionsDisabled && p != 0) {
            throw new AssertionError();
        }
        Root r = this.getRoot();
        Root rDst = cDst.getRoot();
        Splay copy = s.copySplay();
        Object txt = r._text;
        int cp = r.getCp(s);
        int cch = copy.getCchLeft() + copy.getCch();
        if (s.isLeaf() && s.getCchAfter() > 0) {
            int cchValue = s.getCchValue();
            int cchAfter = s.getCchAfter();
            if (cchValue == 0) {
                cp += cchAfter;
            } else if (s.nextSplay().isAttr()) {
                char[] buf = new char[cch];
                r._text.fetch(buf, 0, cp, cchValue);
                r._text.fetch(buf, cchValue, cp + cchValue + cchAfter, cch - cchValue);
                txt = buf;
                cp = 0;
            }
        }
        sDst.insert(rDst, pDst, copy, txt, cp, cch, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeXmlContents() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (!this.isContainer()) {
                return false;
            }
            XmlCursor.TokenType tt = this.toFirstContentToken();
            if (!$assertionsDisabled && tt.isNone()) {
                throw new AssertionError();
            }
            boolean removed = !this.isFinish();
            try {
                while (!this.isFinish()) {
                    boolean b = this.removeXml();
                    if (!$assertionsDisabled && !b) {
                        throw new AssertionError();
                    }
                }
            }
            finally {
                this.toParent();
            }
            return removed;
        }
    }

    private boolean contains(XmlCursor dst) {
        if (this.isInSameDocument(dst)) {
            dst.push();
            do {
                if (!dst.isAtSamePositionAs(this)) continue;
                dst.pop();
                return true;
            } while (dst.toParent());
            dst.pop();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveXmlContents(XmlCursor dst) {
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.moveXmlContentsImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = dst.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        boolean bl = this.moveXmlContentsImpl(dst);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean moveXmlContentsImpl(XmlCursor dst) {
        this.checkDisposed();
        if (!this.isContainer()) {
            return false;
        }
        if (this.contains(dst)) {
            return false;
        }
        XmlCursor.TokenType tt = this.toFirstContentToken();
        if (!$assertionsDisabled && tt.isNone()) {
            throw new AssertionError();
        }
        boolean moved = !this.isFinish();
        try {
            if (!this.moveXmlImpl(dst)) {
                boolean bl = false;
                return bl;
            }
            while (!this.isFinish()) {
                boolean b = this.moveXmlImpl(dst);
                if (!$assertionsDisabled && !b) {
                    throw new AssertionError();
                }
            }
        }
        finally {
            this.toParent();
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyXmlContents(XmlCursor dst) {
        if (dst == null) {
            throw new IllegalArgumentException("Destination is null");
        }
        if (dst.monitor() == this.monitor()) {
            Object object = this.monitor();
            synchronized (object) {
                return this.copyXmlContentsImpl(dst);
            }
        }
        boolean acquired = false;
        try {
            GlobalLock.acquire();
            acquired = true;
            Object object = this.monitor();
            synchronized (object) {
                Object object2 = dst.monitor();
                synchronized (object2) {
                    try {
                        GlobalLock.release();
                        acquired = false;
                        boolean bl = this.copyXmlContentsImpl(dst);
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new XmlRuntimeException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        finally {
            if (acquired) {
                GlobalLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyXmlContentsImpl(XmlCursor dst) {
        boolean copied;
        block12: {
            this.checkDisposed();
            if (!this.isContainer()) {
                return false;
            }
            if (this.contains(dst)) {
                XmlCursor cTmp = XmlObject.Factory.newInstance().newCursor();
                cTmp.toNextToken();
                if (!this.copyXmlContentsImpl(cTmp)) {
                    cTmp.dispose();
                    return false;
                }
                cTmp.toStartDoc();
                ((Cursor)cTmp).moveXmlContentsImpl(dst);
                cTmp.dispose();
                return true;
            }
            XmlCursor.TokenType tt = this.toFirstContentToken();
            if (!$assertionsDisabled && tt.isNone()) {
                throw new AssertionError();
            }
            copied = !this.isFinish();
            try {
                boolean b;
                if (!this.copyXmlImpl(dst)) {
                    boolean bl = false;
                    return bl;
                }
                do {
                    if (this.isStart()) {
                        this.toEndToken();
                    }
                    this.toNextToken();
                    if (this.isFinish()) {
                        break block12;
                    }
                    b = this.copyXmlImpl(dst);
                } while ($assertionsDisabled || b);
                throw new AssertionError();
            }
            finally {
                this.toParent();
            }
        }
        return copied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInSameDocument(XmlCursor xthat) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (xthat == null || !(xthat instanceof Cursor)) {
                return false;
            }
            Cursor that = (Cursor)xthat;
            Cursor.checkDisposed(that);
            return this.getRoot() == that.getRoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._stack == null) {
                this._data._stack = new Selections();
            }
            this._data._stack.add(this.getRoot(), this.getSplay(), this.getPos());
            this.getRoot().registerForChange(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pop() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._stack == null || this._data._stack.size() == 0) {
                return false;
            }
            this._data._stack.setCursor(this, this._data._stack.size() - 1);
            this._data._stack.pop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSelectionCount() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return this._data._selections == null ? 0 : this._data._selections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toSelection(int i) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections != null && i >= 0 && this._data._selections.setCursor(this, i)) {
                this._data._currentSelection = i;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextSelection() {
        Object object = this.monitor();
        synchronized (object) {
            boolean bl;
            this.push();
            int currentSelection = this._data._currentSelection;
            try {
                bl = this.toNextSelection();
                this.pop();
            }
            catch (Throwable throwable) {
                this.pop();
                this._data._currentSelection = currentSelection;
                throw throwable;
            }
            this._data._currentSelection = currentSelection;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toNextSelection() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections == null || this._data._currentSelection < -1) {
                return false;
            }
            int nextSelection = this._data._currentSelection + 1;
            if (!this._data._selections.setCursor(this, nextSelection)) {
                this._data._currentSelection = -2;
                return false;
            }
            this._data._currentSelection = nextSelection;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelections() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            this._data.clearSelections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSelection() {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections == null) {
                this._data._selections = Path.newSelections();
            }
            this._data._selections.size();
            this._data._selections.add(this.getRoot(), this.getSplay(), this.getPos());
            this.getRoot().registerForChange(this);
        }
    }

    public void changeNotification() {
        if (!this.isDisposed()) {
            if (this._data._selections != null) {
                this._data._selections.size();
                this._data._selections.cursify(this.getRoot());
            }
            if (this._data._stack != null) {
                this._data._stack.cursify(this.getRoot());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectPath(String path, XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            if (this._data._selections == null) {
                this._data._selections = Path.newSelections();
            } else {
                this._data._selections.dispose();
            }
            this._data._selections.init(Path.select(this.getRoot(), this.getSplay(), this.getPos(), path, options));
            this.push();
            if (this._data._selections.setCursor(this, 0)) {
                this.getRoot().registerForChange(this);
                this._data._currentSelection = -1;
            } else {
                this._data._currentSelection = -2;
            }
            this.pop();
        }
    }

    public void selectPath(String path) {
        this.selectPath(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlCursor execQuery(String queryExpr, XmlOptions options) {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            return Path.query(this, queryExpr, options);
        }
    }

    public XmlCursor execQuery(String query) {
        return this.execQuery(query, null);
    }

    public Node newDomNode() {
        return this.newDomNode(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node newDomNode(XmlOptions options) {
        try {
            Saver.DomSaver saver;
            Object object = this.monitor();
            synchronized (object) {
                this.checkDisposed();
                saver = new Saver.DomSaver(this.getRoot(), this.getSplay(), this.getPos(), !this.isFragment(), options);
            }
            return saver.exportDom();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean isFragment() {
        block19: {
            if (!this.isStartdoc()) {
                return true;
            }
            seenElement = false;
            c = this.newCursor();
            token = c.toNextToken().intValue();
            try {
                block14: while (true) {
                    switch (token) {
                        case 3: {
                            if (seenElement) {
                                var4_4 = true;
                                return var4_4;
                            }
                            seenElement = true;
                            token = c.toEndToken().intValue();
                            continue block14;
                        }
                        case 5: {
                            if (!Splay.isWhiteSpace(c.getChars())) {
                                var4_5 = true;
                                return var4_5;
                            }
                            token = c.toNextToken().intValue();
                            continue block14;
                        }
                        case 0: 
                        case 2: {
                            ** break;
lbl24:
                            // 1 sources

                            break block19;
                        }
                        case 6: 
                        case 7: {
                            var4_6 = true;
                            return var4_6;
                        }
                        case 4: 
                        case 8: 
                        case 9: {
                            token = c.toNextToken().intValue();
                            continue block14;
                        }
                        case 1: {
                            if (!Cursor.$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break block19;
                        }
                        default: {
                            continue block14;
                        }
                    }
                    break;
                }
            }
            finally {
                c.dispose();
            }
        }
        return seenElement == false;
    }

    public void save(ContentHandler ch, LexicalHandler lh) throws SAXException {
        this.save(ch, lh, null);
    }

    public void save(File file) throws IOException {
        this.save(file, null);
    }

    public void save(OutputStream os) throws IOException {
        this.save(os, null);
    }

    public void save(Writer w) throws IOException {
        this.save(w, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(ContentHandler ch, LexicalHandler lh, XmlOptions options) throws SAXException {
        Object object = this.monitor();
        synchronized (object) {
            this.checkDisposed();
            new Saver.SaxSaver(this.getRoot(), this.getSplay(), this.getPos(), options, ch, lh);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file, XmlOptions options) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.save(os, options);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream os, XmlOptions options) throws IOException {
        InputStream is = this.newInputStream(options);
        try {
            int n;
            byte[] bytes = new byte[8192];
            while ((n = is.read(bytes)) >= 0) {
                os.write(bytes, 0, n);
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Writer w, XmlOptions options) throws IOException {
        Reader r = this.newReader(options);
        try {
            int n;
            char[] chars = new char[8192];
            while ((n = r.read(chars)) >= 0) {
                w.write(chars, 0, n);
            }
        }
        finally {
            r.close();
        }
    }

    private boolean validate() {
        if (!$assertionsDisabled && !this._data._goober.getRoot().validate()) {
            throw new AssertionError();
        }
        return true;
    }

    public void dump() {
        this._data._goober.getRoot().dump();
    }

    public void dump(boolean verbose) {
        this._data._goober.getRoot().dump(verbose);
    }

    static {
        $assertionsDisabled = !Cursor.class.desiredAssertionStatus();
        _toStringOptions = Cursor.buildPrettyOptions();
    }

    static class Selections {
        private Splay[] _splays;
        private int[] _positions;
        private int _count;
        private ArrayList _cursors;
        private PathEngine _pathEngine;
        static final /* synthetic */ boolean $assertionsDisabled;

        Selections() {
        }

        void init(PathEngine pathEngine) {
            this.dispose();
            this._pathEngine = pathEngine;
        }

        void add(Root r, Splay s) {
            this.add(r, s, 0);
        }

        void add(Root r, Splay s, int p) {
            if (!$assertionsDisabled && s.getRootSlow() != r) {
                throw new AssertionError();
            }
            if (this._cursors != null) {
                Splay.CursorGoober g = new Splay.CursorGoober(r);
                g.set(s, p);
                this._cursors.add(g);
                return;
            }
            if (this._splays == null) {
                if (!$assertionsDisabled && this._count != 0) {
                    throw new AssertionError();
                }
                this._splays = new Splay[16];
                this._positions = new int[16];
            } else if (this._count == this._splays.length) {
                Splay[] newSplays = new Splay[this._count * 2];
                int[] newPositions = new int[this._count * 2];
                System.arraycopy(this._splays, 0, newSplays, 0, this._count);
                System.arraycopy(this._positions, 0, newPositions, 0, this._count);
                this._splays = newSplays;
                this._positions = newPositions;
            }
            this._splays[this._count] = s;
            this._positions[this._count] = p;
            ++this._count;
        }

        void pop() {
            if (!$assertionsDisabled && this.size() <= 0) {
                throw new AssertionError();
            }
            if (this._cursors != null) {
                int i = this._cursors.size() - 1;
                ((Splay.CursorGoober)this._cursors.get(i)).set(null, 0);
                this._cursors.remove(i);
            } else {
                --this._count;
            }
        }

        void cursify(Root r) {
            if (this._cursors != null || this._count <= 0) {
                return;
            }
            this._cursors = new ArrayList();
            for (int i = 0; i < this._count; ++i) {
                Splay.CursorGoober g = new Splay.CursorGoober(r);
                g.set(this._splays[i], this._positions[i]);
                this._cursors.add(g);
            }
            this._count = 0;
        }

        int size() {
            if (this._pathEngine != null) {
                while (this._pathEngine.next(this)) {
                }
                this._pathEngine = null;
            }
            return this.currentSize();
        }

        int currentSize() {
            return this._cursors != null ? this._cursors.size() : this._count;
        }

        boolean setCursor(Cursor c, int i) {
            if (!$assertionsDisabled && i < 0) {
                throw new AssertionError();
            }
            while (this._pathEngine != null && this.currentSize() <= i) {
                if (this._pathEngine.next(this)) continue;
                this._pathEngine = null;
            }
            if (i >= this.currentSize()) {
                return false;
            }
            if (this._cursors != null) {
                if (!$assertionsDisabled && i >= this._cursors.size()) {
                    throw new AssertionError();
                }
                c.set((Splay.CursorGoober)this._cursors.get(i));
            } else {
                if (!$assertionsDisabled && i >= this._count) {
                    throw new AssertionError();
                }
                c.set(this._splays[i], this._positions[i]);
            }
            return true;
        }

        void dispose() {
            if (this._cursors != null) {
                for (int i = 0; i < this._cursors.size(); ++i) {
                    ((Splay.CursorGoober)this._cursors.get(i)).set(null, 0);
                }
                this._cursors.clear();
                this._cursors = null;
            }
            this._count = 0;
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Cursor == null ? (class$org$apache$xmlbeans$impl$store$Cursor = Cursor.class$("org.apache.xmlbeans.impl.store.Cursor")) : class$org$apache$xmlbeans$impl$store$Cursor).desiredAssertionStatus();
        }
    }

    static interface PathEngine {
        public boolean next(Selections var1);
    }

    static class ChangeStampImpl
    implements XmlCursor.ChangeStamp {
        private final Root _root;
        private final long _versionStamp;

        ChangeStampImpl(Root r) {
            this._root = r;
            this._versionStamp = this._root.getVersion();
        }

        public boolean hasChanged() {
            return this._versionStamp != this._root.getVersion();
        }
    }
}

