/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.util.ArrayList;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.Root;
import org.apache.xmlbeans.impl.store.Splay;

public final class CursorData {
    private static ThreadLocal tl_CachedCursorData = new ThreadLocal(){

        protected Object initialValue() {
            return new ArrayList();
        }
    };
    public final Splay.CursorGoober _goober;
    protected Cursor.Selections _stack;
    protected Cursor.Selections _selections;
    protected int _currentSelection;

    public static CursorData getOne(Root r) {
        CursorData cd;
        ArrayList dataCache = (ArrayList)tl_CachedCursorData.get();
        if (dataCache.size() == 0) {
            cd = new CursorData(r);
        } else {
            cd = (CursorData)dataCache.remove(dataCache.size() - 1);
            cd._goober.set(r);
        }
        return cd;
    }

    private CursorData(Root r) {
        this._goober = new Splay.CursorGoober(r);
    }

    protected void release() {
        if (this._goober.getSplay() != null) {
            this.clearSelections();
            if (this._stack != null) {
                this._stack.dispose();
            }
            this._goober.set(null, 0);
            ArrayList dataCache = (ArrayList)tl_CachedCursorData.get();
            if (dataCache.size() < 128) {
                dataCache.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        Splay s = this._goober.getSplay();
        if (s != null) {
            Root root = this._goober.getRoot();
            synchronized (root) {
                this.release();
            }
        }
    }

    protected void clearSelections() {
        if (this._selections != null) {
            this._selections.dispose();
        }
        this._currentSelection = -2;
    }
}

