/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.lang.ref.Reference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.store.Cursor;
import org.apache.xmlbeans.impl.store.Goobers;
import org.apache.xmlbeans.impl.store.Root;
import org.apache.xmlbeans.impl.store.Text;
import org.apache.xmlbeans.impl.store.Type;
import org.apache.xmlbeans.impl.values.TypeStoreUser;

public abstract class Splay
extends Goobers {
    static final int DOC = 0;
    static final int BEGIN = 1;
    static final int ATTR = 2;
    static final int COMMENT = 3;
    static final int PROCINST = 4;
    static final int ROOT = 5;
    static final int END = 6;
    static final String _xsi = "http://www.w3.org/2001/XMLSchema-instance";
    static final String _schema = "http://www.w3.org/2001/XMLSchema";
    static final String _openFragUri = "http://www.openuri.org/fragment";
    static final String _xml1998Uri = "http://www.w3.org/XML/1998/namespace";
    static final String _xmlnsUri = "http://www.w3.org/2000/xmlns/";
    static final QName _xsiNil;
    static final QName _xsiType;
    static final QName _openuriFragment;
    static final QName _xmlFragment;
    private static final int START_STATE = 0;
    private static final int SPACE_SEEN_STATE = 1;
    private static final int NOSPACE_STATE = 2;
    static final int CURSOR = 0;
    static final int TYPE = 1;
    static final int ANNOTATION = 2;
    static final int AGGREGATE = 3;
    static final boolean _assertEnabled;
    private static final HashMap _debugIds;
    private static int _nextDebugId;
    Splay _leftSplay;
    Splay _rightSplay;
    Splay _parentSplay;
    private int _bits;
    private int _cch;
    private int _cchAfter;
    private int _cchLeft;
    static final /* synthetic */ boolean $assertionsDisabled;

    Splay(int kind, boolean is) {
        this._bits = kind;
        if (is) {
            this._bits += 8;
        }
    }

    final int getKind() {
        return this._bits & 7;
    }

    final boolean isDoc() {
        return this.getKind() == 0;
    }

    final boolean isRoot() {
        return this.getKind() == 5;
    }

    final boolean isBegin() {
        return this.getKind() == 1;
    }

    final boolean isEnd() {
        return this.getKind() == 6;
    }

    final boolean isAttr() {
        return this.getKind() == 2;
    }

    final boolean isComment() {
        return this.getKind() == 3;
    }

    final boolean isProcinst() {
        return this.getKind() == 4;
    }

    final boolean isContainer() {
        return this.getKind() <= 1;
    }

    final boolean isFinish() {
        return this.getKind() >= 5;
    }

    final int getCch() {
        return this._cch;
    }

    final int getCdocBegin() {
        return 1;
    }

    final int getCchLeft() {
        return this._cchLeft;
    }

    final int getCdocBeginLeft() {
        return this._bits >> 5;
    }

    final int getCchAfter() {
        return this._cchAfter;
    }

    final int getCchValue() {
        return this._cch - this._cchAfter;
    }

    QName getName() {
        throw new IllegalStateException();
    }

    String getUri() {
        throw new IllegalStateException();
    }

    String getLocal() {
        throw new IllegalStateException();
    }

    final boolean isNormalAttr() {
        return (this._bits & 0xF) == 2;
    }

    final boolean isXmlns() {
        return (this._bits & 0xF) == 10;
    }

    final boolean isLeaf() {
        return (this._bits & 0xF) == 9;
    }

    final boolean isFragment() {
        return (this._bits & 0xF) == 11;
    }

    final boolean isXsiAttr() {
        return this.isNormalAttr() && this.getUri().equals(_xsi);
    }

    final boolean isXsiNil() {
        return this.isNormalAttr() && this.getName().equals(_xsiNil);
    }

    final boolean isXsiType() {
        return this.isNormalAttr() && this.getName().equals(_xsiType);
    }

    final boolean isTypeable() {
        return this.isContainer() || this.isNormalAttr();
    }

    final void toggleIsLeaf() {
        if (!$assertionsDisabled && !this.isBegin()) {
            throw new AssertionError();
        }
        this._bits ^= 8;
    }

    final boolean isValid() {
        if (!$assertionsDisabled && (this._bits & 0x10) != 0 && !this.isTypeable()) {
            throw new AssertionError();
        }
        return (this._bits & 0x10) == 0;
    }

    final boolean isInvalid() {
        if (!$assertionsDisabled && (this._bits & 0x10) != 0 && !this.isTypeable()) {
            throw new AssertionError();
        }
        return (this._bits & 0x10) != 0;
    }

    final void toggleIsInvalid() {
        if (!$assertionsDisabled && !this.isTypeable()) {
            throw new AssertionError();
        }
        this._bits ^= 0x10;
    }

    final void adjustCch(int delta) {
        this._cch += delta;
        if (!$assertionsDisabled && this._cch < 0) {
            throw new AssertionError();
        }
    }

    final void adjustCchAfter(int delta) {
        this._cchAfter += delta;
        if (!$assertionsDisabled && this._cchAfter < 0) {
            throw new AssertionError();
        }
    }

    final void adjustCchLeft(int delta) {
        this._cchLeft += delta;
        if (!$assertionsDisabled && this._cchLeft < 0) {
            throw new AssertionError();
        }
    }

    final void adjustCdocBeginLeft(int d) {
        this._bits += d * 32;
        if (!$assertionsDisabled && this.getCdocBeginLeft() < 0) {
            throw new AssertionError();
        }
    }

    final Splay getFinishSplay() {
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        return this.isLeaf() ? this : ((Container)this).getFinish();
    }

    final int getPosAfter() {
        return this.getEndPos() - this.getCchAfter();
    }

    final int getPosLeafEnd() {
        if (!$assertionsDisabled && !this.isLeaf()) {
            throw new AssertionError();
        }
        return 1 + this.getCchValue();
    }

    final int getCpForPos(Root r, int p) {
        int cp = r.getCp(this);
        if (p == 0) {
            return cp;
        }
        return this.isLeaf() ? p - (p <= this.getPosLeafEnd() ? 1 : 2) + cp : p - 1 + this.getCchValue() + cp;
    }

    final int getPostCch(int p) {
        if (!($assertionsDisabled || p >= 0 && p <= this.getEndPos())) {
            throw new AssertionError();
        }
        return this.isLeaf() && p <= this.getPosLeafEnd() ? this.getPosLeafEnd() - p : this.getEndPos() - p;
    }

    static final boolean isXmlFragment(QName name) {
        return _openuriFragment.equals(name) || _xmlFragment.equals(name);
    }

    static boolean beginsWithXml(String name) {
        if (name.length() < 3) {
            return false;
        }
        char ch = name.charAt(0);
        return !(ch != 'x' && ch != 'X' || (ch = name.charAt(1)) != 'm' && ch != 'M' || (ch = name.charAt(2)) != 'l' && ch != 'L');
    }

    final int getEndPos() {
        return this.getMaxPos() + 1;
    }

    final int getMaxPos() {
        switch (this.getKind()) {
            case 2: 
            case 5: {
                return 0;
            }
            case 1: {
                return (this.isLeaf() ? 1 : 0) + this.getCch();
            }
            case 0: 
            case 3: 
            case 4: 
            case 6: {
                return this.getCchAfter();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unexpected splay kind " + this.getKind()));
        }
        return 0;
    }

    static final boolean isWhiteSpace(char ch) {
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static final boolean isWhiteSpace(String s) {
        int l = s.length();
        while (l-- > 0) {
            if (Splay.isWhiteSpace(s.charAt(l))) continue;
            return false;
        }
        return true;
    }

    static final boolean isWhiteSpace(StringBuffer sb) {
        int l = sb.length();
        while (l-- > 0) {
            if (Splay.isWhiteSpace(sb.charAt(l))) continue;
            return false;
        }
        return true;
    }

    final boolean isAfterWhiteSpace(Root r) {
        int cchAfter = this.getCchAfter();
        if (cchAfter == 0) {
            return true;
        }
        int off = r._text.unObscure(r.getCp(this) + this.getCch() - cchAfter, cchAfter);
        while (cchAfter-- > 0) {
            if (Splay.isWhiteSpace(r._text._buf[off + cchAfter])) continue;
            return false;
        }
        return true;
    }

    final void setName(Root r, QName newName) {
        if (!($assertionsDisabled || this.isBegin() || this.isAttr() || this.isProcinst())) {
            throw new AssertionError();
        }
        QName oldName = this.getName();
        if (!newName.equals(oldName)) {
            r.startChange();
            ((QNameSplay)this).changeName(newName);
            if (!this.isProcinst() && !this.isXmlns()) {
                if (!($assertionsDisabled || this.isAttr() || this.isBegin())) {
                    throw new AssertionError();
                }
                if (this.isBegin()) {
                    this.disconnectTypes(r);
                }
                if (_xsiType.equals(oldName) || _xsiType.equals(newName)) {
                    this.getContainer().disconnectTypes(r);
                } else if (_xsiNil.equals(oldName) || _xsiNil.equals(newName)) {
                    this.getContainer().invalidateNil();
                } else {
                    this.disconnectTypes(r);
                }
            }
            r.invalidateVersion();
        }
    }

    final int ensureContentValid() {
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        if (this.isValid()) {
            return 0;
        }
        Type t = this.peekType();
        return t.validateContent(this, t);
    }

    final void ensureValueValid() {
        if (!$assertionsDisabled && !this.isNormalAttr()) {
            throw new AssertionError();
        }
        if (this.isInvalid()) {
            Type t = this.peekType();
            t.validateValue(this, t);
        }
    }

    final XmlCursor.TokenType getTokenType(int p) {
        if (!($assertionsDisabled || p >= 0 && p <= this.getMaxPos())) {
            throw new AssertionError();
        }
        if (p >= this.getPosAfter()) {
            return XmlCursor.TokenType.TEXT;
        }
        switch (this.getKind()) {
            case 2: {
                return this.isXmlns() ? XmlCursor.TokenType.NAMESPACE : XmlCursor.TokenType.ATTR;
            }
            case 1: {
                if (p == 0) {
                    return XmlCursor.TokenType.START;
                }
                if (!$assertionsDisabled && !this.isLeaf()) {
                    throw new AssertionError();
                }
                return p == this.getPosLeafEnd() ? XmlCursor.TokenType.END : XmlCursor.TokenType.TEXT;
            }
            case 5: {
                return XmlCursor.TokenType.ENDDOC;
            }
            case 0: {
                return XmlCursor.TokenType.STARTDOC;
            }
            case 3: {
                return XmlCursor.TokenType.COMMENT;
            }
            case 4: {
                return XmlCursor.TokenType.PROCINST;
            }
            case 6: {
                return XmlCursor.TokenType.END;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("Unexpected splay kind " + this.getKind()));
        }
        return null;
    }

    final void foliate(Root r) {
        Goober nextGoober;
        if (!$assertionsDisabled && !this.isBegin()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isLeaf()) {
            throw new AssertionError();
        }
        Begin b = (Begin)this;
        Finish e = b.getFinish();
        if (!$assertionsDisabled && b.nextNonAttrSplay() != e) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && b._end != e) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !e.isEnd()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && b.isLeaf()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !r.validateChangeStarted()) {
            throw new AssertionError();
        }
        int cchBefore = this.getCch();
        super.saveTextAfter(r);
        b._end = null;
        b.toggleIsLeaf();
        b.adjustCchAfter(-cchBefore);
        Goober g = e.firstGoober();
        while (g != null) {
            nextGoober = e.nextGoober(g);
            if (!$assertionsDisabled && g.getPos() != 0) {
                throw new AssertionError();
            }
            g.set(this, cchBefore + 1);
            g = nextGoober;
        }
        g = this.firstGoober();
        while (g != null) {
            nextGoober = this.nextGoober(g);
            int gp = g.getPos();
            if (gp > cchBefore + 1) {
                g.set(this, gp + 1);
            }
            g = nextGoober;
        }
        e.removeSplay(r);
    }

    final void defoliate(Root r) {
        if (!$assertionsDisabled && !this.isLeaf()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !r.validateChangeStarted()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        Begin b = (Begin)this;
        int posLeafEnd = this.getPosLeafEnd();
        int cchAfter = this.getCchAfter();
        int cchValue = this.getCchValue();
        Splay a = this;
        int cchAttr = 0;
        Splay t = this.nextSplay();
        while (t.isAttr()) {
            cchAttr += t.getCch();
            a = t;
            t = t.nextSplay();
        }
        b._end = new End((Begin)this);
        r.insertSplay(b._end, a);
        b.toggleIsLeaf();
        b.adjustCchAfter(cchValue - cchAfter);
        b._end.adjustCchAfter(cchAfter);
        r.updateCch(b, -cchAfter);
        r.updateCch(b._end, cchAfter);
        if (cchAttr > 0) {
            int cp = r.getCp(b);
            r._text.move(cp + cchValue + cchAfter + cchAttr, r._text, cp + cchValue, cchAfter);
        }
        Goober g = this.firstGoober();
        while (g != null) {
            Goober nextGoober = this.nextGoober(g);
            int gp = g.getPos();
            if (gp >= posLeafEnd) {
                g.set(b._end, gp - posLeafEnd);
            }
            g = nextGoober;
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    private final void removeTextAfter(Root r) {
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (this.isRoot() || this.isAttr())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !r.validateChangeStarted()) {
            throw new AssertionError();
        }
        int cchTextAfter = this.getCchAfter();
        if (cchTextAfter == 0) {
            return;
        }
        int cpTextAfter = r.getCp(this) + this.getCch() - cchTextAfter;
        int posTextAfter = this.getPosAfter();
        this.adjustCchAfter(-cchTextAfter);
        r.updateCch(this, -cchTextAfter);
        r._text.remove(cpTextAfter, cchTextAfter);
        Goober g = this.firstGoober();
        while (g != null) {
            Goober nextGoober = this.nextGoober(g);
            int k = g.getKind();
            if (g.getPos() >= posTextAfter) {
                if (k == 2) {
                    g.disconnect(r);
                } else if (k == 0) {
                    g.set(this.nextSplay(), 0);
                }
            }
            g = nextGoober;
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    private final int saveTextAfter(Root r) {
        int cchEndText;
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !r.validateChangeStarted()) {
            throw new AssertionError();
        }
        Splay endText = this;
        if (this.isBegin() && !this.isLeaf()) {
            endText = this.getFinishSplay();
        }
        if ((cchEndText = endText.getCchAfter()) == 0) {
            return 0;
        }
        if (!$assertionsDisabled && (this.isRoot() || this.isDoc() || this.isAttr())) {
            throw new AssertionError();
        }
        Splay getsText = this.prevNonAttrSplay();
        int getsTextLastPos = getsText.getEndPos();
        int cpGetsText = r.getCp(getsText) + getsText.getCch();
        int cpEndText = r.getCp(endText) + endText.getCch() - cchEndText;
        getsText.adjustCchAfter(cchEndText);
        endText.adjustCchAfter(-cchEndText);
        r.updateCch(getsText, cchEndText);
        r.updateCch(endText, -cchEndText);
        if (!$assertionsDisabled && cpGetsText > cpEndText) {
            throw new AssertionError();
        }
        if (cpGetsText != cpEndText) {
            r._text.insert(cpGetsText, r._text, cpEndText, cchEndText);
            r._text.remove(cpEndText + cchEndText, cchEndText);
        }
        int posEndText = endText.getPosAfter();
        Goober g = endText.firstGoober();
        while (g != null) {
            Goober nextGoober = endText.nextGoober(g);
            int gp = g.getPos();
            if (gp >= posEndText) {
                g.set(getsText, getsTextLastPos + gp - posEndText);
            }
            g = nextGoober;
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
        return cchEndText;
    }

    final void move(Root r, Root rDst, Splay sDst, int pDst, boolean invalidate) {
        Type parentType;
        Splay first;
        int cchSaved;
        if (!$assertionsDisabled && r == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && (this.isDoc() || this.isFinish())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rDst != null && r == rDst && sDst.between(r, pDst, this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rDst != null && sDst == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rDst != null && Root.dv <= 0 && sDst.getRootSlow() != rDst) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || rDst == null || pDst >= 0 && pDst < sDst.getEndPos())) {
            throw new AssertionError();
        }
        if ($assertionsDisabled || rDst != null) {
            // empty if block
        }
        r.startChange();
        if (rDst != null) {
            rDst.startChange();
        }
        if ((cchSaved = this.saveTextAfter(r)) > 0) {
            Splay gotText = this.prevNonAttrSplay();
            Goober g = this.firstGoober();
            while (g != null) {
                Goober nextGoober = this.nextGoober(g);
                if (g.getKind() == 0) {
                    g.set(gotText, gotText.getEndPos() - cchSaved);
                }
                g = nextGoober;
            }
            if (rDst != null) {
                Splay hadText;
                Splay splay = hadText = this.isBegin() && !this.isLeaf() ? this.getFinishSplay() : this;
                if (sDst == hadText && pDst >= hadText.getEndPos()) {
                    sDst = gotText;
                    pDst = gotText.getEndPos() - (cchSaved - (pDst - hadText.getEndPos()));
                }
            }
        }
        if (!$assertionsDisabled && sDst == this) {
            throw new AssertionError();
        }
        Splay last = this.isBegin() ? this.getFinishSplay().nextNonAttrSplay() : this.nextSplay();
        Container container = this.getContainer();
        int cp = r.getCp(this);
        int cch = 0;
        for (Splay s = this; s != last; s = s.nextSplay()) {
            if (s.isInvalid()) {
                if (!($assertionsDisabled || s.isLeaf() || s.isNormalAttr())) {
                    throw new AssertionError();
                }
                if (s.isNormalAttr()) {
                    s.ensureValueValid();
                } else if (s.isLeaf()) {
                    s.ensureContentValid();
                }
            }
            cch += s.getCch();
            Goober g = s.firstGoober();
            while (g != null) {
                Goober nextGoober = s.nextGoober(g);
                switch (g.getKind()) {
                    case 1: {
                        g.disconnect(r);
                        break;
                    }
                    case 2: {
                        if (rDst == null) {
                            g.disconnect(r);
                            break;
                        }
                        g.set(rDst);
                        break;
                    }
                    case 0: {
                        g.set(last, 0);
                    }
                }
                g = nextGoober;
            }
        }
        Splay sRemoved = r.removeSplays(this, last);
        Splay splay = first = sRemoved._leftSplay == null ? sRemoved : sRemoved._leftSplay;
        if (first.isBegin()) {
            ((Begin)first)._container = null;
        }
        char[] textRemoved = rDst == null || cch == 0 ? null : new char[cch];
        r._text.remove(cp, cch, textRemoved, 0);
        r.invalidateVersion();
        if (rDst != null) {
            sDst.insert(rDst, pDst, sRemoved, textRemoved, 0, cch, invalidate);
        }
        if (invalidate && (parentType = container.peekType()) != null) {
            if (this.isBegin()) {
                parentType.invalidateElement(container, last);
            } else if (this.isAttr() && this.isXsiNil()) {
                parentType.invalidateNil();
            }
        }
        if (!$assertionsDisabled && !r.validate()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rDst != null && !rDst.validate()) {
            throw new AssertionError();
        }
    }

    final void remove(Root r, boolean invalidate) {
        this.move(r, null, null, 0, invalidate);
    }

    private final void complain(String msg) {
        throw new IllegalArgumentException(msg);
    }

    final boolean checkInsertionValidity(int p, Splay sDst, int pDst, boolean endOk) {
        if (!$assertionsDisabled && p < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && p >= this.getEndPos()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pDst < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pDst >= sDst.getEndPos()) {
            throw new AssertionError();
        }
        boolean srcChars = false;
        if (p > 0) {
            if (!endOk && this.isLeaf() && p == this.getPosLeafEnd()) {
                this.complain("Can't move/copy/insert an end token.");
            }
            srcChars = true;
        } else {
            if (this.isDoc()) {
                this.complain("Can't move/copy/insert a whole document.");
            }
            if (this.isFinish()) {
                if (!endOk) {
                    this.complain("Can't move/copy/insert an end token.");
                }
                srcChars = true;
            } else if (this.isFragment()) {
                srcChars = true;
            }
        }
        if (pDst == 0 && sDst.isDoc()) {
            this.complain("Can't insert before the start of the document.");
        }
        if (p > 0 && sDst.isAttr()) {
            this.complain("Can't insert text before an attribute.");
        }
        if (this.isAttr() && pDst > 0 && (!sDst.isContainer() || pDst != 1)) {
            this.complain("Can't insert an attribute in text.");
        }
        if (p <= 0 && pDst <= 0) {
            if (this.isAttr()) {
                Splay t;
                boolean isOk = sDst.isAttr();
                if (!isOk && (t = sDst.prevNonAttrSplay()).isContainer() && t.getCchAfter() == 0) {
                    isOk = true;
                }
                if (!isOk) {
                    this.complain("Can only move/copy/insert attribute after another attribute or start token.");
                }
            } else if (sDst.isAttr()) {
                this.complain("Can't move/copy/insert a non-attribute before an attribute.");
            }
        }
        return srcChars;
    }

    final void insert(Root r, int p, Splay rootInsert, Object txt, int offTxt, int cchTxt, boolean invalidate) {
        Type cType;
        Splay sInsert;
        if (!$assertionsDisabled && p >= this.getEndPos()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && cchTxt < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rootInsert == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rootInsert._parentSplay != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rootInsert.getCchLeft() + rootInsert.getCch() != cchTxt) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && rootInsert._leftSplay != null && rootInsert._leftSplay._leftSplay != null) {
            throw new AssertionError();
        }
        r.startChange();
        Splay splay = sInsert = rootInsert._leftSplay == null ? rootInsert : rootInsert._leftSplay;
        if (!$assertionsDisabled && (sInsert.isDoc() || sInsert.isFinish())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sInsert.isFragment() && sInsert.getCch() <= 0) {
            throw new AssertionError();
        }
        Splay s = this;
        if (!$assertionsDisabled && Root.dv <= 0 && sInsert.getRootSlow() != null) {
            throw new AssertionError();
        }
        Splay sOrig = null;
        int pOrig = 0;
        int cchBypassed = 0;
        if (p > 0) {
            int ple;
            if (s.isLeaf() && p <= (ple = s.getPosLeafEnd())) {
                if (s.isInvalid()) {
                    if (!$assertionsDisabled && ple != 1) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && p != 1) {
                        throw new AssertionError();
                    }
                    int cchValid = s.ensureContentValid();
                    p += cchValid;
                    ple += cchValid;
                }
                if (!$assertionsDisabled && s.getFinishSplay() != s) {
                    throw new AssertionError();
                }
                this.defoliate(r);
                if (!$assertionsDisabled && s.getFinishSplay() == s) {
                    throw new AssertionError();
                }
                if (p == ple) {
                    s = this.getFinishSplay();
                    p = 0;
                }
                s.insert(r, p, rootInsert, txt, offTxt, cchTxt, invalidate);
                return;
            }
            if (!($assertionsDisabled || !sInsert.isAttr() || p == 1 && s.isContainer())) {
                throw new AssertionError();
            }
            sOrig = s;
            pOrig = p;
            cchBypassed = this.getEndPos() - p;
            s = s.nextNonAttrSplay();
            p = 0;
        }
        if (!$assertionsDisabled && p != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s.isDoc()) {
            throw new AssertionError();
        }
        Container c = s.getContainer();
        boolean insertingElements = false;
        boolean insertingText = false;
        boolean insertingNilAttr = false;
        Splay insertingFragment = null;
        for (Splay t = sInsert; t != null; t = t.nextSplay()) {
            if (t.isBegin()) {
                insertingElements = true;
                Begin b = (Begin)t;
                if (!$assertionsDisabled && b._container != null) {
                    throw new AssertionError();
                }
                b._container = c;
                t = t.getFinishSplay();
            } else if (t.isFragment()) {
                if (!$assertionsDisabled && insertingFragment != null) {
                    throw new AssertionError();
                }
                insertingFragment = t;
            }
            if (t.isXsiNil()) {
                insertingNilAttr = true;
            }
            if (t.getCchAfter() <= 0) continue;
            insertingText = true;
        }
        r._text.insert(r.getCp(s), txt, offTxt, cchTxt);
        r.insertSplay(rootInsert, s.prevSplay());
        if (insertingFragment != null) {
            insertingFragment.remove(r, false);
        }
        if (invalidate && (cType = c.peekType()) != null) {
            if (insertingElements) {
                cType.invalidateElement(c, s);
                insertingText = true;
            }
            if (insertingText) {
                cType.invalidateText();
            }
            if (insertingNilAttr) {
                cType.invalidateNil();
            }
        }
        if (sOrig != null && !sInsert.isAttr()) {
            int cchMoved = sOrig.moveChars(r, pOrig, -1, r, s, 0, true);
            if (!$assertionsDisabled && cchMoved <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && cchMoved != cchBypassed) {
                throw new AssertionError();
            }
        }
        if (s.isEnd() && s.getContainer().nextNonAttrSplay() == s) {
            s.getContainer().foliate(r);
        }
        r.invalidateVersion();
        if (!$assertionsDisabled && !r.validate()) {
            throw new AssertionError();
        }
    }

    final void replaceContents(Root r, Splay sSrc, Root rSrc, boolean preserveType, boolean preserveNamespaces) {
        Map sourceNamespaces;
        if (!$assertionsDisabled && (this.isFinish() || sSrc.isFinish())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && sSrc.getRootSlow() != rSrc) {
            throw new AssertionError();
        }
        if (this == sSrc) {
            return;
        }
        Map map = sourceNamespaces = preserveNamespaces ? sSrc.lookupAllPrefixMappings() : null;
        if (this.isAttr() || this.isComment() || this.isProcinst()) {
            String str = sSrc.getText(rSrc);
            this.setText(r, str, 0, str.length());
        } else {
            if (!$assertionsDisabled && !this.isContainer()) {
                throw new AssertionError();
            }
            CopyContext copyContext = sSrc.copySplayContents(rSrc);
            String targetXsiType = null;
            if (preserveType) {
                Splay s = this.nextSplay();
                while (s.isAttr()) {
                    if (s.isXsiType()) {
                        targetXsiType = s.getText(r);
                        break;
                    }
                    s = s.nextSplay();
                }
            }
            this.removeContent(r, true);
            if (!$assertionsDisabled && !this.isLeaf() && this.getFinishSplay() != this.nextSplay()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.getCchValue() != 0) {
                throw new AssertionError();
            }
            Splay copy = copyContext.getTree();
            if (copy != null) {
                char[] textCopy;
                Splay insertSplay = this;
                int insertPos = 1;
                if (!this.isLeaf()) {
                    insertSplay = this.nextSplay();
                    insertPos = 0;
                }
                insertSplay.insert(r, insertPos, copy, textCopy, 0, (textCopy = copyContext.getText()) == null ? 0 : textCopy.length, true);
                if (preserveType) {
                    Splay next;
                    Splay s = next = this.nextSplay();
                    while (s.isAttr()) {
                        next = s.nextSplay();
                        if (s.isXsiType()) {
                            s.remove(r, true);
                        }
                        s = next;
                    }
                    if (targetXsiType != null) {
                        Attr a = new Attr(_xsiType);
                        int cchType = targetXsiType.length();
                        a.adjustCch(cchType);
                        if (this.getEndPos() > 1) {
                            this.insert(r, 1, a, targetXsiType, 0, cchType, true);
                        } else {
                            this.nextNonAttrSplay().insert(r, 0, a, targetXsiType, 0, cchType, true);
                        }
                    }
                }
            }
        }
        if (sourceNamespaces != null) {
            this.applyNamespaces(r, sourceNamespaces);
        }
    }

    final CopyContext copySplayContents(Root r) {
        if (!$assertionsDisabled && (this.isFinish() || this.isXmlns())) {
            throw new AssertionError();
        }
        if (this.isContainer()) {
            this.ensureContentValid();
        } else if (this.isNormalAttr()) {
            this.ensureValueValid();
        }
        CopyContext copyContext = new CopyContext();
        if (this.isContainer()) {
            int cchAll;
            int cchValue;
            Splay t;
            int cchAttrs = 0;
            Splay s = t = this.nextSplay();
            while (s.isAttr()) {
                copyContext.copySplay(s, false);
                cchAttrs += s.getCch();
                s = s.nextSplay();
            }
            int n = cchValue = this.isLeaf() ? this.getCchValue() : this.getCchAfter();
            if (cchValue > 0) {
                copyContext.copyFragment(cchValue);
            }
            int cchContents = 0;
            if (!this.isLeaf()) {
                Splay finish = this.getFinishSplay();
                for (Splay u = s; u != finish; u = u.nextSplay()) {
                    copyContext.copySplay(u, true);
                    cchContents += u.getCch();
                }
            }
            if ((cchAll = cchAttrs + cchValue + cchContents) > 0) {
                char[] text = new char[cchAll];
                int cp = r.getCp(this);
                int cch = this.getCch();
                if (cchAttrs > 0) {
                    r._text.fetch(text, 0, cp + cch, cchAttrs);
                }
                if (cchValue > 0) {
                    r._text.fetch(text, cchAttrs, cp, cchValue);
                }
                if (cchContents > 0) {
                    r._text.fetch(text, cchAttrs + cchValue, cp + cch + cchAttrs, cchContents);
                }
                copyContext.copyText(text);
            }
        } else {
            if (!($assertionsDisabled || this.isNormalAttr() || this.isComment() || this.isProcinst())) {
                throw new AssertionError();
            }
            int cchValue = this.getCchValue();
            if (cchValue > 0) {
                copyContext.copyFragment(cchValue);
                char[] text = new char[cchValue];
                r._text.fetch(text, 0, r.getCp(this), cchValue);
                copyContext.copyText(text);
            }
        }
        return copyContext;
    }

    final Splay copySplay() {
        Splay stopHere;
        Splay noTextAfter;
        if (!$assertionsDisabled && (this.isDoc() || this.isFinish())) {
            throw new AssertionError();
        }
        if (this.isBegin()) {
            noTextAfter = this.getFinishSplay();
            stopHere = noTextAfter.nextNonAttrSplay();
        } else {
            noTextAfter = null;
            stopHere = this.nextSplay();
        }
        CopyContext copyContext = new CopyContext();
        Splay s = this;
        while (s != stopHere) {
            Splay next = s.nextSplay();
            copyContext.copySplay(s, s != noTextAfter);
            s = next;
        }
        return copyContext.getTree();
    }

    final void removeAttributes(Root r) {
        Splay s;
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        while ((s = this.nextSplay()).isAttr()) {
            s.remove(r, true);
        }
    }

    final void removeContent(Root r, boolean removeAttrs) {
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        r.startChange();
        if (this.isInvalid()) {
            this.toggleIsInvalid();
            r.invalidateVersion();
            if (this.isContainer() && removeAttrs) {
                this.removeAttributes(r);
            }
            return;
        }
        switch (this.getKind()) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.isLeaf()) break;
                this.removeChars(r, 1, this.getCchValue());
                if (removeAttrs) {
                    this.removeAttributes(r);
                }
                return;
            }
            case 2: {
                if (this.isXmlns() && !$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected kind for removeContent");
                }
            }
            case 3: 
            case 4: {
                int cchValue = this.getCchValue();
                if (cchValue == 0) {
                    return;
                }
                r._text.remove(r.getCp(this), cchValue);
                r.updateCch(this, -cchValue);
                if (this.getKind() == 2) {
                    this.invalidateText();
                    if (this.isXsiType()) {
                        this.getContainer().disconnectTypes(r);
                    }
                }
                r.invalidateVersion();
                return;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected kind for removeContent");
                }
                break;
            }
        }
        if (!($assertionsDisabled || this.isDoc() || this.isBegin() && !this.isLeaf())) {
            throw new AssertionError();
        }
        Splay s = this.nextNonAttrSplay();
        if (s.isRoot()) {
            if (!$assertionsDisabled && !this.isDoc()) {
                throw new AssertionError();
            }
        } else {
            s = this.nextNonAttrSplay();
            while (!s.isFinish()) {
                if (!$assertionsDisabled && s.isAttr()) {
                    throw new AssertionError();
                }
                Splay next = s.isLeaf() ? s.nextNonAttrSplay() : (s.isBegin() ? s.getFinishSplay().nextSplay() : s.nextSplay());
                s.remove(r, false);
                s = next;
            }
            if (!$assertionsDisabled && this.isLeaf()) {
                throw new AssertionError();
            }
            if (this.getCchAfter() > 0) {
                this.removeTextAfter(r);
            }
            if (this.isBegin()) {
                this.foliate(r);
            }
            this.invalidateText();
            r.invalidateVersion();
        }
        if (removeAttrs) {
            this.removeAttributes(r);
        }
        if (r._leftSplay == r._doc && r._doc._rightSplay == null) {
            r._leftOnly = true;
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    final int copyChars(Root r, int p, int cch, Root rDst, Splay sDst, int pDst) {
        if (!($assertionsDisabled || pDst > 0 && pDst <= sDst.getEndPos())) {
            throw new AssertionError();
        }
        int postCch = this.getPostCch(p);
        if (p == 0 || cch == 0 || postCch == 0) {
            return 0;
        }
        if (cch < 0 || cch > postCch) {
            cch = postCch;
        }
        if (!$assertionsDisabled && cch <= 0) {
            throw new AssertionError();
        }
        char[] chars = new char[cch];
        r._text.fetch(chars, 0, this.getCpForPos(r, p), cch);
        sDst.insertChars(pDst, rDst, chars, 0, cch);
        return cch;
    }

    final int moveChars(Root r, int p, int cch, Root rDst, Splay sDst, int pDst, boolean moveCursors) {
        if (p == 0) {
            return 0;
        }
        int postCch = this.getPostCch(p);
        if (cch == 0 || postCch == 0) {
            return 0;
        }
        if (cch < 0 || cch > postCch) {
            cch = postCch;
        }
        r.startChange();
        rDst.startChange();
        if (!$assertionsDisabled && cch <= 0) {
            throw new AssertionError();
        }
        if (sDst.isContainer() && pDst == 1) {
            int cchValid = sDst.ensureContentValid();
            pDst += cchValid;
            if (sDst == this && p == 1) {
                p += cchValid;
            }
        }
        if (pDst == 0) {
            sDst = sDst.prevNonAttrSplay();
            pDst = sDst.getEndPos();
        }
        if (sDst == this && pDst >= p && pDst <= p + cch) {
            return cch;
        }
        if (!$assertionsDisabled && pDst <= 0) {
            throw new AssertionError();
        }
        Container cDst = sDst.getContainer(pDst);
        Container c = this.getContainer(p);
        rDst._text.move(sDst.getCpForPos(rDst, pDst), r._text, this.getCpForPos(r, p), cch);
        if (!sDst.isLeaf() || pDst > sDst.getPosLeafEnd()) {
            sDst.adjustCchAfter(cch);
        }
        rDst.updateCch(sDst, cch);
        Goober g = sDst.firstGoober();
        while (g != null) {
            int gp = g.getPos();
            if (gp >= pDst) {
                g.set(gp + cch);
            }
            g = sDst.nextGoober(g);
        }
        if (!$assertionsDisabled && sDst == this && pDst >= p && pDst <= p + cch) {
            throw new AssertionError();
        }
        if (sDst == this) {
            int pDstSave = pDst;
            if (pDst > p + cch) {
                pDst -= cch;
            }
            if (p >= pDstSave) {
                p += cch;
            }
        }
        if (!this.isLeaf() || p > this.getPosLeafEnd()) {
            this.adjustCchAfter(-cch);
        }
        r.updateCch(this, -cch);
        Goober g2 = this.firstGoober();
        while (g2 != null) {
            Goober nextGoober = this.nextGoober(g2);
            int gp = g2.getPos();
            if (gp >= p + cch) {
                g2.set(gp - cch);
            } else if (gp >= p) {
                if (!moveCursors && g2.getKind() == 0) {
                    if (p == this.getEndPos()) {
                        g2.set(this.nextSplay(), 0);
                    } else {
                        g2.set(p);
                    }
                } else {
                    g2.set(rDst, sDst, pDst + gp - p);
                }
            }
            g2 = nextGoober;
        }
        cDst.invalidateText();
        c.invalidateText();
        r.invalidateVersion();
        rDst.invalidateVersion();
        return cch;
    }

    final int removeChars(Root r, int p, int cch) {
        int ple;
        int maxPos = this.getMaxPos();
        if (!($assertionsDisabled || p > 0 && p <= maxPos)) {
            throw new AssertionError();
        }
        if (p == 0) {
            return 0;
        }
        r.startChange();
        if (this.isLeaf() && p <= (ple = this.getPosLeafEnd())) {
            if (cch < 0 || ple - p < cch) {
                cch = ple - p;
            }
            if (cch == 0) {
                return 0;
            }
            r._text.remove(r.getCp(this) + p - 1, cch);
            r.updateCch(this, -cch);
            Goober g = this.firstGoober();
            while (g != null) {
                Goober nextGoober = this.nextGoober(g);
                int k = g.getKind();
                int gp = g.getPos();
                if (gp >= p + cch) {
                    g.set(gp - cch);
                } else if (gp >= p) {
                    if (k == 0) {
                        g.set(p);
                    } else {
                        if (!$assertionsDisabled && k != 2) {
                            throw new AssertionError();
                        }
                        g.disconnect(r);
                    }
                }
                g = nextGoober;
            }
            this.invalidateText();
            r.invalidateVersion();
            return cch;
        }
        int posAfter = this.getPosAfter();
        if (!$assertionsDisabled && p < posAfter) {
            throw new AssertionError();
        }
        int maxCch = maxPos - p + 1;
        if (!$assertionsDisabled && maxCch < 0) {
            throw new AssertionError();
        }
        if (cch < 0 || cch > maxCch) {
            cch = maxCch;
        }
        if (cch <= 0) {
            return 0;
        }
        Container c = this.getContainer(p);
        r._text.remove(this.getCpForPos(r, p), cch);
        this.adjustCchAfter(-cch);
        r.updateCch(this, -cch);
        Goober g = this.firstGoober();
        while (g != null) {
            Goober nextGoober = this.nextGoober(g);
            int k = g.getKind();
            int gp = g.getPos();
            if (gp >= p) {
                if (k == 0) {
                    g.set(this.nextNonAttrSplay(), 0);
                } else {
                    g.disconnect(r);
                }
            }
            g = nextGoober;
        }
        c.invalidateText();
        r.invalidateVersion();
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
        return cch;
    }

    final void insertChars(int p, Root r, Object txt, int off, int cch) {
        if (!($assertionsDisabled || p > 0 && p <= this.getEndPos())) {
            throw new AssertionError();
        }
        if (cch == 0) {
            return;
        }
        r.startChange();
        Container container = this.getContainer(p);
        if (this.isContainer() && p == 1) {
            p += this.ensureContentValid();
        }
        r._text.insert(this.getCpForPos(r, p), txt, off, cch);
        if (p >= this.getPosAfter()) {
            this.adjustCchAfter(cch);
        }
        r.updateCch(this, cch);
        Goober g = this.firstGoober();
        while (g != null) {
            int gp = g.getPos();
            if (gp >= p) {
                g.set(gp + cch);
            }
            g = this.nextGoober(g);
        }
        container.invalidateText();
        r.invalidateVersion();
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    public final int scrubText(Text text, int ws, int cp, int cch, StringBuffer sb, int state) {
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        if (text._buf == null) {
            if (!$assertionsDisabled && cch != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && cp != 0) {
                throw new AssertionError();
            }
            return state;
        }
        if (cch == 0) {
            return state;
        }
        boolean replace = false;
        boolean collapse = false;
        switch (ws) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                replace = true;
                break;
            }
            case 3: {
                replace = true;
                collapse = true;
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unknown white space rule " + ws));
                }
                break;
            }
        }
        if (!replace && !collapse) {
            text.fetch(sb, cp, cch);
            return state;
        }
        int off = text.unObscure(cp, cch);
        int startpt = 0;
        for (int i = 0; i < cch; ++i) {
            char ch = text._buf[off + i];
            if (ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t') {
                sb.append(text._buf, off + startpt, i - startpt);
                startpt = i + 1;
                if (collapse) {
                    if (state != 2) continue;
                    state = 1;
                    continue;
                }
                sb.append(' ');
                continue;
            }
            if (state == 1) {
                sb.append(' ');
            }
            state = 2;
        }
        sb.append(text._buf, off + startpt, cch - startpt);
        return state;
    }

    final String getText(Root r) {
        return this.getText(r, 1);
    }

    final String getText(Root r, int ws) {
        if (this.isInvalid()) {
            if (this.isNormalAttr()) {
                this.ensureValueValid();
            } else if (this.isLeaf()) {
                this.ensureContentValid();
            }
        }
        int cp = r.getCp(this);
        if (this.isNormalAttr() || this.isComment() || this.isProcinst() || this.isLeaf()) {
            int cch = this.getCchValue();
            if (cch == 0) {
                return "";
            }
            if (ws == 1 || ws == 0) {
                return r._text.fetch(cp, cch);
            }
            StringBuffer sb = new StringBuffer();
            this.scrubText(r._text, ws, cp, this.getCchValue(), sb, 0);
            return sb.toString();
        }
        if (!this.isContainer()) {
            return null;
        }
        Splay last = this.getFinishSplay();
        int scrubState = 0;
        StringBuffer sb = new StringBuffer();
        for (Splay s = this; s != last; s = s.nextSplay()) {
            if (s.isBegin()) {
                if (s.isInvalid()) {
                    s.ensureContentValid();
                }
                scrubState = this.scrubText(r._text, ws, cp, s.getCch(), sb, scrubState);
            } else {
                int cchAfter = s.getCchAfter();
                if (cchAfter > 0) {
                    scrubState = this.scrubText(r._text, ws, cp + s.getCchValue(), cchAfter, sb, scrubState);
                }
            }
            cp += s.getCch();
        }
        return sb.toString();
    }

    Splay getAttr(QName name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!this.isContainer()) {
            return null;
        }
        Splay s = this.nextSplay();
        while (s.isAttr()) {
            if (s.isNormalAttr() && s.getName().equals(name)) {
                return s;
            }
            s = s.nextSplay();
        }
        return null;
    }

    void setXsiNil(Root r, boolean nil) {
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        if (this.getXsiNil(r) == nil) {
            return;
        }
        this.setAttr(r, _xsiNil, "true");
    }

    boolean getXsiNil(Root r) {
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        Splay s = this.nextSplay();
        while (s.isAttr() && !s.isXsiNil()) {
            s = s.nextSplay();
        }
        if (!s.isAttr()) {
            return false;
        }
        String value = s.getText(r, 3);
        return value.equals("true") || value.equals("1");
    }

    QName getXsiTypeName(Root r) {
        String localname;
        String prefix;
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        Splay s = this.nextSplay();
        while (s.isAttr() && !s.isXsiType()) {
            s = s.nextSplay();
        }
        if (!s.isAttr()) {
            return null;
        }
        if (!$assertionsDisabled && !s.isXsiType()) {
            throw new AssertionError();
        }
        String value = s.getText(r, 3);
        int firstcolon = value.indexOf(58);
        if (firstcolon >= 0) {
            prefix = value.substring(0, firstcolon);
            localname = value.substring(firstcolon + 1);
        } else {
            prefix = "";
            localname = value;
        }
        String uri = this.namespaceForPrefix(prefix, true);
        if (uri == null) {
            return null;
        }
        return new QName(uri, localname);
    }

    void setXsiType(Root r, QName typeName) {
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        if (typeName == null) {
            this.removeAttr(r, _xsiType);
            return;
        }
        String value = typeName.getLocalPart();
        String ns = typeName.getNamespaceURI();
        String prefix = this.prefixForNamespace(r, ns, null, true);
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError((Object)("Cannot establish prefix for " + ns));
        }
        if (prefix.length() > 0) {
            value = prefix + ":" + value;
        }
        boolean set = false;
        this.setAttr(r, _xsiType, value);
    }

    void removeAttr(Root r, QName attrName) {
        Splay s = this.nextSplay();
        while (s.isAttr()) {
            Splay next = s.nextSplay();
            if (s.getName().equals(attrName)) {
                s.remove(r, true);
            }
            s = next;
        }
    }

    void setAttr(Root r, QName attrName, String value) {
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && attrName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        boolean set = false;
        Splay s = this.nextSplay();
        while (s.isAttr()) {
            Splay next = s.nextSplay();
            if (s.getName().equals(attrName)) {
                if (set) {
                    s.remove(r, true);
                } else {
                    s.setText(r, value, 0, value.length());
                    set = true;
                }
            }
            s = next;
        }
        if (!set) {
            Splay sInsert = this;
            int pInsert = 1;
            if (!this.isLeaf() && this.getCch() == 0) {
                sInsert = this.nextSplay();
                pInsert = 0;
            }
            int cchValue = value.length();
            Attr attr = new Attr(attrName);
            attr.adjustCch(cchValue);
            sInsert.insert(r, pInsert, attr, value, 0, cchValue, false);
        }
    }

    final void setText(Root r, Object txt, int off, int cch) {
        this.removeContent(r, false);
        if (txt == null || cch == 0) {
            return;
        }
        switch (this.getKind()) {
            case 0: 
            case 1: {
                if (!$assertionsDisabled && this.isBegin() && !this.isLeaf()) {
                    throw new AssertionError();
                }
                this.insertChars(1, r, txt, off, cch);
                break;
            }
            case 2: {
                if (this.isXmlns() && !$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected kind for setText");
                }
            }
            case 3: 
            case 4: {
                r.startChange();
                if (!$assertionsDisabled && this.getCchValue() != 0) {
                    throw new AssertionError();
                }
                r._text.insert(r.getCp(this), txt, off, cch);
                r.updateCch(this, cch);
                if (this.getKind() == 2) {
                    this.invalidateText();
                    if (this.isXsiType()) {
                        this.getContainer().disconnectTypes(r);
                    }
                }
                r.invalidateVersion();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected kind for setText");
                }
                break;
            }
        }
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    final Map lookupAllPrefixMappings() {
        Splay container;
        HashMap<String, String> mappings = null;
        Splay splay = container = this.isContainer() ? this : this.getContainer();
        while (container != null) {
            Splay s = container.nextSplay();
            while (s.isAttr()) {
                block4: {
                    block6: {
                        block5: {
                            if (!s.isXmlns()) break block4;
                            if (mappings != null) break block5;
                            mappings = new HashMap<String, String>();
                            break block6;
                        }
                        if (mappings.containsKey(s.getLocal())) break block4;
                    }
                    mappings.put(s.getLocal(), s.getUri());
                }
                s = s.nextSplay();
            }
            container = container.getContainer();
        }
        return mappings;
    }

    final void applyNamespaces(Root r, Map namespaces) {
        if (namespaces == null) {
            return;
        }
        Splay container = this.isContainer() ? this : this.getContainer();
        Iterator i = namespaces.keySet().iterator();
        block0: while (i.hasNext()) {
            String prefix = (String)i.next();
            if (prefix.toLowerCase().startsWith("xml")) continue;
            String namespace = (String)namespaces.get(prefix);
            Splay candidate = container;
            block1: for (Container c = container.getContainer(); c != null && !c.isDoc(); c = c.getContainer()) {
                Splay s = c.nextSplay();
                while (s.isAttr()) {
                    if (s.isXmlns() && prefix.equals(s.getLocal())) {
                        if (!namespace.equals(s.getUri())) break block1;
                        continue block0;
                    }
                    s = s.nextSplay();
                }
                candidate = c;
            }
            QName qname = new QName(namespace, prefix);
            this.removeAttr(r, qname);
            candidate.nextNonAttrSplay().insert(r, 0, new Xmlns(qname), null, 0, 0, false);
        }
    }

    final String getPrefix(Root r) {
        if (!($assertionsDisabled || this.isBegin() || this.isAttr())) {
            throw new AssertionError();
        }
        if (this.isXmlns()) {
            return "xmlns";
        }
        Splay c = this.isBegin() ? this : this.getContainer();
        String ns = this.getUri();
        return this.prefixForNamespace(r, ns, null, false);
    }

    final String namespaceForPrefix(String prefix, boolean defaultAlwaysMapped) {
        if (prefix == null) {
            prefix = "";
        }
        if ("xml".equals(prefix)) {
            return _xml1998Uri;
        }
        if ("xmlns".equals(prefix)) {
            return _xmlnsUri;
        }
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        for (Container c = (Container)this; c != null; c = c.getContainer()) {
            Splay s = c.nextSplay();
            while (s.isAttr()) {
                if (s.isXmlns() && prefix.equals(s.getLocal())) {
                    return s.getUri();
                }
                s = s.nextSplay();
            }
        }
        if (defaultAlwaysMapped && prefix.length() == 0) {
            return "";
        }
        return null;
    }

    final String prefixForNamespace(Root r, String ns, String suggestion, boolean createIfMissing) {
        Splay s;
        Container c;
        if (ns == null) {
            ns = "";
        }
        if (_xml1998Uri.equals(ns)) {
            return "xml";
        }
        if (_xmlnsUri.equals(ns)) {
            return "xmlns";
        }
        if (!$assertionsDisabled && !this.isContainer()) {
            throw new AssertionError();
        }
        if (ns.length() == 0) {
            Splay s2;
            Container c2;
            block0: for (c2 = (Container)this; c2 != null; c2 = c2.getContainer()) {
                s2 = c2.nextSplay();
                while (s2.isAttr()) {
                    if (s2.isXmlns() && s2.getLocal().length() == 0) {
                        if (s2.getUri().length() != 0) break block0;
                        return s2.getLocal();
                    }
                    s2 = s2.nextSplay();
                }
            }
            if (c2 == null) {
                return "";
            }
            if (!createIfMissing) {
                return null;
            }
            s2 = this.nextSplay();
            while (s2.isAttr()) {
                if (s2.isXmlns() && s2.getLocal().length() == 0) {
                    s2.setName(r, new QName("", ""));
                    return s2.getLocal();
                }
                s2 = s2.nextSplay();
            }
            Xmlns a = new Xmlns(new QName("", ""));
            r.startChange();
            r.insertSplay(a, this);
            r.invalidateVersion();
            return a.getLocal();
        }
        if (!($assertionsDisabled || ns != null && ns.length() > 0)) {
            throw new AssertionError();
        }
        for (c = (Container)this; c != null; c = c.getContainer()) {
            s = c.nextSplay();
            while (s.isAttr()) {
                block33: {
                    if (s.isXmlns() && s.getUri().equals(ns)) {
                        String result = s.getLocal();
                        for (Container c2 = (Container)this; c2 != c; c2 = c2.getContainer()) {
                            Splay s2 = c2.nextSplay();
                            while (s2.isAttr()) {
                                if (!s2.isXmlns() || !s2.getLocal().equals(result)) {
                                    s2 = s2.nextSplay();
                                    continue;
                                }
                                break block33;
                            }
                        }
                        return result;
                    }
                }
                s = s.nextSplay();
            }
        }
        if (!createIfMissing) {
            return null;
        }
        if (suggestion != null) {
            if (suggestion.length() == 0 || suggestion.toLowerCase().startsWith("xml")) {
                suggestion = null;
            } else {
                block7: for (c = (Container)this; c != null; c = c.getContainer()) {
                    s = c.nextSplay();
                    while (s.isAttr()) {
                        if (s.isXmlns() && s.getLocal().equals(suggestion)) {
                            suggestion = null;
                            continue block7;
                        }
                        s = s.nextSplay();
                    }
                }
            }
        }
        if (suggestion == null) {
            String base;
            suggestion = base = QNameHelper.suggestPrefix(ns);
            int i = 1;
            while (true) {
                block10: for (c = (Container)this; c != null; c = c.getContainer()) {
                    s = c.nextSplay();
                    while (s.isAttr()) {
                        if (s.isXmlns() && s.getLocal().equals(suggestion)) {
                            suggestion = null;
                            break block10;
                        }
                        s = s.nextSplay();
                    }
                }
                if (suggestion != null) break;
                suggestion = base + i;
                ++i;
            }
        }
        Container target = null;
        Container lastContainer = null;
        for (c = (Container)this; c != null; c = c.getContainer()) {
            lastContainer = c;
            if (!c.isBegin()) continue;
            target = c;
        }
        if (target == null) {
            target = lastContainer;
        }
        Xmlns a = new Xmlns(new QName(ns, suggestion));
        r.startChange();
        r.insertSplay(a, target);
        r.invalidateVersion();
        return a.getLocal();
    }

    final Container getContainer(int p) {
        if (!($assertionsDisabled || p >= 0 && p <= this.getEndPos())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && p <= 0 && this.isDoc()) {
            throw new AssertionError();
        }
        if (p == 0) {
            return this.getContainer();
        }
        if (this.isLeaf()) {
            return p < this.getPosAfter() ? (Container)this : this.getContainer();
        }
        if (this.isContainer()) {
            return (Container)this;
        }
        if (this.isFinish()) {
            return this.getContainer().getContainer();
        }
        return this.getContainer();
    }

    abstract Container getContainer();

    Container findContainer() {
        if (!$assertionsDisabled && this.isContainer()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isFinish()) {
            throw new AssertionError();
        }
        Splay s = this.nextSplay();
        while (!s.isFinish() && !s.isBegin()) {
            s = s.nextSplay();
        }
        return s.getContainer();
    }

    final void invalidateText() {
        if (!$assertionsDisabled && !this.isValid()) {
            throw new AssertionError();
        }
        Type t = this.peekType();
        if (t != null) {
            if (!$assertionsDisabled && !this.isTypeable()) {
                throw new AssertionError();
            }
            t.invalidateText();
        }
    }

    final void invalidateNil() {
        Type t;
        if (!$assertionsDisabled && !this.isTypeable()) {
            throw new AssertionError();
        }
        if (!this.isAttr() && (t = this.peekType()) != null) {
            t.invalidateNil();
        }
    }

    protected final void disconnectTypes(Root r) {
        this.disconnectTypes(r, false);
    }

    protected final void disconnectTypes(Root r, boolean disconnectDoc) {
        if (!$assertionsDisabled && !this.isTypeable()) {
            throw new AssertionError();
        }
        Splay last = this.isAttr() ? this : this.getFinishSplay();
        Splay s = this;
        while (true) {
            Container c;
            Type t = null;
            if (s.isNormalAttr() || s.isLeaf()) {
                t = s.peekType();
            } else if (s.isFinish() && (!(c = s.getContainer()).isDoc() || disconnectDoc)) {
                t = c.peekType();
            }
            if (t != null) {
                Splay u = t.getSplay();
                if (u.isInvalid()) {
                    if (u.isAttr()) {
                        t.validateValue(u, t);
                    } else {
                        Splay f = u.getFinishSplay();
                        t.validateContent(u, t);
                        if (f == last) {
                            last = f;
                        }
                    }
                }
                t.disconnect(r);
            }
            if (s == last) break;
            if (s.isContainer() && !s.isLeaf() && s.peekType() == null) {
                s = s.getFinishSplay();
                continue;
            }
            s = s.nextSplay();
        }
    }

    final void setType(Root r, SchemaType sType) {
        this.setType(r, sType, true);
    }

    final void setType(Root r, SchemaType sType, boolean complain) {
        if (!$assertionsDisabled && !this.isTypeable()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && sType == null) {
            throw new AssertionError();
        }
        Type t = this.peekType();
        if (t != null && t.get_schema_type() == sType) {
            return;
        }
        if (this.isDoc()) {
            this.disconnectTypes(r, true);
            if (!$assertionsDisabled && this.peekType() != null) {
                throw new AssertionError();
            }
            new Type(r, sType, this);
            if (!$assertionsDisabled && !this.validate()) {
                throw new AssertionError();
            }
            return;
        }
        Type parentType = this.getContainer().getType(r);
        if (!$assertionsDisabled && parentType == null) {
            throw new AssertionError();
        }
        if (this.isAttr()) {
            if (parentType.get_attribute_type(this.getName()) != sType && complain) {
                throw new IllegalArgumentException("Can't set type of attribute to " + sType.toString());
            }
            return;
        }
        if (!$assertionsDisabled && !this.isBegin()) {
            throw new AssertionError();
        }
        if (parentType.get_element_type(this.getName(), null) == sType) {
            this.setXsiType(r, null);
            this.disconnectTypes(r);
            if (!$assertionsDisabled && !this.validate()) {
                throw new AssertionError();
            }
            return;
        }
        QName typeName = sType.getName();
        if (typeName == null) {
            if (complain) {
                throw new IllegalArgumentException("Can't set type of element, type is un-named");
            }
            return;
        }
        if (parentType.get_element_type(this.getName(), typeName) != sType) {
            if (complain) {
                throw new IllegalArgumentException("Can't set type of element, invalid type");
            }
            return;
        }
        this.setXsiType(r, typeName);
        this.disconnectTypes(r);
        if (!$assertionsDisabled && !this.validate()) {
            throw new AssertionError();
        }
    }

    final Type peekType() {
        if (!$assertionsDisabled && !this.isTypeable()) {
            throw new AssertionError();
        }
        Type type = null;
        if (this._goobers != null) {
            Goober g = this.firstGoober();
            while (g != null) {
                if (g.getKind() == 1) {
                    return (Type)g;
                }
                g = this.nextGoober(g);
            }
        }
        if (!$assertionsDisabled && type == null && !this.isValid()) {
            throw new AssertionError();
        }
        return type;
    }

    final Type getType(Root r) {
        if (!$assertionsDisabled && !this.isTypeable()) {
            throw new AssertionError();
        }
        Type type = this.peekType();
        if (!this.isDoc() && type == null) {
            TypeStoreUser newUser;
            Type parentType = this.getContainer().getType(r);
            if (!$assertionsDisabled && parentType == null) {
                throw new AssertionError();
            }
            if (parentType == null) {
                return null;
            }
            if (this.isBegin()) {
                newUser = parentType.create_element_user(this.getName(), this.getXsiTypeName(r));
            } else {
                if (!$assertionsDisabled && !this.isNormalAttr()) {
                    throw new AssertionError();
                }
                newUser = parentType.create_attribute_user(this.getName());
            }
            if (!$assertionsDisabled && newUser == null) {
                throw new AssertionError();
            }
            if (newUser == null) {
                return null;
            }
            type = new Type(r, newUser, this);
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        return type;
    }

    final boolean between(Root r, int pThis, Splay sRange) {
        int pEnd;
        Splay sEnd;
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != sRange.getRootSlow()) {
            throw new AssertionError();
        }
        if (sRange.isDoc()) {
            return true;
        }
        if (this.compare(r, pThis, sRange, 0) < 0) {
            return false;
        }
        if (!$assertionsDisabled && sRange.isDoc()) {
            throw new AssertionError();
        }
        if (sRange.isLeaf()) {
            sEnd = sRange;
            pEnd = sRange.getPosLeafEnd() + 1;
        } else if (sRange.isBegin()) {
            sEnd = sRange.getFinishSplay();
            pEnd = 1;
        } else {
            sEnd = sRange.nextSplay();
            pEnd = 0;
        }
        return this.compare(r, pThis, sEnd, pEnd) <= 0;
    }

    final int compare(Root r, int pThis, Splay sThat, int pThat) {
        Splay sThis = this;
        if (!$assertionsDisabled && Root.dv <= 0 && sThis.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && sThat.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || pThis >= 0 && pThis <= sThis.getEndPos())) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || pThat >= 0 && pThat <= sThat.getEndPos())) {
            throw new AssertionError();
        }
        if (pThis == sThis.getEndPos()) {
            if (sThis.isAttr()) {
                if ((sThis = sThis.nextSplay()).isAttr()) {
                    pThis = 0;
                } else {
                    sThis = sThis.prevNonAttrSplay();
                    pThis = 1;
                }
            } else {
                sThis = sThis.nextNonAttrSplay();
                pThis = 0;
            }
        }
        if (pThat == sThat.getEndPos()) {
            if (sThat.isAttr()) {
                if ((sThat = sThat.nextSplay()).isAttr()) {
                    pThat = 0;
                } else {
                    sThat = sThat.prevNonAttrSplay();
                    pThat = 1;
                }
            } else {
                sThat = sThat.nextNonAttrSplay();
                pThat = 0;
            }
        }
        if (!$assertionsDisabled && pThis >= sThis.getEndPos()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pThat >= sThat.getEndPos()) {
            throw new AssertionError();
        }
        if (sThis == sThat) {
            return pThis < pThat ? -1 : (pThis > pThat ? 1 : 0);
        }
        if (sThis.isAttr()) {
            if (sThat.isAttr()) {
                return this.compare(r, sThat);
            }
            if (sThis.prevNonAttrSplay() != sThat) {
                return this.compare(r, sThat);
            }
            return pThat == 0 ? 1 : -1;
        }
        if (sThat.isAttr()) {
            if (!$assertionsDisabled && sThis.isAttr()) {
                throw new AssertionError();
            }
            if (sThat.prevNonAttrSplay() != sThis) {
                return this.compare(r, sThat);
            }
            return pThis == 0 ? -1 : 1;
        }
        return this.compare(r, sThat);
    }

    private int compare(Root r, Splay sThat) {
        Splay sThis = this;
        if (sThis == sThat) {
            return 0;
        }
        if (r.isLeftOnly()) {
            if (sThis.getCchLeft() < sThat.getCchLeft()) {
                return -1;
            }
            if (sThis.getCchLeft() > sThat.getCchLeft()) {
                return 1;
            }
            if (sThis.getCdocBeginLeft() < sThat.getCdocBeginLeft()) {
                return -1;
            }
            if (sThis.getCdocBeginLeft() > sThat.getCdocBeginLeft()) {
                return 1;
            }
            while (sThis != r) {
                if ((sThis = sThis.nextSplay()) == sThat) {
                    return -1;
                }
                if (sThis.getCch() <= 0 && sThis.getCdocBegin() <= 0) continue;
            }
            return 1;
        }
        if (sThat.isRoot()) {
            return -1;
        }
        if (sThis.isRoot()) {
            return 1;
        }
        sThis.splay(r, r);
        sThat.splay(r, sThis);
        if (!$assertionsDisabled && sThis._leftSplay != sThat && sThis._rightSplay != sThat) {
            throw new AssertionError();
        }
        return sThis._leftSplay == sThat ? 1 : -1;
    }

    final Splay nextNonAttrSplay() {
        Splay s;
        for (s = this.nextSplay(); s != null && s.isAttr(); s = s.nextSplay()) {
        }
        return s;
    }

    final Splay prevNonAttrSplay() {
        Splay s;
        for (s = this.prevSplay(); s != null && s.isAttr(); s = s.prevSplay()) {
        }
        return s;
    }

    final Splay nextSplay() {
        Splay s = this;
        Splay r = s._rightSplay;
        if (r != null) {
            Splay l = s = r;
            while ((l = l._leftSplay) != null) {
                s = l;
            }
            return s;
        }
        Splay p = s._parentSplay;
        while (p != null && p._leftSplay != s) {
            s = p;
            p = s._parentSplay;
        }
        return p;
    }

    final Splay prevSplay() {
        Splay s = this;
        Splay l = s._leftSplay;
        if (l != null) {
            Splay r = s = l;
            while ((r = r._rightSplay) != null) {
                s = r;
            }
            return s;
        }
        Splay p = s._parentSplay;
        while (p != null && p._rightSplay != s) {
            s = p;
            p = s._parentSplay;
        }
        return p;
    }

    final void rotateRight() {
        if (!$assertionsDisabled && this._parentSplay._leftSplay != this) {
            throw new AssertionError();
        }
        Splay p = this._parentSplay;
        Splay g = p._parentSplay;
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError();
        }
        p._leftSplay = this._rightSplay;
        if (this._rightSplay != null) {
            this._rightSplay._parentSplay = p;
        }
        this._rightSplay = p;
        p._parentSplay = this;
        this._parentSplay = g;
        if (g != null) {
            if (g._leftSplay == p) {
                g._leftSplay = this;
            } else {
                g._rightSplay = this;
            }
        }
        p.adjustCchLeft(-this.getCchLeft() - this.getCch());
        p.adjustCdocBeginLeft(-this.getCdocBeginLeft() - this.getCdocBegin());
    }

    final void rotateLeft() {
        if (!$assertionsDisabled && this._parentSplay._rightSplay != this) {
            throw new AssertionError();
        }
        Splay p = this._parentSplay;
        Splay g = p._parentSplay;
        if (!$assertionsDisabled && p == null) {
            throw new AssertionError();
        }
        p._rightSplay = this._leftSplay;
        if (this._leftSplay != null) {
            this._leftSplay._parentSplay = p;
        }
        this._leftSplay = p;
        p._parentSplay = this;
        this._parentSplay = g;
        if (g != null) {
            if (g._leftSplay == p) {
                g._leftSplay = this;
            } else {
                g._rightSplay = this;
            }
        }
        this.adjustCchLeft(p.getCchLeft() + p.getCch());
        this.adjustCdocBeginLeft(p.getCdocBeginLeft() + p.getCdocBegin());
    }

    final void splay(Root r, Splay pStop) {
        if (!$assertionsDisabled && pStop == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this == pStop) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && r != null && this.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && r != null && pStop.getRootSlow() != r) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && r != null && !r.validateSplayTree()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isRoot()) {
            throw new AssertionError();
        }
        boolean rotated = false;
        while (true) {
            if (!$assertionsDisabled && this._parentSplay == null) {
                throw new AssertionError();
            }
            Splay p = this._parentSplay;
            if (!$assertionsDisabled && p == null) {
                throw new AssertionError();
            }
            if (p == pStop) break;
            Splay g = p._parentSplay;
            rotated = true;
            if (g == pStop) {
                if (p._leftSplay == this) {
                    this.rotateRight();
                    break;
                }
                this.rotateLeft();
                break;
            }
            if (g._leftSplay == p) {
                if (p._leftSplay == this) {
                    p.rotateRight();
                } else {
                    this.rotateLeft();
                }
                this.rotateRight();
                continue;
            }
            if (p._rightSplay == this) {
                p.rotateLeft();
            } else {
                this.rotateRight();
            }
            this.rotateLeft();
        }
        if (rotated && r != null) {
            r._leftOnly = false;
        }
        if (!$assertionsDisabled && r != null && !r.validateSplayTree()) {
            throw new AssertionError();
        }
    }

    final Splay removeSplay(Splay r) {
        Root root;
        Root root2 = root = r.isRoot() ? (Root)r : null;
        if (!$assertionsDisabled && r._parentSplay != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && root != null && !root.validateSplayTree()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isRoot()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isDoc()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && Root.dv <= 0 && this.getSplayRootSlow() != r) {
            throw new AssertionError();
        }
        int cch = this.getCch();
        int cbegin = this.getCdocBegin();
        if (root != null && root._leftOnly && cch == 0 && cbegin == 0) {
            if (!$assertionsDisabled && this._rightSplay != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._parentSplay == null) {
                throw new AssertionError();
            }
            this._parentSplay._leftSplay = this._leftSplay;
            if (this._parentSplay._leftSplay != null) {
                this._leftSplay._parentSplay = this._parentSplay;
            }
        } else {
            this.splay(root, r);
            if (this._leftSplay == null) {
                r.adjustCchLeft(-cch);
                r.adjustCdocBeginLeft(-cbegin);
                r._leftSplay = this._rightSplay;
                if (r._leftSplay != null) {
                    this._rightSplay._parentSplay = r;
                }
            } else {
                Splay p = this.prevSplay();
                p.splay(root, this);
                if (!$assertionsDisabled && p._rightSplay != null) {
                    throw new AssertionError();
                }
                r._leftSplay = p;
                p._parentSplay = r;
                r.adjustCchLeft(-cch);
                r.adjustCdocBeginLeft(-cbegin);
                p._rightSplay = this._rightSplay;
                if (p._rightSplay != null) {
                    p._rightSplay._parentSplay = p;
                }
            }
        }
        this._parentSplay = null;
        this._rightSplay = null;
        this._leftSplay = null;
        this.adjustCchLeft(-this.getCchLeft());
        this.adjustCdocBeginLeft(-this.getCdocBeginLeft());
        if (!$assertionsDisabled && root != null && !root.validateSplayTree()) {
            throw new AssertionError();
        }
        return this;
    }

    final Goober firstGoober() {
        if (this._goobers == null || this._goobers.getKind() != 3) {
            return this._goobers;
        }
        if (!$assertionsDisabled && this._goobers._goobers == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._goobers._goobers.getKind() == 3) {
            throw new AssertionError();
        }
        return this._goobers._goobers;
    }

    final Goober nextGoober(Goober g) {
        if (!$assertionsDisabled && g == null) {
            throw new AssertionError();
        }
        g = g._next;
        if (g != g._parent._goobers) {
            return g;
        }
        return g._parent == g._splay ? null : this.nextGoober((Goober)g._parent);
    }

    private static boolean getAssertEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                // empty if block
            }
        }
        return enabled;
    }

    static void assertAssertEnabled() {
        if (!_assertEnabled) {
            throw new RuntimeException("Assert needs to be enabled for this operation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDebugId() {
        if (_debugIds == null) {
            return -1;
        }
        HashMap hashMap = _debugIds;
        synchronized (hashMap) {
            if (!_debugIds.containsKey(this)) {
                _debugIds.put(this, new Integer(_nextDebugId++));
            }
            return (Integer)_debugIds.get(this);
        }
    }

    void dump() {
        this.getRootSlow().dump();
    }

    void dump(boolean verbose) {
        this.getRootSlow().dump(verbose);
    }

    public Splay getSplayRootSlow() {
        Splay.assertAssertEnabled();
        Splay s = this;
        while (s._parentSplay != null) {
            s = s._parentSplay;
        }
        return s;
    }

    public Root getRootSlow() {
        Splay.assertAssertEnabled();
        Splay s = this.getSplayRootSlow();
        return s.isRoot() ? (Root)s : null;
    }

    int getCpSlow() {
        Splay.assertAssertEnabled();
        int cch = 0;
        Splay s = this;
        while ((s = s.prevSplay()) != null) {
            cch += s.getCch();
        }
        return cch;
    }

    int compareSlow(Splay sThat) {
        Splay s;
        Splay.assertAssertEnabled();
        if (!$assertionsDisabled && Root.dv <= 0 && this.getRootSlow() != sThat.getRootSlow()) {
            throw new AssertionError();
        }
        if (this == sThat) {
            return 0;
        }
        for (s = this; s != null; s = s.nextSplay()) {
            if (s != sThat) continue;
            return -1;
        }
        for (s = this; s != null; s = s.prevSplay()) {
            if (s != sThat) continue;
            return 1;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Yikes!");
        }
        return 0;
    }

    boolean validate() {
        Splay.assertAssertEnabled();
        return this.getRootSlow().validate();
    }

    static {
        $assertionsDisabled = !Splay.class.desiredAssertionStatus();
        _xsiNil = new QName(_xsi, "nil");
        _xsiType = new QName(_xsi, "type");
        _openuriFragment = new QName(_openFragUri, "fragment");
        _xmlFragment = new QName("", "xml-fragment");
        _assertEnabled = Splay.getAssertEnabled();
        _debugIds = _assertEnabled ? new HashMap() : null;
        _nextDebugId = 1;
    }

    static class Annotation
    extends Goober
    implements XmlCursor.XmlMark {
        XmlCursor.XmlBookmark _annotation;
        Reference _ref;
        Object _key;

        public Object monitor() {
            return this.getRoot();
        }

        Annotation(Root r) {
            super(r, 2);
        }

        Annotation(Root r, XmlCursor.XmlBookmark a) {
            this(r);
            if (a._ref == null) {
                this._annotation = a;
            } else {
                this._ref = a._ref;
            }
            this._key = a.getKey();
        }

        void setKey(Object key) {
            this._key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final XmlCursor createCursor() {
            Object object = this.monitor();
            synchronized (object) {
                if (this.getSplay() == null) {
                    throw new IllegalStateException("Attempting to create a cursor on a bookmark that has been cleared or replaced.");
                }
                return new Cursor(this.getRoot(), this.getSplay(), this.getPos());
            }
        }

        public XmlCursor.XmlBookmark getXmlBookmark() {
            if (this._annotation != null) {
                return this._annotation;
            }
            if (this._ref != null) {
                return (XmlCursor.XmlBookmark)this._ref.get();
            }
            return null;
        }

        void disconnect(Root r) {
            super.disconnect(r);
            XmlCursor.XmlBookmark xa = this.getXmlBookmark();
            if (xa != null) {
                xa._currentMark = null;
            }
        }
    }

    static final class CursorGoober
    extends Goober {
        private static final HashMap _debugIds;
        private static int _nextDebugId;
        static final /* synthetic */ boolean $assertionsDisabled;

        CursorGoober(Root r) {
            super(r, 0);
        }

        private static final HashMap createDebugIdMap() {
            HashMap map = null;
            if (!$assertionsDisabled && (map = new HashMap()) == null) {
                throw new AssertionError();
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getDebugId() {
            if (_debugIds == null) {
                return -1;
            }
            HashMap hashMap = _debugIds;
            synchronized (hashMap) {
                if (!_debugIds.containsKey(this)) {
                    _debugIds.put(this, new Integer(_nextDebugId++));
                }
                return (Integer)_debugIds.get(this);
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Splay == null ? (class$org$apache$xmlbeans$impl$store$Splay = Splay.class$("org.apache.xmlbeans.impl.store.Splay")) : class$org$apache$xmlbeans$impl$store$Splay).desiredAssertionStatus();
            _debugIds = CursorGoober.createDebugIdMap();
            _nextDebugId = 1;
        }
    }

    static abstract class Goober
    extends Goobers {
        private Root _root;
        private Splay _splay;
        private int _state;
        Goober _next;
        Goober _prev;
        Goobers _parent;
        static final /* synthetic */ boolean $assertionsDisabled;

        Goober(Root r, int kind) {
            this._root = r;
            this._state = kind;
        }

        final int getKind() {
            return this._state & 7;
        }

        final Root getRoot() {
            return this._root;
        }

        final Splay getSplay() {
            return this._splay;
        }

        final int getPos() {
            return this._state >> 3;
        }

        final int getState() {
            return this._state;
        }

        final boolean isAnnotation() {
            return this.getKind() == 2;
        }

        final void set(Root r, Splay s, int p) {
            if (!$assertionsDisabled && s == null) {
                throw new AssertionError();
            }
            this.doSet(r, s, p);
        }

        private final void doSet(Root r, Splay s, int p) {
            if (!$assertionsDisabled && s == null && p != 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && Root.dv <= 0 && s != null && r != s.getRootSlow()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && Root.dv <= 0 && this._splay != null && this._root != this._splay.getRootSlow()) {
                throw new AssertionError();
            }
            this._root = r;
            if (this._splay != s) {
                if (this._splay != null) {
                    this.remove();
                }
                if (s != null) {
                    this.append(s);
                }
            }
            if (!$assertionsDisabled && p < 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._splay != null && p > this._splay.getMaxPos()) {
                throw new AssertionError();
            }
            this._state = p * 8 + (this._state & 7);
        }

        final void set(Root r) {
            if (!$assertionsDisabled && r == null) {
                throw new AssertionError();
            }
            this._root = r;
        }

        final void set(Splay s, int p) {
            this.doSet(this.getRoot(), s, p);
        }

        final void set(int p) {
            this.doSet(this.getRoot(), this.getSplay(), p);
        }

        final void set(Goober g) {
            this.doSet(g.getRoot(), g.getSplay(), g.getPos());
        }

        void disconnect(Root r) {
            this.doSet(r, null, 0);
        }

        private final void append(Splay s) {
            if (!$assertionsDisabled && s == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && Root.dv <= 0 && s.getRootSlow() != this._root) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._splay != null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._parent != null) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || this._next == null && this._prev == null)) {
                throw new AssertionError();
            }
            if (s._goobers == null) {
                s._goobers = this;
                this._next = this._prev = this;
            } else {
                this._next = s._goobers;
                this._prev = this._next._prev;
                this._next._prev = this;
                this._prev._next = this;
            }
            this._splay = s;
            this._parent = s;
        }

        private final void remove() {
            if (!$assertionsDisabled && this._splay == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this._goobers != null) {
                throw new AssertionError();
            }
            if (this._next == this) {
                if (!$assertionsDisabled && this._parent._goobers != this) {
                    throw new AssertionError();
                }
                this._parent._goobers = null;
                if (this._parent != this._splay) {
                    Goober g = (Goober)this._parent;
                    if (!$assertionsDisabled && g.getKind() != 3) {
                        throw new AssertionError();
                    }
                    g.remove();
                }
            } else {
                this._prev._next = this._next;
                this._next._prev = this._prev;
                if (this._parent._goobers == this) {
                    this._parent._goobers = this._next;
                }
            }
            this._prev = null;
            this._next = null;
            this._parent = null;
            this._splay = null;
        }

        XmlCursor.XmlBookmark getBookmark() {
            return this.getKind() == 2 ? ((Annotation)this).getXmlBookmark() : null;
        }

        String getKindName() {
            switch (this.getKind()) {
                case 0: {
                    return "CURSOR";
                }
                case 1: {
                    return "TYPE";
                }
                case 2: {
                    return "ANNOTATION";
                }
            }
            return "<unknow goober kind>";
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Splay == null ? (class$org$apache$xmlbeans$impl$store$Splay = Splay.class$("org.apache.xmlbeans.impl.store.Splay")) : class$org$apache$xmlbeans$impl$store$Splay).desiredAssertionStatus();
        }
    }

    static final class Procinst
    extends QNameSplay {
        Procinst(QName target) {
            super(4, false, target);
        }

        Procinst(String target) {
            super(4, false, new QName("", target));
        }

        Container getContainer() {
            return this.findContainer();
        }
    }

    static final class Xmlns
    extends Attr {
        Xmlns(QName name) {
            super(name, true);
        }
    }

    static class Attr
    extends QNameSplay {
        static final /* synthetic */ boolean $assertionsDisabled;

        Attr(QName name) {
            super(2, false, name);
        }

        Attr(QName name, boolean isXmlns) {
            super(2, true, name);
            if (!$assertionsDisabled && !isXmlns) {
                throw new AssertionError();
            }
        }

        Container getContainer() {
            Splay s = this.prevSplay();
            while (s.isAttr()) {
                s = s.prevSplay();
            }
            return (Container)s;
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Splay == null ? (class$org$apache$xmlbeans$impl$store$Splay = Splay.class$("org.apache.xmlbeans.impl.store.Splay")) : class$org$apache$xmlbeans$impl$store$Splay).desiredAssertionStatus();
        }
    }

    static final class Fragment
    extends Splay {
        Fragment() {
            super(3, true);
        }

        Container getContainer() {
            return null;
        }
    }

    static final class Comment
    extends Splay {
        Comment() {
            super(3, false);
        }

        Container getContainer() {
            return this.findContainer();
        }
    }

    static final class End
    extends Finish {
        final Begin _begin;

        End(Begin begin) {
            super(6);
            this._begin = begin;
        }

        Container getContainer() {
            return this._begin;
        }
    }

    static abstract class Finish
    extends Splay {
        Finish(int kind) {
            super(kind, false);
        }
    }

    static class Begin
    extends Container {
        End _end;
        Container _container;

        Begin(QName name, Container container) {
            super(1, false, name);
            this._container = container;
        }

        final Container getContainer() {
            return this._container;
        }

        final Finish getFinish() {
            return this._end;
        }
    }

    static final class Doc
    extends Container {
        Root _root;

        Doc(Root r, QName name) {
            super(0, false, name);
            this._root = r;
        }

        Container getContainer() {
            return null;
        }

        Finish getFinish() {
            return this._root;
        }
    }

    static abstract class Container
    extends QNameSplay {
        Container(int kind, boolean is, QName name) {
            super(kind, is, name);
        }

        abstract Finish getFinish();
    }

    static abstract class QNameSplay
    extends Splay {
        private QName _name;

        QNameSplay(int kind, boolean is, QName name) {
            super(kind, is);
            this._name = name;
        }

        final QName getName() {
            return this._name;
        }

        final void changeName(QName name) {
            this._name = name;
        }

        final String getUri() {
            return this._name.getNamespaceURI();
        }

        final String getLocal() {
            return this._name.getLocalPart();
        }
    }

    static final class CopyContext {
        private char[] _text;
        private Splay _first;
        private Splay _tail;
        private Splay _last;
        private Container _frontier;
        static final /* synthetic */ boolean $assertionsDisabled;

        CopyContext() {
        }

        void copyText(char[] text) {
            this._text = text;
        }

        void copySplay(Splay s, boolean copyTextAfter) {
            Splay t;
            if (!$assertionsDisabled && (s.isDoc() || s.isRoot())) {
                throw new AssertionError();
            }
            switch (s.getKind()) {
                case 1: {
                    s.ensureContentValid();
                    this._frontier = new Begin(s.getName(), this._frontier);
                    t = this._frontier;
                    if (!s.isLeaf()) break;
                    t.toggleIsLeaf();
                    this._frontier = this._frontier.getContainer();
                    break;
                }
                case 2: {
                    if (s.isXmlns()) {
                        t = new Xmlns(s.getName());
                        break;
                    }
                    s.ensureValueValid();
                    t = new Attr(s.getName());
                    break;
                }
                case 3: {
                    t = new Comment();
                    break;
                }
                case 4: {
                    t = new Procinst(s.getName());
                    break;
                }
                case 6: {
                    Begin b = (Begin)this._frontier;
                    b._end = new End(b);
                    t = b._end;
                    this._frontier = this._frontier.getContainer();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!$assertionsDisabled && !s.isValid()) {
                throw new AssertionError();
            }
            int cch = s.getCchValue();
            if (copyTextAfter) {
                int cchAfter = s.getCchAfter();
                cch += cchAfter;
                t.adjustCchAfter(cchAfter);
            }
            if (cch > 0) {
                t.adjustCch(cch);
            }
            this.copy(t);
        }

        void copyFragment(int cch) {
            if (!$assertionsDisabled && cch <= 0) {
                throw new AssertionError();
            }
            Fragment s = new Fragment();
            s.adjustCchAfter(cch);
            s.adjustCch(cch);
            this.copy(s);
        }

        Splay getTree() {
            if (!$assertionsDisabled && this._frontier != null) {
                throw new AssertionError();
            }
            if (this._last == null) {
                return null;
            }
            if (this._first != null) {
                this._last.adjustCchLeft(this._first.getCchLeft() + this._first.getCch());
                this._last.adjustCdocBeginLeft(this._first.getCdocBeginLeft() + this._first.getCdocBegin());
                this._last._leftSplay = this._first;
                this._first._parentSplay = this._last;
                if (this._tail != null) {
                    this._last.adjustCchLeft(this._tail.getCchLeft() + this._tail.getCch());
                    this._last.adjustCdocBeginLeft(this._tail.getCdocBeginLeft() + this._tail.getCdocBegin());
                    this._first._rightSplay = this._tail;
                    this._tail._parentSplay = this._first;
                }
            }
            return this._last;
        }

        char[] getText() {
            return this._text;
        }

        private void copy(Splay s) {
            if (this._last != null) {
                if (this._first == null) {
                    this._first = this._last;
                } else if (this._tail == null) {
                    this._tail = this._last;
                } else {
                    this._last.adjustCchLeft(this._tail.getCchLeft() + this._tail.getCch());
                    this._last.adjustCdocBeginLeft(this._tail.getCdocBeginLeft() + this._tail.getCdocBegin());
                    this._last._leftSplay = this._tail;
                    this._tail._parentSplay = this._last;
                    this._tail = this._last;
                }
            }
            this._last = s;
        }

        static {
            $assertionsDisabled = !(class$org$apache$xmlbeans$impl$store$Splay == null ? (class$org$apache$xmlbeans$impl$store$Splay = Splay.class$("org.apache.xmlbeans.impl.store.Splay")) : class$org$apache$xmlbeans$impl$store$Splay).desiredAssertionStatus();
        }
    }
}

