/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.values;

import java.math.BigInteger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlInt;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.QNameHelper;
import org.apache.xmlbeans.impl.common.ValidationContext;
import org.apache.xmlbeans.impl.values.JavaDecimalHolder;
import org.apache.xmlbeans.impl.values.JavaIntegerHolder;
import org.apache.xmlbeans.impl.values.XmlObjectBase;

public class JavaIntegerHolderEx
extends JavaIntegerHolder {
    private SchemaType _schemaType;

    public JavaIntegerHolderEx(SchemaType type, boolean complex) {
        this._schemaType = type;
        this.initComplexType(complex, false);
    }

    public SchemaType schemaType() {
        return this._schemaType;
    }

    protected void set_text(String s) {
        BigInteger v = JavaIntegerHolderEx.lex(s, _voorVc);
        if (this._validateOnSet()) {
            JavaIntegerHolderEx.validateValue(v, this._schemaType, _voorVc);
        }
        if (this._validateOnSet()) {
            JavaIntegerHolderEx.validateLexical(s, this._schemaType, _voorVc);
        }
        super.set_BigInteger(v);
    }

    protected void set_BigInteger(BigInteger v) {
        if (this._validateOnSet()) {
            JavaIntegerHolderEx.validateValue(v, this._schemaType, _voorVc);
        }
        super.set_BigInteger(v);
    }

    public static void validateLexical(String v, SchemaType sType, ValidationContext context) {
        JavaDecimalHolder.validateLexical(v, context);
        if (sType.hasPatternFacet() && !sType.matchPatternFacet(v)) {
            context.invalid("Integer (" + v + ") does not match pattern for " + QNameHelper.readable(sType));
        }
    }

    private static void validateValue(BigInteger v, SchemaType sType, ValidationContext context) {
        BigInteger m;
        BigInteger m2;
        BigInteger m3;
        BigInteger m4;
        XmlAnySimpleType mine;
        XmlInt td = (XmlInt)sType.getFacet(7);
        if (td != null) {
            String temp = v.toString();
            int len = temp.length();
            if (len > 0 && temp.charAt(0) == '-') {
                --len;
            }
            if (len > td.getIntValue()) {
                context.invalid("Integer total digits (" + temp + ") is greater than " + "total digits facet (" + td.getIntValue() + ") for " + QNameHelper.readable(sType));
                return;
            }
        }
        if ((mine = sType.getFacet(3)) != null && v.compareTo(m4 = JavaIntegerHolderEx.getBigIntegerValue(mine)) <= 0) {
            context.invalid("Integer (" + v + ") is less than or equal to " + "min exclusive facet (" + m4 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType mini = sType.getFacet(4);
        if (mini != null && v.compareTo(m3 = JavaIntegerHolderEx.getBigIntegerValue(mini)) < 0) {
            context.invalid("Integer (" + v + ") is less than " + "min inclusive facet (" + m3 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType maxi = sType.getFacet(5);
        if (maxi != null && v.compareTo(m2 = JavaIntegerHolderEx.getBigIntegerValue(maxi)) > 0) {
            context.invalid("Integer (" + v + ") is greater than " + "max inclusive facet (" + m2 + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType maxe = sType.getFacet(6);
        if (maxe != null && v.compareTo(m = JavaIntegerHolderEx.getBigIntegerValue(maxe)) >= 0) {
            context.invalid("Integer (" + v + ") is greater than or equal to " + "max exclusive facet (" + m + ") for " + QNameHelper.readable(sType));
            return;
        }
        XmlAnySimpleType[] vals = sType.getEnumerationValues();
        if (vals != null) {
            for (int i = 0; i < vals.length; ++i) {
                if (!v.equals(JavaIntegerHolderEx.getBigIntegerValue(vals[i]))) continue;
                return;
            }
            context.invalid("Integer (" + v + ") does not match any enumeration values for " + QNameHelper.readable(sType));
        }
    }

    private static BigInteger getBigIntegerValue(XmlObject o) {
        SchemaType s = o.schemaType();
        switch (s.getDecimalSize()) {
            case 1000001: {
                return ((XmlObjectBase)o).bigDecimalValue().toBigInteger();
            }
            case 1000000: {
                return ((XmlObjectBase)o).bigIntegerValue();
            }
        }
        throw new IllegalStateException("Bad facet type for Big Int: " + s);
    }

    protected void validate_simpleval(String lexical, ValidationContext ctx) {
        JavaIntegerHolderEx.validateLexical(lexical, this.schemaType(), ctx);
        JavaIntegerHolderEx.validateValue(this.bigIntegerValue(), this.schemaType(), ctx);
    }
}

