/*   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package myPackage;

import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlCursor;

import javax.xml.namespace.QName;

/**
 * Author: Cezar Andrei ( cezar.andrei at bea.com )
 * Date: Apr 25, 2004
 */

public class FooHandler
{
    public static String foo(XmlObject xo, String s)
    {
        return "{in FooHandler.handleFoo(s: " + s + ")}";
    }

    public static String getName(XmlObject xo)
    {
        return "{name in FooHandler}";
    }

    // for testing pre and post calls
    public static class PreBookmark extends XmlCursor.XmlBookmark
    {
        String _msg;

        PreBookmark(String msg)
        {
            _msg = msg;
        }

        public String getMsg()
        {
            return _msg;
        }
    }

    public static class PostBookmark extends XmlCursor.XmlBookmark
    {
        String _msg;

        PostBookmark(String msg)
        {
            _msg = msg;
        }

        public String getMsg()
        {
            return _msg;
        }
    }

    public static boolean preSet(int opType, XmlObject xo, QName prop, boolean isAttr, int index)
    {
        XmlCursor xc = xo.newCursor();
        xc.setBookmark(new PreBookmark("{preSet in FooHandler: " + opType + ", " + xo + ", " + prop + ", " + isAttr + ", " + index + "}"));
        xc.dispose();
        return true;
    }

    public static void postSet(int opType, XmlObject xo, QName prop, boolean isAttr, int index)
    {
        XmlCursor xc = xo.newCursor();
        xc.setBookmark(new PostBookmark("{postSet in FooHandler: " + opType + ", " + xo + ", " + prop + ", " + isAttr + ", " + index + "}"));
        xc.dispose();
    }
}