#include "xercescatalogresolver.h"
#include <xercesc/sax2/SAX2XMLReader.hpp>
#include <xercesc/framework/LocalFileInputSource.hpp>
//#include "catalogresolver.h"


InputSource *XercesCatalogResolver::resolveEntity (
			const XMLCh * const publicID,
			const XMLCh* const systemId )
{
	char *narrowPublicId = XMLString::transcode ( publicID );
	
	//std::string resolved = wrapLibxml->lookupPublicId ( narrowPublicId );

	std::string resolved = cr->lookupPublicId ( narrowPublicId );

	XMLString::release ( &narrowPublicId );
	
	if ( resolved.empty() )
		return NULL;

	XMLCh *wideResolved = XMLString::transcode ( resolved.c_str() );
	InputSource *source = (InputSource *)new LocalFileInputSource ( wideResolved );
	XMLString::release ( &wideResolved );

	return source;
}
