// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __ADDFILETHREAD_H__

#include "mfc.h"                            // Needed for CTypedPtrList - audited 4 Nov 2004

#include <wx/thread.h>                      // Needed for wxThread

class CPartFile;
struct UnknownFile_Struct;

class CAddFileThread: protected wxThread
{
public:
    CAddFileThread();

    static void Setup();
    static void Shutdown();

    static void AddFile(const char* path, const char* name, CPartFile* = NULL);
    static int GetCount();

protected:
    virtual bool InitInstance()
    {
        return true;
    }

    virtual wxThread::ExitCode Entry();
    virtual void OnExit() { }

private:
    wxThread* m_Thread;

    // Setted to non-zero to end the thread
    static volatile int m_endWaitingForHashList;

    // Lock for the wait list and the conditions
    static wxMutex m_lockWaitingForHashList;

    // Signaled when something is added to the wait list.
    static wxCondition m_runWaitingForHashList;

    // The wait list itself
    static CTypedPtrList<CPtrList, UnknownFile_Struct *> m_sWaitingForHashList;
};

#endif

