// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// This file was part of eMule created by Ornis

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "CatDialog.h"                      // Needed for Module's Prototype(s) - audited 5 Nov 2004

#include "DownloadListCtrl.h"               // Needed for CDownloadListCtrl - audited 5 Nov 2004
#include "otherfunctions.h"                 // Needed for GetResString - audited 5 Nov 2004
#include "Preferences.h"                    // CPreferences::GetCategory - audited 5 Nov 2004
#include "SharedFileList.h"                 // Needed for CSharedFileList - audited 5 Nov 2004
#include "TransferWnd.h"                    // Needed for CTransferWnd - audited 5 Nov 2004
#include "xmule.h"                          // Needed for theApp - audited 5 Nov 2004
#include "xmuleDlg.h"                       // Needed for CxmuleDlg - audited 5 Nov 2004

#include <wx/button.h>                      // Needed for wxButton
#include <wx/colordlg.h>                    // Needed for wxGetColourFromUser
#include <wx/combobox.h>                    // Needed for wxComboBox
#include <wx/dirdlg.h>                      // Needed for wxDirSelector
#include <wx/textctrl.h>                    // Needed for wxTextCtrl
#include <iostream>
#if defined(HAVE_XRC)
    #include <wx/xrc/xmlres.h>              // Needed for wxXmlResource
    #define SMARTID(A) (XRCID(#A))
    #define GetDlgItem(x,clas) XRCCTRL(*this, #x, clas)
#else
    #include <wx/sizer.h>                   // Needed for wxBoxSizer
    #include <wx/stattext.h>                // Needed for wxStaticText

    #define SMARTID(A) (A)
    #define GetDlgItem(id, type) (static_cast<type *>(this->FindWindow(id)))

    enum
    {
        IDC_BROWSE,
        IDC_CATCOLOR,
        IDC_COMMENT,
        IDC_INCOMING,
        IDC_PRIOCOMBO,
        IDC_TITLE
    };
#endif
using namespace std;
#define GetRValue(rgb) (((rgb)>>16)&0xff)
#define GetGValue(rgb) (((rgb)>>8)&0xff)
#define GetBValue(rgb) ((rgb)&0xff)

#define RGB(a,b,c) ((a&0xff)<<16|(b&0xff)<<8|(c&0xff))

IMPLEMENT_DYNAMIC_CLASS(CCatDialog, wxDialog)

BEGIN_EVENT_TABLE(CCatDialog, wxDialog)
    EVT_BUTTON(wxID_OK, CCatDialog::OnBnClickedOk)
    EVT_BUTTON(SMARTID(IDC_CATCOLOR), CCatDialog::OnBnClickColor)
    EVT_BUTTON(SMARTID(IDC_BROWSE), CCatDialog::OnBnClickedBrowse)
END_EVENT_TABLE()

CCatDialog::CCatDialog(wxWindow *parent, int index)
: wxDialog(parent, -1, _("Category"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE | wxSYSTEM_MENU)
{
#if defined(HAVE_XRC)
    wxXmlResource::Get()->LoadDialog(this, parent, "DLG_CAT");
#else
    CCatDialog* item1 = this;
    item1->SetExtraStyle(wxCAPTION | wxRESIZE_BORDER | wxSYSTEM_MENU | wxADJUST_MINSIZE);

    wxBoxSizer* item2 = new wxBoxSizer(wxVERTICAL);

    wxStaticText* item3 = new wxStaticText( item1, wxID_STATIC, _("Title:"), wxDefaultPosition, wxDefaultSize, 0);
    item2->Add(item3, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item4 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item4, 0, wxALIGN_LEFT, 5);

    item4->Add(20, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxTextCtrl* item6 = new wxTextCtrl( item1, IDC_TITLE, _T(""), wxDefaultPosition, wxDefaultSize, 0);
    item4->Add(item6, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* item7 = new wxStaticText( item1, wxID_STATIC, _("Description:"), wxDefaultPosition, wxDefaultSize, 0);
    item2->Add(item7, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item8 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item8, 0, wxALIGN_LEFT, 5);

    item8->Add(20, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxTextCtrl* item10 = new wxTextCtrl( item1, IDC_COMMENT, _T(""), wxDefaultPosition, wxSize(316, -1), 0);
    item8->Add(item10, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* item11 = new wxStaticText( item1, wxID_STATIC, _("Incoming Files:"), wxDefaultPosition, wxDefaultSize, 0);
    item2->Add(item11, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item12 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item12, 0, wxALIGN_LEFT, 5);

    item12->Add(20, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxTextCtrl* item14 = new wxTextCtrl( item1, IDC_INCOMING, _T(""), wxDefaultPosition, wxSize(316, -1), 0);
    item12->Add(item14, 0, wxALIGN_BOTTOM|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxButton* item15 = new wxButton( item1, IDC_BROWSE, _("..."), wxPoint(362, 134), wxSize(28, 24), 0);
    item12->Add(item15, 0, wxALIGN_CENTER_VERTICAL|wxLEFT|wxRIGHT|wxBOTTOM, 5);

    wxStaticText* item16 = new wxStaticText( item1, wxID_STATIC, _("Change priority for new assigned files"), wxDefaultPosition, wxDefaultSize, 0);
    item2->Add(item16, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item17 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item17, 0, wxALIGN_LEFT, 5);

    item17->Add(20, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxString* item19Strings = NULL;
    wxComboBox* item19 = new wxComboBox( item1, IDC_PRIOCOMBO, _T(""), wxPoint(36, 184), wxSize(138, 96), 0, item19Strings, 0);
    item17->Add(item19, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxStaticText* item20 = new wxStaticText( item1, wxID_STATIC, _("Color"), wxDefaultPosition, wxDefaultSize, 0);
    item2->Add(item20, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    wxBoxSizer* item21 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item21, 0, wxALIGN_LEFT, 5);

    item21->Add(20, 5, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* item23 = new wxButton( item1, IDC_CATCOLOR, _T(""), wxPoint(36, 238), wxSize(59, 32), 0);
    item21->Add(item23, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxBoxSizer* item24 = new wxBoxSizer(wxHORIZONTAL);
    item2->Add(item24, 0, wxALIGN_RIGHT, 5);

    wxButton* item25 = new wxButton( item1, wxID_OK, _("OK"), wxPoint(211, 268), wxSize(82, 24), 0);
    item24->Add(item25, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxButton* item26 = new wxButton( item1, wxID_CANCEL, _("Cancel"), wxPoint(302, 268), wxSize(87, 24), 0);
    item24->Add(item26, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    item1->SetSizerAndFit(item2);
    item1->SetAutoLayout(TRUE);
#endif

    Center();
    m_myCat = theApp.glob_prefs->GetCategory(index);
}

bool CCatDialog::OnInitDialog()
{
    m_prio = GetDlgItem(IDC_PRIOCOMBO, wxComboBox);

    m_ctlColor = GetDlgItem(IDC_CATCOLOR, wxButton);

    GetDlgItem(IDC_TITLE, wxTextCtrl)->SetValue(m_myCat->title);
    GetDlgItem(IDC_INCOMING, wxTextCtrl)->SetValue(m_myCat->incomingpath);
    GetDlgItem(IDC_COMMENT, wxTextCtrl)->SetValue(m_myCat->comment);
    newcolor = m_myCat->color;

    m_prio->Append(GetResString(IDS_DONTCHANGE));
    m_prio->Append(GetResString(IDS_PRIOLOW));
    m_prio->Append(GetResString(IDS_PRIONORMAL));
    m_prio->Append(GetResString(IDS_PRIOHIGH));
    m_prio->Append(GetResString(IDS_PRIOAUTO));
    m_prio->SetSelection(m_myCat->prio);
    m_ctlColor->SetBackgroundColour(wxColour(GetBValue(newcolor), GetGValue(newcolor), GetRValue(newcolor)));

    return true;
}

void CCatDialog::OnBnClickedBrowse(wxCommandEvent &evt)
{
    wxString dir = wxDirSelector(GetResString(IDS_SELECT_INCOMINGDIR),
    GetDlgItem(IDC_INCOMING, wxTextCtrl)->GetValue());
    
    if (!dir.IsEmpty())
    {
        GetDlgItem(IDC_INCOMING, wxTextCtrl)->SetValue(dir);
    }
}

void CCatDialog::OnBnClickedOk(wxCommandEvent &evt)
{
    wxString oldpath = m_myCat->incomingpath;

    if (GetDlgItem(IDC_TITLE, wxTextCtrl)->GetValue().Length() > 0)
    {
        m_myCat->title = GetDlgItem(IDC_TITLE, wxTextCtrl)->GetValue();
    }

    if (GetDlgItem(IDC_INCOMING, wxTextCtrl)->GetValue().Length() > 1)
    {
        m_myCat->incomingpath = GetDlgItem(IDC_INCOMING, wxTextCtrl)->GetValue();
    }

    m_myCat->comment = GetDlgItem(IDC_COMMENT, wxTextCtrl)->GetValue();
    MakeFoldername(m_myCat->incomingpath);

    if (!::wxDirExists(m_myCat->incomingpath))
    {
        wxMkdir(m_myCat->incomingpath, 0777);
    }

    if (m_myCat->incomingpath.CmpNoCase(oldpath) != 0)
    {
        theApp.sharedfiles->AddFilesFromDirectory(m_myCat->incomingpath);
        theApp.sharedfiles->Reload();
    }
    
    m_myCat->color = newcolor;
    cout << "cat color: " << std::hex << newcolor << endl;
    m_myCat->prio = m_prio->GetSelection();
    theApp.xmuledlg->transferwnd->downloadlistctrl->Refresh();
    EndModal(0);
}

void CCatDialog::OnBnClickColor(wxCommandEvent &evt)
{
    wxColour newcol = wxGetColourFromUser(this, wxColour(GetBValue(newcolor), GetGValue(newcolor), GetRValue(newcolor)));
    if (newcol.Ok())
    {
        newcolor = RGB(newcol.Blue(), newcol.Green(), newcol.Red());
        m_ctlColor->SetBackgroundColour(newcol);
    }
}
