// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "ClientDetailDialog.h"             // Needed for Module's Prototype(s) - audited 6 Nov 2004

#include "ClientCredits.h"                  // Needed for CClientCredits - audited 5 Nov 2004
#include "KnownFile.h"                      // Needed for CKnownFile - audited 5 Nov 2004
#include "muuli_wdr.h"                      // Needed for clientDetails - audited 4 Nov 2004
#include "otherfunctions.h"                 // Needed for GetResString - audited 4 Nov 2004
#include "server.h"                         // Needed for CServer - audited 5 Nov 2004
#include "ServerList.h"                     // Needed for CServerList - audited 5 Nov 2004
#include "SharedFileList.h"                 // Needed for CSharedFileList - audited 5 Nov 2004
#include "updownclient.h"                   // Needed for CUpDownClient - audited 5 Nov 2004
#include "xmule.h"                          // Needed for theApp

#include <arpa/inet.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <wx/intl.h>                        // Needed for _
#include <wx/sizer.h>                       // Needed for wxSizer
#include <wx/stattext.h>                    // Needed for wxStaticText

#define GetDlgItem(a,b) wxStaticCast(FindWindowById((a)),b)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

BEGIN_EVENT_TABLE(CClientDetailDialog, wxDialog)
EVT_BUTTON(ID_CLOSEWND, CClientDetailDialog::OnBnClose)
END_EVENT_TABLE()

//IMPLEMENT_DYNAMIC(CClientDetailDialog, CDialog)
CClientDetailDialog::CClientDetailDialog(wxWindow *parent, CUpDownClient *client)
: wxDialog(parent, 9997, "Client Details", wxDefaultPosition, wxDefaultSize,
wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
//: CDialog(CClientDetailDialog::IDD, 0)
{
    m_client = client;
    wxSizer *content = clientDetails(this, TRUE);
    content->Show(this, TRUE);
    Centre();
    OnInitDialog();
}

CClientDetailDialog::~CClientDetailDialog()
{
}

#if 0
void CClientDetailDialog::DoDataExchange(CDataExchange *pDX)
{
    CDialog::DoDataExchange(pDX);
}

#endif

void CClientDetailDialog::OnBnClose(wxCommandEvent &evt)
{
    EndModal(0);
}

bool CClientDetailDialog::OnInitDialog()
{
    Localize();
    char buffer[100];
    if (m_client->GetUserName())
    GetDlgItem(ID_DNAME, wxStaticText)->SetLabel(m_client->GetUserName());
    else
    GetDlgItem(ID_DNAME, wxStaticText)->SetLabel("?");
    if (m_client->GetUserName())
    {
        buffer[0] = 0;
        for (uint16_t i = 0 ; i != 16 ; i++)
        sprintf(buffer, "%s%02X", buffer, m_client->GetUserHash() [i]);
        GetDlgItem(ID_DHASH, wxStaticText)->SetLabel(buffer);
    }
    else
    GetDlgItem(ID_DHASH, wxStaticText)->SetLabel("?");
    switch (m_client->GetClientSoft())
    {
        case SO_UNKNOWN:
        {
            GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel("?");
            GetDlgItem(ID_DVERSION, wxStaticText)->SetLabel("?");
            break;
        }
        case SO_EMULE:
        case SO_OLDEMULE:
        case SO_CDONKEY:
        case SO_AMULE:
        case SO_SHAREAZA:
        case SO_XMULE:
        {
            GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("eMule"));
            wxUint8 version = m_client->GetMuleVersion();

            if (version == 0x0)
            {
                strcpy(buffer, "?");
            }
            else if (version != 0x99)
            {
                if (m_client->GetClientModString().IsEmpty() == false)
                {
                    sprintf(buffer, "[ %s ]", m_client->GetClientModString() .c_str());
                }
                else
                {
                    sprintf(buffer, "v0.%02X", m_client->GetMuleVersion());
                }
            }
            else
            {
                sprintf(buffer, "%s", static_cast<const char *>(m_client->GetClientVerString().c_str()));
            }
            break;
        }
        case SO_EDONKEYHYBRID:
        case SO_EDONKEY:
            GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("eDonkey"));
            sprintf(buffer, "v%i", m_client->GetVersion());
            break;
        case SO_MLDONKEY:
            GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("Old MlDonkey"));
            sprintf(buffer, "v%i", m_client->GetVersion());
            break;
        case SO_NEW_MLDONKEY:
            GetDlgItem(ID_DSOFT, wxStaticText)->SetLabel(_("New MlDonkey"));
            sprintf(buffer, "v%i", m_client->GetVersion());
            break;
    }
    GetDlgItem(ID_DVERSION, wxStaticText)->SetLabel(wxString(buffer, *wxConvCurrent));

    sprintf(buffer, "%u (%s)", m_client->GetUserID(), (m_client->HasLowID() ? GetResString(IDS_PRIOLOW) .GetData(): GetResString(IDS_PRIOHIGH) .GetData()));
    GetDlgItem(ID_DID, wxStaticText)->SetLabel(buffer);
    sprintf(buffer, "%s:%i", m_client->GetFullIP(), m_client->GetUserPort());
    GetDlgItem(ID_DIP, wxStaticText)->SetLabel(buffer);
    if (m_client->GetServerIP())
    {
        in_addr server;
        server.s_addr = m_client->GetServerIP();
        GetDlgItem(ID_DSIP, wxStaticText)->SetLabel(inet_ntoa(server));
        CServer* cserver = theApp.serverlist->GetServerByAddress(inet_ntoa(server), m_client->GetServerPort());
        if (cserver)
        {
            GetDlgItem(ID_DSNAME, wxStaticText)->SetLabel(cserver->GetListName());
        }
        else
        {
            GetDlgItem(ID_DSNAME, wxStaticText)->SetLabel("?");
        }
    }
    else
    {
        GetDlgItem(ID_DSIP, wxStaticText)->SetLabel("?");
        GetDlgItem(ID_DSNAME, wxStaticText)->SetLabel("?");
    }
    if (m_client->Credits())
    {
	    char result[33];unsigned char *key;
        switch (m_client->Credits()->GetCurrentIdentState(m_client->GetIP()))
        {
        case IS_IDNEEDED:
            GetDlgItem(ID_SECI, wxStaticText)->SetLabel("in progress");
            break;
        case IS_IDFAILED:
	    key=(unsigned char *)m_client->Credits()->GetKey();
	    sprintf(result,"%08x%08x%04x",((uint32_t*)key)[0],((uint32_t*)key)[1],((uint32_t*)key)[2]%65535);
            GetDlgItem(ID_SECI, wxStaticText)->SetLabel("not supported");
            GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(result);
            break;
        case IS_IDENTIFIED:
	    key=(unsigned char *)m_client->Credits()->GetKey();
	    sprintf(result,"%08x%08x%04x",((uint32_t*)key)[0],((uint32_t*)key)[1],((uint32_t*)key)[2]%65535);
            GetDlgItem(ID_SECI, wxStaticText)->SetLabel("is identified");
            GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(result);
            break;
        case IS_IDBADGUY:
	    key=(unsigned char *)m_client->Credits()->GetKey();
	    sprintf(result,"%08x%08x%04x",((uint32_t*)key)[0],((uint32_t*)key)[1],((uint32_t*)key)[2]%65535);
            GetDlgItem(ID_SECI, wxStaticText)->SetLabel("Client=BadGuy");
            GetDlgItem(ID_PUBK, wxStaticText)->SetLabel(result);
            break;
        default:
            GetDlgItem(ID_SECI, wxStaticText)->SetLabel("State unknown");
            GetDlgItem(ID_PUBK, wxStaticText)->SetLabel("");
	    break;
        }
    }
    else
    {
        GetDlgItem(ID_SECI, wxStaticText)->SetLabel("is waiting");
        GetDlgItem(ID_PUBK, wxStaticText)->SetLabel("");
    }
    CKnownFile *file = theApp.sharedfiles->GetFileByID(m_client->GetUploadFileID());
    if (file)
    GetDlgItem(ID_DDOWNLOADING, wxStaticText)->SetLabel(file->GetFileName());
    else
    GetDlgItem(ID_DDOWNLOADING, wxStaticText)->SetLabel("-");
    GetDlgItem(ID_DDUP, wxStaticText)->SetLabel(CastItoXBytes(m_client->GetTransferedDown()));
    GetDlgItem(ID_DDOWN, wxStaticText)->SetLabel(CastItoXBytes(m_client->GetTransferedUp()));
    sprintf(buffer, "%.1f %s", (float) m_client->GetDownloadDatarate() /1024, GetResString(IDS_KBYTESEC) .GetData());
    GetDlgItem(ID_DAVUR, wxStaticText)->SetLabel(buffer);
    sprintf(buffer, "%.1f %s", (float) m_client->GetDatarate() /1024, GetResString(IDS_KBYTESEC) .GetData());
    GetDlgItem(ID_DAVDR, wxStaticText)->SetLabel(buffer);
    if (m_client->Credits())
    {
        GetDlgItem(ID_DUPTOTAL, wxStaticText)->SetLabel(CastItoXBytes(m_client->Credits()->GetDownloadedTotal()));
        GetDlgItem(ID_DDOWNTOTAL, wxStaticText)->SetLabel(CastItoXBytes(m_client->Credits()->GetUploadedTotal()));
        sprintf(buffer, "%.1f", (float) m_client->Credits()->GetScoreRatio(m_client->GetIP()));
        GetDlgItem(ID_DRATIO, wxStaticText)->SetLabel(buffer);
    }
    else
    {
        GetDlgItem(ID_DDOWNTOTAL, wxStaticText)->SetLabel("?");
        GetDlgItem(ID_DUPTOTAL, wxStaticText)->SetLabel("?");
        GetDlgItem(ID_DRATIO, wxStaticText)->SetLabel("?");
    }
    if (m_client->GetUserName())
    {
        sprintf(buffer, "%.1f", (float) m_client->GetScore(m_client->IsDownloading(), true));
        GetDlgItem(ID_DRATING, wxStaticText)->SetLabel(buffer);
    }
    else
        GetDlgItem(ID_DRATING, wxStaticText)->SetLabel("?");;
    if (m_client->GetUploadState() != US_NONE)
    {
        sprintf(buffer, "%u", m_client->GetScore(m_client->IsDownloading(), false));
        GetDlgItem(ID_DSCORE, wxStaticText)->SetLabel(buffer);
    }
    else
    GetDlgItem(ID_DSCORE, wxStaticText)->SetLabel("-");
    return true;
}

#if 0
BEGIN_MESSAGE_MAP(CClientDetailDialog, CDialog)
END_MESSAGE_MAP()
#endif

// CClientDetailDialog message handlers
void CClientDetailDialog::Localize()
{
#if 0
    GetDlgItem(IDC_STATIC30)->SetWindowText(GetResString(IDS_CD_GENERAL));
    GetDlgItem(IDC_STATIC31)->SetWindowText(GetResString(IDS_CD_UNAME));
    GetDlgItem(IDC_STATIC32)->SetWindowText(GetResString(IDS_CD_UHASH));
    GetDlgItem(IDC_STATIC33)->SetWindowText(GetResString(IDS_CD_CSOFT));
    GetDlgItem(IDC_STATIC34)->SetWindowText(GetResString(IDS_CD_UIP));
    GetDlgItem(IDC_STATIC35)->SetWindowText(GetResString(IDS_CD_SIP));
    GetDlgItem(IDC_STATIC36)->SetWindowText(GetResString(IDS_CD_VERSION));
    GetDlgItem(IDC_STATIC37)->SetWindowText(GetResString(IDS_CD_UID));
    GetDlgItem(IDC_STATIC38)->SetWindowText(GetResString(IDS_CD_SNAME));
    GetDlgItem(IDC_STATIC40)->SetWindowText(GetResString(IDS_CD_TRANS));
    GetDlgItem(IDC_STATIC41)->SetWindowText(GetResString(IDS_CD_CDOWN));
    GetDlgItem(IDC_STATIC42)->SetWindowText(GetResString(IDS_CD_DOWN));
    GetDlgItem(IDC_STATIC43)->SetWindowText(GetResString(IDS_CD_ADOWN));
    GetDlgItem(IDC_STATIC44)->SetWindowText(GetResString(IDS_CD_TDOWN));
    GetDlgItem(IDC_STATIC45)->SetWindowText(GetResString(IDS_CD_UP));
    GetDlgItem(IDC_STATIC46)->SetWindowText(GetResString(IDS_CD_AUP));
    GetDlgItem(IDC_STATIC47)->SetWindowText(GetResString(IDS_CD_TUP));
    GetDlgItem(IDC_STATIC50)->SetWindowText(GetResString(IDS_CD_SCORES));
    GetDlgItem(IDC_STATIC51)->SetWindowText(GetResString(IDS_CD_MOD));
    GetDlgItem(IDC_STATIC52)->SetWindowText(GetResString(IDS_CD_RATING));
    GetDlgItem(IDC_STATIC53)->SetWindowText(GetResString(IDS_CD_USCORE));
    GetDlgItem(IDOK)->SetWindowText(GetResString(IDS_FD_CLOSE));
    SetWindowText(GetResString(IDS_CD_TITLE));
#endif
}

