// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "CommentDialogLst.h"
#	include "muuli_wdr.h"
#	include "otherfunctions.h"
#	include "PartFile.h"
#	include "updownclient.h"
#	include "wintypes.h"
#	include "xmule.h"
#endif

#include <wx/dialog.h>
#include <wx/settings.h>

#include "wx/xrc/xmlres.h"
#include "wx/xrc/xh_all.h"

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)


BEGIN_EVENT_TABLE(CCommentDialogLst, wxDialog)
    EVT_BUTTON(XRCID("IDCOK"), CCommentDialogLst::OnBnClickedApply)
    EVT_BUTTON(XRCID("IDCREF"), CCommentDialogLst::OnBnClickedRefresh)
END_EVENT_TABLE()


CCommentDialogLst::CCommentDialogLst(wxWindow *parent, CPartFile *file):
    wxDialog(parent, CCommentDialogLst::IDD, _("File Comments"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    m_file = file;
    //wxSizer* content=commentLstDlg(this,TRUE);
    //content->Show(this,TRUE);
    wxPanel *content = wxXmlResource::Get()->LoadPanel(this, "DLG_COMMENTLST");
    SetSize(content->GetSize());
    content->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    Centre();
    pmyListCtrl = XRCCTRL( *this, "IDC_LST", wxListCtrl);
    OnInitDialog();
}

CCommentDialogLst::~CCommentDialogLst()
{
}

void CCommentDialogLst::OnBnClickedApply(wxCommandEvent &evt)
{
    //CDialog::OnOK();
    EndModal(0);
}

void CCommentDialogLst::OnBnClickedRefresh(wxCommandEvent &evt)
{
    CompleteList();
}

bool CCommentDialogLst::OnInitDialog()
{
    //CDialog::OnInitDialog();
    pmyListCtrl->InsertColumn(0, GetResString(IDS_CD_UNAME), wxLIST_FORMAT_LEFT, 130);
    pmyListCtrl->InsertColumn(1, GetResString(IDS_DL_FILENAME), wxLIST_FORMAT_LEFT, 130);
    pmyListCtrl->InsertColumn(2, GetResString(IDS_QL_RATING), wxLIST_FORMAT_LEFT, 80);
    pmyListCtrl->InsertColumn(3, GetResString(IDS_COMMENT), wxLIST_FORMAT_LEFT, 340);
    Localize();
    CompleteList();
    return TRUE;
}

void CCommentDialogLst::Localize(void)
{
    GetDlgItem(IDCOK, wxControl)->SetLabel(GetResString(IDS_CW_CLOSE));
    GetDlgItem(IDCREF, wxControl)->SetLabel(GetResString(IDS_CMT_REFRESH));
    SetTitle(GetResString(IDS_CMT_READALL) + " (" + m_file->GetFileName() + ")");
}

void CCommentDialogLst::CompleteList()
{
    POSITION pos1, pos2;
    CUpDownClient* cur_src;
    int count = 0;
    pmyListCtrl->DeleteAllItems();

    for (pos1 = m_file->srclist.GetHeadPosition(); (pos2 = pos1) != NULL;)
    {
        m_file->srclist.GetNext(pos1);
        cur_src = m_file->srclist.GetAt(pos2);

        if (cur_src->GetFileComment().Length() > 0 || cur_src->GetFileRate() > 0)
        {
            pmyListCtrl->InsertItem(count, cur_src->GetUserName());
            pmyListCtrl->SetItem(count, 1, cur_src->GetClientFilename());
            pmyListCtrl->SetItem(count, 2, GetRateString(cur_src->GetFileRate()));
            pmyListCtrl->SetItem(count, 3, cur_src->GetFileComment());
            count++;
        }
    }

    wxString info = "";

    if (count == 0) 
    {
        info = "(" + GetResString(IDS_CMT_NONE) + ")";
    }

    GetDlgItem(IDC_CMSTATUS, wxControl)->SetLabel(info);
    m_file->UpdateFileRatingCommentAvail();
}

