// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _IPFILTER_H
#define _IPFILTER_H

#include "mfc.h"                            // CArray wxString - audited 4 Nov 2004

#include <stdint.h>                         // uint32_t

struct IPRange_Struct
{
    uint32_t  IPstart;
    uint32_t  IPend;
    uint8_t   filter;
    wxString  description;
};

class CIPFilter
{
public:
	CIPFilter();
	~CIPFilter();
	void	AddBannedIPRange(uint32_t IPfrom,uint32_t IPto,uint8_t filter, wxString desc);
	void	RemoveAllIPs();
	int		LoadFromFile();
	void	SaveToFile();
	bool	IsFiltered(uint32_t IP2test);
	wxString GetLastHit()				{ return lasthit;}
	uint16_t	BanCount()					{ return iplist.GetCount(); }
private:
	wxString lasthit;
	//CMutex m_Mutex;
	CArray<IPRange_Struct*,IPRange_Struct*> iplist;
};

#endif
