// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// handling incoming connections (up or downloadrequests)

#ifndef LISTENSOCKET_H
#define LISTENSOCKET_H

#include "EMSocket.h"                       // CEMSocket - audited 5 Nov 2004

#include <wx/socket.h>
#include <wx/hashmap.h>
#include <string.h>

class CPreferences;
class Packet;
class wxEvtHandler;

class WXDLLEXPORT MyIntegerHash
{
public:
    MyIntegerHash() { }
    uint64_t operator()( uint64_t x ) const { return x; }

    MyIntegerHash& operator=(const MyIntegerHash&) { return *this; }
};

class WXDLLEXPORT MyIntegerEqual
{
public:
    MyIntegerEqual() { }
    bool operator()( uint64_t a, uint64_t b ) const { return a == b; }

    MyIntegerEqual& operator=(const MyIntegerEqual&) { return *this; }
};

WX_DECLARE_HASH_MAP(uint64_t, uint32_t, MyIntegerHash, MyIntegerEqual, MyHashMap1);
WX_DECLARE_HASH_MAP(uint64_t, uint64_t, MyIntegerHash, MyIntegerEqual, MyHashMap2);

class CUpDownClient;
class CTimerWnd;

//class CClientReqSocket;

class CClientReqSocket : public CEMSocket
{
friend class CClientSocket;

	DECLARE_DYNAMIC_CLASS(CClientReqSocket)

	CClientReqSocket(); /*{};*/
public:

	CClientReqSocket(CPreferences* in_prefs, CUpDownClient* in_client = 0);	
	~CClientReqSocket();
	void		Disconnect();

	void		ResetTimeOutTimer();
	bool		CheckTimeOut();
	void		Safe_Delete();

	long		deletethis;

	bool		Create();
	void		OnClose(int nErrorCode);

	void		OnLost(int nErrorCode);
	void		OnInput(int nErrorCode);
	void		OnOutput(int nErrorCode);

	virtual	void OnInit();
	virtual	bool Close(); /*	{return wxSocketBase::Close();}*/
	
	uint32_t		timeout_timer;
	uint32_t		deltimer;  
	bool		hotrank;
	CUpDownClient*	client;
	CPreferences* 	app_prefs;


protected:
	void		 PacketReceived(Packet* packet);
private:
	void		Delete_Timed();
	bool		ProcessPacket(char* packet, uint32_t size,uint8_t opcode);
	bool		ProcessExtPacket(char* packet, uint32_t size,uint8_t opcode);
    wxEvtHandler* m_event_handler;
};

#include <wx/list.h>
#include <wx/version.h>                     // wxCHECK_VERSION
//WX_DECLARE_LIST(CClientReqSocket,SocketListL);

// CListenSocket command target
class CListenSocket : public wxSocketServer
{
  DECLARE_DYNAMIC_CLASS(CListenSocket)

public:
    #if wxCHECK_VERSION(2,5,3)
	CListenSocket(): wxSocketServer(happyCompiler, wxSOCKET_NOWAIT | wxSOCKET_REUSEADDR) {};
    #else
	CListenSocket(): wxSocketServer(happyCompiler, wxSOCKET_NOWAIT) {};
    #endif
	CListenSocket(CPreferences* in_prefs,wxSockAddress& addr);
	~CListenSocket();
	bool	StartListening();
	void	StopListening();
	virtual void OnAccept(int nErrorCode);
	void	Process();
	void	RemoveSocket(CClientReqSocket* todel);
	void	AddSocket(CClientReqSocket* toadd);
	uint16_t	GetOpenSockets()		{return socket_list.GetCount();}
	void	KillAllSockets();
	bool	TooManySockets(bool bIgnoreInterval = false);
	uint32_t	GetMaxConnectionReached()	{return maxconnectionreached;}
	bool    IsValidSocket(CClientReqSocket* totest);
	void	AddConnection();
	void	RecalculateStats();
	void	ReStartListening();

	void	Debug_ClientDeleted(CUpDownClient* deleted);
private:
	bool bListening;
	CPreferences* app_prefs;
	CTypedPtrList<CPtrList, CClientReqSocket*> socket_list;
	//SocketListL socket_list;
	uint16_t opensockets;
	uint16_t m_OpenSocketsInterval;
	uint32_t maxconnectionreached;
	wxIPV4address happyCompiler;
	uint16_t	m_ConnectionStates[3];
	uint16_t	m_nPeningConnections;
    wxEvtHandler* m_event_handler;

public:
	MyHashMap1 offensecounter;
	MyHashMap2 hashbase;  

};


#endif
