// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _NEWFUNCTIONS
#define _NEWFUNCTIONS

#include <stdint.h>                         // uint32_t

#define		MAPCLIENTS_MAX		30000

typedef struct _MAP
{
	_MAP*	next;
	_MAP* 	prev;
	uint32_t Data;
	uint32_t Data2;
	unsigned char *Key;
}

MAP;

extern uint32_t globaldata2;

extern MAP* ToDelete_ClientReqSockets;
extern MAP* ToDelete_UpDownClients;

uint32_t MapData(MAP* pos);
unsigned char *MapDataKey(MAP* pos);
void MapData_Init(MAP *&base);
MAP* MapData_Find(MAP* base,void *tofind, int length);
uint32_t MapData_GetCount(MAP *base);
void *MapData_GetIt(MAP* pos);
MAP* MapData_GetNext(MAP* next);
void MapData_Append(MAP *base,void *data, void *key=NULL, int length=0);
void MapData_Insert(MAP *base,void *data, void *key=NULL, int length=0);
MAP* MapData_Remove(MAP *base,MAP *todelete);
void MapData_RemoveAll(MAP* base);

#endif
