// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// PgTweaks.cpp : implementation file

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "PPgTweaks.h"
#	include "otherfunctions.h"
#include "Preferences.h"                    // CPreferences
#	include "xmule.h"
#endif

#include <stdint.h>                         // uint32_t
#include <wx/checkbox.h>
#include <wx/notebook.h>
#include <wx/slider.h>
#include <wx/textctrl.h>
#include <wx/xrc/xmlres.h>

#define GetDlgItem(x,clas) XRCCTRL(*this,#x,clas)
#define IsDlgButtonChecked(x) XRCCTRL(*this,#x,wxCheckBox)->GetValue()
#define CheckDlgButton(x,y) XRCCTRL(*this,#x,wxCheckBox)->SetValue(y)

// CPPgTweaks dialog

//IMPLEMENT_DYNAMIC(CPPgTweaks, CPropertyPage)
IMPLEMENT_DYNAMIC_CLASS(CPPgTweaks, wxPanel)

BEGIN_EVENT_TABLE(CPPgTweaks, wxPanel)
EVT_SCROLL(CPPgTweaks::OnHScroll)
END_EVENT_TABLE()

CPPgTweaks::CPPgTweaks(wxWindow *parent)
: wxPanel(parent, CPPgTweaks::IDD)
{
    wxNotebook *book = (wxNotebook *) parent;
    wxPanel *page1 = _panel = wxXmlResource::Get()->LoadPanel(this, "DLG_PPG_TWEAKS");
    book->AddPage(this, _("Tweaks"));
    //SetSize(wxSize(320,200));
    // looks stupid? it is :)
    SetSize(page1->GetSize() .GetWidth(), page1->GetSize() .GetHeight() + 60);
    page1->SetSize(GetSize());
}

CPPgTweaks::~CPPgTweaks()
{
}

#if 0
void CPPgTweaks::DoDataExchange(CDataExchange *pDX)
{
    CPropertyPage::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CPPgTweaks, CPropertyPage)

ON_EN_CHANGE(IDC_MAXCON5SEC, OnSettingsChange)
ON_BN_CLICKED(IDC_VERBOSE, OnSettingsChange)
ON_BN_CLICKED(IDC_AUTOTAKEED2KLINKS, OnSettingsChange)
ON_BN_CLICKED(IDC_UPDATEQUEUE, OnSettingsChange)
ON_BN_CLICKED(IDC_SHOWRATEONTITLE, OnSettingsChange)
ON_WM_HSCROLL()

END_MESSAGE_MAP()

#endif

// CPPgTweaks message handlers

bool CPPgTweaks::OnInitDialog()
{
#if 0
    CPropertyPage::OnInitDialog();
    LoadSettings();
    Localize();
#endif
    // return TRUE unless you set the focus to a control:
    return TRUE;
    // EXCEPTION: OCX Property Pages should return FALSE
}

void CPPgTweaks::LoadSettings(void)
{
    if (1)
    {
        wxString strBuffer;
        strBuffer.Printf("%d", app_prefs->GetMaxConperFive());
        GetDlgItem(IDC_MAXCON5SEC, wxTextCtrl)->SetValue(strBuffer);
    }
    if (app_prefs->prefs->m_bVerbose)
    CheckDlgButton(IDC_VERBOSE, 1);
    else
    CheckDlgButton(IDC_VERBOSE, 0);
    if (app_prefs->prefs->showRatesInTitle)
    CheckDlgButton(IDC_SHOWRATEONTITLE, 1);
    else
    CheckDlgButton(IDC_SHOWRATEONTITLE, 0);
    if (app_prefs->prefs->m_bupdatequeuelist)
    CheckDlgButton(IDC_UPDATEQUEUE, 1);
    else
    CheckDlgButton(IDC_UPDATEQUEUE, 0);
    // Barry
    if (app_prefs->prefs->autotakeed2klinks)
    CheckDlgButton(IDC_AUTOTAKEED2KLINKS, 1);
    else
    CheckDlgButton(IDC_AUTOTAKEED2KLINKS, 0);
    ((wxSlider *) GetDlgItem(IDC_FILEBUFFERSIZE, wxSlider))->SetRange(1, 100);
    ((wxSlider *) GetDlgItem(IDC_FILEBUFFERSIZE, wxSlider))->SetValue(app_prefs->prefs->m_iFileBufferSize);
    m_iFileBufferSize = app_prefs->prefs->m_iFileBufferSize;
    ((wxSlider *) GetDlgItem(IDC_QUEUESIZE, wxSlider))->SetRange(20, 100);
    ((wxSlider *) GetDlgItem(IDC_QUEUESIZE, wxSlider))->SetValue(app_prefs->prefs->m_iQueueSize);
    m_iQueueSize = app_prefs->prefs->m_iQueueSize;
    // must fake two scroll events.. setvalue won't cause any events
    wxScrollEvent evt1(0, XRCID("IDC_QUEUESIZE"), app_prefs->prefs->m_iQueueSize);
    evt1.SetEventObject(XRCCTRL( *this, "IDC_QUEUESIZE", wxObject));
    OnHScroll(evt1);
    wxScrollEvent evt2(0, XRCID("IDC_FILEBUFFERSIZE"), app_prefs->prefs->m_iFileBufferSize);
    evt2.SetEventObject(XRCCTRL( *this, "IDC_FILEBUFFERSIZE", wxObject));
    OnHScroll(evt2);
}

bool CPPgTweaks::OnApply()
{
    wxString buffer;
    if (GetDlgItem(IDC_MAXCON5SEC, wxTextCtrl)->GetValue() .Length())
    {
        //GetWindowText(buffer,20);:
        buffer = GetDlgItem(IDC_MAXCON5SEC, wxTextCtrl)->GetValue();
        app_prefs->SetMaxConsPerFive((atoi(buffer)) ?
        atoi(buffer): 20);
    }
    if (IsDlgButtonChecked(IDC_VERBOSE))
    app_prefs->prefs->m_bVerbose = true;
    else
    app_prefs->prefs->m_bVerbose = false;
    if (IsDlgButtonChecked(IDC_UPDATEQUEUE))
    app_prefs->prefs->m_bupdatequeuelist = true;
    else
    app_prefs->prefs->m_bupdatequeuelist = false;
    if (IsDlgButtonChecked(IDC_SHOWRATEONTITLE))
    app_prefs->prefs->showRatesInTitle = true;
    else
    app_prefs->prefs->showRatesInTitle = false;
    // Barry
    app_prefs->prefs->autotakeed2klinks = (int8_t) IsDlgButtonChecked(IDC_AUTOTAKEED2KLINKS);
    app_prefs->prefs->m_iFileBufferSize = m_iFileBufferSize;
    app_prefs->prefs->m_iQueueSize = m_iQueueSize;
    //	LoadSettings();
    //SetModified(FALSE);
    //theApp.xmuledlg->serverwnd.ToggleDebugWindow();
    if (!theApp.glob_prefs->ShowRatesOnTitle())
    {
        //sprintf(buffer,"xMule v%s",CURRENT_VERSION_LONG);
        //theApp.xmuledlg->SetWindowText(buffer);
    }
    return TRUE;
}

// UINT nSBCode, UINT nPos, CScrollBar* pScrollBar):
void CPPgTweaks::OnHScroll(wxScrollEvent &evt)
{
    //SetModified(TRUE);
    wxSlider *slider = (wxSlider *) evt.GetEventObject();
    //CSliderCtrl* slider =(CSliderCtrl*)pScrollBar;
    wxString temp;
    if (slider == XRCCTRL( *this, "IDC_FILEBUFFERSIZE", wxSlider))
    {
        //GetDlgItem(IDC_FILEBUFFERSIZE)) {
        m_iFileBufferSize = evt.GetPosition();
        temp.Printf(GetResString(IDS_FILEBUFFERSIZE), m_iFileBufferSize *15000);
        GetDlgItem(IDC_FILEBUFFERSIZE_STATIC, wxControl)->SetLabel(temp);
    }
    else if(slider == XRCCTRL( *this, "IDC_QUEUESIZE", wxSlider))
    {
        //GetDlgItem(IDC_QUEUESIZE)) {
        m_iQueueSize = evt.GetPosition();
        temp.Printf(GetResString(IDS_QUEUESIZE), m_iQueueSize *100);
        GetDlgItem(IDC_QUEUESIZE_STATIC, wxControl)->SetLabel(temp);
    }
}

void CPPgTweaks::Localize(void)
{
    if (1)
    {
        //SetWindowText(GetResString(IDS_PW_TWEAK));
        GetDlgItem(IDC_MAXCON5SECLABEL, wxControl)->SetLabel(GetResString(IDS_MAXCON5SECLABEL));
        GetDlgItem(IDC_WARNING, wxControl)->SetLabel(GetResString(IDS_WARNING));
        GetDlgItem(IDC_UPDATEQUEUE, wxControl)->SetLabel(GetResString(IDS_UPDATEQUEUE));
        GetDlgItem(IDC_AUTOTAKEED2KLINKS, wxControl)->SetLabel(GetResString(IDS_AUTOTAKEED2KLINKS));
        GetDlgItem(IDC_VERBOSE, wxControl)->SetLabel(GetResString(IDS_VERBOSE));
        wxString temp;
        temp.Printf(GetResString(IDS_FILEBUFFERSIZE), m_iFileBufferSize *15000);
        GetDlgItem(IDC_FILEBUFFERSIZE_STATIC, wxControl)->SetLabel(temp);
        temp.Printf(GetResString(IDS_QUEUESIZE), m_iQueueSize *100);
        GetDlgItem(IDC_QUEUESIZE_STATIC, wxControl)->SetLabel(temp);
        GetDlgItem(IDC_SHOWRATEONTITLE, wxControl)->SetLabel(GetResString(IDS_SHOWRATEONTITLE));
    }
}

