// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Client to Server communication

#ifndef SERVERSOCKET_H
#define SERVERSOCKET_H

#include "EMSocket.h"                       // CEMSocket - audited 5 Nov 2004

#include <stdint.h>                         // uint32_t

class CPreferences;
class CServer;
class Packet;
class wxEvtHandler;

#ifndef ID_SOKETTI
#define ID_SOKETTI 7772
#endif

class CServerSocket : public CEMSocket
{
  DECLARE_DYNAMIC_CLASS(CServerSocket)
    friend class CServerConnect;

    CServerSocket() {};
public:
	CServerSocket(CServerConnect* in_serverconnect);
	~CServerSocket();

	void	ConnectToServer(CServer* server);
	int8_t	GetConnectionState()	{return connectionstate;} 
    wxString info;

 public:
	void	OnConnect(int nErrorCode);
	void	OnLost(int nErrorCode);
	void	OnInput(int nErrorCode);
	void	OnClose(int nErrorCode);
	void	PacketReceived(Packet* packet);

private:
	bool	ProcessPacket(char* packet, int32_t size,int8_t opcode);
	void	SetConnectionState(int8_t newstate);
	CServerConnect*	serverconnect; 
	int8_t	connectionstate;
	CServer*	cur_server;
	bool	headercomplete;
	int32_t	sizetoget;
	int32_t	sizereceived;
	char*	rbuffer;
	bool	m_bIsDeleting;//true: socket is already in deletion phase, don't destroy it in ::StopConnectionTry
    wxEvtHandler* m_event_handler;
};

#endif
