// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef _SHAREDFILESLIST_H
#define _SHAREDFILESLIST_H

#include "MapKey.h"                         // Needed for CCKey - audited 5 Nov 2004
#include "mfc.h"                            // Needed for CTypedPtrList - audited 4 Nov 2004

#include <map>                              // Needed for std::map
#include <stdint.h>                         // Needed for uint32_t
#include <wx/thread.h>                      // Needed for wxMutex

class CAddFileThread;
class CKnownFile;
class CKnownFileList;
class CMemFile;
class CPreferences;
class CServerConnect;
struct UnknownFile_Struct;

typedef std::map<CCKey, CKnownFile*> CKnownFileMap;

class CSharedFileList
{
    friend class CSharedFilesCtrl;
    friend class CClientReqSocket;
public:
    CSharedFileList(CPreferences* in_prefs, CServerConnect* in_server, CKnownFileList* in_filelist);
    ~CSharedFileList();
    void SendListToServer();
    void Reload(bool sendtoserver = true, bool firstload = false);
    void SafeAddKFile(CKnownFile* toadd, bool bOnlyAdd = false);
    void SetOutputCtrl(CSharedFilesCtrl* in_ctrl);
    void RemoveFile(CKnownFile* toremove);
    wxMutex list_mut;
    CKnownFile* GetFileByID(unsigned char* filehash);
    short GetFilePriorityByID(unsigned char* filehash);
    CKnownFile* GetFileByIndex(int index);
    CKnownFileList* filelist;
    void CreateOfferedFilePacket(CKnownFile* cur_file,CMemFile* files);
    uint64_t GetDatasize();

    uint16_t GetCount()
    {
        return m_Files_map.size();
    }

    void UpdateItem(CKnownFile* toupdate);
    void AddFilesFromDirectory(const wxString& directory);
    void GetSharedFilesByDirectory(const char *directory, CTypedPtrList<CPtrList, CKnownFile*>& list);

private:
    void FindSharedFiles();

    CKnownFileMap m_Files_map;
    CPreferences* app_prefs;
    CServerConnect* server;
    CSharedFilesCtrl* output;
    CAddFileThread* m_Thread;
};

#endif
