// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// XBMDraw.h: interface for the XBMDraw class.

#if !defined(AFX_XBMDRAW_H__79B4E994_2752_4A68_A15E_29B04736D719__INCLUDED_)
#define AFX_XBMDRAW_H__79B4E994_2752_4A68_A15E_29B04736D719__INCLUDED_

#include "mfc.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class XBMDraw  
{
public:
	bool Line(int x1, int y1, int x2, int y2, bool bXOR = false);
	wxString GetImageTag();
	bool Plot(int x, int y, bool bXOR = false);
	bool GetImage(wxString &sImage);
	bool CreateImage(wxString sName, int nWidth, int nHeight, BYTE bBackground = 0x00);
	XBMDraw();
	virtual ~XBMDraw();
private:
	wxString	m_sName;
	int		m_nWidth;
	int		m_nHeight;
	BYTE*	m_pImage;
};

#endif // !defined(AFX_XBMDRAW_H__79B4E994_2752_4A68_A15E_29B04736D719__INCLUDED_)
