// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef SERVER_H
#define SERVER_H

#include <stdint.h>                         // uint32_t
#include <wx/list.h>                        // WX_DECLARE_LIST
#include <wx/treectrl.h>                    // wxTreeCtrl wxTreeItemId

class CSafeFile;
class CTag;
class ServerMet_Struct;

WX_DECLARE_LIST(CTag,TagList);

#define		SRV_TCPFLG_COMPRESSION			0x00000001

#define		SRV_UDPFLG_EXT_GETSOURCES		0x00000001
#define		SRV_UDPFLG_EXT_GETFILES			0x00000002

class CServer{
public:
	CServer(ServerMet_Struct* in_data);
	CServer(uint16_t in_port, char* i_addr);
	CServer(CServer* pOld);
	~CServer();
	void	AddTag(CTag* in_tag)			{taglist->Append(in_tag);}
	char*	GetListName()					{return listname;}
	char*	GetFullIP()						{return ipfull;}
	char*	GetAddress();
	uint16_t	GetPort()						{return port;}
	void	FillWindowTags(wxTreeCtrl* wnd,wxTreeItemId rootitem);
	bool	AddTagFromFile(CSafeFile* servermet);
	void	SetListName(char* newname);
	void	SetDescription(char* newdescription);
	uint32_t	GetIP()			{return ip;}
	uint32_t	GetFiles()						{return files;} 
	uint32_t	GetUsers()						{return users;} 
	char*	GetDescription()				{return description;} 
	uint32_t	GetPing()						{return ping;} 
	uint32_t	GetPreferences()				{return preferences;} 
	uint32_t	GetMaxUsers()					{return maxusers;}
	void	SetMaxUsers(uint32_t in_maxusers) {maxusers = in_maxusers;}
	void	SetUserCount(uint32_t in_users)	{users = in_users;}
	void	SetFileCount(uint32_t in_files)	{files = in_files;}
	void	ResetFailedCount()				{failedcount = 0;} 
	void	AddFailedCount()				{failedcount++;} 
	uint32_t	GetFailedCount()				{return failedcount;} 
	void	SetID(uint32_t newip);
	char*	GetDynIP()						{return dynip;}
	bool	HasDynIP()						{return dynip;}
	void	SetDynIP(char* newdynip);
	uint32_t	GetLastPinged()					{return lastpinged;}
	void	SetLastPinged(uint32_t in_lastpinged)	{lastpinged = in_lastpinged;}
	void	SetPing(uint32_t in_ping)					{ping = in_ping;}
	void	SetPreference(uint32_t in_preferences)	{preferences = in_preferences;}
	void	SetIsStaticMember(bool in)				{staticservermember=in;}
	bool	IsStaticMember()						{return staticservermember;}
	uint32_t	GetChallenge()							{return challenge;}
	void	SetChallenge(uint32_t in_challenge)		{challenge = in_challenge;}
	uint32_t	GetSoftFiles()						{return softfiles;}
	void	SetSoftFiles(uint32_t in_softfiles)			{softfiles = in_softfiles;}
	uint32_t	GetHardFiles()						{return hardfiles;}
	void	SetHardFiles(uint32_t in_hardfiles)			{hardfiles = in_hardfiles;}
	const	wxString GetVersion() const				{return m_strVersion;}
	void	SetVersion(unsigned char* pszVersion)				{m_strVersion = pszVersion;}
	void	SetTCPFlags(uint32_t uFlags)				{m_uTCPFlags = uFlags;}
	uint32_t	GetTCPFlags() const					{return m_uTCPFlags;}
	void	SetUDPFlags(uint32_t uFlags)				{m_uUDPFlags = uFlags;}
	uint32_t	GetUDPFlags() const					{return m_uUDPFlags;}

private:
	uint32_t		challenge;
	uint32_t		lastpinged;
	uint32_t		files;
	uint32_t		users;
	uint32_t		maxusers;
	uint32_t		preferences;
	uint32_t		ping;
	char*		description;
	char*		listname;
	char*		dynip;
	uint32_t		tagcount;
	char		ipfull[17];
	uint32_t		ip;
	uint16_t		port;
	uint32_t		failedcount; 
	TagList* taglist;
	//CTypedPtrList<CPtrList, CTag*>*	taglist;
	uint8_t		staticservermember;
	uint32_t		softfiles;
	uint32_t		hardfiles;
	wxString		m_strVersion;
	uint32_t		m_uTCPFlags;
	uint32_t		m_uUDPFlags;
};

#endif
