// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "AddFriend.h"                      // Needed for Module's Prototype(s) - audited 4 Nov 2004

#include "FriendList.h"                     // Needed for CFriendList - audited 5 Nov 2004
#include "muuli_wdr.h"                      // Needed for addFriendDlg ID_ADDFRIEND ID_CLOSEDLG ID_IPADDRESS ID_IPORT ID_USERNAME - audited 4 Nov 2004
#include "otherfunctions.h"                 // Needed for GetResString - audited 5 Nov 2004
#include "xmule.h"                          // Needed for theApp - audited 4 Nov 2004

#include <wx/msgdlg.h>                      // Needed for wxMessageBox
#include <wx/intl.h>                        // Needed for _
#include <wx/sizer.h>                       // Needed for wxSizer
#include <wx/textctrl.h>                    // Needed for wxTextCtrl

IMPLEMENT_DYNAMIC_CLASS(CAddFriend, wxDialog)

CAddFriend::CAddFriend(wxWindow *parent): wxDialog(parent, 9995, _("Add a Friend"), wxDefaultPosition, wxDefaultSize,
wxDEFAULT_DIALOG_STYLE |wxSYSTEM_MENU)
{
    addFriendDlg(this, TRUE)->Show(this, TRUE);
    OnInitDialog();
}

CAddFriend::~CAddFriend()
{
}

bool CAddFriend::OnInitDialog()
{
    //CDialog::OnInitDialog();
    Localize();
    return true;
}

#if 0
BEGIN_MESSAGE_MAP(CAddFriend, CDialog)
ON_BN_CLICKED(IDC_ADD, OnAddBtn)
END_MESSAGE_MAP()
#endif

BEGIN_EVENT_TABLE(CAddFriend, wxDialog)
EVT_BUTTON(ID_ADDFRIEND, CAddFriend::OnAddBtn)
EVT_BUTTON(ID_CLOSEDLG, CAddFriend::OnCloseBtn)
END_EVENT_TABLE()

// CAddFriend message handlers
void CAddFriend::Localize()
{
#if 0
    SetWindowText(GetResString(IDS_ADDAFRIEND));
    GetDlgItem(IDC_INFO1)->SetWindowText(GetResString(IDS_PAF_REQINFO));
    GetDlgItem(IDC_INFO2)->SetWindowText(GetResString(IDS_PAF_MOREINFO));
    GetDlgItem(IDC_ADD)->SetWindowText(GetResString(IDS_ADD));
    GetDlgItem(IDCANCEL)->SetWindowText(GetResString(IDS_CANCEL));
    GetDlgItem(IDC_STATIC31)->SetWindowText(GetResString(IDS_CD_UNAME));
    GetDlgItem(IDC_STATIC32)->SetWindowText(GetResString(IDS_CD_UHASH));
    GetDlgItem(IDC_STATIC34)->SetWindowText(GetResString(IDS_CD_UIP));
    GetDlgItem(IDC_STATIC35)->SetWindowText(GetResString(IDS_PORT) + ":");
#endif
}

#define GetDlgItem(a,b) wxStaticCast(FindWindowById((a)),b)

void CAddFriend::OnAddBtn(wxCommandEvent &evt)
{
    wxString name, userhash, fullip;
    uint32_t ip;
    long port;
    ip = port = 0;
    if (GetDlgItem(ID_USERNAME, wxTextCtrl)->GetValue() .Length())
    {
        //GetDlgItem(IDC_USERNAME)->GetWindowText(buffer,255);
        name = GetDlgItem(ID_USERNAME, wxTextCtrl)->GetValue();
    }
    if (GetDlgItem(ID_IPADDRESS, wxTextCtrl)->GetValue() .Length())
    {
        //GetDlgItem(IDC_IP)->GetWindowText(buffer,20);
        fullip = GetDlgItem(ID_IPADDRESS, wxTextCtrl)->GetValue();
    }
    else
    {
        //MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
        wxMessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
        return;
    }
    if (GetDlgItem(ID_IPORT, wxTextCtrl)->GetValue() .Length())
    {
        //GetDlgItem(IDC_PORT)->GetWindowText(buffer,20);
        wxString buff = GetDlgItem(ID_IPORT, wxTextCtrl)->GetValue();
        buff.ToLong(&port);
    }
    else
    {
        //MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
        wxMessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
        return;
    }
#if 0
    int counter = 0;
    wxString temp;
    for (int i = 0 ; i < 4 ; i++)
    {
        fullip.Tokenize(".", counter);
        if (counter == - 1)
        {
            //MessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
            wxMessageBox(GetResString(IDS_ERR_NOVALIDFRIENDINFO));
            return;
        }
    }
    counter = 0;
    for (int i = 0 ; i < 4 ; i++)
    {
        temp = fullip.Tokenize(".", counter);
        ip |= atoi(temp) << (8 *i);
    }
#endif
    int a, b, c, d;
    a = b = c = d = 0;
    sscanf(fullip.c_str(), "%d.%d.%d.%d", &a, &b, &c, &d);
    ip = a | (b << 8) | (c << 16) | (d << 24);
    theApp.friendlist->AddFriend(NULL, 0, ip, port, 0, name, 0);
    //OnCloseBtn(evt);
    EndModal(1);
    //OnCancel();
}

void CAddFriend::OnCloseBtn(wxCommandEvent &evt)
{
    EndModal(0);
}

