// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// ColorFrameCtrl.h : header file
//

#ifndef __ColorFrameCtrl_H__
#define __ColorFrameCtrl_H__

#include "wintypes.h"                       // x::COLORREF - audited 4 Nov 2004

#include <wx/brush.h>
#ifndef RGB
#define RGB(a,b,c) ((a&0xff)<<16|(b&0xff)<<8|(c&0xff))
#endif

#include <wx/control.h>

class CColorFrameCtrl : public wxControl
{
public:
    CColorFrameCtrl( wxWindow* parent, int id,int wid,int hei );

public:
    void SetFrameColor(x::COLORREF color);
    void SetBackgroundColor(x::COLORREF color);

// Implementation
public:
    x::COLORREF m_crBackColor;        // background color
    x::COLORREF m_crFrameColor;       // frame color

    virtual ~CColorFrameCtrl();

    // Generated message map functions
protected:
    void OnPaint(wxPaintEvent& evt);
    void OnSize(wxSizeEvent& evt);
    DECLARE_EVENT_TABLE()

    wxBrush m_brushBack,m_brushFrame;
};

#endif
