// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef MULELISTCTRL_H
#define MULELISTCTRL_H

#include "resource.h"                       // Needed for IDB_DOWN
#include <wx/event.h>                       // Needed for DECLARE_DYNAMIC_CLASS
#include "listctrl.h"                       // Needed for wxODListCtrl
#include "wintypes.h"                       // Needed for bool

class CMuleListCtrl : public wxODListCtrl
{
  DECLARE_DYNAMIC_CLASS(CMuleListCtrl)

public:
	CMuleListCtrl();
	CMuleListCtrl(wxWindow*& parent,int id,const wxPoint& pos,wxSize siz,int flags);
	virtual ~CMuleListCtrl();

	// Sets the list name, used for hide/show menu
	void SetNamxMule(x::LPCTSTR lpszName);

	// Forces the control to repaint a specific item.
	bool Update(int nItem);

	// Hide the column
	void HideColumn(int iColumn);

	// Unhide the column
	void ShowColumn(int iColumn);

	// check to see if the column is hidden
	bool IsColumnHidden(int iColumn) const {
		if(iColumn < 1 || iColumn >= m_iColumnsTracked)
			return false;

		return m_aColumns[iColumn].bHidden;
	}

	// Get the correct column width even if column is hidden
	int GetColumnWidth(int iColumn) const {
		if(iColumn < 0 || iColumn >= m_iColumnsTracked)
			return 0;
		
		if(m_aColumns[iColumn].bHidden)
			return m_aColumns[iColumn].iWidth;
		else
			return wxODListCtrl::GetColumnWidth(iColumn);
	}

	//save to preferences
	void SaveSettings(const short int tID);

	//load from preferences
	void LoadSettings(const short int tID);

	enum ArrowType { arrowDown = IDB_DOWN, arrowUp = IDB_UP,
		arrowDoubleDown = IDB_DOWN2X, arrowDoubleUp = IDB_UP2X };
	DECLARE_EVENT_TABLE()
protected:
	virtual bool ProcessEvent(wxEvent& evt);
	virtual void PreSubclassWindow();

    void         SetColors();
	void         SetSortArrow(int iColumn, ArrowType atType);
	void         SetSortArrow(int iColumn, bool bAscending) {
		SetSortArrow(iColumn, bAscending ? arrowUp : arrowDown);
	}

	wxString          m_Name;
	wxMenu *m_ColumnMenu;
	bool             m_bCustomDraw;
	x::COLORREF         m_crWindow;
	x::COLORREF         m_crWindowText;
	x::COLORREF         m_crHighlight;
	x::COLORREF         m_crFocusLine;
	x::COLORREF         m_crNoHighlight;
	x::COLORREF         m_crNoFocusLine;
	void OnColumnRclick(wxListEvent& evt);
private:
	//static int IndexToOrder(CHeaderCtrl* pHeader, int iIndex);

	struct MULE_COLUMN {
		int iWidth;
		int iLocation;
		bool bHidden;
	};

	int          m_iColumnsTracked;
	MULE_COLUMN *m_aColumns;

	int GetHiddenColumnCount() const {
		int iHidden = 0;
		for(int i = 0; i < m_iColumnsTracked; i++)
			if(m_aColumns[i].bHidden)
				iHidden++;
		return iHidden;
	}

	int       m_iCurrentSortItem;
	ArrowType m_atSortArrow;

	int m_col_minsize;
};
#endif
