// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef __MULENOTEBOOKH__
#define __MULENOTEBOOKH__

#include <wx/notebook.h>                    // Needed for wxNotebook

class CMuleNotebook : public wxNotebook {
public:
    CMuleNotebook();
    CMuleNotebook(wxWindow* parent, wxWindowID id, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize, long style = 0, const wxString& name = "notebook");
    void OnRightClick(wxMouseEvent& event);
    DECLARE_DYNAMIC_CLASS(CMuleNotebook)

    void SetMouseListener(wxEvtHandler* listener)
    {
        m_listener = listener;
    }

    wxEvtHandler* GetMouseListener() const
    {
        return m_listener;
    }

private:
    DECLARE_EVENT_TABLE()
    wxEvtHandler* m_listener;
    wxWindow* m_parent;
};

#endif
