// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _UDPSOCKET_H
#define _UDPSOCKET_H

#include "packets.h"
#include "server.h"

#include <arpa/inet.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <wx/socket.h>

#define WM_DNSLOOKUPDONE WM_USER+280
// Client to Server communication
class CServerConnect;
class wxEvtHandler;

class CUDPSocket : public wxDatagramSocket //CAsyncSocket
{
	friend class CServerConnect;
	DECLARE_DYNAMIC_CLASS(CUDPSocket);

	CUDPSocket():wxDatagramSocket(useless) {};
public:
	CUDPSocket(CServerConnect* in_serverconnect,wxIPV4address& addr);
	~CUDPSocket();
	//bool	Create();
	void	SendPacket(Packet* packet,CServer* host);
	void DnsLookupDone(struct sockaddr_in* addr);
	//void	DnsLookupDone(WPARAM wp, LPARAM lp);
protected:
	void	AsyncResolveDNS(x::LPCTSTR lpszHostAddress, x::UINT nHostPort);
	//HANDLE	DnsTaskHandle;					// dns lookup handle
	
 public:
	virtual void OnReceive(int nErrorCode);
private:
	x::LPCTSTR m_lpszHostAddress;
	x::UINT m_nHostPort;
	//HWND m_hWndResolveMessage;	// where to send WM_DNSRESOLVED
	//SOCKADDR_IN m_SaveAddr;
	struct sockaddr_in m_SaveAddr;
	//CUDPSocketWnd m_udpwnd;

	void SendBuffer();
	void SendBuffer_NEW(wxUint32 hostip,wxUint16 port);
	bool	ProcessPacket(unsigned char* packet, wxUint16 size, wxUint8 opcode, wxUint32 hostip, wxUint16 port);
	bool	ProcessExtPacket(unsigned char* packet, wxUint16 size, wxUint8 opcode, wxUint32 hostip, wxUint16 port);
	CServerConnect*	serverconnect;
	char*	sendbuffer;
	uint32_t	sendblen;
	CServer* cur_server;
	char	DnsHostBuffer[1024]; //MAXGETHOSTSTRUCT];	// dns lookup structure
	wxIPV4address useless;
    wxEvtHandler* m_event_handler;
};

#endif
