// This file is a part of the xMule Project.
//
// Copyright (c) 2004, 2005 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef LDAEMON_H
#define LDAEMON_H

#include <wx/file.h>                        // Needed for wxFile
#include <wx/string.h>                      // Needed for wxString

#define LD_NUMBER 6
#define LD_COMMAND 0
#define LD_STATUS 1
#define LD_OUTPUT 2
#define LD_SERVER 3
#define LD_DOWN 4
#define LD_UPLO 5


class CLDaemon
{
public:
    CLDaemon();
    virtual ~CLDaemon();
    void Init();
    void Print (wxString,int,bool=false);
    bool Read (wxString &,int);
    bool ReadCommand ();
    bool Delete (int);

    wxString Command;
private:
    wxString FName[LD_NUMBER];
    wxFile Ftmp;
};

#endif
