/*
  This file is part of xMule
  Copyright (C) 2002 Madcat ( madcat@xmule.org / http://www.xmule.org )

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void AddLink(char *ed2klink)
{
FILE *ed2kfile;
char filename[100];
	
	// First do some checking wether the link is correct.	
	if ((ed2klink[strlen(ed2klink)-35] != '|') && (ed2klink[strlen(ed2klink)-34] != '|')) {
		printf("Invalid ED2K link.\nReason: Character before hash (34/35 chars before end) must be |\n");
		return;
	}
	if ((ed2klink[strlen(ed2klink)-45] != '|') && (ed2klink[strlen(ed2klink)-44] != '|')) {
		printf("Invalid ED2K link.\nReason: Character before numbers before hash (44/45 chars before end) must be |\n");
		return;
	}

	// Link seemed ok, add it to file.
	sprintf(filename,"%s/.xMule/ED2KLinks",getenv("HOME"));
	ed2kfile = fopen(filename,"a");
	if (ed2kfile != NULL) {
		fprintf(ed2kfile,"%s\n",ed2klink);
		printf("Successfully wrote ED2K link to file.\n");
		fclose(ed2kfile);
	} else {
		printf("Error opening file %s.\n", filename);
	}
}

int main(int argc, char *argv[])
{
	for (int i=1;i<argc;i++) {
		if (!strncmp(argv[i], "ed2k://|file|", 13) && (strlen(argv[i])>55)) {
			AddLink(argv[i]);
		} else if (!strncmp(argv[i], "--version", 9)) {
			printf("xMule ED2K links parser v1.0\n");
		} else {
			if (strncmp(argv[i], "ed2k://|file|", 13)) {
				printf("Invalid ED2K link.\nReason: First 13 characters don't match 'ed2k://|file|'\n");
			}
			if (strlen(argv[i])<=55) {
				printf("Invalid ED2K Link.\nReason: Link length is below 55 characters.\n");
			}
		}
	}
}
