//this file is part of xMule
//Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include "wintypes.h"
#include "xmule.h"
#include "ListenSocket.h"
#include "opcodes.h"
#include "KnownFile.h"
#include "SharedFileList.h"
#include "UploadQueue.h"
#include "updownclient.h"
#include "ClientList.h"
#include "Friend.h"
#include "otherfunctions.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <wx/hashmap.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// some client testing variables
static wxString crash_name   = "[Invalid User Name]"; 
static wxString empty_name = "[Empty User Name]";


// prevent fscking dns queries
class xmuleIPV4Address : public wxIPV4address {
public:
  xmuleIPV4Address() : wxIPV4address() {};
  virtual bool Hostname(unsigned long addr) {
    return GAddress_INET_SetHostAddress(m_address,addr)==GSOCK_NOERROR;
  };
  virtual bool Hostname(char* addr) {
    struct in_addr inaddr;
    inet_aton(addr,&inaddr);
    return GAddress_INET_SetHostAddress(m_address,inaddr.s_addr)==GSOCK_NOERROR;
  }
};

//	members of CUpDownClient
//	which are used by down and uploading functions 

CUpDownClient::CUpDownClient(CClientReqSocket* sender){
	socket = sender;
	reqfile = 0;
	Init();
}

CUpDownClient::CUpDownClient(uint16 in_port, uint32 in_userid,uint32 in_serverip, uint16 in_serverport,CPartFile* in_reqfile){
	socket = 0;
	Init();
	m_nUserID = in_userid;
	m_nUserPort = in_port;
	sourcesslot=m_nUserID%SOURCESSLOTS;
	if (!HasLowID())
		sprintf(m_szFullUserIP,"%i.%i.%i.%i",(uint8)m_nUserID,(uint8)(m_nUserID>>8),(uint8)(m_nUserID>>16),(uint8)(m_nUserID>>24));
	m_dwServerIP = in_serverip;
	m_nServerPort = in_serverport;
	reqfile = in_reqfile;
	ReGetClientSoft();
}

void CUpDownClient::Init(){
	memset(m_szFullUserIP,0,21);
	credits = 0;
	memset(requpfileid, 0, sizeof requpfileid);
	m_nAvDownDatarate = 0;
	m_nAvUpDatarate = 0;
	m_byChatstate = 0;
	m_cShowDR = 0;
	m_nUDPPort = 0;
	m_cFailed = 0;
	m_dwBanTime = 0;
	m_nMaxSendAllowed = 0;
	m_nTransferedUp = 0;
	m_cSendblock = 0;
	m_cAsked = 0;
	m_cDownAsked = 0;
	dataratems = 0;
	m_nUpDatarate = 0;
	m_pszUsername = 0;
	m_dwUserIP = 0;
	m_nUserID = 0;
	m_nServerPort = 0;
	m_bBanned = false;
	m_iFileListRequested = 0;
	m_dwLastUpRequest = 0;
	m_bEmuleProtocol = false;
	usedcompressiondown = false;
	m_bUsedComprUp = false;
	m_bCompleteSource = false;
	m_bFriendSlot = false;
	m_bCommentDirty = false;
	m_bReaskPending = false;
	m_bUDPPending = false;
	m_byEmuleVersion = 0;
	m_nUserPort = 0;
	m_nPartCount = 0;
	m_nUpPartCount = 0;
	m_abyPartStatus = 0;
	m_abyUpPartStatus = 0;
	m_dwLastAskedTime = 0;
	m_nDownloadState = DS_NONE;
	m_pszClientFilename = 0;
	m_dwUploadTime = 0;
	m_nTransferedDown = 0;
	m_nDownDatarate = 0;
	m_nDownDataRateMS = 0;
	m_byUploadState = US_NONE;
	m_dwLastBlockReceived = 0;
	m_byEmuleVersion = 0;
	m_byDataCompVer = 0;
	m_byUDPVer = 0;
	m_bySourceExchangeVer = 0;
	m_byAcceptCommentVer = 0;
	m_byExtendedRequestsVer = 0;
	m_nRemoteQueueRank = 0;
	m_dwLastSourceRequest = 0;
	m_dwLastSourceAnswer = 0;
	m_byCompatableClient = 0;
	m_bIsHybrid = false;
	m_bIsNewMLD = false;
	m_Friend = NULL;
	m_iRate=0;
	m_strComment="";
	m_nCurSessionUp = 0;
	m_nSumForAvgDownDataRate = 0;
	m_nSumForAvgUpDataRate = 0;
	m_clientSoft=SO_UNKNOWN;
	m_nClientVersion=0;
	m_bRemoteQueueFull = false;
	memset( m_achUserHash, 0, 16);
	SetWaitStartTime();
	if (socket){
		struct sockaddr_in sockAddr;
		memset(&sockAddr, 0, sizeof(sockAddr));
		uint32 nSockAddrLen = sizeof(sockAddr);
		wxIPV4address address;
		socket->GetPeer(address);
		//socket->GetPeerName((SOCKADDR*)&sockAddr,(int*)&nSockAddrLen);
		sockAddr.sin_addr.s_addr=GAddress_INET_GetHostAddress(address.GetAddress());
		m_dwUserIP = sockAddr.sin_addr.s_addr;
		strcpy(m_szFullUserIP,inet_ntoa(sockAddr.sin_addr));
	}
	sourcesslot=0;
	m_bHashsetRequested=false;
	// At the beginning, client is't a thief :)
	leechertype = 0;
	thief = false;
}

CUpDownClient::~CUpDownClient(){
  /* Razor 1a - Modif by MikaelB */
	if(reqfile != NULL){
		reqfile->RemoveDownloadingSource(this);
	}
  /* End modif */

	theApp.clientlist->RemoveClient(this);
	if (m_Friend){
		m_Friend->m_LinkedClient = NULL;
		theApp.friendlist->RefreshFriend(m_Friend);
		m_Friend = NULL;
	}
	if (m_pszClientFilename)
		delete[] m_pszClientFilename;
	if (socket){
		socket->client = 0;
		socket->Safe_Delete();
	}
	if (m_pszUsername)
		delete[] m_pszUsername;
	if (m_abyPartStatus)
		delete[] m_abyPartStatus;
	if (m_abyUpPartStatus)
		delete[] m_abyUpPartStatus;
	
	ClearUploadBlockRequests();

	for (POSITION pos = m_DownloadBlocks_list.GetHeadPosition();pos != 0;m_DownloadBlocks_list.GetNext(pos))
		delete m_DownloadBlocks_list.GetAt(pos);
	m_DownloadBlocks_list.RemoveAll();
	for (POSITION pos = m_RequestedFiles_list.GetHeadPosition();pos != 0;m_RequestedFiles_list.GetNext(pos))
		delete m_RequestedFiles_list.GetAt(pos);
	m_RequestedFiles_list.RemoveAll();
	for (POSITION pos = m_PendingBlocks_list.GetHeadPosition();pos != 0;m_PendingBlocks_list.GetNext(pos)){
		Pending_Block_Struct *pending = m_PendingBlocks_list.GetAt(pos);
		delete pending->block;
		// Not always allocated
		if (pending->zStream) {
		  inflateEnd(pending->zStream);
		  delete pending->zStream;
		}
		delete pending;
	}

	if (m_iRate>0 || m_strComment.GetLength()>0) {
		m_iRate=0; m_strComment="";
		reqfile->UpdateFileRatingCommentAvail();
	}


	m_PendingBlocks_list.RemoveAll();
	m_AvarageUDR_list.RemoveAll();
	m_AvarageDDR_list.RemoveAll();
	//DEBUG_ONLY (theApp.listensocket->Debug_ClientDeleted(this));
	SetUploadFileID(NULL);
}

void CUpDownClient::ProcessHelloPacket(char* pachPacket, uint32 nSize){
	CSafeMemFile data((BYTE*)pachPacket,nSize);
	uint8 hashsize;
	if ( (1!=data.Read(&hashsize,1)) )
		throw CString("Invalid Hello packet: Short packet when reading hash size");
	if ( 16 != hashsize ) {
		/*
		 * Hint: We can not accept other sizes here because:
		 *       - the magic number is spread all over the source
		 *       - the answer packet lacks the size field
		 */
		throw CString("Invalid Hello packet: Other userhash sizes than 16 are not implemented");
	}

	ProcessHelloTypePacket(&data);
}

void CUpDownClient::ProcessHelloAnswer(char* pachPacket, uint32 nSize){
	CSafeMemFile data((BYTE*)pachPacket,nSize);
	ProcessHelloTypePacket(&data);
}

void CUpDownClient::ProcessHelloTypePacket(CSafeMemFile* data){
	try {
#ifdef __DEBUG__
		bool bDumpClientInfo = false;	// Setted if unusual happens
#endif

		if ( 16 != data->Read(&m_achUserHash,16) )
			throw CInvalidPacket("short packet reading user hash");
	uint32 nUserID;
		if ( 4 != data->Read(&nUserID,4) )
			throw CInvalidPacket("short packet reading user id");
	if (!m_nUserID || nUserID < 16777216)
		m_nUserID = nUserID;
		if ( 2 != data->Read(&m_nUserPort,2) ) // hmm clientport is sent twice - why?
			throw CInvalidPacket("short packet reading user port");
	uint32	tagcount;
		if ( 4 != data->Read(&tagcount,4) )
			throw CInvalidPacket("short packet reading tag count");

#ifdef __DEBUG__
		if ( tagcount > 7 )
			printf("Huh, unusual tagcount %lu in Hello packet\n", (unsigned long)tagcount);
#endif

		// TODO: Check if we get everything needed!

	/* It seems that various Mules and Donkeys send tagcount 2, Old MLDonkey sends
		tagcount 3, new mldonkeys 4. There are also some clients
		sending tagcount 5 and 7, what are those? */
		for (uint32 i = 0;i < tagcount; i++){
			CTag* temptag = new CTag(data);
			if ( temptag->tag->tagname && !strcmp(temptag->tag->tagname, "pr") ) {
				// EDonkey hybrid does send integer 1
			} else switch(temptag->tag->specialtag){
				case CT_NAME:
				{
					if ( temptag->GetType() != TAG_STRING )
						throw CInvalidPacket("invalid data type for username");

					// Verifying username for determining a thief
					wxString oldusername;
					bool bOldUser = false;
					if (m_pszUsername)
                	{
               	    	bOldUser = true;
				    	oldusername.Format("%s",m_pszUsername);					
						delete[] m_pszUsername;
						m_pszUsername = NULL; 
					}
                	m_pszUsername = NULL;
					m_pszUsername = temptag->tag->stringvalue ? nstrdup(temptag->tag->stringvalue) : nstrdup(crash_name);
				
                	if(strcmp(m_pszUsername, "")==0)
					{
						delete[] m_pszUsername;
						m_pszUsername = NULL;
						m_pszUsername=nstrdup(empty_name);
					}
					// If username has changed
					if ((bOldUser && (oldusername.CmpNoCase(m_pszUsername)!=0))
						&& !thief)
                	{
				    	uint64 id = getUID();
						uint32 dummy;
						leechertype=0;		
						if(theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end())
							theApp.listensocket->offensecounter[id]++;
						else 
							theApp.listensocket->offensecounter[id] = (uint32) 1;
						theApp.listensocket->offensecounter[0]++;
		 		 	}				
                }
				break;
				/*	if (m_pszUsername)
						delete[] m_pszUsername;
					m_pszUsername = nstrdup(temptag->tag->stringvalue);
					break;  */
				case CT_VERSION:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for version");

					m_nClientVersion = temptag->tag->intvalue;
					break;
				case CT_PORT:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for port number");

					m_nUserPort = temptag->tag->intvalue;
					break;

				case CT_FRIENDSHARING:
					// ignore this one
					break;

#ifdef __DEBUG__
				default:
					printf("Unknown tag %u in HelloAnswer\n", (unsigned int)temptag->tag->specialtag);
					temptag->DumpToStdout();
					bDumpClientInfo = true;
					break;
#endif
			}
			delete temptag;
		}

		// Make up a username if we get none
		if ( !m_pszUsername ) {
			m_pszUsername = nstrdup(empty_name);
		}

		if ( 4 != data->Read(&m_dwServerIP,4) )
			throw CInvalidPacket("short packet reading server IP");
		if ( 2 != data->Read(&m_nServerPort,2) )
			throw CInvalidPacket("short packet reading server port");
	// Hybrid now has an extra uint32.. What is it for?
	// Also, many clients seem to send an extra 6? These are not eDonkeys or Hybrids..
	if ( data->GetLength() - data->GetPosition() == 4 ){
		uint32 test;
		data->Read(&test,4);
		if (test==1262767181) 
		   m_bIsNewMLD = true;
	        else
		   m_bIsHybrid = true;
//		if( m_nClientVersion > 10000 && m_nClientVersion < 100000 )
//			m_nClientVersion = m_nClientVersion - (m_nClientVersion/10000)*10000;
//		if( m_nClientVersion > 1000 )
//			m_nClientVersion = m_nClientVersion - (m_nClientVersion/1000)*1000;
//		if( m_nClientVersion < 100 )
//			m_nClientVersion *= 10;
	}

#ifdef __DEBUG__
		if ( data->GetLength() != data->GetPosition() )
		{
			long extra = data->GetLength() - data->GetPosition();
			printf("Additional data in hello packet: %ld bytes\n", extra);
			if ( extra > 0 )
			{
				char *tmpbuffer = new char[extra];
				extra = data->Read(tmpbuffer, extra);
				HexDump(tmpbuffer, extra);
				delete[] tmpbuffer;
				bDumpClientInfo = true;
			}
		}
#endif

	// tecxx 1609 2002 - add client's servet to serverlist (Moved to uploadqueue.cpp)

	if (socket) {
		struct sockaddr_in sockAddr;
		memset(&sockAddr, 0, sizeof(sockAddr));
		uint32 nSockAddrLen = sizeof(sockAddr);
		wxIPV4address address;
		socket->GetPeer(address);
		sockAddr.sin_addr.s_addr=GAddress_INET_GetHostAddress(address.GetAddress());
		//socket->GetPeerName((SOCKADDR*)&sockAddr,(int*)&nSockAddrLen);
		m_dwUserIP = sockAddr.sin_addr.s_addr;
		strcpy(m_szFullUserIP,inet_ntoa(sockAddr.sin_addr));
	} else {
		printf("Huh, socket failure. Avoided crash this time.\n");
	}

	if (theApp.glob_prefs->AddServersFromClient()){
		in_addr addhost;
		addhost.s_addr = m_dwServerIP;
		CServer* addsrv = new CServer(m_nServerPort, inet_ntoa(addhost));
		addsrv->SetListName(addsrv->GetAddress());

		if (!theApp.xmuledlg->serverwnd->serverlistctrl->AddServer(addsrv, true))
			delete addsrv;
		/*else
			theApp.xmuledlg->AddLogLine(false,"Added new server: %s:%d", srv->GetFullIP(), srv->GetPort());*/
	}

	// get client credits
	// key, 255.255.0.0 subnetmask
	if(!HasLowID() && m_nUserID != m_dwUserIP)
		m_nUserID = m_dwUserIP;

	uchar key[16];
	memcpy(key,m_achUserHash,16);
	credits = theApp.clientcredits->GetCredit(key);
	if ( (m_Friend = theApp.friendlist->LinkFriend(key, m_dwUserIP, m_nUserPort) ) != NULL){
		m_Friend->m_LinkedClient = this;
		m_Friend->m_dwHasHash = 1;
		for( int i = 0; i < 16; i++ )
			m_Friend->m_abyUserhash[i] = GetUserHash()[i];
		m_Friend->m_strName.Format("%s", m_pszUsername);
		m_Friend->m_dwLastUsedIP = m_dwUserIP;
		m_Friend->m_nLastUsedPort = m_nUserPort;
		theApp.friendlist->RefreshFriend(m_Friend);
	}
	ReGetClientSoft();
	
#ifdef __DEBUG__
		if ( bDumpClientInfo )
		{
			printf("from client with:");
			if ( m_pszUsername )
				printf(" Username '%s'", m_pszUsername);
			printf(" Software: '%s'", m_clientVerString.c_str());
			printf("\n");
		}
#endif
	}
	catch (CInvalidPacket e)
	{
#ifdef __DEBUG__
		data->Seek(0);
		char *tmpbuffer = new char[data->GetLength()];
		if ( data->GetLength() == data->Read(tmpbuffer, data->GetLength()) )
			HexDump(tmpbuffer, data->GetLength());
		delete tmpbuffer;
#endif

		// Leave thing function, since there nothing more we
		// can do about this packet
		throw CString("Received invalid hello packet! - ") + e.what();
	}
	
	// Thief detection
	if(!thief)
	{
		// Stolen Hash detection [BlackRat]
		uint64 id = getUID();
		if(theApp.serverconnect->GetClientID()!= m_nUserID && memcmp(m_achUserHash, theApp.glob_prefs->GetUserHash(), 16)==0)
    	{
    		// This is a hasl stealer !
			thief=true;
			leechertype=5;		
			uint32 dummy;
			if(theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end())
				theApp.listensocket->offensecounter[id]++;
			else
				theApp.listensocket->offensecounter[id] = (uint32) 1;
		}

		// Detection id change [BlackRat]
		/*
			There is still something to do here
			Actually, due to problems with HashMap, everybody here is consider as id stealers...
		*/
		
		uint64 lasthash;
		uint64 thishash = 0;
		for(int i = 0; i < 8; i++ )
			thishash += GetUserHash()[i] << (i*8) ^ GetUserHash()[i+8] << (i*8);

		if((theApp.listensocket->hashbase.find(id) != theApp.listensocket->hashbase.end()) &&
		   ((lasthash = theApp.listensocket->hashbase[id]) != thishash))
		{   
			// id changed, this is a id stealer !
			leechertype=4;
			if(theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end())
				theApp.listensocket->offensecounter[id]++;
			else
				theApp.listensocket->offensecounter[id] = (uint32) 1;
			theApp.listensocket->offensecounter[0]++;
		}
		theApp.listensocket->hashbase[id] = thishash;  

		// Famous stolen hashs/names [BlackRat]	
		if(m_pszUsername && (
		   strcmp(m_pszUsername, "pbwll") == 0 ||
		   strcmp(m_pszUsername, "unix user") == 0 ||
		   strstr(m_pszUsername, "Odin") == m_pszUsername) && 
		   !thief) 
	    {  
			// This is a thief !!!
			thief=true;
		    leechertype=3;
		    if(theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end())
				theApp.listensocket->offensecounter[id]++;
			else
				theApp.listensocket->offensecounter[id] = 1;

			theApp.listensocket->offensecounter[0]++;
		}

		if((theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end()) &&
		   (theApp.listensocket->offensecounter[id] >= 3))
		{
			// Made suspicious actions....
			thief=true;
		} 
	} 
}

void CUpDownClient::SendHelloPacket(){
	if (socket){
	  struct sockaddr_in sockAddr;
		memset(&sockAddr, 0, sizeof(sockAddr));
		uint32 nSockAddrLen = sizeof(sockAddr);
		//socket->GetPeerName((SOCKADDR*)&sockAddr,(int*)&nSockAddrLen);
		wxIPV4address address;
		socket->GetPeer(address);
		sockAddr.sin_addr.s_addr=GAddress_INET_GetHostAddress(address.GetAddress());
		if ( theApp.ipfilter->IsFiltered(sockAddr.sin_addr.s_addr)) {
			theApp.xmuledlg->AddDebugLogLine(true,GetResString(IDS_IPFILTERED).GetData(),GetFullIP(),theApp.ipfilter->GetLastHit().GetData());
			Disconnected();
			theApp.stat_filteredclients++;
			return;
		}
	}
	CMemFile* data = new CMemFile();
	uint8 hashsize = 16;
	data->Write(&hashsize,1);
	SendHelloTypePacket(data);
	Packet* packet = new Packet(data);
	delete data;
	packet->opcode = OP_HELLO;
	if (socket) {
		theApp.uploadqueue->AddUpDataOverheadOther(packet->size);
		socket->SendPacket(packet,true);
	}
}

void CUpDownClient::SendMuleInfoPacket(bool bAnswer){
	CMemFile* data = new CMemFile();
	uint8 version = CURRENT_VERSION_SHORT;
	data->Write(&version,1);
	uint8 protversion = EMULE_PROTOCOL;
	data->Write(&protversion,1);
	uint32 tagcount = 7;
	data->Write(&tagcount,4);
	CTag tag(ET_COMPRESSION,1);
	tag.WriteTagToFile(data);
	CTag tag2(ET_UDPVER,2);
	tag2.WriteTagToFile(data);
	CTag tag3(ET_UDPPORT,theApp.glob_prefs->GetUDPPort());
	tag3.WriteTagToFile(data);
	CTag tag4(ET_SOURCEEXCHANGE,2);
	tag4.WriteTagToFile(data);
	CTag tag5(ET_COMMENTS,1);
	tag5.WriteTagToFile(data);
	CTag tag6(ET_EXTENDEDREQUEST,1);
	tag6.WriteTagToFile(data);
	CTag tag7(ET_COMPATABLECLIENT,2);
	tag7.WriteTagToFile(data);
	// Maella end
	Packet* packet = new Packet(data,OP_EMULEPROT);
	delete data;
	if (!bAnswer)
		packet->opcode = OP_EMULEINFO;
	else
		packet->opcode = OP_EMULEINFOANSWER;
	if (socket){
		theApp.uploadqueue->AddUpDataOverheadOther(packet->size);
		socket->SendPacket(packet,true,true);
	}
}

void CUpDownClient::ProcessMuleInfoPacket(char* pachPacket, uint32 nSize){
	try
	{
#ifdef __DEBUG__
		bool bDumpClientInfo = false;
#endif

	CSafeMemFile* data = new CSafeMemFile((BYTE*)pachPacket,nSize);
	m_byCompatableClient = 0;
		if ( 1 != data->Read(&m_byEmuleVersion,1) )
			throw CInvalidPacket("short packet reading emule version");
	if( m_byEmuleVersion == 0x2B )
		m_byEmuleVersion = 0x22;
	uint8 protversion;
		if ( 1 != data->Read(&protversion,1) )
			throw CInvalidPacket("short packet reading emule protocol version");

	//implicitly supported options by older clients
	if (protversion == EMULE_PROTOCOL) {
		//in the future do not use version to guess about new features

		if(m_byEmuleVersion < 0x25 && m_byEmuleVersion > 0x22)
			m_byUDPVer = 1;

		if(m_byEmuleVersion < 0x25 && m_byEmuleVersion > 0x21)
			m_bySourceExchangeVer = 1;

		if(m_byEmuleVersion == 0x24)
			m_byAcceptCommentVer = 1;

	} else {
		delete data;
		return;
	}
	m_bEmuleProtocol = true;

	uint32 tagcount;
		if ( 4 != data->Read(&tagcount,4) )
			throw CInvalidPacket("short packet reading tag count");

#ifdef __DEBUG__
		if (tagcount > 10)
			printf("Mule info packet with unusual tag count %lu\n", (unsigned long)tagcount);
#endif
		for (int i = 0;i < tagcount; i++){
		CTag* temptag = new CTag(data);
		switch(temptag->tag->specialtag){
			case ET_COMPRESSION:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for compression support flag");
				m_byDataCompVer = temptag->tag->intvalue;
				break;
			case ET_UDPPORT:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for UDP port");
				m_nUDPPort = temptag->tag->intvalue;
				break;
			case ET_UDPVER:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for UDP version");
				m_byUDPVer = temptag->tag->intvalue;
				break;
			case ET_SOURCEEXCHANGE:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for source exchange version");
				m_bySourceExchangeVer = temptag->tag->intvalue;
				break;
			case ET_COMMENTS:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for comments support flag");
				m_byAcceptCommentVer = temptag->tag->intvalue;
				break;
			case ET_EXTENDEDREQUEST:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for extended request version");
				m_byExtendedRequestsVer = temptag->tag->intvalue;
				break;
			case ET_COMPATABLECLIENT:
					if ( temptag->GetType() != TAG_INTEGER )
						throw CInvalidPacket("invalid data type for compatible client id");
				m_byCompatableClient = temptag->tag->intvalue;
				break;
			// Support for tag ET_MOD_VERSION
			case ET_MOD_VERSION:
			{
					if ( temptag->GetType() != TAG_STRING )
						throw CInvalidPacket("invalid data type for Mod-version");
				// Anti-leechermods [BlackRat]
				wxString oldmodversion;
				bool bOldMod = false;
				if(m_clientModString.Cmp("") != 0)
                {
                    bOldMod=true;
				    oldmodversion = m_clientModString;					
					m_clientModString = "";
				}
                m_clientModString = "";
				m_clientModString = temptag->tag->stringvalue;

				// mod version changed ??
                if (bOldMod && (oldmodversion != m_clientModString))
                {
					  // Thief !
					  uint64 id = getUID();
					  uint32 dummy;
					  leechertype = 2;
		              if(theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end())
						  theApp.listensocket->offensecounter[id]++;
		              else
			              theApp.listensocket->offensecounter[id] = (uint32) 1;

					  theApp.listensocket->offensecounter[0]++;		       
		 		}				
            } 
            break;

		 		case ET_FEATURES:
					if ( temptag->GetType() != TAG_INTEGER )
					{
#ifdef __DEBUG__
						printf("MuleInfo: invalid data type for feature flag\n");
						bDumpClientInfo = true;
#endif
						break;
		}  
#ifdef __DEBUG__
		 			if ( temptag->tag->intvalue & ~0x03 )
		 			{
		 				printf("MuleInfo: unknown features signaled with ET_FEATURES: %08x\n", temptag->tag->intvalue & ~0x03);
						bDumpClientInfo = true;
	}
#endif

		 			/*
		 			 * The known bits 0 and 1 are for
		 			 * SecIdent v1/v2.
		 			 */
		 			break;

#ifdef __DEBUG__
		 		case ET_TAROD:
		 		case ET_TAROD_VERSION:
		 		case ET_L2HAC:
		 		case ET_MOD_LSD:
				case ET_MOD_LSD_VERSION:
				case ET_MOD_SECURE_COMMUNITY:
				case ET_MOD_PROTOCOL:
				case ET_MOD_Morph:
				case ET_MOD_Morph_VERSION:
				case ET_MOD_FUSION:
				case ET_MOD_FUSION_VERSION:
				case ET_MOD_MorTillo:
				case ET_MOD_MorTillo_VERSION:
				case ET_MOD_LOVELACE_VERSION:
				case ET_MOD_OXY:
				case ET_PLUS:
				case ET_FEATURESET:
		 			/* We merily know about this tags */
		 			break;

		 		default:
					printf("Unknown tag %u in MuleInfo packet\n", (unsigned int)temptag->tag->specialtag);
					temptag->DumpToStdout();
					bDumpClientInfo = true;
            				break;
#endif
			}  
			delete temptag;
	}

	if( m_byDataCompVer == 0 ){
		m_bySourceExchangeVer = 0;
		m_byExtendedRequestsVer = 0;
		m_byAcceptCommentVer = 0;
		m_nUDPPort = 0;
	}
	delete data;
	ReGetClientSoft();
	
#ifdef __DEBUG__
		if ( bDumpClientInfo )
		{
			printf("from client with:");
			if ( m_pszUsername )
				printf(" Username '%s'", m_pszUsername);
			printf(" Software: '%s'", m_clientVerString.c_str());
			printf(" Mods: '%s'", m_clientModString.c_str());
			printf("\n");
		}
#endif
	}
	catch (CInvalidPacket e)
	{
		throw CString("Received invalid Mule info packet - ") + e.what();
	}
	
	// Filtering Invalid Emule Clients [BlackRat]
    if (((!GetMuleVersion() && (GetClientSoft()==SO_EMULE || GetClientSoft()==SO_OLDEMULE) && (GetVersion()==60 || !GetVersion()))
	   || (!ExtProtocolAvailable() && GetClientSoft()==SO_EMULE && (GetVersion()==60 || !GetVersion())))
	   && !thief)
	{
		// bad client : thief !
		thief = true;
		leechertype = 1;
		uint64 id = getUID();
		uint32 dummy;
		if(theApp.listensocket->offensecounter.find(id) != theApp.listensocket->offensecounter.end())
			theApp.listensocket->offensecounter[id]++;
		else
		    theApp.listensocket->offensecounter[id] = (uint32) 1;

		theApp.listensocket->offensecounter[0]++;
	}

}

void CUpDownClient::SendHelloAnswer(){
	CMemFile* data = new CMemFile();
	SendHelloTypePacket(data);
	Packet* packet = new Packet(data);
	delete data;
	packet->opcode = OP_HELLOANSWER;
	if (socket){
		theApp.uploadqueue->AddUpDataOverheadOther(packet->size);
		socket->SendPacket(packet,true);
	}
}

void CUpDownClient::SendHelloTypePacket(CMemFile* data){
	data->Write(theApp.glob_prefs->GetUserHash(),16);
	uint32 clientid = theApp.serverconnect->GetClientID();
	data->Write(&clientid,4);
	uint16 nPort = theApp.glob_prefs->GetPort();
	data->Write(&nPort,2);
	uint32 tagcount = 2;
	data->Write(&tagcount,4);
	CTag* tag = new CTag(CT_NAME,theApp.glob_prefs->GetUserNick());
	tag->WriteTagToFile(data);
	delete tag;
	tag = new CTag(CT_VERSION,EDONKEYVERSION);
	tag->WriteTagToFile(data);
	delete tag;
//	tag = new CTag(CT_PORT,theApp.glob_prefs->GetPort());
//	tag->WriteTagToFile(data);
//	delete tag;
	uint32 dwIP;
	if (theApp.serverconnect->IsConnected()){
		dwIP = theApp.serverconnect->GetCurrentServer()->GetIP();
		nPort = theApp.serverconnect->GetCurrentServer()->GetPort();
	}
	else{
		nPort = 0;
		dwIP = 0;
	}
	data->Write(&dwIP,4);
	data->Write(&nPort,2);
}


void CUpDownClient::ProcessMuleCommentPacket(char* pachPacket, uint32 nSize){
	try
	{
		CSafeMemFile data((BYTE*)pachPacket,nSize);
		int length;
		if ( sizeof(m_iRate) != data.Read(&m_iRate,sizeof(m_iRate)) )
			throw CInvalidPacket("short packet reading rating");
		if ( sizeof(length) != data.Read(&length,sizeof(length)) )
			throw CInvalidPacket("short packet reading comment length");
	
		reqfile->SetHasRating(true);
		theApp.xmuledlg->AddDebugLogLine(false,GetResString(IDS_RATINGRECV),m_pszClientFilename,m_iRate);
		if (length>50) length=50;
		if (length>0){
			char* desc=new char[length+1];
			memset(desc,0,length+1);
			if ( length != data.Read(desc,length) )
				throw CInvalidPacket("short packet reading comment string");
			theApp.xmuledlg->AddDebugLogLine(false,GetResString(IDS_DESCRIPTIONRECV), m_pszClientFilename, desc);
			m_strComment.Format("%s",desc);
			reqfile->SetHasComment(true);
			delete[] desc;
		}

	}
	catch ( CInvalidPacket e )
	{
		printf("Invalid MuleComment packet - %s\n", e.what());
		return;
	}
	if (reqfile->HasRating() || reqfile->HasComment()) theApp.xmuledlg->transferwnd->downloadlistctrl->UpdateItem(reqfile);
}
void CUpDownClient::Disconnected(){
  //assert(theApp.clientlist->Debug_IsValidClient(this));
	if (GetUploadState() == US_UPLOADING)
		theApp.uploadqueue->RemoveFromUploadQueue(this);
	if (GetDownloadState() == DS_DOWNLOADING){
		SetDownloadState(DS_ONQUEUE);
	}
	if ((GetDownloadState() == DS_REQHASHSET) && (reqfile))
        reqfile->hashsetneeded= true;
	//assert(theApp.clientlist->Debug_IsValidClient(this));
	//check if this client is needed in any way, if not delete it
	bool bDelete = true;
	switch(m_byUploadState){
		case US_ONUPLOADQUEUE:
			bDelete = false;
	};
	switch(m_nDownloadState){
		case DS_ONQUEUE:
		case DS_TOOMANYCONNS:
		case DS_NONEEDEDPARTS:
		case DS_LOWTOLOWIP:
			bDelete = false;
	};

	switch(m_byUploadState){
		case US_CONNECTING:
		case US_WAITCALLBACK:
		case US_ERROR:
			bDelete = true;
	};
	switch(m_nDownloadState){
		case DS_CONNECTING:
		{
			m_cFailed++;
			if (m_cFailed <= 2){
				TryToConnect();
				return;
			}
		}
		case DS_WAITCALLBACK:{
		case DS_ERROR:
			bDelete = true;
		}
	};
	

	if (GetChatState()){
		bDelete = false;
		//theApp.xmuledlg->chatwnd.chatselector.ConnectingResult(this,false);
#warning CHATSELECTOR MISSING
	}
	if (socket){
	  //ASSERT (theApp.listensocket->IsValidSocket(socket));
	  socket->Safe_Delete();
	  //delete socket;
	}
	socket = 0;
	if (m_iFileListRequested){
		theApp.xmuledlg->AddDebugLogLine(false,GetResString(IDS_SHAREDFILES_FAILED),GetUserName());
		m_iFileListRequested = 0;
	}
	if (m_Friend)
	  theApp.friendlist->RefreshFriend(m_Friend);
	if (bDelete){
		delete this;
	}

}

void CUpDownClient::TryToConnect(bool bIgnoreMaxCon){
	if (theApp.listensocket->TooManySockets() && !bIgnoreMaxCon && !(socket && socket->IsConnected())){
		Disconnected();
		return;
	}
	if ((theApp.serverconnect->GetClientID() < 16777216) && HasLowID()){
		if (GetDownloadState() == DS_CONNECTING)
			SetDownloadState(DS_LOWTOLOWIP);
		else if (GetDownloadState() == DS_REQHASHSET){
			SetDownloadState(DS_ONQUEUE);
			reqfile->hashsetneeded = true;
		}
		if (GetUploadState() == US_CONNECTING){
			Disconnected();
		}
	}

	if (!socket){
		socket = new CClientReqSocket(theApp.glob_prefs,this);
		if (!socket->Create()){
			socket->Safe_Delete();
			return;
		}
	}
	else if (!socket->IsConnected()){
		socket->Safe_Delete();
		socket = new CClientReqSocket(theApp.glob_prefs,this);
		if (!socket->Create()){
			socket->Safe_Delete();
			return;
		}
	}
	else{
		ConnectionEstablished();
		return;
	}
	if (HasLowID()){
		if (GetDownloadState() == DS_CONNECTING)
			SetDownloadState(DS_WAITCALLBACK);
		if (GetUploadState() == US_CONNECTING){
			Disconnected();
			return;
		}

		if (theApp.serverconnect->IsLocalServer(m_dwServerIP,m_nServerPort)){
			Packet* packet = new Packet(OP_CALLBACKREQUEST,4);
			memcpy(packet->pBuffer,&m_nUserID,4);
			theApp.uploadqueue->AddUpDataOverheadServer(packet->size);
			theApp.serverconnect->SendPacket(packet);
		}
		else{
			if (GetUploadState() == US_NONE && (!GetRemoteQueueRank() || m_bReaskPending) ){
				theApp.downloadqueue->RemoveSource(this);
				Disconnected();
				return;
			}
			else{
				if (GetDownloadState() == DS_WAITCALLBACK){
					m_bReaskPending = true;
					SetDownloadState(DS_ONQUEUE);
				}
			}
		}
	}
	// MOD Note - end
	else{
	  xmuleIPV4Address tmp;
	  tmp.Hostname(GetFullIP());
	  tmp.Service(GetUserPort());
	  socket->Connect(tmp,FALSE);
	  //socket->Connect(GetFullIP(),GetUserPort());
	  SendHelloPacket();
	}
}

void CUpDownClient::ConnectionEstablished(){
	m_cFailed = 0;
	// ok we have a connection, lets see if we want anything from this client
	if (GetChatState() == MS_CONNECTING) {
	  //theApp.xmuledlg->chatwnd.chatselector.ConnectingResult(this,true);
#warning CHATSELECTOR MISSING
	}

	switch(GetDownloadState()){
		case DS_CONNECTING:
		case DS_WAITCALLBACK:
			m_bReaskPending = false;
			SetDownloadState(DS_CONNECTED);
			SendFileRequest();
	}
	if (m_bReaskPending){
		m_bReaskPending = false;
		if (GetDownloadState() != DS_NONE && GetDownloadState() != DS_DOWNLOADING){
			SetDownloadState(DS_CONNECTED);
			SendFileRequest();
		}
	}
	switch(GetUploadState()){
		case US_CONNECTING:
		case US_WAITCALLBACK:
			if (theApp.uploadqueue->IsDownloading(this)){
				SetUploadState(US_UPLOADING);
				Packet* packet = new Packet(OP_ACCEPTUPLOADREQ,0);
				theApp.uploadqueue->AddUpDataOverheadFileRequest(packet->size);
				socket->SendPacket(packet,true);
			}
	}
	if (m_iFileListRequested==1){
		Packet* packet = new Packet((GetClientSoft()==SO_EDONKEYHYBRID) ? OP_ASKSHAREDDIRS : OP_ASKSHAREDFILES,0);
		theApp.uploadqueue->AddUpDataOverheadOther(packet->size);
		socket->SendPacket(packet,true,true);
	}
}

void CUpDownClient::ReGetClientSoft(){
	do
	{
	if (!m_pszUsername) {m_clientSoft=SO_UNKNOWN;break;}
	if( m_bIsHybrid ) {m_clientSoft=SO_EDONKEYHYBRID;break;}
	if( m_bIsNewMLD ) {m_clientSoft=SO_NEW_MLDONKEY;break;}
	if (m_achUserHash[5] == 13 && m_achUserHash[14] == 110) {m_clientSoft= SO_OLDEMULE;break;}
	if (m_achUserHash[5] == 14 && m_achUserHash[14] == 111){
		if( m_byCompatableClient == 1 ){
			m_clientSoft= SO_CDONKEY;
			break;
		}
		else if( m_byCompatableClient == 2 ){
			m_clientSoft= SO_xmule;
			break;
		}
		else{
			m_clientSoft= SO_EMULE;
			break;
		}
	}
	if (m_achUserHash[5] == 'M' && m_achUserHash[14] == 'L') {m_clientSoft= SO_MLDONKEY;break;}
	else
		m_clientSoft=SO_EDONKEY;
	}
	while (0);
	
	// Format name of client
	switch(GetClientSoft()){
		case SO_EDONKEY:
			m_clientVerString.Printf(_T("eDonkey v%u"), GetVersion());
			break;
		case SO_EDONKEYHYBRID:
			m_clientVerString.Printf(_T("eDonkey Hybrid v%u"), GetVersion());
			break;
		case SO_EMULE:
			m_clientVerString.Printf(_T("eMule v%02X"), GetMuleVersion());
			break;
		case SO_OLDEMULE:
			m_clientVerString.Printf(_T("old eMule v%02X"), GetMuleVersion());
			break;
		case SO_CDONKEY:
			m_clientVerString.Printf(_T("cDonkey v%02X"), GetMuleVersion());
			break;
		case SO_xmule:
			m_clientVerString.Printf(_T("xmule v%02X"), GetMuleVersion());
			break;			
		case SO_MLDONKEY:
			m_clientVerString = _T("Old MlDonkey");
			break;
		case SO_NEW_MLDONKEY:
			m_clientVerString = _T("New MlDonkey");
			break;
		default:
			m_clientVerString = GetResString(IDS_UNKNOWN);
    }
}


void CUpDownClient::SetUserName(char* pszNewName){
	if (m_pszUsername)
		delete[] m_pszUsername;
	if( pszNewName )
		m_pszUsername = nstrdup(pszNewName);
	else
		m_pszUsername = NULL;
}

void CUpDownClient::RequestSharedFileList(){
	theApp.xmuledlg->AddDebugLogLine(true,GetResString(IDS_SHAREDFILES_REQUEST),GetUserName());
	m_iFileListRequested = 1;
	TryToConnect(true);
}

void CUpDownClient::ProcessSharedFileList(char* pachPacket, uint32 nSize){
	if (m_iFileListRequested>0){
		m_iFileListRequested--;
		theApp.searchlist->ProcessSearchanswer(pachPacket,nSize,this);
	}
}

wxString CUpDownClient::GetUploadFileInfo()
{
  if(this == NULL) return "";
  wxString sRet;
 
  // build info text and display it
  sRet.Printf(GetResString(IDS_USERINFO), GetUserName(), GetUserID());
  if (reqfile)
    {
      sRet += GetResString(IDS_SF_REQUESTED) + wxString(reqfile->GetFileName()) + "\n";
      wxString stat;
      stat.Printf(GetResString(IDS_FILESTATS_SESSION)+GetResString(IDS_FILESTATS_TOTAL),
		  reqfile->statistic.GetAccepts(), reqfile->statistic.GetRequests(), CastItoXBytes(reqfile->statistic.GetTransfered()).GetData(),
		  reqfile->statistic.GetAllTimeAccepts(),
		  reqfile->statistic.GetAllTimeRequests(), CastItoXBytes(reqfile->statistic.GetAllTimeTransfered()).GetData() );
      sRet += stat;
    }
  else
    {
      sRet += GetResString(IDS_REQ_UNKNOWNFILE);
    }
  return sRet;
  
  return "";
}

void CUpDownClient::Destroy()
{
	socket->Destroy();

}
