// IconStatic.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "IconStatic.h"
#include "VisualStylesXP.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CIconStatic

CIconStatic::CIconStatic()
{
	m_strText = "";
}

CIconStatic::~CIconStatic()
{
}


BEGIN_MESSAGE_MAP(CIconStatic, CStatic)
	//{{AFX_MSG_MAP(CIconStatic)
		ON_WM_SYSCOLORCHANGE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CIconStatic 
bool CIconStatic::Init(UINT nIconID)
{
	m_nIconID = nIconID;

	CString strText;	
	GetWindowText(strText);
	SetWindowText("");
	if(strText != "")
		m_strText = strText;

	CRect rRect;
	GetClientRect(rRect);

	CDC *pDC = GetDC();
	CDC MemDC;
	CBitmap MemBMP, *pOldBMP;
	MemDC.CreateCompatibleDC(pDC);

	MemDC.SelectObject(GetFont());

	CRect rCaption(0,0,0,0);
	MemDC.DrawText(m_strText, rCaption, DT_CALCRECT);
	if(rCaption.Height() < 16)
		rCaption.bottom = rCaption.top + 16;
	rCaption.right += 25;
	if(rCaption.Width() > rRect.Width() - 16)
		rCaption.right = rCaption.left + rRect.Width() - 16;

	MemBMP.CreateCompatibleBitmap(pDC, rCaption.Width(), rCaption.Height());
	pOldBMP = MemDC.SelectObject(&MemBMP);

	MemDC.FillSolidRect(rCaption, GetSysColor(COLOR_BTNFACE));
	DrawState(MemDC.m_hDC, NULL, NULL, 
				(long)::LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(m_nIconID), IMAGE_ICON, 16,16, 0), 
					NULL, 3, 0, 16, 16, DST_ICON | DSS_NORMAL);
	
	rCaption.left += 22;
	
	if(g_xpStyle.IsAppThemed())
    {
		HTHEME hTheme = g_xpStyle.OpenThemeData(NULL, L"BUTTON"); 
		USES_CONVERSION;
		g_xpStyle.DrawThemeText(hTheme, MemDC.m_hDC, 4, 1, T2OLE(m_strText), m_strText.GetLength(), 
									DT_WORDBREAK | DT_CENTER | DT_WORD_ELLIPSIS, NULL, &rCaption);
		g_xpStyle.CloseThemeData(hTheme);
	}
	else
	{	
		MemDC.SetTextColor(pDC->GetTextColor());
		MemDC.DrawText(m_strText, rCaption, DT_SINGLELINE | DT_LEFT | DT_END_ELLIPSIS);
	}

	MemDC.SelectObject(pOldBMP);
	
	if(m_wndPicture.m_hWnd == NULL)
		m_wndPicture.Create(NULL, WS_CHILD | WS_VISIBLE | SS_BITMAP, CRect(0,0,0,0), this);
	
	m_wndPicture.GetBitmap();
	m_wndPicture.SetWindowPos(NULL, rRect.left+8, rRect.top, rCaption.Width()+22, rCaption.Height(), SWP_SHOWWINDOW);
	m_wndPicture.SetBitmap(MemBMP);
		
	MemBMP.Detach();


	CWnd *pParent = GetParent();
	if(pParent == NULL)
		pParent = GetDesktopWindow();
	
	CRect r;
	GetWindowRect(r);
	r.bottom = r.top + 20;
	GetParent()->ScreenToClient(&r);
	GetParent()->RedrawWindow(r);

	return true;
}

bool CIconStatic::SetText(CString strText)
{
	m_strText = strText;
	return Init(m_nIconID);
}

bool CIconStatic::SetIcon(UINT nIconID)
{
	return Init(nIconID);
}

void CIconStatic::OnSysColorChange() {
	Init(m_nIconID);
}
